## Leçon 3. Citations. Questions. Interjections

### « **sei** » : commentaires sur le texte

La particule **sei** permet d'insérer un commentaire sur notre attitude à l'égard de ce qui est dit dans une relation :

> **do jinga sei mi gleki**
> _Tu as gagné ! (Je suis heureux à ce sujet !)_

Cependant :

> **do jinga sei la .ian. cu gleki**
> _Tu as gagné ! (Et Yan est heureux à ce sujet !)_

Comme pour les arguments formés avec **le**, la relation formée avec **sei** doit se terminer par un verbe.

> **la .alis. cu prami sei la .bob. cu gleki la .kevin.**

Ajoutons des parenthèses pour le rendre plus facilement lisible.

> **la .alis. cu prami (sei la .bob. cu gleki) la .kevin.**
> _Alice aime (Bob est heureux) Kevin._
> _Alice aime Kevin (Bob est heureux)._

Nous pouvons ajouter plus de arguments au mots de relation avec **be** et **bei** comme nous le faisons pour les termes-arguments :

> **do jinga sei mi zausku be fo la fircku**
> _Tu as gagné ! (Je vais poster des félicitations sur Facebook)_

la fircku
: Facebook

zausku
: $x_1$ fait l'éloge de $x_2$ pour le public $x_3$ via les moyens $x_4$

### Guillemets

Pour citer du texte, nous plaçons la particule de citation **lu** avant la citation et plaçons **li'u** après. Le résultat est un argument représentant le texte cité :

> **mi cusku lu mi prami do li'u**
> _Je dis "Je t'aime"._

cusku
: $x_1$ exprime/dit $x_2$ (citation) à l'audience $x_3$

Une caractéristique intéressante du lojban est que les marques de citation **lu** - « citation » et **li'u** - « non-citation » sont prononçables. C'est assez pratique car, en lojban parlé, vous n'avez pas besoin de changer l'intonation pour montrer où commence et se termine un texte cité.

Cependant, dans un texte écrit qui cite une conversation, l'auteur attire souvent l'attention du lecteur sur le contenu des citations. Dans de tels cas, **sei** est préféré.

Nous pouvons également imbriquer des citations, par exemple :

> **la .ian. pu cusku lu la .djein. pu cusku lu coi li'u mi li'u**
> _Yan a dit : "Jane a dit 'Bonjour' à moi"._

ce qui est similaire à

> **la .ian. pu cusku lu la .djein. pu rinsa mi li'u**
> _Yan a dit : "Jane m'a salué"._

rinsa
: $x_1$ salue quelqu'un $x_2$

<pixra url="/assets/pixra/cilre/rinsa2.webp" caption="le prenu cu rinsa mi" definition="La personne me salue."></pixra>

Notez qu'en lojban, nous distinguons les choses et leurs noms :

> **lu le munje li'u cu cmalu**
> _"L'univers" est petit._

<!-- -->

> **le munje na ku cmalu**
> _L'univers n'est pas petit._

le munje
: l'univers, le monde

Ici, le texte _"l'univers"_ est petit, alors que l'univers ne l'est pas.

---

Les interjections et les vocatifs fonctionnent comme des constructions **sei** :

> **je'u mi jinga sei ra cusku**
> _Vraiment, "J'ai gagné", dit-il._

je'u
: interjection : vraiment

Comme vous pouvez le voir, **je'u** ne fait pas partie de ses mots. Il représente votre attitude envers la relation. Si vous voulez citer "**je'u mi jinga**", utilisez des guillemets comme ceci :

> **lu je'u mi jinga li'u se cusku ra**
> _"Vraiment, j'ai gagné", dit-il._

Remarquez la différence entre les deux exemples ?

Voici plusieurs mots de relation courants liés à la parole :

> **ra pu retsku lu do klama ma li'u**
> _Elle a demandé : "Où vas-tu ?"_

<!-- -->

> **mi pu spusku lu mi klama le zdani li'u**
> _J'ai répondu : "Je rentre chez moi."_

<!-- -->

> **mi pu spuda le se retsku be ra le ka spusku lu mi klama le zdani li'u**
> _J'ai répondu à sa question en disant : "Je rentre chez moi."_

spuda
: $x_1$ répond à $x_2$ en faisant $x_3$ (propriété de $x_1$)

Les trois mots de relation restants ont une structure de place identique :

cusku
: $x_1$ exprime/dit $x_2$ (citation) à l'audience $x_3$

retsku
: $x_1$ demande $x_2$ (citation) à l'audience $x_3$

spusku
: $x_1$ répond/dit la réponse $x_2$ (citation) à l'audience $x_3$

### « **zo** » — citer un mot

**zo** est un marqueur de citation, similaire à **lu**. Cependant, **zo** ne cite qu'un seul mot immédiatement après lui. Cela signifie qu'il ne nécessite pas de mot de fin de citation comme **li'u**; nous savons déjà où se termine la citation. En faisant cela, nous économisons deux syllabes et rendons notre discours plus concis.

> **zo .robin. cmene mi**
> _"Robin" est mon nom._
> _Mon nom est Robin._

cmene
: $x_1$ (citation) est un nom de $x_2$ …

Pour vous présenter en lojban en utilisant votre nom lojbanisé, suivez l'exemple ci-dessus. Si votre nom se compose de plus d'un mot, utilisez **lu … li'u**:

> **lu .robin.djonsyn. li'u cmene mi**
> _Robin Johnson est mon nom._

Une autre approche consiste à utiliser **me**:

> **mi me la .robin.djonsyn.**
> _Je suis Robin Johnson._

Remarquez la différence: _"Robin"_ entre guillemets est un nom cité, tandis que Robin est une personne.

Pour mieux le montrer, voici une variation stupide:
> **zo .robin. cmene la .robin.**
> _"Robin" est le nom de Robin._
> _"Robin" est un nom de Robin._

Le premier endroit de **cmene** est une citation, un texte. Par conséquent, nous utilisons **lu … li'u** ou **zo** pour créer une citation et remplir le premier endroit de **cmene** avec celui-ci, au lieu de **la** (préfixe pour les noms).

### Verbes de parole

Voici quelques relations décrivant la parole :

> **mi pu skicu le purdi le pendo be mi lo ka bredi**
> _J'ai dit à mon ami que mon jardin était prêt._

skicu
: $x_1$ raconte à $x_3$ à propos de $x_2$ (objet/évènement/état) avec la description $x_4$ (propriété)

bredi
: … être prêt à …

> **mi pu cusku lu le purdi cu bredi li'u le pendo be mi lo ka cladu bacru**
> _J'ai dit à mon ami, "Le jardin est prêt", en le prononçant fort._

cusku
: $x_1$ dit $x_2$ (texte) à l'audience $x_3$ via le médium $x_4$

cladu
: … être fort

> **mi pu tavla le pendo be mi le nu le purdi cu bredi kei le lojbo**
> _J'ai parlé à mon ami en lojban du fait que le jardin était prêt._

tavla
: $x_1$ parle à $x_2$ de sujet $x_3$ dans la langue $x_4$

En bref:

* **skicu** signifie _raconter_, _décrire avec une certaine description_,
* **cusku** signifie _dire un texte_,
* **tavla** signifie _parler dans une langue_.

### Questions de contenu

L'anglais a plusieurs mots interrogatifs _wh-_ — _who_, _what_ etc. En Lojban, pour les deux, nous utilisons un seul mot : **ma**. Ce mot est un argument (comme **mi**, **le prenu** etc.) et c'est comme une suggestion pour combler la place manquante. Par exemple:

> **— do klama ma**
> **— la .london.**
> _— Où vas-tu ?_
> _— Londres._

<!-- -->

> **— ma klama la .london.**
> **— la .kevin.**
> _— Qui va à Londres ?_
> _— Kevin._

<!-- -->

> **— mi plicru do ma**
> **— le plise**
> <span>_— Je te donne quoi ?_ (probablement signifiant _Qu'est-ce que je devais te donner ?_)</span>
> _— La pomme._

Pour traduire _which/what_, nous utilisons également **ma** :

> **— ma gugde gi'e se xabju do**
> **— le gugde'usu**
> _— Dans quel pays habites-tu ?_
> _— USA_
> `— Qu'est-ce qu'un pays et est habité par toi`
> `— USA`

xabju
: … (quelqu'un) habiter … (un endroit)

se xabju
: … (un endroit) être habité par … (quelqu'un)

**mo** est similaire à **ma**, mais c'est un mot de relation.

**mo** suggère de remplir une relation au lieu d'un argument. C'est comme demander _Que fait X ?_ ou _Qu'est-ce que X ?_ en anglais (le Lojban ne vous oblige pas à faire la distinction entre être et faire).

Nous pouvons voir **mo** comme demander à quelqu'un de décrire la relation entre les arguments dans la question.

> **— do mo**
> _— Comment vas-tu ? Quoi de neuf ?_
> `— Tu es quoi, tu fais quoi ?`

C'est la façon la plus courante de demander _Comment vas-tu ?_ ou _Salut ?_ en lojban. Quelques réponses possibles :

> **— mi gleki**
> _— Je suis heureux._

gleki
: $x_1$ est heureux

> **— mi kanro**
> _— Je suis en bonne santé._

<!-- -->

> **mi tatpi**
> _Je suis fatigué._

<!-- -->

> **mi gunka**
> _Je travaille._

Une autre façon de demander _Comment vas-tu ?_ :

> **— do cinmo le ka mo**
> _— Comment te sens-tu (émotionnellement) ?_

cinmo
: $x_1$ ressent $x_2$ (propriété de $x_1$)

Autres exemples :

> **ti mo**
> _Qu'est-ce que c'est ?_

<!-- -->

> **la .meilis. cu mo**
> _Qui est Mei Li ? / Qu'est-ce que Mei Li ? / Que fait Mei Li ?_

Réponses possibles en fonction du contexte :

- **ninmu** : _Elle est une femme._
- **jungo** : _Elle est chinoise._
- **pulji** : _Elle est policière._
- **sanga** : _Elle est chanteuse_ ou _Elle chante._

> **do mo la .kevin.**
> _Qu'es-tu pour Kevin ?_
> `Tu es quoi (tu fais quoi) pour Kevin.`

La réponse dépend du contexte. Les réponses possibles à cette question sont :

- **nelci** : _Je l'aime._
- **pendo** : _Je suis son ami(e)._
- **prami** : _Je l'adore/suis amoureux(se) d'elle/lui._
- **xebni** : _Je la déteste._
- **fengu** : _Je suis en colère contre elle/lui._
- **cinba** : _Je l'ai embrassé(e)._

Notez une fois de plus que le temps n'est pas important ici : tout comme **cinba** peut signifier _embrasser_, _embrassé_, _embrassera_ et ainsi de suite, **mo** ne pose pas de question sur un moment particulier.

Si nous voulons faire la différence entre _faire_ et _être quelqu'un ou quelque chose_, nous utilisons des relations supplémentaires :

> **la meilis cu zukte ma**
> `Que fait Mei Li ?`

> **le ka lumci**
> _fait le ménage._

<!-- -->

> **la meilis cu zukte le ka lumci**
> _Mei Li fait le ménage._

zukte
: $x_1$ fait $x_2$ (propriété de $x_1$)

lumci
: ... nettoie ou lave ... (quelque chose)

<pixra url="/assets/pixra/cilre/lumci.webp" caption="ra lumci le zdani" definition="Elle nettoie la maison."></pixra>

> **do du ma**
> `Qui es-tu ?`

> **mi du le ctuca**
> _Je suis l'enseignant(e)._

Voici le texte traduit :

L'utilisation de termes modaux avec **ma** peut nous donner d'autres questions utiles :

<table>
<tbody><tr>
<th>mot
</th>
<th>signification
</th>
<th><code>[littéralement]</code>
</th></tr>
<tr>
<td><b>ca ma</b>
</td>
<td>Quand ?
</td>
<td>pendant quoi
</td></tr>
<tr>
<td><b>bu'u ma</b>
</td>
<td>Où ?
</td>
<td>à quoi
</td></tr>
<tr>
<td><b>ma prenu gi'e …</b>
</td>
<td>Qui ?
</td>
<td>qui est une personne et …
</td></tr>
<tr>
<td><b>ma dacti gi'e</b>
</td>
<td>Quoi ? (à propos d'objets)
</td>
<td>qu'est-ce qu'un objet et …
</td></tr>
<tr>
<td><b>ri'a ma</b>
</td>
<td>Pourquoi ?
</td>
<td>à cause de quoi
</td></tr>
<tr>
<td><b>pe ma</b>
</td>
<td>À qui ? Lequel ? À propos de quoi ?
</td>
<td>concernant quoi ou qui
</td></tr>
<tr>
<td><b>le mlatu poi mo</b>
</td>
<td>Quel chat ? Quel genre de chat ?
</td>
<td>
</td></tr></tbody></table>

**pe ma** est attaché uniquement aux arguments :

> **le penbi pe ma cu zvati le jubme**
> _À qui appartient le stylo sur la table ?_

### Questions de nombre

> **le xo prenu cu klama ti**
> _Combien de personnes viennent ici ?_

<!-- -->

> **mu**
> _Cinq._

Le mot **xo** signifie _Combien ?_ et demande donc un nombre. La réponse complète sera:

> **le mu prenu cu klama ti**
> _Les 5 personnes viennent à cet endroit._

La personne interrogée est censée mettre une valeur appropriée à la place de **xo**.

Voici quelques exemples supplémentaires:

> **le xo botpi cu kunti**
> _Combien de bouteilles sont vides ?_

<!-- -->

> **do ralte le xo gerku**
> _Combien de chiens possédez-vous ?_

### Verbes de faits

Considérez l'exemple:

> **mi djuno le du'u do stati**
> _Je sais que vous êtes intelligent._

djuno
: $x_1$ sait $x_2$ (proposition) à propos de $x_3$

> **mi jimpe le du'u do pu citka**
> _Je comprends que vous mangiez._

jimpe
: $x_1$ comprend $x_2$ (proposition) à propos de $x_3$

<pixra url="/assets/pixra/cilre/na_jimpe.webp" caption="mi na jimpe" definition="Je ne comprends pas."></pixra>

Dans les endroits qui décrivent des faits, la particule **du'u** est utilisée (au lieu de **nu**).

**djuno** (_savoir_) et **jimpe** (_comprendre_) décrivent des faits. Il serait illogique de dire, _Je comprends que vous mangiez, mais en fait, vous ne mangiez pas._

Notez que la relation commencée avec **du'u** n'a pas besoin d'être vraie:

> **le du'u do mlatu cu jitfa**
> _Le fait que vous êtes un chat est faux._

jitfa
: $x_1$ (proposition) est faux

Quand devez-vous utiliser **du'u** et quand devez-vous utiliser **nu** ? Vous pouvez consulter le dictionnaire:

- L'étiquette _(du'u)_ ou _(proposition)_ marque les endroits où **du'u** est recommandé.
- L'étiquette _(nu)_ ou _(évènement)_ marque les endroits où **nu** est recommandé.

Si vous utilisez par erreur **nu** au lieu de **du'u**, vous serez quand même compris. Cependant, les locuteurs courants de lojban distinguent généralement ces particules.

### Questions indirectes

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Je sais qui étudie le lojban._

Ceci est appelé une question indirecte. Le mot _qui_ ici n'est pas une demande d'information, et il n'y a pas de point d'interrogation. La réponse est présumée, et en fait, vous connaissez vous-même la réponse à la question _Qui apprend le lojban ?_

**kau** est une interjection que nous mettons après un mot interrogatif pour indiquer qu'il s'agit d'une question indirecte.

Si je vous pose la question **ma tadni la .lojban.**, vous savez quelle valeur remplir dans l'emplacement **ma**: **la .kevin.** Donc vous pourriez simplement dire

> **ma tadni la .lojban.**
> _Qui étudie le lojban ?_

<!-- -->

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Je sais qui étudie le lojban. Je connais l'identité de la personne qui étudie le lojban._

<!-- -->

> **mi djica le nu ma tadni la .lojban.**
> _Qui est-ce que je veux étudier le lojban ?_
> `Je veux qui étudier le lojban ?`

Cela ne peut jamais être une question indirecte: on demande une réponse (même si vous le faites de manière rhétorique).

Vous pouvez le mettre après d'autres mots interrogatifs:

> **mi djuno le du'u le xo kau prenu cu tadni la .lojban.**
> _Je sais combien de personnes étudient le lojban._

### Citations indirectes (discours rapporté) : « J'ai dit que je viendrais. »

Une relation comme _Alice a dit, "Michelle m'a dit 'Bonjour'"_ peut également être exprimée de manière plus subtile :

> **la .alis. pu cusku zo'e pe le nu la .micel. pu rinsa la .alis.**
> _Alice a dit quelque chose à propos de Michelle qui la saluait avant._
> `Alice a dit quelque chose à propos de l'évènement où Michelle la saluait.`

Alternativement, vous pouvez le raccourcir :

> **la .alis. pu cusku le se du'u la .micel. pu rinsa la .alis.**
> _Alice a dit que Michelle l'avait saluée._

La combinaison **se du'u** permet l'expression du discours indirect.

Voici quelques exemples de relations liés à la parole lors de l'utilisation du discours rapporté :

> **le ninmu pu retsku le se du'u mi klama ma kau**
> _Elle a demandé où j'allais._

<!-- -->

> **mi pu spusku le se du'u mi klama le zdani**
> _J'ai répondu que je rentrais chez moi._

<!-- -->

> **mi pu spuda le se retsku be le ninmu le ka spusku le se du'u mi klama le zdani**
> _J'ai répondu à sa question en disant en réponse que je rentrais chez moi._

Questions dans le discours rapporté :

> **mi pu cusku le se du'u ma tadni la .lojban.**
> _Qui ai-je dit étudier le lojban ?_
> `J'ai dit qui étudie le lojban ?`

Ainsi, le lojban a plusieurs mots pour _que…_, selon ce qui est voulu.

- Si _que_ décrit ce qui peut être vu, entendu ou ce qui se passe, utilisez **nu**.
- Si _que_ décrit ce que vous pensez, un fait ou une information, utilisez **du'u**.
- Si _que_ décrit ce que vous dites, utilisez **se du'u**.
  - Mais si vous avez besoin d'une citation littérale, utilisez **lu…li'u**.

### Interjections émotionnelles : ‘_Yay!_’ = « **ui** », ‘_Aye!_’ = « **ie** », ‘_Phew!_’ = « **.o'u** »

Nous connaissons de telles interjections comme **ui** (_Yay!_), **.a'o** (_J'espère_).

> **do jinga ui**
> _Tu as gagné ! (Je suis heureux de ça !)_

ui
: interjection : _Yay!_, interjection de bonheur

<pixra url="/assets/pixra/cilre/ui_jinga.webp" caption="ui mi jinga" definition="Yay! J'ai gagné !"></pixra>

Les interjections fonctionnent comme **sei** avec leurs relations. **ui** signifie la même chose que **sei mi gleki** donc nous pourrions tout aussi bien dire **do jinga sei mi gleki** signifiant la même chose (bien que ce soit un peu plus long).

Il y a des interjections exprimant d'autres états émotionnels. Ils sont similaires aux smileys comme ;-) ou :-( mais en lojban, nous pouvons être plus précis sur nos émotions tout en restant concis dans notre discours.

> **ie tu mlatu**
> _Oui, c'est un chat._

<!-- -->

> **ie nai .i tu na ku mlatu**
> _Non, je ne suis pas d'accord. Ce n'est pas un chat._

ie
: interjection : _Ouais ! Aye !_ (accord)

ie nai
: interjection : désaccord

> **.ai mi vitke do**
> _Je vais te rendre visite._

.ai
: interjection : _Je vais …_ (intention)

> **.au do kanro**
> _Je souhaite que tu sois en bonne santé._

.au
: interjection de désir

<pixra url="/assets/pixra/cilre/clira.webp" caption="mi clira klama" definition="Je suis arrivé tôt."></pixra>

> **.a'o do clira klama**
> _J'espère que tu viendras tôt._

.a'o
: interjection : J'espère

clira
: $x_1$ arrive tôt

<pixra url="/assets/pixra/cilre/ciska.webp" caption=".ei mi ciska le xatra ti voi pelji ku'o le penbi" definition="Je devrais écrire la lettre sur ce papier en utilisant le stylo."></pixra>

> **.ei mi ciska le xatra le pelji le penbi**
> _Je devrais écrire la lettre sur le papier en utilisant le stylo._

.ei
: Je devrais … (obligation)

ciska
: $x_1$ écrit $x_2$ sur le support $x_4$

> **.i'e do pu gunka le vajni**
> _Très bien ! Tu as fait un travail important._

.i'e
: interjection : _Bien !_ (approbation)

> **.o'u tu mlatu**
> _Oh, ce n'est qu'un chat._

.o'u
: interjection : _Phew!_ (relaxation)

Dans ce cas, vous avez probablement pensé que c'était quelque chose de dangereux, mais ce n'est qu'un chat, donc vous dites **.o'u**.

> **.u'i ti zmitci**
> _Ha-ha, c'est un robot._

.u'i
: interjection : _Ha-ha !_ (amusement)

zmitci
: … être un outil automatique

Vous pouvez ajouter ou supprimer des interjections à ou d'une phrase sans risque de la casser.

Tout mot qui commence par une voyelle pure (à l'exclusion de **u** et **i** avant les voyelles) est préfixé d'un point en lojban à l'écrit et avec une pause à l'oral. Ainsi, l'orthographe correcte est **.a'o** et ainsi de suite. Il est courant d'omettre les points à l'écriture. Cependant, en parlant, vous devriez toujours montrer ce point en faisant une courte pause avant de dire un tel mot pour éviter de fusionner deux mots voisins en un seul.

Comme avec les relations **xu** ou **sei**, nous pouvons ajouter des interjections après n'importe quel argument ou mot de relation, exprimant ainsi notre attitude envers cette partie de la phrase.

### Interjections d'incitation

Un groupe spécial d'interjections "impératives/hortatives" est utilisé pour les incitations, les commandes et les demandes. Nous avons déjà rencontré **.e'o** :

> **.e'o mi ciksi da poi mi cusku djica**
> _S'il vous plait, laissez-moi expliquer ce que je veux dire._

.e'o
: interjection : _S'il vous plait …_ (demande)

> **— au mi klama le nenri**
> **— .e'a**
> _— Je voudrais entrer._
> _— S'il vous plait._

.e'a
: interjection : _Je permets, vous pouvez …_ (permission)

le nenri
: l'intérieur, ce qui est à l'intérieur

> **.e'ei do zukte**
> _Allez, fais-le !_

.e'ei
: interjection : _Allez !_ (encouragement, provocation). Mot non officiel

> **.e'i do zutse doi le verba**
> _Assieds-toi, enfant !_

.e'i
: interjection : _Fais ça !_ (commande)

> **.e'u do pinxe le jisra**
> _Je suggère que vous buviez le jus. Vous feriez mieux de boire le jus._

.e'u
: interjection : _Allons …_ (suggestion)

### « **ko** » pour des incitations plus rapides

> **do bajra**
> _Tu cours._

<!-- -->

> **bajra**
> _Quelqu'un court._

En anglais, le verbe lui-même est une commande :

> _Cours !_

En lojban, **bajra** en tant que phrase signifie _Quelqu'un court_ (ou _est en train de courir_ / _courait_, selon le contexte). **bajra** peut également signifier une commande, _Cours !_, mais parfois le contexte n'est pas suffisant pour déterminer s'il s'agit d'une incitation à courir ou simplement d'une déclaration que quelqu'un court ou est en train de courir.

Le pronom **ko** est utilisé à la place de **do** pour faire des demandes, des suggestions ou des commandes :

> **ko bajra**
> _Cours ! Fais-le pour que tu cours !_

**ko** est une alternative plus vague à **do .e'o**, **do .e'u**, **do .e'i**.

Il est tout à fait possible de dire quelque chose de plus précis, comme :

> **do .e'o bajra**
> _Toi, s'il te plait, cours !_

en mettant l'accent sur notre politesse sur **do** (_toi_).

En déplaçant **ko** dans une relation, la commande/demande est déplacée vers cette partie. Par exemple :

> **nelci ko**
> _Fais en sorte que tu sois aimé par quelqu'un !_

nelci
: … aimer, apprécier … (quelque chose ou quelqu'un)

Comme vous pouvez le voir, nous devons restructurer cette relation en anglais, ce qui sonne toujours étrange. Cependant, vous pourriez l'utiliser en lojban dans le sens de _Essayer de faire bonne impression._

Notez que **prami** correspond à l'anglais _aimer_, tandis que **nelci** correspond à l'anglais _apprécier_.

Nous pouvons même avoir plusieurs **ko** dans une phrase :

> **ko kurji ko**
> _Prends soin de toi._

kurji
: … prendre soin de … (quelqu'un ou quelque chose)

### Interjections discursives

> **au mi citka le salta .e ji'a le grute**
> _Je voudrais manger la salade et les fruits aussi._

ji'a
: _en outre, aussi_, signifie qu'il existe d'autres personnes qui sont également les mêmes (_vous_ dans ce cas) ou qui font la même chose

salta
: … être une salade

grute
: … être un fruit

> **mi si'a nelci do**
> `Moi aussi, je t'aime`

<!-- -->
> **— mi nelci le'e mlatu**
> **— mi si'a nelci le'e mlatu**
> _— J'aime les chats._
> _— Moi aussi, j'aime les chats._

si'a
: _de même, aussi_, indique que quelque chose est similaire tout en étant différent dans d'autres aspects non mentionnés

### Structure des interjections : « **nai** », « **sai** », « **pei** », « **dai** »

Les interjections peuvent consister en :

1. la racine, comme **ui** (_Youpi !_)
2. après elle, des suffixes comme **pei**, **dai**, **zo'o** :

    > **ui zo'o**
    > _Youpi ! (je plaisante, je ne suis pas vraiment heureux)_

3. la racine et chacun des suffixes peuvent être modifiés avec des particules scalaires comme **nai** :

    > **ui nai**
    > _Hélas !_

    <!-- -->
    > **ui nai zo'o**
    > _Hélas ! (je plaisante, je ne suis pas sérieux dans ce sentiment)_

    <!-- -->
    > **ui nai zo'o nai**
    > _Hélas, je ne plaisante pas, je me sens malheureux_

Quelques exemples de la façon dont les particules scalaires fonctionnent.

- **ju'o** = _interjection : je suis sûr (certitude)_
- **ju'o cu'i** = _interjection : peut-être, peut-être pas (incertitude)_
- **ju'o nai** = _interjection : je n'en ai aucune idée !_

Exemples courants d'interjections :

- une interjection composée d'une racine nue :

 > **ju'o le bruna co'i klama**
 > _Je suis sûr que le frère est venu._

- la particule scalaire **cu'i** transforme une interjection de racine nue en son attitude moyenne :

 > **ju'o cu'i le bruna co'i klama**
 > _Peut-être que le frère est venu, je n'en suis pas sûr._

- la particule scalaire **nai** transforme l'interjection en attitude opposée :

 > **ju'o nai le bruna co'i klama**
 > _Peut-être que le frère est venu, peut-être pas, je n'en ai aucune idée_

 De même, **ui** signifie _Youpi !_, tandis que **ui nai** signifie _Hélas !_

 Les significations précises des interjections qui ont un sens avec leurs particules scalaires **cu'i** et **nai** sont données dans le dictionnaire.

- la particule scalaire **sai** indique une forte intensité de l'interjection :

 > **.u'i sai**
 > _Ha-ha-ha !_

Les vocatifs peuvent également être modifiés avec des particules scalaires :

> **ki'e sai do**
> _Merci beaucoup !_

Les suffixes sont ajoutés après la racine de l'interjection (avec ses particules scalaires si nous les avons utilisées) :

- le suffixe d'interjection **pei** transforme l'interjection en question.

 > **— .au pei do .e mi klama le zarci**
 > **— .au cu'i**
 > _— Veux-tu que toi et moi allions au magasin ?_
 > _— Meh, je n'ai pas de préférences._

 <!-- -->

 > **— ie pei tu melbi**
 > **— ie**
 > _— Celui-là est joli, n'est-ce pas ?_
 > _— Oui._

- le suffixe d'interjection **dai** montre les sentiments des autres, pas les sentiments de l'orateur :

 > **ui nai dai do na ku co'i jinga**
 > _Tu dois être triste, tu n'as pas gagné._

 <!-- -->

 > **.a'u**
 > _C'est intéressant !_

 <!-- -->

 > **.a'u dai**
 > _Ça a dû être intéressant pour toi !_

- Les interjections nues expriment l'attitude de l'orateur. **ei do cliva** ne signifie pas _Tu devrais partir_, mais _Je ressens l'obligation pour toi de partir_. **dai** montre que l'orateur compatit aux sentiments de quelqu'un d'autre.

 > **.ei dai do cliva**
 > _Tu ressens l'obligation pour toi-même de partir._

Notez que les interjections ne montrent pas nécessairement l'attitude envers les orateurs eux-mêmes. Au lieu de cela, elles expriment l'attitude des orateurs envers d'autres choses.

- le suffixe d'interjection **zo'o** marque l'attitude comme exprimée sans sérieux :

 > **.e'u zo'o do pinxe ti**
 > _Je suggère que vous le buviez (je plaisante)._

- Les suffixes peuvent également être modifiés avec des particules scalaires :

 > **ie zo'o nai**
 > _Je suis d'accord (je ne plaisante pas)._

- **zo'o nai** est utilisé pour montrer que l'information n'est pas une blague :

 >**zo'o nai ra pu klama la .paris.**
 >_— Je suis sérieux, il est allé à Paris._

- Les suffixes peuvent être utilisés seuls :

  - **pei** lorsqu'il est utilisé seul demande toute interjection que l'auditeur jugerait appropriée :

 >**— pei le lunra cu crino**
 >**— .ie nai**
 >_— La lune est verte (quel est votre sentiment à ce sujet ?)_
 >_— Je ne suis pas d'accord._

- Pour les autres suffixes, cela signifie que l'interjection racine **ju'a** (_Je déclare_) a été omise :

 > **zo'o do kusru**
 > **ju'a zo'o do kusru**
 > _Tu es cruel (je plaisante)._

 ju'a
 : interjection : Je déclare (ne la confondez pas avec **ju'o** (Je suis sûr))

### Juste pour référence : interjections dans les tableaux

Voici une vue plus complète : interjections émotionnelles, incitatives et diverses par série.

<table>
<tbody><tr>
<td><b>.au</b><br/><i>Je souhaite…</i>
</td>
<td><b>.ai</b><br/><i>Je vais…</i>
</td>
<td><b>.ei</b><br/><i>Ça devrait être…</i>
</td>
<td><b>.oi</b><br/><i>Aïe !</i>
</td></tr>
<tr>
<td><b>.au cu'i</b><br/><i>meh</i><br/>indifférence
</td>
<td><b>.ai cu'i</b><br/>indécision
</td>
<td><b>.ei cu'i</b>
</td>
<td><b>.oi cu'i</b>
</td></tr>
<tr>
<td><b>.au nai</b><br/><i>Nuh-uh !</i><br/>désinclination, réticence
</td>
<td><b>.ai nai</b><br/>involontairement, accidentellement
</td>
<td><b>.ei nai</b><br/>liberté, comment les choses pourraient ne pas être nécessaires
</td>
<td><b>.oi nai</b><br/>plaisir
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Émotion</th></tr></thead>
<tbody>
<tr>
<td><b>ua</b><br/><small>"wah" comme dans "<u>wo</u>n", "<u>o</u>nce"</small><br/><i>Aha ! Eureka !</i>
</td>
<td><b>ue</b><br/><small>"weh" comme dans "<u>we</u>t"</small><br/><i>Quelle surprise !</i>
</td>
<td><b>ui</b><br/><small>"weeh" comme "we"</small><br/><i>hourra !</i>
</td>
<td><b>uo</b><br/><small>"woh" comme dans "<u>wo</u>mbat", "<u>wha</u>t"</small><br/><i>voilà !</i>
</td>
<td><b>uu</b><br/><small>"wooh" comme "woo"</small><br/><i>oh pauvre chose</i>
</td></tr>
<tr>
<td><b>ua cu'i</b><br/>&nbsp;
</td>
<td><b>ue cu'i</b><br/><i>Je ne suis pas vraiment surpris</i>
</td>
<td><b>ui cu'i</b><br/>&nbsp;
</td>
<td><b>uo cu'i</b><br/>&nbsp;
</td>
<td><b>uu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ua nai</b><br/><i>Duh ! Je ne comprends pas !</i><br/>confusion
</td>
<td><b>ue nai</b><br/>attente, manque de surprise
</td>
<td><b>ui nai</b><br/><i>Hélas !</i><br/>sentiment de malheur
</td>
<td><b>uo nai</b><br/>sentiment d'incomplétude
</td>
<td><b>uu nai</b><br/><i>Mwa ha ha !</i><br/>cruauté
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Émotion</th></tr></thead>
<tbody>
<tr>
<td><b>ia</b><br/><small>"yah" comme dans "<u>ya</u>rd"</small><br/><i>Je crois</i>
</td>
<td><b>ie</b><br/><small>"yeh" comme dans "<u>ye</u>s"</small><br/><i>Oui ! D'accord !</i>
</td>
<td><b>ii</b><br/><small>"yeeh" comme "hear <u>ye</u>"</small><br/><i>oups !</i>
</td>
<td><b>io</b><br/><small>"yoh" comme dans "<u>yo</u>gurt"</small><br/><i>respect</i>
</td>
<td><b>iu</b><br/><small>"yooh" comme dans "c<u>u</u>te, d<u>ew</u>"</small><br/><i>J'adore ça</i>
</td></tr>
<tr>
<td><b>ia cu'i</b><br/>&nbsp;
</td>
<td><b>ie cu'i</b><br/>&nbsp;
</td>
<td><b>ii cu'i</b><br/>&nbsp;
</td>
<td><b>io cu'i</b><br/>&nbsp;
</td>
<td><b>iu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ia nai</b><br/><i>Pshaw !</i><br/>incrédulité
</td>
<td><b>ie nai</b><br/>désaccord
</td>
<td><b>ii nai</b><br/><i>Je me sens en sécurité</i>
</td>
<td><b>io nai</b><br/>irrespect
</td>
<td><b>iu nai</b><br/>haine
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Émotion</th></tr></thead>
<tbody>
<tr>
<td><b>.u'a</b><br/><small>"oohah" comme dans "t<u>wo ha</u>lves"</small><br/><i>gain</i>
</td>
<td><b>.u'e</b><br/><small>"ooheh" comme dans "deux têtes"</small><br/><i>quel émerveillement !</i>
</td>
<td><b>.u'i</b><br/><small>"ooheeh" comme dans "deux talons"</small><br/><i>hahaha !</i>
</td>
<td><b>.u'o</b><br/><small>"oohoh" comme dans "deux faucons"</small><br/><i>courage</i>
</td>
<td><b>.u'u</b><br/><small>"oohooh" comme dans "deux hiboux"</small><br/><i>désolé !</i>
</td></tr>
<tr>
<td><b>.u'a cu'i</b><br/>&nbsp;
</td>
<td><b>.u'e cu'i</b><br/>&nbsp;
</td>
<td><b>.u'i cu'i</b><br/>&nbsp;
</td>
<td><b>.u'o cu'i</b><br/>la timidité
</td>
<td><b>.u'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.u'a nai</b><br/>la perte
</td>
<td><b>.u'e nai</b><br/><i>Pff !</i><br/>banalité
</td>
<td><b>.u'i nai</b><br/><i>Blah</i><br/>lassitude
</td>
<td><b>.u'o nai</b><br/>la lâcheté
</td>
<td><b>.u'u nai</b><br/>&nbsp;
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Attitude</th></tr></thead>
<tbody>
<tr>
<td><b>.i'a</b><br/><small>"eehah" comme dans "maison"</small><br/><i>d'accord, je l'accepte</i>
</td>
<td><b>.i'e</b><br/><small>"eeheh" comme dans "tête"</small><br/><i>j'approuve !</i>
</small></td>
<td><b>.i'i</b><br/><small>"eeheeh" comme dans "chaud"</small><br/><i>je suis avec toi là-dessus</i>
</td>
<td><b>.i'o</b><br/><small>"eehoh" comme dans "faucon"</small><br/><i>grâce à cela</i>
</td>
<td><b>.i'u</b><br/><small>"eehooh" comme dans "crochet"</small><br/><i>familiarité</i>
</td></tr>
<tr>
<td><b>.i'a cu'i</b><br/>&nbsp;
</td>
<td><b>.i'e cu'i</b><br/>non-approbation
</td>
<td><b>.i'i cu'i</b><br/>&nbsp;
</td>
<td><b>.i'o cu'i</b><br/>&nbsp;
</td>
<td><b>.i'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.i'a nai</b><br/>la résistance
</td>
<td><b>.i'e nai</b><br/><i>Boo !</i><br/>la désapprobation
</td>
<td><b>.i'i nai</b><br/>le sentiment d'antagonisme
</td>
<td><b>.i'o nai</b><br/>l'envie
</td>
<td><b>.i'u nai</b><br/>la non-familiarité
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Attachement à la situation</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.a'a</b><br/><small>"ahah" comme "aha"</small><br/><i>je t'écoute</i>
</td>
<td><b>.a'e</b><br/><small>"aheh"</small><br/><i>l'alerte</i>
</td>
<td><b>.a'i</b><br/><small>"aheeh" comme dans "Swahili"</small><br/><i>oumph !</i><br/>l'effort
</td>
<td><b>.a'o</b><br/><small></small><br/><i>j'espère</i>
</td>
<td><b>.a'u</b><br/><small></small><br/><i>hm, je me demande…</i>
</td></tr>
<tr>
<td><b>.a'a cu'i</b><br/>inattentivement
</td>
<td><b>.a'e cu'i</b><br/>&nbsp;
</td>
<td><b>.a'i cu'i</b><br/>aucun effort particulier
</td>
<td><b>.a'o cu'i</b><br/>&nbsp;
</td>
<td><b>.a'u cu'i</b><br/><i>Ho-hum</i><br/>le désintérêt
</td></tr>
<tr>
<td><b>.a'a nai</b><br/>l'évitement
</td>
<td><b>.a'e nai</b><br/><i>Je suis fatigué</i>
</td>
<td><b>.a'i nai</b><br/>le repos
</td>
<td><b>.a'o nai</b><br/><i>Gah !</i><br/>le désespoir
</td>
<td><b>.a'u nai</b><br/><i>Berk ! Beurk !</i><br/>la répulsion
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Incitation</th></tr></thead>
<tbody>
<tr>
</td>

<td><b>.e'a</b><br/><small>"ehah"</small><br/><i>vous pouvez le faire</i>
</td>
<td><b>.e'ei</b><br/><small>"ehey"</small><br/><i>allez, fais-le !</i>
</td>
<td><b>.e'i</b><br/><small>"eheeh"</small><br/><i>fais-le !</i>
</td>
<td><b>.e'o</b><br/><small>"ehoh"</small><br/><i>s'il te plait, fais-le</i>
</td>
<td><b>.e'u</b><br/><small>"ehooh"</small><br/><i>je suggère</i>
</td></tr>
<tr>
<td><b>.e'a cu'i</b><br/>&nbsp;
</td>
<td><b>.e'ei cu'i</b><br/>&nbsp;
</td>
<td><b>.e'i cu'i</b><br/>&nbsp;
</td>
<td><b>.e'o cu'i</b><br/>&nbsp;
</td>
<td><b>.e'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.e'a nai</b><br/>interdiction
</td>
<td><b>.e'ei nai</b><br/>exprimant le découragement, la démoralisation
</td>
<td><b>.e'i nai</b><br/>&nbsp;
</td>
<td><b>.e'o nai</b><br/>offrant, accordant
</td>
<td><b>.e'u nai</b><br/>avertissement, déconseil
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.o'a</b><br/><small>"ohah"</small><br/><i>fierté</i>
</td>
<td><b>.o'e</b><br/><small>"oheh"</small><br/><i>Je le sens à portée de main</i>
</td>
<td><b>.o'i</b><br/><small>"oheeh"</small><br/><i>danger !</i>
</td>
<td><b>.o'o</b><br/><small>"ohoh" comme dans "s<u>awho</u>rse"</small><br/><i>patience</i>
</td>
<td><b>.o'u</b><br/><small>"ohooh"</small><br/><i>détente</i>
</td></tr>
<tr>
<td><b>.o'a cu'i</b><br/>modestie, humilité
</td>
<td><b>.o'e cu'i</b><br/>&nbsp;
</td>
<td><b>.o'i cu'i</b><br/>&nbsp;
</td>
<td><b>.o'o cu'i</b><br/>simple tolérance
</td>
<td><b>.o'u cu'i</b><br/>composure, équilibre
</td></tr>
<tr>
<td><b>.o'a nai</b><br/><i>Que c'est embarrassant.<br/>Cela me rend honteux.</i>
</td>
<td><b>.o'e nai</b><br/>distance
</td>
<td><b>.o'i nai</b><br/>imprudence, témérité
</td>
<td><b>.o'o nai</b><br/>impatience, intolérance
</td>
<td><b>.o'u nai</b><br/>stress, anxiété
</td></tr></tbody></table>

Remarquez comment une émotion change en son opposé lors de l'utilisation de **nai**, et en l'émotion intermédiaire lors de l'utilisation de **cu'i**.

Pourquoi certaines cellules d'interjections avec **cu'i** et **nai** sont-elles vides ? Parce que l'anglais manque de moyens concis pour exprimer de telles émotions.

De plus, bon nombre de ces interjections sont rarement utilisées.

### Combinaison d'interjections

> **iu ui nai**
> _Malheureusement amoureux._

<!-- -->

> **ue ui do jinga**
> _Oh, tu as gagné ! Je suis tellement heureux !_

jinga
: … gagner

Dans ce cas, la victoire était improbable, donc je suis surpris et heureux en même temps.

Les interjections (contrairement aux particules scalaires et aux suffixes d'interjection) ne se modifient pas mutuellement:

> **ue ui do jinga**
> **ui ue do jinga**
> _Oh, tu as gagné ! Je suis tellement heureux !_

Ici, deux interjections modifient la même construction (toute la phrase) mais elles ne se modifient pas mutuellement, donc leur ordre n'est pas important.

> **pei .u'i le gerku cu sutra plipe**
> _(Que ressens-tu ?) Hé, le chien saute rapidement._

Ici, **pei** est utilisé seul et ne modifie pas **.u'i**, qui est placé après lui.

### Oublié de mettre une interjection au début ?

> **do pu sidju mi ui**
> _Tu m'aides (youpi !)_

**ui** ne modifie que le pronom **mi**, mettant l'attitude seulement sur _moi_.

> **ui do pu sidju mi**
> _Youpi, tu m'as aidé._

Et si nous avons oublié d'ajouter **ui** au début de cette phrase ?

Nous pouvons explicitement étiqueter la relation comme complète avec **vau** et ensuite mettre l'interjection:

> **do pu sidju mi vau ui**
> _Tu m'as aidé, youpi !_