## Leçon 11. Sujets plus difficiles

### Connaissez aussi votre langue maternelle

Lorsque vous essayez de vous exprimer en lojban, il est important de ne pas en faire une simple copie du français.

Considérez la phrase :

> _Terry, le tigre, visite la grande ville._

Il pourrait être tentant d'utiliser la relation

vitke
: $x_1$ (invité) rend visite à $x_2$ (quelqu'un) à $x_3$

Cependant, l'expression _visite la grande ville_ implique de visiter un lieu, et non quelqu'un à cet endroit, ce qui met en évidence le fait que le verbe anglais _to visit_ peut avoir plusieurs significations.

En effet, par exemple, si l’on considère le français, nous voyons des solutions distinctes :

> J'aimerais rendre visite à mes amis.
<!-- -->

> J'aimerais visiter cette ville.

Le français utilise _rendre visite_ pour rendre visite à quelqu'un et _visiter_ pour visiter un lieu.

En Lojban, nous traduisons le sens, pas seulement les mots.

Comprendre les particularités de votre propre langue est également important lorsque vous essayez d'exprimer quelque chose en Lojban.

Les solutions à l'exemple ci-dessus pourraient être :

> **la .teris. poi tirxu cu klama le barda tcadu**
> _Terry, le tigre, arrive dans la grande ville._

tirxu
: $x_1$ est un tigre

> **la .teris. poi tirxu cu pa roi klama le barda tcadu**
> _Terry, le tigre, vient un jour dans la grande ville._
<!-- -->

> **la .teris. poi tirxu cu pa re'u mo'u klama le barda tcadu**
> _Terry, le tigre, arrive pour la première fois dans la grande ville._
<!-- -->

> **la .teris. poi tirxu cu co'a klama le barda tcadu**
> _Terry, le tigre, part pour la grande ville._

### Quatre significations de '_you_' en anglais

Nous avons déjà vu deux pronoms personnels, **mi** (_je_ ou _moi_) et **do** (_tu_). Cependant, _you_ en anglais peut avoir plusieurs significations, qui sont traduites en lojban de manière spécifique :

- _you_ comme _la personne à qui je parle_ :

 >**le pa do**<br/>
 >_toi un_

 Nous savons que **le re prenu** signifie _les deux personnes_. Il est également possible de mettre des nombres après **le** et avant les pronoms.

- _you_ comme _toutes les personnes à qui je parle_ :

 >**ro do**<br/>
 >_chacun de vous_, _vous tous_ (ou _y'all_ dans le sud des États-Unis)

 On peut également utiliser des nombres avec **ko** :

 >**ro ko klama ti**<br/>
 >_Vous tous, venez ici._

- _you_ comme _un nombre spécifique de personnes à qui je parle_ :

 >**le re do**<br/>
 >_vous deux_

 Par exemple, on peut commencer des courriels à ses parents avec **coi le re do**.

 Remarquez que **re do** signifie _deux d'entre vous_ et **re le ci do** signifie _deux d'entre vous trois_.

- _you_ comme _la personne ou les personnes à qui je parle plus une autre personne ou d'autres personnes_ :

 >**do'o**<br/>
 >_toi et quelqu'un d'autre_

- _you_ comme _n'importe qui_ (par exemple, _L'argent ne peut pas acheter l'amour._) :

 Cela s'exprime généralement par :

 >**ro da**<br/>
 >_tous **da**_

 ou

 >**ro lo prenu**<br/>
 >_toutes les personnes_

 Cependant, vous pouvez souvent l'omettre complètement ou placer **zo'e** à cette position.
<!-- La méthode recommandée consiste à transformer d'abord les pronoms en verbes :

>**lo re me do ko klama ti**
>_Vous deux, venez ici._

Il est possible d'omettre **me** dans cette position et de dire **lo re do ko klama ti** mais cela peut conduire à la confusion chez les débutants. -->
### Plus sur les courtes propositions relatives

Les courtes propositions relatives avec un pronom qui les suit peuvent être placées immédiatement après **le** :

> **le gerku pe mi**
> _Mon chien_

Dans de tels cas, **pe** peut même être omis :

> **le gerku pe mi**
> **le mi gerku**
> _Mon chien_

**le mi gerku** signifie exactement la même chose que **le gerku pe mi**.

Ainsi, "**le** + argument + construction de relation" est équivalent à "**le** + construction de relation + **pe** + argument".

Quelques règles :

- si vous souhaitez utiliser un argument converti à partir d'une relation (par exemple avec **le**) ou si c'est un nom, il est conseillé d'utiliser **pe** et de le placer après l'argument : **le gerku pe la .alis.** (_Le chien d'Alice_).
- l'omission de **pe** est acceptable uniquement lors de l'utilisation de pronoms sans nombres devant eux : **le do gerku** (_ton chien_) mais pas **le pa do gerku** (= **le pa do cu gerku** = _l'un de vous est un chien_).

Il est beaucoup plus sûr d'utiliser **pe** explicitement et de le placer après l'argument auquel il est attaché : **le gerku pe la .alis.** et **le gerku pe mi** sont les constructions les plus intuitives.

### Citer du texte dans différentes langues

**zoi** est une marque de citation pour citer du texte non-lojban. Sa syntaxe est **zoi X. texte .X**, où X est un mot lojban (appelé mot délimitant) qui est séparé du texte cité par des pauses, et qui n'est pas trouvé dans le texte écrit ou dans le flux phonème parlé à l'intérieur de cette citation. Il est courant, mais pas obligatoire, d'utiliser le nom de certaines lettres, qui correspondent au nom lojban de la langue citée :

> **zoi gy. John is a man .gy. cu glico jufra**
> _"John is a man" est une phrase anglaise._

glico
: $x_1$ est anglais

où **gy.** signifie **glico**. D'autres choix populaires de mots délimitants sont le mot _zoi_ lui-même et un mot lojban suggérant le sujet de la citation.

Le lojban évite strictement toute confusion entre les choses et les noms des choses :

> **zo .bob. cmene la .bob.**
> `Le mot "Bob" est le nom de celui nommé Bob.`

**zo .bob.** est le mot, tandis que **la .bob.** est la chose nommée par le mot. Les courtes qualificatrices **la'e** et **lu'e** placées avant les termes convertissent les références et leurs référents :

> **zo .bob. cmene la'e zo .bob.**
> _Le mot "Bob" est le nom du référent du mot "Bob"._

<!-- -->

> **lu'e la .bob. cmene la .bob.**
> _Un symbole pour Bob est le nom de Bob._

Les deux derniers exemples signifient la même chose. Mais ceci est différent :

> **la .bob. cu cmene la .bob.**
> _Bob est le nom de Bob._

et dit que Bob est à la fois le nom et la chose nommée, une situation peu probable. Les gens ne sont pas des noms.

**la'o** sert à marquer les noms non-lojban, par exemple, les noms binomiaux linéens (comme "Homo sapiens"), qui sont les noms normalisés internationalement pour les espèces animales et végétales.

Les noms connus internationalement qui peuvent être plus facilement reconnus par l'orthographe que par la prononciation, tels que _Goethe_, peuvent également apparaitre dans le texte lojban avec **la'o** :

> **la'o dy. Goethe .dy. cu me la'o ly. Homo sapiens .ly.**
> _Goethe est un Homo sapiens._

Cependant, utiliser **la'o** pour tous les noms plutôt que de les adapter au lojban peut rendre le texte lourd.

Tout ce qui est exprimé dans le texte doit également être exprimé dans la parole et vice versa. Par conséquent, il ne peut y avoir aucune ponctuation qui n'est pas prononcée. Cela signifie que le lojban a une large gamme de mots pour citer d'autres mots. Tous les lojban convertissent un texte en un terme-argument.

**lu** … **li'u** ne citent que du texte grammaticalement correct. Pour citer n'importe quel texte lojban, nous utilisons plutôt des citations **lo'u** … **le'u**.

> **— xu lo'u je le'u lojbo sumsmi**
> **— na ku sumsmi**
> _— "Je" est-il un terme ?_
> _— Non._

<!-- -->

> **ma xe fanva zoi gy.What's up?.gy. la .lojban.**
> _Comment traduire "What's up?" en lojban ?_

### Termes internes

En utilisant **be**, vous pouvez non seulement remplir des emplacements de relations mais également ajouter des termes modaux :

> **le xatra be de'i li vo cu se mrilu de'i li ze**
> _Cette lettre, datée du 4, est envoyée le 7_

xatra
: $x_1$ est une lettre

Une date marquée avec **de'i** s'applique uniquement à **xatra**. Comparez :

> **le xatra de'i li vo cu se mrilu de'i li ze**
> _La lettre du 4 est envoyée le 7_ (quoi que cela puisse signifier)

Sans **be**, le terme **de'i li vo** s'appliquerait à l'ensemble de la relation, et non à **xatra**. Ce que nous voulons dire, c'est que la première date s'applique uniquement à la lettre et la seconde date s'applique à l'envoi de la lettre. Cela signifie que dans **le xatra be de'i li vo** la partie **de'i li vo** (_le 4, comme date_), s'applique uniquement à l'argument **le xatra**, et non à la phrase entière.

### Relations composées en détail

Le regroupement des termes dans la grammaire lojbane est particulièrement important lorsqu'il s'agit de tanru (relations composées). La façon dont les relations se regroupent dans un tanru détermine ce que signifie ce tanru. Par exemple,

> _the bad music magazine_

a deux interprétations en anglais : un mauvais magazine sur la musique ou un magazine sur la mauvaise musique. En lojban, son équivalent

> **le xlali zgike karni**

n'a que l'interprétation _le magazine de mauvaise musique_, car les deux premières relations (_xlali zgike_ — _mauvaise musique_) se regroupent en premier. Il est important de modifier le regroupement des relations pour garantir que le tanru transmet le sens voulu. Pour cette raison, Lojban a mis en place quelques mécanismes pour que les tanru se regroupent correctement.

En français, nous utilisons des parenthèses pour structurer le texte. De même, pour les tanru, nous utilisons **ke** pour la parenthèse gauche et **ke'e** pour la parenthèse droite.

**le xlali ke zgike karni** signifie _le mauvais magazine de musique_ / _le mauvais magazine musiqual_.

Comme vous pouvez le voir, nous avons séparé **xlali** du reste du tanru et l'avons appliqué à l'ensemble du tanru. Il n'est pas nécessaire d'utiliser **ke'e** à la fin du tanru car nous savons déjà qu'il se termine ici.

> **.i mi pu zi te vecnu le xlali ke zgike karni .i to'e zanru la'o gy.Eurythmics.gy.**
> _Je viens d'acheter un mauvais magazine musiqual. Il a critiqué les Eurythmics._

C'est une façon de regrouper les composants dans tanru. L'autre façon consiste à utiliser **bo** dans un nouveau rôle. Lorsque **bo** apparaît entre deux composants, cela signifie que ces composants se regroupent plus étroitement qu'autre chose. Donc, une autre façon de dire _mauvais (magazine musical)_ est

le xlali zgike bo karni
: le mauvais (magazine de musique)

**bo** ici est similaire au trait d'union dans la traduction française. Cela signifie que **zgike bo karni** doit être considéré comme une unité, à laquelle **xlali** (_mauvais_) s'applique.

Ainsi, **bo** rend les connexions plus étroites :

> **la .doris. e la .alis. o nai bo la .bob.**
> _Doris et (soit Alice, soit Bob)_

**ke** peut également être utilisé avec des connecteurs (mais pas avec des phrases ; elles ont leur propre type de parenthèses, **tu'e … tu'u**). Ainsi, nous pourrions également dire

> **la .doris. e ke la .alis. o nai la .bob.**

Rappelez-vous que la parenthèse droite **ke'e** peut souvent être omise sans changer le sens (comme dans ce cas).

Les conjonctions de prévoyance sont également fréquemment utilisées car elles peuvent éliminer le besoin de parenthèses droites :

> **ge la .doris. gi go nai la .alis. gi la .bob.**
> _Doris et soit Alice, soit Bob_

et

> **go nai ge la .doris. gi la .alis. gi la .bob.**
> _Soit Doris et Alice, soit Bob_

Il n'est pas nécessaire d'utiliser **bo** ou **ke** avec les conjonctions de prévoyance.

### « **co** » pour changer l'ordre dans les relations composées

Il existe une autre façon de restructurer les relations composées.

> **mi fanva se jibri**
> _Je suis un traducteur professionnel_

jibri
: $x_1$ est un travail de $x_2$

Si je voulais dire que je suis un traducteur professionnel de l'anglais vers l'allemand, je pourrais utiliser **be** et **bei** :

> **mi fanva be le dotco bei le glico be'o se jibri**
> _Je suis un traducteur professionnel en allemand depuis l'anglais._

dotco
: $x_1$ est allemand

Le fait qu’il s’agisse d’une relation composée pouvait rapidement se perdre dans le discours en raison de la structure complexe de la phrase. Ici, nous pouvons utiliser le mot **co** :

**co** — inverse la relation composée, faisant en sorte que le composant le plus à droite modifie celui le plus à gauche au lieu de l'inverse. Tout terme d'argument précédent remplit le modifié, tout terme d'argument suivant remplit le modificateur.

> **mi se jibri co fanva le dotco le glico**

C'est la même relation que la précédente Lojban, mais beaucoup plus facile à comprendre. Notez que tout argument avant la relation composée remplit **se jibri**, tandis que tout argument qui le suit ne remplit que le composant modificateur : **fanva**.

La force par laquelle deux composants sont liés ensemble avec **co** est très faible – encore plus faible que le regroupement de relations composées normales sans aucun mot de regroupement. Cela garantit que, dans une co-construction, le composant le plus à gauche est toujours le composant modifié, et le composant le plus à droite est toujours modifié, même si l'une de ces parties est une relation composée. Cela rend une **co**-construction facile à comprendre :

est lu comme **ti (pelxu plise) co kukte**, ce qui est la même chose que **ti kukte pelxu bo plise**. Cela signifie également qu'un **ke … ke'e** ne peut pas englober un **co**.

Un autre exemple :

> **mi merko limna co mutce certu**
> _Je suis un nageur américain très expérimenté._

merko
: $x_1$ est américain (sens des États-Unis)

Voici la liste des différents types de groupes dans les verbes composés classés du plus serré au plus lâche :

1. **bo** et **ke … ke'e**
2. connecteurs logiques pour les verbes composés comme **je**
3. ne pas utiliser de mots de regroupement
4. **co**

### Terminaison explicite des noms

Le petit mot **ku** peut être utilisé à la fin d'un nom pour montrer explicitement sa bordure droite. **ku** est analogue au crochet droit en mathématiques.

> **tu du le badna ku ui**
> **tu du le ui badna**
> _C'est la banane (youpi !)_

Contrairement à :

> **tu du le badna ui**
> _C'est la banane (youpi c'est une banane et pas autre chose dans la nature !)_

### Éviter la terminaison explicite
Un autre style de discours consiste à éviter la terminaison. Voici quelques cas courants :

Élimination de **li'u**, le guillemet droit :

> **lu mi prami do li'u cu se cusku la .alis.**
> **lu mi prami do li'u se cusku la .alis.**
> **lu mi prami do cu se cusku la .alis.**
> _"Je t'aime", dit Alice._

**li'u** peut être omis ici car il ne peut y avoir deux constructions de relation principales dans une phrase. Ainsi, nous lisons d'abord la partie **lu mi prami do**, et lorsque nous voyons le **cu**, nous réalisons que nous ne pouvons pas continuer cette phrase citée plus loin. Nous supposons que la citation est terminée et que la phrase extérieure continue. Ainsi, aucune ambigüité ne se produit.

Élimination de **ku'o**, la bordure droite des propositions relatives :

> **le prenu noi mi zgana ke'a ku'o ca tavla le pendo be mi**
> **le prenu noi mi zgana ke'a ca tavla le pendo be mi**
> _La personne que j'observe parle maintenant à mon ami._

**ku'o** peut être omis ici lorsque la proposition relative dont nous avons besoin (**mi zgana ke'a**) se termine par un terme, **ke'a** dans ce cas. Après la proposition relative, quelque chose d'autre qu'un terme commence, donc la proposition relative ne peut pas être poursuivie, et nous savons donc qu'elle se termine avec succès sans aucun mot de droite de crochet explicite.

Un tour similaire serait de toujours placer **ke'a** à la fin de la proposition relative :

> **le prenu noi ke'a melbi ku'o ca tavla le pendo be mi**
> **le prenu noi melbi fa ke'a ca tavla le pendo be mi**
> _La personne qui est jolie parle maintenant à mon ami._

Cependant, dans le cas suivant, la terminaison est nécessaire :

> **le prenu noi mi zgana ke'a ku'o le pendo be mi ca tavla**
> _La personne que j'observe parle maintenant à mon ami._

car après la proposition relative **mi zgana ke'a**, nous avons choisi de placer un autre terme (**le pendo be mi**) qui n'appartient pas à la proposition relative actuelle.

Un semi-tour ici serait d'utiliser **ce'e** :

> **le prenu noi mi ke'a zgana ce'e le pendo be mi ca tavla**
> _La personne que j'observe parle maintenant à mon ami._

Ici, nous terminons la proposition relative avec la construction de relation principale **zgana**. Ensuite, nous avons la conjonction **ce'e** et un terme après (**le pendo be mi**). Comme **ce'e** ne peut joindre que des termes, nous savons qu'à gauche de **ce'e**, nous avons un terme, qui ne peut être que **le prenu noi mi ke'a**. Ainsi, le sens est conservé et aucune ambigüité ne se produit. Notez que nous avons toujours besoin d'un mot séparé, **ce'e**, dans de tels cas, donc bien que nous ayons éliminé le mot de crochet droit, nous avons quand même dû introduire quelque chose d'autre.

Élimination de **kei**, la bordure droite des phrases intérieures :

> **mi cinmo le ka badri kei le tcini**
> **le ka badri cu se cinmo mi le tcini**
> **mi cinmo fi le tcini fe le ka badri**
> **mi cinmo le ka badri ce'e le tcini**
> _Je me sens triste à propos de la situation._

> **mi stidi lo ka citka su'o da kei do**
> **mi stidi lo ka ce'u su'o da citka ce'e do**
> _Je suggère que vous mangiez quelque chose._

Comme vous pouvez le voir, aucun tour de passe-passe ne rend le résultat plus court que l'original avec **kei**, donc pour la concision, vous voudrez peut-être utiliser **kei**.

### Conversion des ensembles en masses

> **le prenu cu pa moi le'i pendo be mi ku noi lu'o ke'a ca smaji**
> _Il est le premier de mes amis qui gardent le silence ensemble._
> _Cette personne est la première parmi le groupe de mes amis qui sont maintenant, comme une foule, silencieux._

Le mot qualificatif **lu'o** placé avant un argument le convertit en une masse composée de membres de cet argument. Dans ce cas, **ke'a** fait référence à l'ensemble de mes amis **le'i pendo be mi** puis **lu'o** convertit les membres de l'ensemble en une masse, la foule des mes amis.

### Ensembles et sous-ensembles

Certains infinitifs peuvent impliquer plus d'un **ce'u** :

> **le'i prenu cu simxu le ka prami**
> **le'i prenu cu simxu le ka ce'u prami ce'u**
> _Les gens s'aiment les uns les autres._

simxu
: les membres de l'ensemble $x_1$ font réciproquement $x_2$

La relation **simxu** prend chaque paire possible de l'ensemble spécifié en place $x_1$ et affirme la relation spécifiée dans $x_2$.

Si nous avons trois personnes, cela signifierait qu'elles s'aiment toutes les unes les autres.

> **do ce la .alis. ce mi simxu le ka prami**
> **do ce la .alis. ce mi simxu le ka ce'u prami ce'u**
> _Toi, Alice et moi, nous nous aimons tous les uns les autres._

ce
: conjonction : joint plusieurs arguments dans un ensemble

La conjonction **ce** fusionne les arguments en un ensemble. Ainsi, **faites ce la .alis. ce mi** pourrait être une manière plus verbeuse de **le'i prenu** de l'exemple précédent lorsque nous voulons nommer les membres de l'ensemble.

<pixra url="/assets/pixra/cilre/simxu_tunba.webp" caption="le'i ci prenu cu simxa le ka tunba" definition="The three people are all siblings to each other."></pixra>

Au total, nous affirmons 6 relations :

1. Tu aimes Alice.
2. Tu m'aimes.
3. Alice m'aime.
4. Alice t'aime.
5. Je t'aime.
6. Je l'aime.

Ainsi, **simxu** est un raccourci pratique pour exprimer des relations mutuelles.

Considérons maintenant l'exemple :

> **le'i su'o cmima be le'i prenu cu simxu le ka prami**
> _Certains des gens s'aiment les uns les autres._

cmima
: $x_1$ est un membre de l'ensemble $x_2$

Dans cet exemple, nous montrons qu'un sous-ensemble des personnes en question (un sous-ensemble de **le'i prenu**) a un amour mutuel.

Cela nous permet de transmettre des idées encore plus complexes :

> **le'i su'o citno cmima be le'i stati prenu cu simxu le ka prami**
> _Certains jeunes de ces gens intelligents s'aiment les uns les autres._
> `Certains jeunes membres de l'ensemble des gens intelligents s'aiment les uns les autres.`

<!-- ## Logique du second ordre

Nous avons vu que **da** (et **de**, **di**) est une "variable" sous forme de nom avec des significations déclarées en fonction des propositions données.
Il est généralement traduit par _il y a X, il y a X tels que…_

Cependant, par curiosité, je dois mentionner la série de verbes qui servent également de "variables" mais sous forme de verbe, c'est-à-dire sous forme de relation :

>**su'o bu'a zo'u mi bu'a do**
>_Il y a une certaine relation ou propriété : j'ai cette relation avec toi._
> _Toi et moi sommes liés d'au moins une manière._

>**ro bu'a zo'u ga nai le'e mlatu cu bu'a gi la .dinas. bu'a**
>>_Pour chaque relation ou propriété possible : si les chats l'ont, alors Dinah l'a aussi._ (Ainsi, nous supposons que Dinah est un chat.)

Le raisonnement derrière ces verbes variables est caché dans la logique formelle. Inutile de dire qu'ils sont rarement utilisés dans la parole, mais voici un exemple possible :

su'o bu'a zo'u ge ge da na bu'a gi su'o da su'o de zo'u ge da .e de bu'a gi da manci de gi ro da ro de zo'u da bu'a .ije da manci de .inaja de bu'a
- corriger la phrase -->

<!-- ## Choses pas encore formalisées en lojban

Bien que le lojban puisse être la langue parlée n°1 dans le monde en raison de la précision de sa grammaire, il y a encore des choses qui ne sont pas formalisées.

On ne sait pas ce que signifie **ta'e na** par opposition à **na ta'e**.

On ne sait pas comment traiter **na go'i**.

Voici le texte traduit :

On ne sait pas comment xorlo fonctionne lorsque nous avons besoin d'une conversion explicite entre ensembles et masses, comment opérer avec des ensembles en général, comment utiliser xorlo avec la logique du second ordre comme bu'a.

postoxorlo fonctionne avec l'anaphore et les quantificateurs externes. -->

<!-- ## Système de connectivité non standard

Certaines personnes pour connecter des noms au lieu de

- **a**, **e**, **o**, **u**

utilisent

- **ja**, **je**, **jo**, **ju**

C'est-à-dire qu'au lieu de

>**mi e do nelci le plise**
>_J'aime les pommes, et tu aimes les pommes._

ils disent

>**mi je do nelci le plise**
>_J'aime les pommes, et tu aimes les pommes._

C'est une approche non standard. Les gens utilisent ce style car il y a moins de conjonctions à retenir.

Mais vous devez faire attention à ne pas oublier **le** ou les nombres pour former des noms : **mi nelci le plise je jisra** signifierait _J'aime quelque chose qui est une pomme (ou des pommes) et est du jus_ (?!)

La phrase correcte utilise **le** pour former chaque nom :

>**mi nelci le plise je le jisra**
>_J'aime les pommes et le jus._

Dans l'approche standard, le locuteur utilise une conjonction séparée **e** lorsqu'il connecte des noms, et il est plus facile de voir la différence et la signification correcte :

>**mi nelci le plise .e le jisra**
>_J'aime les pommes et le jus._ -->