---
title: alphabet krulermorna
---

**la krulermorna** est une orthographe alternative qui met en œuvre de manière plus stricte l'isomorphisme audiovisuel de l'orthographe en Lojban.

1. La plupart des lettres proviennent de l'orthographe originale basée sur l'alphabet latin.
2. Les glisses **i** et **u** devant les voyelles sont considérées comme des consonnes et sont donc exprimées par des lettres distinctes :
   * **i** => **ɩ**
   * **u** => **w**
3. Les diphtongues qui se comportent comme d'autres voyelles "pures" sont exprimées par des lettres distinctes :
   * **au** => **ǎ**
   * **ai** => **ą**
   * **ei** => **ę**
   * **oi** => **ǫ**
4. Dans d'autres positions, **i** et **u** sont conservés tels quels dans l'orthographe originale en alphabet latin.

## Utilisation

la krulermorna est utilisée par un algorithme dans l'application [la sutysisku](https://la-lojban.github.io/sutysisku/fr/ "la sutysisku") pour rechercher des rimes pour les mots en Lojban.

Cela peut également aider à comprendre la morphologie du Lojban.

Mis à part cela, c'est principalement un projet artistique.

Le nombre total de lettres dans l'alphabet Lojban passe de 26 dans l'orthographe officielle à 32 dans la krulermorna, ce qui peut ne pas être souhaitable pour les personnes utilisant de petits claviers d'écran comme ceux des appareils portables.

## la vlipa krulermorna

<figure class="wide">
	<img src="https://github.com/La-Lojban/suho-pixra-pe-la-jbotcan/blob/master/320px-la_vlipa_krulermorna.png?raw=true" alt="la vlipa krulermorna">
	<figcaption>
	.i coi do<br/>.i mi ca jai gau djuno fai do<br/>lo du'u wi mi ca pilno<br/>la krulermorna<br/>lo ka ciska dei<br/>.i ɩa ky. jai cinri
	</figcaption>
</figure>

_la vlipa krulermorna_ est une modification de la krulermorna où la lettre **ǎ** est remplacée par le caractère Unicode 'LATIN SMALL LETTER AU'. Ce dernier n'est pas pris en charge par la plupart des polices utilisées et donc cette variante de l'orthographe krulermorna est moins utilisée.

## Interjections selon krulerske

|          |           |              |        |
| -------- | --------- | ------------ | ------ |
| .ǎ       | .ą        | .ę           | .ǫ     |
| Désir ... | Je vais    | cela devrait | ouille\! |

<div class="first_col">

|     | a               | e                | i                   | o             | u               |
| --- | --------------- | ---------------- | ------------------- | ------------- | --------------- |
| .   |                 |                  |                     |               |                 |
| ɩ   | Je crois        | oua\! d'accord\! | ouh là là\!          | respect       | J'adore ça      |
| w   | découverte      | Quelle surprise  | hourra\!            | voilà\!       | oh pauvre chose |
| .a' | j'écoute        | vigilance        | ouf\! (effort)      | J'espère       | hum, je me demande... |
| .e' | tu peux         | allez, fais-le\! | fais-le\!           | s'il te plaît, fais-le | Je suggère       |
| .i' | d'accord, je l'accepte | J'approuve\! | Je connais ce sentiment | grâce à ça  | familiarité     |
| .o' | fierté           | proximité        | danger\!            | patience      | relaxation      |
| .u' | gain            | quelle merveille\!  | hahaha\!            | courage       | désolé\!         |

</div>

## Représentation alternative

<div class="first_col">

|     | a          | e          | i            | o            | u           | ǎ      | ą      | ę          | ǫ              |
| --- | ---------- | ---------- | ------------ | ------------ | ----------- | ------ | ------ | ---------- | -------------- |
| .   |            |            |              |              |             | désir  | intention | obligation | plainte/douleur |
| ɩ   | croyance     | accord  | peur         | respect      | amour        |        |        |            |                |
| w   | découverte  | surprise   | bonheur    | achèvement   | pitié        |        |        |            |                |
| .a' | attentif/ve  | vigilance  | effort       | espoir         | intérêt    |        |        |            |                |
| .e' | permission | compétence | contrainte   | demande      | suggestion  |        |        |            |                |
| .i' | acceptation | approbation   | être ensemble | appréciation | familiarité |        |        |            |                |
| .o' | fierté      | proximité  | prudence      | patience     | détente  |        |        |            |                |
| .u' | gain       | émerveillement   | amusement    | courage      | repentir  |        |        |            |                |

</div>