---
icon: 📕 
title: Langue complète
---

**CLL non officiel** (communément appelé *UnCLL*, *InCLL*) est un projet organisé par Gleki qui propose régulièrement des versions expérimentales non officielles (n'étant pas nécessairement approuvées par le Logical Language Group) du livre de la langue 'Complete Lojban Language'.

*   Envoyez vos commentaires (bugs remarqués, propositions, suggestions) à l'un des endroits suivants:
    *   [groupe Lojban Reddit](https://www.reddit.com/r/lojban/)
    *   [groupe Lojban Facebook](https://www.facebook.com/groups/lojban)
    *   Chat en direct: [discussion Telegram](https://t.me/lojban) ou [discussion Discord](https://discord.gg/BVm4EYR)
    *   à <gleki.is.my.name@gmail.com> (Gleki Arxokuna), le mainteneur de l'UnCLL.

## Versions
### geklojban-1.2.15 octobre 2022
#### Version compilée
*   lisez le document final qui doit être utilisé pour l'impression et la publication. Remarquez que la page de titre a explicitement marqué le document comme "geklojban-1.2.15" et que le nom de l'organisation qui l'a publié est différent de celui de la LLG; cela est fait pour souligner qu'il ne s'agit pas d'une publication de la LLG:
    *   [format PDF](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [format HTML, une page est une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [format HTML - l'ensemble du livre sur une seule page très longue](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
* ou lisez le document PDF appelé "différence" qui compare geklojban-1.2.15 à l'UnCLL, version 1.2.14 (publiée en juillet 2021). Les insertions sont marquées en vert et avec le préfixe "ins\`" et les suppressions sont marquées en rouge et avec le préfixe "del\`". Les préfixes sont ajoutés pour que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative de différence sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (mais vous devrez alors faire défiler manuellement le document pour trouver les différences).
*   ou lisez le document de différence au format HTML à la place:
    *   [avec des préfixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [sans les préfixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

#### Courte liste des changements par rapport à la version précédente 'geklojban-1.2.14 Juillet 2021'

* correction de fautes de frappe et de problèmes stylistiques dans le chrestomathy (merci à koyshi, gleki)
* [issue #475](https://github.com/lojban/cll/issues/475) **nunkilbra** changé en **nunkilca'a** (merci up4kid)
* [issue #466](https://github.com/lojban/cll/issues/466) amélioration de l'algorithme de test tosmabru (merci vpbroman)
* [issue #473](https://github.com/lojban/cll/issues/473) le cmavo "matrix transpose" utilise maintenant un T en exposant pour l'opérateur de transposition
* Les mentions de la police Helvetica sont remplacées par des mentions de la police Comic ("Comic" est le nom d'une police open-source au moins) 
* correction d'autres fautes mineures (merci Matt Nazarian, mattfbacon, la-kanba)
* Modifications du CSS pour améliorer le rendu des versions HTML sur les appareils en mode sombre (merci à NathanHawks) 
* L'UnCLL dispose désormais de fichiers de différences visuelles par rapport à la version précédente, ainsi que séparément pour la version officielle.

[source git de l'UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Comparé à la version 'geklojban-1.2.12 novembre 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparaison entre l'édition officielle CLL v.1.1 (2016) et l'édition UnCLL novembre 2020': différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* le [document PDF "différence"](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference_prefixed.pdf) qui compare geklojban-1.2.15 à l'édition officielle CLL v.1.1 (2016). Les insertions sont marquées en vert avec un préfixe "ins\`" et les suppressions sont marquées en rouge avec un préfixe "del\`". Les préfixes sont ajoutés pour que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative sans préfixes des différences](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (mais vous devrez alors faire défiler manuellement le document pour trouver les différences).

### geklojban-1.2.14 Juillet 2021

#### Version compilée
*   Lire le document final qui sera utilisé pour l'impression et la publication. Notez que la page de titre indique explicitement que le document est "geklojban-1.2.14" et que le nom de l'organisation qui l'a publié est différente de la LLG ; cela est fait pour souligner qu'il ne s'agit pas d'une publication de la LLG :
    *   [Format PDF](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [Format HTML, une page représente une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [Format HTML - le livre entier sur une seule page très longue](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* ou lire le soi-disant document PDF ["difference"](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference_prefixed.pdf) qui compare geklojban-1.2.14 à l'UnCLL, version 1.2.12 (publiée en novembre 2020). Les insertions sont marquées en vert avec le préfixe "ins\`" et les suppressions sont marquées en rouge avec le préfixe "del\`". Les préfixes sont ajoutés pour vous permettre d'utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (mais vous devrez alors faire défiler manuellement le document pour trouver les différences).
*   ou lire le document de différence au format HTML à la place :
    *   [avec les préfixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans les préfixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Petite liste de modifications par rapport à la version précédente 'geklojban-1.2.11.1 octobre 2020'

* il s'agit d'une des principales améliorations. Le [Glossaire des mots en Lojban](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) comporte environ 200 nouveaux exemples de phrases en Lojban avec leur traduction en anglais. Étant donné que le nombre de mots de base en Lojban est d'environ 2000, cela signifie que ~10% de cette tâche est terminée.
* correction des erreurs avec **bo**, **ke'e** dans le chapitre 5. 'Négation scalaire du selbri'
* correction d'un nom incorrect d'un fichier audio
* davantage d'améliorations de l'index : ajout de ZEhA et de plus de BAI
* meilleure explication de cmevla selon dotside
* ajout de points manquants dans les cmavo lorsque nécessaire
* correction de la ponctuation dans la traduction du poème 'Kubla Khan'

[source git de l'UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Comparée à la version 'geklojban-1.2.12 novembre 2020' : différence git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparaison entre l'édition officielle CLL v.1.1 (2016) et l'édition UnCLL novembre 2020' : différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
### geklojban-1.2.13 mai 2021

#### Version compilée
*   lire le document final qui sera utilisé pour l'impression et la publication. Notez que la page de titre marque explicitement le document comme étant "geklojban-1.2.13" et comporte le nom de l'organisation qui l'a publié, différente de la LLG ; cela est fait pour souligner qu'il ne s'agit pas d'une publication de la LLG :
    *   [Format PDF](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [Format HTML, une page par section du livre](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [Format HTML - l'ensemble du livre sur une seule page très longue](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* ou lire le soi-disant document de ["différence" au format PDF](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference_prefixed.pdf) qui compare geklojban-1.2.13 à l'UnCLL, version 1.2.12 (publiée en novembre 2020). Les insertions sont marquées en vert avec le préfixe "ins\`" et les suppressions en rouge avec le préfixe "del\`". Les préfixes sont ajoutés afin que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (mais vous devrez alors faire défiler manuellement le document pour trouver les différences).
*   ou lire le document de différence au format HTML à la place :
    *   [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Courte liste de modifications par rapport à la version précédente "geklojban-1.2.11.1 Octobre 2020"

* ajouter de nouvelles belles images en chapitre par [la-ninpre](https://github.com/la-ninpre)
* ajouter une traduction du poème "In Xanadu" à la chrestomathie
* corriger la tentative bizarrement datée de la théorie des ensembles par [simpson](https://github.com/MostAwesomeDude)
* corriger la définition de **toldi** (_papillon_)
* corriger l'affirmation incorrecte qui impliquait que les fuhivla n'ont pas de rafsi
* rendre moins trompeuse l'explication de **le vi tavla ba klama** (correction mise en œuvre par [mezohe](https://github.com/mezohe))
* Les matrices de plus de deux dimensions peuvent être construites en utilisant soit **pi'a** soit **sa'i** avec un sous-sciprit approprié étiquetant la dimension... Les étiquettes peuvent être n'importe quoi que **xi** prend en charge, par exemple **pa** ou **mlatu bu**.
* Chapitre 5 : rétablissement de la mention du regroupement **bo** dans la section sur NAhE, et ajout de **bo** à un exemple (correction mise en œuvre par [mezohe](https://github.com/mezohe))
* Chapitre 7 : correction de l'affirmation à propos de **ra'o** dans l'exemple 7.39 (correction mise en œuvre par [mezohe](https://github.com/mezohe))
* Chapitre 2 : correction du diagramme (prédicat -> prédication) (correction mise en œuvre par [mezohe](https://github.com/mezohe))
* ajouter des points manquants dans cmavo
* correction d'autres petites erreurs de frappe, d'éléments d'indices, de scripts de compilation, etc.

[source git de l'UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Comparé à la version 'geklojban-1.2.12 Novembre 2020' : différence git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Comparaison entre l'édition officielle du CLL v.1.1 (2016) et l'édition de l'UnCLL de novembre 2020 : différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12) 
### geklojban-1.2.12 Novembre 2020

#### Version compilée
* lire le document final qui sera utilisé pour l'impression et la publication. Notez que la page de titre du document est explicitement marquée comme "geklojban-1.2.12" et que le nom de l'organisation qui l'a publié est différent de celui du LLG; cela est fait pour souligner qu'il ne s'agit pas d'une publication du LLG:
    * [format PDF](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    * [format HTML, une page est une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    * [format HTML - le livre entier sur une très longue page](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* ou lire le soi-disant ["document de différence" au format PDF](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference_prefixed.pdf) qui compare geklojban-1.2.12 au CLL publié en 2016 (version du 27 août 2016). Le document a des insertions marquées en vert et avec le préfixe "ins\`" et des suppressions marquées en rouge et avec le préfixe "del\`". Les préfixes sont ajoutés afin que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative de différence sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (mais ensuite, vous devrez faire défiler manuellement le document pour trouver les différences).
* ou lire le document de différence en format HTML à la place :
    * [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Courte liste des changements par rapport à la version précédente 'geklojban-1.2.11.1 octobre 2020'

* ajout de la prononciation standard de {u} dans le chapitre IPA (par [Vexatos](https://github.com/Vexatos))
* les symboles en indice dans les gloses sont traités de manière appropriée (bug remarqué par [gr-g](https://github.com/gr-g))
* correction d'une erreur grammaticale dans l'Exemple 17.36 (bug remarqué par [kotwys](https://github.com/kotwys))
* la particule **ri'u** manquait dans la section 10.28 (comme remarqué par [gr-g](https://github.com/gr-g)). Ajouté
* dans l'Exemple 7.12, le premier endroit de **lafti** est appliqué à une personne. Le prédicat devient **lafmuvgau** (qui est dans les notes de la définition de **lafti**)
* dans le texte anglais, changer .) en ). là où c'est nécessaire
* afficher la racine carrée, l'infini et le nombre d'or phi avec des symboles réels
* correction de la traduction incorrecte de **levi rozgu cu sofi'upanova'e xunre**
* autres corrections mineures
#### [source git](https://github.com/lojban/cll/compare/geklojban-1.2.12)
#### Comparaison du code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.11.1 octobre 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Comparé à la version officielle CLL v.1.1 (2016)': différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.12)

 ### geklojban-1.2.11.1 octobre 2020

#### Version compilée
* lire le document final destiné à l'impression et à la publication. Notez que la page de titre indique explicitement que le document est "geklojban-1.2.11" et que le nom de l'organisation qui l'a publié diffère de celui de la LLG ; cela est fait pour souligner qu'il ne s'agit pas d'une publication de la LLG :
    * [format PDF](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    * [format HTML, une page est une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    * [format HTML - tout le livre en une très longue page](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* ou lire le document PDF appelé "différence" qui compare geklojban-1.2.11 au CLL publié en 2016 (version du 27 août 2016). Les insertions sont marquées en vert et préfixées par "ins\`" et les suppressions sont marquées en rouge et préfixées par "del\`". Les préfixes sont ajoutés pour que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative de différence sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (mais vous devrez alors faire défiler manuellement le document pour trouver les différences).
* ou lire le document de différence au format HTML à la place :
    * [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Liste courte des changements par rapport à la version précédente 'geklojban-1.2.10 août 2020'

* les liens audio (audio de la tcakoi, de .lindar. et de .aionys.) ont été ajoutés aux versions HTML du livre "récupérées par sections" et "récupérées par chapitres"
* correction de plusieurs fautes de frappe
* ajout des caractères hanzi à un exemple chinois
* publication corrective 1.2.11.1 : rendre les boutons audio des pages HTML fonctionnels
#### [source git](https://github.com/lojban/cll/compare/geklojban-1.2.11)
#### Comparaison du code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.10 août 2020' : différence git](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [Comparé à la version officielle du CLL v.1.1 (2016) : différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)
### geklojban-1.2.10 août 2020

#### Version compilée
* Lisez le document final qui doit être utilisé pour l'impression et la publication. Remarquez que la page de titre indique explicitement que le document est "geklojban-1.2.10" et que le nom de l'organisation qui l'a publié est différent de l'LLG ; cela est fait pour souligner qu'il ne s'agit pas d'une publication de l'LLG :
    * [Format PDF](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    * [Format HTML, une page équivaut à une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    * [Format HTML - le livre entier sur une seule page très longue](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* ou lisez le soi-disant "document de différence" au format PDF qui compare geklojban-1.2.10 au CLL publié en 2016 (version du 27 août 2016). Le document a les insertions marquées en vert et préfixées par "ins\`" et les suppressions marquées en rouge et préfixées par "del\`". Les préfixes sont ajoutés afin que vous puissiez utiliser la combinaison de touches Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (mais vous devrez alors faire défiler le document manuellement pour trouver les différences).
*   ou lisez le document de différence au format HTML à la place :
    *   [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Courte liste des changements par rapport à la version précédente 'geklojban-1.2.9 juillet 2020'

* Un volume de Chrestomathie (textes sélectionnés) a été ajouté après le dernier chapitre
* Les points ne sont jamais omis dans les mots, même pas dans l'Index des mots en Lojban
#### [source git](https://github.com/lojban/cll/compare/geklojban-1.2.10)
#### Comparaison du code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.9 juillet 2020' : différence git](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Comparé à la version 'geklojban-1.2.3 janvier 2020' : différence git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.10)
* [Comparé à l'édition officielle du CLL v.1.1 (2016)' : différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)

### geklojban-1.2.9 juillet 2020

#### Version compilée
*   lisez le document final qui sera utilisé pour l'impression et la publication. Notez que la page de titre indique explicitement que le document est "geklojban-1.2.9" et que le nom de l'organisation qui l'a publié est différent de la LLG; cela est fait pour souligner qu'il ne s'agit pas d'une publication de la LLG:
    *   [Format PDF](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    *   [Format EPUB](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    *   [Format HTML, une page équivaut à une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    *   [Format HTML - le livre complet en une seule page très longue](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* ou lisez le prétendu document PDF "différence" qui compare geklojban-1.2.9 à la CLL publiée en 2016 (version du 2016-08-27). Le document contient des insertions marquées en vert et préfixées par "ins\`" et des suppressions marquées en rouge et préfixées par "del\`". Les préfixes sont ajoutés afin que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une autre version de différence sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (mais vous devrez alors parcourir manuellement le document pour trouver les différences).
*   ou bien lisez le document de différence au format HTML à la place:
    *   [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Liste succincte des modifications par rapport à la version précédente 'geklojban-1.2.8.1 juin 2020'

* La version HTML dispose désormais de tables et d'exemples défilants horizontalement sur les écrans étroits (par exemple, les appareils mobiles). Cela rend la version HTML plus adaptée aux mobiles.
* L'EPUB est à nouveau généré (il était manquant dans la version 1.2.8.1)
* Les symboles coréens et chinois sont maintenant affichés avec la police Noto CJK
* Les emplacements tels que "$x_1$" sont maintenant affichés avec des chiffres en exposant
* Un exemple dans la Section 16.9 {naku zo'u la djan. klama} ne correspondait pas aux autres exemples autour, il a donc été remplacé par {naku zo'u mi klama le zarci} (un bug signalé par [Corbin Simpson](https://github.com/MostAwesomeDude))
* Une définition du mot {bu'u} a été ajoutée à la liste des autres particules grammaticales de la classe FAhA
#### [source git](https://github.com/lojban/cll/compare/geklojban-1.2.9)
#### Comparaison du code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.8.1 juin 2020' : différence git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Comparé à la version 'geklojban-1.2.3 janvier 2020' : différence git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Comparé à l'édition officielle CLL v.1.1 (2016) : différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.9)
### geklojban-1.2.8.1 juin 2020

#### Version compilée
* lire le document final qui sera utilisé pour l'impression et la publication. Notez que la page de titre du document est explicitement marquée "geklojban-1.2.8.1" et que le nom de l'organisation qui l'a publié est différent de LLG ; cela est fait pour souligner qu'il ne s'agit pas d'une publication de LLG :
    *   [format PDF](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    *   [format HTML, une page correspond à une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    *   [format HTML - tout le livre sur une très longue page](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* ou lire le document PDF dit "différence" qui compare geklojban-1.2.8.1 au CLL publié en 2016 (version du 27-08-2016). Le document contient des insertions marquées en vert et avec le préfixe "ins\`", et des suppressions marquées en rouge et avec le préfixe "del\`". Les préfixes sont ajoutés pour que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version différence alternative sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (mais vous devrez alors faire défiler le document manuellement pour trouver les différences).
* ou lire le document de différence en format HTML à la place :
    *   [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Liste courte des changements par rapport à la version précédente 'geklojban-1.2.7 Mai 2020'

* Une nouvelle orthographe "diacritique" nommée "zbalermorna" a été ajoutée. Elle est clairement mentionnée comme non officielle. Ses symboles ("lettres") sont affichés avec une police appropriée. Bravo à [Jack Humbert](https://jackhumbert.github.io/zbalermorna/) et à son équipe (la saski'o, la xaspeljba et d'autres) pour la police et la révision de l'explication de l'orthographe.
* Les index ont été révisés (presque toutes leurs 4000 entrées). De nombreuses entrées ont été modifiées pour plus de facilité d'utilisation ou ont été déplacées de l'Index des mots Lojban à l'Index général ou inversement.
* la règle pour l'utilisation de la virgule est [revertée](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) à la version du CLL 1.1 
* un algorithme de différence amélioré pour visualiser les différences entre les versions (sans encombres supplémentaires)
* version 1.2.8.1 correction de programme : problèmes résolus concernant l'affichage des symboles zbalermorna dans le document PDF
#### [source git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)

#### Comparaison de code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.7 mai 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Comparé à la version 'geklojban-1.2.3 janvier 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Comparé à l'édition CLL v.1.1 officielle (2016)': différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)
### geklojban-1.2.7 Mai 2020
#### Version compilée
*   lire le document final qui sera utilisé pour l'impression et la publication. Remarquez que la page de titre du document est explicitement marquée comme étant "geklojban-1.2.7" et que le nom de l'organisation qui l'a publié est différent de LLG ; ceci est fait pour souligner qu'il ne s'agit pas d'une publication LLG :
    *   [format PDF](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    *   [format EPUB](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    *   [format HTML, une page est une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    *   [format HTML - tout le livre en une seule page très longue](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* ou lire le document PDF appelé ["différence"](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference_prefixed.pdf) qui compare geklojban-1.2.7 à la CLL publiée en 2016 (version du 27 août 2016). Les insertions sont marquées en vert et avec le préfixe "ins\`" et les suppressions sont marquées en rouge et avec le préfixe "del\`". Les préfixes sont ajoutés afin que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative sans préfixes de différence](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (mais vous devrez alors faire défiler manuellement le document pour trouver les différences).
*   ou lire le document de différence au format HTML :
    *   [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Courte liste de modifications par rapport à la version précédente 'geklojban-1.2.6 avril 2020'

* "Le cmavo tu'a est utilisé pour former des abstractions et est expliqué plus en détail dans la Section 11.11.", mais il n'est pas du tout mentionné dans cette section. Changé la référence en Section 11.10. Le bug est remarqué par [Robert Baruch](https://github.com/RobertBaruch).
* toutes les références aux selma'o sont déplacées de l'index des mots lojban à l'index général de l'appendice.
* Section 10.18. La phrase "Contrairement à la négation contradictoire -nai, la négation scalaire des temps n'est pas limitée à PU et FAhA:" contredit le texte suivant de la section. Remplacé par "Un exemple de négation scalaire de FAhA :"
#### [source git](https://github.com/lojban/cll/compare/geklojban-1.2.7)

#### Comparaison du code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.6 avril 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Comparé à la version 'geklojban-1.2.3 janvier 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Comparé à l'édition officielle CLL v.1.1 (2016)': différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)
### geklojban-1.2.6 avril 2020
#### Version compilée
*   Lire le document final qui sera utilisé pour l'impression et la publication. Notez que la page de titre a explicitement marqué le document comme "geklojban-1.2.6" et a le nom de l'organisation qui l'a publié différent de LLG; cela est fait pour souligner qu'il ne s'agit pas d'une publication LLG :
    *   [Format PDF](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [Format EPUB](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [Format HTML, une page est une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [Format HTML - Tout le livre en une très longue page](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* ou lire le soi-disant document PDF "difference" qui compare geklojban-1.2.6 avec le CLL publié en 2016 (version du 27-08-2016). Le document a des insertions marquées en vert et le préfixe "ins\`" et des suppressions marquées en rouge et le préfixe "del\`". Les préfixes sont ajoutés afin que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version alternative de différence sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (mais vous devrez alors faire défiler manuellement le document pour trouver les différences).
*   ou lire le document de différence en format HTML à la place :
    *   [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Courte liste de changements par rapport à la version précédente 'geklojban-1.2.5 mars 2020'
* de nouvelles images haute résolution pour plusieurs chapitres créées par [la ninpre](https://github.com/la-ninpre) (violation possible de droits d'auteur rejetée)
* la règle 'les virgules ne sont jamais nécessaires' est désormais temporairement limitée aux virgules qui sont des séparateurs de syllabes
* ajout de plusieurs liens vers diverses selma'o dans l'index des mots lojban
#### [source git](https://github.com/lojban/cll/compare/geklojban-1.2.6)#### Comparaison du code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.5 mars 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.5...geklojban-1.2.6)
* [Comparé à la version 'geklojban-1.2.3 janvier 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.6)
### geklojban-1.2.5 mars 2020

#### Version compilée
*   lisez le document final qui doit être utilisé pour l'impression et la publication. Notez que la page de titre du document est explicitement marquée comme "geklojban-1.2.5" et que le nom de l'organisation qui l'a publié est différent de celui de LLG ; cela est fait pour souligner qu'il ne s'agit pas d'une publication de LLG :
    *   [format PDF](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    *   [format EPUB](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    *   [format HTML, une page est une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    *   [format HTML - tout le livre sur une seule page très longue](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* ou lisez le soi-disant document PDF de "différence" qui compare geklojban-1.2.5 à la CLL publiée en 2016 (version du 27-08-2016). Le document présente les insertions en vert et avec le préfixe "ins\`" et les suppressions en rouge et avec le préfixe "del\`". Les préfixes sont ajoutés pour que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il existe [une version de différence alternative sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (mais alors vous devrez faire défiler manuellement le document pour trouver les différences).
*   ou lisez le document de différence au format HTML à la place :
    *   [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Courte liste des changements par rapport à la version 'geklojban-1.2.3 janvier 2020'
* suppression temporaire de l'utilisation controversée de ni+ce'u
* utilisation d'un meilleur exemple pour NU JA NU, suppression de l'expansion de NU JA NU (qui peut ne pas être ambiguë en cas de plusieurs NU JA NU dans un bridi)
* ajout de hanzi et de pinyin plus joli aux exemples chinois
* Dotside : Ajout d'un coup de glotte initial à la transcription IPA dans un exemple
* ajout de "FA selma'o" à l'index des mots lojban
* la règle "les virgules ne sont jamais obligatoires" est temporairement limitée aux cmevla uniquement
* quelques erreurs de frappe sont corrigées
* les symboles UTF sont ajoutés tels quels (au lieu de leurs descriptions)
*   Dotside implémenté
*   les concepts de "cmene" et "cmevla" sont maintenant séparés
*   **sumti tcita** est renommé en **sumtcita**
*   **mi kucli le jei broda** est maintenant **mi kucli tu'a le jei broda**
*   Le dictionnaire avec des exemples est désormais techniquement possible : le glossaire peut désormais avoir des exemples sous les définitions des mots (et le fait pour le mot **coi** comme démonstration)
*   les rafsi pour **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** sont modifiés selon le cmavo.txt de l'année 2002.
*   une immense quantité de fautes de frappe et d'erreurs mineures sont corrigées.
#### [Source git](https://github.com/lojban/cll/compare/geklojban-1.2.5)

#### Comparaison de code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.4 Février 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Comparé à la version 'geklojban-1.2.3 Janvier 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)

### geklojban-1.2.4 Février 2020
#### Version compilée
*   lire le document final qui sera utilisé pour l'impression et la publication. Notez que la page de titre a explicitement marqué le document comme étant "geklojban-1.2.4" et a le nom de l'organisation qui l'a publié différent de LLG ; cela est fait pour souligner qu'il ne s'agit pas d'une publication de LLG :
    *   [Format PDF](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    *   [Format EPUB](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    *   [Format HTML, une page est une section du livre](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    *   [Format HTML - l'ensemble du livre en une seule page très longue](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* ou lire le soi-disant document "différences" en PDF qui compare geklojban-1.2.4 à CLL publié en 2016 (version du 27-08-2016). Le document a des insertions marquées en vert et un préfixe "ins\`" et des suppressions marquées en rouge et un préfixe "del\`". Les préfixes sont ajoutés pour que vous puissiez utiliser Cmd+F ou Ctrl+F pour trouver rapidement les différences dans le document PDF. Il y a [une version différente alternative sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (mais alors vous devrez faire défiler manuellement le document pour trouver les différences).
*   ou lire le document de différence en format HTML à la place :
    *   [avec préfixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sans préfixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Courte liste des changements par rapport à la version 'geklojban-1.2.3 Janvier 2020'
* quelques erreurs de frappe sont corrigées
* des symboles UTF sont ajoutés tels quels (et non sous forme de descriptions)
#### [Source git](https://github.com/lojban/cll/compare/geklojban-1.2.4)
#### Comparaison de code source avec les versions précédentes
* [Comparé à la version 'geklojban-1.2.3 Janvier 2020': différence git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Comparé à l'édition officielle de CLL v.1.1 (2016)': différence git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)
### geklojban-1.2.3 Janvier 2020

#### Courte liste de changements

*   Implémentation de Dotside
*   Les concepts **cmene** et **cmevla** sont maintenant séparés
*   **sumti tcita** est renommé en **sumtcita**
*   Il est maintenant techniquement possible d'avoir un dictionnaire avec des exemples : le glossaire peut maintenant avoir des exemples sous les définitions des mots (et c'est le cas pour le mot **coi** comme démonstration)
*   Les rafsi pour **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** sont modifiés selon le cmavo.txt de l'année 2002.
*   Un nombre immense de fautes de frappe et d'erreurs mineures ont été corrigées

#### [source git](https://github.com/lojban/cll/compare/geklojban-1.2.3)