---
title: Des verbes compliqués en lojban ?
---

<!-- Author of trans-creation (translation, localisation, adaptation to culture): Sukender (Benoit NEIL) -->
<!-- Source language: English, + machine-based translation -->
<!-- Target language: FR_fr - Français, France (orthographe moderne, dite "1990") -->
<!-- Special additions or changes (compared to the source) are tagged with "L10N" in this source code: "L10N: <somme additional info>" -->

<div class="lojbo simple_blockquotes"></div>

## Question

Les définitions des verbes en lojban, telles que

> *$x_1$ court sur la surface $x_2$ en utilisant les membres $x_3$ avec une démarche $x_4$*

semblent difficiles à apprendre car pratiquement chaque verbe a sa structure propre, avec des emplacements ($x_1$, $x_2$...) différents. N'y a-t-il pas plus facile à retenir ? Pourquoi lojban est-il conçu de cette manière ?

## Réponse

<!-- L10N: Added example -->
Tout d'abord, il faut savoir que la langue française a des similarités avec ce fonctionnement. Par exemple, pour le verbe "courir", on peut s'attendre à des compléments circonstanciels de lieu, de temps, de manière, du cause, et tout un tas d'autres compléments. Chacun de ces compléments est introduit d'une manière différente (adverbe, pronom, proposition, etc.). On peut ainsi "courir vers...", "courir depuis...", "courir sur...", "courir vite", "courir sur les mains"... Les possibilités sont innombrables.

La différence ici, c'est que le dictionnaire lojban définit explicitement la structure des emplacements, tandis que la plupart des dictionnaires français ne le font pas. La raison à cela est justement d'éviter d'avoir une préposition distincte pour chaque cas, ce qui serait encore plus lourd à apprendre.

Et puis, imaginez que l'on se retrouve avec :

> *Je compte à toi (?!)*

Avec un ensemble limité de prépositions comme dans beaucoup de langues, le lojban deviendrait subjectif, très loin d'être universel. En effet, en français, on dit :

> *Je compte sur toi*

alors qu'en russe cela se traduit par quelque chose comme :

> Je compte de toi

De plus, certaines prépositions ou formulations pourraient être ambigües. Cela rendrait les choses bien plus hasardeuses qu'avec le système actuel des emplacements.

Ce système n'est d'ailleurs pas si lourd. La plupart des verbes en lojban n'ont que trois emplacements ($x_1$, $x_2$, $x_3$). Seule une trentaine de verbes de base (*lo gismu*) en ont cinq. De plus, il n'est pas nécessaire de connaitre les emplacements de chaque verbe pour parler couramment lojban. Et puis, a-t-on besoin des emplacements du verbe "être un sinus" (fonction trigonométrique) ? Surtout lorsqu'on discute de cuisine !

<!-- L10N: Specific to French language -->
Il est intéressant de noter qu'en français, le complément d'objet direct (COD) se comporte assez souvent comme la première "place" lojban ($x_1$). Par exemple, "donner quelque chose" ("Je donne un cadeau."). Ce complément ne nécessite d'ailleurs pas de préposition, contrairement à d'autres ("donner À quelqu'un").

De plus, en français et contrairement au lojban, certaines formulations "à priori correctes grammaticalement" ne sont pas utilisables. Elles doivent être reformulées pour obtenir la "bonne" façon de dire. On peut ainsi "donner à Sophie", mais pas "donner à toi" ; il convient de dire "te donner".

Comme exposé précédemment, l'utilisation de prépositions est dépendante de la langue :

> [Anglais] *I think of you* (Je pense de toi)

> [Russe] *Ya dumayu o tebe* (Je pense à propos de toi)

> [Espagnol] *Yo pienso en ti* (Je pense en toi)

Alors certes, il y a des "emplacements" en lojban qui sont moins évidents que d'autres. Mais c'est aussi le cas de la structuration des expressions en français. Pourquoi choisit-on généralement "Je vais suivre Maé" plutôt que l'inverse ("Maé va me précéder") ?...

Pour faciliter l'apprentissage, les verbes en lojban peuvent être regroupés par type de structure. Par exemple :

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=mlatu&bangu=en&versio=masno">mlatu</a> - $x_1$ est un chat de l'espèce $x_2$

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=gerku&bangu=en&versio=masno">gerku</a> - $x_1$ est un chien de l'espèce $x_2$

## La structure est facile à apprendre mais...

Souvent, les emplacements sont intuitifs à apprendre. Mais pas toujours. Ce qui tourne autour du concept de mouvement, notamment, présente des emplacements disparates :

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a> - $x_1$ (objet) bouge vers $x_2$ depuis l'origine $x_3$ sur le chemin/le trajet $x_4$.

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> - $x_1$ court sur la surface $x_2$ en utilisant les membres $x_3$ avec une démarche $x_4$.

Pourquoi ne pas avoir une seule structure d'emplacements pour tous ?

## Réponse

<a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=fr&versio=masno">muvdu</a>, <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=fr&versio=masno">bajra</a> et <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=cadzu&bangu=fr&versio=masno">cadzu</a> décrivent un processus similaire mais avec des perspectives très différentes. Dans <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=fr&versio=masno">bajra</a>, l'origine et la destination ne sont pas importantes ; l'accent est mis sur l'action. Ce n'est pas "courir depuis, vers" comme en français. Il ne faut d'ailleurs pas confondre les traductions en français avec le sens du verbe lojban : les traductions ne sont que des approximations. Ici, <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=fr&versio=masno">bajra</a> signifie avoir une certaine démarche, tout en touchant une surface (avec des membres), et le faire rapidement.

Une personne qui utilise un tapis de course n'a pas de destination ("vers") ou d'origine ("de") mais court simplement sur place. C'est un bon exemple dans lequel utiliser **bajra** plutôt que **klama**.

Pour conclure, il faut simplement retenir que le lojban n'est ni un "français simplifié" ni une transcription directe, même si le dictionnaire lojban-français peut parfois le laisser penser.

C'est notamment dû au fait que les langues naturelles (dont le français) possèdent des ambigüités. Ce n'est pour le coup pas un défaut du lojban.

Notez enfin, que l'on peut toujours combiner les verbes (**lo tanru**) pour préciser. Par exemple **bajra klama** ("courir-aller") permet d'exprimer à la fois le fait de courir, et le fait de se déplacer d'un point à un autre.
