## Lección 9. Conjunciones lógicas

Las conjunciones lógicas en Lojban se basan en 4 primitivas: **.a**, **.e**, **.o**, **.u**. En esta lección, las cubriremos en detalle.

### Conjunciones lógicas para argumentos

Aquí están las conjunciones que combinan dos palabras: _esto_ y _eso_.

- **ti .a ta** = _esto y/o eso_

 > **mi ba vitke le mamta .a le tamne**
 >_Visitaré a la madre o al primo._

 Ten en cuenta que **.a** también puede traducirse como _al menos uno de los dos valores_, y por lo tanto deja abierta la posibilidad de que los visite a ambos en algún momento.

- **ti .e ta** = _esto y eso_

 > **mi ralte le pa gerku .e le re mlatu**
 >_Tengo un perro y dos gatos._
 >`Tengo un perro y dos gatos.`

- **ti .o ta** = _o esto y eso, o ninguno_

 > **mi ba vitke le mamta .o le tamne**
 >_Visitaré tanto a la madre como al primo, o a ninguno de ellos._

- **ti .u ta** = _esto, y tal vez eso_, _esto, independientemente de eso_

 > **mi ba vitke le mamta .u le tamne**
 >_Visitaré a la madre, independientemente de si visitaré al primo o no._

 **.u** simplemente enfatiza que el segundo valor no afecta la verdad de la oración.

Colocar **nai** después de una conjunción niega lo que está a su derecha. Colocar **na** antes de una conjunción niega lo que está a su izquierda:

- **ti .e nai ta** = _esto y no eso_

 > **mi nelci la .bob. e nai la .alis.**
 >_Me gusta Bob pero no Alice._
 >`Me gusta Bob y no Alice`

 También podemos decir **ti .e nai ku'i ta** (_esto pero no eso_) agregando un matiz de contraste para el segundo argumento.

- **ti na .e ta** = _no esto pero eso_

 > **mi nelci la .alis. na .e la .bob.**
 >_No me gusta Alice pero sí me gusta Bob._
 >`No me gusta Alice y sí me gusta Bob`

 Esto puede sonar un poco extraño para los hablantes de inglés (`No me gusta Alice y sí...`), por lo que podrías preferir intercambiar los argumentos y usar **.e nai** en su lugar: **mi nelci la .bob. e nai la .alis.** o incluso **mi nelci la .bob. i mi na ku nelci la .alis.** significarán lo mismo.

- **ti na .e nai ta** = _ni esto ni aquello (ninguno)_

 > **mi no me gusta ni Alicia ni Bob**
 > _No me gusta ni Alicia ni Bob_

Negar con otras conjunciones primitivas puede no parecer intuitivamente utilizable, simplemente puedes aprenderlas a través de ejemplos:
- **ti .a nai ta** = _esto si aquello_, _para que esto ocurra, la condición exclusiva es que_

 > **Voy a visitar a mi madre pero para que eso suceda necesito visitar a mi primo.**
 > _Mi ba vitke le mamta .a nai le tamne_

 Por lo tanto, **ti .a nai ta** significa que **ta** es necesario (pero puede no ser la única condición) para que se aplique **ti**.

- **ti .o nai ta** = _o esto o aquello_

 > **Voy a visitar a mi madre o a mi primo.**
 > _Mi ba vitke le mamta .o nai le tamne_

 Si quiero decir que visitaré a mi madre o a mi primo pero no a ambos, necesito **.o nai** (_o uno u otro_). A diferencia de **.a** (_y/o_) donde puedo visitar a ambos.

- **ti na .u ta** = no influye _(no esto, pero tal vez aquello)_
- **ti na .u nai ta** = no influye _(no esto, pero tal vez aquello)_

- **ti se .u ta** = _tal vez esto, y aquello_
- **ti se .u nai ta** = _tal vez esto pero no aquello_

<!-- **se** se usa solo para **.u** porque en otros casos no tiene efecto en el significado. -->

Estos se usan para conectar argumentos. Para conectar partes de relaciones compuestas, usamos conjunciones similares: **ja**, **je**, **jo**, **ju**. Así que en lugar del punto (pausa) usamos **j** aquí.

<!-- También es común usar **ja**, **je**, **jo**, **ju** para conectar argumentos. -->

### Conjunciones lógicas para oraciones

Esta es una forma más concisa de decir:

> **Tengo un perro, y tengo dos gatos.**
> _Mi ralte le pa gerku .i je mi ralte le re mlatu_

**.i je** une dos oraciones con un _y_ lógico, mostrando que ambas oraciones son parte de un mismo pensamiento y son verdaderas.

Aquí hay ejemplos de otras conjunciones para oraciones:

> **Romeo ama a Julieta, <u>y</u> Julieta ama a Romeo.**
> _La .rome'os. cu prami la .djuliet. i je la .djuliet. cu prami la .rome'os._

Esto significa que ambas afirmaciones son verdaderas, es decir, Romeo y Julieta se aman mutuamente.

Las mismas reglas se aplican a otras conjunciones:

> **la .rome'os. cu prami la .djuliet. i ja la .djuliet. cu prami la .rome'os.**
> _Romeo ama a Julieta, y/o Julieta ama a Romeo._

Esto significa que uno de ellos ama al otro, y tal vez ambos lo hacen.

> **la .rome'os. cu prami la .djuliet. i jo nai la .djuliet. cu prami la .rome'os.**
> _Ya sea que Romeo ame a Julieta o que Julieta ame a Romeo._

Aquí, o bien Romeo ama a Julieta (pero ella no lo ama), o Julieta ama a Romeo (pero él no la ama).

> **la .rome'os. cu prami la .djuliet. i ja nai la .djuliet. cu prami la .rome'os.**
> _Para que Romeo ame a Julieta, es necesario que Julieta ame a Romeo._

Esto significa que si Julieta ama a Romeo, él definitivamente la ama, pero él puede amarla de todos modos (la única posibilidad imposible es que Julieta ame a Romeo pero él no la ame).

> **la .rome'os. cu prami la .djuliet. i jo la .djuliet. cu prami la .rome'os.**
> _Ya sea que Romeo ame a Julieta y Julieta ame a Romeo, o ninguno de los dos eventos ocurra._

Esto significa que si Julieta ama a Romeo, él la ama, y si ella no lo ama, él no la ama.

> **la .rome'os. cu prami la .djuliet. i ju la .djuliet. cu prami la .rome'os.**
> _Romeo ama a Julieta, ya sea que Julieta lo ame o no._

Observa cómo lojbanizamos el nombre "Romeo": la combinación "eo" es imposible en lojban, así que usamos "e'o" y agregamos una consonante al final de su nombre.

Ten en cuenta que **da** se refiere a la misma entidad cuando se conectan varias oraciones.

### Conjunciones lógicas dentro de relaciones compuestas

> **le melbi xunre fonxa**
> _teléfonos hermosamente rojos_

<!-- -->

> **le melbi je xunre fonxa**
> _teléfonos hermosos y rojos_

Otras conjunciones también tienen sentido:

> **mi nelci ro tu voi xajmi ja melbi prenu**
> _Me gustan todas las personas que son divertidas o guapas (o ambas)._

<!-- -->

> **mi nelci ro tu voi xajmi jo nai melbi prenu**
> _Me gustan todas las personas que son o divertidas o hermosas._

Esto podría explicarse si, por ejemplo, encuentro que las cualidades del humor y la belleza son incompatibles, es decir, una mezcla de ambas sería demasiado.

> **mi nelci ro tu voi xajmi ju melbi nanmu**
> _Me gusta todas las personas que son divertidas (sin importar si son hermosas o no)._

Y una vez más, no debemos olvidar la diferencia entre conectar argumentos y conectar partes de construcciones de relaciones compuestas:

> **mi ba vitke le pa pendo .e le pa speni**
> _Voy a visitar a un amigo y a un cónyuge._

<!-- -->

> **mi ba vitke le pa pendo je speni**
> _Voy a visitar a un amigo-y-cónyuge._

La última frase en Lojban significa que el amigo también es un cónyuge.

### Conjunciones lógicas para colas de relaciones

> **pu ku mi uantida la .soker. gi'e klama le zdani gi'e citka le badna**
> _Jugué al fútbol, fui a casa, comí la banana._

uantida
: relación no oficial: $x_1$ juega el juego $x_2$, participa en el juego $x_2$

**gi'e** conecta varias relaciones en una con algunos términos compartidos. Mira esto: Se expande en **pu ku mi kelci la .soker. i je pu ku mi klama le zdani** ... lo cual sería más largo.

Con **gi'e**, mantenemos la cabeza de la relación constante y especificamos los términos después de cada una de las construcciones de relación (**kelci la .soker.**, **klama le zdani** ...).

Así, al usar **gi'e**, tenemos varias relaciones en la cola unidas pero con una cabeza común.

**gi'e** tiene la misma vocal final que en **je** y por lo tanto significa _y_.

Otras conjunciones para unir colas de relaciones:

- **gi'a** para _y/o_
- **gi'o nai** para _ya sea ... o_
- **gi'u** para _si o no_, etc.

Estas conjunciones tienen el mismo final que las de la serie **.a**, **.o**, **.u**.

### Términos en oraciones con varias colas

Ten en cuenta que los tiempos como términos y los tiempos adjuntos a la relación principal de la relación hacen una diferencia cuando se aplican a oraciones que contienen varias relaciones adjuntas:

- Un término en la cabeza de la oración se aplica a todas sus colas:

 > **mi ba'o cu citka le badna gi'e pinxe**
 > _Ya no como la banana y ya no bebo._

 Aquí, **ba'o** se aplica a **citka le badna gi'e pinxe**.

- Una palabra de tiempo que es parte de la relación se aplica solo a esa relación:

 > **mi ba'o citka le badna gi'e pinxe**
 > _Ya no como la banana, pero sí bebo._

Aquí, **ba'o** se aplica solo a la relación implícita **mi citka le badna**, pero no a la relación implícita **mi pinxe**.

### Preguntas de elección

Otro tipo de "o" en inglés se encuentra en preguntas:

> **— xu do pinxe le tcati .o nai le ckafi?**
> **— pinxe**
> _— ¿Vas a tomar té o café?_
> _— Sí._

Esa es una respuesta peculiar, pero perfectamente razonable: _Sí, voy a tomar té o café._

Esto sucede porque "o" tiene varios significados en inglés:

1. _A o B_ puede significar _o bien A, o bien B pero no ambos_. Usamos **.o nai** aquí.
2. _A o B_ puede significar _A o B o ambos_. Usamos **.a** aquí.
3. _¿A o B?_ puede ser una pregunta que significa _elige entre A y B, ¿cuál eliges?_ Usamos **ji** aquí.

Por lo tanto, en el último caso, usamos una conjunción de pregunta separada **ji**:

> **— do pinxe le tcati ji le ckafi?**
> _— ¿Vas a tomar té o café?_

Respuestas posibles:

> **le tcati .e le ckafi**
> _Té y café._

<!-- -->

> **le tcati**
> _Té._

<!-- -->

> **le ckafi**
> _Café._

También es posible usar conjunciones al responder:

> **.e** — <span>_Ambos_ (se elige el primer y el segundo elemento)</span>

<!-- -->

> **.e nai** — <span>_El primero (té)_ (se elige el primero pero no el segundo)</span>

<!-- -->

> **na .e** — <span>_El segundo (café)_ (no se elige el primero pero sí el segundo)</span>

<!-- -->

> **na .e nai** — <span>_Ninguno_ (no se elige ni el primero ni el segundo)</span>

Puedes hacer preguntas de la misma manera sobre los otros tipos de conjunciones que hemos visto. La conjunción interrogativa para las relaciones de cola es **gi'i**, para las relaciones compuestas es **je'i**, para las oraciones es **.i je'i**.

Las preguntas indirectas se logran usando **ji kau**:

Imagina que el camarero le pregunta a un visitante:

> **- le'e dembi ji le'e rismi**
> _- ¿Las habichuelas o el arroz?_

Una vez que el visitante responde, el camarero sabe si el visitante quiere comer cordero o carne de res:

> **ba le nu le vitke cu spusku kei le bevri cu djuno le du'u le vitke cu djica le nu ri citka le'e dembi ji kau le'e rismi**
> _Después de que el visitante responde, el camarero sabe si el visitante quiere comer las habichuelas o el arroz._

### Conjunciones de previsión

> **ge do gi mi**
> _tanto tú como yo_

<!-- -->

> **ge nai do gi mi**
> _No tú, sino yo_

<!-- -->

> **ge do gi nai mi**
> _Tú, pero no yo_

<!-- -->

> **go nai do gi mi**
> _O tú o yo_

La conjunción de previsión **ge** significa _y_, pero se coloca antes del primer término del argumento, con **gi** separando los dos argumentos. Esta serie es paralela a otras conjunciones: **ga**, **ge**, **go**, **gu**, así como **ga nai**, **ge nai**, **go nai**, etc. El separador **gi** es el mismo para todas ellas.

El uso de estas conjunciones es una cuestión de conveniencia:

> **mi citka ge nai le badna gi le plise**
> _Yo no como el plátano sino la manzana._

Aquí, al igual que en inglés, _no_ se coloca antes del primer argumento.

**ge** y las palabras de esta serie también se pueden utilizar para conectar relaciones:

> **ge mi dansu gi mi zgipli le pipno**
> _Yo tanto bailo como toco el piano._

zgipli
: $x_1$ toca el instrumento musical $x_2$

le pipno
: piano

> **.i ga nai pu zi carvi gi ca cilmo**
> _Si ha estado lloviendo recientemente, ahora está mojado._