## Lección 7. Letras, referencias a relaciones, fechas

### Nombres de las letras en Lojban

Cada letra tiene un nombre en Lojban.

La siguiente tabla representa el alfabeto básico de Lojban y cómo pronunciar las letras (debajo de cada letra):

<table>
<tbody><tr>
<td>'
</td>
<td><b><font  class="guibutton" color="#FF1493">a</font></b>
</td>
<td>b
</td>
<td>c
</td>
<td>d
</td>
<td><b><font  class="guibutton" color="#FF1493">e</font></b>
</td></tr>
<tr>
<td><b>.y'y.</b>
</td>
<td><b>.a bu</b>
</td>
<td><b>by.</b>
</td>
<td><b>cy.</b>
</td>
<td><b>dy.</b>
</td>
<td><b>.ebu</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>f
</td>
<td>g
</td>
<td><b><font  class="guibutton" color="#FF1493">i</font></b>
</td>
<td>j
</td>
<td>k
</td>
<td>l
</td></tr>
<tr>
<td><b>fy.</b>
</td>
<td><b>gy.</b>
</td>
<td><b>.i bu</b>
</td>
<td><b>jy.</b>
</td>
<td><b>ky.</b>
</td>
<td><b>ly.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>m
</td>
<td>n
</td>
<td><b><font class="guibutton" color="#FF1493">o</font></b>
</td>
<td>p
</td>
<td>r
</td>
<td>s
</td></tr>
<tr>
<td><b>my.</b>
</td>
<td><b>ny.</b>
</td>
<td><b>.o bu</b>
</td>
<td><b>py.</b>
</td>
<td><b>ry.</b>
</td>
<td><b>sy.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>t
</td>
<td><b><font  class="guibutton" color="#FF1493">u</font></b>
</td>
<td>v
</td>
<td>x
</td>
<td><b><font  class="guibutton" color="#FF1493">y</font></b>
</td>
<td>z
</td></tr>
<tr>
<td><b>ty.</b>
</td>
<td><b>.u bu</b>
</td>
<td><b>vy.</b>
</td>
<td><b>xy.</b>
</td>
<td><b>.y bu</b>
</td>
<td><b>zy.</b>
</td></tr></tbody></table>

Como puedes ver:

- para obtener el nombre de una vocal, agregamos la palabra **bu**.
- para obtener el nombre de una consonante, agregamos **y.** a la consonante.
- la palabra para el **'** (apóstrofe) es **.y'y**.

Podemos deletrear palabras usando estos nombres. Por ejemplo, CNN será **cy. ny. ny.**

<!-- Una letra mayúscula sola tiene un significado especial. Denota el nombre de esa letra:

**A** es lo mismo que **.abu**, **B** es lo mismo que **by.** y así sucesivamente. Significan lo mismo e incluso se leen igual que **.abu**, **by.** etc. Por lo tanto, _CNN_ también se puede escribir como **CNN** en Lojban y aún se pronunciará y significará lo mismo que **cy. ny. ny.** -->

### Letras en lugar de 'él' y 'ella'

Una cadena de uno o más nombres de letras puede funcionar como un pronombre, proporcionando un método alternativo para referirse a argumentos mencionados anteriormente en el discurso.

> **la .alis. pu klama le nurma .i le nurma cu melbi la .alis.**
> **la .alis. pu klama le nurma .i ri melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi .a bu**
> _Alice fue al campo. El área rural es hermosa para Alice._
> _Alice fue al campo. Es hermoso para ella._

Todas las variantes en Lojban tienen el mismo significado.

Dado que la primera letra en **.alis.** es **a** (ignorando el punto) y la primera letra en **nurma** es **n**, podemos usar palabras de letras para referirnos a esos argumentos correspondientemente:

- **.a bu** se refiere a **la .alis.**
- **ny.** se refiere a **le nurma**

Este método puede ser más conveniente que el inglés _he_ o _she_, o incluso el lojban **ri** o **ra**. Nos permite hacer el discurso más conciso pero preciso, sin tener que repetir nombres potencialmente largos u otros términos de argumentos repetidamente.

Sin embargo, es importante tener en cuenta que puede haber situaciones en las que queramos referirnos nuevamente, por ejemplo, a **le nurma**, pero otro argumento que comienza con **n** aparece en el ínterin, lo que hace que **ny.** no pueda referirse al área rural. En tales casos, la solución más rápida es repetir todo el argumento, es decir, decir **le nurma**:

> **bu'u le nurma la .alis. pu penmi la .nik. i ri se zdani bu'u le nurma**
> _En el campo, Alice conoció a Nick. Él tiene su hogar en el campo._

zdani
: ...es un hogar para...

se zdani
: ...tiene un hogar..., ...vive en...

Si un nombre consiste en varias cmevla, puedes usar las primeras letras para referirte a ese nombre. Lo mismo se aplica a las relaciones compuestas:

> **la .djan.smit. cu citka le glare stasu .i dy.sy. nelci fy.sy.**
> _John Smith está comiendo la sopa caliente. A él le gusta._

glare
: ...es caliente

**dy.sy.** es un pronombre único. Lo mismo se aplica a **fy.sy.**.

Si necesitas poner varios pronombres uno después de otro, sepáralos con la palabra **boi**:

> **mi klama la .paris. la .moskov.**
> _Voy a París desde Moscú._

<!-- -->

> **mi klama py. boi my.**
> _Voy a P desde M._

La frase **mi klama py. my.** significaría _Voy a PM_, lo cual tendría un significado diferente.

> **la .tom.silver. pu zvati .i je'u ty. sy. boi .ui pu sidju mi**
> _Tom Silver estuvo presente. Y de hecho, TS (¡yay!) me ayudó._

Si colocas una interjección después de esas letras, sepáralas con **boi**. Sin **boi**, las interjecciones se referirán a la última letra.

### Diferentes formas de decir "_nosotros_" en Lojban

En Lojban, hay varios pronombres que se acercan en significado a "_nosotros_":

mi'o
: tú y yo

mi'a
: nosotros sin ti

ma'a
: tú, yo y otros

Así que, al hablar, debes tener cuidado con el significado de "_nosotros_" que necesitas.

Y finalmente:

mi
: yo o los hablantes

**mi** también puede significar "_nosotros_"! Lojban no hace distinción entre singular y plural de forma predeterminada. Por lo tanto, si varias personas están hablando juntas, **mi** (que se refiere a uno o más hablantes) es perfectamente correcto para "_nosotros_". En la práctica, generalmente encontrarás que **mi** se usa de esta manera cuando una persona presume hablar (o más a menudo, escribir) en nombre de otros.

Algunos ejemplos:

> **mi prami do**
> _Te amo._

<!-- -->

> **mi'a ba penmi do**
> _Nos encontraremos contigo._

<!-- -->

> **ma'a remna**
> _Todos somos humanos._

<!-- -->

> **mi djica le nu do cliva**
> _Queremos que te vayas._

cliva
: $x_1$ se va

### «**ri**» en lugar de ‘_he_’ y ‘_she_’

Anteriormente, aprendimos sobre el pronombre **ri**:

ri
: pronombre: se refiere al argumento anterior que acaba de finalizar (omitir pronombres estables como **mi**, **do**, palabras para _nosotros_)

> **mi catlu le nanmu .i ri melbi**
> _Miro al hombre. Él es guapo._

melbi
: $x_1$ es hermoso / bonito / guapo para alguien $x_2$

**ri** se refiere al argumento previo completado utilizado en el texto o en el discurso de alguien:

> **la .alis. cu sipna bu'u le sledi'u pe la .alis.**
> _Alice duerme en la habitación de Alice._
> `Alice duerme-en la habitación-de-Alice.`

> **la .alis. cu sipna bu'u le sledi'u pe ri**
> _Alice duerme en su habitación._
> `Alice duerme en la habitación de [término de argumento previo].`

sledi'u
: $x_1$ es una habitación con el propósito $x_2$ (proposición)

El **ri** es equivalente a repetir el último argumento, que en este caso es **la .alis.**.

Un aspecto a tener en cuenta es que **ri** no repite **le sledi'u pe ri** (que también es un argumento), porque **ri** es parte de ese argumento y, por lo tanto, ese argumento no es "anterior", no ha finalizado aún cuando **ri** aparece. Esto evita que **ri** se refiera recursivamente a sí mismo.

Otro ejemplo:

> **le du'u le prenu cu melbi cu se djuno ri**
> _Que la persona es bonita es conocido por ella misma._

El **ri** se refiere a **le prenu** (y no a **le du'u le prenu cu melbi** aunque ambos argumentos estén completos: **le prenu** comienza después del inicio de **le du'u le prenu cu melbi**).

La relación dentro de las formas **sei** forma un texto paralelo. **ri** omite los argumentos dentro de las relaciones **sei**:

> **mi viska la .lukas. sei la .doris. pu cusku .i ri jibni la .micel.**
> _Veo a Lucas, — dijo Doris. Él está cerca de Michelle._

En este ejemplo, **ri** no puede referirse a **la .doris.** Simplemente omitimos toda la relación **sei la .doris. pu cusku** al decidir a qué debe referirse **ri**.

Los pronombres que son estables a lo largo del diálogo o la historia son ignorados por **ri**. Los repetimos directamente:

> **mi lumci mi**
> _Me lavo._
> `Me lavo`

lumci
: $x_1$ lava a $x_2$

> **mi prami mi**
> _Me amo._
> `Me amo.`

Sin embargo:

- Los pronombres **ti**, **ta**, **tu** son recogidos por **ri** porque podrías haber cambiado a qué te estás refiriendo, por lo que repetir **tu** puede no ser efectivo.
- De manera similar, **ri** en sí mismo (o más bien, su antecedente) puede ser repetido por un **ri** posterior. De hecho, una cadena de palabras **ri** sin otros argumentos intermedios siempre repetirá el mismo argumento:

 > **la .alis. cu catlu le nanmu .i ri melbi .i ri co'a zgana .a bu**
 > _Alice nota a un hombre. Él es guapo. Él nota a Alice._

zgana
: observar

co'a zgana
: comenzar a observar, notar

En este ejemplo, el segundo **ri** tiene al primer **ri** como su antecedente, que a su vez tiene a **le nanmu** como su antecedente. Los tres se refieren a la misma cosa: el hombre.

En última instancia, tú decides qué, dónde y cuándo usar en el discurso: el método con **le** + relación, el método con nombres de letras o con **ri**.

<!-- ### "_Yo mismo, ellos mismos_"

En los idiomas eslavos, la gente dice literalmente _Yo lavo a mí mismo_. Para estar más cerca de un estilo eslavo, podemos usar **lo nei**.

>**mi nelci mi**
>_Me gusto a mí mismo._

>`Me gusto.`

Es lo mismo en significado que:

>**mi nelci lo nei**
>_Me gusto a mí mismo._

>**mi lumci mi**
>**mi lumci lo nei**
>_Me lavo a mí mismo._

>**la ian ca lumci lo nei**
>**la ian ca lumci ri**
>_Yan se lava a sí mismo._

**lo nei** se refiere al primer sustantivo de la relación actual.

Recuerda que **ri** no puede referirse a pronombres como **mi**, por lo que **lo nei** podría ser preferido en el último ejemplo. Al cambiar el primer sustantivo, **lo nei** no cambia, lo cual es bastante útil:

>**mi lumci lo nei i do lumci lo nei i la ian cu lumci lo nei**
>_Me lavo a mí mismo. Te lavas a ti mismo. Yan se lava a sí mismo._

>**la .doris. cu pensi lo nei**
>_Doris piensa en sí misma._

>**pa gerku cu batci lo nei**
>_Un perro se muerde a sí mismo._

---

**nei** funciona bien cuando una oración solo contiene una relación. Pero cuando tiene varias relaciones incrustadas, podríamos necesitar algo diferente. En

>**la .doris. cu djuno lo du'u la .alis. cu prami lo nei**
>_Doris sabe que Alice se ama a sí misma._

**lo nei** se refiere a **la .alis.**

¿Qué pasa si queremos referirnos a Doris? Aquí hay una solución:

>**la .doris. cu djuno lo du'u la .alis. cu prami vo'a**
>_Doris sabe que Alice la ama._

Entonces, mientras que **lo nei** se refiere al primer sustantivo de la relación actual, **vo'a** se refiere al primer sustantivo de la oración actual.

Cuando no hay relaciones incrustadas, estas dos palabras significan lo mismo:

>**la .alis. cu prami vo'a** es lo mismo que **la .alis. cu prami lo nei**
>_Alice se ama a sí misma._

- **vo'a** se refiere al primer sustantivo de la oración actual.
- **vo'e** se refiere al segundo sustantivo de la oración actual.
- **vo'i** se refiere al tercer sustantivo de la oración actual.
- **vo'o** se refiere al cuarto sustantivo de la oración actual.
- **vo'u** se refiere al quinto sustantivo de la oración actual.

---

**lo nei** puede dar resultados divertidos cuando se aplica a acciones mutuas:

>**la .alis. e la .kevin. cu cinba lo nei**
>_Alice se besa a sí misma, y Kevin se besa a sí mismo._

Aquí está la solución:

>**la .alis. jo'u la .kevin. cu cinba zu'ai**
>_Alice y Kevin se besan mutuamente._

Significa lo mismo que:

>**la alis cu cinba la kevin i je la kevin cu cinba la alis**
>_Alice besa a Kevin, y Kevin besa a Alice._

**zu'ai** se coloca en el segundo lugar del verbo. Muestra la acción mutua entre el primer lugar y el segundo lugar. Los miembros de esta acción mutua se colocan en el primer lugar y se conectan con la conjunción **jo'u**. -->

### «**go'i**» para la relación anterior

> **la .alis. cu klama le barja .i la .alis. cu viska le nanmu**
> **la .alis. cu klama le barja .i le go'i cu viska le nanmu**
> _Alice va al bar. Ella ve a un hombre._

- **le go'i** se refiere al primer lugar de la relación anterior.
  - **go'i** presenta otra forma de referirse a un argumento que necesitamos.
- **le se go'i** se refiere al segundo lugar de la relación anterior.
- **le te go'i** se refiere al tercer lugar, y así sucesivamente.

Ejemplos:

> **.i la .alis. cu zgana le nanmu .i ri melbi**
> **.i la .alis. cu zgana le nanmu .i le se go'i cu melbi**
> _Alice observa a un hombre. Él es guapo._

Aquí, **le se go'i** se refiere al segundo lugar ($x_2$) de la relación anterior, que es **le nanmu**.

Otro ejemplo:

> _Bill vio a Nick. Lo golpeó._

En inglés no se preocupa por la precisión aquí, _he_ simplemente significa _alguna persona masculina mencionada en algún lugar cercano en el texto o deducida del contexto_. ¿Bill golpeó a Bob o Bob golpeó a Bill? No lo sabemos. En Lojban, podemos decir:

> **la .bil. pu viska la .nik. .i le se go'i cu darxi le go'i**
> _Bill vio a Nick. Nick golpeó a Bill._

Sin embargo, en la mayoría de los casos, se pueden usar **ri** o palabras de letras:

> **la .bil. cu viska la .nik. i ri darxi la .bil.**
> **la .bil. cu viska la .nik. i ny. darxi by.**
> _Bill vio a Nick. Nick golpeó a Bill._

**go'i** en sí mismo es una palabra de relación, por lo que tiene una estructura de lugar:

> **mi tatpi .i do ji'a go'i**
> _Estoy cansado. Y tú también._

Cuando decimos **do go'i**, repetimos la relación anterior pero reemplazamos su primer lugar con **do**. En otras palabras, **do ji'a go'i** aquí es lo mismo que decir **do ji'a tatpi**.

<!-- ### ¿Qué copia **go'i**?

Interjecciones como **pei** (cuando se usa solo), **xu**, **.ui**, **.u'i**, **je'u** formadas con **sei** y la interjección de pregunta no son partes de relaciones. Por lo tanto, no son copiadas por **go'i**.

Términos como **na ku**, **pu**, negadores izquierdos como **na'e**, **no'e**, **to'e** son partes de relaciones.

Por lo tanto, **go'i** copia la relación anterior con esas partículas:

>— **la .bob. na ku prami la .alis.**
>— _**go'i**_

>— _No es cierto que Bob ame a Alice._

>— _Él no lo hace (amar)._

> **— la .bob. na'e prami la .alis.**
> _— Bob no ama a Alice._

> **— go'i**
> _— Él no lo hace (amar)._

Para decir "No, él sí la ama" usamos el verbo necesario directamente:

> **— la .bob. na ku prami la .alis.**
> _Bob no ama a Alice._

> **— ja'a ku go'i**
> _Bob sí ama a Alice._

Aquí, **ja'a ku** reemplaza **na ku** en la relación original. -->

### Hora del día

> **— ma tcika ti**
> _¿Qué hora es?_

<!-- -->

> **— li cacra bu pa pa**
> _Once horas_

tcika
: $x_1$ (horas, minutos, segundos) es la hora del evento $x_2$

En Lojban, los tiempos siempre son los tiempos de algo. Entonces preguntamos cuál es la hora de **ti**, que significa _este evento/cosa_, o, en otras palabras, _ahora_.

**li**, un prefijo para los números, también se utiliza para las marcas de tiempo.

- **cacra bu** es un prefijo que indica que le sigue el número de horas. Casi siempre se utiliza el formato de 24 horas en Lojban.
- **mentu bu** es un prefijo que indica que le sigue el número de minutos.
- **snidu bu** es un prefijo que indica que le sigue el número de segundos.

> **li cacra bu pa pa mentu bu pa no**
> _11:10 (Diez minutos después de las once)_

<!-- -->

> **li cacra bu pa pa mentu bu pa no snidu bu pa ci**
> _11 horas, 10 minutos y 13 segundos._

<!-- -->

> **li cacra bu pa no mentu bu mu no**
> _10:50, diez para las once_

Si queremos dar la hora de un evento en lugar de simplemente decir la hora, se llena el segundo lugar:

> **li cacra bu pa no tcika le nu mi klama**
> _Las diez en punto es la hora a la que llego._

Usando el término **de'i** podemos obtener una frase que suene más natural:

> **mi klama de'i li cacra bu pa no**
> _Voy a llegar a las diez._

de'i
: a las... (hora), en... (fecha)

Y un ejemplo útil:

> **ca tcika le nu .ei sipna**
> _Es hora de dormir._

### Fechas

> **— ma detri ti**
> _¿Cuál es la fecha de hoy?_

> **— li mastu bu ze djedi bu pa**
> _Es el 1 de julio._

detri
: $x_1$ (año, mes, día) es la fecha/hora del evento $x_2$

Otra opción:

> **— ma ca detri**
> _— ¿Cuál es la fecha actual?_

- **nanca bu** es un prefijo que indica que le sigue el año.
- **masti bu** es un prefijo que indica que le sigue el mes.
- **jefydei bu** es un prefijo que indica que le sigue el día de la semana.
- **djedi bu** es un prefijo que indica que le sigue el día.

Los prefijos con números después de ellos se pueden usar en cualquier orden (usaremos dígitos para mostrar los números):

> **li djedi bu 2 ca detri**
> _Hoy es el segundo día del mes._

<!-- -->

> **li masti bu 4 djedi bu 1 ca detri**
> _Hoy es el 1 de abril._

<!-- -->

> **li djedi bu 5 masti bu 7 nanca bu 2005 detri le nu mi jbena**
> _El 5 de julio (séptimo mes), año 2005 es cuando nací._

jbena
: $x_1$ nace

También podemos usar **de'i**:

> **mi ba klama de'i li masti bu pano**
> _Voy a llegar en octubre._

Las partículas en Lojban se pueden escribir sin espacios entre ellas, como en este **pano**, que es lo mismo que **pa no**.

Para los días de la semana, generalmente, el lunes es el primer día:

> **mi gunka de'i li jefydei bu pa**
> _Trabajo los lunes._

<!-- -->

> **mi gunka ca ro se detri be li jefydei bu re**
> _Trabajo todos los martes._

<!-- -->

> **xu do pu zvati la .paris. de'i li jefydei bu ci**
> _¿Estuviste en París el miércoles?_

### Especificando intervalos de tiempo

> **mi nanca li re re**
> _Tengo 22 años._

nanca
: $x_1$ es de duración de $x_2$ (número) años

**nanca** especifica la duración, y para decir _dos años de duración_, se coloca el número precedido por **li** en el segundo lugar.

> **le verba cu masti li re**
> _El niño tiene dos meses._

masti
: $x_1$ tiene una duración de $x_2$ meses

> **le nu carvi cu djedi li ci**
> _Está lloviendo durante tres días._

djedi
: $x_1$ (evento) tiene una duración de $x_2$ días completos

### Nuevos verbos de una escala: ‘_other than_’ — «**na'e**», ‘_anti-_’ — «**to'e**»

> **mi na'e nelci do**
> _No me gustas._

Las partículas "escalar izquierda" (a las que pertenece **na'e**) se colocan a la izquierda de las construcciones que afectan, formando una escala:

La escala en sí se puede especificar utilizando la etiqueta modal **ci'u**.

- **je'a** = _indeed (la posición afirmativa en la escala)_. La palabra **je'a** confirma el significado de una parte de una oración. Por lo general, se omite.

 > **mi je'a nelci do**
 > _Realmente me gustas._

- **na'e** = _no- (diferente de la posición afirmativa en la escala)_

 > **mi na'e nelci do**
 > _No me gustas._

 > **le stizu cu na'e xunre be ci'u le ka skari**
 > _La silla tiene un color que no es rojo._
 > `La silla es diferente de rojo en la escala de tener un color`

- **no'e** = _no realmente (punto medio en la escala)_. La palabra **no'e** le da a una parte de una oración un significado intermedio.

 > **mi no'e nelci do**
 > _En cuanto a si te amo o te odio, me da igual. No me gustas ni te odio._

- **to'e** = _anti-, dis-, mis- etc. (opuesto en la escala)_. La palabra **to'e** le da a una parte de una oración un significado opuesto. Es similar al prefijo en inglés _anti-_.

 > **mi to'e nelci do**
 > _Te odio._
 > `Te anti-gusto`

**na'e** es más vago que **no'e** y **to'e**; puede significar cualquiera de ellos cuando no te importa el significado exacto.

### Términos modales complejos: ‘_porque_’ — «**ki'u**», ‘_a pesar de_’ — «**to'e ki'u nai**»

Los términos modales pueden negarse de dos maneras para obtener significados relacionados.

ki'u
: término modal: porque, debido a la explicación ..., que puede explicarse por el hecho de que ...

> **ki'u ma do cusku zo co'o**
> _¿Por qué dices adiós?_

Añadir el sufijo **nai** cambia el significado:

ki'u nai
: término modal: no porque, que no puede explicarse por el hecho de que ...

> **mi se nabmi ki'u nai le nu mi laldo ce'e ki'u le nu mi na certu**
> _Tengo problemas no porque sea viejo sino porque no soy un experto._

nabmi
: $x_1$ es un problema para $x_2$

se nabmi
: $x_1$ tiene un problema $x_2$

laldo
: $x_1$ es viejo ...

certu
: $x_1$ es un experto, profesional en la propiedad $x_2$

Añadir **to'e** establece la negación del significado:

to'e ki'u
: porque no, que puede explicarse por el hecho de que no sucede que ...

> **mi jinga to'e ki'u le nu mi pu surla**
> _Gané porque no había descansado._

Combinando tanto **to'e** como **nai** obtenemos:

to'e ki'u nai
: a pesar de la razón ..., no porque no, que no puede explicarse por el hecho de que no sucede ...,

> **.i to'e ki'u nai le nu le mamta cu sanga su'o melbi kei le verba na snada lo ka sipna**
> _A pesar de que la madre canta hermosamente, el niño no logra quedarse dormido._

Usar **se** cambia el orden de los argumentos. De lo contrario, se mantiene el significado.

se ki'u
: por lo tanto, que explica el hecho de que ...

> **ra bilma se ki'u le nu ra na pu cusku zo coi do**
> _Está enfermo, lo cual explica por qué no te saludó._

se ki'u nai
: pero no se sigue que ..., que no explica el hecho de que ...

> **ra bilma se ki'u nai le nu ra klama le drata tcadu**
> _Está enfermo, lo cual no explica por qué se va a otra ciudad._

se to'e ki'u
: ..., cuya ausencia explica el hecho de que ...

> **ra bilma se to'e ki'u le nu ra klama le drata tcadu**
> _No está enfermo, y eso explica por qué se va a otra ciudad._

se to'e ki'u nai
: ..., la ausencia de lo cual no explica el hecho de que ...

> **ra bilma se to'e ki'u nai le nu ra penmi le mikce**
> _Él no está enfermo, y eso no explica por qué se está encontrando con el médico._

mikce
: $x_1$ es un médico