## Lección 5. Términos modales, «**da**», su posición relativa

### ¿Cómo se refieren los términos modales a la relación?

Algunos términos modales, como los que describen el tiempo (tiempo verbal), conectan la relación actual con la que está en el argumento después de ellos:

> **mi cadzu ca le nu le cipni cu vofli**
> _Yo camino cuando los pájaros vuelan._

cadzu
: … camina

le cipni
: el pájaro/los pájaros

vofli
: … vuela hacia …

> **mi pu cadzu fa'a le rirxe**
> _Yo caminé hacia el río._

<!-- -->

> **mi pu cadzu se ka'a le rirxe**
> _Yo caminé hasta el río._

se ka'a
: llegando a …

fa'a
: directamente hacia …

Los términos modales no eliminan los lugares ordenados (**fa**, **fe**, **fi**, **fo**, **fu**) de la relación:

> **mi klama se ka'a le rirxe le dinju**
> **mi klama fe le rirxe .e le dinju**
> _Yo voy a un río, a una casa._

En el primer ejemplo, **se ka'a** conecta **le rirxe** y luego sigue el segundo lugar de **klama**, que se llena con **le dinju**. Es lo mismo que simplemente llenar el segundo lugar de **klama** dos veces, conectándolos con **.e** — _y_.

Sin embargo, **se ka'a** es útil cuando se aplica a otras relaciones como **cadzu** en el ejemplo anterior.

> **le prenu pu cadzu tai le nu ri bevri su'o da poi tilju**
> _La persona caminaba como si estuviera cargando algo pesado._

bevri
: $x_1$ carga $x_2$

tai
: término modal: como …, parecido a …

<!--
- Algunos términos describen relaciones del primer lugar de la relación con el sustantivo después del término:

>**mi jinga se rai le ka clani**
>_Yo gano siendo el más alto._

se rai
: término de **se traji**: siendo el más en …

Aquí, $x_1$ de la relación corresponde al más alto en comparación especificado después de **se rai**.

- Por último, algunos términos describen relaciones del primer lugar de la relación y la relación misma con el sustantivo después del término:

>**le fragari cu se nelci mi te rai le'i jbari**
>_De todas las bayas, las fresas son las que más me gustan._

te rai
: término de **te traji**: preferir entre...

lo fragari
: fresas

lo jbari
: bayas

$x_1$ de la relación describe la más destacada en esta comparación, la relación en sí describe la comparación.

El diccionario explica estos casos complicados donde la relación definida por el término puede ser difícil de entender. En la práctica, la relación suele ser clara a partir de los ejemplos proporcionados. -->

### Usando «**ne**» + término. «**se mau**» — ‘_más que …_’

**mi ne se mau do cu melbi**
_Yo soy más bonito que tú._

se mau
: término de **se zmadu**: más que; la relación en sí describe la comparación

Este ejemplo es similar a

> **mi zmadu do le ka melbi**
> _Yo supero a ti en belleza._

En otras palabras, la relación principal **melbi** es similar al tercer lugar de **zmadu**, que especifica los criterios de comparación. Dos ejemplos más:

> **mi prami do ne se mau la .doris.**
> _Yo te amo más que a Doris._

<!-- -->

> **mi ne se mau la .doris. cu prami do**
> _Yo te amo más que Doris._
> _Yo te amo más que Doris te ama._
> `Yo (más que Doris) te amo.`

Más ejemplos:

> **mi nelci le'e pesxu ne se mau le'e jisra**
> _Me gusta más la mermelada que el jugo._

pesxu
: ...es mermelada

> **le'e pesxu cu zmadu le'e jisra le ka mi nelci**
> _Me gusta más la mermelada que el jugo._
> `La mermelada supera al jugo en cuánto me gusta.`

Y ahora una frase interesante:

> _Bob le gusta más Betty que Mary._

¡Puede tener dos significados diferentes en inglés!

1. Bob le gusta Betty y le gusta menos Mary.
2. Bob le gusta Betty, pero Mary también le gusta a Betty, aunque no tanto como a Bob.

¿Comparamos a Betty con Mary en cuánto a cómo Bob las quiere?

O en cambio, ¿comparamos a Bob con Mary en cuánto a cómo ellos quieren a Betty?

El inglés es ambiguo en este aspecto.

En Lojban, podemos diferenciar los dos significados adjuntando **se mau** a los argumentos adecuados:

> **la .bob. ne se mau la .maris. cu nelci la .betis.**
> _Bob (comparado con Mary) le gusta más a Betty. Mary le gusta menos a Betty._
> _Bob le gusta más a Betty que a Mary._

> **Bob likes Betty, and he likes Mary less.**
> _Bob le gusta Betty, y le gusta Mary menos._
> _Bob le gusta Betty más que Mary._

### Comparaciones: 'igual', 'lo mismo'

> **mi dunli le mensi be mi le ka mitre .i ku'i mi na ku du le mensi**
> *Soy tan grande como mi hermana, pero no soy ella.*
> _Yo soy igual de grande que mi hermana en metros, pero no soy idéntica a ella._

dunli
: $x_1$ (cualquier tipo) es igual a $x_2$ (cualquier tipo) en $x_3$ (propiedad de $x_1$ y $x_2$ con **kau**)

mitre
: $x_1$ tiene una longitud de $x_2$ metros

du
: $x_1$ (cualquier tipo) es idéntico a $x_2$ (cualquier tipo)

**dunli** compara dos lugares para una única propiedad, mientras que **du** compara para la identidad. Mi hermana y yo tenemos la misma altura, pero no somos la misma persona. Clark Kent y Superman tienen diferentes admiradores, pero son la misma persona.

Lo mismo ocurre con estos dos verbos:

> **mi frica do le ka nelci ma kau**
> *Nos diferenciamos en lo que nos gusta.*
> _Me diferencio de ti en lo que me gusta._

<!-- -->

> **le drata be mi cu kakne le ka sidju**
> *Alguien que no soy yo puede ayudar.*

frica
: $x_1$ (cualquier tipo) difiere de $x_2$ (cualquier tipo) en $x_3$ (propiedad de $x_1$ y $x_2$ con **kau**)

drata
: $x_1$ (cualquier tipo) no es lo mismo que $x_2$ (cualquier tipo)

### El concepto de 'solo'

> **Yo y ninguno de mis amigos le gusta el plátano.**
> _Yo y ninguno de mis amigos le gusta el plátano._
> _Entre mis amigos, soy el único al que le gusta el plátano._

El concepto de _no solo_ se expresa de manera similar:

> **No solo yo, sino algunos de mis amigos les gusta el plátano.**
> _No solo yo, sino algunos de mis amigos les gusta el plátano._

<!-- Una forma más precisa:

> **Soy el único al que le gusta el plátano entre mis amigos.** (por cierto, implicando que eres amigo de ti mismo)

se steci
: $x_1$ es el único en $x_2$ (propiedad de $x_1$) entre $x_3$ (conjunto) -->

<!-- Nota que este ejemplo implica que eres amigo de ti mismo :) De lo contrario, por favor, usa una declaración aún más precisa:

> **Soy el único al que le gusta el plátano entre el conjunto de mí y mis amigos.** -->

<!-- Negando esto obtenemos:

> **na ku mi se steci le ka nelci le'e badna**
> _No es cierto que solo a mí me gusten los plátanos._

— tal vez a nadie le gusten los plátanos, tal vez a mí y a otros les gusten. -->

<!-- Otro ejemplo interesante:

> **le'e troci cu se steci le ka snada**
> _Solo aquel que intenta tiene éxito._
> `Quien intenta es el único que tiene éxito.`

> **le'e po'o zukte be le ka troci cu fliba**
> _El único que solo intenta fracasa._
> `Aquel que solo hace intentos y nada más fracasa.`

troci
: $x_1$ intenta hacer $x_2$ (propiedad de $x_1$)

snada
: $x_1$ tiene éxito al hacer $x_2$ (propiedad de $x_1$)
.
fliba
: $x_1$ fracasa al hacer $x_2$ (propiedad de $x_1$)

Y una solución más:

> **ro snada pu troci**
> _Todos los que tienen éxito lo intentaron._

ro
: número: cada, todos

Como puedes ver, el lojban ofrece diferentes formas de decir lo mismo, algunas de las cuales pueden diferir significativamente de las formas en inglés. -->

### ‘_La mayoría_’, ‘_muchos_’ y ‘_demasiado_’

Palabras como _la mayoría_ y _muchos_ también son números en lojban:

<table>
<tbody><tr>
<td><b>ro</b>
</td>
<td><i>cada</i>
</td></tr>
<tr>
<td><b>so'a</b>
</td>
<td><i>casi todos</i>
</td></tr>
<tr>
<td><b>so'e</b>
</td>
<td><i>la mayoría</i>
</td></tr>
<tr>
<td><b>so'i</b>
</td>
<td><i>muchos</i>, <i>un montón de</i>
</td></tr>
<tr>
<td><b>so'o</b>
</td>
<td><i>varios</i>
</td></tr>
<tr>
<td><b>so'u</b>
</td>
<td><i>pocos</i>
</td></tr>
<tr>
<td><b>no</b>
</td>
<td><i>cero</i>, <i>ninguno</i>
</td></tr>
<tr>
<td><b>su'e</b>
</td>
<td><i>como máximo</i>
</td></tr>
<tr>
<td><b>su'o</b>
</td>
<td><i>al menos</i>
</td></tr>
<tr>
<td><b>za'u</b>
</td>
<td><i>más de …</i>
</td></tr>
<tr>
<td><b>du'e</b>
</td>
<td><i>demasiadas veces</i>
</td></tr></tbody></table>

Algunos ejemplos:

> **su'e re no le prenu ba klama**
> _No vendrán más de 20 personas._

<!-- -->

> **su'o pa le prenu cu prami do**
> _Al menos una persona te ama._

### ‘_nunca_’ — «**no roi**», ‘_siempre_’ — «**ro roi**»

Términos que especifican el número de veces:

- **no roi** = _nunca_
- **pa roi** = _una vez_
- **re roi** = _dos veces_
- **ci roi** = _tres veces_

…

- **so'i roi** = _muchas veces_
- **so'u roi** = _unas pocas veces_
- **du'e roi** = _demasiadas veces_
- **ro roi** = _siempre_

> **mi du'e roi klama le zarci**
> _Voy al mercado demasiado a menudo._

zarci
: $x_1$ es un mercado

> **mi pu re roi klama le zarci**
> _Fui al mercado dos veces._

Sin **pu**, la construcción **re roi** puede significar que fui al mercado una vez, pero la segunda vez que estaré allí solo ocurrirá en el futuro. Estas partículas relacionadas con el tiempo se pueden usar con un argumento después de ellas:

> **mi klama ti pa roi le jeftu**
> _Vengo aquí una vez a la semana._

### ‘_por primera vez_’ — «**pa re'u**», ‘_por última vez_’ — «**ro re'u**»

- **pa re'u** = _por primera vez_
- **re re'u** = _por segunda vez_

…

- **za'u re'u** = _de nuevo_
- **ro re'u** = _por última vez_

La partícula relacionada con el tiempo **re'u** funciona como **roi**, pero indica el número de iteraciones en las que ocurre el evento.

Comparar:

> **mi pa roi klama le muzga**
> _Visitó el museo una vez._

<!-- -->

> **mi pa re'u klama le muzga**
> _Visitó el museo por primera vez._

<!-- -->

> **mi za'u roi klama le muzga**
> _Visitó el museo varias veces._

<!-- -->

> **mi za'u re'u klama le muzga**
> _Visitó el museo de nuevo._

<!-- -->

> **mi za'u pa roi klama le muzga**
> _Visitó el museo más de una vez._

<!-- -->

> **mi za'u pa re'u klama le muzga**
> _Visitó el museo no por primera vez (quizás por segunda/tercera, etc.)_

vitke
: visitar (a alguien o algo)

Observa la diferencia entre:

za'u re'u
: de nuevo, no por primera vez

re re'u
: por segunda vez (aquí también, no se necesita contexto, e incluso se da el número exacto de veces)

### Partículas modales: su ubicación dentro de una relación

> **le nu tcidu kei ca cu nandu**
> _La lectura es difícil ahora._

<!-- -->

> **ca ku le nu tcidu cu nandu**
> _Ahora la lectura es difícil._

Los términos simples sin argumentos después de ellos pueden moverse alrededor de la oración agregando **ku** después de ellos.

**ku** evita que los términos de argumento siguientes se adjunten a dichos términos. Comparar:

> **ca le nu tcidu cu nandu**
> _Cuando leo, es difícil._

Aquí hay varios lugares donde pueden ir las partículas modales.

- El término modal modifica la relación a su derecha:

 >**ca ku mi citka**
 >_Ahora como._

  — aquí el término está etiquetado con la palabra **ku** como completado.

 >**ca le cabdei mi citka**
 >_Hoy como._

  — aquí el término tiene un argumento después de él.

 >**mi ca citka**
 >_Yo como ahora._

  — aquí la partícula modal es parte de la construcción principal de la relación y no tiene un argumento.

- El término modal se aplica a toda la relación:

 >**mi citka ca**
 >_Yo como ahora._

  — aquí el término modal está al final de la relación.

### Unir declaraciones con modales

> **mi pinxe le jisra ca le nu do co'i klama le zdani**
> _Estoy bebiendo el jugo cuando llegas a casa._

<!-- -->

> **mi pinxe le jisra .i ca bo do co'i klama le zdani**
> _Estoy bebiendo el jugo, y al mismo tiempo llegas a casa._

Los dos ejemplos transmiten el mismo significado. La segunda opción se utiliza principalmente cuando alguna de las relaciones originales suena pesada.

Otro uso es mover los términos modales fuera del alcance de otros términos modales:

> **mi na ku te vecnu ki'u le nu kargu**
> _No es cierto que compre porque es caro._

En este ejemplo, uno podría suponer que solo compro cosas si son caras. Sin embargo, ese no es el caso.

Aquí, **na ku** niega que _compro cosas porque son caras_. **na ku** se aplica a toda la relación, por lo tanto, "cubre" **ki'u**.

> **mi na ku te vecnu .i ki'u bo kargu**
> _No compro. Es porque es caro._

En este caso, no compro cosas. ¿Por qué? Porque son caras. Tal vez prefiero solo cosas baratas.

Aquí, **ki'u** se coloca en otra oración. Por lo tanto, **na ku** no tiene alcance sobre ella.

Ambos ejemplos podrían traducirse como _No compro porque es caro_. Sin embargo, significan cosas diferentes.

Una regla especial es usar **.i ba bo** y **.i pu bo**. Compara:

> **mi cadzu pu le nu mi citka**
> _Camino antes de comer._

<!-- -->

> **mi cadzu .i ba bo mi citka**
> _Camino, y luego como._

**.i ba bo** significa _después, luego_. La oración después de **.i ba bo** se refiere a algo que ocurrió más tarde que lo que ocurrió en la relación anterior.

**pu** se cambia por **ba**, y viceversa. Esta regla especial para el Lojban se hizo por analogía con los idiomas naturales. Así que solo tienes que recordar este comportamiento especial de estas dos palabras.

### Cosas existentes, '_hay ..._'

En realidad, hay tres palabras en la serie **da**: **da**, **de** y **di**. Las usamos cuando nos referimos a diferentes objetos en un discurso:

> **ci le mlatu cu citka re le finpe**
> _Hay tres gatos, hay dos peces para cada gato, y cada gato come dos peces._

Si necesitas más palabras de este tipo en un discurso, agrega un sufijo **xi** a ellas y luego cualquier número (que podemos llamar un índice). Así,

- **da xi pa** es lo mismo que simplemente **da**,
- **da xi re** es lo mismo que **de**,
- **da xi ci** es lo mismo que **di**
- **da xi vo** es la cuarta "cosa" y así sucesivamente...

### Tema y comentario. «**zo'u**»

A veces es útil mostrar el tema de una relación y luego hacer un comentario al respecto:

> **le'e finpe zo'u mi nelci le'e salmone**
> _En cuanto a los peces, me gusta el salmón._

salmone
: ... es un salmón

zo'u
: termina el tema y comienza el comentario de la relación

**zo'u** es más útil cuando se define un pronombre como **da** en el tema y luego se usa en el comentario:

> **su'o da zo'u mi viska da**
> _Hay una cosa tal que la veo._

<!-- -->

> **ro da poi gerku zo'u mi nelci da**
> _Para cada cosa que es un perro: me gusta._
> _Me gustan todos los perros._

<!-- -->

> **da de zo'u da viska de**
> _Hay **da** y **de** tal que **da** ve a **de**._

Los dos pronombres **da** y **de** indican que hay dos cosas que están en la relación de que uno ve al otro. Podría ser el caso de que las dos cosas supuestas sean realmente una sola cosa que se ama a sí misma: nada en la oración descarta esa interpretación, por eso la traducción coloquial no dice _Alguien ve a alguien más_. Las cosas a las que se refieren los diferentes pronombres de la serie **da** pueden ser diferentes o iguales.

Está perfectamente bien que estos pronombres aparezcan más de una vez en la misma oración:

> **da zo'u da prami da**
> _Hay **da** tal que **da** se ama a sí mismo. Hay alguien que se ama a sí mismo._

No es necesario que un pronombre sea el argumento directo de la relación:

> **da zo'u le gerku pe da cu viska mi**
> _Existe **da** tal que el perro de ellos me ve. El perro de alguien me ve._

### ‘_any_’ y ‘_some_’ en ejemplos

Las palabras _any_ y _some_, junto con sus derivados, tienen muchos significados en inglés. Debemos tener cuidado al traducir el significado deseado:

Traduciendo como **da**:

- _some_: algo no especificado:

 >**da pu klama .i je ko smadi le du'u da me ma kau**
 >_Alguien vino. Adivina quién fue._

  <!-- -->

 >**mi pu tirna da .i je mi fliba le ka jimpe le du'u da mo kau**
 >_Escuché algo, pero no logro entender qué era._

- _some_ en preguntas se convierte en _anything_, _anybody_; en Lojban, sigue siendo **da**:

 >**xu su'o da pu klama**
 >_¿Vino alguien?_

- _some_ cuando se usan comandos, solicitudes o sugerencias:

 >**.e'u mi'o pilno su'o da poi drata**
 >_Intentemos algo más. Intentemos otras cosas._

  <!-- -->

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Intentemos en otro lugar._

- _any_ se puede usar en relaciones internas:

 >**mi rivbi le ka jdice da**
 >_Evité tomar cualquier decisión._

 Como en relaciones dentro de términos modales:

 >**ba le nu do zgana da kei ko klama**
 >_Después de que notes algo, ¡ven!_

- Alcance: _any_ se usa en inglés al negar, mientras que en Lojban se usa **na ku** pero luego sigue siendo **da**:

 >**mi na ku viska su'o da poi prenu**
 >_No veo a nadie._

- _any_ se usa cuando no se hace ninguna distinción entre los miembros de los que hablamos:

 >**.au nai mi tavla su'o da poi na ku slabu mi**
 >_No quiero hablar con cualquier persona._

- Alcance: La negación debe usarse en una relación adecuada, como se muestra a continuación:

 >**mi jinvi le du'u na ku da jimpe**
 >_No creo que nadie entienda._

 Esto se puede reformular como:

 >**mi jinvi le du'u no da jimpe**
 >_Creo que nadie entiende._

- En comparaciones, _every_ se convierte en _any_ y se traduce como **ro da**:

 >**do zmadu ro da le ka se canlu**
 >_Eres más alto que cualquier persona._
 >`Superas a todos en tamaño.`

- Al proporcionar opciones, se utiliza y se traduce **any** como **ro da**:

 >**ro da poi do nelci zo'u .e'a do citka da**
 >_Puedes comer cualquier cosa que te guste._
 >`Para todo lo que te guste, te permito comerlo.`

- Para términos como _anyone_ y _somewhere_:

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Intentemos en otro lugar._

 Aquí, **su'o da poi drata** significa _cualquier otra cosa o lugares_. No se especifica el número de lugares, aunque cualquier lugar de este tipo podría servir.

 Para decir _cualquier lugar, pero solo un lugar_, utiliza:

 >**.e'u mi'o troci bu'u pa da poi drata**
 >_Intentemos en otro lugar._

- Traduciendo _any_ como **le'e** en declaraciones genéricas:

 >**le'e gerku cu se tuple le vo da**
 >_Cualquier perro tiene cuatro patas. Se espera que los perros tengan cuatro patas._

- Usando **le** al describir objetos, lugares o eventos específicos:

 >**le drata zo'u .e'u mi'o pilno ri**
 >_La otra cosa, vamos a usarla._

 >**le drata stuzi zo'u .e'u mi'o troci bu'u ri**
 >_El otro lugar, vamos a intentar allí._

### Resumen: ¿qué construcciones afecta el alcance?

El alcance se crea solo mediante:

- los límites de las relaciones,
- los términos modales y partículas modales de la construcción de la relación principal,
- los términos de argumento que comienzan con números (como **pa le prenu** — _uno de las personas_).
<!-- - las interjecciones discursivas **po'o**, **ji'a**. -->

**da**, **de**, **di** si se usan sin un prenex y sin un número explícito al frente se entienden como **su'o da**, **su'o de**, **su'o di** y, por lo tanto, también crean alcance.

Por lo tanto, el orden relativo de dichas construcciones cambia el significado:

> **pa le prenu ca ku zvati**
> _Hay una persona que está presente ahora._

> **ca ku pa le prenu ca zvati**
> _Ahora hay una persona._

El alcance no es relevante para las construcciones de relación y para los argumentos que comienzan con **le** (como **le prenu** o **le re prenu**). Ambas oraciones significan lo mismo:

> **le prenu ca ku zvati le zdani**
> **ca ku le prenu cu zvati le zdani**
> **ca ku fe le zdani fa le prenu cu zvati**
> _Las personas están presentes ahora._

El alcance del término modal se extiende desde donde se usa hasta la derecha de la relación hasta que la relación y todas sus relaciones internas (si las hay) terminen.

Aquí, **ki'u le nu kargu** está bajo el alcance de **na ku**:

> **na ku mi te vecnu ki'u le nu kargu**
> _No es cierto que: Compro porque es caro._

Pero aquí, **ki'u le ne kargu** no está bajo el alcance de **na ku**. **ki'u** se aplica a toda la oración anterior, incluyendo **na ku**:

> **mi na ku te vecnu .i ki'u bo kargu**
> _No compro. Es porque es caro._