## Lección 4. Práctica

Ahora conocemos las partes más importantes de la gramática y podemos comenzar a acumular nuevas palabras a través de situaciones.

### Expresiones coloquiales

Aquí hay algunas estructuras comunes utilizadas por hablantes fluidos de Lojban, junto con ejemplos que ilustran su uso.

Pueden ayudarte a acostumbrarte más rápidamente al Lojban coloquial.

- <dl><dt>.i ku'i</dt><dd>Pero...</dd></dl>
 > **mi djuno .i ku'i mi na ku djica**
 > _Lo sé. Pero no quiero._
- <dl><dt>mi djica le nu</dt><dd>Quiero que...</dd></dl>

 > **mi djica le nu mi sipna**
 > _Quiero dormir._
 > `Quiero que yo duerma.`
- <dl><dt>mi djuno le du'u ma kau</dt><dd>Sé qué/quién...</dd></dl>

> **mi djuno le du'u ma kau smuni zo coi**
> _Sé lo que significa "coi"._

<!-- -->

> **mi na ku djuno**
> _No lo sé._
>
- <dl><dt>jinvi le du'u</dt><dd>… tiene la opinión de que …</dd></dl>

> **mi jinvi le du'u la .lojban. cu zabna**
> _Creo que Lojban es genial._

<!-- -->

> **coi ro do**
> _¡Hola a todos!_

<!-- -->

> **co'o ro do**
> _¡Adiós a todos!_
>
- <dl><dt>jinvi le du'u</dt><dd>… tiene la opinión de que …</dd></dl>

> **ai mi cliva .i co'o**
> _Me voy. ¡Adiós!_
>
- <dl><dt>.ei mi</dt><dd>Debería …</dd></dl>

> **.ei mi citka .i co'o**
> _Debería comer. ¡Adiós!_
>
- <dl><dt>ca le nu</dt><dd>cuando …</dd></dl>

> **mi pu bebna ca le nu mi citno**
> _Era tonto cuando era joven._
>
- <dl><dt>va'o le nu</dt><dd>siempre que …</dd></dl>

> **va'o le nu do djica kei mi ka'e ciksi**
> _Si quieres, puedo explicar._
>
- <dl><dt>simlu le ka</dt><dd>… parece ser …</dd></dl>

> **simlu le ka zabna**
> _Parece ser genial._
>
- <dl><dt>ca le cabdei</dt><dd>hoy</dd></dl>

> **pu ce'e ca le cabdei mi surla**
> _Hoy descansé._
>
- <dl><dt>mi nelci</dt><dd>Me gusta</dd></dl>

> **mi nelci le mlatu**
> _Me gusta el gato._
>
- <dl><dt>le nu pilno</dt><dd>usando …</dd></dl>

> **na ku le nu pilno le vlaste cu nandu**
> _Usar diccionarios no es difícil._
>
- <dl><dt>kakne le ka</dt><dd>capaz de …</dd></dl>

> **xu do kakne le ka sutra tavla**
> _¿Eres capaz de hablar rápido?_
>
- <dl><dt>tavla fi</dt><dd>hablar sobre …</dd></dl>

> **.e'ei tavla fi le skami**
> _¡Hablemos de computadoras!_
>
- <dl><dt>mutce le ka</dt><dd>muy …</dd></dl>

> **mi mutce le ka se cinri**
> _Estoy muy interesado._
>
- <dl><dt>troci le ka</dt><dd>intenta …</dd></dl>

> **mi troci le ka tavla fo la .lojban.**
> _Estoy intentando hablar en Lojban._
>
- <dl><dt>rinka le nu</dt><dd>(evento) conduce a …</dd></dl>

> **le nu mi tadni la .lojban. cu rinka le nu mi jimpe fi do**
> _El hecho de que estudie Lojban me hace entenderte._
>
- <dl><dt>gasnu le nu</dt><dd>(agente) causa …</dd></dl>

<pixra url="/assets/pixra/cilre/tadni.webp" caption="mi tadni" definition="Estudio."></pixra>

 > **mi pu gasnu le nu le skami pe mi co'a spofu**
 > _Hice que mi computadora se rompiera._
- <dl><dt>xusra le du'u</dt><dd>afirmar que …</dd></dl>

 > **xu do xusra le du'u mi na ku drani**
 > _¿Afirmas que no tengo razón?_
- <dl><dt>kanpe le du'u</dt><dd>esperar (en el sentido de evaluación, predicción) que …</dd></dl>

 <!-- -->

 > **mi na ku kanpe le du'u mi jinga**
 > _No espero ganar._

### Un diálogo sencillo

> **coi la .alis.**
> _¡Hola, Alicia!_
<!-- -->
> **coi la .doris.**
> _¡Hola, Doris!_
<!-- -->
> **do mo**
>_¿Cómo estás?_
<!-- -->
> **mi kanro .i mi ca tadni la .lojban. .i mi troci le ka tavla do**
> _Estoy bien. Ahora estudio Lojban. Estoy tratando de hablar contigo._

kanro
: estar bien de salud

tadni
: estudiar … (algo)

troci
: intentar … (hacer algo)

tavla
: hablar [con alguien]

> **zabna .i ma tcima ca le bavlamdei**
> _Bien. ¿Cómo estará el clima mañana?_

zabna
: … es agradable, fresco

tcima
: … es el clima

ca
: en (algún momento)

le bavlamdei
: día de mañana

> **mi na ku djuno .i le solri sei mi pacna**
> _No lo sé. Estará soleado, espero._

djuno
: saber (un hecho)

le solri
: el sol

Ten en cuenta que **le solri cu tcima** (literalmente _el sol es el clima_) es la forma de usar **tcima** en Lojban.

sei
: comienza un comentario

pacna
: esperar (un evento)

> **mi jimpe**
> _Entiendo._

> **co'o**
> _Adiós._

### Sentidos humanos

> **ju'i la .alis.**
> _¡Oye, Alicia!_

ju'i
: vocativo que llama la atención: _¡Oye! ¡Psst! ¡Ejem! ¡Atención!_

> **re'i**
> _Escuchando._

re'i
: vocativo: _Estoy listo para recibir información._

> **xu do viska ta**
> _¿Ves eso que está cerca de ti?_

En inglés decimos _Can you see_, en Lojban decimos simplemente **xu do viska** — _¿Ves?_

----

Las relaciones que describen la percepción se explicarán después del diálogo.

> **viska .i plise**
> **.i le plise cu xunre .i skari le ka xunre**
> _Sí. Es una manzana._
> _La manzana es roja. Está de color rojo._

> **xu do viska le tarmi be le plise**
> _¿Puedes ver la forma de la manzana?_

> **viska .i le plise cu barda**
> _Sí. La manzana es grande._

> **xu do jinvi le du'u le plise ca makcu**
> _¿Crees que la manzana está madura?_

makcu
: ...está madura

> **.au mi zgana le sefta be le plise**
> _Me gustaría palparla._

> **.i ua xutla**
> _Oh, es suave._

> **.i mi pacna le nu makcu ie**
> _Espero que esté madura, sí._

> **panci pei**
> _¿Y el olor?_

> **.i .e'o do sumne le plise**
> _Por favor, huélela._

> **le xrula cu panci**
> _Huele a flores._

> **.i .au mi zgana le vrusi be le plise**
> _Me gustaría probar la manzana._

> **.i .oi nai le kukte cu vrusi**
> _Mmm, sabe dulce._

> **.i .oi**
> _Oh-no._

le xrula
: la flor (las flores)

<pixra url="/assets/pixra/cilre/xrula.webp" caption="xrula" definition="flor"></pixra>

> **ma pu fasnu**
> _¿Qué pasó?_

> **mi pu farlu**
> _Caí._

farlu
: ... cae hacia ...

> **xu do cortu**
> _¿Sientes dolor?_

> **cortu .i mi cortu le cidni**
> _Sí, siento dolor en la rodilla._

> **.i na ku ckape**
> _No es peligroso._

> **.i ca ti mi ganse le nu da vi zvati**
> _Y ahora puedo sentir la presencia de alguien aquí._

> **doi la .alis. do cliva .e'o sai**
> _¡Alice, por favor, regresa inmediatamente!_

> **ko denpa .i mi ca tirna le sance**
> _Espera, puedo oír un sonido._

> **le sance be ma**
> _¿Un sonido de qué?_

> **mi pu tirna le nu le prenu cu tavla**
> _Escuché a una persona hablando._

> **.i ca ti mi zgana le lenku**
> _Ahora siento frío._

> **ju'i la .alis.**
> _¡Oye, Alice!..._

En este diálogo, se abordaron los conceptos más importantes relacionados con los sentidos humanos. En las siguientes secciones explicaremos sus estructuras de lugar, junto con relaciones y ejemplos adicionales.

#### Visión

viska
: $x_1$ ve $x_2$ (objeto, forma, color)

skari
: $x_1$ es un objeto con el color $x_2$ (propiedad)

tarmi
: $x_1$ es la forma de $x_2$

cukla
: $x_1$ es redondo (en forma)

<pixra url="/assets/pixra/cilre/coha_viska.webp" caption="le prenu co'a viska le cipni" definition="La persona nota, comienza a ver el pájaro."></pixra>

> **mi viska le plise**
> _Veo la manzana._

> **mi viska le tarmi be le plise**
> _Veo la forma de la manzana._

> **.i le plise cu se tarmi le cukla**
> _La manzana es redonda._

<!-- -->
<!-- > **mi viska le se skari be le plise**
> _Veo el color de la manzana._ -->

> **.i le plise cu skari le ka xunre**
> _La manzana tiene el color rojo._

Nota: podemos decir tanto "ver la forma de la manzana" como "ver la manzana".

#### Audición

tirna
: $x_1$ escucha a $x_2$ (objeto o sonido)

<pixra url="/assets/pixra/cilre/le_prenu_cu_tirna_lei_djacu.webp" caption="le prenu cu tirna lei djacu" definition="La persona escucha las aguas."></pixra>

> **mi tirna le palta**
> _Escucho el plato._

<!-- -->

> **mi tirna le sance be le palta poi ca'o porpi**
> _Escucho el sonido de un plato que se está cayendo._

> **.i le palta cu se sance le cladu**
> _Suena fuerte._

le palta
: el plato

cladu
: $x_1$ es fuerte (en sonido)

tolycladu
: $x_1$ es bastante suave (en sonido)

tonga
: $x_1$ es un tono de $x_2$

Podemos usar **cladu** y palabras similares directamente:

> **mi tirna le cladu**
> _Escucho algo fuerte._

<!-- -->

> **mi tirna le tolycladu**
> _Escucho algo bastante suave._

<!-- -->

> **mi tirna le tonga be le palta poi farlu**
> _Escucho el tono del plato que cae._

Al igual que con la visión, podemos decir "escuchar un sonido" y "escuchar algo que produce el sonido":

> **— ma sance gi'e se tirna do**
> _— ¿Qué sonido escuchas?_

> **— le zgike**
> _— La música._

<!-- -->

> **— do tirna le sance be ma**
> _— ¿Escuchas el sonido de qué?_

> **— le plise poi co'i farlu**
> _— La manzana que ha caído._

#### Percepción en general

También podemos usar el vago **ganse** — _percibir un estímulo_.

ganse
: $x_1$ percibe el estímulo $x_2$ (objeto, evento) mediante $x_3$

ganse le glare
: sentir el calor

ganse le lenku
: sentir el frío

> **mi ganse le plise**
> _Percibo la manzana._

<!-- -->

Para observar nuestras percepciones podemos usar **zgana**:

<pixra url="/assets/pixra/cilre/zgana_le_sefta.webp" caption="le prenu cu zgana le sefta be le xrula" definition="The person palpates the surface of the flower."></pixra>

> **mi zgana le tarmi be le plise**
> _Observo la forma de una manzana._

> **.i le plise cu se tarmi le'e cukla**
> _La manzana es redonda._

zgana
: $x_1$ nota, observa, mira a $x_2$. No se limita a la visión.

Algunos argumentos se pueden usar con diferentes relaciones sensoriales. Por ejemplo, podemos

viska le sefta
: ver la superficie

zgana le sefta
: palpar la superficie

#### Sentido del olfato

sumne
: $x_1$ huele a $x_2$ (olor)

panci
: $x_1$ es un olor de $x_2$ (objeto)

<pixra url="/assets/pixra/cilre/sumne.webp" caption="le mlatu cu sumne le xrula" definition="El gato huele la flor."></pixra>

> **mi sumne le xrula**
> _Yo huelo la flor._

<!-- -->

> **mi sumne le panci be le za'u xrula**
> _Yo huelo el olor de las flores._

<!-- -->

> **mi sumne le panci be le plise**
> _Yo huelo el olor de la manzana._

> **.i le plise cu se panci le xrula**
> _La manzana huele a flores._

Ten en cuenta que el inglés puede ser confuso cuando se trata de distinguir entre oler un olor y oler un objeto que produce ese olor. Decimos _oler la manzana_, _la manzana huele a flores (tiene el aroma de flores)_. Esta distinción doble es importante porque una manzana produce partículas aromáticas que son distintas de la manzana en sí. Lo mismo se aplica a un plato que cae y su sonido, es posible que no queramos mezclarlos.

En Lojban, podemos separar fácilmente estos casos, como se muestra en los ejemplos anteriores.


#### Sentido del gusto

vrusi
: $x_1$ es un sabor de $x_2$

<pixra url="/assets/pixra/cilre/se_vrusi_lo_ka_kukte.webp" caption="le prenu cu zgana le vrusi be le grute" definition="La persona prueba, observa el sabor de la fruta."></pixra>

> **mi zgana le vrusi be le grute**
> _Yo pruebo la manzana._
> `Observo el sabor de la fruta`

le grute
: la fruta, las frutas
<!-- -->

> **.i le plise cu se vrusi le titla**
> _La manzana tiene un sabor dulce._

titla
: ... es dulce, ... es un dulce

#### Sentido del tacto

sefta
: $x_1$ es una superficie de $x_2$

> **mi zgana le sefta be le plise**
> _Yo palpo, toco la superficie de la manzana._

<!-- -->

> **.i le plise cu se sefta le xutla**
> _La manzana tiene una superficie suave._

#### Dolor

> **mi cortu le birka be mi**
> _Siento dolor en mi brazo._
> _Me duele el brazo._

<!-- -->

<pixra url="/assets/pixra/cilre/cortu.webp" caption="mi cortu le cidni be mi" definition="Me duele la rodilla."></pixra>

> **mi cortu le cidni**
> _Siento dolor en mi rodilla, me duele la rodilla._

cortu
: $x_1$ siente dolor en $x_2$ (órgano, parte del cuerpo de $x_1$)

cidni
: $x_1$ es una rodilla de $x_2$

#### Colores

Diferentes idiomas utilizan diferentes conjuntos de palabras para denotar colores. Algunos idiomas simplemente se refieren a los colores haciendo referencia a otros objetos "prototipo" con colores, tonalidades o formas similares. En Lojban, utilizamos todas las opciones:

> **ti xunre**
> _Esto es rojo._

xunre
: $x_1$ es rojo

> **ti skari le ka xunre**
> _Esto es rojo. Esto tiene el color de las cosas rojas._

<!-- -->

> **ti skari le ka ciblu**
> _Esto tiene el color de la sangre._

le ciblu
: la sangre

Aquí hay algunos ejemplos de colores que se alinean con el idioma inglés. También puedes usar otras palabras de colores, reflejando la forma en que los hablantes de diferentes idiomas categorizan típicamente las cosas.

> **le tsani cu xunre ca le cerni**
> _El cielo es rojo por la mañana._

le tsani
: el cielo

> **.i le solri cu simlu le ka narju**
> _El sol parece ser naranja._

le solri
: el Sol

<pixra url="/assets/pixra/cilre/tsani.webp" caption="tsani .i solri" definition="El cielo. El sol."></pixra>

simlu
: $x_1$ parece ser como $x_2$ (propiedad de $x_1$)

> **.i le pelxu xrula cu se farna le solri**
> _Las flores amarillas están orientadas hacia el Sol._

se farna
: $x_1$ está orientado hacia $x_2$

farna
: $x_1$ es la dirección de $x_2$

> **.i le pezli be le tricu cu crino**
> _Las hojas de los árboles son verdes._

pezli
: $x_1$ es una hoja de $x_2$

le tricu
: árbol

> **.i mi zvati le korbi be le blanu xamsi**
> _Estoy en el borde de un mar azul._

zvati
: ... está presente en ...

korbi
: $x_1$ es el borde de $x_2$

le xamsi
: mar

> **.i mi catlu le prenu noi dasni le zirpu taxfu**
> _Miro a una persona que lleva un vestido violeta._

dasni
: $x_1$ lleva $x_2$ (algo)

xunre
: $x_1$ es rojo

narju
: $x_1$ es naranja

pelxu
: $x_1$ es amarillo

crino
: $x_1$ es verde

blanu
: $x_1$ es azul

zirpu
: $x_1$ es violeta

Otras relaciones útiles:

> **le gusni be le manku pagbu pu na ku carmi**
> _La luz que ilumina las áreas oscuras no era intensa._

<!-- -->

> **le gusni be fi le solri pu carmi**
> _La luz del Sol era intensa._

gusni
: $x_1$ es una luz que ilumina $x_2$ desde la fuente de luz $x_3$

carmi
: $x_1$ es intenso, brillante

manku
: $x_1$ es oscuro

### «**sipna**» — ‘_dormir_’, «**sanji**» — ‘_estar consciente_’

Los siguientes ejemplos ilustran algunos aspectos básicos de la mente:

> **pu ku mi cikna gi'e ku'i na ganse le nu do klama**
> _Estaba despierto pero no percibí tu llegada._

<!-- -->

> **pu ku ca le nu mi sipna kei mi ganse ku'i le nu do klama**
> _Mientras dormía, sin embargo, percibí que te acercabas._

<!-- -->

<pixra url="/assets/pixra/cilre/le_prenu_cu_senva_tuha_le_nei.webp" caption="mi ca'o sipna gi'e sanji le nu mi sipna" definition="Duermo y soy consciente de que duermo."></pixra>

> **pu ku mi ca'o sipna gi'e sanji le nu mi sipna**
> _Estaba durmiendo y era consciente de que estaba durmiendo._
> _Estaba teniendo un sueño lúcido._

<!-- -->

> **mi sanji le nu mi sanji**
> _Soy consciente de que soy consciente._
> _Soy autoconsciente._

sipna
: $x_1$ duerme

cikna
: $x_1$ está despierto

ganse
: el observador $x_1$ percibe, nota algún estímulo (evento) por medio de los medios $x_3$

sanji
: $x_1$ está consciente, es consciente de $x_2$ (evento)

**ganse** no implica ningún procesamiento mental; solo describe la percepción, reconocimiento, detección de algún estímulo a través de canales sensoriales (especificados en $x_3$).

Por otro lado, **sanji** describe la percepción pasiva, que implica procesamiento mental pero no necesariamente a través de entradas sensoriales (algunas relaciones mentales no son detectadas por los sentidos).

### Emociones: «**cmila**» — ‘_reír_’, «**cisma**» — ‘_sonreír_’

> **coi**
> **.i ma nuzba**
> **.i do simlu le ka badri**
> _Hola._
> _¿Cuáles son las noticias?_
> _Pareces estar triste._

badri
: $x_1$ está triste por $x_2$

<pixra url="/assets/pixra/cilre/badri.webp" caption="le prenu cu simlu lo ka badri" definition="La persona parece estar triste."></pixra>

> **Estoy frustrado de que mi hermano se case con la mujer.**
> _I am frustrated that my brother gets married to the woman._

steba
: $x_1$ siente frustración acerca de $x_2$

> **Estoy confundido.**
> **¿No estás feliz de que el hermano se case?**
> _I am confused._
> _Aren't you happy that the brother gets married?_

se cfipu
: $x_1$ está confundido acerca de $x_2$

gleki
: $x_1$ está feliz acerca de $x_2$

> **Sí.**
> _La mujer es pobre._
> _Ella no tiene dinero._
> _No puedo explicar._

le jdini
: el dinero

kakne
: $x_1$ es capaz de $x_2$ (propiedad de $x_1$)

> **¡Ah!**
> _Probablemente, esperas que la mujer no le guste al hermano._

la'a
: interjección: probablemente, es probable

kanpe
: $x_1$ espera $x_2$ (algún evento)

> **Tengo miedo de que ella se comporte mal.**
> _Pero el hermano sonríe cada vez que habla con ella._
> _Y ella suele reírse._

terpa
: $x_1$ teme $x_2$

cisma
: $x_1$ sonríe

cmila
: $x_1$ se ríe

> **Me pregunto si a la chica le gusta el hermano.**
> _I wonder whether the girl likes the brother._

kucli
: $x_1$ tiene curiosidad acerca de $x_2$

> **No espero eso.**
> _I don't expect that._

kanpe
: $x_1$ espera que $x_2$ (evento) suceda

> **¡Relájate!**
> _Relax!_

surla
: $x_1$ se relaja haciendo $x_2$ (propiedad de $x_1$)

cinmo
: $x_1$ siente emoción $x_2$ (propiedad de $x_1$)

nelci
: $x_1$ le gusta $x_2$

manci
: $x_1$ siente asombro o admiración acerca de $x_2$

fengu
: $x_1$ está enojado acerca de $x_2$

xajmi
: $x_1$ piensa que $x_2$ es gracioso

se zdile
: $x_1$ se divierte con $x_2$

zdile
: $x_1$ es divertido

djica
: $x_1$ desea $x_2$

pacna
: $x_1$ espera que $x_2$ sea verdad

### Salud

> **Hace calor ahora.**
> _It's hot now._

<!-- -->

> **Pero siento frío.**
> _But I feel cold._

ku'i
: interjección: pero, sin embargo

> **¿Estás enfermo?**
> _Are you ill?_

<!-- -->

> **bilma**
> _Sí._

<!-- -->

> **xu do bilma fi le vidru**
> **.i .e'u do klama le mikce**
> _¿Tienes un virus? Te sugiero que vayas al médico._

le vidru
: el virus

le mikce
: médico

> **mi bilma le ka cortu le galxe**
> **.i mi sruma le du'u mi bilma fi la .zukam.**
> _Mis síntomas son que me duele la garganta._
> _Supongo que tengo un resfriado._

cortu
: $x_1$ tiene dolor en $x_2$ (órgano, parte del cuerpo de $x_1$)

la .zukam.
: resfriado común (enfermedad)

> **ko kanro**
> _¡Recupérate!_

kanro
: $x_1$ está sano

> **ki'e**
> _Gracias._

bilma
: $x_1$ está enfermo o tiene síntomas $x_2$ de la enfermedad $x_3$

Ten en cuenta que el segundo lugar de **bilma** describe los síntomas, como **le ka cortu le galxe** = _tener dolor de garganta_. El tercer lugar indica el nombre de la enfermedad que causa esos síntomas. Obviamente, puedes optar por no completar estos lugares de **bilma**.

### Cuerpo humano

> **le nanmu cu se xadni le clani**
> _El hombre tiene un cuerpo largo. El hombre es alto._

se xadni
: $x_1$ tiene el cuerpo $x_2$

xadni
: $x_1$ es el cuerpo de $x_2$

> **mi pu darxi fi le stedu .e le zunle xance**
> **.i ca ti le degji be le xance cu cortu**
> **.i ku'i le pritu xance na ku cortu**
> _Golpeé algo con la cabeza y la mano izquierda. Ahora el dedo de la mano duele. Pero la mano derecha no duele._

darxi
: $x_1$ golpea a $x_2$ con $x_3$

La mayoría de las palabras para las partes del cuerpo tienen la misma estructura de lugar que **xadni**:

stedu
: $x_1$ es la cabeza de $x_2$

Sin embargo, algunas describen partes más pequeñas:

degji
: $x_1$ es un dedo/dedo del pie en la parte $x_2$ (mano, pie)

> **le degji be le xance be le ninmu cu clani**
> _Los dedos de la mujer son largos._
> `Los dedos de la mano de la mujer son largos`

> **mi viska le jamfu .i ku'i mi na ku viska le degji be le jamfu**
> _Puedo ver los pies. Pero no veo los dedos._

janco
: $x_1$ es una articulación que une las extremidades $x_2$

ctebi
: $x_1$ es un labio de la boca, orificio $x_2$

cidni
: $x_1$ es una rodilla o codo de la extremidad $x_2$

![](/assets/pixra/cilre/xadni1.svg)

![](/assets/pixra/cilre/xadni2.svg)

### Parentesco

> **coi do mi se cmene zo .adam.**
> **.i ti du la .alis.**
> **.i ri speni mi**
> _Hola. Me llamo "Adam"._
> _Esta es Alice._
> _Ella es mi esposa._

> **pluka fa le nu penmi do**
> **.i .e'o do klama le nenri be le dinju**
> _¡Qué gusto conocerte!_
> _Por favor, entra a la casa._

<!-- -->

> **ki'e**
> _Gracias._

<!-- -->

> **.i .au gau mi do co'a slabu le lanzu be mi**
> **.i le re verba cu panzi mi**
> **.i le tixnu cu se cmene zo .flor.**
> **.i la .karl. cu du le bersa**
> _Me gustaría que conozcas a mi familia._
> _Los dos niños son mis hijos._
> _La hija se llama "Flor"._
> _Karl es el hijo._

<!-- -->

> **la .karl. cu mutce citno**
> _Karl es muy joven._

<!-- -->

> **ie**
> _Sí._

<!-- -->

> **.i ji'a mi se tunba re da noi ca na ku zvati le dinju**
> **.i sa'e mi se tunba le pa bruna .e le pa mensi**
> _También tengo dos hermanos que no están en casa ahora._
> _Para ser precisos, tengo un hermano y una hermana._

<!-- -->

> **ue**
> **.i le lanzu be do cu barda**
> _¡Wow!_
> _Tu familia es grande._

<!-- -->

> **je'u pei**
> _¿En serio?_

je'u
: interjección: realmente

Las palabras para los nombres de los miembros de la familia tienen una estructura de lugar similar:

speni
: $x_1$ es el esposo/esposa de $x_2$

**co'a speni** significa _casarse_:

> **mi co'a speni la .suzan.**
> _Me casé con Susan._

lanzu
: $x_1$ es una familia que incluye a $x_2$

panzi
: $x_1$ es un hijo/hija de $x_2$

tixnu
: $x_1$ es una hija de $x_2$

bersa
: $x_1$ es un hijo de $x_2$

tunba
: $x_1$ es un hermano/hermana de $x_2$

bruna
: $x_1$ es un hermano de $x_2$

mensi
: $x_1$ es una hermana de $x_2$

Ten en cuenta que **panzi** se puede aplicar a hijos adultos:

verba
: $x_1$ es un niño, una persona inmadura de edad $x_2$ (evento)

panzi
: $x_1$ es un hijo, descendiente de $x_2$

**verba** no necesariamente habla del niño como miembro de la familia:

> **le bersa be le pendo be mi cu verba le nanca be li ci**
> _El hijo de mi amigo es un niño de tres años._

citno
: $x_1$ es joven

laldo
: $x_1$ es viejo, de edad avanzada

Pares de palabras tradicionales (solo para humanos):

le ninmu
: mujer / mujeres

le nanmu
: hombre / hombres

le nixli
: las niñas

le nanla
: los niños

le remna
: los humanos

Ten en cuenta que **le prenu** significa _las personas_ o _los individuos_. En cuentos de hadas e historias fantásticas, no solo los humanos (**lo'e remna**) sino también animales o seres alienígenas de otros planetas pueden considerarse personas.

Estas palabras se pueden usar para describir el sexo determinado genéticamente (tanto en animales como en humanos) en contraposición al género:

le fetsi
: la hembra

le nakni
: macho

Estas palabras describen relaciones parentales (no necesariamente genéticas):

mamta
: $x_1$ es madre de $x_2$, $x_1$ actúa maternalmente

patfu
: $x_1$ es padre de $x_2$

rirni
: $x_1$ es progenitor de $x_2$, $x_1$ cría a $x_2$

### En la tienda

> **ue**
> **do pu te vecnu le laldo karce**
> _¡Guau!_
> _Compraste un coche viejo._

<!-- -->

> **ie**
> **.i ku'i mi na ku pu pleji le so'i jdini**
> _Sí._
> _Pero no pagué mucho dinero._

<!-- -->

> **ma pu jdima le karce**
> _¿Cuál fue el precio del coche?_

<!-- -->

> **mi pu pleji le rupnusudu be li pa ki'o le kagni le karce**
> _Pagué mil dólares a la compañía por el coche._

<!-- -->

> **mi pu vecnu le laldo karce pe mi le pendo be mi**
> **.i le pendo pu pleji le rupne'uru be li re ki'o mi le karce**
> _Vendí un coche viejo mío a mi amigo._
> _El amigo pagó 2 000 euros por el coche._

ki'o
: coma entre dígitos para que **pa ki'o** sea _1, 000_ (_mil_)

vecnu
: $x_1$ vende $x_2$ a $x_3$

te vecnu
: $x_1$ compra $x_2$ de $x_3$

pleji
: $x_1$ paga $x_2$ a $x_3$ por $x_4$

jdima
: $x_1$ es el precio de $x_2$

jdini
: $x_1$ es dinero

rupnusudu
: $x_1$ cuesta $x_2$ (número) dólares estadounidenses

rupne'uru
: $x_1$ cuesta $x_2$ (número) euros

### Tienda, edificios

> **ma stuzi le zdani be do**
> _¿Cuál es la ubicación de tu hogar?_

<!-- -->

> **le korbi be le cmana**
> **.i mi se zdani le nurma**
> **.i le zdani be mi cu barda dinju gi'e se sledi'u ci da .e le vimstu .e le lumstu**
> _El borde de la montaña._
> _Vivo en el campo._
> _Mi hogar es una casa grande y tiene tres habitaciones, además de un baño y un cuarto de baño._

<!-- -->

> **je'e**
> **.i ku'i mi pu jbena le tcadu .i je ca ti mi se zdani le jarbu be la .paris.**
> **.i mi xabju ne'a le zarci**
> _Entiendo._
> _Pero nací en la ciudad y ahora vivo en las afueras de París._
> _Vivo cerca de una tienda._

stuzi
: $x_1$ es un lugar

dinju
: $x_1$ es un edificio, una casa

sledi'u
: $x_1$ es una habitación, una parte de un edificio $x_2$

vimstu
: $x_1$ es un inodoro, un lugar para excretar

lumstu
: $x_1$ es un baño, un lugar para lavar algo

zdani
: $x_1$ es un hogar de $x_2$

se zdani
: $x_1$ vive en $x_2$, $x_1$ habita $x_2$

tcadu
: $x_1$ es una ciudad o pueblo

jarbu
: $x_1$ es una zona suburbana de la ciudad/pueblo $x_2$

nurma
: $x_1$ es una zona rural, $x_1$ está en el campo

zarci
: $x_1$ es una tienda