## Lección 3. Citas. Preguntas. Interjecciones

### «**sei**»: comentarios sobre el texto

La partícula **sei** permite insertar un comentario sobre nuestra actitud con respecto a lo que se dice en una relación:

> **do jinga sei mi gleki**
> _¡Ganaste! (¡Estoy feliz por eso!)_

Sin embargo:

> **do jinga sei la .ian. cu gleki**
> _¡Ganaste! (¡Yan está feliz por eso!)_

Al igual que con los argumentos formados usando **le**, la relación formada con **sei** debe terminar en una construcción de relación.

> **la .alis. cu prami sei la .bob. cu gleki la .kevin.**

Agreguemos paréntesis para que sea más fácil de leer.

> **la .alis. cu prami (sei la .bob. cu gleki) la .kevin.**
> _Alice ama (Bob está feliz) a Kevin._
> _Alice ama a Kevin (Bob está feliz)._

Por supuesto, también podemos agregar más argumentos a la relación con **be** y **bei**, como lo hacemos dentro de los términos de argumento:

> **do jinga sei mi zausku be fo la fircku**
> _¡Ganaste! (Publicaré felicitaciones en Facebook)_

la fircku
: Facebook

zausku
: $x_1$ elogia a $x_2$ para la audiencia $x_3$ a través del medio $x_4$

### Comillas

Para citar texto, colocamos la partícula de cita **lu** antes de la cita y colocamos **li'u** después de ella. El resultado es un argumento que representa el texto citado:

> **mi cusku lu mi prami do li'u**
> _Digo "Te amo"._

cusku
: $x_1$ expresa/dice $x_2$ (cita) a la audiencia $x_3$

Una característica interesante del Lojban es que las marcas **lu** — «cita» y **li'u** — «descita» son pronunciables. Es bastante útil ya que, en el Lojban hablado, no es necesario cambiar la entonación para mostrar dónde comienza y termina un texto citado.

Sin embargo, en un texto escrito que cita una conversación, el autor a menudo llama la atención del lector sobre el contenido de las citas. En esos casos, se prefiere usar **sei**.

También podemos anidar citas, por ejemplo:

> **la .ian. pu cusku lu la .djein. pu cusku lu coi li'u mi li'u**
> _Yan dijo: "Jane dijo: 'Hola' para mí"._

que es similar a

> **la .ian. pu cusku lu la .djein. pu rinsa mi li'u**
> _Yan dijo: "Jane me saludó"._

rinsa
: $x_1$ saluda a alguien $x_2$

<pixra url="/assets/pixra/cilre/rinsa2.webp" caption="le prenu cu rinsa mi" definition="La persona me saluda."></pixra>

Ten en cuenta que en Lojban, distinguimos las cosas y sus nombres:

> **lu le munje li'u cu cmalu**
> _"El universo" es pequeño._

<!-- -->

> **le munje na ku cmalu**
> _El universo no es pequeño._

le munje
: el universo, mundo

Aquí, el texto _"el universo"_ es pequeño, mientras que el universo no lo es.

---

Las interjecciones y vocativos funcionan como construcciones con **sei**:

> **je'u mi jinga sei ra cusku**
> _Verdaderamente, "Gané", dijo él._

je'u
: interjección: verdaderamente

Como puedes ver, **je'u** no forma parte de sus palabras. Representa tu actitud hacia la relación. Si quieres citar "**je'u mi jinga**", utiliza comillas de esta manera:

> **lu je'u mi jinga li'u se cusku ra**
> _"Verdaderamente, gané", dijo él._

¿Notas la diferencia entre los dos ejemplos?

Aquí hay varias palabras de relación comunes relacionadas con hablar:

> **ra pu retsku lu do klama ma li'u**
> _Ella preguntó: "¿A dónde vas?"_

<!-- -->

> **mi pu spusku lu mi klama le zdani li'u**
> _Respondí: "Voy a casa."_

<!-- -->

> **mi pu spuda le se retsku be ra le ka spusku lu mi klama le zdani li'u**
> _Respondí a su pregunta diciendo: "Voy a casa."_

spuda
: $x_1$ responde a $x_2$ haciendo $x_3$ (propiedad de $x_1$)

Las otras tres palabras de relación tienen la misma estructura de lugar:

cusku
: $x_1$ expresa/dice $x_2$ (cita) a la audiencia $x_3$

retsku
: $x_1$ pregunta a $x_2$ (cita) a la audiencia $x_3$

spusku
: $x_1$ responde/dice la respuesta $x_2$ (cita) a la audiencia $x_3$

### «**zo**» — citando una palabra

**zo** es un marcador de cita, similar a **lu**. Sin embargo, **zo** cita solo una palabra que le sigue inmediatamente. Esto significa que no requiere una palabra de des-cita como **li'u**; ya sabemos dónde termina la cita. Al hacer esto, ahorramos dos sílabas y hacemos nuestro discurso más conciso.

> **zo .robin. cmene mi**
> _"Robin" es mi nombre._
> _Mi nombre es Robin._

cmene
: $x_1$ (cita) es un nombre de $x_2$ ...

Para presentarte en Lojban usando tu nombre en Lojbanizado, sigue el ejemplo anterior. Si tu nombre consiste en más de una palabra, usa **lu ... li'u**:

> **lu .robin.djonsyn. li'u cmene mi**
> _Robin Johnson es mi nombre._

Otra opción es usar **me**:

> **mi me la .robin.djonsyn.**
> _Soy Robin Johnson._

Observa la diferencia: _"Robin"_ entre comillas es un nombre citado, mientras que Robin es una persona.

Para mostrar esto mejor, aquí hay una variación divertida:
> **zo .robin. cmene la .robin.**
> _"Robin" es el nombre de Robin._
> _"Robin" es un nombre de Robin._

El primer lugar de **cmene** es una cita, un texto. Por lo tanto, usamos **lu ... li'u** o **zo** para crear una cita y llenar el primer lugar de **cmene** con ella, en lugar de **la** (prefijo para nombres).

### Verbos de habla

Aquí hay algunas relaciones que describen el habla:

> **mi pu skicu le purdi le pendo be mi lo ka bredi**
> _Le conté a mi amigo sobre mi jardín listo._

skicu
: $x_1$ cuenta sobre $x_1$ (objeto/evento/estado) a $x_3$ con descripción $x_4$ (propiedad)

bredi
: ... está listo para ...

> **mi pu cusku lu le purdi cu bredi li'u le pendo be mi lo ka cladu bacru**
> _Le dije a mi amigo: "El jardín está listo", al pronunciarlo en voz alta._

cusku
: $x_1$ dice $x_2$ (texto) para la audiencia $x_3$ a través del medio $x_4$

cladu
: ... es ruidoso

> **mi pu tavla le pendo be mi le nu le purdi cu bredi kei le lojbo**
> _Hablé con mi amigo en Lojban sobre el jardín listo._

tavla
: $x_1$ habla con $x_2$ sobre el tema $x_3$ en el idioma $x_4$

En resumen:

* **skicu** significa _contar_, _describir con alguna descripción_,
* **cusku** significa _decir algún texto_,
* **tavla** significa _hablar en un idioma_.

### Preguntas de contenido

El inglés tiene varias palabras de pregunta _wh-_: _who_, _what_, etc. En Lojban, para ambas usamos una palabra: **ma**. Esta palabra es un argumento (como **mi**, **le prenu**, etc.) y es como una sugerencia para llenar el lugar faltante. Por ejemplo:

> **— do klama ma**
> **— la .london.**
> _— ¿A dónde vas?_
> _— Londres._

<!-- -->

> **— ma klama la .london.**
> **— la .kevin.**
> _— ¿Quién va a Londres?_
> _— Kevin._

> **— mi plicru do ma**
> **— le plise**
> <span>_— ¿Qué te doy?_ (probablemente significa _¿Qué era lo que se suponía que debía darte?_)</span>
> _— La manzana._

Para traducir _which/what_, también usamos **ma**:

> **— ma gugde gi'e se xabju do**
> **— le gugde'usu**
> _— ¿En qué país vives?_
> _— Estados Unidos_
> `— ¿Qué es un país y está habitado por ti?`
> `— Estados Unidos`

xabju
: … (alguien) habita … (algún lugar)

se xabju
: … (algún lugar) está habitado por … (alguien)

**mo** es similar a **ma**, pero es una palabra de relación.

**mo** sugiere llenar una relación en lugar de un argumento. Es como preguntar _¿Qué hace X?_ o _¿Qué es X?_ en inglés (Lojban no te obliga a distinguir entre ser y hacer).

Podemos ver **mo** como pedirle a alguien que describa la relación entre los argumentos en la pregunta.

> **— do mo**
> _— ¿Cómo estás? ¿Qué tal?_
> `— ¿Tú eres qué, tú haces qué?`

Esta es la forma más común de preguntar _¿Cómo estás?_ o _¿Qué tal?_ en Lojban. Algunas respuestas posibles:

> **— mi gleki**
> _— Estoy feliz._

gleki
: $x_1$ es feliz

> **— mi kanro**
> _— Estoy saludable._

<!-- -->

> **mi tatpi**
> _Estoy cansado._

<!-- -->

> **mi gunka**
> _Estoy trabajando._

Otra forma de preguntar _¿Cómo estás?_:

> **— do cinmo le ka mo**
> _— ¿Cómo te sientes (emocionalmente)?_

cinmo
: $x_1$ siente $x_2$ (propiedad de $x_1$)

Otros ejemplos:

> **ti mo**
> _¿Qué es esto?_

<!-- -->

> **la .meilis. cu mo**
> _¿Quién es Mei Li? / ¿Qué es Mei Li? / ¿Qué está haciendo Mei Li?_

Respuestas posibles dependiendo del contexto:

- **ninmu**: _Es una mujer._
- **jungo**: _Es china._
- **pulji**: _Es una oficial de policía._
- **sanga**: _Es una cantante_ o _Está cantando._

> **do mo la .kevin.**
> _¿Qué eres para Kevin?_
> `Tú eres qué (haces qué) para Kevin.`

La respuesta depende del contexto. Respuestas posibles a esta pregunta son:

- **nelci**: _Me gusta él._
- **pendo**: _Soy su amigo/a._
- **prami**: _Lo adoro/estoy enamorado/a de él._
- **xebni**: _Lo odio._
- **fengu**: _Estoy enojado/a con él._
- **cinba**: _Lo besé._

Nuevamente, ten en cuenta que el tiempo no es importante aquí: al igual que **cinba** puede significar _besar_, _besó_, _besará_, etc., **mo** no hace una pregunta sobre un tiempo específico.

Si queremos diferenciar entre _hacer_ y _ser alguien o algo_, utilizamos relaciones adicionales:

> **la Mei Li cu zukte ma**
> `¿Qué hace Mei Li?`
> _¿Qué hace Mei Li?_

> **le ka lumci**
> _limpiar._

<!-- -->

> **la Mei Li cu zukte le ka lumci**
> _Mei Li está limpiando._

zukte
: $x_1$ hace $x_2$ (propiedad de $x_1$)

lumci
: ...limpia o lava... (algo)

<pixra url="/assets/pixra/cilre/lumci.webp" caption="ra lumci le zdani" definición="Ella limpia la casa."></pixra>

> **do du ma**
> `¿Quién eres?`

> **mi du le ctuca**
> _Yo soy el maestro._

El uso de términos modales con **ma** nos puede dar otras preguntas útiles:

<table>
<tbody><tr>
<th>palabra
</th>
<th>significado
</th>
<th><code>[literalmente]</code>
</th></tr>
<tr>
<td><b>ca ma</b>
</td>
<td>¿Cuándo?
</td>
<td>durante qué
</td></tr>
<tr>
<td><b>bu'u ma</b>
</td>
<td>¿Dónde?
</td>
<td>en qué
</td></tr>
<tr>
<td><b>ma prenu gi'e …</b>
</td>
<td>¿Quién?
</td>
<td>quién es una persona y …
</td></tr>
<tr>
<td><b>ma dacti gi'e</b>
</td>
<td>¿Qué? (sobre objetos)
</td>
<td>qué es un objeto y …
</td></tr>
<tr>
<td><b>ri'a ma</b>
</td>
<td>¿Por qué?
</td>
<td>por qué razón
</td></tr>
<tr>
<td><b>pe ma</b>
</td>
<td>¿De quién? ¿Cuál? ¿Sobre qué?
</td>
<td>relativo a qué o a quién
</td></tr>
<tr>
<td><b>le mlatu poi mo</b>
</td>
<td>¿Qué gato? ¿Qué tipo de gato?
</td>
<td>
</td></tr></tbody></table>

**pe ma** se adjunta solo a los argumentos:

> **le penbi pe ma cu zvati le jubme**
> _¿De quién es la pluma que está en la mesa?_

### Preguntas de cantidad

> **le xo prenu cu klama ti**
> _¿Cuántas personas vienen aquí?_

<!-- -->

> **mu**
> _Cinco._

La palabra **xo** significa _¿Cuántos?_ y por lo tanto pregunta por un número. La respuesta completa sería:

> **le mu prenu cu klama ti**
> _Las 5 personas vienen a este lugar._

Se supone que la persona a la que se le pregunta debe colocar un valor apropiado en lugar de **xo**.

Aquí hay algunos ejemplos más:

> **le xo botpi cu kunti**
> _¿Cuántas botellas están vacías?_

<!-- -->

> **do ralte le xo gerku**
> _¿Cuántos perros tienes?_

### Verbos de hechos

Considera el ejemplo:

> **mi djuno le du'u do stati**
> _Sé que eres inteligente._

djuno
: $x_1$ sabe $x_2$ (proposición) sobre $x_3$

> **mi jimpe le du'u do pu citka**
> _Entiendo que estabas comiendo._

jimpe
: $x_1$ comprende $x_2$ (proposición) sobre $x_3$

<pixra url="/assets/pixra/cilre/na_jimpe.webp" caption="mi na jimpe" definition="No entiendo."></pixra>

En lugares que describen hechos, se utiliza la partícula **du'u** (en lugar de **nu**).

**djuno** (_saber_) y **jimpe** (_entender_) describen hechos. Sería ilógico decir: _Entiendo que estabas comiendo, pero en realidad no lo estabas._

Ten en cuenta que la relación que comienza con **du'u** no tiene que ser verdadera:

> **le du'u do mlatu cu jitfa**
> _Que tú eres un gato es falso._

jitfa
: $x_1$ (proposición) es falso

¿Cuándo debes usar **du'u** y cuándo debes usar **nu**? Puedes consultar el diccionario:

- La etiqueta _(du'u)_ o _(proposición)_ marca los lugares donde se recomienda **du'u**.
- La etiqueta _(nu)_ o _(evento)_ marca los lugares donde se recomienda **nu**.

Si por error usas **nu** en lugar de **du'u**, aún serás comprendido. Sin embargo, los hablantes fluidos de Lojban suelen distinguir entre estas partículas.

### Preguntas indirectas

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Sé quién está estudiando Lojban._

Esto se llama una pregunta indirecta. La palabra _quién_ aquí no es una solicitud de información y no hay un signo de interrogación. Se presume la respuesta, y de hecho, tú mismo conoces la respuesta a la pregunta _¿Quién está aprendiendo Lojban?_

**kau** es una interjección que colocamos después de una palabra interrogativa para indicar que es una pregunta indirecta.

Si te hago la pregunta **ma tadni la .lojban.**, sabes qué valor llenar en el espacio de **ma**: **la .kevin.** Así que podrías simplemente decir:

> **ma tadni la .lojban.**
> _¿Quién está estudiando Lojban?_

<!-- -->

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Sé quién está estudiando Lojban. Conozco la identidad de la persona que está estudiando Lojban._

<!-- -->

> **mi djica le nu ma tadni la .lojban.**
> _¿A quién quiero que estudie Lojban?_
> `¿A quién quiero que estudie Lojban?`

Esto nunca puede ser una pregunta indirecta: está pidiendo una respuesta (incluso si lo haces de manera retórica).

Puedes colocarlo después de otras palabras interrogativas:

> **Sé que muchas personas estudian Lojban.**

### Citas indirectas (discurso reportado): "_Dije que vendría._"

Una relación como _Alice dijo: "Michelle me dijo 'Hola'"_ también se puede expresar de una manera más sutil:

> **Alice dijo algo sobre Michelle saludándola antes.**
> `Alice dijo algo sobre el evento de Michelle saludándola.`

Alternativamente, se puede hacer más corto:

> **Alice dijo que Michelle la había saludado.**

La combinación **se du'u** permite la expresión de discurso indirecto.

Aquí hay algunos ejemplos de relaciones útiles para el discurso reportado:

> **Ella preguntó dónde iba yo.**

<!-- -->

> **Respondí que iba a casa.**

<!-- -->

> **Le respondí a su pregunta diciendo que iba a casa.**

Preguntas en discurso reportado:

> **¿A quién dije que está estudiando Lojban?**
> `Dije quién está estudiando Lojban?`

Por lo tanto, Lojban tiene varias palabras para _eso..._, dependiendo de qué tipo de cosa se quiera decir.

- Si _eso_ describe lo que se puede ver, oír o lo que sucede, usa **nu**.
- Si _eso_ describe lo que piensas, algún hecho o información, usa **du'u**.
- Si _eso_ describe lo que dices, usa **se du'u**.
  - Pero si necesitas una cita literal, usa **lu...li'u**.

### Interjecciones emocionales: "_¡Yay!_" = «**ui**», "_¡Sí!_" = «**ie**», "_¡Uf!_" = «**.o'u**»

Conocemos estas interjecciones como **ui** (_¡Yay!_), **.a'o** (_Espero_).

> **¡Tú ganaste! (¡Estoy feliz por eso!)**

ui
: interjección: _¡Yay!_, interjección de felicidad

<pixra url="/assets/pixra/cilre/ui_jinga.webp" caption="ui mi jinga" definition="¡Yay! ¡Gané!"></pixra>

Las interjecciones funcionan como **sei** con sus relaciones. **ui** significa lo mismo que **sei mi gleki**, por lo que también podríamos decir **do jinga sei mi gleki**, que significa lo mismo (aunque es un poco más largo).

Hay interjecciones que expresan otros estados emocionales. Son similares a los emoticonos como ;-) o :-(, pero en Lojban podemos ser más específicos acerca de nuestras emociones y seguir siendo concisos en nuestro lenguaje.

> **ie tu mlatu**
> _Sí, eso es un gato._

<!-- -->

> **ie nai .i tu na ku mlatu**
> _No, no estoy de acuerdo. Eso no es un gato._

ie
: interjección: _¡Sí! ¡Ajá!_ (acuerdo)

ie nai
: interjección: desacuerdo

> **.ai mi vitke do**
> _Voy a visitarte._

.ai
: interjección: _Voy a ..._ (intención)

> **.au do kanro**
> _Deseo que estés sano._

.au
: interjección de deseo

<pixra url="/assets/pixra/cilre/clira.webp" caption="mi clira klama" definition="Llegué temprano."></pixra>

> **.a'o do clira klama**
> _Espero que llegues temprano._

.a'o
: interjección: espero

clira
: $x_1$ ocurre temprano

<pixra url="/assets/pixra/cilre/ciska.webp" caption=".ei mi ciska le xatra ti voi pelji ku'o le penbi" definition="Debería escribir la carta en este papel usando el bolígrafo."></pixra>

> **.ei mi ciska le xatra le pelji le penbi**
> _Debería escribir la carta en el papel usando el bolígrafo._

.ei
: Debería ... (obligación)

ciska
: $x_1$ escribe $x_2$ en el medio $x_4$

> **.i'e do pu gunka le vajni**
> _¡Muy bien! Hiciste un trabajo importante._

.i'e
: interjección: _¡Bien!_ (aprobación)

> **.o'u tu mlatu**
> _Oh, eso es solo un gato._

.o'u
: interjección: _Uf!_ (relajación)

En este caso, probablemente pensaste que era algo peligroso, pero es solo un gato, por eso dices **.o'u**.

> **.u'i ti zmitci**
> _Ja-ja, esto es un robot._

.u'i
: interjección: _Ja-ja!_ (diversión)

zmitci
: ... es una herramienta automática

Puedes agregar o quitar interjecciones en una oración sin riesgo de romperla.

Cualquier palabra que comience con una vocal pura (excluyendo **u** e **i** antes de vocales) se le antepone un punto en Lojban al escribir y una pausa al hablar. Por lo tanto, la escritura correcta es **.a'o** y así sucesivamente. Es común omitir los puntos al escribir. Sin embargo, al hablar, siempre debes mostrar este punto haciendo una breve pausa antes de pronunciar dicha palabra para evitar fusionar dos palabras vecinas en una sola.

Como con las relaciones **xu** o **sei**, podemos agregar interjecciones después de cualquier argumento o construcción de relación, expresando así nuestra actitud hacia esa parte de la oración.

### Interjecciones de urgencia

Un grupo especial de interjecciones "imperativas/hortativas" se utilizan para instigaciones, comandos y peticiones. Ya hemos encontrado **.e'o**:

> **.e'o mi ciksi da poi mi cusku djica**
> _Por favor, déjame explicar lo que quiero decir._

.e'o
: interjección: _Por favor..._ (petición)

> **— au mi klama le nenri**
> **— .e'a**
> _— Me gustaría entrar._
> _— Por favor, hazlo._

.e'a
: interjección: _Permito, puedes..._ (permiso)

le nenri
: el interior, lo que está dentro

> **.e'ei do zukte**
> _¡Vamos, hazlo!_

.e'ei
: interjección: _¡Vamos!_ (estímulo, instigación, provocación). Palabra no oficial

> **.e'i do zutse doi le verba**
> _¡Siéntate, niño!_

.e'i
: interjección: _¡Haz eso!_ (mando)

> **.e'u do pinxe le jisra**
> _Sugiero que bebas el jugo. Sería mejor que lo bebas._

.e'u
: interjección: _Vamos a..._ (sugerencia)

### «**ko**» para urgencias más rápidas

> **do bajra**
> _Tú corres._

<!-- -->

> **bajra**
> _Alguien corre._

En inglés, el verbo en sí mismo es un mandato:

> _¡Corre!_

En lojban, **bajra** como una oración significa _Alguien corre_ (o _está corriendo_ / _corrió_, dependiendo del contexto). **bajra** también puede significar un mandato, _¡Corre!_, pero a veces el contexto no es suficiente para determinar si es una urgencia de correr o simplemente una afirmación de que alguien corre o está corriendo.

El pronombre **ko** se utiliza en lugar de **do** para hacer peticiones, sugerencias o mandatos:

> **ko bajra**
> _¡Corre! ¡Hazlo para que corras!_

**ko** es una alternativa más vaga a **do .e'o**, **do .e'u**, **do .e'i**.

Es perfectamente aceptable decir algo más preciso, como:

> **do .e'o bajra**
> _Tú, por favor, ¡corre!_

poniendo énfasis en nuestra cortesía en **do** (_tú_).

Al mover **ko** en una relación, el mandato/petición se traslada a esa parte. Por ejemplo:

> **nelci ko**
> _¡Haz que alguien te quiera!_

nelci
: ...le gusta... (algo o alguien)

Como puedes ver, tenemos que reestructurar esta relación en inglés, lo cual aún suena extraño. Sin embargo, podrías usarlo en lojban en el sentido de _Intenta causar una buena impresión_.

Ten en cuenta que **prami** corresponde a _to love_ en inglés, mientras que **nelci** corresponde a _to like_ en inglés.

Incluso podemos tener varios **ko** en una sola oración:

> **ko kurji ko**
> _Cuídate._

kurji
: ... se ocupa de ... (alguien o algo)

### Interjecciones discursivas

> **au mi citka le salta .e ji'a le grute**
> _Me gustaría comer la ensalada y también las frutas._

ji'a
: _además, también_, significa que existen otros que también son iguales (en este caso, tú) o que hacen lo mismo

salta
: ... es alguna ensalada

grute
: ... es una fruta

> **mi si'a nelci do**
> `También me gustas a ti`

<!-- -->
> **— mi nelci le'e mlatu**
> **— mi si'a nelci le'e mlatu**
> _— Me gustan los gatos._
> _— A mí también me gustan los gatos._

si'a
: _similarmente, también_, denota que algo es similar aunque sea diferente en otros aspectos no mencionados

### Estructura de las interjecciones: «**nai**», «**sai**», «**pei**», «**dai**»

Las interjecciones pueden consistir en

1. la raíz, como **ui** (_¡Hurra!_)
2. después de ella, sufijos como **pei**, **dai**, **zo'o**:

    > **ui zo'o**
    > _¡Hurra! (bromeando, en realidad no estoy feliz)_

3. tanto la raíz como cada uno de los sufijos pueden ser modificados con partículas escalares como **nai**:

    > **ui nai**
    > _¡Ay!_

    <!-- -->
    > **ui nai zo'o**
    > _¡Ay! (bromeando, no estoy en serio con este sentimiento)_

    <!-- -->
    > **ui nai zo'o nai**
    > _¡Ay, no estoy bromeando, me siento infeliz_

Algunos ejemplos de cómo funcionan las partículas escalares.

- **ju'o** = _interjección: estoy seguro (certeza)_
- **ju'o cu'i** = _interjección: tal vez, quizás (incertidumbre)_
- **ju'o nai** = _interjección: ¡no tengo idea!_

Ejemplos comunes de interjecciones:

- una interjección formada por una raíz desnuda:

 > **ju'o le bruna co'i klama**
 > _Estoy seguro, el hermano ha venido._

- la partícula escalar **cu'i** convierte una interjección de raíz desnuda en su actitud media:

 > **ju'o cu'i le bruna co'i klama**
 > _Tal vez el hermano ha venido, no estoy seguro._

- la partícula escalar **nai** convierte la interjección en la actitud opuesta:

 > **ju'o nai le bruna co'i klama**
 > _Tal vez el hermano ha venido, tal vez no, no tengo idea._

Del mismo modo, **ui** es _¡Whee! ¡Yay!_, mientras que **ui nai** significa _¡Ay!_

Los significados precisos de las interjecciones que son significativas con sus partículas escalares **cu'i** y **nai** se encuentran en el diccionario.

- La partícula escalar **sai** denota una intensidad fuerte de la interjección:

 > **.u'i sai**
 > _¡Ja-ja-ja!_

Los vocativos también pueden ser modificados con partículas escalares:

> **ki'e sai do**
> _¡Muchas gracias!_

Los sufijos se agregan después de la raíz de la interjección (junto con sus partículas escalares si las usamos):

- El sufijo de interjección **pei** convierte la interjección en una pregunta.

 > **— .au pei do .e mi klama le zarci**
 > **— .au cu'i**
 > _— ¿Quieres que tú y yo vayamos a la tienda?_
 > _— Meh, no tengo preferencias._

 <!-- -->

 > **— ie pei tu melbi**
 > **— ie**
 > _— ¿Ese es bonito, verdad?_
 > _— Sí._

- El sufijo de interjección **dai** muestra los sentimientos de los demás, no los sentimientos del hablante:

 > **ui nai dai do na ku co'i jinga**
 > _Debes estar triste, no has ganado._

 <!-- -->

 > **.a'u**
 > _¡Eso es interesante!_

 <!-- -->

 > **.a'u dai**
 > _¡Eso debe haber sido interesante para ti!_

- Las interjecciones simples expresan la actitud del hablante. **ei do cliva** no significa _Deberías irte_, sino _Siento la obligación de que te vayas_. **dai** muestra que el hablante está empatizando con los sentimientos de otra persona.

 > **.ei dai do cliva**
 > _Sientes la obligación de irte._

Ten en cuenta que las interjecciones no necesariamente muestran una actitud hacia los propios hablantes. En cambio, expresan la actitud de los hablantes hacia otras cosas.

- El sufijo de interjección **zo'o** marca la actitud como expresada no seriamente:

 > **.e'u zo'o do pinxe ti**
 > _Sugiero que lo bebas (en broma)._

- Los sufijos también pueden ser modificados con partículas escalares:

 > **ie zo'o nai**
 > _Estoy de acuerdo (en serio)._

- **zo'o nai** se usa para mostrar que la información no es una broma:

 >**zo'o nai ra pu klama la .paris.**
 >_— Hablo en serio, él fue a París._

- Los sufijos se pueden usar por sí solos:

  - **pei** cuando se usa solo, pide cualquier interjección que el oyente considere apropiada:

> **— pei le lunra cu crino**
> **— .ie nai**
> _— La luna es verde (¿qué opinas al respecto?)_
> _— No estoy de acuerdo._

- Para otros sufijos, significa que se omitió la interjección raíz **ju'a** (_lo afirmo_):

 > **zo'o do kusru**
 > **ju'a zo'o do kusru**
 > _Eres cruel (bromeando)._

 ju'a
 : interjección: lo afirmo (no confundir con **ju'o** (estoy seguro))

### Solo como referencia: interjecciones en tablas

Aquí tienes una vista más completa: interjecciones emocionales, de urgencia y varias otras por series.

<table>
<tbody><tr>
<td><b>.au</b><br/><i>Deseo que...</i>
</td>
<td><b>.ai</b><br/><i>Voy a...</i>
</td>
<td><b>.ei</b><br/><i>Debería ser...</i>
</td>
<td><b>.oi</b><br/><i>¡Ay!</i>
</td></tr>
<tr>
<td><b>.au cu'i</b><br/><i>meh</i><br/>indiferencia
</td>
<td><b>.ai cu'i</b><br/>indecisión
</td>
<td><b>.ei cu'i</b>
</td>
<td><b>.oi cu'i</b>
</td></tr>
<tr>
<td><b>.au nai</b><br/><i>¡No! ¡De ninguna manera!</i><br/>desgana, reluctancia
</td>
<td><b>.ai nai</b><br/>sin querer, accidentalmente
</td>
<td><b>.ei nai</b><br/>libertad, cómo las cosas podrían no ser necesarias
</td>
<td><b>.oi nai</b><br/>placer
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emoción</th></tr></thead>
<tbody>
<tr>
<td><b>ua</b><br/><small>"wah" como en "<u>wo</u>n", "<u>o</u>nce"</small><br/><i>¡Ajá! ¡Eureka!</i>
</td>
<td><b>ue</b><br/><small>"weh" como en "<u>we</u>t"</small><br/><i>¡Qué sorpresa!</i>
</td>
<td><b>ui</b><br/><small>"weeh" como "we"</small><br/><i>¡Hurra!</i>
</td>
<td><b>uo</b><br/><small>"woh" como en "<u>wo</u>mbat", "<u>wha</u>t"</small><br/><i>¡Voilà!</i>
</td>
<td><b>uu</b><br/><small>"wooh" como "woo"</small><br/><i>¡Pobrecito!</i>
</td></tr>
<tr>
<td><b>ua cu'i</b><br/>&nbsp;
</td>
<td><b>ue cu'i</b><br/><i>No me sorprende realmente</i>
</td>
<td><b>ui cu'i</b><br/>&nbsp;
</td>
<td><b>uo cu'i</b><br/>&nbsp;
</td>
<td><b>uu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ua nai</b><br/><i>¡Vaya! ¡No lo entiendo!</i><br/>confusión
</td>
<td><b>ue nai</b><br/>expectativa, falta de sorpresa
</td>
<td><b>ui nai</b><br/><i>¡Ay!</i><br/>sentimiento de infelicidad
</td>
<td><b>uo nai</b><br/>sentimiento de incompletitud
</td>
<td><b>uu nai</b><br/><i>¡Mwa ja ja!</i><br/>crueldad
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emoción</th></tr></thead>
<tbody>
<tr>
<td><b>ia</b><br/><small>"yah" como en "<u>ya</u>rd"</small><br/><i>Creo</i>
</td>
<td><b>ie</b><br/><small>"yeh" como en "<u>ye</u>s"</small><br/><i>¡sí! ¡de acuerdo!</i>
</td>
<td><b>ii</b><br/><small>"yeeh" como en "hear <u>ye</u>"</small><br/><i>¡ay, qué miedo!</i>
</td>
<td><b>io</b><br/><small>"yoh" como en "<u>yo</u>gurt"</small><br/><i>respeto</i>
</td>
<td><b>iu</b><br/><small>"yooh" como en "c<u>u</u>te, d<u>ew</u>"</small><br/><i>Me encanta</i>
</td></tr>
<tr>
<td><b>ia cu'i</b><br/>&nbsp;
</td>
<td><b>ie cu'i</b><br/>&nbsp;
</td>
<td><b>ii cu'i</b><br/>&nbsp;
</td>
<td><b>io cu'i</b><br/>&nbsp;
</td>
<td><b>iu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ia nai</b><br/><i>¡Bah!</i><br/>incredulidad
</td>
<td><b>ie nai</b><br/>desacuerdo
</td>
<td><b>ii nai</b><br/><i>Me siento seguro</i>
</td>
<td><b>io nai</b><br/>falta de respeto
</td>
<td><b>iu nai</b><br/>odio
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emoción</th></tr></thead>
<tbody>
<tr>
<td><b>.u'a</b><br/><small>"oohah" como en "t<u>wo ha</u>lves"</small><br/><i>ganancia</i>
</td>
<td><b>.u'e</b><br/><small>"ooheh" como en "t<u>wo hea</u>ds"</small><br/><i>¡qué maravilla!</i>
</td>
<td><b>.u'i</b><br/><small>"ooheeh" como en "t<u>wo hee</u>ls"</small><br/><i>¡jajaja!</i>
</td>
<td><b>.u'o</b><br/><small>"oohoh" como en "t<u>wo haw</u>ks"</small><br/><i>coraje</i>
</td>
<td><b>.u'u</b><br/><small>"oohooh" como en "t<u>wo hoo</u>ds"</small><br/><i>¡perdón!</i>
</td></tr>
<tr>
<td><b>.u'a cu'i</b><br/>&nbsp;
</td>
<td><b>.u'e cu'i</b><br/>&nbsp;
</td>
<td><b>.u'i cu'i</b><br/>&nbsp;
</td>
<td><b>.u'o cu'i</b><br/>timidez
</td>
<td><b>.u'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.u'a nai</b><br/>pérdida
</td>
<td><b>.u'e nai</b><br/><i>¡Bah!</i><br/>cotidiano
</td>
<td><b>.u'i nai</b><br/><i>Bah</i><br/>cansancio
</td>
<td><b>.u'o nai</b><br/>cobardía
</td>
<td><b>.u'u nai</b><br/>&nbsp;
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Actitud</th></tr></thead>
<tbody>
<tr>
<td><b>.i'a</b><br/><small>"eehah" como en "t<u>eaho</u>use"</small><br/><i>ok, lo acepto</i>
</td>
<td><b>.i'e</b><br/><small>"eeheh" como en "t<u>eahea</u>d"</small><br/><i>¡lo apruebo!</i>
</small></td>
<td><b>.i'i</b><br/><small>"eeheeh" como en "w<u>e hea</u>t"</small><br/><i>Estoy de acuerdo contigo</i>
</td>
<td><b>.i'o</b><br/><small>"eehoh" como en "w<u>e haw</u>"</small><br/><i>gracias a eso</i>
</td>
<td><b>.i'u</b><br/><small>"eehooh" como en "w<u>e hoo</u>k"</small><br/><i>familiaridad</i>
</td></tr>
<tr>
<td><b>.i'a cu'i</b><br/>&nbsp;
</td>
<td><b>.i'e cu'i</b><br/>no aprobación
</td>
<td><b>.i'i cu'i</b><br/>&nbsp;
</td>
<td><b>.i'o cu'i</b><br/>&nbsp;
</td>
<td><b>.i'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.i'a nai</b><br/>resistencia
</td>
<td><b>.i'e nai</b><br/><i>¡Bu!</i><br/>desaprobación
</td>
<td><b>.i'i nai</b><br/>sentimiento de antagonismo
</td>
<td><b>.i'o nai</b><br/>envidia
</td>
<td><b>.i'u nai</b><br/>desconocimiento
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Adjunto a la situación</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.a'a</b><br/><small>"ahah" como "aha"</small><br/><i>Estoy escuchando</i>
</td>
<td><b>.a'e</b><br/><small>"aheh"</small><br/><i>atención</i>
</td>
<td><b>.a'i</b><br/><small>"aheeh" como en "Sw<u>ahi</u>li"</small><br/><i>¡Uf!</i><br/>esfuerzo
</td>
<td><b>.a'o</b><br/><small></small><br/><i>Espero</i>
</td>
<td><b>.a'u</b><br/><small></small><br/><i>Mmm, me pregunto...</i>
</td></tr>
<tr>
<td><b>.a'a cu'i</b><br/>desatentamente
</td>
<td><b>.a'e cu'i</b><br/>&nbsp;
</td>
<td><b>.a'i cu'i</b><br/>sin esfuerzo especial
</td>
<td><b>.a'o cu'i</b><br/>&nbsp;
</td>
<td><b>.a'u cu'i</b><br/><i>Bah</i><br/>desinterés
</td></tr>
<tr>
<td><b>.a'a nai</b><br/>evitando
</td>
<td><b>.a'e nai</b><br/><i>Estoy cansado/a</i>
</td>
<td><b>.a'i nai</b><br/>reposo
</td>
<td><b>.a'o nai</b><br/><i>¡Ay!</i><br/>desesperación
</td>
<td><b>.a'u nai</b><br/><i>¡Puaj! ¡Qué asco!</i><br/>repulsión
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Instigación</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.e'a</b><br/><small>"ehah"</small><br/><i>puedes</i>
</td>
<td><b>.e'ei</b><br/><small>"ehey"</small><br/><i>vamos, hazlo</i>
</td>
<td><b>.e'i</b><br/><small>"eheeh"</small><br/><i>¡hazlo!</i>
</td>
<td><b>.e'o</b><br/><small>"ehoh"</small><br/><i>por favor, hazlo</i>
</td>
<td><b>.e'u</b><br/><small>"ehooh"</small><br/><i>te sugiero</i>
</td></tr>
<tr>
<td><b>.e'a cu'i</b><br/>&nbsp;
</td>
<td><b>.e'ei cu'i</b><br/>&nbsp;
</td>
<td><b>.e'i cu'i</b><br/>&nbsp;
</td>
<td><b>.e'o cu'i</b><br/>&nbsp;
</td>
<td><b>.e'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.e'a nai</b><br/>prohibiendo
</td>
<td><b>.e'ei nai</b><br/>expresando desaliento, desmoralización
</td>
<td><b>.e'i nai</b><br/>&nbsp;
</td>
<td><b>.e'o nai</b><br/>ofreciendo, concediendo
</td>
<td><b>.e'u nai</b><br/>advertencia, desaconsejar
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emoción</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.o'a</b><br/><small>"ohah"</small><br/><i>orgullo</i>
</td>
<td><b>.o'e</b><br/><small>"oheh"</small><br/><i>lo siento cerca</i>
</td>
<td><b>.o'i</b><br/><small>"oheeh"</small><br/><i>¡peligro!</i>
</td>
<td><b>.o'o</b><br/><small>"ohoh" como en "s<u>awho</u>rse"</small><br/><i>paciencia</i>
</td>
<td><b>.o'u</b><br/><small>"ohooh"</small><br/><i>relajación</i>
</td></tr>
<tr>
<td><b>.o'a cu'i</b><br/>modestia, humildad
</td>
<td><b>.o'e cu'i</b><br/>&nbsp;
</td>
<td><b>.o'i cu'i</b><br/>&nbsp;
</td>
<td><b>.o'o cu'i</b><br/>mera tolerancia
</td>
<td><b>.o'u cu'i</b><br/>serenidad, equilibrio
</td></tr>
<tr>
<td><b>.o'a nai</b><br/><i>¡Qué vergüenza!<br/>Me hace sentir avergonzado/a.</i>
</td>
<td><b>.o'e nai</b><br/>distancia
</td>
<td><b>.o'i nai</b><br/>imprudencia, temeridad
</td>
<td><b>.o'o nai</b><br/>impaciencia, intolerancia
</td>
<td><b>.o'u nai</b><br/>estrés, ansiedad
</td></tr></tbody></table>

Observa cómo una emoción cambia a su opuesto al usar **nai**, y a una emoción intermedia al usar **cu'i**.

¿Por qué algunas celdas de interjecciones con **cu'i** y **nai** están vacías? Porque el inglés carece de formas concisas de expresar tales emociones.

Además, muchas de estas interjecciones se usan raramente.

### Combinando interjecciones

> **iu ui nai**
> _Tristemente enamorado/a._

<!-- -->

> **ue ui do jinga**
> _¡Oh, ganaste! ¡Estoy tan feliz!_

jinga
: ...gana

En este caso, la victoria era improbable, así que estoy sorprendido/a y feliz al mismo tiempo.

Las interjecciones (a diferencia de las partículas escalares y los sufijos de interjección) no se modifican entre sí:

> **ue ui do jinga**
> **ui ue do jinga**
> _¡Oh, ganaste! ¡Estoy tan feliz!_

Aquí, dos interjecciones modifican la misma construcción (la oración completa), pero no se modifican entre sí, por lo que su orden no es importante.

> **pei .u'i le gerku cu sutra plipe**
> _(¿Qué sientes?) Jeje, el perro salta rápidamente._

Aquí, **pei** se usa solo y no modifica a **.u'i**, que se coloca después de él.

### ¿Olvidaste poner una interjección al principio?

> **do pu sidju mi ui**
> _Tú me ayudas (¡yay!)_

**ui** solo modifica al pronombre **mi**, expresando la actitud solo hacia _mí_.

> **ui do pu sidju mi**
> _¡Yay, tú me ayudaste._

¿Qué pasa si olvidamos agregar **ui** al principio de esta oración?

Podemos etiquetar explícitamente la relación como completa con **vau** y luego poner la interjección:

> **do pu sidju mi vau ui**
> _Tú me ayudaste, ¡yay!_