## Lección 11. Temas más complicados

### Conoce también tu primer idioma

Cuando intentes expresarte en lojban, es importante no convertirlo en una mera copia del español.

Considere la frase:

> _Terry, el tigre, visita la gran ciudad._
Podría resultar tentador utilizar la relación

vitke
: $x_1$ (invitado) visita $x_2$ (alguien) en $x_3$

Sin embargo, la frase _visitas la gran ciudad_ implica visitar un lugar, no a alguien en ese lugar, lo que resalta el hecho de que el verbo inglés _to visit_ puede tener varios significados.

De hecho, por ejemplo, si consideramos el francés, vemos soluciones separadas:

> Me gustaría visitar a mis amigos.<br/>
> J'aimerais rendre visite à mes amis.
<!-- -->

> Me gustaría visitar esta ciudad.<br/>
> J'aimerais visitante cette ville.
El francés usa _rendre visite_ cuando visita a alguien y _visiter_ cuando visita un lugar.

En Lojban traducimos el significado, no sólo las palabras.

Comprender las peculiaridades de tu propio idioma también es importante cuando intentas expresar algo en lojban.

Las soluciones al ejemplo anterior podrían ser:

> **la .teris. poi tirxu cu klama le barda tcadu**
> _Terry, el tigre, llega a la gran ciudad._
tirxu
: $x_1$ es un tigre

> **la .teris. poi tirxu cu pa roi klama le barda tcadu**
> _Terry, el tigre, una vez llega a la gran ciudad._
<!-- -->

> **la .teris. poi tirxu cu pa re'u mo'u klama le barda tcadu**
> _Terry, el tigre, llega por primera vez a la gran ciudad._
<!-- -->

> **la .teris. poi tirxu cu co'a klama le barda tcadu**
> _Terry, el tigre, parte hacia la gran ciudad._

### Cuatro significados de ‘_you_’ en inglés

Ya hemos visto dos pronombres personales, **mi** (_yo_ o _me_) y **do** (_tú_). Sin embargo, _you_ en inglés puede tener múltiples significados, que se traducen al lojban de formas específicas:

- _you_ como _la persona a la que estoy hablando_:

 >**le pa do**<br/>
 >_tú uno_

 Sabemos que **le re prenu** significa _las dos personas_. También es posible poner números después de **le** y antes de los pronombres.

- _you_ como _todas las personas a las que estoy hablando_:

 >**ro do**<br/>
 >_cada uno de ustedes_, _todos ustedes_ (o en el sur de Estados Unidos, _y'all_)

 También se pueden usar números con **ko**:

 >**ro ko klama ti**<br/>
 >_Todos ustedes, vengan aquí._

- _you_ como _un número específico de personas a las que estoy hablando_:

 >**le re do**<br/>
 >_ustedes dos_

 Por ejemplo, uno puede comenzar correos electrónicos a sus padres con **coi le re do**.

 Observa que **re do** significa _dos de ustedes_ y **re le ci do** significa _dos de ustedes tres_.

- _you_ como _la persona o personas a las que estoy hablando más alguna otra persona o personas_:

 >**do'o**<br/>
 >_tú y alguien más_

- _you_ como _cualquier persona_ (por ejemplo, _El dinero no puede comprar el amor_):

 Normalmente se expresa como:

 >**ro da**<br/>
 >_todos **da**_

 o

 >**ro lo prenu**<br/>
 >_todas las personas_

 Sin embargo, a menudo puedes omitirlo por completo o colocar **zo'e** en esa posición.
<!-- El método recomendado es convertir los pronombres en verbos primero:

>**lo re me do ko klama ti**
>_Ustedes dos, vengan aquí._

Es posible omitir **me** en esta posición y decir **lo re do ko klama ti**, pero esto puede llevar a confusión en principiantes. -->

### Más sobre cláusulas relativas cortas

Las cláusulas relativas cortas con un pronombre que las sigue pueden colocarse inmediatamente después de **le**:

> **le gerku pe mi**
> _Mi perro_

En estos casos, incluso se puede omitir **pe**:

> **le gerku pe mi**
> **le mi gerku**
> _Mi perro_

**le mi gerku** significa exactamente lo mismo que **le gerku pe mi**.

Así, "**le** + argumento + construcción de relación" es equivalente a "**le** + construcción de relación + **pe** + argumento".

Algunas reglas:

- Si deseas usar un argumento convertido de una relación (por ejemplo, con **le**) o si es un nombre, es recomendable usar **pe** y colocarlo después del argumento: **le gerku pe la .alis.** (_El perro de Alicia_).
- Omitir **pe** solo es aceptable al usar pronombres sin números delante de ellos: **le do gerku** (_tu perro_) pero no **le pa do gerku** (= **le pa do cu gerku** = _uno de ustedes es un perro_).

Es mucho más seguro usar **pe** explícitamente y colocarlo después del argumento al que está adjunto: **le gerku pe la .alis.** y **le gerku pe mi** son las construcciones más intuitivas.

### Citar texto en diferentes idiomas

**zoi** es una marca de cita para citar texto no lojban. Su sintaxis es **zoi X. texto .X**, donde X es una palabra lojban (llamada palabra delimitadora) que se separa del texto citado por pausas, y que no se encuentra en el texto escrito o en la secuencia de fonemas hablados dentro de esa cita. Es común, pero no obligatorio, usar el nombre de alguna letra, que corresponde al nombre lojban del idioma que se está citando:

> **zoi gy. John is a man .gy. cu glico jufra**
> _"John is a man" es una frase en inglés._

glico
: $x_1$ es inglés

donde **gy.** representa **glico**. Otras opciones populares de palabras delimitadoras son la palabra _zoi_ en sí misma y una palabra lojban que sugiere el tema de la cita.

Lojban evita estrictamente cualquier confusión entre las cosas y los nombres de las cosas:

> **zo .bob. cmene la .bob.**
> `La palabra "Bob" es el nombre del llamado Bob.`

**zo .bob.** es la palabra, mientras que **la .bob.** es la cosa nombrada por la palabra. Las palabras cortas calificadoras **la'e** y **lu'e** colocadas antes de los términos convierten de ida y vuelta entre referencias y sus referentes:

> **zo .bob. cmene la'e zo .bob.**
> _La palabra "Bob" es el nombre del referente de la palabra "Bob"._

<!-- -->

> **lu'e la .bob. cmene la .bob.**
> _Un símbolo para Bob es el nombre de Bob._

Los dos últimos ejemplos significan lo mismo. Pero esto es diferente:

> **la .bob. cu cmene la .bob.**
> _Bob es el nombre de Bob._

y dice que Bob es tanto el nombre como la cosa nombrada, una situación poco probable. Las personas no son nombres.

**la'o** se utiliza para marcar nombres no lojban, por ejemplo, los nombres binomiales linneanos (como "Homo sapiens"), que son los nombres estandarizados internacionalmente para las especies de animales y plantas.

Nombres internacionalmente conocidos que se pueden reconocer más fácilmente por su escritura que por su pronunciación, como _Goethe_, también pueden aparecer en texto lojban con **la'o**:

> **la'o dy. Goethe .dy. cu me la'o ly. Homo sapiens .ly.**
> _Goethe es un Homo sapiens._

Sin embargo, utilizar **la'o** para todos los nombres en lugar de adaptarlos al lojban puede hacer que el texto sea engorroso.

Todo lo expresado en texto también debe ser expresado en habla y viceversa. Por lo tanto, no puede haber ninguna puntuación que no se pronuncie. Esto significa que el lojban tiene una amplia gama de palabras para citar otras palabras. Todos los lojban convierten un texto en un término de argumento.

**lu** … **li'u** citan solo texto que es gramaticalmente correcto. Para citar cualquier texto en lojban, utilizamos citas con **lo'u** … **le'u** en su lugar.

> **— xu lo'u je le'u lojbo sumsmi**
> **— na ku sumsmi**
> _— ¿"je" es un término?_
> _— No._

<!-- -->

> **ma xe fanva zoi gy.What's up?.gy. la .lojban.**
> _¿Cómo se traduce "What's up?" al lojban?_

### Términos internos

Utilizando **be**, puedes completar no solo espacios de relaciones sino también agregar términos modales:

> **le xatra be de'i li vo cu se mrilu de'i li ze**
> _Esta carta, fechada el 4, es enviada el 7_

xatra
: $x_1$ es una carta

Una fecha etiquetada con **de'i** se aplica solo al **xatra**. Compara:

> **le xatra de'i li vo cu se mrilu de'i li ze**
> _La carta del 4 se envía el 7_ (lo que eso signifique)

Sin **be**, el término **de'i li vo** se aplicaría a toda la relación, no al **xatra**. Lo que queremos decir es que la fecha anterior se aplica solo a la carta, y la fecha posterior se aplica al envío de la carta. Esto significa que en **le xatra be de'i li vo**, la parte **de'i li vo** (_el 4, como fecha_) se aplica solo al argumento **le xatra**, y no a toda la oración.

### Relaciones compuestas en detalle

La agrupación de términos en la gramática lojban es particularmente importante cuando se trata de tanru (relaciones compuestas). La forma en que las relaciones se agrupan en un tanru determina su significado. Por ejemplo,

> _la revista de música mala_

tiene dos interpretaciones en inglés: una revista mala sobre música o una revista sobre música mala. En lojban, su equivalente

> **le xlali zgike karni**

solo tiene la interpretación _la revista de música mala_, porque las dos primeras relaciones (_xlali zgike_ — _música mala_) se agrupan primero. Es importante modificar la agrupación de las relaciones para asegurar que el tanru transmita el significado deseado. Por esa razón, el lojban tiene un par de mecanismos para que los tanru se agrupen correctamente.

En español, usamos corchetes para estructurar el texto. De manera similar, para los tanru, usamos **ke** como corchete izquierdo y **ke'e** como corchete derecho.

**le xlali ke zgike karni** significa _la mala revista de musica_.

Como puedes ver, separamos **xlali** del resto del tanru y lo hicimos aplicar a todo el tanru. No es necesario usar **ke'e** al final del tanru, ya que sabemos que termina aquí.

> **.i mi pu zi te vecnu le xlali ke zgike karni .i to'e zanru la'o gy.Eurythmics.gy.**
> _Acabo de comprar una mala revista de música. Criticó a los Eurythmics._

Esa es una forma de agrupar componentes en un tanru. La otra forma es usar **bo** en un nuevo papel. Cuando **bo** aparece entre dos componentes, significa que esos componentes se agrupan más estrechamente que cualquier otra cosa. Entonces, una forma alternativa de decir _mala (revista de música)_ es...

le xlali zgike bo karni
: la revista de música-mala

**bo** aquí es similar al guion en la traducción al español. Esto significa que **zgike bo karni** debe contar como una unidad, a la cual se aplica **xlali** (_mala_).

Entonces **bo** hace que las conexiones sean más estrechas:

> **la .doris. e la .alis. o nai bo la .bob.**
> _Doris y (ya sea Alice o Bob)_

**ke** también se puede usar con conectores (aunque no con oraciones; tienen su propio tipo de corchete, **tu'e ... tu'u**). Así que también podríamos decir

> **la .doris. e ke la .alis. o nai la .bob.**

Recuerda que el corchete derecho **ke'e** a menudo se puede omitir sin cambiar el significado (como en este caso).

Las conjunciones de previsión también se usan con frecuencia porque pueden eliminar la necesidad de corchetes derechos:

> **ge la .doris. gi go nai la .alis. gi la .bob.**
> _Doris y ya sea Alice o Bob_

y

> **go nai ge la .doris. gi la .alis. gi la .bob.**
> _Ya sea Doris y Alice, o Bob_

No es necesario usar **bo** o **ke** con las conjunciones de previsión.

### «**co**» para cambiar el orden en relaciones compuestas

Hay otra forma de reestructurar relaciones compuestas.

> **mi fanva se jibri**
> _Soy un traductor profesional_

jibri
: $x_1$ es un trabajo de $x_2$

Si quisiera decir que soy un traductor profesional de inglés a alemán, podría usar **be** y **bei**:

> **mi fanva be le dotco bei le glico be'o se jibri**
> _Soy un traductor profesional de alemán a inglés._

dotco
: $x_1$ es alemán


El hecho de que fuera una relación compuesta podría perderse rápidamente en el habla debido a la estructura complicada de la oración. Aquí, podemos usar la palabra **co**:

**co** — invierte la relación compuesta, haciendo que el componente más a la derecha modifique al más a la izquierda en lugar de al revés. Cualquier término de argumento anterior llena el modificado, cualquier término de argumento siguiente llena el modificador.

> **mi se jibri co fanva le dotco le glico**

Es la misma relación que la anterior en Lojban, pero mucho más fácil de entender. Observa que cualquier argumento antes de la relación compuesta llena **se jibri**, mientras que cualquier argumento que le siga solo llena el componente modificador: **fanva**.

La fuerza con la que dos componentes están unidos con **co** es muy débil, incluso más débil que la agrupación normal de relaciones compuestas sin palabras de agrupación. Esto asegura que, en un co-constructo, el componente más a la izquierda siempre es el componente que está siendo modificado, y el componente más a la derecha siempre modifica, incluso si alguna de esas partes son relaciones compuestas. Esto hace que un **co**-constructo sea fácil de entender:

> **ti pelxu plise co kukte**

se lee como **ti (pelxu plise) co kukte**, que es lo mismo que **ti kukte pelxu bo plise**. Esto también significa que un **ke … ke'e** no puede abarcar un **co**.

Otro ejemplo:

> **mi merko limna co mutce certu**
> _Soy un nadador americano muy experimentado._

merko
: $x_1$ es americano (en el sentido de Estados Unidos)

Aquí está la lista de diferentes tipos de agrupadores en relaciones compuestas, clasificados desde el más ajustado hasta el más suelto:

1. **bo** y **ke … ke'e**
2. conectores lógicos dentro de relaciones compuestas como **je**
3. no usar palabras de agrupación
4. **co**

### Terminación explícita de argumentos

La pequeña palabra **ku** se puede usar al final de un argumento para mostrar explícitamente su límite derecho. **ku** es análogo al corchete derecho en matemáticas.

> **tu du le badna ku ui**
> **tu du le ui badna**
> _Esa es la banana (¡yay!)_

A diferencia de:

> **tu du le badna ui**
> _Esa es la banana (¡yay, que sea una banana y no algo más en la naturaleza!)_

### Evitar la terminación explícita
Otro estilo de hablar implica evitar la terminación. Aquí hay algunos casos comunes:

Eliminación de **li'u**, la comilla derecha:

> **lu mi prami do li'u cu se cusku la .alis.**
> **lu mi prami do li'u se cusku la .alis.**
> **lu mi prami do cu se cusku la .alis.**
> _"Te amo", dijo Alicia._

**li'u** se puede omitir aquí porque no puede haber dos construcciones de relación principal en una oración. Por lo tanto, primero leemos la parte **lu mi prami do**, y luego cuando vemos el **cu**, nos damos cuenta de que no podemos continuar esta oración citada más adelante. Suponemos que la cita ha terminado y la oración exterior continúa. Por lo tanto, no surge ninguna ambigüedad.

Eliminación de **ku'o**, el límite derecho de las cláusulas relativas:

> **le prenu noi mi zgana ke'a ku'o ca tavla le pendo be mi**
> **le prenu noi mi zgana ke'a ca tavla le pendo be mi**
> _La persona a quien estoy observando está hablando con mi amigo._

Aquí se puede omitir **ku'o** cuando la cláusula relativa que necesitamos (**mi zgana ke'a**) termina en un término, en este caso, **ke'a**. Después de la cláusula relativa, comienza algo que no es un término, por lo que la cláusula relativa no puede continuar, y así sabemos que termina exitosamente sin ninguna palabra explícita de corchete derecho.

Un truco similar sería siempre colocar **ke'a** al final de la cláusula relativa:

> **le prenu noi ke'a melbi ku'o ca tavla le pendo be mi**
> **le prenu noi melbi fa ke'a ca tavla le pendo be mi**
> _La persona que es bonita está hablando con mi amigo._

Sin embargo, en el siguiente caso, es necesario el término de la cláusula:

> **le prenu noi mi zgana ke'a ku'o le pendo be mi ca tavla**
> _La persona a quien estoy observando está hablando con mi amigo._

porque después de la cláusula relativa **mi zgana ke'a**, elegimos colocar otro término (**le pendo be mi**) que no pertenece a la cláusula relativa actual.

Un semi-truco aquí sería usar **ce'e**:

> **le prenu noi mi ke'a zgana ce'e le pendo be mi ca tavla**
> _La persona a quien estoy observando está hablando con mi amigo._

Aquí, terminamos la cláusula relativa con el constructo principal de relación **zgana**. Luego tenemos la conjunción **ce'e** y un término después (**le pendo be mi**). Dado que **ce'e** solo puede unir términos, sabemos que a la izquierda de **ce'e** tenemos un término, que solo puede ser **le prenu noi mi ke'a**. Por lo tanto, se mantiene el significado y no surge ninguna ambigüedad. Tenga en cuenta que todavía necesitamos una palabra separada, **ce'e**, en estos casos, por lo que aunque eliminamos la palabra de corchete brillante, todavía tuvimos que introducir algo más.

Eliminación de **kei**, el límite derecho de las oraciones internas:

> **mi cinmo le ka badri kei le tcini**
> **le ka badri cu se cinmo mi le tcini**
> **mi cinmo fi le tcini fe le ka badri**
> **mi cinmo le ka badri ce'e le tcini**
> _Me siento triste con respecto a la situación._

> **mi stidi lo ka citka su'o da kei do**
> **mi stidi lo ka ce'u su'o da citka ce'e do**
> _Sugiero que comas algo._

Como puedes ver, ningún truco hace que el resultado sea más corto que el original con **kei**, así que por concisión, puedes optar por usar **kei**.

### Conversión de conjuntos a masas

> **le prenu cu pa moi le'i pendo be mi ku noi lu'o ke'a ca smaji**
> _Él es el primero entre mis amigos que guardan silencio juntos._
> _La persona es la primera entre el conjunto de mis amigos que ahora, como multitud, están en silencio._

La palabra calificadora **lu'o** colocada antes de un argumento lo convierte en una masa compuesta por los miembros de ese argumento. En este caso, **ke'a** se refiere al conjunto de mis amigos **le'i pendo be mi** y luego **lu'o** convierte a los miembros del conjunto en una masa, la multitud de mis amigos.

### Conjuntos y subconjuntos

Algunos infinitivos pueden implicar más de un **ce'u**:

> **le'i prenu cu simxu le ka prami**
> **le'i prenu cu simxu le ka ce'u prami ce'u**
> _Las personas se aman mutuamente._

simxu
: los miembros del conjunto $x_1$ se hacen $x_2$ el uno al otro

La relación **simxu** toma todas las posibles parejas del conjunto especificado en el lugar $x_1$ y afirma la relación especificada en $x_2$.

Si tenemos tres personas, entonces significaría que todas se aman mutuamente.

> **do ce la .alis. ce mi simxu le ka prami**
> **do ce la .alis. ce mi simxu le ka ce'u prami ce'u**
> _Tú, Alice, y yo nos amamos mutuamente._

ce
: conjunción: une varios argumentos en un conjunto

La conjunción **ce** fusiona los argumentos en un conjunto. Así, **do ce la .alis. ce mi** podría ser una forma más detallada de **le'i prenu** del ejemplo anterior cuando queremos nombrar a los miembros del conjunto.

En total, afirmamos 6 relaciones:

1. Tú amas a Alice.
2. Tú me amas.
3. Alice me ama.
4. Alice te ama.
5. Yo amo a Alice.
6. Yo te amo.

Por lo tanto, **simxu** es una forma práctica de expresar relaciones mutuas.

Ahora considera el ejemplo:

> **le'i su'o cmima be le'i prenu cu simxu le ka prami**
> _Algunas de las personas se aman mutuamente._

cmima
: $x_1$ es un miembro del conjunto $x_2$

En este ejemplo, mostramos que un subconjunto de las personas en cuestión (un subconjunto de **le'i prenu**) tiene amor mutuo.

Esto nos permite transmitir ideas aún más complicadas:

> **le'i su'o citno cmima be le'i stati prenu cu simxu le ka prami**
> _Algunos jóvenes de esas personas inteligentes se aman entre sí._
> `Algunos miembros jóvenes del conjunto de personas inteligentes se aman entre sí.`

<!-- ## Lógica de segundo orden

Hemos visto que **da** (y **de**, **di**) es una "variable" en forma de sustantivo con significados declarados dependiendo de las proposiciones dadas.
Normalmente se traduce como _hay X, hay X tal que..._

Sin embargo, por curiosidad debo mencionar la serie de verbos que también sirven como "variables" pero en forma de verbo, es decir, en forma de relación:

>**su'o bu'a zo'u mi bu'a do**
>_Hay alguna relación o propiedad: Tengo esta relación contigo._
> _Tú y yo estamos relacionados de al menos una manera._

>**ro bu'a zo'u ga nai le'e mlatu cu bu'a gi la .dinas. bu'a**
>>_Para cada relación o propiedad posible: si los gatos la tienen, entonces Dinah también la tiene._ (Por lo tanto, asumimos que Dinah es un gato.)

El razonamiento detrás de estos verbos variables está oculto en la lógica formal. No hace falta decir que rara vez se usan en el habla, pero aquí hay un posible ejemplo:

su'o bu'a zo'u ge ge da na bu'a gi su'o da su'o de zo'u ge da .e de bu'a gi da manci de gi ro da ro de zo'u da bu'a .ije da manci de .inaja de bu'a
- corregir la oración -->

<!-- ## Cosas aún no formalizadas en Lojban

Aunque Lojban podría ser el idioma hablado número 1 en el mundo debido a lo detallada que es su gramática, aún hay algunas cosas que no se han formalizado.
No se sabe qué significa **ta'e na** en contraposición a **na ta'e**.

No se sabe cómo manejar **na go'i**.

No se sabe cómo funciona xorlo cuando necesitamos una conversión explícita entre conjuntos y masas, cómo operar con conjuntos en general, cómo usar xorlo junto con la lógica de segundo orden como bu'a.

postoxorlo funciona con anáforas y cuantificadores externos. -->

<!-- ## Sistema de conectores no estándar

Algunas personas, en lugar de usar

- **a**, **e**, **o**, **u**

para conectar sustantivos, usan

- **ja**, **je**, **jo**, **ju**

Es decir, en lugar de decir

>**mi e do nelci le plise**
>_Me gustan las manzanas, y a ti te gustan las manzanas._

dicen

>**mi je do nelci le plise**
>_Me gustan las manzanas, y a ti te gustan las manzanas._

Este es un enfoque no estándar. Las personas usan este estilo porque en él hay menos conjunciones que recordar.

Pero debes tener cuidado de no olvidar **le** o los números para formar sustantivos: **mi nelci le plise je jisra** significaría _Me gusta algo que es una manzana (o manzanas) y es jugo_ (?!)

La oración correcta usa **le** para formar cada sustantivo:

>**mi nelci le plise je le jisra**
>_Me gustan las manzanas y el jugo._

En el enfoque estándar, el hablante usa la conjunción separada **e** al conectar sustantivos, y es más fácil ver la diferencia y el significado correcto:

>**mi nelci le plise .e le jisra**
>_Me gustan las manzanas y el jugo._ -->