<div class="print:hidden">

Cómo usar este curso:

1. léelo
2. recopila tus comentarios y sugerencias
3. envíalos a [💬 el chat en vivo](https://lojban.pw/es/articles/live_chat/)
</div>

## Lección 1. El idioma de un vistazo

### Alfabeto

Lo primero que necesitas saber sobre Lojban es el alfabeto.

Lojban utiliza el alfabeto latino (las vocales están coloreadas):

<dl><dd><b><font color="#FF1493">a</font> b c d <font color="#FF1493">e</font> f g <font color="#FF1493">i</font> j k l m n <font color="#FF1493">o</font> p r s t <font color="#FF1493">u</font> v x <font color="#FF1493">y</font> z ' .</b></dd></dl>

Las palabras se pronuncian tal como se escriben.

Hay 10 vocales en Lojban:

<table>
<tbody><tr>
<td><b class="audio-inline"><font color="#FF1493" class="guibutton">a</font></b></td>
<td> como en <i>p<u>a</u>dre</i> (no como en <i>cara</i>)</td>
</tr>
<tr>
<td><b class="audio-inline"><font class="guibutton"color="#FF1493">e</font></b></td>
<td> como en <i>g<u>e</u>to</i></td>
</tr>
<tr>
<td><b class="audio-inline"><font class="guibutton" color="#FF1493">i</font></b></td>
<td> como en <i>máqu<u>i</u>na</i> (no como en <i>golpear</i>)</td>
</tr>
<tr>
<td><b class="audio-inline"><font class="guibutton" color="#FF1493">o</font></b></td>
<td> como en <i>elecc<u>ió</u>n</i>, <i>n<u>o</u></i> o <i>ough</i> en <i>th<u>ough</u>t</i> (no como en <i>tan</i>, la <b>o</b> debe ser un sonido "puro").</td>
</tr>
<tr>
<td><b class="audio-inline"><font class="guibutton" color="#FF1493">u</font></b></td>
<td> como en <i>gen<i>ial</i></i> (no como en <i>pero</i>)</td>
</tr>
<tr>
<td><b class="audio-inline"><font class="guibutton" color="#FF1493">y</font></b></td>
<td> como en <i>comm<u>a</u></i> (no como en <i>brumoso</i> o <i>ciclo</i>)</td>
</tr>
<tr>
</tbody></table>

4 vocales se escriben usando combinaciones de letras:

<table>
<tbody><tr>
<td><b class="audio-inline"><font color="#FF1493" class="guibutton">au</font></b></td>
<td> como en <i>v<u>aca</u></i></td></tr>
<tr>
<td><b class="audio-inline"><font color="#FF1493" class="guibutton">ai</font></b></td>
<td> como en <i>alt<u>o</u></i></td></tr>
<tr>
<td><b class="audio-inline"><font class="guibutton"color="#FF1493">ei</font></b></td>
<td> como en <i>l<u>ei</u>che</i></td></tr>
<tr>
<td><b class="audio-inline"><font class="guibutton" color="#FF1493">oi</font></b></td>
<td> como en <i>h<u>oy</u></i></td></tr>
</tbody></table>

En cuanto a las consonantes, se pronuncian como en inglés o latín, pero hay varias diferencias:

<table>
<tbody><tr>
<td><span class="audio-inline"><b class="guibutton">c</b></span>
</td>
<td>se pronuncia como <i>c</i> en <i>oceano</i>, como <i>ch</i> en <i>chico</i>.
</td></tr>
<tr>
<td><span class="audio-inline"><b class="guibutton">g</b></span>
</td>
<td>siempre <i>g</i> como en <i>goma</i> (nunca <i>g</i> como en <i>gema</i>).
</td></tr>
<tr>
<td><span class="audio-inline"><b class="guibutton">j</b></span>
</td>
<td>como <i>s</i> en <i>placer</i> o <i>j</i> en francés <i>bonjour</i>.
</td></tr>
<tr>
<td><span class="audio-inline"><b class="guibutton">x</b></span>
</td>
<td>como <i>ch</i> en escocés <i>loch</i> o como en alemán <i>Bach</i>, como <i>J</i> en español <i>Jose</i> o <i>Kh</i> en árabe moderno <i>Khaled</i>. Intenta pronunciar <i>ksss</i> manteniendo tu lengua abajo y obtendrás este sonido.
</td></tr>
<tr>
<td><span class="audio-inline"><b class="guibutton"> ' </b></span>
</td>
<td>como la <i>h</i> en inglés. Por lo tanto, el apóstrofo se considera una letra propia del Lojban y se pronuncia como una <i>h</i>. Solo se encuentra entre vocales. Por ejemplo, <b>u'i</b> se pronuncia como <i>oo-hee</i> (mientras que <b>ui</b> se pronuncia como <i>wee</i>).
</td></tr>
<tr>
<td><span class="audio-inline"><b>.</b></span>
</td>
<td>un punto (punto final, separación de palabras) también se considera una letra en Lojban. Es una breve pausa en el habla para evitar que las palabras se fusionen entre sí. En realidad, cualquier palabra que comience con una vocal tiene un punto colocado delante de ella. Esto ayuda a evitar la fusión indeseable de dos palabras consecutivas en una sola.
</td></tr>
<tr>
<td><span class="audio-inline"><b>i</b></span>
</td>
<td><span class="audio-inline"><b>i</b></span> antes de vocales se considera una consonante y se pronuncia más corta, por ejemplo:
<ul><li><b>ia</b> se pronuncia como <i>ya</i> en <i>yarda</i></li>
<li><b>ie</b> se pronuncia como <i>ye</i> en <i>yeso</i></li></ul>
</td></tr>
<tr>
<td><span class="audio-inline"><b>u</b></span>
</td>
<td><span class="audio-inline"><b>u</b></span> antes de vocales se considera una consonante y se pronuncia más corta, por ejemplo:
<ul><li><b>ua</b> se pronuncia como <i>wo</i> en <i>wow</i></li>
<li><b>ue</b> se pronuncia como <i>whe</i> en <i>when</i></li></ul>
</td></tr></tbody></table>

El énfasis se coloca en la segunda vocal desde el final. Si una palabra tiene solo una vocal, simplemente no se le da énfasis.

La letra **r** puede pronunciarse como la _r_ en inglés, escocés o ruso, por lo que hay un rango de pronunciación aceptable para ella.

Algunas personas utilizan vocales no-lojban como la _i_ y la _u_ cortas en el inglés británico estándar en palabras como _hit_ y _but_ para separar consonantes. Entonces, si tienes dificultades para pronunciar dos consonantes seguidas (por ejemplo, el **vl** en **tavla**, que significa _hablar con_), puedes decir _tavɪla_ —donde la _ɪ_ es muy corta. Sin embargo, otras vocales como **a** y **u** deben ser largas.

### La oración más simple

La unidad básica en Lojban es la "oración". Aquí tienes tres ejemplos simples:

> **le prenu cu tavla mi**
> _La persona me habla._

le prenu
: la persona

tavla
: ... habla con ..., ... se comunica con ...

mi
: yo, me

> **mi prami do**
> _Te amo._

prami
: ... ama a ... (alguien)

do
: tú

> **mi ca cu tavla do**
> _Ahora te hablo._

ca
: ahora

<pixra url="/assets/pixra/cilre/tavla.webp" caption="le prenu cu tavla mi" definition="La persona me habla."></pixra>

<pixra url="/assets/pixra/cilre/mi.webp" caption="mi" definition="Yo / me"></pixra>

<pixra url="/assets/pixra/cilre/mi_prami_do2.webp" caption="mi prami do" definition="Te amo."></pixra>

<pixra url="/assets/pixra/cilre/do.webp" caption="do" definition="tú"></pixra>

Cada oración en Lojban consta de las siguientes partes de izquierda a derecha:

- la cabeza:
  - compuesta por los llamados "términos",
    - **le prenu** es el único término de cabeza en el ejemplo **le prenu cu tavla mi** anterior,
    - **mi**, **ca** son términos de cabeza en el ejemplo **mi ca cu tavla do** anterior.
- el separador de cabeza **cu**:
  - pronunciado como _shoe_ ya que **c** es para _sh_,
  - indica que la cabeza ha terminado,
  - se puede omitir cuando está claro que la cabeza está completa.
- la cola:
  - la construcción principal de relación (llamada "**selbrisni**" en Lojban)
  - \+ posiblemente uno o más términos después de ella,
    - **tavla**, **prami** son selbrisni, construcciones principales de relación en los ejemplos anteriores.
    - **mi** es el único término de cola en el ejemplo **le prenu cu tavla mi** anterior.
    - **do** es el único término de cola en el ejemplo **mi prami do** anterior.

En Lojban, principalmente hablamos de relaciones en lugar de sustantivos o verbos.

Aquí están las dos palabras de relación, que se corresponden aproximadamente con verbos:

prenu
: ... es una persona / son personas

tavla
: ... habla con ...

Cada relación tiene uno o más roles que también se pueden llamar "espacios" o "lugares". Arriba, están etiquetados con "..." Esos espacios deben llenarse con argumentos (llamados "**sumti**" en Lojban). Los términos de los argumentos son construcciones como **le prenu**, **mi**, **do**, sin importar si esos términos terminan siendo en la cabeza o en la cola de una oración. Colocamos los términos de los argumentos en orden, llenando así estos espacios y dando un significado concreto a la relación.

Podemos convertir esa relación en un término de argumento.

Para eso, colocamos una palabra corta **le** delante de ella:

prenu
: ... es una persona

le prenu
: la persona, las personas

De manera similar,

tavla
: ... habla con ...

y así

le tavla
: el hablante, los hablantes

Puede sonar extraño cómo _persona_ puede ser un "verbo", pero de hecho, esto hace que el Lojban sea muy simple:

<table>
<thead>
<tr>
<th>palabra de relación con espacios sin llenar</th>
<th>forma de argumento (<b>sumti</b>)</th></tr>
</thead>
<tbody>
<tr>
<td><b>prenu</b> — <i>... (alguien) es una persona</i> </td>
<td><b>le prenu</b> — <i>la persona / las personas</i>
    <br/><b>le prenu</b> — <i>la persona que es una persona / aquellos que son personas</i>
</td></tr>
<tr>
<td><b>tavla</b> — <i>... (alguien) habla con ... (alguien)</i> </td>
<td><b>le tavla</b> — <i>el hablante / los hablantes</i>
    <br/><b>le tavla</b> — <i>la persona que es un hablante / aquellos que son hablantes</i>
</td></tr>
</tbody></table>

El primer espacio de las relaciones desaparece al usar **le**, por lo tanto, es posible tener traducciones alternativas como _la persona que ..._.

<!-- También podemos decir que **le** crea un sustantivo a partir de una construcción de relación con el significado aproximado de _la persona que es ..._ (_es una persona_ — _la persona_), o incluso _aquellos que hacen ..._ (_hablar con_ — _los hablantes_), _aquellos que son ..._ (_son personas_ — _las personas_). -->

Observa que, por defecto, el Lojban no especifica el número entre _el hablante_ o _los hablantes_. Es decir, **le tavla** es vago en ese sentido, y pronto descubriremos formas de definir el número.

Aparte de los términos de argumento, hay términos modales como **ca**:

> **mi ca cu tavla do**
> _Ahora te hablo._

ca
: ahora

Los términos modales no llenan espacios en la estructura principal de relaciones ("**selbrisni**"). En cambio, se aplican a toda la oración enriqueciendo o limitando su significado.

Por lo tanto, los términos en Lojban se representan con:

- términos de argumento que llenan espacios de relaciones. Ejemplos son:
  - sustantivos como **le prenu** (_la persona_)
  - pronombres como **mi** (_yo_, _me_), **do** (_tú_). Los pronombres funcionan exactamente como los sustantivos, pero no se usa **le** para ellos. Funcionan como argumentos por sí mismos.
- términos modales que no llenan espacios de relaciones, sino que especifican información adicional y aclaratoria.
  - por ejemplo, **ca** (_ahora, en el presente_).

Algunos ejemplos más:

<pixra url="/assets/pixra/cilre/nintadni.webp" caption="mi nintadni" definition="Soy un estudiante nuevo, un novato."></pixra>

> **mi nintadni**
> _Soy un estudiante nuevo._

nintadni
: … (alguien) es un estudiante nuevo, un novato

A diferencia del inglés, no tenemos que agregar el verbo "ser/estar" a la oración. Ya está implícito. La palabra de relación **nintadni** (_… es un estudiante nuevo_) ya tiene este "ser/estar" en su traducción al inglés.

> **do jimpe**
> _Tú entiendes._

jimpe
: … (alguien) entiende … (algo)

<pixra url="/assets/pixra/cilre/pilno_le_fonxa.webp" caption="le prenu cu pilno le fonxa" definition="La persona usa el teléfono."></pixra>

> **mi pilno le fonxa**
> _Yo uso el teléfono._

pilno
: … (alguien) usa … (algo)

fonxa
: … es un teléfono, … son teléfonos

le fonxa
: el teléfono, los teléfonos

<pixra url="/assets/pixra/cilre/citka.webp" caption="mi citka" definition="Yo como."></pixra>

> **mi citka**
> _Yo como._

citka
: … (alguien) come … (algo)

> **do citka**
> _Tú comes._

<!-- -->

> **mi citka le plise**
> _Yo como las manzanas._

<pixra url="/assets/pixra/cilre/le_plise_cu_kukte.webp" caption="le plise cu kukte" definition="Las manzanas son sabrosas."></pixra>

> **le plise cu kukte**
> _Las manzanas son sabrosas._

le plise
: las manzanas

kukte
: … (algo) es sabroso

Una frase más simple en Lojban contendría solo una palabra de relación principal:

<pixra url="/assets/pixra/cilre/karce.webp" caption="karce" definition="Es un coche."></pixra>

> **karce**
> _¡Coche!_
> _Es un coche._

Podrías decir esto cuando veas un coche acercándose. Aquí el contexto sería lo suficientemente claro de que hay un coche en algún lugar y probablemente sea peligroso.

**karce** en sí es una palabra de relación que significa _es un coche_.

Por supuesto, podemos ser más precisos y decir, por ejemplo:

> **bolci**
> _Ball!_
> _It is a ball._

where **bolci** is a relation word meaning _is a ball_.

> **ti bolci**
> _This is a ball near me._
<!-- -->
> **ta bolci**
> _This is a ball near you._

ti
: pronoun: this thing near me

ta
: pronoun: this/that thing near you

tu
: pronoun: that one away from you and me

<pixra url="/assets/pixra/cilre/ti.webp" caption="ti" definition="esto (cerca de mí, el hablante)"></pixra>
<pixra url="/assets/pixra/cilre/ta.webp" caption="ta" definition="this one (near you, the listener)"></pixra>

<pixra url="/assets/pixra/cilre/tu.webp" caption="tu" definition="that one over there (away from you and me)"></pixra>

De manera similar, puedes decir

<pixra url="/assets/pixra/cilre/carvi.webp" caption="carvi" definition="… está lloviendo"></pixra>

> **carvi**
> _Está lloviendo._

donde

carvi
: … está lloviendo

o

> **pluka**
> _Es agradable._

donde

pluka
: … es agradable

Observa que en Lojban no es necesario el uso de la palabra _it_ en ese sentido. Simplemente usas la palabra de relación que necesitas.

> **prami**
> _Alguien ama._

<pixra url="/assets/pixra/cilre/bajra.webp" caption="le prenu cu bajra" definition="La persona corre."></pixra>

> **bajra**
> _Alguien corre._

bajra
: … corre usando extremidades

Nuevamente, el contexto probablemente indicaría quién ama a quién y quién corre.

### Tarea

<pixra url="/assets/pixra/cilre/pinxe_le_djacu.webp" caption="le prenu cu pinxe le djacu" definition="La persona bebe el agua."></pixra>

pinxe
: … bebe … (algo)

le djacu
: el agua

Cierra la parte derecha de la tabla. Traduce las frases de la izquierda del Lojban.

<table style="table-layout: fixed;">
<tbody><tr>
<td><b>do citka</b>
</td>
<td><i>Tú comes.</i>
</td></tr>
<tr>
<td><b>mi pinxe le djacu</b>
</td>
<td><i>Yo bebo agua.</i>
</td></tr>
<tr>
<td><b>mi citka le plise</b>
</td>
<td><i>Yo como manzanas.</i>
</td></tr></tbody></table>

### «**.i**» separa las oraciones

Colocamos la palabra corta **.i** para separar cualquier par de oraciones consecutivas:

> **mi tavla le prenu .i le prenu cu tavla mi**
> _Estoy hablando con la gente. La gente está hablando conmigo._

**.i** separa las oraciones, al igual que el punto al final de las oraciones en textos en inglés.

Cuando decimos una oración después de otra en inglés, hacemos una pausa (puede ser corta) entre ellas. Pero la pausa tiene muchos significados diferentes en inglés. En Lojban tenemos una mejor manera de entender dónde termina una oración y comienza otra.

También debes tener en cuenta que a veces, al pronunciar palabras rápidamente, no puedes distinguir dónde termina una oración y comienza la siguiente. Por lo tanto, se recomienda usar la palabra **.i** antes de comenzar una nueva oración.

### Números: ‘_1 2 3 4 5 6 7 8 9 0_’ = «**pa re ci vo mu xa ze bi so no**»

**le** simplemente convierte una construcción de relación en un argumento, pero dicho argumento no tiene un número asociado. La oración

> **le prenu cu tavla mi**
> _Las personas me hablan._
> _La persona me habla._

no especifica la cantidad de personas que me hablan. En inglés, es imposible omitir el número porque _people_ en inglés implica _más de una persona_. Sin embargo, en Lojban, puedes omitir el número.

Ahora vamos a especificar cuántas de las personas son relevantes para nuestra discusión.

Agreguemos un número después de **le**.

<table>
<tbody><tr>
<td><b>pa</b>
</td>
<td><b>re</b>
</td>
<td><b>ci</b>
</td>
<td><b>vo</b>
</td>
<td><b>mu</b>
</td>
<td><b>xa</b>
</td>
<td><b>ze</b>
</td>
<td><b>bi</b>
</td>
<td><b>so</b>
</td>
<td><b>no</b>
</td></tr>
<tr>
<td> 1
</td>
<td> 2
</td>
<td> 3
</td>
<td> 4
</td>
<td> 5
</td>
<td> 6
</td>
<td> 7
</td>
<td> 8
</td>
<td> 9
</td>
<td> 0
</td>
</tr></tbody></table>

<pixra url="/assets/pixra/cilre/ci_prenu.webp" caption="le ci prenu" definition="Las tres personas"></pixra>

> **le pa prenu cu tavla mi**
> _La persona me habla._
> _La única persona me habla._

Agregamos un número después de **le** y así especificamos personas individuales.

Para números que consisten en varios dígitos, simplemente unimos esos dígitos:

> **le re mu prenu cu tavla mi**
> _Las 25 personas me hablan._

Sí, es así de simple.

Si queremos contar, podemos separar los números con **.i**:

> **mu .i vo .i ci .i re .i pa .i no**
> _5 … 4 … 3 … 2 … 1 … 0_

El número **za'u** significa _más que ..._ (_\>_ en matemáticas), el número **me'i** significa _menos que_ (_<_ en matemáticas):

> **le za'u re prenu cu tavla mi**
> _Más de dos personas me hablan._

<!-- -->

> **le me'i pa no prenu cu tavla mi**
> _Menos de 10 personas me hablan._

<!-- -->

> **le za'u ci prenu cu tavla mi**
> _Más de tres personas me hablan._

Para decir simplemente _personas_ (número plural) en contraposición a _una persona_, usamos **za'u pa**, _más de una_ o simplemente **za'u**.

> **le za'u pa prenu cu tavla mi**
> **le za'u prenu cu tavla mi**
> _Las personas me hablan._

**za'u** por defecto significa **za'u pa**, por lo tanto, es posible esta contracción.

le prenu
: la persona / las personas

le pa prenu
: la persona (uno en número)

le za'u prenu
: las personas (dos o más en número)

### Tarea

stati
: ... (alguien) es inteligente, ... tiene talento

<pixra url="/assets/pixra/cilre/stati.webp" caption="stati" definition="... tiene talento"></pixra>

klama
: ... viene a ... (un lugar u objeto)

<pixra url="/assets/pixra/cilre/klama_ti.webp" caption="le prenu cu klama ti" definition="La persona vino aquí."></pixra>

nelci
: ... le gusta (algo)

le zarci
: el mercado

<pixra url="/assets/pixra/cilre/zarci.webp" caption="le prenu cu zvati le zarci" definition="La persona está en la tienda."></pixra>

le najnimre
: la naranja (fruta), las naranjas

<pixra url="/assets/pixra/cilre/najnimre.webp" caption="najnimre" definition="... es una naranja"></pixra>

le badna
: el plátano, los plátanos

<pixra url="/assets/pixra/cilre/badna.webp" caption="badna" definition="... es un plátano"></pixra>

Cierra la parte derecha de la tabla. Traduce las oraciones de la izquierda del Lojban.

<table style="table-layout: fixed;">
 <tbody>
  <tr>
   <td>le mu prenu cu klama le zarci</td>
   <td>Las cinco personas van al mercado.</td>
  </tr>
  <tr>
   <td>le pa re prenu cu stati .i do stati</td>
   <td>Las 12 personas son inteligentes. Tú eres inteligente.</td>
  </tr>
  <tr>
   <td>le prenu cu nelci le plise</td>
   <td>A las personas les gustan las manzanas.</td>
  </tr>
  <tr>
   <td>le za'u re prenu cu citka .i le me'i mu prenu cu pinxe le djacu</td>
   <td>Más de dos personas comen. Menos de 5 personas beben el agua.</td>
  </tr>
  <tr>
   <td>le za'u re prenu cu stati</td>
   <td>Más de dos personas son inteligentes.</td>
  </tr>
 </tbody>
</table>

<table style="table-layout: fixed;">
 <tbody>
  <tr>
   <td>Las 256 personas son inteligentes.</td>
   <td>le re mu xa prenu cu stati</td>
  </tr>
  <tr>
   <td>Menos de 12 manzanas son sabrosas.</td>
   <td>le me'i pa re plise cu kukte</td>
  </tr>
 </tbody>
</table>

### Relación compuesta

La construcción de una relación compuesta (**tanru** en Lojban) consiste en varias palabras de relación colocadas una después de otra.

> **tu melbi zdani**
> _Ese es un hogar bonito._

<pixra url="/assets/pixra/cilre/melbi_zdani.webp" caption="melbi zdani" definition="... es un hogar bonito"></pixra>

tu
: ese (lejos de ti y de mí)

melbi
: ... es hermoso, bonito

zdani
: ... es un hogar o nido para ... (alguien)

melbi zdani
: construcción de relación compuesta: ... es un hogar bonito para ... (alguien)

<pixra url="/assets/pixra/cilre/dansu.webp" caption="le prenu cu melbi dansu" definition="La persona baila bonito."></pixra>

> **do melbi dansu**
> _Tú bailas bonito._

dansu
: ... baila

Aquí, la relación **melbi** agrega un significado adicional al colocarse a la izquierda de otra relación: **zdani**. El componente izquierdo generalmente se traduce usando adjetivos y adverbios.

Las relaciones compuestas son una característica poderosa que produce significados más ricos. Solo tienes que unir dos palabras de relación, y el componente izquierdo de dicha relación compuesta agrega un matiz al derecho.

Podemos colocar **le** (por ejemplo, con un número) a la izquierda de una relación compuesta para obtener un término de argumento más rico:

le pa melbi zdani
: el hogar bonito

Ahora sabes por qué había **cu** después de los términos principales en nuestro ejemplo:

> **le pa prenu cu tavla mi**
> _La persona me habla._

Sin **cu**, se convertiría en **le pa prenu tavla**, lo cual tendría el significado de _la persona-hablante_ - lo que sea que eso pueda significar.

Considera:

> **le pa tavla pendo**
> _El amigo que habla_
<!-- -->
> **le pa tavla cu pendo**
> _El que habla es un amigo._

Recuerda colocar **cu** antes de la construcción principal de la relación en una oración para evitar la creación involuntaria de relaciones compuestas.

Las relaciones compuestas pueden contener más de dos componentes. En este caso, la primera relación modifica la segunda, la segunda modifica la tercera, y así sucesivamente:

<pixra url="/assets/pixra/cilre/cmalu_karce.webp" caption="ti cmalu karce" definition="Este es un coche pequeño."></pixra>

> **le pa melbi cmalu karce**
> _el coche bonito-pequeño, el coche pequeño de una manera bonita_

<!-- -->

> **le mutce melbi zdani**
> _la casa muy bonita_

mutce
: ...es muy, ...es mucho

### Tarea

sutra
: ...es rápido

barda
: ...es grande

cmalu
: ...es pequeño

mlatu
: ...es un gato

Cierra la parte derecha de la tabla. Traduce las frases de la izquierda del Lojban.

<table style="table-layout: fixed;">
<tbody><tr>
<td><b>le melbi karce</b>
</td>
<td><i>el coche bonito / los coches bonitos</i>
</td></tr>
<tr>
<td><b>do sutra klama</b>
</td>
<td><i>Tú vienes rápidamente. Tú vienes rápido.</i>
</td></tr>
<tr>
<td><b>tu barda zdani</b>
</td>
<td><i>Esa es una casa grande.</i>
</td></tr>
<tr>
<td><b>le pa sutra bajra mlatu</b>
</td>
<td><i>el gato corriendo rápidamente</i>
</td></tr>
<tr>
<td><b>le pa sutra mlatu</b>
</td>
<td><i>el gato rápido</i>
</td></tr>
<tr>
<td><b>le pa bajra mlatu</b>
</td>
<td><i>el gato corriendo</i>
</td></tr></tbody></table>

Cierra la parte derecha de la tabla. Traduce las frases de la izquierda al Lojban.

<table style="table-layout: fixed;">

<tbody><tr>
<td><i>Este es un coche pequeño.</i>
</td>
<td><b>ti cmalu karce</b>
</td></tr>
<tr>
<td><i>manzanas sabrosas</i>
</td>
<td><b>le kukte plise</b>
</td></tr>
<tr>
<td><i>los comedores rápidos</i>
</td>
<td><b>le sutra citka</b>
</td></tr>
<tr>
<td><i>Tú eres una persona que camina rápidamente.</i>
</td>
<td><b>do sutra cadzu prenu</b>
</td></tr></tbody></table>

### Preguntas de 'Sí/No'

En inglés, formamos una pregunta de 'sí/no' cambiando el orden de las palabras, por ejemplo:

> _You are ... ⇒ Are you ...?_

o usando alguna forma del verbo _to do_ al principio, por ejemplo:

> _You know ... ⇒ Do you know?_

En Lojban, se puede mantener el orden de las palabras. Para convertir cualquier afirmación en una pregunta de 'sí/no', simplemente insertamos la palabra **xu** en alguna parte de la oración, por ejemplo, al principio:

> **xu do nelci le gerku**
> _¿Te gustan los perros?_

le gerku
: el perro, los perros

<pixra url="/assets/pixra/cilre/le_prenu_e_le_gerku.webp" caption="ti prenu .i ti gerku" definition="Esta es una persona. Este es un perro."></pixra>

Recuerda que en Lojban, la puntuación como "?" (signo de interrogación) es en su mayoría opcional y se utiliza principalmente con fines estilísticos. Esto se debe a que la palabra interrogativa **xu** ya indica que es una pregunta.

Otros ejemplos:

> **xu mi klama**
> _¿Voy yo?_

klama
: ... va a ... (a algún lugar)

> **xu pelxu**
> _¿Es amarillo?_

pelxu
: ... es amarillo

Podemos cambiar el significado colocando **xu** después de diferentes partes de la relación. Las explicaciones de lo que cambió en el significado se dan entre corchetes:

> **xu do nelci le gerku**
> _¿Te gustan los perros?_

<!-- -->

> **do xu nelci le gerku**
> _¿A TI te gustan los perros?_ (Pensé que era otra persona a quien le gustaban).

<!-- -->

> **do nelci xu le gerku**
> _¿Te GUSTAN los perros? (Pensé que simplemente eras neutral hacia ellos)._

<!-- -->

> **do nelci le xu gerku**
> _¿Te gustan LOS PERROS? (Pensé que te gustaban los gatos)._

<!-- -->

> **do nelci le gerku xu**
> _Te gustan esas cosas, ¿son perros? (Solo cuestionas la validez de la relación **gerku**)._

Lo que se expresa mediante la entonación en inglés se expresa moviendo **xu** después de la parte que queremos enfatizar en Lojban. Ten en cuenta que la primera oración con **xu** al principio hace la pregunta más genérica sin enfatizar ningún aspecto en particular.

**xu** es una palabra interjección. Estas son las características de las interjecciones en Lojban:

- La interjección modifica la construcción anterior a ella:

 > **do xu nelci le gerku**
 > _¿A TI te gustan los perros?_

- Cuando se coloca al principio de una relación, la interjección modifica toda la relación:

 > **xu do nelci le gerku**
 > _¿Te gustan los perros?_

- Las interjecciones se pueden colocar después de diferentes partes de la misma relación para cambiar el significado.

 > **do nelci le gerku xu**
 > _Te gustan esas entidades, ¿son perros?_

 Aquí, solo la relación **gerku** (no el argumento **le gerku**) es modificada por la palabra interrogativa **xu**. Por lo tanto, aquí nos preguntamos solo sobre esa relación. Afirmamos que te gustan esos objetos o seres vivos y te preguntamos si son perros.

Las interjecciones no rompen las relaciones compuestas, se pueden usar dentro de ellas:

> **do nelci le barda xu gerku**
> _¿Te gustan los perros GRANDES?_

Ahora, ¿cómo responder a estas preguntas de 'sí/no'? Repites la construcción principal de la relación:

> **— xu le mlatu cu melbi**
> **— melbi**
> _— ¿Los gatos son bonitos?_
> _— Bonitos._

Para responder 'no', usamos el término modal **na ku**:

> **— xu le mlatu cu melbi**
> **— na ku melbi**
> _— ¿Los gatos son bonitos?_
> _— No bonitos._

na ku
: término: es falso que ...

O, podemos usar una palabra especial de relación **go'i**:

> **— xu le mlatu cu melbi**
> **— go'i**
> _— ¿Los gatos son bonitos?_
> _— Bonitos._

go'i
: palabra de relación que repite la relación principal de la oración anterior

Aquí, **go'i** significa lo mismo que **melbi** ya que **melbi** es la relación de la relación anterior.

> **— xu le mlatu cu melbi**
> **— na ku go'i**
> _— ¿Los gatos son bonitos?_
> _— No bonitos._

<!-- Este curso no recomienda negar **go'i** para respuestas negativas. Solo usa **je'u nai**. -->

El término modal **na ku** se puede usar no solo en respuestas:

> **na ku mi nelci le gerku**
> _Es falso que me gusten los perros._
> _No me gustan los perros._
<!-- -->
> **mi na ku nelci do**
> _No me gustas._

Su opuesto, el término **ja'a ku** afirma el significado:

> **mi ja'a ku nelci do**
> _Sí me gustas._

ja'a ku
: término: es verdadero que ...

### Tarea

Completa la parte derecha de la tabla. Traduce las oraciones de la izquierda al Lojban.

<table style="table-layout: fixed;">

<tbody><tr>
<td><b>xu le barda zdani cu melbi</b>
</td>
<td><i>¿Es bonita la casa grande?</i>
</td></tr>
<tr>
<td><b>— le prenu cu stati xu<br/>— na ku stati</b>
</td>
<td><i>— ¿Son inteligentes las personas?<br/>— No.</i>
</td></tr>
<tr>
<td><b>do klama le zarci xu</b>
</td>
<td><i>¿Vas al mercado?</i>
</td></tr>
<tr>
<td><b>xu le verba cu prami le mlatu</b>
</td>
<td><i>¿El niño ama a los gatos?</i>
</td></tr></tbody></table>

Completa la parte derecha de la tabla. Traduce las oraciones de la izquierda al Lojban.

<table style="table-layout: fixed;">

<tbody><tr>
<td><i>¿Es rápido el coche?</i>
</td>
<td><b>xu le karce cu sutra</b>
</td></tr>
<tr>
<td><i>— ¿Es sabrosa la naranja?<br/>— Sí, lo es.</i>
</td>
<td><b>— xu le najnimre cu kukte<br/>— kukte</b>
</td></tr>
<tr>
<td><i>¿El perro te ama?</i>
</td>
<td><b>xu le gerku cu prami do</b>
</td></tr></tbody></table>

### Felicidad y solicitudes educadas: ‘_¡Yay!_’ = «**ui**», ‘_¡Por favor!_’ = «**.e'o**»

La interjección **ui** muestra la felicidad de quien habla. Se utiliza de la misma manera que la carita sonriente ‘_:)_’ en los mensajes, para indicar que estás contento/a por algo. Aunque las caritas sonrientes pueden ser ambiguas, **ui** tiene solo un significado, lo cual es práctico.

> **ui do klama**
> _¡Yay, tú vienes!_

ui
: interjección: _¡Yay!_, interjección de felicidad


La interjección **.e'o** al comienzo de una oración la convierte en una solicitud educada:

> **.e'o do lebna le fonxa**
> _¿Podrías tomar el teléfono, por favor?_
> `Por favor, toma el teléfono.`

.e'o
: interjección: por favor (pronunciada como _eh-haw_ con una breve pausa o pausa antes de la palabra)

lebna
: tomar (algo)

En inglés, para ser educado, se debe usar _could you_ + _please_ + una pregunta. En lojban, **.e'o** es suficiente para hacer una solicitud educada.

### Tarea

Completa la parte derecha de la tabla. Traduce las oraciones de la izquierda del lojban.

le tcati
: el té

<pixra url="/assets/pixra/cilre/tcati.webp" caption="tcati" definition="...es un poco de té"></pixra>

le ckafi
: café

<pixra url="/assets/pixra/cilre/ckafi.webp" caption="ckafi" definition="...es un poco de café"></pixra>

zgana
: observar, mirar (usando cualquier sentido)

le skina
: la película

<pixra url="/assets/pixra/cilre/zgana_le_skina.webp" caption="le prenu cu zgana le skina" definition="La persona mira la película."></pixra>

kurji
: cuidar de (alguien, algo)

<table style="table-layout: fixed;">

<tbody>
<tr>
<td><b>ui carvi</b>
</td>
<td><i>¡Yay, está lloviendo! ¡Yay, está lloviendo!</i>
</td></tr>
<tr>
<td><b>.e'o do sutra bajra</b>
</td>
<td><i>¡Corre rápido!</i>
</td></tr>
<tr>
<td><b>.e'o do pinxe le tcati</b>
</td>
<td><i>¡Por favor, bebe té!</i>
</td></tr>
<tr>
<td><b>.e'o zgana le skina</b>
</td>
<td><i>¡Por favor, mira la película!</i>
</td></tr></tbody></table>

Completa la parte derecha de la tabla. Traduce las oraciones de la izquierda al lojban.

<table style="table-layout: fixed;">

<tbody><tr>
<td><i>¡Por favor, sé inteligente!</i>
</td>
<td><b>.e'o do stati</b>
</td></tr>
<tr>
<td><i>¡Por favor, ve a casa!</i>
</td>
<td><b>.e'o do klama le zdani</b>
</td></tr>
<tr>
<td><i>¡Por favor, bebe el café!</i>
</td>
<td><b>.e'o do pinxe le ckafi</b>
</td></tr>
<tr>
<tr>
<td><i>¡Yay, hablo contigo!</i>
</td>
<td><b>ui mi tavla do</b>
</td></tr>
<tr>
<td><i>Por favor, cuida del niño.</i>
</td>
<td><b>.e'o do kurji le verba</b>
</td></tr></tbody></table>

### 'Y' 'O'

> **do nintadni .i je mi nintadni**
> _Eres un novato. Y yo soy un novato._

<!-- -->

> **do .e mi nintadni**
> _Tú y yo somos novatos._

<pixra url="/assets/pixra/cilre/do_e_mi_nintadni.webp" caption="do .e mi nintadni" definition="Tú y yo somos nuevos estudiantes."></pixra>

<!-- -->

> **mi tadni .i je mi tavla do**
> _Estudio. Y hablo contigo._

<!-- -->

> **mi tadni gi'e tavla do**
> _Estudio y hablo contigo._

.i je
: conjunción "y" que combina oraciones en una.

.e
: conjunción "y" que conecta argumentos.

gi'e
: conjunción "y" que conecta colas de oraciones.

Podemos combinar dos oraciones en una declaración usando la conjunción **.i je**, que significa _y_:

> **do nintadni .i je mi nintadni**
> _Eres un novato. Y yo soy un novato._

Dado que ambas oraciones tienen la misma cola, podemos usar una contracción: la conjunción **.e** significa _y_ para los argumentos:

> **do .e mi nintadni**
> _Tú y yo somos novatos._

**do nintadni .i je mi nintadni** significa exactamente lo mismo que **do .e mi nintadni**

También podemos usar **.e** para conectar argumentos en otras posiciones.

Ambas oraciones significan lo mismo.

> **mi pinxe le djacu .e le jisra**
> _Bebo el agua y el jugo._
> **mi pinxe le djacu .i je mi pinxe le jisra**
> _Beb

jibni
: ...está cerca de...

ti
: esta cosa, este lugar cerca de mí

**je** es una conjunción en Lojban que significa _y_ en relaciones compuestas.

Sin **je**, la oración cambia de significado:

> **le melbi cmalu zdani cu jibni**
> _La casa bonita y pequeña está cerca._

Aquí, **melbi** modifica a **cmalu**, y **melbi cmalu** modifica a **zdani**, de acuerdo a cómo funcionan las relaciones compuestas.

En **le melbi je cmalu zdani** (_la casa bonita y pequeña_), tanto **melbi** como **cmalu** modifican directamente a **zdani**.

Otras conjunciones comunes incluyen:

> **le verba cu fengu ja bilma**
> _El niño está enojado o enfermo (o tal vez ambas cosas)_

<!-- -->

> **do .a mi ba vitke le dzena**
> _Tú o yo (o ambos) visitaremos al ancestro._

ja
: y/o

**.a** = _y/o_ al conectar argumentos.

fengu
: ...está enojado

<pixra url="/assets/pixra/cilre/fengu.webp" caption="fengu" definition="...está enojado"></pixra>

bilma
: ...está enfermo

<pixra url="/assets/pixra/cilre/bilma.webp" caption="le prenu cu bilma" definition="La persona está enferma"></pixra>

vitke
: visitar

dzena
: ...es un ancestro de...

<pixra url="/assets/pixra/cilre/dzena.webp" caption="dzena" definition="...es un ancestro de..."></pixra>

> **le karce cu blabi jo nai grusi**
> _El carro es blanco o gris._

<!-- -->

> **do .o nai mi vitke le laldo**
> _Tú o yo visitamos al anciano._

jo nai
: ya sea... o... pero no ambos

.o nai
: ya sea... o... pero no ambos (al conectar argumentos)

laldo
: ...es viejo

<pixra url="/assets/pixra/cilre/laldo.webp" caption="laldo" definition="… es viejo"></pixra>

Nota: es mejor recordar **jo nai** como una construcción única, y lo mismo para **.o nai**.

> **mi prami do .i ju do stati**
> _Te amo. Ya sea que seas inteligente o no._

<!-- -->

> **le verba cu nelci le plise .u le badna**
> _Al niño le gustan las manzanas, ya sea que le gusten o no los plátanos._

ju
: ya sea que...

.u
: ya sea que... (al conectar argumentos)

### «**joi**» es ‘_y_’ para acciones en masa

> **do joi mi casnu le bangu**
> _Tú y yo estamos discutiendo el lenguaje._

casnu
: ...discute...

le bangu
: el lenguaje

joi
: conjunción _y_ para masas

Si digo **do .e mi casnu le bangu**, puede significar que tú discutes el lenguaje y yo discuto el lenguaje. ¡Pero no necesariamente significa que estamos en la misma conversación!

Esto puede hacerse más visible si lo expandimos usando **.i je**:

> **do .e mi casnu le bangu**
> **do casnu le bangu .i je mi casnu le bangu**
> _Tú discutes el lenguaje. Y yo discuto el lenguaje._

Para enfatizar que tú y yo participamos en la misma acción, usamos una conjunción especial **joi** que significa _y_ y forma una "masa":

> **do joi mi casnu le bangu**
> _Tú y yo estamos discutiendo el lenguaje._
> _Tú y yo, como una sola entidad para este evento, estamos discutiendo el lenguaje._

El pronombre **mi'o** (_tú y yo juntos_) puede expresarse como **mi joi do**, que significa exactamente lo mismo (solo que es más largo). En Lojban, puedes usar no una sola palabra para _nosotros_, sino construcciones más precisas como **mi joi le pendo** (literalmente _yo y los amigos_).

<pixra url="/assets/pixra/cilre/casnu.webp" caption="do joi le pendo joi mi casnu" definition="Tú, el amigo y yo estamos en una discusión."></pixra>

### Tarea

Completa la parte derecha de la tabla. Traduce las oraciones de la izquierda del Lojban.

<table style="table-layout: fixed;">

<tbody><tr>
<td><b>mi nelci le badna .e le plise</b>
</td>
<td><i>Me gustan las bananas y me gustan las manzanas. Me gustan las bananas y las manzanas.</i>
</td></tr>
<tr>
<td><b>do sutra ja stati</b>
</td>
<td><i>Eres rápido o inteligente o ambos.</i>
</td></tr>
<tr>
<td><b>le za'u prenu cu casnu le karce .u le gerku</b>
</td>
<td><i>Las personas discuten los autos, ya sea que discutan o no los perros.</i>
</td></tr>
<tr>
<td><b>mi citka le najnimre .o nai le badna</b>
</td>
<td><i>Como o las naranjas o las bananas.</i>
</td></tr></tbody></table>

Completa la parte derecha de la tabla. Traduce las oraciones de la izquierda al Lojban.

<table style="table-layout: fixed;">

<tbody><tr>
<td><i>A los amigos y a mí nos gusta la lluvia.</i>
</td>
<td><b>le pendo .e mi cu nelci le carvi</b>
</td></tr>
<tr>
<td><i>Ya sea yo o tú vamos al mercado.</i>
</td>
<td><b>mi .o nai do klama le zarci</b>
</td></tr>
<tr>
<td><i>Miro el auto grande y hermoso.</i>
</td>
<td><b>mi catlu le barda je melbi karce</b>
</td></tr>
<tr>
<td><i>El niño bebe agua y/o jugo.</i>
</td>
<td><b>le verba cu pinxe le djacu .a le jisra</b>
</td></tr>
<tr>
<td><i>El niño y el pequeño discuten el auto.</i>
</td>
<td><b>le verba joi le pa cmalu cu casnu le karce</b> (nota el uso de <b>joi</b>. <i>el pequeño</i> es simplemente <b>le pa cmalu</b>).
</td></tr></tbody></table>

### Pero...

> **le najnimre cu barda .i je ku'i le badna cu cmalu**
> _Las naranjas son grandes. Pero los plátanos son pequeños._

ku'i
: interjección: pero, sin embargo

En realidad, en inglés, _but_ es lo mismo que _and_, y agrega un sabor de contraste.

En Lojban, simplemente usamos la conjunción **.i je** (o **.e**, **gi'e**, **je**, dependiendo de lo que conectemos) y le agregamos el sabor de contraste con la interjección **ku'i**. Esto nos dará el contraste necesario. Como de costumbre, la interjección modifica la construcción anterior.

### Eventos: "_bailar y estar juntos_" — «**le nu dansu .e le nu kansa**»

Algunos espacios de relaciones esperan un evento:

> **le cabna cu nicte**
> _Ahora es de noche. En este momento es de noche._

cabna
: ... (evento) está presente con ...; ... (evento) sucede ahora

le cabna
: el tiempo presente, el evento presente

nicte
: ... (evento) sucede de noche

Pero, ¿qué pasa si queremos describir un evento usando una oración completa?

Cualquier oración se puede convertir en una construcción de relación colocando **nu** al frente:

> **le nicte cu nu mi viska le lunra**
> _La noche es cuando veo la Luna._
> `La noche es un evento cuando veo la Luna.`

<pixra url="/assets/pixra/cilre/nicte_fi_mi.webp" caption="le nicte" definition="la noche"></pixra>

le nicte
: la noche, las noches

viska
: ver (algo)

le lunra
: la Luna

Aquí, **le nicte** es el primer argumento de la oración y **nu mi viska le lunra** es la construcción de relación principal de la oración. Sin embargo, dentro de esta relación principal, ¡podemos ver otra relación: **mi viska le lunra** incrustada!

La palabra **nu** transforma una oración completa en una relación que denota un evento (en su sentido genérico, puede ser un proceso, un estado, etc.)

Aquí hay algunos ejemplos más:

nu mi tavla
: ... es un evento de que yo hable

nu do tavla
: ... es un evento de que tú hables

Al agregar **le** antes de **nu**, creamos un argumento que denota un evento:

pinxe ⇒ le nu pinxe
: beber ⇒ el beber

dansu ⇒ le nu dansu
: bailar ⇒ el bailar

kansa ⇒ le nu kansa
: ... está junto con ... ⇒ estar juntos

klama ⇒ el venir
: venir a ... ⇒ el venir

le nu klama
: el venir de ti, tu venir

**le nu** a menudo corresponde al inglés _\-ing_, _\-ción_, _\-sión_.

Algunos ejemplos más con espacios que esperan eventos en lugar de entidades ordinarias:

> **mi djica le nu do klama ti**
> _Quiero que vengas aquí (a este lugar)_

djica
: querer (algún evento)

> **mi gleki le nu do klama**
> _Estoy feliz porque vienes._

gleki
: ... está feliz por ... (algún evento)

<pixra url="/assets/pixra/cilre/gleki.webp" caption="gleki" definition="... está feliz acerca de un evento..."></pixra>

> **le nu pinxe le jisra cu nabmi mi**
> _Beber el jugo es un problema para mí._

nabmi
: ... (evento) es un problema para ... (alguien), ... (evento) es problemático para ... (alguien)

### Tarea

Cierra la parte derecha de la tabla. Traduce las oraciones de la izquierda del lojban.

pilno
: usar (algo)

le skami
: la computadora

<table style="table-layout: fixed;">

<tbody><tr>
<td><b>mi nelci le nu do dansu</b>
</td>
<td><i>Me gusta que bailes.</i>
</td></tr>
<tr>
<td><b>xu do gleki le nu do pilno le skami</b>
</td>
<td><i>¿Estás feliz de usar computadoras?</i>
</td></tr>
<tr>
<td><b>do djica le nu mi citka le plise xu</b>
</td>
<td><i>¿Quieres que coma la <u>manzana</u>?</i>
</td></tr></tbody></table>

Cierra la parte derecha de la tabla. Traduce las oraciones de la izquierda al lojban.

<table style="table-layout: fixed;">

<tbody><tr>
<td><i>El venir aquí es un problema.</i>
</td>
<td><b>le nu klama ti cu nabmi</b>
</td></tr>
<tr>
<td><i>Quiero que estés feliz.</i>
</td>
<td><b>mi djica le nu do gleki</b>
</td></tr></tbody></table>

### Términos modales. Tiempos simples: ‘_era_’, ‘_es_’, ‘_será_’ — «**pu**», «**ca**», «**ba**»

En lojban, expresamos el tiempo en que ocurre algo (gramaticalmente, en inglés se llama generalmente _tiempo verbal_) con términos modales. Ya hemos visto el término modal **ca** que significa _en el presente_.

Aquí hay una serie de términos relacionados con el tiempo que indican cuándo ocurre algo:

> **le prenu pu cu tavla mi**
> _Las personas me hablaron._

<!-- -->

> **le prenu ca cu tavla mi**
> _Las personas me hablan (en el presente)._

<!-- -->

> **le prenu ba cu tavla mi**
> _Las personas me hablarán._

Cuando colocamos un argumento sin adornos después de una partícula relacionada con el tiempo, formamos un término con un significado ligeramente diferente:

> **mi pinxe le djacu ca le nu do klama**
> _Yo bebo el agua mientras tú vienes._

La parte **ca le nu do klama** es un término largo que significa _mientras vienes / mientras estás viniendo_. El **le nu do klama** es un argumento que significa *tu venida, tu venir*.

> **mi citka ba le nu mi dansu**
> _Como después de bailar._

Las partículas relacionadas con el tiempo se agrupan en series según su significado para facilitar su memorización y uso.

Palabras para tiempos simples:

- **pu** significa _antes de... (algún evento)_, **pu** solo denota tiempo pasado.
- **ca** significa _al mismo tiempo que... (algún evento)_, **ca** solo denota tiempo presente.
- **ba** significa _después de... (algún evento)_, **ba** solo denota tiempo futuro.

Los tiempos añaden información sobre cuándo ocurre algo. El inglés nos obliga a usar ciertos tiempos. Uno tiene que elegir entre

- _Las personas me hablan._
- _Las personas me hablaron._
- _Las personas me hablarán._

y otras opciones similares.

Pero en Lojban, las partículas de tiempo son opcionales, podemos ser tan vagos o precisos como queramos.

La frase

> **le prenu cu tavla mi**
> _Las personas me hablan._

en realidad no dice nada sobre cuándo ocurre esto. El contexto es lo suficientemente claro en la mayoría de los casos y nos puede ayudar. Pero si necesitamos más precisión, simplemente agregamos más palabras.

**ba** significa _después de... (algún evento)_, por lo que cuando decimos **mi ba cu citka** significa que comemos después del momento de hablar, por eso significa _voy a comer_.

Podemos combinar partículas de tiempo con y sin argumentos después de ellas:

> **mi pu cu citka le plise ba le nu mi dansu**
> _Comí las manzanas después de bailar._

Observa que el término **pu** (tiempo pasado) se coloca solo en la relación principal (**mi pu cu citka**). En Lojban, se asume que el evento _bailé_ ocurre en relación con el evento de comer.

No debemos colocar **pu** con **dansu** (a diferencia del inglés) ya que **mi dansu** se ve en relación con **mi pu cu citka**, por lo que ya sabemos que todo ocurrió en el pasado.

Más ejemplos de términos relacionados con el tiempo:

> **le nicte cu pluka**
> _La noche es agradable._

pluka
: ... es agradable

> **ba le nicte cu pluka**
> _Después de la noche es agradable._

Aquí, la cabeza de la oración contiene un término **ba le nicte**, un término modal con su argumento interno. Luego, después del separador **cu**, se sigue la relación principal de la oración **pluka** (**pluka** solo significa _Es agradable._)

Para decir _será agradable_, debemos usar el término en tiempo pasado:

> **le nicte ba cu pluka**
> _La noche será agradable._

También ten en cuenta que agregar un argumento después de una partícula relacionada con el tiempo puede llevar a un significado drásticamente diferente:

> **le nicte ba le nu citka cu pluka**
> _La noche es agradable después de comer._

Ten en cuenta que **ca** puede extenderse ligeramente hacia el pasado y el futuro, lo que significa _justo ahora_. Por lo tanto, **ca** refleja una noción ampliamente utilizada en todo el mundo de "tiempo presente".

También es posible integrar partículas modales en la construcción de la relación principal:

> **le nicte ba cu pluka**
> **le nicte ba pluka**
> _La noche será agradable._

Ambas oraciones significan lo mismo, **ba pluka** es una construcción de relación que significa _... será agradable_.

La estructura de **le nicte ba pluka** es la siguiente:

- **le nicte** - la cabeza de la oración con solo un término **le nicte**
- **ba pluka** - la cola de la oración que solo consiste en la relación **ba pluka**

Contrasta esto con la oración anterior **le nicte ba cu pluka**:

- **le nicte ba** - la cabeza de la oración con dos términos **le nicte** y **ba**
- **pluka** - la cola de la oración que solo consiste en la relación **pluka**

La ventaja de **le nicte ba pluka** sobre **le nicte ba cu pluka** es solo en concisión; generalmente puedes omitir decir **cu** en tales casos, ya que la oración de todos modos no se puede entender de otra manera.

Si deseas colocar un término modal antes de un término de argumento, puedes separarlo del texto siguiente "terminando" explícitamente el término con la palabra auxiliar **ku**:

> **ba ku le nicte cu pluka**
> **le nicte ba cu pluka**
> **le nicte ba pluka**
> _La noche será agradable._

**ku** evita que **ba le nicte** aparezca, manteniendo así **ba ku** y **le nicte** como términos separados.

Una última nota: las definiciones en inglés de las palabras en Lojban pueden usar tiempos verbales incluso cuando las palabras originales en Lojban no los implican, por ejemplo:

tavla
: ...habla con..., ...se comunica con...

pluka
: ...es agradable

Aunque _habla_, _es_, etc. están en presente (no siempre podemos eliminar los tiempos verbales en las palabras en inglés porque así funciona el inglés), siempre debemos asumir que el tiempo verbal no está implícito en el significado de las palabras definidas en Lojban a menos que la definición en inglés de dichas palabras mencione explícitamente restricciones de tiempo.

### Términos modales. Contornos de eventos: «**co'a**», «**ca'o**», «**co'i**»

Otra serie de partículas relacionadas con el tiempo, _contornos de eventos_:

co'a
: partícula de tiempo: el evento está comenzando

ca'o
: partícula de tiempo: el evento está en progreso

mo'u
: partícula de tiempo: el evento está completo

co'i
: partícula de tiempo: el evento se ve como un todo (ha comenzado y luego ha terminado)

La mayoría de las palabras de relación describen eventos sin especificar la etapa de esos eventos. Los contornos de eventos nos permiten ser más precisos:

> **mi pu co'a сu cikna**
> **mi pu co'a cikna**
> _Me desperté._

cikna
: ...está despierto/a

co'a cikna
: ...se despierta, se vuelve despierto/a

pu co'a cikna
: ...se despertó, se volvió despierto/a

<pixra url="/assets/pixra/cilre/coha_cikna.webp" caption="le prenu co'a cikna" definition="La persona se despierta."></pixra>

Para expresar precisamente el tiempo progresivo en inglés, usamos **ca'o**:

> **mi pu ca'o сu sipna**
> **mi pu ca'o sipna**
> _Estaba durmiendo._

sipna
: ...duerme

<pixra url="/assets/pixra/cilre/sipna.webp" caption="le mlatu ca'o sipna" definition="El gato está durmiendo."></pixra>

<!-- -->

> **mi ca ca'o pinxe**
> _Estoy bebiendo._

<!-- -->

> **mi ba ca'o pinxe**
> _Estaré bebiendo._

**mo'u** se usa para describir la finalización de eventos:

> **mi mo'u klama le tcana**
> _Llegué a la estación._

le tcana
: la estación

<pixra url="/assets/pixra/cilre/mohu_klama_le_tcana.webp" caption="le prenu mo'u klama le tcana" definition="La persona ha llegado a la estación."></pixra>

**co'i** generalmente corresponde al tiempo perfecto en inglés:

> **le verba ca co'i pinxe le jisra**
> _Los niños han bebido el jugo._

Podemos omitir **ca** en estas oraciones ya que el contexto sería lo suficientemente claro en la mayoría de los casos.

El tiempo presente simple en inglés describe eventos que ocurren a veces:

> **le prenu ca ta'e tavla**
> _Las personas (habitualmente, a veces) hablan._

ta'e
: tiempo simple: el evento ocurre habitualmente

Podemos usar las mismas reglas para describir el pasado usando **pu** en lugar de **ca** o el futuro usando **ba**:

> **le prenu pu co'i tavla mi**
> _Las personas habían hablado conmigo._

<!-- -->

> **le prenu ba co'i tavla mi**
> _Las personas habrán hablado conmigo._

El orden relativo de las partículas relacionadas con el tiempo es importante. En **ca co'i** primero decimos que algo sucede en el presente (**ca**), luego afirmamos que en este tiempo presente, el evento descrito ha sido completado (**co'i**). Solo cuando usamos este orden obtenemos el tiempo presente perfecto.

### Términos modales. Intervalos: ‘_durante_’ — «**ze'a**»

Otra serie de partículas modales enfatiza que los eventos ocurren durante un intervalo:

ze'i
: por un corto tiempo

ze'a
: a través de algún tiempo, por un tiempo, durante...

ze'u
: por mucho tiempo

> **mi pu ze'a cu sipna**
> **mi pu ze'a sipna**
> _Dormí por un rato._

<!-- -->

<pixra url="/assets/pixra/cilre/sipna_zeha.webp" caption="le prenu cu sipna ze'a le nu carvi" definition="La persona está durmiendo mientras llueve."></pixra>

> **mi pu ze'a le nicte cu sipna**
> _Dormí toda la noche._

Nota: no podemos omitir **cu** aquí ya que **nicte sipna** (_... es un durmiente nocturno_) es un tanru y, por lo tanto, llevaría a otro significado (aunque extraño).

> **mi pu ze'i le nicte cu sipna**
> _Dormí durante la corta noche._

Compara **ze'a** con **ca**:

> **mi pu ca le nicte cu sipna**
> _Dormí de noche._

le nicte
: la noche

Cuando usamos **ze'a**, estamos hablando de todo el intervalo de lo que describimos.

Ten en cuenta que **nicte** en sí mismo es un evento, por lo que no necesitamos **nu** aquí.

### Términos modales. ‘_porque_’ — «**ri'a**», ‘_hacia_’ — «**fa'a**», ‘_en (lugar)_’ — «**bu'u**»

Partícula modal para _porque_:

> **mi pinxe ri'a le nu mi taske**
> _Bebo porque tengo sed._

<!-- -->

> **mi citka ri'a le nu mi xagji**
> _Como porque tengo hambre._

ri'a
: porque ... (debido a algún evento)

taske
: ... tiene sed

<pixra url="/assets/pixra/cilre/taske.webp" caption="taske" definition="... tiene sed"></pixra>

xagji
: ... tiene hambre

<pixra url="/assets/pixra/cilre/xagji.webp" caption="xagji" definition="... tiene hambre"></pixra>

Las partículas modales que denotan lugar funcionan de la misma manera:

> **mi cadzu fa'a do to'o le zdani**
> _Camino en tu dirección, lejos de casa._

Ten en cuenta que, a diferencia de **klama**, las partículas modales **fa'a** y **to'o** denotan direcciones, no necesariamente puntos de inicio o final de la ruta. Por ejemplo:

> **le prenu cu klama fa'a do**
> _La persona se acerca a ti._

significa que la persona simplemente se está moviendo hacia tu dirección, pero no necesariamente hacia ti (quizás hacia algún lugar o persona cerca de ti).

<!-- -->

> **mi cadzu bu'u le tcadu**
> _Camino en la ciudad._

tcadu
: … is a city

fa'a
: hacia ..., en dirección a ...

to'o
: desde ..., desde la dirección de ...

bu'u
: en ..., (en algún lugar)

Nota: **nu** indica que una nueva oración interna comienza dentro de la oración principal. Colocamos **kei** después de dicha relación para mostrar su límite derecho, similar a cómo usamos ")" o "]" en matemáticas. Por ejemplo:

> **le gerku cu plipe fa'a mi ca le nu do ca'o klama**
> _El perro salta hacia mí cuando tú vienes._

<pixra url="/assets/pixra/cilre/le_gerku_faha_plipe.webp" caption="le gerku cu plipe fa'a mi" definition="El perro salta hacia mí."></pixra>

plipe
: saltar

pero

> **le gerku cu plipe ca le (nu do ca'o klama kei) fa'a mi**
> _El perro salta (cuando tú vienes) hacia mí._

Los paréntesis _(_ y _)_ se usan aquí solo para mostrar la estructura; no son necesarios en un texto normal en Lojban.

Usamos **kei** después de la oración interna **do ca'o klama** para mostrar que ha terminado, y la cola de la oración continúa con sus términos.

Compara esta oración con la siguiente:

> **le gerku cu plipe ca le (nu do ca'o klama fa'a mi)**
> _El perro salta (cuando tú vienes hacia mí)._

Como puedes ver, **do klama fa'a mi** es una relación dentro de la más grande, por lo que **fa'a mi** ahora está dentro de ella.

Ahora, no es el perro el que se acerca a mí, sino tú.

Al final de la declaración, **kei** nunca es necesario ya que ya indica el borde derecho.

Considera el siguiente ejemplo con una partícula relacionada con el tiempo:

> **mi pu citka le plise ba le nu mi dansu**
> _Comí las manzanas después de bailar._

<!-- -->

> **mi pu citka ba le nu mi dansu kei le plise**
> _Comí (después de bailar) las manzanas._

Podemos reorganizar la oración moviendo **ba le nu mi dansu** alrededor, siempre y cuando permanezca después de **pu**.

#### Tarea

Cierra la parte derecha de la tabla. Traduce las oraciones de la izquierda del Lojban.

le tsani
: el cielo

zvati
: ...está presente en... (algún lugar o evento), ...se queda en... (algún lugar)

le canko
: la ventana

le fagri
: el fuego

mi'o
: tú y yo

le purdi
: el jardín

le tcati
: el té

<table style="table-layout: fixed;">

<tbody><tr>
<td><b>mi ca gleki le nu do catlu le tsani</b>
</td>
<td><i>Estoy feliz de que mires el cielo.</i>
</td></tr>
<tr>
<td><b>xu le gerku pu ca'o zvati le zdani</b>
</td>
<td><i>¿Los perros se quedaban en casa?</i>
</td></tr>
<tr>
<td><b>do pu citka le plise ba le nu mi pinxe le jisra</b>
</td>
<td><i>Tú comiste las manzanas después de que yo bebí el jugo.</i>
</td></tr>
<tr>
<td><b>ko catlu fa'a le canko</b>
</td>
<td><i>Mira hacia la ventana.</i>
</td></tr>
<tr>
<td><b>xu do gleki ca le nu do ca'o cadzu bu'u le purdi</b>
</td>
<td><i>¿Eres feliz cuando caminas en el jardín?</i>
</td></tr>
<tr>
<td><b>ca le nu mi klama le zdani kei do pinxe le tcati ri'a le nu do taske</b>
</td>
<td><i>Cuando voy a casa, tú bebes té porque tienes sed.</i>
</td></tr></tbody></table>

Cierra la parte derecha de la tabla. Traduce las oraciones de la izquierda al Lojban.

<table style="table-layout: fixed;">

<tbody><tr>
<td><i>Tú mirarás el coche.</i>
</td>
<td><b>do ba catlu le karce</b>
</td></tr>
<tr>
<td><i>Tú quieres que llueva en el futuro.</i>
</td>
<td><b>do ca djica le nu ba carvi</b>
</td></tr>
<tr>
<td><i>¡Corre rápidamente lejos del fuego!</i>
</td>
<td><b>ko sutra bajra to'o le fagri</b>
</td></tr>
<tr>
<td><i>Tú y yo nos quedamos juntos en casa cuando estaba lloviendo.</i>
</td>
<td><b>mi'o pu ca'o zvati le zdani ca le nu carvi</b>
</td></tr></tbody></table>

### Nombres. Elección de un nombre

**cmevla**, o _palabra de nombre_, es un tipo especial de palabra utilizada para construir nombres personales. Es fácil reconocer le cmevla en un flujo de texto, ya que son las únicas palabras que terminan en una consonante y están envueltas por un punto a cada lado.

Ejemplos de le cmevla son: **.paris.**, **.robin.**

Si el nombre de alguien es _Bob_, entonces podemos crear un cmevla nosotros mismos que suene lo más parecido posible a este nombre, por ejemplo: **.bab.**

El ejemplo más simple de uso de un nombre sería

> **la .bab. cu tcidu**
> _Bob lee/está leyendo._

tcidu
: ... lee

<pixra url="/assets/pixra/cilre/tcidu_la_lojban.webp" caption="le prenu ca'o tcidu" definition="La persona está leyendo."></pixra>

**la** es similar a **le**, pero convierte una palabra en un nombre en lugar de un simple argumento.

En inglés, comenzamos una palabra con una letra mayúscula para mostrar que es un nombre. En lojban, usamos el prefijo **la**.

¡Siempre usa **la** al producir nombres!

Un nombre puede consistir en varios cmevla uno después de otro:

> **la .bab.djansyn. cu tcidu**
> _Bob Johnson lee/está leyendo._

Aquí, separamos los dos cmevla con solo un punto, que es suficiente.

Es común omitir los puntos al principio y al final de le cmevla para escribir textos más rápido, por ejemplo, al chatear. Después de todo, le cmevla aún están separados de las palabras vecinas por espacios alrededor de ellos:

> **la bab djansyn cu tcidu**

Sin embargo, en el lenguaje hablado, todavía es necesario hacer una breve pausa antes y después de le cmevla.

El primer nombre de Bob, el nombre del idioma _Lojban_, se puede usar en lojban sin muchos cambios:

> **la .lojban. cu bangu mi**
> _Hablo Lojban._
> Lojban es un idioma mío.
> `Lojban es un idioma que uso.`

bangu
: ... es un idioma utilizado por ... (alguien)

<!-- -->
> **mi nintadni la .lojban.**
> _Soy un nuevo estudiante de Lojban._
<!-- -->
> **mi tadni la .lojban.**
> _Estudio Lojban._

<pixra url="/assets/pixra/cilre/tadni.webp" caption="le prenu ca ca'o tadni la .lojban." definition="La persona está estudiando Lojban en este momento."></pixra>

Las letras de Lojban corresponden directamente a los sonidos, por lo que hay algunas reglas para adaptar los nombres a cómo se escriben en Lojban. Esto puede sonar extraño, después de todo, un nombre es un nombre, pero todos los idiomas hacen esto hasta cierto punto. Por ejemplo, los hablantes de inglés tienden a pronunciar _Jose_ como _Hozay_, y _Margaret_ en chino es _Mǎgélìtè_. Algunos sonidos simplemente no existen en algunos idiomas, por lo que debes reescribir el nombre para que solo contenga sonidos de Lojban y se escriba de acuerdo con la correspondencia entre letras y sonidos.

Por ejemplo:

la .djansyn.
: Johnson (probablemente, más cercano a la pronunciación americana)

la .suzyn.
: Susan (las dos letras _s_ se pronuncian de manera diferente: la segunda es en realidad una _z_, y la _a_ no es realmente un sonido de _a_)

Presta atención a cómo se pronuncia el nombre nativamente. Como resultado, los nombres en inglés y francés _Robert_ se pronuncian de manera diferente en Lojban: el nombre en inglés es **.robyt.** en inglés británico, o **.rabyrt.** en algunos dialectos americanos, pero el francés es **.rober.**

Aquí están las "Lojbanizaciones" de algunos nombres:

- _Alice_ ⇒ **la .alis.**
- _Mei Li_ ⇒ **la .meilis.**
- _Bob_ ⇒ **la .bab.**
- _Abdul_ ⇒ **la .abdul.**
- _Yan or Ian_ ⇒ **la .ian.**
- _Ali_ ⇒ **la .al.**
- _Doris_ ⇒ **la .doris.**
- _Michelle_ ⇒ **la .micel.**
- _Kevin_ ⇒ **la .kevin.**
- _Edward_ ⇒ **la .edvard.**
- _Adam_ ⇒ **la .adam.**
- _Lucas_ ⇒ **la .lukas.**

Notas:

* Se necesitan dos puntos adicionales (puntos) porque si no se ponen esas pausas en el habla, podría ser difícil saber dónde comienza y termina el nombre, o en otras palabras, dónde termina la palabra anterior y comienza la siguiente.
* La última letra de un cmevla debe ser una consonante. Si un nombre no termina en una consonante, generalmente agregamos una **s** al final; por lo tanto, en Lojban, _Mary_ se convierte en **.meris.**, _Joe_ se convierte en **.djos.**, y así sucesivamente. Alternativamente, podemos omitir la última vocal, por lo que _Mary_ se convertiría en **.mer.** o **.meir**.
* También puedes poner un punto entre el nombre y el apellido de una persona (aunque no es obligatorio), por lo que _Jim Jones_ se convierte en **.djim.djonz.**

### Reglas para crear le cmevla

Aquí hay una representación compacta de los sonidos en Lojban:

- vocales:
  - **a e i o u y au ai ei oi**
- consonantes:
  - **b d g v z j** (sonoras)
  - **p t k f s c x** (sordas)
  - **l m n r**
  - **i u**. Se consideran consonantes cuando se colocan entre dos vocales o al comienzo de una palabra. **.iaua** — aquí **i** y **u** son consonantes. **.iai** — aquí está la consonante **i** con la vocal **ai** después de ella.
  - **'** (apóstrofe). Se coloca solo entre dos vocales: **.e'e**, **.u'i**
  - **.** (punto, separación de palabras)

Para crear un nombre en Lojban, sigue estas reglas:

1. El nombre debe terminar en una consonante, excepto **'**. Si no es así, añade una consonante al final tú mismo. Además, envuélvelo con un punto a cada lado: **.lojban.**.
2. Las vocales solo pueden colocarse entre dos consonantes: **.sam.**, **.no'am.**
3. Las consonantes dobles se fusionan en una: _dd_ se convierte en **d**, _nn_ se convierte en **n**, etc. O se coloca una **y** entre ellas: **.nyn.**
4. Si una consonante sonora y una sorda están juntas, inserta una **y** entre ellas: **kv** se convierte en **kyv**. Alternativamente, puedes eliminar una de las letras: **pb** puede convertirse en una sola **p** o una sola **b**.
5. Si una de las letras **c**, **j**, **s**, **z** está junto a otra, inserta una **y** entre ellas: **jz** se convierte en **jyz**. Alternativamente, puedes eliminar una de las letras: **cs** puede convertirse en una sola **c** o una sola **s**.
6. Si **x** está junto a **c** o junto a **k**, inserta una **y** entre ellos: **cx** se convierte en **cyx**, **xk** se convierte en **xyk**. Alternativamente, puedes eliminar una de las letras: **kx** puede convertirse en una sola **x**.
7. Las subcadenas **mz**, **nts**, **ntc**, **ndz**, **ndj** se corrigen añadiendo una **y** en el interior o eliminando una de las letras: **nytc** o **nc**, **.djeimyz.**
8. Las dobles **ii** entre vocales se fusionan en una sola **i**: **.eian.** (pero no **.eiian.**)
9. Las dobles **uu** entre vocales se fusionan en una sola **u**: **.auan.** (pero no **.auuan.**)
10. El sonido de la "h" en inglés, como en "Harry", puede eliminarse o reemplazarse con **x**. _Harry_ puede convertirse en **.aris.** o **.xaris.**

### Palabras de relación como nombres

Puedes elegir un apodo agradable en Lojban utilizando no solo cmevla sino también palabras de relación. También puedes traducir tu nombre actual al Lojban si sabes lo que significa, o elegir un nombre completamente nuevo en Lojban.

Aquí tienes algunos ejemplos:

| Nombre original | Significado original | Palabra en Lojban | Significado en Lojban | Tu nombre |
| --- | --- | --- | --- | --- |
| Alexis | <i>ayudante</i> en griego | <b>le sidju</b> | <i>el ayudante</i> | <b>la sidju</b> |
| Ethan | <i>sólido, durante</i> en hebreo | <b>le sligu</b> | <i>el sólido</i> | <b>la sligu</b> |
| Mei Li | <i>hermoso</i> en mandarín chino | <b>le melbi</b> | <i>los hermosos</i> | <b>la melbi</b> |

### '_he_' '_she_'

Lojban no tiene palabras distintas para '_he_' o '_she_'. Posibles soluciones:

le ninmu
: la mujer (en sentido de género)

<pixra url="/assets/pixra/cilre/ninmu.webp" caption="le ninmu" definition="la mujer (humana de género femenino)"></pixra>

le nanmu
: el hombre (en sentido de género)

<pixra url="/assets/pixra/cilre/nanmu.webp" caption="le nanmu" definition="el hombre (humano de género masculino)"></pixra>

> **le ninmu cu tavla le nanmu .i le ninmu cu jatna**
> _La mujer habla con el hombre. Ella es una líder._

jatna
: ... es un líder, comandante

Los lojbanistas han propuesto varias palabras para otros géneros como

le nonmu
: la persona sin género

le nunmu
: la persona de género no binario

Sin embargo, en la mayoría de las situaciones, usar **le prenu** (_la persona_) o nombres propios es suficiente.

Otra opción es usar el pronombre corto **ri**, que se refiere al término de argumento anterior:

> **mi pu klama le nurma .i ri melbi**
> _Fui al campo. Era hermoso._

le nurma
: el área rural

melbi
: … is beautiful, nice to … (someone)

Aquí, **ri** se refiere al campo.

<pixra url="/assets/pixra/cilre/nurma.webp" caption="nurma" definition="... es un área rural"></pixra>

> **mi tavla le pendo .i ri jundi**
> _Hablo con el amigo. Él/Ella es atento/a._

jundi
: ... es atento/a

Aquí, **ri** se refiere al amigo.

<pixra url="/assets/pixra/cilre/tinjuhi.webp" caption="le gerku cu jundi" definition="El perro está atento."></pixra>

Nota: **ri** omite los pronombres **mi** (_yo_) y **do** (_tú_):

> **le prenu cu tavla mi .i ri pendo mi**
> _La persona me habla. Él/Ella es un/a amigo/a mío/a._

Aquí, **ri** omite el pronombre anterior **mi** y se refiere a **le prenu**, que es el término de argumento anterior disponible.

Otros dos pronombres similares son **ra** y **ru**.

real academia de bellas artes
: se refiere a un término de argumento utilizado recientemente

ru
: se refiere a un término de argumento usado incluso antes

> **le pendo pu klama le nurma .i ri melbi ra**
> _El amigo se fue al campo. El campo era hermoso para él/ella._

Aquí, dado que se usa **ri**, **ra** tiene que hacer referencia a un término de argumento completo más reciente, que para este ejemplo aislado es **le pendo**. **ra** también omite argumentos como **mi** y **do**.

Si no se utiliza **ri**, entonces **ra** puede hacer referencia incluso al último argumento completado:

> **le pendo pu klama le nurma .i ra melbi ru**
> _El amigo se fue al campo. El campo era hermoso para él/ella._

**ra** es más conveniente cuando eres vago y el contexto resolvería la referencia de todos modos.

### Presentarse. Vocativos

En Lojban, los _vocativos_ son palabras que se comportan como interjecciones (como **xu** que discutimos anteriormente), pero requieren un argumento que se adjunte a su derecha:

> **coi do**
> _¡Hola, tú!_

coi
: vocativo: ¡Hola! ¡Hola!

<pixra url="/assets/pixra/cilre/coi.webp" caption="coi do" definition="Hello to you!"></pixra>

Usamos **coi** seguido de un término de argumento para saludar a alguien.

> **co'o do**
> _Adiós a ti._

co'o
: vocativo: adiós!

<pixra url="/assets/pixra/cilre/coho.webp" caption="co'o do" definition="¡Adiós a ti!"></pixra>

<div class="common"></div>

> **coi ro do**
> _¡Hola a todos!_
> `Hola a cada uno de ustedes`

— es como la gente suele comenzar una conversación con varias personas. Por supuesto, también son posibles otros números: **coi re do** significa *Hola a los dos* etc.

Dado que los vocativos funcionan como interjecciones, tenemos bonitos tipos de saludos:

<pixra url="/assets/pixra/cilre/cerni.webp" caption="cerni" definition="... es la mañana"></pixra>
<pixra url="/assets/pixra/cilre/donri.webp" caption="donri" definition="... es la hora del día"></pixra>
<pixra url="/assets/pixra/cilre/vanci.webp" caption="vanci" definition="... es la tarde"></pixra>
<pixra url="/assets/pixra/cilre/nicte.webp" caption="nicte" definition="... es la noche"></pixra>

<div class="common"></div>

> **cerni coi**
> _¡Buenos días!_
> `Es la mañana — ¡Hola!`

<div class="common"></div>

> **vanci coi**
> _¡Buenas tardes!_

<div class="common"></div>

> **donri coi**
> _¡Buen día!_

<!-- -->

> **nicte coi**
> _¡Saludos nocturnos!_

Nota: en inglés, _Goodnight!_ significa _¡Adiós!_ o denota desearle a alguien una buena noche. Por su significado, _Goodnight!_ no pertenece a la serie de saludos anteriores. Por lo tanto, usamos una redacción diferente en Lojban:

<div class="common"></div>

> **nicte co'o**
> _¡Buenas noches!_

o

<div class="common"></div>

> **.a'o pluka nicte**
> _¡Noche agradable!_

.a'o
: interjección: espero

pluka
: ... es agradable para ... (alguien)

Por supuesto, podemos ser vagos diciendo simplemente **pluka nicte** (solo significando _noche agradable_ sin ningún deseo explícito).

El vocativo **mi'e** + un argumento se usa para presentarse:

> **mi'e la .doris.**
> _Soy Doris. Habla Doris._

mi'e
: vocativo: identifica al hablante

El vocativo **doi** se usa para dirigirse directamente a alguien:

> **mi cliva doi la .robert.**
> _Me estoy yendo, Robert._

cliva
: irse (de algo o alguien)

Sin **doi**, el nombre podría llenar el primer argumento de la relación:

> **mi cliva la .robert.**
> _Me estoy yendo de Robert._

**doi** es similar al inglés antiguo _O_ (como en _O ye of little faith_) o al vocativo latino (como en _Et tu, Brute_). Algunos idiomas no hacen esta distinción entre estos contextos, aunque como puedes ver, el inglés antiguo y el latín sí lo hacían.

Dos vocativos más son **ki'e** para decir gracias y **je'e** para aceptarlos:

> **— ki'e do do pu sidju mi**
> **— je'e do**
> _— Gracias, me ayudaste._
> _— De nada._

sidju
: … ayuda a … (alguien)

Podemos omitir el argumento después del vocativo solo al final de la oración. Por ejemplo, podemos decir simplemente:

> **— coi .i xu do kanro**
> _— ¡Hola! ¿Cómo estás?_
> `— ¡Hola! ¿Estás saludable?`

kanro
: … está saludable

Aquí, una nueva oración comienza inmediatamente después del vocativo **coi**, por lo que omitimos el nombre. O podemos decir:

> **coi do mi djica le nu do sidju mi**
> _Hola. Quiero que me ayudes._
> `Hola tú. Quiero que me ayudes.`

Por lo tanto, si no conoces el nombre del oyente y quieres continuar la misma oración después del vocativo, simplemente coloca **do** después de él.

Si usas el vocativo por sí solo (sin un argumento después) y la oración aún no ha terminado, entonces debes separarlo del resto. Esto se debe a que las cosas que más probablemente sigan al vocativo en una oración podrían interpretarse fácilmente como descripciones de tu interlocutor. Para separarlo del argumento siguiente, usa la palabra **do**. Por ejemplo,

> **coi do la .alis. la .doris. pu cliva**
> _¡Hola! Alice se fue de Doris._
> `¡Hola tú! Alice se fue de Doris`

<!-- -->

> **coi la .alis. la .doris. pu cliva**
> _¡Hola, Alice! Doris se fue._

Y si quieres poner tanto vocativos como interjecciones, modificando toda la oración, por favor coloca las interjecciones primero:

> **.ui coi do la .alis. la .doris. pu cliva**
> _¡Hurra, hola! Alice se fue de Doris._

Nota: al comienzo de una oración, las interjecciones generalmente se colocan antes de los vocativos porque:

> **coi .ui do la .alis. la .doris. pu cliva** significa

> _¡Hola (estoy feliz por este saludo)! Tú! Alice se fue de Doris._

Entonces, una interjección inmediatamente después de un vocativo modifica ese vocativo. De manera similar, una interjección modifica el argumento de un vocativo cuando se coloca después de él:

> **coi do .ui la .alis. la .doris. pu cliva**
> _¡Hola tú (estoy feliz por ti)! Alice se fue de Doris._