---
title: alfabeto krulermorna
---

**la krulermorna** es una ortografía alternativa que implementa más estrictamente el isomorfismo audiovisual de la ortografía de Lojban.

1. La mayoría de las letras son de la ortografía original basada en el latín.
2. Las semivocales **i** y **u** delante de las vocales se consideran consonantes y, por lo tanto, se expresan mediante letras distintas:
    * **i** => **ɩ**
    * **u** => **w**
3. Los diptongos que actúan como otras vocales "puras" se expresan mediante letras distintas:
    * **au** => **ǎ**
    * **ai** => **ą**
    * **ei** => **ę**
    * **oi** => **ǫ**
4. En otras posiciones, **i** y **u** se mantienen como están en la ortografía original del latín.

## Uso

La krulermorna se utiliza mediante un algoritmo en la aplicación [la sutysisku](https://la-lojban.github.io/sutysisku/en/ "la sutysisku") para buscar rimas de palabras en Lojban.

También puede ayudar a entender la morfología de Lojban.

Aparte de eso, es principalmente un proyecto artístico.

El número total de letras en el alfabeto de Lojban se eleva de 26 en la ortografía oficial a 32 en la krulermorna, lo que puede no ser deseable para las personas que usan teclados pequeños en pantalla como los de los dispositivos portátiles.

## la vlipa krulermorna

<figure class="wide">
	<img src="https://github.com/La-Lojban/suho-pixra-pe-la-jbotcan/blob/master/320px-la_vlipa_krulermorna.png?raw=true" alt="la vlipa krulermorna">
	<figcaption>
	.i coi do<br/>.i mi ca jai gau djuno fai do<br/>lo du'u wi mi ca pilno<br/>la krulermorna<br/>lo ka ciska dei<br/>.i ɩa ky. jai cinri
	</figcaption>
</figure>

_la vlipa krulermorna_ es una modificación de la krulermorna en la que la letra **ǎ** se reemplaza con el Carácter Unicode 'LATIN SMALL LETTER AU'. Este último no es compatible con la mayoría de las fuentes utilizadas y, por lo tanto, esta variante de la ortografía de la krulermorna se usa menos.

## Interjecciones según krulerske

|          |           |              |        |
| -------- | --------- | ------------ | ------ |
| .ǎ       | .ą        | .ę           | .ǫ     |
| ¡Ojalá!  | Voy a     | debería ser  | ¡Ay!   |

<div class="first_col">

|     | a               | e                | i                   | o             | u               |
| --- | --------------- | ---------------- | ------------------- | ------------- | --------------- |
| .   |                 |                  |                     |               |                 |
| ɩ   | Creo            | ¡Sí! de acuerdo  | ¡Ay!                | respeto       | ¡Me encanta!    |
| w   | descubrimiento  | ¡Qué sorpresa!   | ¡Hurra!             | ¡Voilà!      | ¡Pobre cosa!    |
| .a' | Estoy escuchando| alerta           | ¡Uf! (esfuerzo)     | Espero        | Mmm, me pregunto|
| .e' | Puedes          | ¡Vamos, hazlo!   | ¡Hazlo!             | Por favor, hazlo| Sugiero      |
| .i' | Vale, lo acepto | ¡Lo apruebo!     | Conozco ese sentimiento| gracias a ello| familiaridad|
| .o' | orgullo         | cercanía         | ¡Peligro!           | paciencia     | relajación     |
| .u' | ganancia        | ¡Qué maravilla! | ¡Jajaja!            | coraje        | ¡Lo siento!    |

</div>


## Representación alternativa

<div class="first_col">

|     | a          | e          | i            | o            | u           | ǎ      | ą      | ę          | ǫ              |
| --- | ---------- | ---------- | ------------ | ------------ | ----------- | ------ | ------ | ---------- | -------------- |
| .   |            |            |              |              |             | deseo  | intención | obligación | queja/dolor |
| ɩ   | creencia   | acuerdo    | miedo        | respeto      | amor        |        |        |            |                |
| w   | descubrimiento | sorpresa | felicidad | realización | lástima |        |        |            |                |
| .a' | atención   | alerta     | esfuerzo     | esperanza    | interés     |        |        |            |                |
| .e' | permiso    | competencia | restricción | solicitud    | sugerencia  |        |        |            |                |
| .i' | aceptación | aprobación | unión        | apreciación  | familiaridad |        |        |            |                |
| .o' | orgullo    | cercanía   | precaución   | paciencia    | relajación  |        |        |            |                |
| .u' | ganancia   | asombro    | diversión    | coraje       | arrepentimiento |        |        |            |                |

</div>