---
icon: 📕 
title: Idioma completo
---

**CLL no oficial** (coloquialmente, *UnCLL*, *InCLL*) es un proyecto organizado por Gleki de compilaciones experimentales no oficiales regulares (no necesariamente aprobadas por el Logical Language Group) del libro Complete Lojban Language.

*   Envía tus comentarios (errores notados, propuestas, sugerencias) a uno de los siguientes lugares:
    *   [Grupo de Reddit de Lojban](https://www.reddit.com/r/lojban/)
    *   [Grupo de Facebook de Lojban](https://www.facebook.com/groups/lojban)
    *   Chat en vivo: [Chat de Telegram](https://t.me/lojban) o [Chat de Discord](https://discord.gg/BVm4EYR)
    *   a <gleki.is.my.name@gmail.com> (Gleki&nbsp;Arxokuna), el mantenedor del UnCLL.

## Versiones
### geklojban-1.2.15 Octubre 2022
#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título tiene el documento marcado explícitamente como "geklojban-1.2.15" y tiene el nombre de la organización que lo publicó diferente al LLG; esto se hace para enfatizar que no es una publicación del LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [Formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [Formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
* o lee el llamado documento de "diferencia" en PDF que compara geklojban-1.2.15 con UnCLL, versión 1.2.14 (publicada en julio de 2021). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión de diferencia alternativa sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencia en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

Aquí está la traducción:

#### Breve lista de cambios en comparación con la versión anterior 'geklojban-1.2.14 julio de 2021'

* se corrigieron errores tipográficos y problemas de estilo en la crestomatía (gracias a koyshi, gleki)
* [problema #475](https://github.com/lojban/cll/issues/475) **nunkilbra** se cambió a **nunkilca'a** (gracias up4kid)
* [problema #466](https://github.com/lojban/cll/issues/466) se mejoró el algoritmo de prueba de tosmabru (gracias vpbroman)
* [problema #473](https://github.com/lojban/cll/issues/473) el cmavo "transposición de matriz" ahora utiliza el superíndice T para el operador de transposición
* Las menciones de la fuente Helvetica se reemplazaron con menciones de la fuente Comic ("Comic" es el nombre de al menos una fuente de código abierto)
* se corrigieron otros errores tipográficos menores (gracias Matt Nazarian, mattfbacon, la-kanba)
* cambios de CSS para que las versiones html funcionen mejor en dispositivos en modo oscuro (gracias a NathanHawks)
* el UnCLL ahora tiene archivos de diferencia visual desde la versión anterior y por separado para la versión oficial.

[fuente git del UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [En comparación con la versión 'geklojban-1.2.12 noviembre de 2020': diferencia git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparación entre la edición oficial CLL v.1.1 (2016) y la edición UnCLL de noviembre de 2020: diferencia git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* el documento PDF de ["diferencia"](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference_prefixed.pdf) que compara geklojban-1.2.15 con la edición oficial CLL v.1.1 (2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Se agregaron prefijos para que pueda usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión de diferencia alternativa sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (pero entonces tendrá que desplazarse manualmente por el documento para encontrar las diferencias).

### geklojban-1.2.14 julio de 2021


#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título del documento está marcada explícitamente como "geklojban-1.2.14" y tiene el nombre de la organización que lo publicó diferente del LLG; esto se hace para enfatizar que no es una publicación del LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [Formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [Formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* o lee el llamado documento de diferencia en PDF que compara geklojban-1.2.14 con el UnCLL, versión 1.2.12 (publicado en noviembre de 2020). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión de diferencia alternativa sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencia en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Breve lista de cambios en comparación con la versión anterior 'geklojban-1.2.11.1 octubre de 2020'

* es una de las mejoras principales. [Glosario de palabras Lojban](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) tiene alrededor de 200 nuevos ejemplos de oraciones en Lojban con su traducción al inglés. Dado que el número de palabras básicas en Lojban es de alrededor de 2000, significa que se ha completado ~10% de esta tarea.
* se corrigieron errores con **bo**, **ke'e** en el Capítulo 5. 'Negación escalar de selbri'
* se corrigió un nombre incorrecto de un archivo de audio
* más mejoras en el índice: se agregó ZEhA y más BAI
* se explica mejor cmevla según el dotside
* se agregaron puntos faltantes en cmavo donde sea necesario
* se corrigió la puntuación en la traducción del poema 'Kubla Khan'

[fuente git del UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Comparado con la versión 'geklojban-1.2.12 noviembre de 2020': diferencia git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparación entre la edición oficial CLL v.1.1 (2016) y la edición UnCLL de noviembre de 2020: diferencia git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
### geklojban-1.2.13 mayo de 2021


#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título del documento está marcada explícitamente como "geklojban-1.2.13" y tiene el nombre de la organización que lo publicó diferente al de LLG; esto se hace para enfatizar que no es una publicación de LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [Formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [Formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* o lee el llamado documento de diferencias en PDF que compara geklojban-1.2.13 con UnCLL, versión 1.2.12 (publicada en noviembre de 2020). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión de diferencia alternativa sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencias en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html). 

La traducción se presenta en un bloque de código.

Aquí está la traducción:

#### Breve lista de cambios en comparación con la versión anterior 'geklojban-1.2.11.1 de octubre de 2020'

* se agregaron nuevas imágenes de capítulos hermosas por [la-ninpre](https://github.com/la-ninpre)
* se agregó una traducción del poema 'En Xanadu' a la crestomatía
* se corrigió un intento extraño de teoría de conjuntos con fecha de [simpson](https://github.com/MostAwesomeDude)
* se corrigió la definición de **toldi** (_mariposa_)
* se corrigió una declaración incorrecta que implicaba que los fuhivla no tienen rafsi
* se hizo que la explicación de **le vi tavla ba klama** sea menos engañosa (corrección implementada por [mezohe](https://github.com/mezohe))
* Las matrices de más de dos dimensiones se pueden construir utilizando **pi'a** o **sa'i** con una etiqueta de subíndice apropiada que etiquete la dimensión... Las etiquetas pueden ser cualquier cosa que **xi** admita, por ejemplo, **pa** o **mlatu bu**.
* Capítulo 5: se restaura la mención de la agrupación **bo** en la sección sobre NAhE, y se agrega **bo** a un ejemplo (corrección implementada por [mezohe](https://github.com/mezohe))
* Capítulo 7: se corrige la declaración sobre **ra'o** en el ejemplo 7.39 (corrección implementada por [mezohe](https://github.com/mezohe))
* Capítulo 2: se corrige el diagrama (predicado -> predicación) (corrección implementada por [mezohe](https://github.com/mezohe))
* se agregaron puntos faltantes en cmavo
* se corrigieron otros errores menores, elementos de índices, scripts de compilación, etc.

[fuente git de UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [En comparación con la versión 'geklojban-1.2.12 de noviembre de 2020': diferencia git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Comparación entre la edición oficial CLL v.1.1 (2016) y la edición UnCLL de noviembre de 2020: diferencia git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
### geklojban-1.2.12 de noviembre de 2020

Aquí está la traducción:

#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título del documento está marcada explícitamente como "geklojban-1.2.12" y tiene el nombre de la organización que lo publicó diferente al de LLG; esto se hace para enfatizar que no es una publicación de LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    *   [Formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    *   [Formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* o lee el llamado documento PDF de "diferencias" que compara geklojban-1.2.12 con CLL publicado en 2016 (versión del 27 de agosto de 2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión de diferencia alternativa sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencia en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Breve lista de cambios en comparación con la versión anterior 'geklojban-1.2.11.1 octubre de 2020'

* Se agregó la pronunciación estándar de {u} en el capítulo IPA (por [Vexatos](https://github.com/Vexatos))
* Los símbolos de subíndice en las glosas se tratan adecuadamente (error notado por [gr-g](https://github.com/gr-g))
* Se corrigió un error gramatical en el Ejemplo 17.36 (error notado por [kotwys](https://github.com/kotwys))
* La partícula **ri'u** faltaba en la Sección 10.28 (como notó [gr-g](https://github.com/gr-g)). Agregado
* En el Ejemplo 7.12, el primer lugar de **lafti** se aplica a una persona. El predicado cambia a **lafmuvgau** (que está en las notas de la definición de **lafti**)
* En el texto en inglés, cambia .) a ). donde sea necesario
* Muestra la raíz cuadrada, el infinito y la proporción áurea phi con símbolos reales
* Corrige la traducción incorrecta de **levi rozgu cu sofi'upanova'e xunre**
* otras correcciones menores
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.12)
#### Comparación de código fuente con versiones anteriores
* [Comparado con la versión 'geklojban-1.2.11.1 octubre de 2020': diferencia git](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Comparado con la versión oficial CLL v.1.1 (2016)': diferencia git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.11.1 octubre de 2020

Aquí está la traducción:

#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título del documento está marcada explícitamente como "geklojban-1.2.11" y tiene el nombre de la organización que lo publicó diferente del LLG; esto se hace para enfatizar que no es una publicación del LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    *   [Formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    *   [Formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* o lee el llamado documento de diferencias en PDF que compara geklojban-1.2.11 con el CLL publicado en 2016 (versión del 27 de agosto de 2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión alternativa de diferencias sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencias en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Breve lista de cambios en comparación con la versión anterior 'geklojban-1.2.10 agosto de 2020'

* Se agregaron enlaces de audio (audio de la tcakoi, la .lindar., la .aionys.) a las versiones HTML "divididas por secciones" y "divididas por capítulos" del libro.
* Se corrigieron varios errores tipográficos.
* Se agregaron caracteres hanzi a un ejemplo en chino.
* Versión de corrección rápida 1.2.11.1: hacer que los botones de audio en las páginas HTML funcionen realmente.
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.11)
#### Comparación de código fuente con versiones anteriores
* [En comparación con la versión 'geklojban-1.2.10 agosto de 2020': diferencia de git](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [En comparación con la versión oficial CLL v.1.1 (2016)': diferencia de git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)
### geklojban-1.2.10 agosto de 2020

Aquí está la traducción:

#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título del documento está marcada explícitamente como "geklojban-1.2.10" y tiene el nombre de la organización que lo publicó diferente del LLG; esto se hace para enfatizar que no es una publicación del LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    *   [Formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    *   [Formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* o lee el llamado documento de diferencias en PDF que compara geklojban-1.2.10 con el CLL publicado en 2016 (versión del 27 de agosto de 2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Se agregan prefijos para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión alternativa de diferencias sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencias en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Breve lista de cambios en comparación con la versión anterior 'geklojban-1.2.9 julio de 2020'

* Se agregó el volumen de Créstomos (textos seleccionados) después del último capítulo
* los puntos nunca se omiten en las palabras, ni siquiera en el Índice de Palabras Lojban
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.10)
#### Comparación de código fuente con versiones anteriores
* [Comparado con la versión 'geklojban-1.2.9 julio de 2020': diferencia de git](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Comparado con la versión oficial CLL v.1.1 (2016)': diferencia de git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)

### geklojban-1.2.9 julio de 2020

Aquí está la traducción:

#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título del documento está marcada explícitamente como "geklojban-1.2.9" y tiene el nombre de la organización que lo publicó diferente del LLG; esto se hace para enfatizar que no es una publicación del LLG:
    *   [formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    *   [formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    *   [formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    *   [formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* o lee el llamado documento de diferencias en PDF que compara geklojban-1.2.9 con el CLL publicado en 2016 (versión del 27 de agosto de 2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión alternativa de diferencias sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencias en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Breve lista de cambios en comparación con la versión anterior 'geklojban-1.2.8.1 junio de 2020'

* La versión HTML ahora tiene tablas y ejemplos que se pueden desplazar horizontalmente en pantallas estrechas (por ejemplo, dispositivos móviles). Esto hace que la versión HTML sea más amigable para dispositivos móviles.
* Se genera de nuevo el EPUB (faltaba en la versión 1.2.8.1)
* Los símbolos coreanos y chinos ahora se muestran con la fuente Noto CJK
* lugares como "$x_1$" ahora se muestran con números subíndice
* Un ejemplo en la Sección 16.9 {naku zo'u la djan. klama} no correspondía a otros ejemplos a su alrededor, por lo que se reemplazó con {naku zo'u mi klama le zarci} (un error notado por [Corbin Simpson](https://github.com/MostAwesomeDude))
* se agrega una definición de la palabra {bu'u} a la lista de otras partículas gramaticales de la clase FAhA
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.9)
#### Comparación de código fuente con versiones anteriores
* [Comparado con la versión 'geklojban-1.2.8.1 junio de 2020': diferencia git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Comparado con la versión 'geklojban-1.2.3 enero de 2020': diferencia git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Comparado con la edición oficial CLL v.1.1 (2016)': diferencia git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.9)
### geklojban-1.2.8.1 junio de 2020

#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título del documento está marcada explícitamente como "geklojban-1.2.8.1" y tiene el nombre de la organización que lo publicó diferente de LLG; esto se hace para enfatizar que no es una publicación de LLG:
    *   [formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    *   [formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    *   [formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* o lee el llamado documento de "diferencias" en PDF que compara geklojban-1.2.8.1 con CLL publicado en 2016 (versión 2016-08-27). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión alternativa de diferencias sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (pero tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencias en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista corta de cambios en comparación con la versión anterior 'geklojban-1.2.7 mayo de 2020'

* Se agregó una nueva ortografía "diacrítica" llamada "zbalermorna". Se menciona claramente como no oficial. Sus símbolos ("letras") se muestran con una fuente adecuada. Felicitaciones a [Jack Humbert](https://jackhumbert.github.io/zbalermorna/) y su equipo (la saski'o, la xaspeljba y otros) por la fuente y la revisión de la explicación de la ortografía.
* Los índices han sido revisados (casi todas sus 4000 entradas). Se han modificado numerosas entradas para facilitar su uso o se han movido del Índice de Palabras Lojban al Índice General o viceversa.
* la regla para el uso de la coma se [revirtió](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) a la versión de CLL 1.1
* un mejor algoritmo de diferencias para ver las diferencias entre versiones (sin desorden adicional)
* versión 1.2.8.1 lanzamiento de hotfix: se solucionaron los problemas con la visualización de los símbolos zbalermorna en el documento PDF
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)

#### Comparación de código fuente con versiones anteriores
* [Comparado con la versión 'geklojban-1.2.7 mayo de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Comparado con la versión 'geklojban-1.2.3 enero de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Comparado con la edición oficial CLL v.1.1 (2016)': diferencia en git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)
### geklojban-1.2.7 mayo de 2020
#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título tiene el documento marcado explícitamente como "geklojban-1.2.7" y tiene el nombre de la organización que lo publicó diferente de LLG; esto se hace para enfatizar que no es una publicación de LLG:
    *   [formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    *   [formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    *   [formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    *   [formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* o lee el llamado documento PDF de "diferencia" que compara geklojban-1.2.7 con CLL publicado en 2016 (versión del 27 de agosto de 2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión de diferencia alternativa sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencia en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Breve lista de cambios en comparación con la versión anterior 'geklojban-1.2.6 abril de 2020'

* "El cmavo tu'a se utiliza en la formación de abstracciones, y se explica más completamente en la Sección 11.11." pero no se menciona en absoluto en esa sección. Se cambió la referencia a la Sección 11.10. El error fue notado por [Robert Baruch](https://github.com/RobertBaruch).
* todas las referencias a selma'o se movieron del índice de palabras lojban al índice general en el apéndice.
* Sección 10.18. La frase "A diferencia de la negación contradictoria -nai, la negación escalar de los tiempos no se limita a PU y FAhA:" contradecía el texto siguiente de la sección. Se reemplazó con "Un ejemplo de negación escalar de FAhA:"
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.7)

#### Comparación de código fuente con versiones anteriores
* [Comparado con la versión 'geklojban-1.2.6 de abril de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Comparado con la versión 'geklojban-1.2.3 de enero de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Comparado con la edición oficial CLL v.1.1 (2016)': diferencia en git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)
### geklojban-1.2.6 abril de 2020
#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título tiene el documento marcado explícitamente como "geklojban-1.2.6" y tiene el nombre de la organización que lo publicó diferente de LLG; esto se hace para enfatizar que no es una publicación de LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [Formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [Formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [Formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* o lee el llamado documento PDF de "diferencia" que compara geklojban-1.2.6 con CLL publicado en 2016 (versión del 27 de agosto de 2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión de diferencia alternativa sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencia en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista corta de cambios en comparación con la versión anterior 'geklojban-1.2.5 de marzo de 2020'

* nuevas imágenes de alta resolución para varios capítulos hechas por [la ninpre](https://github.com/la-ninpre) (posible violación de derechos de autor rechazada)
* la regla 'las comas nunca son necesarias' ahora está temporalmente limitada a las comas que son separadores de sílabas
* se agregaron más enlaces a varios selma'o al índice de palabras de lojban
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.6)#### Comparación de código fuente con versiones anteriores
* [Comparado con la versión 'geklojban-1.2.5 de marzo de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.5...geklojban-1.2.6)
* [Comparado con la versión 'geklojban-1.2.3 de enero de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.6)
### geklojban-1.2.5 marzo de 2020

Aquí está la traducción:

#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título del documento está marcada explícitamente como "geklojban-1.2.5" y tiene el nombre de la organización que lo publicó diferente de LLG; esto se hace para enfatizar que no es una publicación de LLG:
    *   [formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    *   [formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    *   [formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    *   [formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* o lee el llamado documento de diferencias en PDF que compara geklojban-1.2.5 con CLL publicado en 2016 (versión del 27 de agosto de 2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión alternativa de diferencias sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencias en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Breve lista de cambios en comparación con la versión 'geklojban-1.2.3 enero de 2020'
* temporalmente se elimina el uso controvertido de ni+ce'u
* se utiliza un mejor ejemplo para NU JA NU, se elimina la expansión de NU JA NU (que puede no ser ambigua en caso de varios NU JA NU en un bridi)
* se agregan hanzi y pinyin más bonitos a los ejemplos chinos
* Dotside: se agrega una parada glotal inicial a la transcripción IPA en un ejemplo
* se agrega "FA selma'o" al índice de palabras lojban
* la regla 'las comas nunca son necesarias' se limita temporalmente solo a cmevla
* se corrigen algunos errores de escritura
* se agregan símbolos UTF tal como son (en lugar de sus descripciones)
*   Dotside implementado
*   los conceptos "cmene" y "cmevla" ahora están separados
*   **sumti tcita** se renombra a **sumtcita**
*   **mi kucli le jei broda** ahora es **mi kucli tu'a le jei broda**
*   El diccionario con ejemplos ahora es técnicamente posible: el glosario ahora puede tener ejemplos debajo de las definiciones de las palabras (y lo hace para la palabra **coi** como muestra)
*   los rafsi para **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** se cambian según el cmavo.txt del año 2002.
*   se corrige una inmensa cantidad de errores de escritura y errores menores
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.5)

#### Comparación de código fuente con versiones anteriores
* [Comparado con la versión 'geklojban-1.2.4 de febrero de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Comparado con la versión 'geklojban-1.2.3 de enero de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)

### geklojban-1.2.4 de febrero de 2020
#### Versión compilada
*   lee el documento final que se utilizará para imprimir y publicar. Ten en cuenta que la página de título tiene el documento marcado explícitamente como "geklojban-1.2.4" y tiene el nombre de la organización que lo publicó diferente de LLG; esto se hace para enfatizar que no es una publicación de LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    *   [Formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    *   [Formato HTML, una página es una sección del libro](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    *   [Formato HTML - todo el libro en una sola página muy larga](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* o lee el llamado documento PDF de "diferencias" que compara geklojban-1.2.4 con CLL publicado en 2016 (versión del 27 de agosto de 2016). El documento tiene inserciones marcadas con verde y el prefijo "ins\`" y eliminaciones marcadas con rojo y el prefijo "del\`". Los prefijos se agregan para que puedas usar Cmd+F o Ctrl+F para encontrar rápidamente las diferencias en el documento PDF. Hay [una versión alternativa de diferencia sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (pero entonces tendrás que desplazarte manualmente por el documento para encontrar las diferencias).
*   o lee el documento de diferencia en formato HTML en su lugar:
    *   [con prefijos](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sin prefijos](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Breve lista de cambios en comparación con la versión 'geklojban-1.2.3 de enero de 2020'
* se corrigieron algunos errores de escritura
* se agregaron símbolos UTF tal como son (en lugar de sus descripciones)
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.4)
#### Comparación de código fuente con versiones anteriores
* [Comparado con la versión 'geklojban-1.2.3 de enero de 2020': diferencia en git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Comparado con la edición oficial CLL v.1.1 (2016)': diferencia en git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)
### geklojban-1.2.3 de enero de 2020


#### Breve lista de cambios

*   Se implementó Dotside
*   Los conceptos "cmene" y "cmevla" ahora están separados
*   **sumti tcita** se renombra a **sumtcita**
*   **mi kucli le jei broda** ahora es **mi kucli tu'a le jei broda**
*   Es técnicamente posible tener un diccionario con ejemplos: el glosario ahora puede tener ejemplos debajo de las definiciones de las palabras (y lo hace para la palabra **coi** como muestra)
*   Los rafsi para **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** se cambian según el cmavo.txt del año 2002.
*   Se corrigió una inmensa cantidad de errores tipográficos y menores
#### [fuente git](https://github.com/lojban/cll/compare/geklojban-1.2.3)