---
title: ¿Están rotos los verbos en Lojban?
---

<div class="lojbo simple_blockquotes"></div>

## Pregunta

Parece que aprender las definiciones de los verbos en Lojban, como

> *$x_1$ corre sobre la superficie $x_2$ usando las extremidades $x_3$ con el paso $x_4$*

podría ser un desafío porque casi cada verbo tiene su propia estructura de lugar distinta. ¿Hay alguna manera de hacer que esto requiera menos esfuerzo mental? ¿Por qué Lojban está diseñado de esta manera?
## Respuesta

El inglés funciona de manera similar en un sentido pragmático. Tiene verbos con su estructura de lugar implícita. La principal diferencia es que los diccionarios de Lojban declaran explícitamente la estructura de lugar, mientras que la mayoría de los diccionarios de inglés no lo hacen. La razón de este sistema es que tener una preposición separada para cada lugar sería aún más pesado y a veces incluso imposible. Por ejemplo:

> *Dependo de ti (?!)*

Además, tener un conjunto limitado de preposiciones haría que el lenguaje fuera altamente subjetivo y no universal. Por ejemplo, en inglés decimos

> *Dependo de ti*

pero en ruso se traduce como

> Dependo de ti

Ciertas preposiciones combinadas con verbos específicos podrían crear significados inusuales, lo que llevaría a aún más aleatoriedad que el sistema actual con $x_1$, $x_2$, etc.

Es importante tener en cuenta que la mayoría de los verbos de Lojban tienen solo hasta tres lugares. Solo alrededor de 30 verbos principales (lo gismu) tienen cinco lugares. Además, no es necesario conocer la estructura de lugar de cada verbo principal para hablar con fluidez en Lojban. Por ejemplo, ¿es crucial conocer la estructura de lugar de la 'función seno trigonométrica' al discutir la preparación de alimentos?

Es cierto que "Te doy un regalo" no requiere preposiciones, mientras que las estructuras de lugar de otros verbos sí lo hacen. Sin embargo, no hay más memorización involucrada. El inglés requiere aprender metáforas. ¿Por qué es "Te doy A ti" y "Te hablo A ti" cuando los procesos son completamente diferentes?

También, considera las siguientes traducciones:

> [Inglés] *Pienso en ti*

> [Ruso] *Ya dumayu o tebe* (Pienso en ti)

> [Español] *Yo pienso en ti* (Pienso en ti)

Algunas estructuras de lugar de Lojban son menos directas que otras, al igual que en inglés. Por ejemplo, ¿por qué es "Esta película es agradable PARA mí" en lugar de "Me gusta esta película"?

Los verbos de Lojban, al igual que los verbos en inglés, se pueden agrupar en marcos con estructuras de lugar idénticas, por ejemplo:

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=mlatu&bangu=en&versio=masno">mlatu</a> - $x_1$ es un gato de especie $x_2$

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=gerku&bangu=en&versio=masno">gerku</a> - $x_1$ es un perro de especie $x_2$
## La estructura de lugar es fácil de aprender, pero...

A menudo, la estructura de lugar es fácil de aprender. Sin embargo, el concepto de movimiento presenta un conjunto aleatorio de estructuras de lugar. Considere lo siguiente:

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a> - $x_1$ (objeto) se mueve hacia el destino/receptor $x_2$ [lejos] del origen $x_3$ sobre la ruta $x_4$.

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> - $x_1$ corre sobre la superficie $x_2$ usando las extremidades $x_3$ con el paso $x_4$.

¿Por qué no tener una estructura de lugar para todos ellos?

Aquí está la traducción:

## Respuesta

<a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a>, <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> y <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=cadzu&bangu=en&versio=masno">cadzu</a> describen un proceso similar desde perspectivas muy diferentes. En <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a>, el origen y el destino no son importantes; el énfasis está en la forma. No es "correr hacia desde" como en inglés. Por favor, no confundas las glosas en inglés con el proceso real que describen los verbos en Lojban. Estar en un estado de <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> significa tener una cierta forma de caminar mientras se toca una superficie con las extremidades y se hace rápidamente.

Una persona que usa una cinta de correr no tiene puntos "hacia" o "desde", sino que simplemente corre mientras permanece en el mismo lugar. Este es un buen ejemplo de un estado de bajra sin estar en un estado de klama.

En resumen, Lojban no es un inglés relajado, aunque el uso común y el diccionario Lojban-Inglés puedan sugerirlo.

El problema radica más en la ambigüedad del inglés que en el propio idioma Lojban.

Por último, se puede usar lo tanru, como bajra klama (correr-venir), para expresar tanto correr como llegar a un lugar específico.