---
icon: 📕 
title: Kompleta lingvo
---

<pixra url="/assets/pixra/ralju/cll2.webp" caption="La Kompleta Loĵbana Lingvo, la presita eldono de 2016"></pixra>

**CLL neoficiala** (kolektive, *NeCLL*, *EnCLL*) estas projekto organizita de Gleki de regula eksperimenta neoficiala (ne necesare aprobata de la Logika Lingva Grupo) konstruoj de la libro de la Kompleta Loĵbana Lingvo.

*   Sendu vian reagon (rimarkitajn erarojn, proponojn, sugestojn) al unu el la sekvaj lokoj:
    *   [Lojban Reddit grupo](https://www.reddit.com/r/lojban/)
    *   [Lojban Facebook grupo](https://www.facebook.com/groups/lojban)
    *   Vivaj babiladoj: [Telegrama babilejo](https://t.me/lojban) aŭ [Discorda babilejo](https://discord.gg/BVm4EYR)
    *   al <gleki.is.my.name@gmail.com> (Gleki&nbsp;Arxokuna), la prizorganto de la NeCLL.


## Eldonoj

### geklojban-1.2.15 oktobro 2022

#### Kompilita versio
*   legu la finan dokumenton, kiu estu uzata por presado kaj publikigo. Rimarku, ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.15" kaj havas la nomon de la organizo, kiu publikigis ĝin, malsama de la LLG; tio estas farita por emfazi ke ĝi ne estas eldonita de la LLG:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
* aŭ legu la tiel nomitan ["diferenco" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.15 kun la NeCLL, versio 1.2.14 (eldonita en julio 2021). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF dokumento. Estas [alternativa diferencversio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferencan dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

#### Mallonga listo de ŝanĝoj kompare al la antaŭa versio 'geklojban-1.2.14 julio 2021'

* fiksis literumajn erarojn kaj stilkoncernojn en la krestomatio (dankon al koyshi, gleki)
* [problemo #475](https://github.com/lojban/cll/issues/475) **nunkilbra** ŝanĝita al **nunkilca'a** (dankon al up4kid)
* [problemo #466](https://github.com/lojban/cll/issues/466) plibonigis tosmabru testalgoritmon (dankon al vpbroman)
* [problemo #473](https://github.com/lojban/cll/issues/473) "matrica transponado" cmavo nun uzas superskripton T por transpona operacio
* Helvetica tiparoj estas anstataŭigitaj per Comic tiparoj ("Comic" estas nomo de almenaŭ unu fonto kun malferma fontlicenco)
* fiksis aliajn malgrandajn literumajn erarojn (dankon al Matt Nazarian, mattfbacon, la-kanba)
* CSS-ŝanĝoj por plibonigi la funkciadon de la html-versioj sur aparatoj en malluma reĝimo (dankon al NathanHawks)
* la UnCLL nun havas dosierojn de vizualaj diferencoj de la antaŭa eldono kaj aparte por la oficiala eldono.

[fonto de la UnCLL en Git](https://github.com/lojban/cll/compare/geklojban-master)

* [Kompare kun versio 'geklojban-1.2.12 novembro 2020': git-diferenco](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Komparo inter la oficiala CLL v.1.1 eldono (2016) kaj la UnCLL novembro 2020 eldono': git-diferenco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* la ["diferenca" PDF-dokumento](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.15 kun la oficiala CLL v.1.1 eldono (2016). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF-dokumento. Estas [alternativa versio de diferencoj sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la diferencojn).

### geklojban-1.2.14 julio 2021

#### Kunigita versio
*   legu la finalan dokumenton, kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.14" kaj havas la nomon de la organizo, kiu publikigis ĝin malsama de la LLG; tio estas farita por emfazi ke ĝi ne estas eldonita de la LLG:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* aŭ legu la tiel nomatan ["diferenca" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.14 al la UnCLL, versio 1.2.12 (eldonita en novembro 2020). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF dokumento. Estas [alternativa diferencversio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferencan dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la antaŭa versio 'geklojban-1.2.11.1 oktobro 2020'

* estas unu el la gravaj plibonigoj. [Lojbanaj Vortaro](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) ricevis ĉirkaŭ 200 novajn ekzemplojn de frazoj en Lojban kun ilia traduko al la angla. Ĉar la nombro de bazaj vortoj en Lojban estas ĉirkaŭ 2000, tio signifas ke ~10% de tiu tasko estas farita
* korektitaj eraroj kun **bo**, **ke'e** en Ĉapitro 5. 'Skalara neado de selbri'
* korekti malĝustan nomon de unu sona dosiero
* pli da plibonigoj al la indekso: aldonitaj ZEhA kaj pli da BAI
* pli bone klarigi cmevla laŭ la punktsistemo
* aldoni mankantajn punktojn en cmavo kie necesas
* korekti interpunkton en traduko de poemo 'Kubla Khan'


[git fonto de la UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Kompare kun versio 'geklojban-1.2.12 novembro 2020': git diferenco](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Komparo inter la oficiala CLL v.1.1 eldono (2016) kaj la UnCLL novembro 2020 eldono': git diferenco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.13 majo 2021

#### Kompilita versio
*   legu la finalan dokumenton kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.13" kaj havas la nomon de la organizo kiu publikigis ĝin malsama de la LLG; tio estas farita por emfazi ke ĝi ne estas LLG eldono:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* aŭ legu la tiel nomatan ["diferenco" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.13 al la UnCLL, versio 1.2.12 (eldonita en novembro 2020). La dokumento havas enmetojn markitajn per verda kaj "ins\`" prefikso kaj forigojn markitajn per ruĝa kaj "del\`" prefikso. Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF dokumento. Estas [alternativa diferenco versio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferenco dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la antaŭa versio 'geklojban-1.2.11.1 oktobro 2020'

* aldoni novajn belajn ĉapitro bildojn far [la-ninpre](https://github.com/la-ninpre)
* aldoni tradukon de la poemo 'In Xanadu' al la krestomatio
* ripari strangan datitan provon pri setteorio far [simpson](https://github.com/MostAwesomeDude)
* ripari difinon de **toldi** (_papilio_)
* ripari malĝustan aserton kiu subkomprenigis ke fuhivla ne havas rafsi
* plibonigi la klarigon de **le vi tavla ba klama** malpli trompema (riparo far [mezohe](https://github.com/mezohe))
* Matricoj de pli ol du dimensioj povas esti konstruitaj uzante aŭ **pi'a** aŭ **sa'i** kun taŭga subskribo etiketanta la dimensio... Etikedoj povas esti iu ajn afero kiun **xi** subtenas, ekz. **pa** aŭ **mlatu bu**.
* Ĉapitro 5: restaŭri mencion de **bo** grupigado en sekcio pri NAhE, kaj aldoni **bo** al unu ekzemplo (riparo far [mezohe](https://github.com/mezohe))
* Ĉapitro 7: ripari aserton pri **ra'o** en ekzemplo 7.39 (riparo far [mezohe](https://github.com/mezohe))
* Ĉapitro 2: ripari diagramon (predikato -> predikado) (riparo far [mezohe](https://github.com/mezohe))
* aldoni mankantajn punktojn en cmavo
* riparitaj aliaj malgrandaj literumaj eraroj, elementoj de indeksoj, kompilaj skriptoj ktp.

[git fonto de la UnCLL](https://github.com/lojban/cll/compare/geklojban-master)
---
icon: 📕 
title: Complete language
---

<pixra url="/assets/pixra/ralju/cll2.webp" caption="The Complete Lojban Language, the 2016 printed edition"></pixra>

**CLL unofficial** (colloquially, *UnCLL*, *InCLL*) is a project organized by Gleki of regular experimental unofficial (not necessarily approved by the Logical Language Group) builds of the Complete Lojban Language book.

*   Send your feedback (noticed bugs, proposals, suggestions) to one of the following places:
    *   [Lojban Reddit group](https://www.reddit.com/r/lojban/)
    *   [Lojban Facebook group](https://www.facebook.com/groups/lojban)
    *   Live chat: [Telegram chat](https://t.me/lojban) or [Discord chat](https://discord.gg/BVm4EYR)
    *   to <gleki.is.my.name@gmail.com> (Gleki&nbsp;Arxokuna), the maintainer of the UnCLL.


## Releases

### geklojban-1.2.15 October 2022

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.15" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference_prefixed.pdf) that compares geklojban-1.2.15 to the UnCLL, version 1.2.14 (published in July 2021). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.14 July 2021'

* fix mistypes and stylistic problems in the chrestomathy (thanks to koyshi, gleki)
* [issue #475](https://github.com/lojban/cll/issues/475) **nunkilbra** changed to **nunkilca'a** (thanks up4kid)
* [issue #466](https://github.com/lojban/cll/issues/466) improved tosmabru test algorithm (thanks vpbroman)
* [issue #473](https://github.com/lojban/cll/issues/473) "matrix transpose" cmavo now uses superscript T for transposition operator
* Helvetica font mentions are replaced with Comic font mentions ("Comic" is a name of an at least one open-source font) 
* fixed other minor mistypes (thanks Matt Nazarian, mattfbacon, la-kanba)
* CSS changes to make html versions work better on devices in dark mode (thanks to NathanHawks) 
* the UnCLL now has visual difference files from the previous release and separately for the official release.

[git source of the UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Compared with version 'geklojban-1.2.12 November 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparison between the official CLL v.1.1 edition (2016) and the UnCLL November 2020 edition': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* the ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference_prefixed.pdf) that compares geklojban-1.2.15 to the official CLL v.1.1 edition (2016). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).


### geklojban-1.2.14 July 2021

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.14" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.14 to the UnCLL, version 1.2.12 (published in November 2020). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.11.1 October 2020'

* it's one of the major improvements. [Lojban Words Glossary](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) got around 200 new examples of sentences in Lojban with their translation to English. Since the number of core words in Lojban is around 2000 it means ~10% of this task is done
* fixed errors in with **bo**, **ke'e** in Chapter 5. 'Scalar negation of selbri'
* fix an incorrect name of one audio file
* more improvements to the index: added ZEhA and more BAI
* better explain cmevla according to the dotside
* add missing dots in cmavo where necessary
* fix punctuation in 'Kubla Khan' poem translation

[git source of the UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Compared with version 'geklojban-1.2.12 November 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparison between the official CLL v.1.1 edition (2016) and the UnCLL November 2020 edition': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.13 May 2021

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.13" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.13 to the UnCLL, version 1.2.12 (published in November 2020). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.11.1 October 2020'

* add new beautiful chapter pictures by [la-ninpre](https://github.com/la-ninpre)
* add a translation of 'In Xanadu' poem to the chrestomathy
* fix weirdly dated attempt at set theory by [simpson](https://github.com/MostAwesomeDude)
* fix definition of **toldi** (_butterfly_)
* fix incorrect statement that implied fuhivla don't have rafsi
* make the explanation of **le vi tavla ba klama** less misleading (fix implemented by [mezohe](https://github.com/mezohe))
* Matrices of more than two dimensions can be built up using either **pi'a** or **sa'i** with an appropriate subscript labeling the dimension... Labels can be any anything that **xi** supports, e.g. **pa** or **mlatu bu**.
* Chapter 5: restore mention of **bo** grouping in section on NAhE, and add **bo** to one example (fix implemented by [mezohe](https://github.com/mezohe))
* Chapter 7: fix statement about **ra'o** in example 7.39 (fix implemented by [mezohe](https://github.com/mezohe))
* Chapter 2: fix diagram (predicate -> predication) (fix implemented by [mezohe](https://github.com/mezohe))
* add missing dots in cmavo
* fixed other minor mistypes, elements of indices, compilation scripts etc.

[git source of the UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Compared with version 'geklojban-1.2.12 November 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Comparison between the official CLL v.1.1 edition (2016) and the UnCLL November 2020 edition': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.12 November 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.12" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.12 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.11.1 October 2020'

* Added standard pronunciation of {u} in IPA chapter (by [Vexatos](https://github.com/Vexatos))
* Subscript symbols in glosses are treated appropriately (bug noticed by [gr-g](https://github.com/gr-g))
* Fixed a grammatical error in Example 17.36 (bug noticed by [kotwys](https://github.com/kotwys))
* The particle **ri'u** was missing from Section 10.28 (as noticed by [gr-g](https://github.com/gr-g)). Added
* In Example 7.12 the first place of **lafti** is applied to a person. The predicate change to **lafmuvgau** (which is in the notes of the definition of **lafti**)
* In English text change .) to ). where necessary
* Display square root, infinity and golden ration phi with actual symbols
* Fix incorrect translation of **levi rozgu cu sofi'upanova'e xunre**
* other minor fixes

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.12)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.11.1 October 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.12)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.12)


### geklojban-1.2.11.1 October 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.11" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.11 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.10 August 2020'

* Audio links (audio by la tcakoi, la .lindar., la .aionys.) are added to "splits by sections" and "split by chapters" HTML versions of the book
* fix several mistypes
* add hanzi characters to one Chinese example
* 1.2.11.1 hotfix release: make audio buttons in HTML pages actually work

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.11)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.10 August 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.11)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)

### geklojban-1.2.10 August 2020

#### Compiled version---
icon: 📕 
title: Complete language
---

<pixra url="/assets/pixra/ralju/cll2.webp" caption="The Complete Lojban Language, the 2016 printed edition"></pixra>

**CLL unofficial** (colloquially, *UnCLL*, *InCLL*) is a project organized by Gleki of regular experimental unofficial (not necessarily approved by the Logical Language Group) builds of the Complete Lojban Language book.

*   Send your feedback (noticed bugs, proposals, suggestions) to one of the following places:
    *   [Lojban Reddit group](https://www.reddit.com/r/lojban/)
    *   [Lojban Facebook group](https://www.facebook.com/groups/lojban)
    *   Live chat: [Telegram chat](https://t.me/lojban) or [Discord chat](https://discord.gg/BVm4EYR)
    *   to <gleki.is.my.name@gmail.com> (Gleki&nbsp;Arxokuna), the maintainer of the UnCLL.


## Releases

### geklojban-1.2.15 October 2022

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.15" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference_prefixed.pdf) that compares geklojban-1.2.15 to the UnCLL, version 1.2.14 (published in July 2021). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.14 July 2021'

* fix mistypes and stylistic problems in the chrestomathy (thanks to koyshi, gleki)
* [issue #475](https://github.com/lojban/cll/issues/475) **nunkilbra** changed to **nunkilca'a** (thanks up4kid)
* [issue #466](https://github.com/lojban/cll/issues/466) improved tosmabru test algorithm (thanks vpbroman)
* [issue #473](https://github.com/lojban/cll/issues/473) "matrix transpose" cmavo now uses superscript T for transposition operator
* Helvetica font mentions are replaced with Comic font mentions ("Comic" is a name of an at least one open-source font) 
* fixed other minor mistypes (thanks Matt Nazarian, mattfbacon, la-kanba)
* CSS changes to make html versions work better on devices in dark mode (thanks to NathanHawks) 
* the UnCLL now has visual difference files from the previous release and separately for the official release.

[git source of the UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Compared with version 'geklojban-1.2.12 November 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparison between the official CLL v.1.1 edition (2016) and the UnCLL November 2020 edition': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* the ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference_prefixed.pdf) that compares geklojban-1.2.15 to the official CLL v.1.1 edition (2016). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).


### geklojban-1.2.14 July 2021

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.14" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.14 to the UnCLL, version 1.2.12 (published in November 2020). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.11.1 October 2020'

* it's one of the major improvements. [Lojban Words Glossary](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) got around 200 new examples of sentences in Lojban with their translation to English. Since the number of core words in Lojban is around 2000 it means ~10% of this task is done
* fixed errors in with **bo**, **ke'e** in Chapter 5. 'Scalar negation of selbri'
* fix an incorrect name of one audio file
* more improvements to the index: added ZEhA and more BAI
* better explain cmevla according to the dotside
* add missing dots in cmavo where necessary
* fix punctuation in 'Kubla Khan' poem translation

[git source of the UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Compared with version 'geklojban-1.2.12 November 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparison between the official CLL v.1.1 edition (2016) and the UnCLL November 2020 edition': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.13 May 2021

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.13" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.13 to the UnCLL, version 1.2.12 (published in November 2020). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.11.1 October 2020'

* add new beautiful chapter pictures by [la-ninpre](https://github.com/la-ninpre)
* add a translation of 'In Xanadu' poem to the chrestomathy
* fix weirdly dated attempt at set theory by [simpson](https://github.com/MostAwesomeDude)
* fix definition of **toldi** (_butterfly_)
* fix incorrect statement that implied fuhivla don't have rafsi
* make the explanation of **le vi tavla ba klama** less misleading (fix implemented by [mezohe](https://github.com/mezohe))
* Matrices of more than two dimensions can be built up using either **pi'a** or **sa'i** with an appropriate subscript labeling the dimension... Labels can be any anything that **xi** supports, e.g. **pa** or **mlatu bu**.
* Chapter 5: restore mention of **bo** grouping in section on NAhE, and add **bo** to one example (fix implemented by [mezohe](https://github.com/mezohe))
* Chapter 7: fix statement about **ra'o** in example 7.39 (fix implemented by [mezohe](https://github.com/mezohe))
* Chapter 2: fix diagram (predicate -> predication) (fix implemented by [mezohe](https://github.com/mezohe))
* add missing dots in cmavo
* fixed other minor mistypes, elements of indices, compilation scripts etc.

[git source of the UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Compared with version 'geklojban-1.2.12 November 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Comparison between the official CLL v.1.1 edition (2016) and the UnCLL November 2020 edition': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.12 November 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.12" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.12 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.11.1 October 2020'

* Added standard pronunciation of {u} in IPA chapter (by [Vexatos](https://github.com/Vexatos))
* Subscript symbols in glosses are treated appropriately (bug noticed by [gr-g](https://github.com/gr-g))
* Fixed a grammatical error in Example 17.36 (bug noticed by [kotwys](https://github.com/kotwys))
* The particle **ri'u** was missing from Section 10.28 (as noticed by [gr-g](https://github.com/gr-g)). Added
* In Example 7.12 the first place of **lafti** is applied to a person. The predicate change to **lafmuvgau** (which is in the notes of the definition of **lafti**)
* In English text change .) to ). where necessary
* Display square root, infinity and golden ration phi with actual symbols
* Fix incorrect translation of **levi rozgu cu sofi'upanova'e xunre**
* other minor fixes

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.12)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.11.1 October 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.12)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.12)


### geklojban-1.2.11.1 October 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.11" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.11 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.10 August 2020'

* Audio links (audio by la tcakoi, la .lindar., la .aionys.) are added to "splits by sections" and "split by chapters" HTML versions of the book
* fix several mistypes
* add hanzi characters to one Chinese example
* 1.2.11.1 hotfix release: make audio buttons in HTML pages actually work

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.11)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.10 August 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.11)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)

### geklojban-1.2.10 August 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.10" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.10 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.9 July 2020'

* Chrestomathy (selected texts) volume added after the last chapter
* dots are never omitted in words, not even in Lojban Words Index

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.10)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.9 July 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.10)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)


### geklojban-1.2.9 July 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.9" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.9 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.8.1 June 2020'

* HTML version now has tables and examples horizontally scrollable on narrow (e.g. mobile devices') screens. This makes the HTML version more mobile-friendly
* EPUB is generated again (was missing from version  1.2.8.1)
* Korean and Chinese symbols are now displayed using Noto CJK font
* places like "$x_1$" are now displayed with numbers subscripted
* An example in Section 16.9 {naku zo'u la djan. klama} didn't correspond to other examples around it so it was replaced with {naku zo'u mi klama le zarci} (a bug noticed by [Corbin Simpson](https://github.com/MostAwesomeDude))
* a definition of the word {bu'u} is added to the list of other grammatical partices of class FAhA

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.9)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.8.1 June 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.9)

### geklojban-1.2.8.1 June 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.8.1" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.8.1 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.7 May 2020'

* A new "diacritic" orthography named "zbalermorna" added. It's clearly mentioned as unofficial. Its symbols ("letters") are displayed with an appropriate font. Kudos to [Jack Humbert](https://jackhumbert.github.io/zbalermorna/) and their team (la saski'o, la xaspeljba and others) for the font and the revision of the explanation of the orthography.
* The indices have been revised (almost all of their 4000 entries). Numerous entries have been modified for the ease of use or moved from Lojban Words Index to General Index or vice versa.
* the rule for usage of the comma is [reverted](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) back to the version from the CLL 1.1 
* a better diff algorithm for viewing differences between versions (without extra clutter)
* version 1.2.8.1 hotfix release: fixed problems with zbalermorna symbols display in the PDF document

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.7 May 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)

### geklojban-1.2.7 May 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.7" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.7 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.6 April 2020'

* "The cmavo tu'a is used in forming abstractions, and is explained more fully in Section 11.11." but it isn't mentioned at all in that section. Changed the reference to Section 11.10. The bug is noticed by [Robert Baruch](https://github.com/RobertBaruch).
* all the references to selma'o are moved from lojban words index to general index in the appendix.
* Section 10.18. The phrase "Unlike -nai contradictory negation, scalar negation of tenses is not limited to PU and FAhA:" contradicted the following text of the section. Replaced with "An example of scalar negation of FAhA:"

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.7)
#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.6 April 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)

### geklojban-1.2.6 April 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.6" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.6 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.5 March 2020'

* new slick hi-res pictures for several chapters made by [la ninpre](https://github.com/la-ninpre) (possible copyright violation rejected)
* the rule 'commas are never required' is now temporarily limited to commas that are syllable separators
* added more links to various selma'o to lojban-word index

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.6)
#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.5 March 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.5...geklojban-1.2.6)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.6)

### geklojban-1.2.5 March 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.5" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.5 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the version 'geklojban-1.2.3 January 2020'
* temporarily remove controversial use of ni+ce'u
* use a better example for NU JA NU, remove expansion of NU JA NU (which may not be unambiguous in case of several NU JA NU in one bridi)
* add hanzi and prettier pinyin to Chinese examples
* Dotside: Adding an initial glottal stop to the IPA transcription in one example
* add "FA selma'o" to lojban-word index
* the rule 'commas are never required' is temporarily limited to cmevla only
* a few mistypes are fixed
* UTF symbols are added as they are (instead of their descriptions)
*   Dotside implemented
*   "cmene" and "cmevla" concepts are now separated
*   **sumti tcita** is renamed to **sumtcita**
*   **mi kucli le jei broda** is now **mi kucli tu'a le jei broda**
*   Dictionary with examples is now technically possible: the glossary can now have examples below definitions of words (and does so for the word **coi** as a showcase)
*   rafsi for **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** are changed according to the cmavo.txt from year 2002.
*   immense amount of mistypes and minor errors fixed

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.5)
#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.4 February 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)


### geklojban-1.2.4 February 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.4" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.4 to CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the version 'geklojban-1.2.3 January 2020'
* a few mistypes are fixed
* UTF symbols are added as they are (instead of their descriptions)

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.4)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)

### geklojban-1.2.3 January 2020

#### Short list of changes

*   Dotside implemented
*   "cmene" and "cmevla" concepts are now separated
*   **sumti tcita** is renamed to **sumtcita**
*   **mi kucli le jei broda** is now **mi kucli tu'a le jei broda**
*   Dictionary with examples is now technically possible: the glossary can now have examples below definitions of words (and does so for the word **coi** as a showcase)
*   rafsi for **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** are changed according to the cmavo.txt from year 2002.
*   immense amount of mistypes and minor errors fixed

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.3)

*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.10" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.10 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.9 July 2020'

* Chrestomathy (selected texts) volume added after the last chapter
* dots are never omitted in words, not even in Lojban Words Index

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.10)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.9 July 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.10)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)


### geklojban-1.2.9 July 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.9" and has the name of the organization published it different from the LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.9 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.8.1 June 2020'

* HTML version now has tables and examples horizontally scrollable on narrow (e.g. mobile devices') screens. This makes the HTML version more mobile-friendly
* EPUB is generated again (was missing from version  1.2.8.1)
* Korean and Chinese symbols are now displayed using Noto CJK font
* places like "$x_1$" are now displayed with numbers subscripted
* An example in Section 16.9 {naku zo'u la djan. klama} didn't correspond to other examples around it so it was replaced with {naku zo'u mi klama le zarci} (a bug noticed by [Corbin Simpson](https://github.com/MostAwesomeDude))
* a definition of the word {bu'u} is added to the list of other grammatical partices of class FAhA

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.9)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.8.1 June 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.9)

### geklojban-1.2.8.1 June 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.8.1" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.8.1 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.7 May 2020'

* A new "diacritic" orthography named "zbalermorna" added. It's clearly mentioned as unofficial. Its symbols ("letters") are displayed with an appropriate font. Kudos to [Jack Humbert](https://jackhumbert.github.io/zbalermorna/) and their team (la saski'o, la xaspeljba and others) for the font and the revision of the explanation of the orthography.
* The indices have been revised (almost all of their 4000 entries). Numerous entries have been modified for the ease of use or moved from Lojban Words Index to General Index or vice versa.
* the rule for usage of the comma is [reverted](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) back to the version from the CLL 1.1 
* a better diff algorithm for viewing differences between versions (without extra clutter)
* version 1.2.8.1 hotfix release: fixed problems with zbalermorna symbols display in the PDF document

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.7 May 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)

### geklojban-1.2.7 May 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.7" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.7 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.6 April 2020'

* "The cmavo tu'a is used in forming abstractions, and is explained more fully in Section 11.11." but it isn't mentioned at all in that section. Changed the reference to Section 11.10. The bug is noticed by [Robert Baruch](https://github.com/RobertBaruch).
* all the references to selma'o are moved from lojban words index to general index in the appendix.
* Section 10.18. The phrase "Unlike -nai contradictory negation, scalar negation of tenses is not limited to PU and FAhA:" contradicted the following text of the section. Replaced with "An example of scalar negation of FAhA:"

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.7)
#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.6 April 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)

### geklojban-1.2.6 April 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.6" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.6 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the previous version 'geklojban-1.2.5 March 2020'

* new slick hi-res pictures for several chapters made by [la ninpre](https://github.com/la-ninpre) (possible copyright violation rejected)
* the rule 'commas are never required' is now temporarily limited to commas that are syllable separators
* added more links to various selma'o to lojban-word index

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.6)
#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.5 March 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.5...geklojban-1.2.6)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.6)

### geklojban-1.2.5 March 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.5" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.5 to the CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the version 'geklojban-1.2.3 January 2020'
* temporarily remove controversial use of ni+ce'u
* use a better example for NU JA NU, remove expansion of NU JA NU (which may not be unambiguous in case of several NU JA NU in one bridi)
* add hanzi and prettier pinyin to Chinese examples
* Dotside: Adding an initial glottal stop to the IPA transcription in one example
* add "FA selma'o" to lojban-word index
* the rule 'commas are never required' is temporarily limited to cmevla only
* a few mistypes are fixed
* UTF symbols are added as they are (instead of their descriptions)
*   Dotside implemented
*   "cmene" and "cmevla" concepts are now separated
*   **sumti tcita** is renamed to **sumtcita**
*   **mi kucli le jei broda** is now **mi kucli tu'a le jei broda**
*   Dictionary with examples is now technically possible: the glossary can now have examples below definitions of words (and does so for the word **coi** as a showcase)
*   rafsi for **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** are changed according to the cmavo.txt from year 2002.
*   immense amount of mistypes and minor errors fixed

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.5)
#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.4 February 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)


### geklojban-1.2.4 February 2020

#### Compiled version
*   read the final document that is to be used for printing and publication. Notice that the title page has the document explicitly marked as "geklojban-1.2.4" and has the name of the organization published it different from LLG; this is done to emphasize that it's not an LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    *   [HTML format, one page is one section of the book](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    *   [HTML format - the whole book in one very long page](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* or read the so called ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference_prefixed.pdf) that compares geklojban-1.2.4 to CLL published in 2016 (2016-08-27 release). The document has insertions marked with green and "ins\`" prefix and deletions marked with red and "del\`" prefix. Prefixes are added so that you can use Cmd+F or Ctrl+F to quickly find the differences in the PDF document. There is [an alternative difference version without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (but then you'll have to manually scroll the document to find the differences).
*   or read the difference document in HTML format instead:
    *   [with prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [without prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Short list of changes compared to the version 'geklojban-1.2.3 January 2020'
* a few mistypes are fixed
* UTF symbols are added as they are (instead of their descriptions)

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.4)

#### Source code comparison with previous versions
* [Compared with version 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Compared with the official CLL v.1.1 edition (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)

### geklojban-1.2.3 January 2020

#### Short list of changes

*   Dotside implemented
*   "cmene" and "cmevla" concepts are now separated
*   **sumti tcita** is renamed to **sumtcita**
*   **mi kucli le jei broda** is now **mi kucli tu'a le jei broda**
*   Dictionary with examples is now technically possible: the glossary can now have examples below definitions of words (and does so for the word **coi** as a showcase)
*   rafsi for **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** are changed according to the cmavo.txt from year 2002.
*   immense amount of mistypes and minor errors fixed

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.3)

* [Komparite kun versio 'geklojban-1.2.12 novembro 2020': git diferenco](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Komparo inter la oficiala CLL v.1.1 eldono (2016) kaj la UnCLL novembro 2020 eldono': git diferenco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.12 novembro 2020

#### Kompilita versio
*   legi la finalan dokumenton kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.12" kaj havas la nomon de la organizo kiu publikigis ĝin malsama de la LLG; tio estas farita por emfazi ke ĝi ne estas LLG publikigo:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* aŭ legi la tiel nomatan ["diferenca" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.12 kun la CLL publikita en 2016 (2016-08-27 eldono). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF dokumento. Estas [alternativa diferencversio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (sed tiam vi devos mem skroligi la dokumenton por trovi la diferencojn).
*   aŭ legi la diferencan dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la antaŭa versio 'geklojban-1.2.11.1 oktobro 2020'

* Aldonis standardan prononcon de {u} en la IPA ĉapitro (far [Vexatos](https://github.com/Vexatos))
* Subskribaj simboloj en glatoj estas traktataj konvene (eraro rimarkita de [gr-g](https://github.com/gr-g))
* Riparis gramatikan eraron en Ekzemplo 17.36 (eraro rimarkita de [kotwys](https://github.com/kotwys))
* La partiklo **ri'u** mankis el Sekcio 10.28 (kiel rimarkis [gr-g](https://github.com/gr-g)). Aldita
* En Ekzemplo 7.12 la unua loko de **lafti** estas aplikita al persono. La predikato ŝanĝiĝas al **lafmuvgau** (kiu estas en la notoj de la difino de **lafti**)
* En la angla teksto ŝanĝu .) al ). kiam necesas
* Montru kvadratan radikon, senfinon kaj oran proporcian fi kun efektivaj simboloj
* Riparu la malĝustan tradukon de **levi rozgu cu sofi'upanova'e xunre**
* aliaj malgrandaj riparoj

#### [fonto de git](https://github.com/lojban/cll/compare/geklojban-1.2.12)

#### Komparo de fonta kodo kun antaŭaj versioj
* [Komparite kun versio 'geklojban-1.2.11.1 oktobro 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Komparite kun versio 'geklojban-1.2.3 januaro 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.12)
* [Komparite kun oficiala CLL v.1.1 eldono (2016)': git malsameco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.12)


### geklojban-1.2.11.1 oktobro 2020

#### Kompilita versio
*   legu la finan dokumenton kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.11" kaj havas la nomon de la organizo kiu publikigis ĝin malsama de la LLG; tio estas farita por emfazi ke ĝi ne estas LLG publikigo:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* aŭ legu la tiel nomatan ["diferenca" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.11 kun la CLL publikigita en 2016 (eldono de 2016-08-27). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF dokumento. Estas [alternativa diferenca versio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferenca dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la antaŭa versio 'geklojban-1.2.10 Aŭgusto 2020'

* Sonaj ligiloj (sonaĵo de la tcakoi, la .lindar., la .aionys.) estas aldonitaj al "dividitaj laŭ sekcioj" kaj "dividitaj laŭ ĉapitroj" HTML-versioj de la libro
* ripari plurajn literumajn erarojn
* aldoni hanzi signojn al unu ĉina ekzemplo
* 1.2.11.1 riparversio: fari la sonajn butonojn en la HTML-paĝoj efektive funkciantaj

#### [git fonto](https://github.com/lojban/cll/compare/geklojban-1.2.11)

#### Komparo de fonta kodo kun antaŭaj versioj
* [Komparita kun versio 'geklojban-1.2.10 Aŭgusto 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [Komparita kun versio 'geklojban-1.2.3 Januaro 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.11)
* [Komparita kun oficiala CLL v.1.1 eldono (2016)': git malsameco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)

### geklojban-1.2.10 Aŭgusto 2020

#### Kompilita versio
*   legu la finan dokumenton, kiu estos uzata por presado kaj publikigo. Rimarku, ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.10" kaj havas la nomon de la organizo, kiu publikigis ĝin, malsama de la LLG; tio estas farita por emfazi ke ĝi ne estas LLG-publikigo:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* aŭ legu la tiel nomitan ["malsameco" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.10 kun la CLL publikita en 2016 (eldonita la 2016-08-27). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la malsamecojn en la PDF-dokumento. Estas [alternativa malsameca versio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la malsamecojn).
*   aŭ legu la malsameca dokumento en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la antaŭa versio 'geklojban-1.2.9 julio 2020'

* Krestomatio (elektitaj tekstoj) volumo aldonita post la lasta ĉapitro
* punktoj neniam estas forlasitaj en vortoj, eĉ ne en la Lojbanaj Vortaro

#### [fonto de git](https://github.com/lojban/cll/compare/geklojban-1.2.10)

#### Komparo de fonta kodo kun antaŭaj versioj
* [Komparite kun versio 'geklojban-1.2.9 julio 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Komparite kun versio 'geklojban-1.2.3 januaro 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.10)
* [Komparite kun oficiala CLL v.1.1 eldono (2016)': git malsameco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)


### geklojban-1.2.9 julio 2020

#### Kompilita versio
*   legu la finalan dokumenton, kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.9" kaj havas la nomon de la organizo, kiu publikigis ĝin, malsama de la LLG; tio estas farita por emfazi ke ĝi ne estas eldono de la LLG:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    *   [EPUB formato](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* aŭ legu la tiel nomatan ["diferenco" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.9 kun la CLL publikigita en 2016 (eldonita la 27-an de aŭgusto 2016). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF dokumento. Estas [alternativa diferencversio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferencan dokumenton anstataŭe en HTML formato:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la antaŭa versio 'geklojban-1.2.8.1 junio 2020'

* La HTML-versio nun havas tabelojn kaj ekzemplojn horizontale ruligeblaj sur mallarĝaj (ekz., poŝtelefonoj') ekranoj. Tio igas la HTML-version pli amikebla al movaj aparatoj
* EPUB estas denove generita (mankis en versio 1.2.8.1)
* La korea kaj ĉina simboloj nun estas montrataj uzante la tiparo Noto CJK
* lokoj kiel "$x_1$" nun estas montrataj kun nombroj subskribitaj
* Ekzemplo en Sekcio 16.9 {naku zo'u la djan. klama} ne kongruis kun aliaj ekzemploj ĉirkaŭe, do ĝi estis anstataŭigita per {naku zo'u mi klama le zarci} (eraro rimarkita de [Corbin Simpson](https://github.com/MostAwesomeDude))
* difino de la vorto {bu'u} estas aldonita al la listo de aliaj gramatikaj partikloj de klaso FAhA

#### [fonto de git](https://github.com/lojban/cll/compare/geklojban-1.2.9)

#### Komparo de fonta kodo kun antaŭaj versioj
* [Komparita kun versio 'geklojban-1.2.8.1 junio 2020': diferenca git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Komparita kun versio 'geklojban-1.2.3 januaro 2020': diferenca git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Komparita kun oficiala CLL v.1.1 eldono (2016)': diferenca git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.9)

### geklojban-1.2.8.1 junio 2020

#### Kompilita versio
*   legu la finan dokumenton kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.8.1" kaj havas la nomon de la organizo kiu publikigis ĝin malsama de LLG; tio estas farita por emfazi ke ĝi ne estas LLG-publikigo:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* aŭ legu la tiel nomitan ["diferenca" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.8.1 kun la CLL publikigita en 2016 (eldono de 2016-08-27). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF-dokumento. Estas [alternativa diferenca versio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (sed tiam vi devos manĝe rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferenca dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj kompare al la antaŭa versio 'geklojban-1.2.7 Majo 2020'

* Nova "diakrita" ortografio nomita "zbalermorna" aldonita. Klare estas menciita kiel neoficiala. Ĝiaj simboloj ("literoj") estas montritaj per taŭga tiparo. Aplaŭdoj al [Jack Humbert](https://jackhumbert.github.io/zbalermorna/) kaj ilia teamo (la saski'o, la xaspeljba kaj aliaj) por la tiparo kaj la revizio de la klarigo de la ortografio.
* La indeksoj estis reviziitaj (preskaŭ ĉiuj el siaj 4000 eniroj). Multaj eniroj estis modifitaj por pli facila uzo aŭ movitaj de la Indekso de Lojbanaj Vortoj al la Ĝenerala Indekso aŭ inverse.
* la regulo por la uzo de la komo estas [revertita](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) reen al la versio de la CLL 1.1
* pli bona algoritmo por vidi diferencon inter versioj (sen ekstra malordo)
* versio 1.2.8.1 riparanta eldono: riparitaj problemoj kun la montrado de zbalermorna simboloj en la PDF-dokumento

#### [fonto de git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)

#### Komparo de fonta kodo kun antaŭaj versioj
* [Kompare kun versio 'geklojban-1.2.7 Majo 2020': git diferenco](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Kompare kun versio 'geklojban-1.2.3 Januaro 2020': git diferenco](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Kompare kun la oficiala eldono de CLL v.1.1 (2016)': git diferenco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)

### geklojban-1.2.7 Majo 2020

#### Kompilita versio
*   legu la finan dokumenton kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.7" kaj havas la nomon de la organizo kiu publikigis ĝin malsama de LLG; tio estas farita por emfazi ke ĝi ne estas eldono de LLG:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    *   [EPUB formato](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* aŭ legu la tiel nomatan ["diferenca" PDF-dokumento](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.7 kun la CLL publikigita en 2016 (eldonita la 27-an de aŭgusto 2016). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF-dokumento. Estas [alternativa diferencversio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (sed tiam vi devos mem skroligi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferencan dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la antaŭa versio 'geklojban-1.2.6 April 2020'

* "La cmavo tu'a estas uzata por formi abstrakciojn, kaj estas pli detale klarigita en Sekcio 11.11." sed ĝi ne estas menciita tute en tiu sekcio. Ŝanĝis la referencon al Sekcio 11.10. La eraro estas rimarkita de [Robert Baruch](https://github.com/RobertBaruch).
* ĉiuj referencoj al selma'o estas movitaj de la indekso de lojban-vortoj al la ĝenerala indekso en la apendico.
* Sekcio 10.18. La frazo "Kontraŭe al -nai kontraŭdira neado, skalaro neado de tempoj ne estas limigita al PU kaj FAhA:" kontraŭdiris la sekvantan tekston de la sekcio. Anstataŭigita per "Ekzemplo de skalaro neado de FAhA:"

#### [fonto de git](https://github.com/lojban/cll/compare/geklojban-1.2.7)
#### Komparo de fonta kodo kun antaŭaj versioj
* [Komparite kun versio 'geklojban-1.2.6 April 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Komparite kun versio 'geklojban-1.2.3 January 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Komparite kun oficiala CLL v.1.1 eldono (2016)': git malsameco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)

### geklojban-1.2.6 April 2020

#### Kompilita versio
*   legu la finan dokumenton kiu estos uzata por presado kaj publikigo. Rimarku ke la titolpaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.6" kaj havas la nomon de la organizo kiu publikigis ĝin malsama de LLG; tio estas farita por emfazi ke ĝi ne estas LLG publikigo:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [EPUB formato](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* aŭ legu la tiel nomatan ["diferenco" PDF dokumenton](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.6 kun la CLL publikigita en 2016 (eldono de 2016-08-27). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF dokumento. Estas [alternativa diferenco versio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferencan dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la antaŭa versio 'geklojban-1.2.5 marto 2020'

* novaj belaj alta-kvalitaj bildoj por pluraj ĉapitroj faritaj de [la ninpre](https://github.com/la-ninpre) (eblea kopirajt-violado rifuzita)
* la regulo 'komoj neniam estas postulataj' nun tempore limigita al komoj kiuj estas silabaj apartigiloj
* aldonitaj pli da ligiloj al diversaj selma'o al lojban-vortindekso

#### [fontkodo de git](https://github.com/lojban/cll/compare/geklojban-1.2.6)
#### Komparo de fontkodo kun antaŭaj versioj
* [Komparita kun versio 'geklojban-1.2.5 marto 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.5...geklojban-1.2.6)
* [Komparita kun versio 'geklojban-1.2.3 januaro 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.6)

### geklojban-1.2.5 marto 2020

#### Kompilita versio
*   legu la finan dokumenton kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.5" kaj havas la nomon de la organizo kiu publikigis ĝin malsama de LLG; tio estas farita por emfazi ke ĝi ne estas eldonita de LLG:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    *   [EPUB formato](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* aŭ legu la tiel nomatan ["diferenca" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.5 kun la CLL publikigita en 2016 (eldonita la 27-an de aŭgusto 2016). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF dokumento. Estas [alternativa diferencversio sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (sed tiam vi devos manĝe rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferencan dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Mallonga listo de ŝanĝoj komparitaj kun la versio 'geklojban-1.2.3 januaro 2020'
* tempore forigi la disputindan uzon de ni+ce'u
* uzi pli bonan ekzemplon por NU JA NU, forigi la etendon de NU JA NU (kio eble ne estas unuforma en kazo de pluraj NU JA NU en unu bridi)
* aldoni hanzi kaj pli belan pinyin al ĉinaj ekzemploj
* Dotside: Aldoni komencajn glotajn haltojn al la IPA transskribo en unu ekzemplo
* aldoni "FA selma'o" al la loĵbana-vortindekso
* la regulo 'komataj signoj neniam estas postulataj' estas tempore limigita nur al cmevla
* kelkaj literumaj eraroj estas korektitaj
* UTF-simboloj estas aldonitaj kiel ili estas (anstataŭ iliaj priskriboj)
*   Dotside implementita
*   la konceptoj "cmene" kaj "cmevla" estas nun apartigitaj
*   **sumti tcita** estas renomita al **sumtcita**
*   **mi kucli le jei broda** estas nun **mi kucli tu'a le jei broda**
*   Vortaro kun ekzemploj estas nun teknike ebla: la glosaro nun povas havi ekzemplojn sub difinoj de vortoj (kaj tiel faras por la vorto **coi** kiel ekspozicio)
*   rafsi por **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** estas ŝanĝitaj laŭ la cmavo.txt de la jaro 2002.
*   granda kvanto da literumaj eraroj kaj malgrandaj eraroj estas korektitaj

#### [fonto de git](https://github.com/lojban/cll/compare/geklojban-1.2.5)
#### Komparo de fonta kodo kun antaŭaj versioj
* [Komparita kun versio 'geklojban-1.2.4 februaro 2020': git diferenco](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Komparita kun versio 'geklojban-1.2.3 januaro 2020': git diferenco](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)


### geklojban-1.2.4 februaro 2020

#### Kompilita versio
*   legu la finalan dokumenton kiu estos uzata por presado kaj publikigo. Rimarku ke la titolopaĝo havas la dokumenton eksplicite markita kiel "geklojban-1.2.4" kaj havas la nomon de la organizo kiu publikigis ĝin malsama de LLG; tio estas farita por emfazi ke ĝi ne estas eldonita de LLG:
    *   [PDF formato](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    *   [EPUB formato](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    *   [HTML formato, unu paĝo estas unu sekcio de la libro](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    *   [HTML formato - la tuta libro en unu tre longa paĝo](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* aŭ legu la tiel nomatan ["diferenca" PDF dokumento](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference_prefixed.pdf) kiu komparas geklojban-1.2.4 kun CLL publikita en 2016 (eldonita la 27-an de aŭgusto 2016). La dokumento havas enmetojn markitajn per verda kaj prefikso "ins\`" kaj forigojn markitajn per ruĝa kaj prefikso "del\`". Prefiksoj estas aldonitaj por ke vi povu uzi Cmd+F aŭ Ctrl+F por rapide trovi la diferencojn en la PDF-dokumento. Estas [alternativa versio de diferenco sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (sed tiam vi devos mane rulumi la dokumenton por trovi la diferencojn).
*   aŭ legu la diferencan dokumenton en HTML formato anstataŭe:
    *   [kun prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sen prefiksoj](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

### Mallonga listo de ŝanĝoj kompare al versio 'geklojban-1.2.3 januaro 2020'
* kelkaj litereraroj estas korektitaj
* UTF-simboloj estas aldonitaj kiel ili estas (anstataŭ iliaj priskriboj)

#### [fontokodo de git](https://github.com/lojban/cll/compare/geklojban-1.2.4)

#### Komparo de fontokodo kun antaŭaj versioj
* [Kompare kun versio 'geklojban-1.2.3 januaro 2020': git malsameco](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Kompare kun oficiala CLL v.1.1 eldono (2016)': git malsameco](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)

### geklojban-1.2.3 januaro 2020

#### Mallonga listo de ŝanĝoj

*   Dotside estas implementita
*   Konceptoj "cmene" kaj "cmevla" estas nun apartigitaj
*   **sumti tcita** estas renomita al **sumtcita**
*   **mi kucli le jei broda** estas nun **mi kucli tu'a le jei broda**
*   Vortaro kun ekzemploj estas nun teknike ebla: la glosaro nun povas havi ekzemplojn sub difinoj de vortoj (kaj tiel faras por la vorto **coi** kiel ekzemplo)
*   rafsi por **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** estas ŝanĝitaj laŭ la cmavo.txt de la jaro 2002.
*   granda kvanto de litereraroj kaj malgrandaj eraroj estas korektitaj

#### [fontokodo de git](https://github.com/lojban/cll/compare/geklojban-1.2.3)
