---
"title": "Gua\\spi Vocabulary"
---

# Gua\spi Vocabulary

<table>
    <thead>
        <tr>
            <th>Word</th>
            <th>Class</th>
            <th>Engl</th>
            <th>Phon</th>
            <th>Definition</th>
            <th>Comments</th>
            <th>Xref</th>
            <th>Notes</th>
        </tr>
    </thead>
    <tbody>

            <tr>
                <td data-label="Word">0</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Structure Words</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.0.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">10</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Morphology, Cases and Organization</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">11</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Grammar and Transformations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fa</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">cancel, that~is</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">The previous phrase at the same level as -fa is removed and replaced by what follows</td>
                <td data-label="Comments">Not for explanatory that~is, for which use |va.</td>
                <td data-label="Xref">-</td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: -</td>
            </tr>

            <tr>
                <td data-label="Word">fe</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">and, or, conjunction</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1= and following arguments conjoin</td>
                <td data-label="Comments">As in the Cartesian expansion of a single argument.  Use -tla or -stl to make a set.</td>
                <td data-label="Xref">fy, tla, stl</td>
                <td data-label="Notes">Rank: 30<br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: .e</td>
            </tr>

            <tr>
                <td data-label="Word">fi</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">upjump</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Grammatical level one to three</td>
                <td data-label="Comments">/fi gives 1, ^fi gives 2, !fi gives 3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 43<br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fl</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">begin</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Beginning of group</td>
                <td data-label="Comments">Not supported in present grammar.</td>
                <td data-label="Xref">-</td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: -</td>
            </tr>

            <tr>
                <td data-label="Word">fn</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">foreign, metaphor</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Event (vo) X1+ is represented by metaphor X2?</td>
                <td data-label="Comments">X2 is a sequence of foreign syllables to end of compounding tone.  -fn with X2 make a subordinate clause.</td>
                <td data-label="Xref">qo, fw</td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.1, 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fo</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">foreign</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is in the referent set of a foreign word</td>
                <td data-label="Comments">The word follows to end of compound tone.</td>
                <td data-label="Xref">qo</td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">end</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">End of group</td>
                <td data-label="Comments">Not supported in present grammar.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">jump</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Jump two to four grammatical levels up</td>
                <td data-label="Comments">!fu gives 2 up, ^fu gives 3 up, /fu gives 4 up.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: gu</td>
            </tr>

            <tr>
                <td data-label="Word">fy</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">and</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Retroactive downjump: previous argument at same level as fy goes down one level and becomes the first case of the following predicate</td>
                <td data-label="Comments">Often used with -tla and -stl for afterthought group arguments.</td>
                <td data-label="Xref">fe, tla, stl</td>
                <td data-label="Notes">Rank: 13<br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: .e</td>
            </tr>

            <tr>
                <td data-label="Word">qo</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">foreign~name</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is what a foreign word names</td>
                <td data-label="Comments">The foreign name follows, to end of compound tone.</td>
                <td data-label="Xref">qu, fo</td>
                <td data-label="Notes">Rank: 33<br>Thes: 0.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">12</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Conversions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">The specified case, wherever permuted to by prior conversions, is exchanged with the current first sequential case.  The conversion closer to the predicate occurs first.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">za</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">3rd~1st</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 3rd case to 1st</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 21<br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: fu</td>
            </tr>

            <tr>
                <td data-label="Word">ze</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">4th~1st</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 4th case to 1st</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: ju</td>
            </tr>

            <tr>
                <td data-label="Word">zi</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">5th~1st</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 5th case to 1st</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: hu</td>
            </tr>

            <tr>
                <td data-label="Word">zl</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">4th~2nd</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 4th case to 2nd</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: -</td>
            </tr>

            <tr>
                <td data-label="Word">zm</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">1st~3rd</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 1st case to 3rd</td>
                <td data-label="Comments">Resulting order is 2, 3, 1.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: fu</td>
            </tr>

            <tr>
                <td data-label="Word">zo</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">1st~1st</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 1st case to 1st</td>
                <td data-label="Comments">Suppresses any automatic conversion.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">3rd~2nd</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 3rd case to 2nd</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: -</td>
            </tr>

            <tr>
                <td data-label="Word">zu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">2nd~1st</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 2nd case to 1st</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 89<br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: nu</td>
            </tr>

            <tr>
                <td data-label="Word">zy</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">5th~2nd</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Conversion, 5th case to 2nd</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.2<br>Chinese: -<br>Latin: -<br>Loglan: -</td>
            </tr>

            <tr>
                <td data-label="Word">13</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Caselinks</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">The linked argument fills the specified case by number independent of any conversions.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sa</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">3rd~link</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Caselink, 3rd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 35<br>Thes: 0.1.3<br>Chinese: -<br>Latin: -<br>Loglan: pui</td>
            </tr>

            <tr>
                <td data-label="Word">se</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">4th~link</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Caselink, 4th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.3<br>Chinese: -<br>Latin: -<br>Loglan: puo</td>
            </tr>

            <tr>
                <td data-label="Word">si</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">5th~link</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Caselink, 5th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.3<br>Chinese: -<br>Latin: -<br>Loglan: puu</td>
            </tr>

            <tr>
                <td data-label="Word">so</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">1st~link</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Caselink, 1st case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.3<br>Chinese: -<br>Latin: -<br>Loglan: pua</td>
            </tr>

            <tr>
                <td data-label="Word">sr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">fence</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Argument fence</td>
                <td data-label="Comments">In an infinitive compound the following infinitive will not eat arguments.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.3<br>Chinese: -<br>Latin: -<br>Loglan: -</td>
            </tr>

            <tr>
                <td data-label="Word">su</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">2nd~link</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Caselink, 2nd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.1.3<br>Chinese: -<br>Latin: -<br>Loglan: pue</td>
            </tr>

            <tr>
                <td data-label="Word">20</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Prefixes</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Prefixes come first in a compound predicate.  Sub-phrases may follow any prefix or the complete predicate.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">21</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Link Words for Clauses and Sentences</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Sentence start prefixes are at the root grammatical level.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">:a</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">then</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Sentence start, next in sequence or time of occurrence</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 29<br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: zia</td>
            </tr>

            <tr>
                <td data-label="Word">:e</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">and</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Sentence start, another item similar to previous sentence</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 26<br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: .ice</td>
            </tr>

            <tr>
                <td data-label="Word">:i</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">start, period</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Main sentence start</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 259<br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: .i</td>
            </tr>

            <tr>
                <td data-label="Word">:l</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">end</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">End of transmission</td>
                <td data-label="Comments">Signifies that the speaker will not speak any more.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">:o</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">conjunction</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Retroactive downjump of sentence</td>
                <td data-label="Comments">The previous sentence becomes an infinitive with !vo and becomes the first case of the sentence now beginning</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 24<br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: .i</td>
            </tr>

            <tr>
                <td data-label="Word">:u</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">follow-on</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Start of follow-on sentence with coordinated pronoun referents</td>
                <td data-label="Comments">Pronouns and :o respond as if the joined sentences were just one sentence.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: .i</td>
            </tr>

            <tr>
                <td data-label="Word">fw</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">metaphor</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Event (vo) X1+ is represented by metaphor X2?</td>
                <td data-label="Comments">X1 is a \guaspi\  phrase, not foreign.  -fw with X2 makes a subordinate clause.</td>
                <td data-label="Xref">qo, fn</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">va</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">which, subordinate, attitude</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">subordinate assertion</td>
                <td data-label="Comments">An independent assertion about the restricted sentence or argument.  Missing argument defaults to -ji.  Use for attitudinals.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.1, 1.5.5<br>Chinese: -<br>Latin: -<br>Loglan: juo</td>
            </tr>

            <tr>
                <td data-label="Word">ve</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">which, subordinate</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">subordinate comment</td>
                <td data-label="Comments">A supplementary explanation.  Missing argument defaults to -xdro.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: juo</td>
            </tr>

            <tr>
                <td data-label="Word">vi</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">discursive, subordinate</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">discursive comment</td>
                <td data-label="Comments">A subordinate assertion relating restricted phrase to previous discourse.  Missing argument defaults to -zgly.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 14<br>Thes: 0.2.1, 1.5.5<br>Chinese: -<br>Latin: -<br>Loglan: juo</td>
            </tr>

            <tr>
                <td data-label="Word">vo</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">to, infinitive</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Event X1: is a member of the referent set of sentence X2?</td>
                <td data-label="Comments">To restrict the infinitive rather than the phrase, use -xe |R /vo P </td>
                <td data-label="Xref">vn</td>
                <td data-label="Notes">Rank: 23<br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: po</td>
            </tr>

            <tr>
                <td data-label="Word">vu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">which, subordinate</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">restrictive subordinate clause</td>
                <td data-label="Comments">The restricted relation events must fit this sentence also.  Missing argument defaults to -xdro.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 11<br>Thes: 0.2.1<br>Chinese: -<br>Latin: -<br>Loglan: juo</td>
            </tr>

            <tr>
                <td data-label="Word">22</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Articles</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Articles specify a subset of the full referent set of the argument.  The set may stay a set or may expand into its members.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">phrase~name</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is what the following phrase names</td>
                <td data-label="Comments">For \guaspi\ predicate names.</td>
                <td data-label="Xref">qo</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vy</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">each</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">All members of argument&#x27;s referent subset must fit in parent relation, or sentence is false.</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vl</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">independent</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Argument&#x27;s referent is chosen independently of other instances</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">inter~alia, each~other, reflexive</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Argument&#x27;s referent is chosen independently of other instances except may not be same as that of the other instances</td>
                <td data-label="Comments">Example: -:i !A ^fe -B /(word) !vr -zdmo</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vn</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">argument</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Despite default words this phrase is an argument, not an infinitive</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vo</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xa</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">all</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Whole referent set in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 11<br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: lea</td>
            </tr>

            <tr>
                <td data-label="Word">xe</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">the</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">In-mind elements of referent set, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: le</td>
            </tr>

            <tr>
                <td data-label="Word">xi</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">typical, mostly</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Typical elements of referent set, in extension</td>
                <td data-label="Comments">A few in-mind elements are excluded.  On sentence predicate, means ``for the most part&#x27;&#x27;.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 17<br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: loe</td>
            </tr>

            <tr>
                <td data-label="Word">xn</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">none, nothing, nobody</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">No members of referent set in extension</td>
                <td data-label="Comments">Makes negated statement about all referent set members.  There is only one null set so it is meaningless to make statements about its members.  !xn -jy means ``nothing&#x27;&#x27;.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xo</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">some, any, a</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Any elements of referent set, in extension</td>
                <td data-label="Comments">As in: give me a nail, any one will do.  Common with serving-portion words.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 28<br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: lo</td>
            </tr>

            <tr>
                <td data-label="Word">xr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">typical*</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Typical elements of referent set, as set</td>
                <td data-label="Comments">A few in-mind elements are excluded.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">all*</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Whole referent set, as set</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: lua</td>
            </tr>

            <tr>
                <td data-label="Word">xw</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">some*, any, a</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Any elements of referent set, as set</td>
                <td data-label="Comments">Example: give me a pair of your dollars; it&#x27;s not important which ones.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xy</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">the*</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">In-mind elements of referent set, as set</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: lue</td>
            </tr>

            <tr>
                <td data-label="Word">23</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Quotations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ba</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">quote~endmark</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Endmark for quote starting with -be</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.3<br>Chinese: -<br>Latin: -<br>Loglan: lu</td>
            </tr>

            <tr>
                <td data-label="Word">be</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">quote</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is an instance of a string to endmark -ba</td>
                <td data-label="Comments">The stuffing is considered foreign.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.3<br>Chinese: -<br>Latin: -<br>Loglan: li</td>
            </tr>

            <tr>
                <td data-label="Word">bi</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">quote</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is an instance of the following phrase X2? as language</td>
                <td data-label="Comments">Transforms as an infinitive similar to -vo.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bn</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">reference</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">The referent of the following argument is inserted here</td>
                <td data-label="Comments">The referent is supposed to be a text.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.3<br>Chinese: -<br>Latin: -<br>Loglan: lae</td>
            </tr>

            <tr>
                <td data-label="Word">bo</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">quote</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Text X1 has the same referent as the following phrase X2?</td>
                <td data-label="Comments">The phrase is an inexact quote meaning about the same as the original.  Transforms as an infinitive like -vo.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">br</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">quote</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is an instance of a delimited string</td>
                <td data-label="Comments">The next word is the delimiter; the stuffing, considered foreign, runs until the delimiter recurs.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.3<br>Chinese: -<br>Latin: -<br>Loglan: lie</td>
            </tr>

            <tr>
                <td data-label="Word">bu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">quote</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is an instance as language of the following words to end of compounding tone</td>
                <td data-label="Comments">-bu itself may be quoted; if so, it has no effect.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.3<br>Chinese: -<br>Latin: -<br>Loglan: liu</td>
            </tr>

            <tr>
                <td data-label="Word">24</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Names and Modal Cases</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">The following predicate specifies the modal case.  Each has a stack on which values can be saved and later restored.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qa</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">modal~pop</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">The modal argument stack for the following predicate is popped</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 31<br>Thes: 0.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qe</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">modal~save</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 becomes the default modal argument for the following predicate</td>
                <td data-label="Comments">The prior default is saved on its stack.</td>
                <td data-label="Xref">qy, qi</td>
                <td data-label="Notes">Rank: 28<br>Thes: 0.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qi</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">modal~new</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is the default modal argument for the following predicate</td>
                <td data-label="Comments">The previous default is replaced by X1.  The previous default is lost.</td>
                <td data-label="Xref">qe, qy</td>
                <td data-label="Notes">Rank: 14<br>Thes: 0.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ql</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">dialogue</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">The speaker and listener modal cases are exchanged</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">qr</td>
                <td data-label="Notes">Rank: 55<br>Thes: 0.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">modal~swap</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">The modal argument stack for the following predicate has its top two elements interchanged</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">ql</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qy</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">modal~test</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is the default modal argument for the following predicate</td>
                <td data-label="Comments">The default is not changed; the sentence is simply true or false.</td>
                <td data-label="Xref">qe, qi</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">25</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Mood Markers</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ga</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">performative</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">By being uttered the phrase makes something happen</td>
                <td data-label="Comments">Example: ``I do&#x27;&#x27; in marriage.</td>
                <td data-label="Xref">tri</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ge</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">affirm, factual, real, yes</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">The phrase is asserted to be real or factual</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">go, qtr, qkr, po, dve</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gi</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">potential</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">The phrase is potentially true</td>
                <td data-label="Comments">Actual truth is irrelevant</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">hypothesis, subjunctive</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">The phrase is hypothetical</td>
                <td data-label="Comments">Reality is irrelevant, and the listener should interpret the words as if the phrase were true (subjunctive mood).</td>
                <td data-label="Xref">poa</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gl</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">non-, negative, not</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Central negation</td>
                <td data-label="Comments">Makes predicate vanish, e.g. red-gray, above-beside, happy-bored.  Also works on central property, e.g. -gl-xbr = slanted, not level.</td>
                <td data-label="Xref">gr, ver</td>
                <td data-label="Notes">Rank: 17<br>Thes: 0.2.5, 1.5.4<br>Chinese: -<br>Latin: -<br>Loglan: bufpo</td>
            </tr>

            <tr>
                <td data-label="Word">go</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">not, unreal, no</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">This phrase is unreal or counter to fact</td>
                <td data-label="Comments">Contradictory negation; the sentence is not true but doesn&#x27;t say what is true.</td>
                <td data-label="Xref">ge, tso, po</td>
                <td data-label="Notes">Rank: <br>Thes: 0.2.5, 1.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">un-, opposite, negative, not</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Scale negation</td>
                <td data-label="Comments">Makes predicate opposite, e.g. red-cyan, above-below, happy-sad.</td>
                <td data-label="Xref">gl, ver</td>
                <td data-label="Notes">Rank: 18<br>Thes: 0.2.5, 1.5.4<br>Chinese: -<br>Latin: -<br>Loglan: bufpo</td>
            </tr>

            <tr>
                <td data-label="Word">30</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Pronouns</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">A pronoun or a modal default represents words, called its antecedent.  Remove the pronoun and substitute the antecedent for it.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">31</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Same Phrase</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdma</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">3rd~same</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Same Phrase 3rd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdme</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">4th~same</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Same Phrase 4th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdmi</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">5th~same</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Same Phrase 5th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdml</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">previous</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Same Phrase, the sequentially previous subphrase</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdmo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">1st~same</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Same Phrase 1st case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdmu</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">2nd~same</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Same Phrase 2nd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdmy</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">sentence~same</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Same Phrase whole sentence</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">32</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Restricted Phrase</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">The restricted phrase is two levels up from the pronoun, which refers to its other sub-phrases.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xdra</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">3rd~restricted</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Restricted Phrase 3rd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xdre</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">4th~restricted</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Restricted Phrase 4th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xdri</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">5th~restricted</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Restricted Phrase 5th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xdro</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">1st~restricted</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Restricted Phrase 1st case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xdru</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">2nd~restricted</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Restricted Phrase 2nd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xdry</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">sentence~restricted</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Restricted Phrase whole sentence</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">33</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Enclosing Main-Level Sentence</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xgna</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">3rd~main</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Enclosing Main-Level Sentence, 3rd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xgne</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">4th~main</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Enclosing Main-Level Sentence, 4th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xgni</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">5th~main</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Enclosing Main-Level Sentence, 5th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xgnl</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">discourse, sequel, title</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: This and following discourse</td>
                <td data-label="Comments">For a title, put xgnl in X1 of xim.</td>
                <td data-label="Xref">xim</td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xgno</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">1st~main</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Enclosing Main-Level Sentence, 1st case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xgnu</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">2nd~main</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Enclosing Main-Level Sentence, 2nd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xgny</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">sentence~main</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Enclosing Main-Level Sentence, whole sentence</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">34</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Previous Main-Level Sentence</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zgla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">3rd~previous</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Previous Main-Level Sentence, 3rd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zgle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">4th~previous</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Previous Main-Level Sentence, 4th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zgli</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">5th~previous</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Previous Main-Level Sentence, 5th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zgln</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">discourse</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Previous discourse in general</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zglo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">1st~previous</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Previous Main-Level Sentence, 1st case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zglr</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">event</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: the event that just happened or that continues to happen now</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zglu</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">2nd~previous</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Previous Main-Level Sentence, 2nd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zgly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">sentence~previous</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Previous Main-Level Sentence, whole sentence</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 24<br>Thes: 0.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">35</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Sentence to which Replies are Directed</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vgra</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">3rd~reply</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Sentence to which Replies are Directed, 3rd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vgre</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">4th~reply</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Sentence to which Replies are Directed, 4th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vgri</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">5th~reply</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Sentence to which Replies are Directed, 5th case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vgro</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">1st~reply</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Sentence to which Replies are Directed, 1st case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vgru</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">2nd~reply</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Sentence to which Replies are Directed, 2nd case</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vgry</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">sentence~reply</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Pronouns: Sentence to which Replies are Directed, whole sentence</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 15<br>Thes: 0.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">36</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Personal Pronouns</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ja</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">imperative, lets</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">(xa) X1M2 we, imperative</td>
                <td data-label="Comments">The speaker and the commandee (listener) in an imperative sentence.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">je</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">we</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">(xa) X1M2 we</td>
                <td data-label="Comments">The speaker and the listener.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ji</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">i, me, speaker</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1M2 I, the speaker</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 132<br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jl</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">something, somebody</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Something</td>
                <td data-label="Comments">An anonymous variable as in Prolog.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jm</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">that</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">An alternate object being shown</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jn</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">now, present</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1M4 now</td>
                <td data-label="Comments">Default for time modal case or present time.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jo</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">imperative, you</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1M3 you, imperative</td>
                <td data-label="Comments">The commandee, the listener in an imperative sentence.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 48<br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">place, here</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1M5 here</td>
                <td data-label="Comments">Default for place modal case or present place.</td>
                <td data-label="Xref">jir</td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ju</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">you</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1M3 you, the listener</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 77<br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jw</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">this</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">An object being shown</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 20<br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jy</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">which, something</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Something</td>
                <td data-label="Comments">The open case of an argument, occuring by default in the first case after conversion.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 10<br>Thes: 0.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">37</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Question Pronouns</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">The listener&#x27;s reply is supposed to be the pronoun&#x27;s antecedent.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">pu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">what, who</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Question Pronouns: who or what</td>
                <td data-label="Comments">Answer is an argument, the antecedent of the pronoun.  Use -py for events (vo).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">py</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">what</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Question Pronouns: what is X1:</td>
                <td data-label="Comments">Answer is a predicate about the given arguments.  Use for events too (vo).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">pr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">which</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Question Pronouns: which</td>
                <td data-label="Comments">Prefixed to an argument, it asks the listener to designate member(s) from the argument&#x27;s referent subset.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.7, 0.2.2<br>Chinese: -<br>Latin: -<br>Loglan: ha</td>
            </tr>

            <tr>
                <td data-label="Word">po</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">is~it</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Question Pronouns: mood marker</td>
                <td data-label="Comments">Answer is typically yes or no.</td>
                <td data-label="Xref">ge, go</td>
                <td data-label="Notes">Rank: 17<br>Thes: 0.3.7, 0.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">pa</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">how~many</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Set X1s has how many members X2 in extension</td>
                <td data-label="Comments">Answer is a numeric predicate.  This is a question pronoun and a quasidigit.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.7, 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: ho</td>
            </tr>

            <tr>
                <td data-label="Word">38</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Assignable Variables</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Assign as a name using -xim.  Also used as hexadecimal digits 10 to 15 (0.4.1).  A hex number must begin with a non-hex digit such as -cy (zero).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.8<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">da</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">variable~d</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Assignable Variable 3 or digit 13</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.8, 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: da</td>
            </tr>

            <tr>
                <td data-label="Word">de</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">variable~e</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Assignable Variable 4 or digit 14</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.8, 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: de</td>
            </tr>

            <tr>
                <td data-label="Word">di</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">variable~f</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Assignable Variable 5 or digit 15</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.8, 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">do</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">variable~b</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Assignable Variable 1 or digit 11</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 179<br>Thes: 0.3.8, 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: do</td>
            </tr>

            <tr>
                <td data-label="Word">du</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">variable~c</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Assignable Variable 2 or digit 12</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.8, 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: du</td>
            </tr>

            <tr>
                <td data-label="Word">dy</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">variable~a</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Assignable Variable 0 or digit 10</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.3.8, 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: di</td>
            </tr>

            <tr>
                <td data-label="Word">40</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Structure Words with Meaning</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">41</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Digits</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Assignable variables (0.3.8) are used for hexadecimal digits 10 to 15.  A hex number must begin with a non-hex digit such as -cy (zero).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ca</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">three</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 3 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: te</td>
            </tr>

            <tr>
                <td data-label="Word">ce</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">four</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 4 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: fo</td>
            </tr>

            <tr>
                <td data-label="Word">ci</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">five</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 5 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: fe</td>
            </tr>

            <tr>
                <td data-label="Word">cn</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">E-</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Negative power of ten follows</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">co</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">one</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 1 member X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 25<br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: ne</td>
            </tr>

            <tr>
                <td data-label="Word">cu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">two</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 2 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: to</td>
            </tr>

            <tr>
                <td data-label="Word">cw</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">decimal, point</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s IEC a decimal fraction X2, in extension</td>
                <td data-label="Comments">Digits: decimal point</td>
                <td data-label="Xref">-</td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: pi</td>
            </tr>

            <tr>
                <td data-label="Word">cy</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">zero</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 0 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: ni</td>
            </tr>

            <tr>
                <td data-label="Word">ka</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">eight</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 8 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: vo</td>
            </tr>

            <tr>
                <td data-label="Word">ke</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">nine</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 9 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: ve</td>
            </tr>

            <tr>
                <td data-label="Word">kl</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">minus</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is an equivalence class with a negative number of members X2, in extension</td>
                <td data-label="Comments">Normally an unsigned number follows.</td>
                <td data-label="Xref">vyn</td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kn</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">E+</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Positive power of ten follows</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ko</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">six</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 6 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: so</td>
            </tr>

            <tr>
                <td data-label="Word">ku</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">seven</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set of 7 members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.1<br>Chinese: -<br>Latin: -<br>Loglan: se</td>
            </tr>

            <tr>
                <td data-label="Word">42</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Quasi-Digits</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">These come first in a number.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ta</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">less</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set with less than N members X2, in extension</td>
                <td data-label="Comments">The number follows.  Alone: less than one.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: si</td>
            </tr>

            <tr>
                <td data-label="Word">te</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">less~equal</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set with less than or equal to N members X2, in extension</td>
                <td data-label="Comments">The number follows.  Alone: at most one.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: si</td>
            </tr>

            <tr>
                <td data-label="Word">ti</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">about</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set with approximately N members X2, in extension</td>
                <td data-label="Comments">The number follows.  Alone: about one.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: sa</td>
            </tr>

            <tr>
                <td data-label="Word">tm</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">few</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s has few members X2, in extesion</td>
                <td data-label="Comments">Use -pql for small degree.</td>
                <td data-label="Xref">pql</td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: ri</td>
            </tr>

            <tr>
                <td data-label="Word">to</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">more~equal</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set with greater than or equal to N members X2, in extension</td>
                <td data-label="Comments">The number follows.  Alone: at least one.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: su</td>
            </tr>

            <tr>
                <td data-label="Word">tr</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">ordinal</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is N&#x27;th in list (xy) X2s starting at origin X3</td>
                <td data-label="Comments">The number follows.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: ri</td>
            </tr>

            <tr>
                <td data-label="Word">tu</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">more</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s is a set with more than N members X2, in extension</td>
                <td data-label="Comments">The number follows.  Alone: more than one.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: su</td>
            </tr>

            <tr>
                <td data-label="Word">tw</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">many</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1s has many members X2, in extension</td>
                <td data-label="Comments">Use -fto for great degree.</td>
                <td data-label="Xref">fto</td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2<br>Chinese: -<br>Latin: -<br>Loglan: ro</td>
            </tr>

            <tr>
                <td data-label="Word">tl</td>
                <td data-label="Class">S</td>
                <td data-label="Engl">ordinal, next</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">(vo) X1+ is N&#x27;th in some sequence</td>
                <td data-label="Comments">Number follows; it means next if there is no number.  Mainly a decoration.</td>
                <td data-label="Xref">bny</td>
                <td data-label="Notes">Rank: <br>Thes: 0.4.2, 1.5.5<br>Chinese: -<br>Latin: -<br>Loglan: ria</td>
            </tr>

            <tr>
                <td data-label="Word">50</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Letterals</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">A letteral means X1 is an instance of whatever letter.  To spell a word compound the letters; it means X1 is an instance of a word spelled thus.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">#vla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">#</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman schwa</td>
                <td data-label="Comments">Written as \# sign.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">51</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Roman Lower Case Alphabet</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">:zla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">:</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman glottal stop</td>
                <td data-label="Comments">Written as colon.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">a</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower a</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">e</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower e</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxli</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">i</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower i</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxlm</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">m</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower m</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxln</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">n</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower n</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxlo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">o</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower o</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxlr</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">r</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower r</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxlu</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">u</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower u</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxlw</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">w</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower w</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">y</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower y</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bxrl</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">l</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower l</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bzla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">b</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower b</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">c</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower c</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dvla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">d</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower d</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fkla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">h</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower h</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fsla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">f</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower f</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gvla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">g</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower g</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jvla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">j</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower j</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kfla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">k</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower k</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">psla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">p</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower p</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qfla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">q</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower q</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sfla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">s</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tfla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">t</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower t</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vzla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">v</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower v</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xvla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">x</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower x</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zvla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">z</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman lower z</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">52</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Roman Upper Case Alphabet</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bzle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">B</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper B</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">C</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper C</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dvle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">D</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper D</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fkle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">H</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper H</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fsle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">F</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper F</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gvle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">G</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper G</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jvle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">J</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper J</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kfle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">K</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper K</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">psle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">P</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper P</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qfle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Q</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper Q</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sfle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">S</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper S</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tfle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">T</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper T</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vzle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">V</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper V</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xbla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">A</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper A</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xble</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">E</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper E</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xbli</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">I</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper I</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xblm</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">M</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper M</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xbln</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">N</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper N</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xblo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">O</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper O</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xblr</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">R</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper R</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xblu</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">U</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper U</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xblw</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">W</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper W</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xbly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Y</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper Y</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xbrl</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">L</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper L</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xvle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">X</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper X</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zvle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Z</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Roman upper Z</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">53</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Greek Lower Case Alphabet</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">:zly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">breath</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a modern Greek breath mark</td>
                <td data-label="Comments">Written in Greek as apostrophe.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bzly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">beta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower beta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">psi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower psi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dvly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">delta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower delta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fkly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">chi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower chi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fsly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">phi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower phi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gvly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">gamma</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower gamma</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kfly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">kappa</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower kappa</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">psly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">pi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower pi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qfly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">theta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower theta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sfly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">sigma</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower sigma</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tfly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">tau</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower tau</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">alpha</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower alpha</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxle</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">epsilon</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower epsilon</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxli</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">iota</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower iota</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxlm</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">mu</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower mu</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxln</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">nu</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower nu</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxlo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">omicron</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower omicron</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxlr</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">rho</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower rho</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxlu</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">upsilon</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower upsilon</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxlw</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">omega</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower omega</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">eta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower eta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vxrl</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">lambda</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower lambda</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xvly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">xi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower xi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zvly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">zeta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek lower zeta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">54</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Greek Upper Case Alphabet</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bzlo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Beta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Beta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cflo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Psi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Psi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dvlo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Delta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Delta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fklo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Chi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Chi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fslo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Phi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Phi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gvlo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Gamma</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Gamma</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kflo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Kappa</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Kappa</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">pslo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Pi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Pi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qflo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Theta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Theta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sflo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Sigma</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Sigma</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tflo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Tau</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Tau</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xvlo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Xi</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Xi</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zbla</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Alpha</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Alpha</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zble</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Epsilon</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Epsilon</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zbli</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Iota</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Iota</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zblm</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Mu</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Mu</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zbln</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Nu</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Nu</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zblo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Omicron</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Omicron</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zblr</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Rho</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Rho</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zblu</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Upsilon</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Upsilon</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zblw</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Omega</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Omega</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zbly</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Eta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Eta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zbrl</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Lambda</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Lambda</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zvlo</td>
                <td data-label="Class">P</td>
                <td data-label="Engl">Zeta</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a Greek upper Zeta</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 0.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">100</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Relations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">All multi-place predicates are relations, but these are more ``relational&#x27;&#x27; than most.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.0.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">110</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Abstract Relations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">111</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Abstract Comparison of Similar Items</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bin</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">beyond</td>
                <td data-label="Phon">biiand</td>
                <td data-label="Definition">X1: is beyond X2: in relation (vo) X3+1, 2-4 with reference X4?</td>
                <td data-label="Comments">X1 compared to X4 is more than X2-X4.  Default X4 is the modal default for X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1<br>Chinese: !dzai!na-bian<br>Latin: ultra<br>Loglan: bancu*</td>
            </tr>

            <tr>
                <td data-label="Word">cao</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">chaos, disorder</td>
                <td data-label="Phon">caos</td>
                <td data-label="Definition">(xu) X1s is chaotic in property (vo) X2+S1</td>
                <td data-label="Comments">X1 is a process or set and its members have property X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1<br>Chinese: !bu-guei!liu<br>Latin: caos<br>Loglan: kalsa*</td>
            </tr>

            <tr>
                <td data-label="Word">pia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">copy, original, prototype</td>
                <td data-label="Phon">kapi</td>
                <td data-label="Definition">X1 is a copy of the original X2*</td>
                <td data-label="Comments">Use when the copy and the original can be distinguished.</td>
                <td data-label="Xref">sur</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1<br>Chinese: !iaw|ben<br>Latin: eksempl.um<br>Loglan: kopca</td>
            </tr>

            <tr>
                <td data-label="Word">qaw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">equal</td>
                <td data-label="Phon">iku#l</td>
                <td data-label="Definition">In relation (vo) X1+2 all the arguments X2:= repeated as needed, fit equally</td>
                <td data-label="Comments">Use -dem to compare math expressions for equality.  Use -xim to assign a symbol&#x27;s value.</td>
                <td data-label="Xref">dem, xim</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1<br>Chinese: -qaw|duw<br>Latin: par<br>Loglan: ciktu</td>
            </tr>

            <tr>
                <td data-label="Word">sur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">repeat, recur, again, prototype</td>
                <td data-label="Phon">rik#r</td>
                <td data-label="Definition">X1 is a recurrent instance of prototype X2*</td>
                <td data-label="Comments">X1 automatically has many X2&#x27;s.  Use for non-distinguishable particles in quantum mechanics.</td>
                <td data-label="Xref">pia, plm, qkm, tfr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1<br>Chinese: /sun/huan<br>Latin: rurs.us<br>Loglan: genza</td>
            </tr>

            <tr>
                <td data-label="Word">viy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">substitute, replace</td>
                <td data-label="Phon">s#bstytut</td>
                <td data-label="Definition">X1 is a substitute for original X2 in activity or function (vo) X3+1, 2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1<br>Chinese: !dai!iuw|pin<br>Latin: vikary.us<br>Loglan: basti*</td>
            </tr>

            <tr>
                <td data-label="Word">gre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">exceed, more, less</td>
                <td data-label="Phon">eksid</td>
                <td data-label="Definition">X1: exceeds X2: in quality (vo) X3+1, 2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 11<br>Thes: 1.1.1, 1.1.7<br>Chinese: !guw/u<br>Latin: egredy<br>Loglan: mordu</td>
            </tr>

            <tr>
                <td data-label="Word">fay</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">reverse, opposite</td>
                <td data-label="Phon">ap#zyt</td>
                <td data-label="Definition">Process (vo) X1@! occurs in the reverse order from process (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vri, vry</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1, 1.5.4<br>Chinese: -siaw|fan<br>Latin: kontrary.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ver</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">opposite</td>
                <td data-label="Phon">opozyt</td>
                <td data-label="Definition">X1 is opposite X2* in dimension (xu-vo) X3+1, 2</td>
                <td data-label="Comments">As in high--low.</td>
                <td data-label="Xref">gr, sra</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1, 1.5.4<br>Chinese: -siaw|fan<br>Latin: advers.us<br>Loglan: bufpo</td>
            </tr>

            <tr>
                <td data-label="Word">vri</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">reverse</td>
                <td data-label="Phon">rivrs</td>
                <td data-label="Definition">List (xy) X1s is in reverse order from list (xy) X2s*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fau, vry, fay</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1, 1.5.4<br>Chinese: -siaw|fan<br>Latin: kontrari.um<br>Loglan: fanve</td>
            </tr>

            <tr>
                <td data-label="Word">bwy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">differ</td>
                <td data-label="Phon">dyfr</td>
                <td data-label="Definition">X1: differs from X2: in dimension (vo) X3+1, 2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 16<br>Thes: 1.1.1, 1.5.5<br>Chinese: !bu/tuw<br>Latin: aly.us<br>Loglan: retca</td>
            </tr>

            <tr>
                <td data-label="Word">smy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">similar, like</td>
                <td data-label="Phon">laik</td>
                <td data-label="Definition">X1: is similar to X2: in fitting predicate (vo) X3+1, 2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">xor</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1, 1.5.5<br>Chinese: -siaw!sz<br>Latin: symyl.ys<br>Loglan: clika</td>
            </tr>

            <tr>
                <td data-label="Word">par</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">compare</td>
                <td data-label="Phon">kumpar</td>
                <td data-label="Definition">Actor X1 compares X2: to X3: on dimension (vo) X4+2, 3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1, 2.3.7<br>Chinese: |bi|jiau<br>Latin: kompar.are<br>Loglan: kambi</td>
            </tr>

            <tr>
                <td data-label="Word">slr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">similar, scale, congruent</td>
                <td data-label="Phon">symylr</td>
                <td data-label="Definition">Object X1 is like prototype X2 multiplied IEC scale (xu) X3*</td>
                <td data-label="Comments">Geometrically similar; same shape but different size.  Use -slr =co for congruent.</td>
                <td data-label="Xref">smy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1, 3.7.4<br>Chinese: !lei!sz<br>Latin: par<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gna</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">relate, predicate</td>
                <td data-label="Phon">rilait</td>
                <td data-label="Definition">Relation (vo) X1+ has arguments X2= repeated as needed</td>
                <td data-label="Comments">X2, X3, etc. are in the same referent set member in unspecified cases.  No case merge for X1.</td>
                <td data-label="Xref">qin, skam</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.1, 4.4.6, 1.5.6<br>Chinese: |jiaw<br>Latin: kognat.us<br>Loglan: kunci</td>
            </tr>

            <tr>
                <td data-label="Word">112</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Sets</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bem</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">subset</td>
                <td data-label="Phon">s#bset</td>
                <td data-label="Definition">(xy) X1s is a subset of superset (xy) X2s with members (xa) X3*</td>
                <td data-label="Comments">Give the defining property in X3; X1 = X2 intersect X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: -<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dem</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">same</td>
                <td data-label="Phon">saim</td>
                <td data-label="Definition">The referents of X1: are the same as the referents of X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">dom, qaw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: -i!iaw<br>Latin: ydem<br>Loglan: samto</td>
            </tr>

            <tr>
                <td data-label="Word">gvu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">group, set</td>
                <td data-label="Phon">grup</td>
                <td data-label="Definition">(xy) X1s is a group with members X2* in extension</td>
                <td data-label="Comments">A set of people</td>
                <td data-label="Xref">sto, diu</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: /tuan<br>Latin: katerva<br>Loglan: grupa</td>
            </tr>

            <tr>
                <td data-label="Word">vge</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">class, set</td>
                <td data-label="Phon">klas</td>
                <td data-label="Definition">(xy) X1s is a class with members X2*</td>
                <td data-label="Comments">A class may be a member of itself while a set may not.  See ``Russell&#x27;s paradox&#x27;&#x27;.  Use -diu -sui for learning team.</td>
                <td data-label="Xref">sto</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: -<br>Latin: gen.us<br>Loglan: klesi</td>
            </tr>

            <tr>
                <td data-label="Word">sew</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">intersection</td>
                <td data-label="Phon">yntersekqn</td>
                <td data-label="Definition">X1: is a member of the intersection of set (xy) X2s= repeated as needed</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">cra</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: /h#w-cie<br>Latin: sek.are<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sto</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">set</td>
                <td data-label="Phon">set</td>
                <td data-label="Definition">(xy) X1s is a set of members X2* in extension</td>
                <td data-label="Comments">Use -tla when each member is given in a separate argument.</td>
                <td data-label="Xref">vge, vdr, tla, sty, gvu</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: !tau<br>Latin: kongery.es<br>Loglan: setci</td>
            </tr>

            <tr>
                <td data-label="Word">stl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">list</td>
                <td data-label="Phon">lyst</td>
                <td data-label="Definition">(xy) X1s is a list with members (xu) X2= repeated as needed, in that order</td>
                <td data-label="Comments">An ordered set.  -xu default because -stl is used for vectors, dates, etc.</td>
                <td data-label="Xref">sty, tla</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: |biau<br>Latin: tabula<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sty</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">list, sort, order</td>
                <td data-label="Phon">lyst</td>
                <td data-label="Definition">List (xy) X1s is a list of set (xy) X2s in order (vo) X3+PS2, 1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">stl, sto</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: |biau<br>Latin: tabula<br>Loglan: lista</td>
            </tr>

            <tr>
                <td data-label="Word">tei</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">except</td>
                <td data-label="Phon">eksept</td>
                <td data-label="Definition">X1: is a member of the intersection of (xu) X2:s and the complement of (xu) X3:s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: /cu-fei<br>Latin: praiter<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tla</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">set</td>
                <td data-label="Phon">set</td>
                <td data-label="Definition">(xa) X1 is one of members X2=? repeated as needed</td>
                <td data-label="Comments">Use -xu to get the set.</td>
                <td data-label="Xref">sto, stl, fy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: !tau<br>Latin: konlat.yo<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tsy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">system</td>
                <td data-label="Phon">systm</td>
                <td data-label="Definition">(xy) X1s is a system of parts X2 with function (xi-vo) X3+1</td>
                <td data-label="Comments">An organized set of parts.</td>
                <td data-label="Xref">cin, fwa, brm, gme</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: !siy|tuw<br>Latin: rat.yo<br>Loglan: sisto</td>
            </tr>

            <tr>
                <td data-label="Word">vae</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">equivalence</td>
                <td data-label="Phon">ikuyvalens</td>
                <td data-label="Definition">X1:s is an equivalence class of class (xy) X2s using equivalence relation (vo) X3+P2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: -qaw|duw-de<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vlu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">exclusive~or, alternation</td>
                <td data-label="Phon">eksklusyv</td>
                <td data-label="Definition">X1: is a member of the exclusive union of (xy) X2:s= repeated as needed</td>
                <td data-label="Comments">Exclusive or: X1 is in an odd number of argument sets.</td>
                <td data-label="Xref">xiw, zny</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: <br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xiw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">iff, if-only-if, equivalent</td>
                <td data-label="Phon">iff</td>
                <td data-label="Definition">X1: is a member of the intersection of (xy) X2:s= repeated as needed, or of all their complements</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vlu, sew</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: <br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xun</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">union, or</td>
                <td data-label="Phon">iuni#n</td>
                <td data-label="Definition">X1: is a member of the union of (xy) X2:s= repeated as needed</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: /lian/h#<br>Latin: yunkt.yo<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zny</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">infer, imply</td>
                <td data-label="Phon">ymplai</td>
                <td data-label="Definition">X1: is a member of the union of (xy) X2:s and the complement of (xy) X3:s</td>
                <td data-label="Comments">Use this for a setwise inference.</td>
                <td data-label="Xref">sny, klu</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: /han!i<br>Latin: sygnyfyk.are<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vdr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">member</td>
                <td data-label="Phon">membr</td>
                <td data-label="Definition">X1 is a member of set (xy) X2s*</td>
                <td data-label="Comments">Conversion of -sto.</td>
                <td data-label="Xref">sto, zdi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2<br>Chinese: -duw!shr<br>Latin: sodal.ys<br>Loglan: djori</td>
            </tr>

            <tr>
                <td data-label="Word">dom</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">none</td>
                <td data-label="Phon">n#n</td>
                <td data-label="Definition">None of the referents of X1: are referents of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">dem, ple</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2, 1.5.4<br>Chinese: -dou/mei<br>Latin: nemo<br>Loglan: notbi</td>
            </tr>

            <tr>
                <td data-label="Word">ple</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">complement</td>
                <td data-label="Phon">komplement</td>
                <td data-label="Definition">X1: is a member of the complement set of (xy) X2:s* relative to universal set (xy) X3:s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">dom</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2, 1.5.4<br>Chinese: |bu/dzu<br>Latin: komplement.um<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kfa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">family</td>
                <td data-label="Phon">famyli</td>
                <td data-label="Definition">(xy) X1s is a family with members X2* in extension</td>
                <td data-label="Comments">Includes nonhumans.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2, 4.6.2<br>Chinese: -jia/ren<br>Latin: famylya<br>Loglan: famji</td>
            </tr>

            <tr>
                <td data-label="Word">xde</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">orchestra</td>
                <td data-label="Phon">orkestr#</td>
                <td data-label="Definition">(xy) X1s is an orchestra, musical performance group</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2, 4.6.3<br>Chinese: !ue!duei<br>Latin: <br>Loglan: bendu</td>
            </tr>

            <tr>
                <td data-label="Word">diu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">team</td>
                <td data-label="Phon">tim</td>
                <td data-label="Definition">(xy) X1s is a team for activity (vo) X2+1</td>
                <td data-label="Comments">X1 members do X2 collectively.  X1 is an organized group.</td>
                <td data-label="Xref">gvu</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2, 4.6.4<br>Chinese: !duei<br>Latin: iug.um<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kqy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">committee</td>
                <td data-label="Phon">kamyti</td>
                <td data-label="Definition">(xy) X1s is a committee of organization (xy) X2s with job (vo) X3+1</td>
                <td data-label="Comments">X1 is a subset of X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.2, 4.7.4<br>Chinese: |duw!qr!bu<br>Latin: konsily.um<br>Loglan: kamti</td>
            </tr>

            <tr>
                <td data-label="Word">113</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Parts and Members of Sets</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bor</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">boundary, edge, border, end</td>
                <td data-label="Phon">border</td>
                <td data-label="Definition">X1s is the boundary of region (xy) X2s* with topology (xy) X3s</td>
                <td data-label="Comments">Includes ends of a long object as a set.</td>
                <td data-label="Xref">fni, xyn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: -bian!jie<br>Latin: margo<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">brm</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">part, system</td>
                <td data-label="Phon">part</td>
                <td data-label="Definition">X1 is a part of system X2s*</td>
                <td data-label="Comments">X1 is in place or it can be put in and X2 will work.</td>
                <td data-label="Xref">gme, tsy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: !bu!f#n<br>Latin: membr.um<br>Loglan: parti</td>
            </tr>

            <tr>
                <td data-label="Word">dmy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">mixture</td>
                <td data-label="Phon">mykstiur</td>
                <td data-label="Definition">(xo) X1 is a mixture of component (xo) X2= repeated as needed</td>
                <td data-label="Comments">Like paint; use -sew for overlaps like blue-gray.</td>
                <td data-label="Xref">zar</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: |dzu/h#!u<br>Latin: mykstura<br>Loglan: miksa</td>
            </tr>

            <tr>
                <td data-label="Word">gme</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">piece</td>
                <td data-label="Phon">pis</td>
                <td data-label="Definition">X1 is a piece of system X2s*</td>
                <td data-label="Comments">X1 is detached as if broken off.</td>
                <td data-label="Xref">brm, tsy, qno</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: !bu!f#n<br>Latin: fragment.um<br>Loglan: pisku</td>
            </tr>

            <tr>
                <td data-label="Word">gon</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">local</td>
                <td data-label="Phon">lokl</td>
                <td data-label="Definition">X1: occurs only in region X2s*</td>
                <td data-label="Comments">Typically X2 is a territory of land; or it can be a set.  X1 is typically a thing but can be an event.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: /jiu!bu<br>Latin: regyon.ys<br>Loglan: lokti</td>
            </tr>

            <tr>
                <td data-label="Word">pey</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">special</td>
                <td data-label="Phon">speql</td>
                <td data-label="Definition">X1 is special among set (xy) X2s in fitting event (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: !t#/bie<br>Latin: praekypu.#s<br>Loglan: spebi</td>
            </tr>

            <tr>
                <td data-label="Word">pqu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">few</td>
                <td data-label="Phon">fiu</td>
                <td data-label="Definition">Set (xy) X1s has few members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vdu, pql</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: !qau!qu<br>Latin: pauky<br>Loglan: ri</td>
            </tr>

            <tr>
                <td data-label="Word">sia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">detail</td>
                <td data-label="Phon">ditail</td>
                <td data-label="Definition">X1 is a detail of system (xy) X2s*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: /siaw!si<br>Latin: syngula<br>Loglan: citlu</td>
            </tr>

            <tr>
                <td data-label="Word">sli</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">slice</td>
                <td data-label="Phon">slais</td>
                <td data-label="Definition">X1 is a slice of object X2*</td>
                <td data-label="Comments">A (usually) flat piece removed by cutting.  X2 is typically food, e.g. a melon or a portion of meat.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: !pian<br>Latin: <br>Loglan: panle*</td>
            </tr>

            <tr>
                <td data-label="Word">vdu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">many</td>
                <td data-label="Phon">meni</td>
                <td data-label="Definition">Set (xy) X1s has many members X2, in extension</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pqu, fto</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: -duo<br>Latin: multy<br>Loglan: re</td>
            </tr>

            <tr>
                <td data-label="Word">zar</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">mixture, medley</td>
                <td data-label="Phon">myksti#r</td>
                <td data-label="Definition">X1s has parts in set (xu) X2:= repeated as needed</td>
                <td data-label="Comments">For red, white and blue flag.</td>
                <td data-label="Xref">dmy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3<br>Chinese: /dza!s#<br>Latin: farago<br>Loglan: miksa</td>
            </tr>

            <tr>
                <td data-label="Word">sym</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">chief, highest, most, extreme</td>
                <td data-label="Phon">most</td>
                <td data-label="Definition">X1: is most in set (xy) X2s on dimension (vo) X3+S2, 1</td>
                <td data-label="Comments">Dimension typically is ``importance&#x27;&#x27; but there is no default.  Ties for X1 are possible.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3, 1.2.5<br>Chinese: !dzuei<br>Latin: maksyme<br>Loglan: cefli</td>
            </tr>

            <tr>
                <td data-label="Word">zer</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rare, unusual</td>
                <td data-label="Phon">rer</td>
                <td data-label="Definition">X1: is rare among set (xy) X2s in property (vo) X3+1, S2</td>
                <td data-label="Comments">Few X2 members are X3, but X1 is one of them.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3, 1.3.3<br>Chinese: -si|iou<br>Latin: rar.us<br>Loglan: rirci*</td>
            </tr>

            <tr>
                <td data-label="Word">bny</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">first, begin, next, least</td>
                <td data-label="Phon">bigyn</td>
                <td data-label="Definition">X1: is next in list (xy) X2s* after origin X3</td>
                <td data-label="Comments">For lists, processes or oriented objects.  First or least member without X3.  |pa for N&#x27;th from X3 or |tepa for initial segment.</td>
                <td data-label="Xref">fne, tl, sym</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3, 3.7.4<br>Chinese: |ci<br>Latin: ynyty.um<br>Loglan: satci</td>
            </tr>

            <tr>
                <td data-label="Word">fne</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">last, end, previous, most</td>
                <td data-label="Phon">end</td>
                <td data-label="Definition">X1 is previous in list (xy) X2s* before origin X3</td>
                <td data-label="Comments">For lists, processes or oriented objects.  Tail or largest member without X3.  |pa gives N&#x27;th from X3 or |tepa for end segment.</td>
                <td data-label="Xref">bny, sym</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3, 3.7.4<br>Chinese: /jie<br>Latin: fyn.ys<br>Loglan: fando</td>
            </tr>

            <tr>
                <td data-label="Word">fni</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">range</td>
                <td data-label="Phon">rainj</td>
                <td data-label="Definition">Process X1s ranges over set (xy) X2s*</td>
                <td data-label="Comments">Use -xu F for the range of a function.</td>
                <td data-label="Xref">biar, bor</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3, 3.7.4<br>Chinese: !fan/uei<br>Latin: <br>Loglan: ranjo</td>
            </tr>

            <tr>
                <td data-label="Word">dor</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">decoration, adorn</td>
                <td data-label="Phon">adorn</td>
                <td data-label="Definition">X1 is a decoration or adornment on system X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3, 4.1.6<br>Chinese: -juaw!qr<br>Latin: orn.are<br>Loglan: durna</td>
            </tr>

            <tr>
                <td data-label="Word">plm</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">example, illustrate</td>
                <td data-label="Phon">eksampl</td>
                <td data-label="Definition">X1 is an example member of set (xy) X2s*</td>
                <td data-label="Comments">A member of X2 which illustrates clearly what kind of thing is in it.</td>
                <td data-label="Xref">sur, bya</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.3, 4.4.5, 1.5.1<br>Chinese: |baw!iaw<br>Latin: eksempl.um<br>Loglan: mipli</td>
            </tr>

            <tr>
                <td data-label="Word">114</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Objective Relations of Persons</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jiy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">encounter, meet</td>
                <td data-label="Phon">mit</td>
                <td data-label="Definition">X1: meets, encounters X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">twa, cra</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4<br>Chinese: !iu!jian<br>Latin: obvy.us<br>Loglan: jmite</td>
            </tr>

            <tr>
                <td data-label="Word">qcy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">affair</td>
                <td data-label="Phon">afer</td>
                <td data-label="Definition">(vo) X1 is an affair involving persons (xy) X2s*</td>
                <td data-label="Comments">Meaning is close to -za -twa = interact.</td>
                <td data-label="Xref">twa, ftr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4<br>Chinese: !qr-cyw<br>Latin: res<br>Loglan: ferci</td>
            </tr>

            <tr>
                <td data-label="Word">zey</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">relevant, possess, my, pertinent</td>
                <td data-label="Phon">p#zes</td>
                <td data-label="Definition">X1: is pertinent or relevant to thing X2:*</td>
                <td data-label="Comments">For ``possessive&#x27;&#x27; constructions like ``my hat&#x27;&#x27; where X1 = hat, X2 = me.  Ownership not required.</td>
                <td data-label="Xref">bou, pry, kio</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4, 1.5.1<br>Chinese: -de<br>Latin: posesyv.us<br>Loglan: pe</td>
            </tr>

            <tr>
                <td data-label="Word">bai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">polite</td>
                <td data-label="Phon">polait</td>
                <td data-label="Definition">X1: is polite to X2: by action (vo) X3+1</td>
                <td data-label="Comments">No automatic replication of X2 into X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4, 2.1.4<br>Chinese: |iou|li/mau<br>Latin: urban.us<br>Loglan: clite*</td>
            </tr>

            <tr>
                <td data-label="Word">per</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">power</td>
                <td data-label="Phon">paur</td>
                <td data-label="Definition">X1: has power over person X2 in affair (vo) X3+2</td>
                <td data-label="Comments">Typically X3 is something X2 has to do.</td>
                <td data-label="Xref">toa</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4, 2.1.6, 4.7.1<br>Chinese: /cuan!biw<br>Latin: ymperi.um<br>Loglan: porli</td>
            </tr>

            <tr>
                <td data-label="Word">gly</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">analyse, conclusion</td>
                <td data-label="Phon">analayz</td>
                <td data-label="Definition">Thinker X1 analyses object X2 with the conclusion (vo) X3+2 from input data (vo) X4+2@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4, 2.3.5<br>Chinese: -fen|jie<br>Latin: eksplyc.are<br>Loglan: lanli*</td>
            </tr>

            <tr>
                <td data-label="Word">jym</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">spouse, marry</td>
                <td data-label="Phon">mari</td>
                <td data-label="Definition">X1 is married to spouse X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4, 4.6.2<br>Chinese: /jie-hun<br>Latin: matrymon.yo<br>Loglan: merji</td>
            </tr>

            <tr>
                <td data-label="Word">bou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">own</td>
                <td data-label="Phon">on</td>
                <td data-label="Definition">Owner X1 owns property X2*</td>
                <td data-label="Comments">Use -zey for ordinary possessive.  |gul for the law or |tue for a culture.</td>
                <td data-label="Xref">zey, kio</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.4, 4.7.1<br>Chinese: |iou<br>Latin: hab.ere<br>Loglan: ponsu</td>
            </tr>

            <tr>
                <td data-label="Word">115</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Subjective Relations of Persons</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">friend</td>
                <td data-label="Phon">frend</td>
                <td data-label="Definition">X1 is a friend of X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">cmi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.5<br>Chinese: /p#w-iou<br>Latin: amyk.us<br>Loglan: fremi</td>
            </tr>

            <tr>
                <td data-label="Word">jul</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">neutral, struggle</td>
                <td data-label="Phon">nutr#l</td>
                <td data-label="Definition">X1 is neutral while participants (xy) X2s have struggle (vo) X3+S2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.5<br>Chinese: -juw!li<br>Latin: medy.us<br>Loglan: nutra</td>
            </tr>

            <tr>
                <td data-label="Word">pin</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">peace</td>
                <td data-label="Phon">pis</td>
                <td data-label="Definition">X1: is at peace with X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">cmi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.5, 1.2.1<br>Chinese: /pin-gan<br>Latin: paks<br>Loglan: pismi</td>
            </tr>

            <tr>
                <td data-label="Word">cmi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">enemy, struggle</td>
                <td data-label="Phon">enemi</td>
                <td data-label="Definition">X1 is an enemy of X2: in affair or struggle (vo) X3+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pin, fre</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.5, 2.1.7<br>Chinese: /cou/di<br>Latin: ynymyk.us<br>Loglan: nemdi</td>
            </tr>

            <tr>
                <td data-label="Word">tew</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">interest</td>
                <td data-label="Phon">yntrest</td>
                <td data-label="Definition">X1 is interested in subject X2 because it does (vo) X3+2</td>
                <td data-label="Comments">Not for rent on money.</td>
                <td data-label="Xref">kre</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.5, 2.3.6<br>Chinese: |hau-tiw<br>Latin: ten.ere<br>Loglan: treci</td>
            </tr>

            <tr>
                <td data-label="Word">fri</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rely, depend</td>
                <td data-label="Phon">rilai</td>
                <td data-label="Definition">X1: relies on fiduciary X2 to do action (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.5, 2.5.1<br>Chinese: !sin!ren<br>Latin: fyd.ere<br>Loglan: lacri*</td>
            </tr>

            <tr>
                <td data-label="Word">116</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Relations of Activities</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jrm</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">formal</td>
                <td data-label="Phon">forml</td>
                <td data-label="Definition">Activity (vo) X1+ is done formally</td>
                <td data-label="Comments">By standard or expected plans or rules.</td>
                <td data-label="Xref">fma, zia, gul, qre, tri</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6<br>Chinese: !jew!qr<br>Latin: rit.us<br>Loglan: forma</td>
            </tr>

            <tr>
                <td data-label="Word">psm</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">random, accident</td>
                <td data-label="Phon">rand#m</td>
                <td data-label="Definition">Process (vo) X1 is accidental or random</td>
                <td data-label="Comments">Not necessarily bad.  Use -psm |stu for bad luck.  ``There is no such thing as bad luck.&#x27;&#x27;</td>
                <td data-label="Xref">kau, qun</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6<br>Chinese: /suei!bian<br>Latin: tem.ere<br>Loglan: canse</td>
            </tr>

            <tr>
                <td data-label="Word">qne</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">proxy, test, valid</td>
                <td data-label="Phon">test</td>
                <td data-label="Definition">Examinee X1 being/doing test (vo) X3+1@! is a proxy measure for having real quality (vo) X2+1</td>
                <td data-label="Comments">|sen for tester, |pyn for interpreter, and |fta for standard.  -za -qne means valid.</td>
                <td data-label="Xref">fta, pyn, sen, vju</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6<br>Chinese: !qr!ian<br>Latin: <br>Loglan: pruci</td>
            </tr>

            <tr>
                <td data-label="Word">spo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">possible</td>
                <td data-label="Phon">posybl</td>
                <td data-label="Definition">Event (vo) X1+ is possible</td>
                <td data-label="Comments">Has a low but nonzero probability.</td>
                <td data-label="Xref">bal, pwo, zba</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6<br>Chinese: |k#/n#w<br>Latin: pose<br>Loglan: blicu</td>
            </tr>

            <tr>
                <td data-label="Word">zba</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">likely, probable</td>
                <td data-label="Phon">laikli</td>
                <td data-label="Definition">Event (vo) X1+ is likely</td>
                <td data-label="Comments">Has a high probability.</td>
                <td data-label="Xref">bal, spo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6<br>Chinese: |k#/n#w<br>Latin: probabyl.ys<br>Loglan: blicu</td>
            </tr>

            <tr>
                <td data-label="Word">qlo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">location, place</td>
                <td data-label="Phon">lokaqn</td>
                <td data-label="Definition">X1M5 is the location of event (vo) X2+ relative to origin (vo) X3@</td>
                <td data-label="Comments">On X2 and X3 do not use -xe even for ``things&#x27;&#x27;; let the default -vo turn things into events.</td>
                <td data-label="Xref">jir</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 1.3.6, 1.4.4<br>Chinese: !di-faw<br>Latin: loky<br>Loglan: sitfa</td>
            </tr>

            <tr>
                <td data-label="Word">fta</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">standard, rule</td>
                <td data-label="Phon">standrd</td>
                <td data-label="Definition">X1s is a standard or set of rules by which (vo) X2:+ can be asserted</td>
                <td data-label="Comments">Normally X2 IS asserted (use -ge).</td>
                <td data-label="Xref">qre, gul, qne</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 1.5.2<br>Chinese: -biau|jun<br>Latin: regula<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">manner, way</td>
                <td data-label="Phon">uai</td>
                <td data-label="Definition">(vo) X1@ is the way or manner in which activity (vo) X2+ is done</td>
                <td data-label="Comments">Typically used as an argument; otherwise, just apply the X1 predicate to X2.</td>
                <td data-label="Xref">fma, jrm</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 1.5.2, 1.5.6<br>Chinese: !iaw.-dz<br>Latin: mod.us<br>Loglan: forma</td>
            </tr>

            <tr>
                <td data-label="Word">bal</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">likely, probable, consequence</td>
                <td data-label="Phon">laikli</td>
                <td data-label="Definition">If antecedent (vo) X1@ happens, it is likely that consequence (vo) X2+ also will</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">spo, zba</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 1.5.3<br>Chinese: /ie|qu<br>Latin: probabyl.ys<br>Loglan: dakli</td>
            </tr>

            <tr>
                <td data-label="Word">kau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">cause, consequence</td>
                <td data-label="Phon">kauz</td>
                <td data-label="Definition">Antecedent (vo) X1@ causes consequence (vo) X2+</td>
                <td data-label="Comments">Cause is mechanical.  Use -kmo for motivation.</td>
                <td data-label="Xref">qma, kmo, sny, psm</td>
                <td data-label="Notes">Rank: 11<br>Thes: 1.1.6, 1.5.3<br>Chinese: |qr<br>Latin: fak.ere<br>Loglan: ckozu</td>
            </tr>

            <tr>
                <td data-label="Word">kmo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">motivation, motive</td>
                <td data-label="Phon">motiv</td>
                <td data-label="Definition">Antecedent (vo) X1@ is a motivation for consequence (vo) X2+</td>
                <td data-label="Comments">Buried in X2 is an actor with free will, and X1 induces him to choose to act.</td>
                <td data-label="Xref">kau</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 1.5.3<br>Chinese: |li/iou<br>Latin: kausa<br>Loglan: modvi</td>
            </tr>

            <tr>
                <td data-label="Word">syl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">purpose, act</td>
                <td data-label="Phon">purp#s</td>
                <td data-label="Definition">(vo) X1@ is the purpose for which actor X2 does action (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 1.5.3<br>Chinese: !mu-di<br>Latin: konsyly.um<br>Loglan: zukte*</td>
            </tr>

            <tr>
                <td data-label="Word">zni</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">reason, because</td>
                <td data-label="Phon">riz#n</td>
                <td data-label="Definition">Antecedent (vo) X1+ is done because of consequence (vo) X2@</td>
                <td data-label="Comments">X2 is a consequence of X1 that motivates someone to do X1 thereby causing X2.  Don&#x27;t state X2 negatively.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 8<br>Thes: 1.1.6, 1.5.3<br>Chinese: /uan-in<br>Latin: kausa<br>Loglan: raznu</td>
            </tr>

            <tr>
                <td data-label="Word">pse</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">process, stage</td>
                <td data-label="Phon">prases</td>
                <td data-label="Definition">Process X1 proceeds through list of stages (xy) X2s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sur</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 2.4.8<br>Chinese: -faw|fa<br>Latin: rat.yo<br>Loglan: prase</td>
            </tr>

            <tr>
                <td data-label="Word">qin</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">event, argument</td>
                <td data-label="Phon">ivent</td>
                <td data-label="Definition">(vo) X1 is an event having argument X2 in some case</td>
                <td data-label="Comments">-zu -qin for argument; -zu -qin |pa for a numbered case.</td>
                <td data-label="Xref">gna, tua, dlmo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 3.4.3, 1.5.6, 4.4.6<br>Chinese: !qr!jian<br>Latin: fakt.um<br>Loglan: vetci</td>
            </tr>

            <tr>
                <td data-label="Word">tso</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">error</td>
                <td data-label="Phon">er#r</td>
                <td data-label="Definition">(vo) X1 is an error</td>
                <td data-label="Comments">|fta for the standard.</td>
                <td data-label="Xref">dve, sfa, go</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 3.7.4<br>Chinese: !tsuo!u<br>Latin: eror<br>Loglan: tsero</td>
            </tr>

            <tr>
                <td data-label="Word">sar</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">necessary, condition</td>
                <td data-label="Phon">nesesari</td>
                <td data-label="Definition">Antecedent (vo) X1@ is a necessary condition for consequence (vo) X2+ to occur</td>
                <td data-label="Comments">Use -bni for X1 needs to do X2.</td>
                <td data-label="Xref">sno, bni, spo, xen</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 3.7.4, 1.5.3<br>Chinese: !bi-siu<br>Latin: nekesary.us<br>Loglan: nerbi</td>
            </tr>

            <tr>
                <td data-label="Word">sno</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">sufficient, condition</td>
                <td data-label="Phon">s#fyqnt</td>
                <td data-label="Definition">Antecedent (vo) X1@ is a sufficient condition for consequence (vo) X2+ to occur</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">bni, sar, gou, zuy, guo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 3.7.4, 1.5.3<br>Chinese: /dzu!gou<br>Latin: sat.ys<br>Loglan: tsufi</td>
            </tr>

            <tr>
                <td data-label="Word">qiw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">condition, state, status</td>
                <td data-label="Phon">k#ndyqn</td>
                <td data-label="Definition">Activity (vo) X1+3@ is done under condition (vo) X2+3 by actor X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kaw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 1.5.3<br>Chinese: /ciw-qiw<br>Latin: stat.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sny</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">logic, imply, entail</td>
                <td data-label="Phon">ymplai</td>
                <td data-label="Definition">Antecedent (vo) X1@ logically entails consequence (vo) X2+</td>
                <td data-label="Comments">For definitions and theorems; use -kau for causation.  |sya for axioms, |qre for rules of logic.</td>
                <td data-label="Xref">zny, kau</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.6, 3.7.4, 1.5.3<br>Chinese: /han!iy<br>Latin: sygnyfyk.are<br>Loglan: snola</td>
            </tr>

            <tr>
                <td data-label="Word">117</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Relations about a Quality</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fto</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">very, more, such, particularly, fairly</td>
                <td data-label="Phon">suc</td>
                <td data-label="Definition">X1: is more than usual or expected in dimension (vo) X2+1, S3 for members of set (xy) X3s</td>
                <td data-label="Comments">|fta for the standard.  -gl -fto means fairly, i.e. at the high end of the usual range.</td>
                <td data-label="Xref">vdu, pql</td>
                <td data-label="Notes">Rank: 14<br>Thes: 1.1.7<br>Chinese: /ru|tz#<br>Latin: tot<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">guo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">excess</td>
                <td data-label="Phon">ekses</td>
                <td data-label="Definition">X1:! is more than enough for consequence (vo) X2+1@ in dimension (vo) X3+1</td>
                <td data-label="Comments">Not necessarily a bad thing.</td>
                <td data-label="Xref">sno</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7<br>Chinese: !guo!du<br>Latin: nim.ys<br>Loglan: tsufi</td>
            </tr>

            <tr>
                <td data-label="Word">gou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">enough</td>
                <td data-label="Phon">in#f</td>
                <td data-label="Definition">X1:! is sufficient for consequence (vo) X2+1@ in dimension (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sno, zuy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7<br>Chinese: /dzu!gou<br>Latin: sat.ys<br>Loglan: tsufi</td>
            </tr>

            <tr>
                <td data-label="Word">jmo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">almost, quite, barely</td>
                <td data-label="Phon">almost</td>
                <td data-label="Definition">X1:! is not quite sufficient for consequence (vo) X2+1@? in dimension (vo) X3+1</td>
                <td data-label="Comments">Default X2 is ``to qualify as X3+1&#x27;&#x27;, e.g. ``almost cooked&#x27;&#x27;.  -gr-jmo means barely.</td>
                <td data-label="Xref">gou</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7<br>Chinese: -ji-#u<br>Latin: paene<br>Loglan: cnire</td>
            </tr>

            <tr>
                <td data-label="Word">pql</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">only, less, just, somewhat</td>
                <td data-label="Phon">les</td>
                <td data-label="Definition">X1: is less than usual or expected in dimension (vo) X2+1, S3 for members of set (xy) X3s</td>
                <td data-label="Comments">|fta for the standard.  -gl -pql means somewhat, i.e. low end of usual range.</td>
                <td data-label="Xref">pqu, fto</td>
                <td data-label="Notes">Rank: 11<br>Thes: 1.1.7<br>Chinese: |jr!qr<br>Latin: tant.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vju</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">accurate, precise</td>
                <td data-label="Phon">akiur#t</td>
                <td data-label="Definition">(vo) X1: is accurate</td>
                <td data-label="Comments">|pa for how accurate, same units as X1.  Use -vju |slr !sa -pa for precision in ratio units.  Use -za -qne for valid. </td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7<br>Chinese: -jiw!mi<br>Latin: verus<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zua</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">lack</td>
                <td data-label="Phon">lak</td>
                <td data-label="Definition">X1: lacks, has no (xa) X2:*</td>
                <td data-label="Comments">Use for objects and servings.</td>
                <td data-label="Xref">kio, xno, fpw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7<br>Chinese: !bu/dzu<br>Latin: kar.ere<br>Loglan: clesi</td>
            </tr>

            <tr>
                <td data-label="Word">zuy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">insufficient</td>
                <td data-label="Phon">ynsufyqnt</td>
                <td data-label="Definition">X1:! is insufficient for consequence (vo) X2+1@ in dimension (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sno, gou</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7<br>Chinese: !bu/dzu<br>Latin: par.um<br>Loglan: tsufi</td>
            </tr>

            <tr>
                <td data-label="Word">gvr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">regular, uniform, homogeneous</td>
                <td data-label="Phon">regiulr</td>
                <td data-label="Definition">Set (xy) X1s is regular or uniform in property (vo) X2+S1</td>
                <td data-label="Comments">Members of X1 fit X2 to about the same degree.  If X1 is not obviously a set, consider its parts.</td>
                <td data-label="Xref">qkl, kym</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7, 1.3.2<br>Chinese: |iou!jr-su<br>Latin: kert.us<br>Loglan: vitci*</td>
            </tr>

            <tr>
                <td data-label="Word">qkl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">irregular, nonuniform</td>
                <td data-label="Phon">yrregular</td>
                <td data-label="Definition">Set (xy) X1s is irregular or nonuniform in property (vo) X2+S1</td>
                <td data-label="Comments">If X1 is not obviously a set, consider its parts.</td>
                <td data-label="Xref">gvr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7, 1.3.2<br>Chinese: !bu|jew/ci<br>Latin: ynaekual.ys<br>Loglan: vitci*</td>
            </tr>

            <tr>
                <td data-label="Word">vdw</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">miscellaneous</td>
                <td data-label="Phon">myselani#s</td>
                <td data-label="Definition">Set (xy) X1s is miscellaneous in property (vo) X2+S1</td>
                <td data-label="Comments">Does not fit in obvious groupings by that property.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7, 1.3.2<br>Chinese: |dza!qiaw<br>Latin: vary.us<br>Loglan: vrici*</td>
            </tr>

            <tr>
                <td data-label="Word">kun</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">degree, quantity, amount</td>
                <td data-label="Phon">#maunt</td>
                <td data-label="Definition">X1: IEC the amount, degree or quantity of (vo) X2:+</td>
                <td data-label="Comments">For a predicate V for which |pa specifies some amount, -kun -V can recover that amount.</td>
                <td data-label="Xref">tme, ful</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7, 1.5.6<br>Chinese: !liaw<br>Latin: alykuot<br>Loglan: kanli</td>
            </tr>

            <tr>
                <td data-label="Word">tua</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">quality</td>
                <td data-label="Phon">kualyti</td>
                <td data-label="Definition">(vo) X1+2 is a quality that X2: has</td>
                <td data-label="Comments">Use -sym or -gre for ``high quality&#x27;&#x27;.  Note unusual case merge.</td>
                <td data-label="Xref">qin, gre, sym</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.7, 1.5.6<br>Chinese: -pin/jr<br>Latin: natura<br>Loglan: katli</td>
            </tr>

            <tr>
                <td data-label="Word">118</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Miscellaneous Relations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cun</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">connect</td>
                <td data-label="Phon">kunekt</td>
                <td data-label="Definition">Part X1 connects to part X2 of system X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fen</td>
                <td data-label="Notes">Rank: 11<br>Thes: 1.1.8<br>Chinese: !cuan<br>Latin: adlyg.are<br>Loglan: djine</td>
            </tr>

            <tr>
                <td data-label="Word">pry</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">relevant, pertinent</td>
                <td data-label="Phon">prtynent</td>
                <td data-label="Definition">X1: is pertinent or relevant to affair (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zey</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8<br>Chinese: |qu/u<br>Latin: pertyn.ere<br>Loglan: perti</td>
            </tr>

            <tr>
                <td data-label="Word">stm</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">problem</td>
                <td data-label="Phon">prablem</td>
                <td data-label="Definition">(bi) X1 is a problem on the subject (vo) X2!</td>
                <td data-label="Comments">A question for students to answer, thereby to learn.</td>
                <td data-label="Xref">xue, pon</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8<br>Chinese: !uen/ti<br>Latin: kuaest.yo<br>Loglan: nable</td>
            </tr>

            <tr>
                <td data-label="Word">kaw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">state, status, situation, condition</td>
                <td data-label="Phon">k#ndyqn</td>
                <td data-label="Definition">Object X1 has the status (vo) X2+1</td>
                <td data-label="Comments">X2 is a phrase about X1, typically showing its progress in some process or its readiness for operation.</td>
                <td data-label="Xref">qiw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8, 1.5.6<br>Chinese: /ciw!kuaw<br>Latin: stat.us<br>Loglan: tcini*</td>
            </tr>

            <tr>
                <td data-label="Word">qno</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">serving, portion, piece</td>
                <td data-label="Phon">porqn</td>
                <td data-label="Definition">X1 is a serving/portion of substance (xo) X2*</td>
                <td data-label="Comments">Use container word (4.1.1, 4.1.2) to express quantity, or put a unit predicate on the serving.</td>
                <td data-label="Xref">qka</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8, 1.5.6<br>Chinese: !fen<br>Latin: pars<br>Loglan: canli</td>
            </tr>

            <tr>
                <td data-label="Word">znu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">all, common</td>
                <td data-label="Phon">al</td>
                <td data-label="Definition">All (xy) X1:s members fit the first case of property (vo) X2+S1</td>
                <td data-label="Comments">Emphasizing that X2 is a common property of X1 members.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8, 1.5.6<br>Chinese: !uan!u<br>Latin: omn.ys<br>Loglan: kumtu</td>
            </tr>

            <tr>
                <td data-label="Word">cfa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">event, occur</td>
                <td data-label="Phon">ivent</td>
                <td data-label="Definition">(vo) X1 occurs</td>
                <td data-label="Comments">Or: X1 is an event.  </td>
                <td data-label="Xref">qyn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8, 1.5.6, 4.4.6<br>Chinese: -fa-qew<br>Latin: fakt.um<br>Loglan: venci</td>
            </tr>

            <tr>
                <td data-label="Word">stw</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">real, exist</td>
                <td data-label="Phon">eksyst</td>
                <td data-label="Definition">X1 exists in reality</td>
                <td data-label="Comments">|sen for the experiencer.  It is very hard to authoritatively assert -stw.  Instead assert that you believe it (-cre or -xou) or that it is a fact (-qkr).</td>
                <td data-label="Xref">qkr, dve</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8, 3.4.3, 3.7.4<br>Chinese: /tsun!dzai<br>Latin: ekst.are<br>Loglan: dzabi</td>
            </tr>

            <tr>
                <td data-label="Word">xor</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">metaphor</td>
                <td data-label="Phon">metafor</td>
                <td data-label="Definition">X1: its qualities are represented as a metaphor X2 in dimension (vo) X3+1, 2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">smy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8, 4.4.5<br>Chinese: |bi!u<br>Latin: translat.yo<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gne</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">compatible, fit</td>
                <td data-label="Phon">fyt</td>
                <td data-label="Definition">X1: fits with X2: in relation (vo) X3+1-2</td>
                <td data-label="Comments">X3 is a relation between X1 and X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.1.8, 4.4.6<br>Chinese: /he!shr<br>Latin: kongruens<br>Loglan: mapti*</td>
            </tr>

            <tr>
                <td data-label="Word">120</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">General Properties  </td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">121</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Noncomparative Properties</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">brn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">broken</td>
                <td data-label="Phon">brokn</td>
                <td data-label="Definition">X1 is broken</td>
                <td data-label="Comments">In pieces.  Use -gr -pwo -sao for ``cannot operate&#x27;&#x27;. </td>
                <td data-label="Xref">bro</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1<br>Chinese: !nuw!puo<br>Latin: frang.us<br>Loglan: broda</td>
            </tr>

            <tr>
                <td data-label="Word">dae</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">open</td>
                <td data-label="Phon">open</td>
                <td data-label="Definition">X1 is open</td>
                <td data-label="Comments">Things can go in and out of interior.</td>
                <td data-label="Xref">klo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1<br>Chinese: |da-kai.-de<br>Latin: apert.us<br>Loglan: kapni</td>
            </tr>

            <tr>
                <td data-label="Word">gve</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">poison</td>
                <td data-label="Phon">poiz#n</td>
                <td data-label="Definition">X1 is poisonous to potential victims (xi) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1<br>Chinese: /du<br>Latin: venen.um<br>Loglan: vendu</td>
            </tr>

            <tr>
                <td data-label="Word">klo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">close</td>
                <td data-label="Phon">klos</td>
                <td data-label="Definition">X1 is closed</td>
                <td data-label="Comments">Things cannot go in and out of the interior.</td>
                <td data-label="Xref">tao, dae</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1<br>Chinese: -guan<br>Latin: klaudy<br>Loglan: klogu</td>
            </tr>

            <tr>
                <td data-label="Word">pro</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">private</td>
                <td data-label="Phon">praiv#t</td>
                <td data-label="Definition">X1 is private to person X2*</td>
                <td data-label="Comments">|tue for the culture.</td>
                <td data-label="Xref">bly</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1<br>Chinese: -sz/ren<br>Latin: propry.us<br>Loglan: prizi</td>
            </tr>

            <tr>
                <td data-label="Word">qum</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">wet</td>
                <td data-label="Phon">uet</td>
                <td data-label="Definition">X1 is wet with liquid (xo) X2*</td>
                <td data-label="Comments">Typically water.</td>
                <td data-label="Xref">ksy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: -qr<br>Latin: umid.us<br>Loglan: cetlo</td>
            </tr>

            <tr>
                <td data-label="Word">xen</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">clear</td>
                <td data-label="Phon">klir</td>
                <td data-label="Definition">X1 is clear for event (vo) X2+ to happen</td>
                <td data-label="Comments">Makes no obstacle.  Necessary conditions for X2 about X1, typically being empty, are true.</td>
                <td data-label="Xref">sar, sir</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1<br>Chinese: -kon-jien<br>Latin: exped.yre<br>Loglan: klina*</td>
            </tr>

            <tr>
                <td data-label="Word">xym</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">immune, prevent, disease, fault, vaccine</td>
                <td data-label="Phon">ymiun</td>
                <td data-label="Definition">X1: is immune to disease or fault (vo) X2+1 due to preventive action (vo) X3+1@!</td>
                <td data-label="Comments">For vaccine V, let X3 be -za ^taw -xyn !V (inject V).</td>
                <td data-label="Xref">kme</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1, 2.1.3<br>Chinese: |mien!i<br>Latin: ymun.ys<br>Loglan: vaksi</td>
            </tr>

            <tr>
                <td data-label="Word">qtu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">dead</td>
                <td data-label="Phon">ded</td>
                <td data-label="Definition">X1 is dead</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.1, 2.4.1<br>Chinese: |sz<br>Latin: mortu.#s<br>Loglan: morto</td>
            </tr>

            <tr>
                <td data-label="Word">122</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Properties of Perfection</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fpe</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">perfect</td>
                <td data-label="Phon">perfekt</td>
                <td data-label="Definition">X1 is perfect</td>
                <td data-label="Comments">Has no flaws, cannot be changed to match its standard better.  |fta for the standard.</td>
                <td data-label="Xref">scu</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.2<br>Chinese: /uan|mei<br>Latin: absolut.us<br>Loglan: purfe</td>
            </tr>

            <tr>
                <td data-label="Word">scu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">complete</td>
                <td data-label="Phon">kumplit</td>
                <td data-label="Definition">(vo) X1+ is complete</td>
                <td data-label="Comments">|fta for the standard.</td>
                <td data-label="Xref">fpe</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.2<br>Chinese: /uan/ciuan<br>Latin: absolut.us<br>Loglan: kapli</td>
            </tr>

            <tr>
                <td data-label="Word">123</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">How an Activity is Done</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fru</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">weak</td>
                <td data-label="Phon">uik</td>
                <td data-label="Definition">X1: is weak in activity (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vaw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: |ruan!ruo<br>Latin: ynfyrm.us<br>Loglan: fibru</td>
            </tr>

            <tr>
                <td data-label="Word">gla</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">lazy</td>
                <td data-label="Phon">laizi</td>
                <td data-label="Definition">X1: is lazy about activity (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: |lan!duo<br>Latin: pyger<br>Loglan: lazni*</td>
            </tr>

            <tr>
                <td data-label="Word">gli</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">care</td>
                <td data-label="Phon">kar</td>
                <td data-label="Definition">X1: does activity (vo) X2+1 carefully</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vra, kar</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: /liou-sin<br>Latin: dilygens<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ker</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">crazy, mad, insane</td>
                <td data-label="Phon">krazi</td>
                <td data-label="Definition">X1: is crazy to do activity (vo) X2+1</td>
                <td data-label="Comments">|ciw for holder of opinion.</td>
                <td data-label="Xref">ksa, tul, smi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: -few/kuaw<br>Latin: kerit.us<br>Loglan: fenki*</td>
            </tr>

            <tr>
                <td data-label="Word">klm</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">clumsy</td>
                <td data-label="Phon">klumsi</td>
                <td data-label="Definition">X1: is clumsy doing activity (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: !ben<br>Latin: ynept.us<br>Loglan: juxre*</td>
            </tr>

            <tr>
                <td data-label="Word">kly</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">difficult, hard</td>
                <td data-label="Phon">dyfyk#lt</td>
                <td data-label="Definition">Actor X1 does activity (vo) X2+1 with difficulty</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kyl</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: !ku#/nan<br>Latin: vikx<br>Loglan: nardu</td>
            </tr>

            <tr>
                <td data-label="Word">kua</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fast, quick</td>
                <td data-label="Phon">fast</td>
                <td data-label="Definition">X1: is faster than usual in activity (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">slo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: !kuai<br>Latin: keler<br>Loglan: kukra</td>
            </tr>

            <tr>
                <td data-label="Word">kyl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">easy</td>
                <td data-label="Phon">izi</td>
                <td data-label="Definition">X1: does activity (vo) X2+1 easily</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kly</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: /ruw-i<br>Latin: fakyl.ys<br>Loglan: fasru</td>
            </tr>

            <tr>
                <td data-label="Word">slo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">slow</td>
                <td data-label="Phon">slo</td>
                <td data-label="Definition">X1: is slower than usual in activity (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kua</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: !man<br>Latin: tard.us<br>Loglan: slano</td>
            </tr>

            <tr>
                <td data-label="Word">smi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">wise</td>
                <td data-label="Phon">uaiz</td>
                <td data-label="Definition">X1: is wise about affair (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">ker, pew, tul</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: -tsuw-miw<br>Latin: sapyens<br>Loglan: sadji</td>
            </tr>

            <tr>
                <td data-label="Word">tul</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fool, dumb, stupid</td>
                <td data-label="Phon">ful</td>
                <td data-label="Definition">X1: is foolish to do activity (vo) X2+1</td>
                <td data-label="Comments">|ciw for holder of opinion.</td>
                <td data-label="Xref">ker, smi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: !u/ren<br>Latin: stult.us<br>Loglan: bunbo</td>
            </tr>

            <tr>
                <td data-label="Word">vaw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">strong</td>
                <td data-label="Phon">strow</td>
                <td data-label="Definition">X1: is strong in activity (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fru</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: /ciaw!juaw<br>Latin: valyd.us<br>Loglan: fotli</td>
            </tr>

            <tr>
                <td data-label="Word">vme</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">violent</td>
                <td data-label="Phon">vaiolnt</td>
                <td data-label="Definition">X1: does activity (vo) X2+1 violently</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zen</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: |m#w!lie<br>Latin: vehemens<br>Loglan: valna</td>
            </tr>

            <tr>
                <td data-label="Word">vra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">serious, care</td>
                <td data-label="Phon">siri#s</td>
                <td data-label="Definition">X1: does activity (vo) X2+1 seriously</td>
                <td data-label="Comments">Takes extra care, does not give it up.  For a serious affair, use -zu -vra.</td>
                <td data-label="Xref">gli</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: /ian!juw<br>Latin: grav.ys<br>Loglan: srisu</td>
            </tr>

            <tr>
                <td data-label="Word">zen</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">gentle</td>
                <td data-label="Phon">jentl</td>
                <td data-label="Definition">X1: does activity (vo) X2+1 gently</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vme</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3<br>Chinese: /uen|ia<br>Latin: len.ys<br>Loglan: mildo</td>
            </tr>

            <tr>
                <td data-label="Word">fmu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">famous, fan</td>
                <td data-label="Phon">famus</td>
                <td data-label="Definition">X1: is famous for activity (vo) X2+1 among fans (xy) X3s</td>
                <td data-label="Comments">-zu -fmu for a famous event.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3, 2.1.4<br>Chinese: /miw!u<br>Latin: praeklar.us<br>Loglan: famva</td>
            </tr>

            <tr>
                <td data-label="Word">saw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hide, secret</td>
                <td data-label="Phon">haid</td>
                <td data-label="Definition">X1: hides secret (vo) X2+1 from X3:</td>
                <td data-label="Comments">To hide an object, be sure to use -vn to cancel -vo.</td>
                <td data-label="Xref">bzo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3, 2.1.4<br>Chinese: /tsaw<br>Latin: abd.ere<br>Loglan: smike</td>
            </tr>

            <tr>
                <td data-label="Word">fei</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">tired</td>
                <td data-label="Phon">taird</td>
                <td data-label="Definition">X1: is tired from activity (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.3, 2.5.2<br>Chinese: /pi/fa<br>Latin: fes.us<br>Loglan: tarle</td>
            </tr>

            <tr>
                <td data-label="Word">124</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Opinions and Emotional Properties</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bly</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">public</td>
                <td data-label="Phon">p#blyk</td>
                <td data-label="Definition">X1 is public</td>
                <td data-label="Comments">Accessible to all people.  |tue for the culture.</td>
                <td data-label="Xref">pro</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: -guw!guw<br>Latin: komun.ys<br>Loglan: publi</td>
            </tr>

            <tr>
                <td data-label="Word">spe</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">precious</td>
                <td data-label="Phon">preq#s</td>
                <td data-label="Definition">X1 is precious</td>
                <td data-label="Comments">|gae for who feels emotion.  A subjective judgement.</td>
                <td data-label="Xref">val</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: |bau!guei<br>Latin: pretyos.us<br>Loglan: dipri</td>
            </tr>

            <tr>
                <td data-label="Word">fpl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">beautiful</td>
                <td data-label="Phon">biutyful</td>
                <td data-label="Definition">X1 is beautiful</td>
                <td data-label="Comments">|ciw for the experiencer.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: !piau-liaw<br>Latin: pulker<br>Loglan: bilti</td>
            </tr>

            <tr>
                <td data-label="Word">kfo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">comfortable</td>
                <td data-label="Phon">komfortabl</td>
                <td data-label="Definition">X1 is comfortable</td>
                <td data-label="Comments">|ciw for experiencer.  Example: comfortable bed.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: -qu-fu<br>Latin: komod.us<br>Loglan: komfu</td>
            </tr>

            <tr>
                <td data-label="Word">kqn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">funny</td>
                <td data-label="Phon">f#ni</td>
                <td data-label="Definition">(vo) X1 is funny</td>
                <td data-label="Comments">|gae for experiencer.</td>
                <td data-label="Xref">qya, fry</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: -huan!le<br>Latin: rydykul.ys<br>Loglan: kamki</td>
            </tr>

            <tr>
                <td data-label="Word">ksa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">sane</td>
                <td data-label="Phon">sain</td>
                <td data-label="Definition">X1 is sane</td>
                <td data-label="Comments">|ciw for the one who thinks so.</td>
                <td data-label="Xref">ker</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: |uen!jian<br>Latin: san.us<br>Loglan: xrali*</td>
            </tr>

            <tr>
                <td data-label="Word">ksr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">harmony</td>
                <td data-label="Phon">harm#ni</td>
                <td data-label="Definition">(vo) X1 is harmonious</td>
                <td data-label="Comments">|ciw for experiencer.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: /i!jr<br>Latin: konkors<br>Loglan: harmo</td>
            </tr>

            <tr>
                <td data-label="Word">ksu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">delicious</td>
                <td data-label="Phon">dilyq#s</td>
                <td data-label="Definition">X1 is delicious</td>
                <td data-label="Comments">|ciw for experiencer.  In the sense of food.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: |mei!uei<br>Latin: suav.ys<br>Loglan: dilko</td>
            </tr>

            <tr>
                <td data-label="Word">psn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">novel, new</td>
                <td data-label="Phon">nu</td>
                <td data-label="Definition">X1 is new, novel in aspect (vo) X2+1</td>
                <td data-label="Comments">|ciw for the experiencer.  Use -ksi for fresh or unused.</td>
                <td data-label="Xref">psw, ksi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: -sin<br>Latin: nov.us<br>Loglan: cninu</td>
            </tr>

            <tr>
                <td data-label="Word">psw</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">ordinary</td>
                <td data-label="Phon">ordynari</td>
                <td data-label="Definition">X1 is ordinary in aspect (vo) X2+1</td>
                <td data-label="Comments">|ciw for experiencer.</td>
                <td data-label="Xref">psn, csn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: |pu-tuw<br>Latin: usytat.us<br>Loglan: danri</td>
            </tr>

            <tr>
                <td data-label="Word">val</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">value</td>
                <td data-label="Phon">valiu</td>
                <td data-label="Definition">X1: values X2:*</td>
                <td data-label="Comments">X1 has a static, quantitative opinion.  Use modal unit to say how much.</td>
                <td data-label="Xref">spe, sri</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: -gu!jia<br>Latin: aestym.are<br>Loglan: vatli</td>
            </tr>

            <tr>
                <td data-label="Word">cfi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">neat</td>
                <td data-label="Phon">nit</td>
                <td data-label="Definition">X1 is neat</td>
                <td data-label="Comments">Typically a system of neatly organized parts but can be a process.  |ciw for holder of opinion.  Use -vgn for clean.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: |jew/ci<br>Latin: <br>Loglan: nitci</td>
            </tr>

            <tr>
                <td data-label="Word">zgr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">great</td>
                <td data-label="Phon">grait</td>
                <td data-label="Definition">X1 is great, accomplished much in dimension (vo) X2+1</td>
                <td data-label="Comments">Being looked up to, accomplishment, not size.  |ciw for who holds the opinion, |fta for standard.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4<br>Chinese: |uei!da<br>Latin: grand.ys<br>Loglan: grada</td>
            </tr>

            <tr>
                <td data-label="Word">fpo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">unimportant, by~the~way</td>
                <td data-label="Phon">#nymportnt</td>
                <td data-label="Definition">X1 is unimportant in dimension (vo) X2+1</td>
                <td data-label="Comments">|ciw for holder of opinion.  -vi -zo -fpo means ``by the way&#x27;&#x27;.</td>
                <td data-label="Xref">tfn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4, 1.5.5<br>Chinese: /bu!juw!iau<br>Latin: lev.is<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">csn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">strange</td>
                <td data-label="Phon">strainj</td>
                <td data-label="Definition">X1 is strange</td>
                <td data-label="Comments">Not ordinary.  |ciw for experiencer.</td>
                <td data-label="Xref">psw, zgn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4, 1.5.5<br>Chinese: /ci!guai<br>Latin: ynsolyt.us<br>Loglan: gutra</td>
            </tr>

            <tr>
                <td data-label="Word">tfn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">important</td>
                <td data-label="Phon">ymportnt</td>
                <td data-label="Definition">X1 is important in dimension (vo) X2+1</td>
                <td data-label="Comments">|ciw for holder of opinion.</td>
                <td data-label="Xref">fpo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4, 1.5.5<br>Chinese: !iau|jin<br>Latin: moment.um<br>Loglan: djipo</td>
            </tr>

            <tr>
                <td data-label="Word">tsu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">sudden</td>
                <td data-label="Phon">s#dn</td>
                <td data-label="Definition">(vo) X1 is sudden</td>
                <td data-label="Comments">|sen for experiencer.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4, 1.5.5<br>Chinese: -hu/ran<br>Latin: subyt.us<br>Loglan: sudna</td>
            </tr>

            <tr>
                <td data-label="Word">zgn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">alien</td>
                <td data-label="Phon">alien</td>
                <td data-label="Definition">X1 is alien, not a member of the local culture</td>
                <td data-label="Comments">|ciw for experiencer (feelings of alienation are not objective).</td>
                <td data-label="Xref">spi, csn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.4, 4.7.1<br>Chinese: !uay/guo<br>Latin: peregryn.us<br>Loglan: fange*</td>
            </tr>

            <tr>
                <td data-label="Word">125</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Miscellaneous Properties</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dvn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">good</td>
                <td data-label="Phon">g#d</td>
                <td data-label="Definition">X1 is good for purpose (vo) X2+1</td>
                <td data-label="Comments">|ciw for holder of opinion.</td>
                <td data-label="Xref">stu, vdo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5<br>Chinese: -iou|dian<br>Latin: bon.us<br>Loglan: gudbi</td>
            </tr>

            <tr>
                <td data-label="Word">dvy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">wealthy</td>
                <td data-label="Phon">uelti</td>
                <td data-label="Definition">X1 is wealthy in kind of wealth (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">spu</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5<br>Chinese: /cian/tsai<br>Latin: dyv.es<br>Loglan: fulri</td>
            </tr>

            <tr>
                <td data-label="Word">bzi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">tight</td>
                <td data-label="Phon">tait</td>
                <td data-label="Definition">X1: is tight on or around X2:*</td>
                <td data-label="Comments">Not for absence of leaks.</td>
                <td data-label="Xref">ksw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5<br>Chinese: |jin<br>Latin: strikt.us<br>Loglan: djitu</td>
            </tr>

            <tr>
                <td data-label="Word">psi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">evil</td>
                <td data-label="Phon">ivyl</td>
                <td data-label="Definition">X1 is evil</td>
                <td data-label="Comments">X1 does things that motivate people to hate it (q.v.)  |ciw for holder of opinion.</td>
                <td data-label="Xref">stu, vdo, xai</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5<br>Chinese: /sie!e<br>Latin: mal.us<br>Loglan: palci*</td>
            </tr>

            <tr>
                <td data-label="Word">spu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">poor</td>
                <td data-label="Phon">pur</td>
                <td data-label="Definition">X1 is poor in kind of wealth (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">dvy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5<br>Chinese: !pin/ciuw<br>Latin: pauper<br>Loglan: purcu</td>
            </tr>

            <tr>
                <td data-label="Word">stu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">unsuitable, bad</td>
                <td data-label="Phon">bad</td>
                <td data-label="Definition">X1 is bad, unsuitable for purpose (vo) X2+1</td>
                <td data-label="Comments">|ciw for holder of opinion.  Use |psi for evil.</td>
                <td data-label="Xref">dvn, psi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5<br>Chinese: !huai<br>Latin: turp.ys<br>Loglan: zavlo</td>
            </tr>

            <tr>
                <td data-label="Word">vdo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">good</td>
                <td data-label="Phon">gud</td>
                <td data-label="Definition">X1 is good</td>
                <td data-label="Comments">Opposite of evil.  |ciw for holder of opinion.</td>
                <td data-label="Xref">stu</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5<br>Chinese: !qa!ne<br>Latin: prob.us<br>Loglan: gudbi</td>
            </tr>

            <tr>
                <td data-label="Word">tfo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">brave</td>
                <td data-label="Phon">brav</td>
                <td data-label="Definition">X1 is brave in danger (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5, 2.1.3<br>Chinese: |iuw|gan<br>Latin: fort.ys<br>Loglan: briga</td>
            </tr>

            <tr>
                <td data-label="Word">qnr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">concentrate, dense</td>
                <td data-label="Phon">kansentraqn</td>
                <td data-label="Definition">X1 is a concentrated occupant of territory X2*</td>
                <td data-label="Comments">Includes dense population and concentrated solutions.</td>
                <td data-label="Xref">spn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.2.5, 3.6.1<br>Chinese: /ji-juw<br>Latin: <br>Loglan: -</td>
            </tr>

            <tr>
                <td data-label="Word">130</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Objective Properties</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">131</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Size and Shape</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Use |vrl for a reference frame to interpret horizontal and vertical properties.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bzy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">thin</td>
                <td data-label="Phon">tyn</td>
                <td data-label="Definition">X1 is thin</td>
                <td data-label="Comments">Smallest dimension is much smaller than other(s).</td>
                <td data-label="Xref">kqo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: /buo<br>Latin: grakyl.ys<br>Loglan: linco</td>
            </tr>

            <tr>
                <td data-label="Word">fpn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">deep</td>
                <td data-label="Phon">dip</td>
                <td data-label="Definition">X1 is deep</td>
                <td data-label="Comments">Extends far down.  Not for ``far from entrance&#x27;&#x27; unless entrance is at the top.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: -qen<br>Latin: profund.#s<br>Loglan: condi</td>
            </tr>

            <tr>
                <td data-label="Word">gvn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">narrow</td>
                <td data-label="Phon">nero</td>
                <td data-label="Definition">X1 is narrow</td>
                <td data-label="Comments">Horizontal dimension is much less than the other(s).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: |jai<br>Latin: angust.us<br>Loglan: janro</td>
            </tr>

            <tr>
                <td data-label="Word">jin</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">point, vertex</td>
                <td data-label="Phon">point</td>
                <td data-label="Definition">X1 is a point of shape X2*</td>
                <td data-label="Comments">``Pointed&#x27;&#x27;.  An acute vertex, like the point of a knife.</td>
                <td data-label="Xref">qku, zdi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: -jien-duan<br>Latin: akumen<br>Loglan: penta</td>
            </tr>

            <tr>
                <td data-label="Word">kqa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">big</td>
                <td data-label="Phon">byg</td>
                <td data-label="Definition">X1 is big</td>
                <td data-label="Comments">Neutral connotation.</td>
                <td data-label="Xref">tfa</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: !da<br>Latin: magn.us<br>Loglan: groda</td>
            </tr>

            <tr>
                <td data-label="Word">kqo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">thick</td>
                <td data-label="Phon">tyk</td>
                <td data-label="Definition">X1 is thick</td>
                <td data-label="Comments">Smallest dimension is large relative to the others.</td>
                <td data-label="Xref">bzy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: !hou<br>Latin: kras.us<br>Loglan: totnu</td>
            </tr>

            <tr>
                <td data-label="Word">pqo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">short</td>
                <td data-label="Phon">qort</td>
                <td data-label="Definition">X1 is short</td>
                <td data-label="Comments">Longest dimension is not very big.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: |duan<br>Latin: brev.ys<br>Loglan: corta</td>
            </tr>

            <tr>
                <td data-label="Word">spl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">small</td>
                <td data-label="Phon">smal</td>
                <td data-label="Definition">X1 is small</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: |siau<br>Latin: parv.us<br>Loglan: cmalo</td>
            </tr>

            <tr>
                <td data-label="Word">bzu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">broad</td>
                <td data-label="Phon">brad</td>
                <td data-label="Definition">X1 is broad</td>
                <td data-label="Comments">2nd largest dimension is almost as large as the biggest.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: -kuan<br>Latin: lat.us<br>Loglan: kubra</td>
            </tr>

            <tr>
                <td data-label="Word">vbn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">bent</td>
                <td data-label="Phon">bent</td>
                <td data-label="Definition">X1 is bent</td>
                <td data-label="Comments">Implies usually straight, or was once straight.</td>
                <td data-label="Xref">psa, fle</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: -uan-ciu<br>Latin: kurv.us<br>Loglan: betcu</td>
            </tr>

            <tr>
                <td data-label="Word">xdo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">shallow</td>
                <td data-label="Phon">qalo</td>
                <td data-label="Definition">X1 is shallow</td>
                <td data-label="Comments">Extends short way down.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: |cian<br>Latin: vados.us<br>Loglan: caxno*</td>
            </tr>

            <tr>
                <td data-label="Word">xgl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">long</td>
                <td data-label="Phon">law</td>
                <td data-label="Definition">X1 is long</td>
                <td data-label="Comments">Longest dimension is big.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1<br>Chinese: /qaw<br>Latin: long.us<br>Loglan: langa</td>
            </tr>

            <tr>
                <td data-label="Word">qku</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">sharp</td>
                <td data-label="Phon">qarp</td>
                <td data-label="Definition">X1 is sharp</td>
                <td data-label="Comments">Vertex or dihedral has a small angle or is not rounded off.</td>
                <td data-label="Xref">jin</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1, 1.3.5<br>Chinese: !li<br>Latin: akut.us<br>Loglan: kinku</td>
            </tr>

            <tr>
                <td data-label="Word">tfa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">large, rotund, fat</td>
                <td data-label="Phon">fat</td>
                <td data-label="Definition">X1 is large</td>
                <td data-label="Comments">Larger than standard or useful.  Use -cul -deri to emphasize fat content.</td>
                <td data-label="Xref">kqa, deri</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.1, 1.3.7<br>Chinese: !paw<br>Latin: rotund.us<br>Loglan: fotpa</td>
            </tr>

            <tr>
                <td data-label="Word">132</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Other Static Dimensions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gvi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">light</td>
                <td data-label="Phon">lait</td>
                <td data-label="Definition">X1 is light</td>
                <td data-label="Comments">Has little mass.  Use -xgm for brilliant.</td>
                <td data-label="Xref">vga, xgy, vaw, xgm</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: -ciw<br>Latin: lev.ys<br>Loglan: latci</td>
            </tr>

            <tr>
                <td data-label="Word">cul</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">full, swollen</td>
                <td data-label="Phon">ful</td>
                <td data-label="Definition">Container X1 is full of content (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">gai, vel, toum, fpw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: -cuw|man<br>Latin: plen.us<br>Loglan: folma</td>
            </tr>

            <tr>
                <td data-label="Word">fpw</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">empty</td>
                <td data-label="Phon">empti</td>
                <td data-label="Definition">X1 is empty of content (xo) X2*</td>
                <td data-label="Comments">X1 is a container that could contain X2 but doesn&#x27;t.</td>
                <td data-label="Xref">cul, zua</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: -kow<br>Latin: ynan.ys<br>Loglan: kunti*</td>
            </tr>

            <tr>
                <td data-label="Word">gzy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">taut, tense, strain</td>
                <td data-label="Phon">tat</td>
                <td data-label="Definition">X1: is taut over X2:</td>
                <td data-label="Comments">For between two points, X2 is a set.  Engineering strain is different.</td>
                <td data-label="Xref">ten</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: |jin-jaw<br>Latin: poryg.ere<br>Loglan: trati*</td>
            </tr>

            <tr>
                <td data-label="Word">psy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">simple</td>
                <td data-label="Phon">sympl</td>
                <td data-label="Definition">X1 is simple</td>
                <td data-label="Comments">Has few parts or steps.</td>
                <td data-label="Xref">skm</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: |jian-dan<br>Latin: sympleks<br>Loglan: sapla</td>
            </tr>

            <tr>
                <td data-label="Word">fcu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">pure</td>
                <td data-label="Phon">piur</td>
                <td data-label="Definition">X1 is pure</td>
                <td data-label="Comments">Meets a high standard (|fta) for impurities included.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: /cu#n/jie<br>Latin: pur.us<br>Loglan: punfo</td>
            </tr>

            <tr>
                <td data-label="Word">spn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">dense</td>
                <td data-label="Phon">dens</td>
                <td data-label="Definition">X1 is dense</td>
                <td data-label="Comments">For mass density and dense fur.  Use -qnr for concentrated.</td>
                <td data-label="Xref">qnr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: /nuw!ho<br>Latin: dens.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vga</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">heavy</td>
                <td data-label="Phon">hevi</td>
                <td data-label="Definition">X1 is heavy</td>
                <td data-label="Comments">Has much mass.  Use -vaw for strength, -xgy for stiffness.</td>
                <td data-label="Xref">gvi, vaw, xgy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: !juw<br>Latin: grav.ys<br>Loglan: tidjo</td>
            </tr>

            <tr>
                <td data-label="Word">vgn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">clean</td>
                <td data-label="Phon">klin</td>
                <td data-label="Definition">X1 is clean</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: -gan!jiw<br>Latin: pur.us<br>Loglan: klini</td>
            </tr>

            <tr>
                <td data-label="Word">zgu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">expensive</td>
                <td data-label="Phon">ekspensiv</td>
                <td data-label="Definition">X1 is expensive for purpose (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: !guei<br>Latin: sumptuos.us<br>Loglan: kusti</td>
            </tr>

            <tr>
                <td data-label="Word">skm</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">complicated</td>
                <td data-label="Phon">kamplykated</td>
                <td data-label="Definition">X1 is complicated</td>
                <td data-label="Comments">Has many parts or steps.</td>
                <td data-label="Xref">psy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2<br>Chinese: !fu/dza<br>Latin: multypleks<br>Loglan: pluja*</td>
            </tr>

            <tr>
                <td data-label="Word">zdr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">hard</td>
                <td data-label="Phon">hard</td>
                <td data-label="Definition">X1 is hard</td>
                <td data-label="Comments">Resists scratching or cutting.  Use -kly for difficult.</td>
                <td data-label="Xref">ftm, kly</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2, 1.3.5<br>Chinese: -gaw!iw<br>Latin: dur.us<br>Loglan: hardu</td>
            </tr>

            <tr>
                <td data-label="Word">spr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">steep</td>
                <td data-label="Phon">stip</td>
                <td data-label="Definition">X1 is steep</td>
                <td data-label="Comments">At a high angle to the horizontal.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.2, 1.4.1<br>Chinese: /suan/iai<br>Latin: praekeps<br>Loglan: slopu</td>
            </tr>

            <tr>
                <td data-label="Word">133</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Dynamic Qualities</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fpi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">pressure</td>
                <td data-label="Phon">presiur</td>
                <td data-label="Definition">X1 is under pressure</td>
                <td data-label="Comments">|pa for how much.  Physical; needs metaphor for emotional pressure.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: -ia!li<br>Latin: pres.us<br>Loglan: danre*</td>
            </tr>

            <tr>
                <td data-label="Word">tfr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">frequent</td>
                <td data-label="Phon">frikuent</td>
                <td data-label="Definition">(vo) X1 occurs frequently</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sur, xer</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: /qaw/qaw<br>Latin: frekuens<br>Loglan: pifno</td>
            </tr>

            <tr>
                <td data-label="Word">kqe</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">loud</td>
                <td data-label="Phon">laud</td>
                <td data-label="Definition">X1 is loud</td>
                <td data-label="Comments">Lots of sound.  </td>
                <td data-label="Xref">vji</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: !da-qew<br>Latin: klar.us<br>Loglan: clado</td>
            </tr>

            <tr>
                <td data-label="Word">qci</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">energy</td>
                <td data-label="Phon">enerji</td>
                <td data-label="Definition">X1 is energetic</td>
                <td data-label="Comments">Applies to objects or events.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: !ci!li<br>Latin: vis<br>Loglan: nerji</td>
            </tr>

            <tr>
                <td data-label="Word">qky</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">hot</td>
                <td data-label="Phon">hat</td>
                <td data-label="Definition">X1 is hot</td>
                <td data-label="Comments">|pa for actual temperature.  Use -zao |qky for hot flavor.</td>
                <td data-label="Xref">zgy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: !r#<br>Latin: kalyd.us<br>Loglan: hatro</td>
            </tr>

            <tr>
                <td data-label="Word">vji</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">quiet</td>
                <td data-label="Phon">kuaiet</td>
                <td data-label="Definition">X1 is quiet</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kqe</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: -an!jiw<br>Latin: kuyet.us<br>Loglan: santi</td>
            </tr>

            <tr>
                <td data-label="Word">xer</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">periodic, daily, annual, hourly, monthly</td>
                <td data-label="Phon">periadyk</td>
                <td data-label="Definition">Event (vo) X1 is periodic with period (xu) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tfr, zai</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: !dzai-san<br>Latin: yter.are<br>Loglan: rilri</td>
            </tr>

            <tr>
                <td data-label="Word">zgy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">cold</td>
                <td data-label="Phon">kold</td>
                <td data-label="Definition">X1 is cold</td>
                <td data-label="Comments">In temperature.  |pa for actual temperature.</td>
                <td data-label="Xref">qky</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3<br>Chinese: |l#w<br>Latin: frygyd.us<br>Loglan: kleda</td>
            </tr>

            <tr>
                <td data-label="Word">ksn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">viscous</td>
                <td data-label="Phon">vysk#s</td>
                <td data-label="Definition">X1 is viscous</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3, 1.3.5<br>Chinese: /nuw<br>Latin: tenaks<br>Loglan: viknu*</td>
            </tr>

            <tr>
                <td data-label="Word">sau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">sound</td>
                <td data-label="Phon">saund</td>
                <td data-label="Definition">X1 sounds like prototype (xi) X2*</td>
                <td data-label="Comments">Similar in sound.  Not for generalized similarity (-smy).</td>
                <td data-label="Xref">fsn, tia</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.3, 1.3.6<br>Chinese: |hau!siaw<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">134</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Colors and Appearance</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fsi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">saturated, bright</td>
                <td data-label="Phon">satiurated</td>
                <td data-label="Definition">X1 is saturated in color</td>
                <td data-label="Comments">Use -qnr |tmy for chemical or solution saturation.</td>
                <td data-label="Xref">xgm, sfe</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -sian!ian<br>Latin: splendyd.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dvr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">red</td>
                <td data-label="Phon">red</td>
                <td data-label="Definition">X1 is red</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: /huw<br>Latin: ruber<br>Loglan: redro</td>
            </tr>

            <tr>
                <td data-label="Word">fci</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">violet</td>
                <td data-label="Phon">vaiolet</td>
                <td data-label="Definition">X1 is violet</td>
                <td data-label="Comments">A color beyond blue.</td>
                <td data-label="Xref">qta</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -ciw/lian<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fkl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">blue</td>
                <td data-label="Phon">blu</td>
                <td data-label="Definition">X1 is blue</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: /lan<br>Latin: kaerule.us<br>Loglan: blanu</td>
            </tr>

            <tr>
                <td data-label="Word">kfu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">brown</td>
                <td data-label="Phon">braun</td>
                <td data-label="Definition">X1 is brown</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -ka-fei<br>Latin: fusk.us<br>Loglan: brona</td>
            </tr>

            <tr>
                <td data-label="Word">kqi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">clear, transparent</td>
                <td data-label="Phon">klir</td>
                <td data-label="Definition">X1 is clear or transparent</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: !tou/miw<br>Latin: perlukid.us<br>Loglan: kliri</td>
            </tr>

            <tr>
                <td data-label="Word">qki</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">gray</td>
                <td data-label="Phon">grai</td>
                <td data-label="Definition">X1 is gray</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -huei<br>Latin: kain.us<br>Loglan: grisi</td>
            </tr>

            <tr>
                <td data-label="Word">qta</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">purple, magenta</td>
                <td data-label="Phon">majenta</td>
                <td data-label="Definition">X1 is magenta</td>
                <td data-label="Comments">Also purple.  These are red plus blue.</td>
                <td data-label="Xref">fci</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: |dz<br>Latin: purpura<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sca</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">cyan</td>
                <td data-label="Phon">sian</td>
                <td data-label="Definition">X1 is cyan</td>
                <td data-label="Comments">This is green plus blue.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: /lan<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">skr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">dark</td>
                <td data-label="Phon">dark</td>
                <td data-label="Definition">X1 is dark</td>
                <td data-label="Comments">Low intensity color or lacks light.  Use |sfe for pastel.</td>
                <td data-label="Xref">xgm, sfe</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -hei<br>Latin: obskur.us<br>Loglan: draka</td>
            </tr>

            <tr>
                <td data-label="Word">sfe</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">pastel</td>
                <td data-label="Phon">pastel</td>
                <td data-label="Definition">X1 is pastel in color</td>
                <td data-label="Comments">The color is low in saturation.</td>
                <td data-label="Xref">fsi, skr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: |fen|bi<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vba</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">white</td>
                <td data-label="Phon">uait</td>
                <td data-label="Definition">X1 is white</td>
                <td data-label="Comments">A color, not a nationality.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: /bai<br>Latin: alb.us<br>Loglan: blabi</td>
            </tr>

            <tr>
                <td data-label="Word">zbo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">blond</td>
                <td data-label="Phon">blond</td>
                <td data-label="Definition">X1 is blond</td>
                <td data-label="Comments">A color special to human hair.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -<br>Latin: -<br>Loglan: londa</td>
            </tr>

            <tr>
                <td data-label="Word">xdw</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">orange</td>
                <td data-label="Phon">or#nj</td>
                <td data-label="Definition">X1 is orange</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: /dx/huaw<br>Latin: <br>Loglan: norji</td>
            </tr>

            <tr>
                <td data-label="Word">xge</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">black</td>
                <td data-label="Phon">blak</td>
                <td data-label="Definition">X1 is black</td>
                <td data-label="Comments">A color, not a nationality.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -hei<br>Latin: nyger<br>Loglan: nigro</td>
            </tr>

            <tr>
                <td data-label="Word">xgi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">green</td>
                <td data-label="Phon">grin</td>
                <td data-label="Definition">X1 is green</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -ciw<br>Latin: vyryd.ys<br>Loglan: vegri</td>
            </tr>

            <tr>
                <td data-label="Word">xgm</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">brilliant, light, bright</td>
                <td data-label="Phon">brayt</td>
                <td data-label="Definition">X1 is bright</td>
                <td data-label="Comments">Brilliant, high intensity color or full of light.  Not for ``intelligent&#x27;&#x27; (-kua -swy or similar metaphor).</td>
                <td data-label="Xref">skr, fsi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: -guaw/myw<br>Latin: spendid.us<br>Loglan: brili</td>
            </tr>

            <tr>
                <td data-label="Word">zgl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">yellow</td>
                <td data-label="Phon">ielo</td>
                <td data-label="Definition">X1 is yellow</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4<br>Chinese: /huaw<br>Latin: flav.us<br>Loglan: pelto</td>
            </tr>

            <tr>
                <td data-label="Word">kor</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">color</td>
                <td data-label="Phon">kolor</td>
                <td data-label="Definition">X1 has a color similar to the color of prototype (xi) X2</td>
                <td data-label="Comments">Use -xu -kor for ``the color of X2&#x27;&#x27;.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4, 1.3.6<br>Chinese: !ci!se<br>Latin: kolor<br>Loglan: kolro</td>
            </tr>

            <tr>
                <td data-label="Word">sie</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">look, appearance</td>
                <td data-label="Phon">l#k</td>
                <td data-label="Definition">X1 looks like prototype (xi) X2*</td>
                <td data-label="Comments">Similar in appearance.  For general similarity use -smy.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.4, 1.3.6<br>Chinese: !sian!siaw<br>Latin: spekies<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">135</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Texture</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ftm</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">soft</td>
                <td data-label="Phon">saft</td>
                <td data-label="Definition">X1 is soft</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zdr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: |ruan<br>Latin: mol.ys<br>Loglan: molro</td>
            </tr>

            <tr>
                <td data-label="Word">ksy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">dry</td>
                <td data-label="Phon">drai</td>
                <td data-label="Definition">X1 is dry</td>
                <td data-label="Comments">Lacks liquid.</td>
                <td data-label="Xref">qum</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: -gan<br>Latin: syk.us<br>Loglan: drani</td>
            </tr>

            <tr>
                <td data-label="Word">spy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">smooth</td>
                <td data-label="Phon">smut</td>
                <td data-label="Definition">X1 is smooth in texture</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tsr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: /pyw<br>Latin: lev.ys<br>Loglan: smupi</td>
            </tr>

            <tr>
                <td data-label="Word">tsi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">spring, elastic</td>
                <td data-label="Phon">ilastyk</td>
                <td data-label="Definition">X1 is elastic or springy</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">xgy, spwy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: /tan!siw<br>Latin: <br>Loglan: lasti</td>
            </tr>

            <tr>
                <td data-label="Word">tsr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">rough</td>
                <td data-label="Phon">r#f</td>
                <td data-label="Definition">X1 is rough in texture</td>
                <td data-label="Comments">Use -vme for violent.</td>
                <td data-label="Xref">spy, vme</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: -tsu<br>Latin: asper<br>Loglan: rofsu</td>
            </tr>

            <tr>
                <td data-label="Word">xgy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">stiff</td>
                <td data-label="Phon">styf</td>
                <td data-label="Definition">X1 is stiff</td>
                <td data-label="Comments">Resists bending or deformation.</td>
                <td data-label="Xref">tsi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: !iyw<br>Latin: rygyd.us<br>Loglan: stifa</td>
            </tr>

            <tr>
                <td data-label="Word">zbl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">soft, malleable</td>
                <td data-label="Phon">mali#bl</td>
                <td data-label="Definition">X1 is malleable</td>
                <td data-label="Comments">Shape is easily changed.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5<br>Chinese: |ran<br>Latin: lent.us<br>Loglan: ranta*</td>
            </tr>

            <tr>
                <td data-label="Word">jra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">texture, feel</td>
                <td data-label="Phon">fil</td>
                <td data-label="Definition">X1 feels like prototype (xi) X2</td>
                <td data-label="Comments">Similar in texture.  Use -smy for general similarity.</td>
                <td data-label="Xref">gae, ciw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.5, 1.3.6<br>Chinese: /jr<br>Latin: tekstura<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">136</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Physical Properties of Objects</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xel</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">odor, smell</td>
                <td data-label="Phon">smel</td>
                <td data-label="Definition">X1 smells like prototype (xi) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.6, 1.3.7<br>Chinese: !uei<br>Latin: odor<br>Loglan: sutme</td>
            </tr>

            <tr>
                <td data-label="Word">zao</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">flavor, taste</td>
                <td data-label="Phon">flavor</td>
                <td data-label="Definition">X1 tastes like prototype (xi) X2*</td>
                <td data-label="Comments">X2 is a food.  Use metaphor, not compound, for (e.g.) hot.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.6, 1.3.7<br>Chinese: -dz!uei<br>Latin: sapor<br>Loglan: gusto</td>
            </tr>

            <tr>
                <td data-label="Word">jir</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">here, location</td>
                <td data-label="Phon">hir</td>
                <td data-label="Definition">X1: is here, is at the same place as, has location (jr) X2*M5</td>
                <td data-label="Comments">Typically objects but may be events.  </td>
                <td data-label="Xref">cnu, qlo, jr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.6, 1.4.4, 1.5.1<br>Chinese: !je|li<br>Latin: hyk<br>Loglan: hijra</td>
            </tr>

            <tr>
                <td data-label="Word">swa</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">duration, last</td>
                <td data-label="Phon">last</td>
                <td data-label="Definition">X1 IEC the amount of time that process (vo) X2+ lasts</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">gyn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.6, 3.5.6, 1.4.4<br>Chinese: /ien/tsaw<br>Latin: dur.are<br>Loglan: ditcu*</td>
            </tr>

            <tr>
                <td data-label="Word">xnu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">unit</td>
                <td data-label="Phon">iunyt</td>
                <td data-label="Definition">X1:! IEC a unit of measure for quality (vo) X3+1 times amount (xu) X2</td>
                <td data-label="Comments">For foreign units, modify -xnu by metaphor with the foreign name.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.6, 4.5.2, 1.5.6<br>Chinese: -dan!uei<br>Latin: mensura<br>Loglan: skalu</td>
            </tr>

            <tr>
                <td data-label="Word">137</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Biological Properties</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfe</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">fertile</td>
                <td data-label="Phon">fertyl</td>
                <td data-label="Definition">Field X1 is fertile for crop (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: /fei!uo<br>Latin: fekund.us<br>Loglan: ferti</td>
            </tr>

            <tr>
                <td data-label="Word">fpa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">young</td>
                <td data-label="Phon">i#w</td>
                <td data-label="Definition">X1 is young</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">xda</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: /nian-ciw<br>Latin: parv.us<br>Loglan: junti</td>
            </tr>

            <tr>
                <td data-label="Word">fpu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">rotten, infest, scavenger</td>
                <td data-label="Phon">ratn</td>
                <td data-label="Definition">X1 is rotten, infested with scavengers (xo) X2*</td>
                <td data-label="Comments">X2 are bacterial or metazoan scavengers (maggots).</td>
                <td data-label="Xref">ksi, zbi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: |fu!lan<br>Latin: putryd.us<br>Loglan: ranta</td>
            </tr>

            <tr>
                <td data-label="Word">fti</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">healthy</td>
                <td data-label="Phon">helti</td>
                <td data-label="Definition">X1 is healthy</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zbi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: !jian-kaw<br>Latin: san.us<br>Loglan: djela</td>
            </tr>

            <tr>
                <td data-label="Word">ksi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">fresh, undamaged, unused</td>
                <td data-label="Phon">freq</td>
                <td data-label="Definition">X1 is fresh</td>
                <td data-label="Comments">Undamaged by age or use.</td>
                <td data-label="Xref">fpu, psn, ste</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: -sin-sian<br>Latin: rekens<br>Loglan: frese</td>
            </tr>

            <tr>
                <td data-label="Word">ksw</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">relax</td>
                <td data-label="Phon">rilaks</td>
                <td data-label="Definition">X1 is relaxed</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sil, bzi</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: -faw-suw<br>Latin: laks.ere<br>Loglan: surla*</td>
            </tr>

            <tr>
                <td data-label="Word">qke</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">sour</td>
                <td data-label="Phon">saur</td>
                <td data-label="Definition">X1 is sour</td>
                <td data-label="Comments">Tastes like acid.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: -suan<br>Latin: akerb.us<br>Loglan: sarni</td>
            </tr>

            <tr>
                <td data-label="Word">zby</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">bitter</td>
                <td data-label="Phon">bytr</td>
                <td data-label="Definition">X1 is bitter in flavor</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: |ku<br>Latin: amar.us<br>Loglan: kutra</td>
            </tr>

            <tr>
                <td data-label="Word">xda</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">old</td>
                <td data-label="Phon">old</td>
                <td data-label="Definition">X1 is old</td>
                <td data-label="Comments">Been alive a long time; use -bir for ancient.  |pa for how old, low numbers permitted.</td>
                <td data-label="Xref">fpa, bir, ste</td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: |lau<br>Latin: grand.ys<br>Loglan: laldo</td>
            </tr>

            <tr>
                <td data-label="Word">xdu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">sweet</td>
                <td data-label="Phon">suit</td>
                <td data-label="Definition">X1 is sweet</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7<br>Chinese: /tian<br>Latin: dulk.ys<br>Loglan: sliti</td>
            </tr>

            <tr>
                <td data-label="Word">dvi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">wild, tame</td>
                <td data-label="Phon">uild</td>
                <td data-label="Definition">X1 is wild</td>
                <td data-label="Comments">Not domesticated.  Use -gr -dvi for tame.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.3.7, 4.6.4<br>Chinese: |ie<br>Latin: fer.us<br>Loglan: cilce*</td>
            </tr>

            <tr>
                <td data-label="Word">140</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Directional Properties</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Often compounded with motion words.  Frequently they seem backward to an English speaker, e.g. ``from above&#x27;&#x27; rather than ``downward&#x27;&#x27;.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">141</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Vertical</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Use |vrl for a reference frame.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bil</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">below, up</td>
                <td data-label="Phon">bilo</td>
                <td data-label="Definition">X1 is below X2:*</td>
                <td data-label="Comments">Lower and on a vertical line.  Motion from below.</td>
                <td data-label="Xref">qmy</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.1<br>Chinese: !dzai!sia<br>Latin: ynfra<br>Loglan: nilca</td>
            </tr>

            <tr>
                <td data-label="Word">for</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">arch</td>
                <td data-label="Phon">arc</td>
                <td data-label="Definition">X1 arches over X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">bryo</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.1<br>Chinese: -guw-qiw<br>Latin: fornyks<br>Loglan: farka</td>
            </tr>

            <tr>
                <td data-label="Word">gal</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">high</td>
                <td data-label="Phon">hai</td>
                <td data-label="Definition">X1 is higher than X2:*</td>
                <td data-label="Comments">Geometrically.</td>
                <td data-label="Xref">xyl</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.1<br>Chinese: -gau<br>Latin: alt.us<br>Loglan: ganta</td>
            </tr>

            <tr>
                <td data-label="Word">qmy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">above, down</td>
                <td data-label="Phon">#b#v</td>
                <td data-label="Definition">X1 is above X2:*</td>
                <td data-label="Comments">Higher and on a vertical line.  Movement from above.</td>
                <td data-label="Xref">bil</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.1<br>Chinese: !qaw!myan<br>Latin: supra<br>Loglan: tovru</td>
            </tr>

            <tr>
                <td data-label="Word">vjr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">vertical</td>
                <td data-label="Phon">vrtyk#l</td>
                <td data-label="Definition">X1 is vertical</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.1<br>Chinese: /jr!li<br>Latin: rekt.us<br>Loglan: vreti</td>
            </tr>

            <tr>
                <td data-label="Word">xyl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">low</td>
                <td data-label="Phon">lou</td>
                <td data-label="Definition">X1 is lower than X2:*</td>
                <td data-label="Comments">Geometrically.</td>
                <td data-label="Xref">gal</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.1<br>Chinese: -di<br>Latin: humyl.ys<br>Loglan: damni</td>
            </tr>

            <tr>
                <td data-label="Word">142</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Horizontal</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Use |vrl for a reference frame.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ber</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">north</td>
                <td data-label="Phon">nort</td>
                <td data-label="Definition">X1 is north of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tau</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: |bei<br>Latin: septentr.yo<br>Loglan: nordi</td>
            </tr>

            <tr>
                <td data-label="Word">bie</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">beside</td>
                <td data-label="Phon">bisaid</td>
                <td data-label="Definition">X1 is beside X2:*</td>
                <td data-label="Comments">Next in a spatial sequence, usually horizontal and perpendicular to line of sight.</td>
                <td data-label="Xref">tao</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: /ge!bi<br>Latin: iuksta<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fro</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">front</td>
                <td data-label="Phon">fr#nt</td>
                <td data-label="Definition">X1 is in front of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zon</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: /qian!mian<br>Latin: pro<br>Loglan: frena</td>
            </tr>

            <tr>
                <td data-label="Word">juw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">center, middle</td>
                <td data-label="Phon">sentr</td>
                <td data-label="Definition">X1 is in the center of X2s:*</td>
                <td data-label="Comments">A central subset (of a set or territory).  Use -dyn for center point, -cunu for nucleus.</td>
                <td data-label="Xref">cunu, xne, dyn</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: -juw-jian<br>Latin: medi.us<br>Loglan: midju</td>
            </tr>

            <tr>
                <td data-label="Word">zon</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">back</td>
                <td data-label="Phon">bak</td>
                <td data-label="Definition">X1 is in back of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fro</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: !dzay!hou<br>Latin: pone<br>Loglan: prire</td>
            </tr>

            <tr>
                <td data-label="Word">sye</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">west, deasil</td>
                <td data-label="Phon">uest</td>
                <td data-label="Definition">X1 is west of X2:*</td>
                <td data-label="Comments">Use -jur -sye for turning deasil.</td>
                <td data-label="Xref">xye</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: -si<br>Latin: oksydens<br>Loglan: lusta</td>
            </tr>

            <tr>
                <td data-label="Word">tau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">south</td>
                <td data-label="Phon">saut</td>
                <td data-label="Definition">X1 is south of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">ber</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: /nan<br>Latin: austral.ys<br>Loglan: surdi</td>
            </tr>

            <tr>
                <td data-label="Word">tio</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">right</td>
                <td data-label="Phon">rait</td>
                <td data-label="Definition">X1 is to the right of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vle</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: !iou<br>Latin: dekster<br>Loglan: ritco</td>
            </tr>

            <tr>
                <td data-label="Word">vle</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">left</td>
                <td data-label="Phon">left</td>
                <td data-label="Definition">X1 is to the left of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tio</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: |dzuo<br>Latin: laev.us<br>Loglan: ledzo</td>
            </tr>

            <tr>
                <td data-label="Word">xbr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">horizontal, level</td>
                <td data-label="Phon">levl</td>
                <td data-label="Definition">X1 is horizontal or level</td>
                <td data-label="Comments">Use -fsr for flat.</td>
                <td data-label="Xref">fsr</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: |quei/piw<br>Latin: lybr.are<br>Loglan: lelpi</td>
            </tr>

            <tr>
                <td data-label="Word">xye</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">east, widdershins</td>
                <td data-label="Phon">ist</td>
                <td data-label="Definition">X1 is east of X2:*</td>
                <td data-label="Comments">-jur -xye for turning widdershins.</td>
                <td data-label="Xref">sye</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.2<br>Chinese: -d#w<br>Latin: oryens<br>Loglan: lesta</td>
            </tr>

            <tr>
                <td data-label="Word">143</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Adjacency</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">cross, intersect</td>
                <td data-label="Phon">kras</td>
                <td data-label="Definition">X1: crosses, intersects X2:</td>
                <td data-label="Comments">Emphasizes the geometry or fact of intersection.  |jir for the intersection point or line.</td>
                <td data-label="Xref">sew</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: /h#w-cie<br>Latin: trans.yre<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">far</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">far</td>
                <td data-label="Phon">far</td>
                <td data-label="Definition">X1 is far away from X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vny</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: |uan<br>Latin: prokul<br>Loglan: darli</td>
            </tr>

            <tr>
                <td data-label="Word">gai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">cover</td>
                <td data-label="Phon">k#vr</td>
                <td data-label="Definition">(xo) X2* covers X1:</td>
                <td data-label="Comments">X2 can be a specific object (needs -xe) or a serving/portion, i.e. blood.</td>
                <td data-label="Xref">cul</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: !fu!gai<br>Latin: teg.ere<br>Loglan: kuvga</td>
            </tr>

            <tr>
                <td data-label="Word">jui</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">surround</td>
                <td data-label="Phon">sraund</td>
                <td data-label="Definition">X2* surrounds X1:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">canu</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: /uei!ju<br>Latin: kyng.ere<br>Loglan: krudi*</td>
            </tr>

            <tr>
                <td data-label="Word">pae</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">separate</td>
                <td data-label="Phon">sep#r#t</td>
                <td data-label="Definition">X1: is separate from X2:*?</td>
                <td data-label="Comments">Not attached, not part of, though potentially part of X2.  With motion words, X2 merges with the start point (3rd case).</td>
                <td data-label="Xref">tao</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: -fen-kai<br>Latin: separat.us<br>Loglan: narti</td>
            </tr>

            <tr>
                <td data-label="Word">pne</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">penetrate</td>
                <td data-label="Phon">penetrait</td>
                <td data-label="Definition">X1 penetrates X2:*</td>
                <td data-label="Comments">Statically.  -can -pne or -kri -pne for dynamic penetration.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: !jin!ru<br>Latin: penetr.are<br>Loglan: tceru</td>
            </tr>

            <tr>
                <td data-label="Word">tao</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">neighbor, contact, touch, close</td>
                <td data-label="Phon">kontakt</td>
                <td data-label="Definition">X1 is in contact with neighbor X2*</td>
                <td data-label="Comments">Geometrically.  -pwo -kuo for X1 can talk to X2 (in touch).</td>
                <td data-label="Xref">pae, tmu, klo, bie</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: -jie!cu<br>Latin: takt.us<br>Loglan: nedza</td>
            </tr>

            <tr>
                <td data-label="Word">vny</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">neighbor, near</td>
                <td data-label="Phon">nir</td>
                <td data-label="Definition">X1 is near to neighbor X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">far</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: !jin<br>Latin: vykyn.us<br>Loglan: snire</td>
            </tr>

            <tr>
                <td data-label="Word">xne</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">between</td>
                <td data-label="Phon">bituin</td>
                <td data-label="Definition">X1 is between X2: and X3:</td>
                <td data-label="Comments">No case merge.  Use -juw or -vdr for among.</td>
                <td data-label="Xref">vdr, juw</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.3<br>Chinese: -x/jien<br>Latin: ynter<br>Loglan: bitsa</td>
            </tr>

            <tr>
                <td data-label="Word">144</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Time and Miscellaneous</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">across</td>
                <td data-label="Phon">#kras</td>
                <td data-label="Definition">X1 is across X2: from X3:</td>
                <td data-label="Comments">X2 is a separating zone and X1 is the closest point to X3 on the opposite side.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.4<br>Chinese: /hew!guo<br>Latin: trans<br>Loglan: karsa</td>
            </tr>

            <tr>
                <td data-label="Word">tai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">outside, out</td>
                <td data-label="Phon">autsaid</td>
                <td data-label="Definition">X1 is outside of X2:*?</td>
                <td data-label="Comments">With motion words, X2 merges with the start point (3rd case).</td>
                <td data-label="Xref">xyn</td>
                <td data-label="Notes">Rank: 12<br>Thes: 1.4.4<br>Chinese: !uai!mian<br>Latin: ekster<br>Loglan: zvoto</td>
            </tr>

            <tr>
                <td data-label="Word">xyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">inside, interior, in</td>
                <td data-label="Phon">ynsaid</td>
                <td data-label="Definition">X1 is inside of X2:*</td>
                <td data-label="Comments">-xu -xyn for the interior of a boundary.</td>
                <td data-label="Xref">tai, bor</td>
                <td data-label="Notes">Rank: 8<br>Thes: 1.4.4, 1.1.3<br>Chinese: |li!mian<br>Latin: yntra<br>Loglan: nenri</td>
            </tr>

            <tr>
                <td data-label="Word">cnu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">present, now, time</td>
                <td data-label="Phon">nou</td>
                <td data-label="Definition">(vo) X1@! occurs at the same time as, at time (vo-jn) X2+M4</td>
                <td data-label="Comments">Present tense.  </td>
                <td data-label="Xref">jir, bir, jro</td>
                <td data-label="Notes">Rank: 13<br>Thes: 1.4.4, 1.3.6, 1.5.1<br>Chinese: !mi/cian<br>Latin: nunk<br>Loglan: nadzo</td>
            </tr>

            <tr>
                <td data-label="Word">bir</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">past, early, before</td>
                <td data-label="Phon">bifor</td>
                <td data-label="Definition">(vo) X1@! is before time (vo-jn) X2+M4</td>
                <td data-label="Comments">Past tense.  </td>
                <td data-label="Xref">jro, cnu, xda</td>
                <td data-label="Notes">Rank: 23<br>Thes: 1.4.4, 1.5.1<br>Chinese: !guo!ciu!qr<br>Latin: pri.us<br>Loglan: pasko</td>
            </tr>

            <tr>
                <td data-label="Word">jro</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">future, after, late, then</td>
                <td data-label="Phon">aftr</td>
                <td data-label="Definition">(vo) X1@! is later than time (vo-jn) X2+M4</td>
                <td data-label="Comments">Future tense.  </td>
                <td data-label="Xref">bir, cnu</td>
                <td data-label="Notes">Rank: 21<br>Thes: 1.4.4, 1.5.1<br>Chinese: -jr!hou<br>Latin: post<br>Loglan: futci</td>
            </tr>

            <tr>
                <td data-label="Word">fau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">reverse, backwards</td>
                <td data-label="Phon">bakuardz</td>
                <td data-label="Definition">X1 is oriented in the reverse direction from X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vri</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.4, 1.5.4<br>Chinese: |fan|juan<br>Latin: retro<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qyr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">direction, vector</td>
                <td data-label="Phon">dyrekqn</td>
                <td data-label="Definition">X1 is the direction to destination X2* from origin X3</td>
                <td data-label="Comments">The tangent at 0 to a geodesic C(t) such that C(0) = X3, C(1) = X2.  X1 is typically a list of components.</td>
                <td data-label="Xref">qkur</td>
                <td data-label="Notes">Rank: <br>Thes: 1.4.4, 2.2.7<br>Chinese: -faw!siaw<br>Latin: kurs.us<br>Loglan: dirco</td>
            </tr>

            <tr>
                <td data-label="Word">150</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Words for Organizing the Discourse  </td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">151</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Modal Cases, Most Frequently Used</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">See also 0.2.4 for modal default stack controls.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">152</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Modal Cases, Less Frequently Used</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">153</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Sentence Connectives</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">If you do not like to use two explicit infinitives, use -:o.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">154</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Negation</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vry</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">reverse, backwards</td>
                <td data-label="Phon">rivrs</td>
                <td data-label="Definition">Process (vo) X1 occurs in the reverse of its usual order</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vri, fay</td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.4<br>Chinese: |fan|juan<br>Latin: ynvert.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">155</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Decorations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Linked with -vi.  Some of these words show the speaker&#x27;s attitude; others show the role of the sentence in the discourse.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gza</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">paragraph</td>
                <td data-label="Phon">paragraf</td>
                <td data-label="Definition">(vo) X1 is a paragraph</td>
                <td data-label="Comments">Actually the 1st sentence of a paragraph.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 18<br>Thes: 1.5.5<br>Chinese: !duan<br>Latin: kaput<br>Loglan: nau</td>
            </tr>

            <tr>
                <td data-label="Word">qti</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">thesis</td>
                <td data-label="Phon">tisys</td>
                <td data-label="Definition">(vo) X1 is a thesis</td>
                <td data-label="Comments">A statement which subsequent discourse will support.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.5<br>Chinese: !j#w!mien<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sku</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">conclusion</td>
                <td data-label="Phon">kunkluzin</td>
                <td data-label="Definition">(vo) X1 is a conclusion</td>
                <td data-label="Comments">The statement which prior discourse has demonstrated.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.5<br>Chinese: /jiel!u#n<br>Latin: kunklusio<br>Loglan: ranpe</td>
            </tr>

            <tr>
                <td data-label="Word">156</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Identity Transformations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 1.5.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">200</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Activities</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Virtually all activities have an actor in the first case.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.0.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">210</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Abstract Behaviors and Multi-Actor Activities</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">In an abstract behavior the activity is given by a separate predicate in an infinitive, usually compounded.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">211</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Abstract Behaviors for Compounds</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 does action (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bni</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">need</td>
                <td data-label="Phon">nid</td>
                <td data-label="Definition">X1 needs to do (vo) X2:+1 so it will have result (vo) X3+1@</td>
                <td data-label="Comments">Example: !X1 /bni -byw -kqua = X1 needs to drink water, not needs water.</td>
                <td data-label="Xref">daw, sar, sno</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: !bi-su<br>Latin: eg.are<br>Loglan: cnida</td>
            </tr>

            <tr>
                <td data-label="Word">can</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">change, become</td>
                <td data-label="Phon">canj</td>
                <td data-label="Definition">X1 changes so property (vo) X2+1 becomes true</td>
                <td data-label="Comments">Most of the time use -can, but use -tar to emphasize starting.</td>
                <td data-label="Xref">tar, siw</td>
                <td data-label="Notes">Rank: 25<br>Thes: 2.1.1<br>Chinese: !bian!hua<br>Latin: mut.ary<br>Loglan: cenja</td>
            </tr>

            <tr>
                <td data-label="Word">dwl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">order, command</td>
                <td data-label="Phon">ordr</td>
                <td data-label="Definition">X1 is ordered to do (vo) X2+1 by commander X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pli, kmi, zno</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: !miw!liw<br>Latin: yus.um<br>Loglan: korji</td>
            </tr>

            <tr>
                <td data-label="Word">fwu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">custom, habit</td>
                <td data-label="Phon">kustm</td>
                <td data-label="Definition">X1 habitually or customarily does (vo) X2:+1</td>
                <td data-label="Comments">Use -tue for customs of a culture.</td>
                <td data-label="Xref">tue, tiu</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: -few/su<br>Latin: us.us<br>Loglan: kusmo</td>
            </tr>

            <tr>
                <td data-label="Word">por</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">temporary, transient</td>
                <td data-label="Phon">temporari</td>
                <td data-label="Definition">X1 temporarily is or does (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tiu, zai</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: !jan/qr<br>Latin: <br>Loglan: zasni*</td>
            </tr>

            <tr>
                <td data-label="Word">pwo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">capable</td>
                <td data-label="Phon">kapabl</td>
                <td data-label="Definition">X1 is capable of doing (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">juy, spo</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: /new-gou<br>Latin: pose<br>Loglan: kanmo</td>
            </tr>

            <tr>
                <td data-label="Word">qai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fail</td>
                <td data-label="Phon">fail</td>
                <td data-label="Definition">X1 fails to do (vo) X2:+1</td>
                <td data-label="Comments">Implies that the actor tried to do it.  Use -gr -poy -gl -qyn for irresponsible negligence.</td>
                <td data-label="Xref">flr</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: -qr!bai<br>Latin: konkyd.ere<br>Loglan: falba</td>
            </tr>

            <tr>
                <td data-label="Word">qma</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">make, transitive</td>
                <td data-label="Phon">maik</td>
                <td data-label="Definition">Actor X1 makes (vo) X2:+ happen</td>
                <td data-label="Comments">Makes transitive meanings.  No case merge.  Not for building things.</td>
                <td data-label="Xref">kau, dma</td>
                <td data-label="Notes">Rank: 45<br>Thes: 2.1.1<br>Chinese: |qr<br>Latin: fak.ere<br>Loglan: madzo</td>
            </tr>

            <tr>
                <td data-label="Word">tar</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">start</td>
                <td data-label="Phon">start</td>
                <td data-label="Definition">X1 starts being or doing (vo) X2:+1</td>
                <td data-label="Comments">To emphasize the starting; use -can for most changes.</td>
                <td data-label="Xref">tiw, can</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: -kai|qr<br>Latin: ynkyp.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">til</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">revert</td>
                <td data-label="Phon">ritrn</td>
                <td data-label="Definition">X1 reverts to have property (vo) X2+1 after a lapse</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">can</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: /huei/lai<br>Latin: reverti<br>Loglan: genza</td>
            </tr>

            <tr>
                <td data-label="Word">tiu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">continuous</td>
                <td data-label="Phon">kuntyniu#s</td>
                <td data-label="Definition">X1 continuously is or does (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">por, fwu, zai</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: !ji!siu<br>Latin: kontinu.#s<br>Loglan: stolo</td>
            </tr>

            <tr>
                <td data-label="Word">tiw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">stop</td>
                <td data-label="Phon">stap</td>
                <td data-label="Definition">X1 stops being or doing (vo) X2:+1</td>
                <td data-label="Comments">To emphasize the stopping; use -can or -siw for most changes.</td>
                <td data-label="Xref">tar, can, siw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: /tiw<br>Latin: desyn.ere<br>Loglan: stise</td>
            </tr>

            <tr>
                <td data-label="Word">zai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">repeat</td>
                <td data-label="Phon">ripit</td>
                <td data-label="Definition">X1 repeatedly is or does (vo) X2:+1</td>
                <td data-label="Comments">Separated by times when it doesn&#x27;t do it.</td>
                <td data-label="Xref">tiu, por, xer</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1<br>Chinese: !dzai-san<br>Latin: yter.are<br>Loglan: genza*</td>
            </tr>

            <tr>
                <td data-label="Word">kri</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">increase, decrease</td>
                <td data-label="Phon">ynkris</td>
                <td data-label="Definition">The amount, degree or quantity of property (vo) X1 increases</td>
                <td data-label="Comments">Use -gr -kri for decrease.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1, 1.1.8<br>Chinese: -jia!da<br>Latin: kresk.yre<br>Loglan: tenri</td>
            </tr>

            <tr>
                <td data-label="Word">siw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">stop, cease</td>
                <td data-label="Phon">sis</td>
                <td data-label="Definition">X1 ceases to be (vo) X2:+1</td>
                <td data-label="Comments">Normal form for a negated change.  Use -tiw to emphasize the stopping.</td>
                <td data-label="Xref">tiw, can</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1, 1.5.4<br>Chinese: /tiw|jr<br>Latin: desyn.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">produce</td>
                <td data-label="Phon">produs</td>
                <td data-label="Definition">X1 makes product (xo) X2* by process (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">smu</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.1, 2.4.2<br>Chinese: -cu|can<br>Latin: kre.are<br>Loglan: proju</td>
            </tr>

            <tr>
                <td data-label="Word">212</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Other Abstract Behaviors</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 does action (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ban</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">do</td>
                <td data-label="Phon">du</td>
                <td data-label="Definition">X1 performs the behavior associated with thing X2*</td>
                <td data-label="Comments">This word is out of favor.  Find a predicate and make a metaphor with X2, e.g. -zou -fw -guna rather than -ban -guna for ``slither&#x27;&#x27;.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2<br>Chinese: !ban<br>Latin: fak.ere<br>Loglan: durzo</td>
            </tr>

            <tr>
                <td data-label="Word">bei</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">ready</td>
                <td data-label="Phon">redi</td>
                <td data-label="Definition">X1 is ready to do (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2<br>Chinese: !u!bei|hau<br>Latin: parat.us<br>Loglan: bredi</td>
            </tr>

            <tr>
                <td data-label="Word">biy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">free</td>
                <td data-label="Phon">fri</td>
                <td data-label="Definition">X1 is free to do (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sir</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2<br>Chinese: /sui!bian<br>Latin: lyber<br>Loglan: frezi</td>
            </tr>

            <tr>
                <td data-label="Word">flr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">succeed</td>
                <td data-label="Phon">s#ksid</td>
                <td data-label="Definition">X1 succeeds in doing (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">qai</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2<br>Chinese: /cew-guw<br>Latin: flor.ere<br>Loglan: suksi</td>
            </tr>

            <tr>
                <td data-label="Word">qem</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">attempt, try</td>
                <td data-label="Phon">atempt</td>
                <td data-label="Definition">X1 attempts to do (vo) X2:+1</td>
                <td data-label="Comments">No connotation of success or failure.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2<br>Chinese: !qr<br>Latin: kon.ary<br>Loglan: trati</td>
            </tr>

            <tr>
                <td data-label="Word">ser</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">exercise</td>
                <td data-label="Phon">eksrsaiz</td>
                <td data-label="Definition">X1 does exercise (vo) X2+1 to improve capability or body part X3-1*  </td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2<br>Chinese: !iun!duw<br>Latin: ekserk.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">swi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">respond, stimulus</td>
                <td data-label="Phon">rispand</td>
                <td data-label="Definition">X1 responds with behavior (vo) X2+1 to stimulus (vo) X3@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2<br>Chinese: |siaw!iw<br>Latin: <br>Loglan: ponda</td>
            </tr>

            <tr>
                <td data-label="Word">ziu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">use, means, end, by~means~of</td>
                <td data-label="Phon">iuz</td>
                <td data-label="Definition">X1 uses means X2 for purpose (vo) X3+1</td>
                <td data-label="Comments">Typically X2 is an object and X3 is done by means of X2.  In a subordinate clause autoconversion leaves X2 as the 2nd case.</td>
                <td data-label="Xref">tum</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2, 1.5.1<br>Chinese: !iuw<br>Latin: uty<br>Loglan: plizo</td>
            </tr>

            <tr>
                <td data-label="Word">voi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">avoid, evade, shun, refrain, doesnt, dont</td>
                <td data-label="Phon">avoid</td>
                <td data-label="Definition">X1 avoids having (vo) X2:+1 happen</td>
                <td data-label="Comments">Example: avoid meeting a person.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2, 1.5.4<br>Chinese: !bi|mian<br>Latin: vyt.are<br>Loglan: rivbi*</td>
            </tr>

            <tr>
                <td data-label="Word">qyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">action</td>
                <td data-label="Phon">akqn</td>
                <td data-label="Definition">X1 does (vo) X2:+1</td>
                <td data-label="Comments">Emphasizes the actor.</td>
                <td data-label="Xref">cfa</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2, 1.5.6<br>Chinese: /qyng/uey<br>Latin: ag.ere<br>Loglan: kakto</td>
            </tr>

            <tr>
                <td data-label="Word">qyw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">behave</td>
                <td data-label="Phon">bihav</td>
                <td data-label="Definition">X1 behaves in manner (vo) X2+1 in situation (vo) X3+1@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.2, 1.5.6<br>Chinese: /qyw|wei<br>Latin: ger.ere<br>Loglan: bivdu</td>
            </tr>

            <tr>
                <td data-label="Word">213</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Abstract Passive Events</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Victim X1 has event (vo) X2+1 happen to it</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cua</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">peril, safe</td>
                <td data-label="Phon">saif</td>
                <td data-label="Definition">X1 is safe from peril (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">dan</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: -an/cuan<br>Latin: tut.us<br>Loglan: curca</td>
            </tr>

            <tr>
                <td data-label="Word">dan</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">danger, peril</td>
                <td data-label="Phon">danjr</td>
                <td data-label="Definition">X1 is in danger of having (vo) X2:+1 happen to it</td>
                <td data-label="Comments">X2 is the peril.</td>
                <td data-label="Xref">cua</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: /uei|sian<br>Latin: perykul.um<br>Loglan: denro</td>
            </tr>

            <tr>
                <td data-label="Word">dwo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">wait</td>
                <td data-label="Phon">uait</td>
                <td data-label="Definition">X1 waits for (vo) X2:+ before doing action (vo) X3+1@</td>
                <td data-label="Comments">X2 compounds, X3 doesn&#x27;t.  X2 lacks case merge, X3 has one.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: |d#w<br>Latin: oper.yry<br>Loglan: pazda</td>
            </tr>

            <tr>
                <td data-label="Word">sre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">survive, endure</td>
                <td data-label="Phon">srvaiv</td>
                <td data-label="Definition">X1 survives (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: -qew/tsu#n<br>Latin: superese<br>Loglan: renvi*</td>
            </tr>

            <tr>
                <td data-label="Word">tre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">tragedy, disaster</td>
                <td data-label="Phon">trajedi</td>
                <td data-label="Definition">X1 tragically has (vo) X2:+1 happen to it</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: /tsan!qr<br>Latin: klad.es<br>Loglan: betri*</td>
            </tr>

            <tr>
                <td data-label="Word">qun</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">luck, fortunate</td>
                <td data-label="Phon">l#k</td>
                <td data-label="Definition">It is lucky that X1: has (vo) X2:+1 happen to it</td>
                <td data-label="Comments">X2 is not necessarily an accident.</td>
                <td data-label="Xref">psm</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: -qyw!iun<br>Latin: fortuna<br>Loglan: funca*</td>
            </tr>

            <tr>
                <td data-label="Word">vou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">revenge</td>
                <td data-label="Phon">rivenj</td>
                <td data-label="Definition">X1 gets revenge for (vo) X2:+1 by taking action (vo) X3+1@</td>
                <td data-label="Comments">X2 often will have to be converted due to case merge.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: !bau/cou<br>Latin: ulkysky<br>Loglan: venfu*</td>
            </tr>

            <tr>
                <td data-label="Word">xum</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">doom, destiny, fate</td>
                <td data-label="Phon">dum</td>
                <td data-label="Definition">X1 is doomed to be or do (vo) X2:+1</td>
                <td data-label="Comments">What fate determines.  -xum -can -xtu for doomed to die, the usual English meaning. </td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.3<br>Chinese: !miw!iun<br>Latin: sors<br>Loglan: dimna*</td>
            </tr>

            <tr>
                <td data-label="Word">214</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Relation of Actor to Behavior</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 has a certain relation to his action (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">daw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">desire, want</td>
                <td data-label="Phon">disair</td>
                <td data-label="Definition">X1 desires to do (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">bni</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.4<br>Chinese: !u!uaw<br>Latin: apet.ere<br>Loglan: danza</td>
            </tr>

            <tr>
                <td data-label="Word">gen</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">talent</td>
                <td data-label="Phon">talnt</td>
                <td data-label="Definition">X1 has a talent for (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.4<br>Chinese: -tian/tsai<br>Latin: yngeny.um<br>Loglan: stati*</td>
            </tr>

            <tr>
                <td data-label="Word">gye</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">intend</td>
                <td data-label="Phon">yntend</td>
                <td data-label="Definition">X1 intends to do (vo) X2:+1</td>
                <td data-label="Comments">Not necessarily actually done.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.4<br>Chinese: !ci/tu<br>Latin: kogyt.are<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">pew</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">competent</td>
                <td data-label="Phon">kampetent</td>
                <td data-label="Definition">X1 is competent in doing (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">toa, smi</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.4<br>Chinese: |new!gan<br>Latin: posse<br>Loglan: spuro</td>
            </tr>

            <tr>
                <td data-label="Word">poy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">responsible, authority</td>
                <td data-label="Phon">responsybl</td>
                <td data-label="Definition">X1 is responsible for (vo) X2:+1 to authority X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">toa</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.4<br>Chinese: !fu/dz<br>Latin: praest.are<br>Loglan: daspa</td>
            </tr>

            <tr>
                <td data-label="Word">swo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hope</td>
                <td data-label="Phon">hop</td>
                <td data-label="Definition">X1 hopes for (vo) X2:+1 to happen</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.4<br>Chinese: -si!uaw<br>Latin: sp.es<br>Loglan: spopa</td>
            </tr>

            <tr>
                <td data-label="Word">toa</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">authority</td>
                <td data-label="Phon">autoryti</td>
                <td data-label="Definition">X1 is an authority in/on/over (vo) X2:+1</td>
                <td data-label="Comments">Use -per for power, -pew for skill.  Authority implies power to act or compel.</td>
                <td data-label="Xref">per, poy, pew</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.4<br>Chinese: /cuan!li<br>Latin: auktor<br>Loglan: tcori</td>
            </tr>

            <tr>
                <td data-label="Word">215</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Categories of Abstract Behaviors</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 performs action (vo) X2+1 in a certain way</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bro</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">broken, inoperable</td>
                <td data-label="Phon">brokn</td>
                <td data-label="Definition">X1 doesn&#x27;t do (vo) X2:+1 because it is broken</td>
                <td data-label="Comments">Use causal connective to say what it does do.  -brn for broken in pieces.</td>
                <td data-label="Xref">sao, brn</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5<br>Chinese: !huai-le<br>Latin: <br>Loglan: spofu*</td>
            </tr>

            <tr>
                <td data-label="Word">cou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">clown, levity</td>
                <td data-label="Phon">kloun</td>
                <td data-label="Definition">X1 is clowning by doing (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5<br>Chinese: |siau|cou<br>Latin: rustyk.us<br>Loglan: xalbo*</td>
            </tr>

            <tr>
                <td data-label="Word">gma</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">manual</td>
                <td data-label="Phon">maniual</td>
                <td data-label="Definition">X1 performs (vo) X2:+1 manually</td>
                <td data-label="Comments">Requiring close human supervision or operation.</td>
                <td data-label="Xref">zom</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5<br>Chinese: |so-gow<br>Latin: manu<br>Loglan: macnu</td>
            </tr>

            <tr>
                <td data-label="Word">kon</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">behave, conduct</td>
                <td data-label="Phon">kondukt</td>
                <td data-label="Definition">X1 behaves characteristically for a member of set (xu) X2* by doing action (vo) X3+1</td>
                <td data-label="Comments">Does not imply that every member of X2 does X3, nor that X1 is in X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5<br>Chinese: |pin!qyw<br>Latin: ger.ere<br>Loglan: tarti*</td>
            </tr>

            <tr>
                <td data-label="Word">zno</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">obey, follow</td>
                <td data-label="Phon">obei</td>
                <td data-label="Definition">X1 does (vo) X2:+1 in obedience to the order or rule (vo) X3+1@ given by authority X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">dwl, gul, kmi</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5<br>Chinese: -dzun|qou<br>Latin: par.ere<br>Loglan: tinbe*</td>
            </tr>

            <tr>
                <td data-label="Word">zom</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">automatic, initiative</td>
                <td data-label="Phon">atomatyk</td>
                <td data-label="Definition">X1 performs (vo) X2:+1 automatically</td>
                <td data-label="Comments">Without the intervention of another controller or actor.  Usually a machine but can be a person.</td>
                <td data-label="Xref">sao, gma</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5<br>Chinese: !dz!dong<br>Latin: <br>Loglan: tomki</td>
            </tr>

            <tr>
                <td data-label="Word">dau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">audacity, chutzpah</td>
                <td data-label="Phon">audasyti</td>
                <td data-label="Definition">X1 audaciously does (vo) X2:+1</td>
                <td data-label="Comments">X1 relies on a victim&#x27;s surprise or outrage to get away with X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5, 1.2.3<br>Chinese: !da|dan/u|c#<br>Latin: audaks<br>Loglan: darsi*</td>
            </tr>

            <tr>
                <td data-label="Word">tyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">stubborn</td>
                <td data-label="Phon">stubrn</td>
                <td data-label="Definition">X1 stubbornly continues to do (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5, 1.2.3<br>Chinese: /uan!gu<br>Latin: pertynaks<br>Loglan: xarnu*</td>
            </tr>

            <tr>
                <td data-label="Word">plu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">play, game</td>
                <td data-label="Phon">plai</td>
                <td data-label="Definition">X1 plays game (vo) X2:+1</td>
                <td data-label="Comments">Use -plu -ziu for playing with an object.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5, 2.1.7<br>Chinese: /uan<br>Latin: lud.ere<br>Loglan: pleci</td>
            </tr>

            <tr>
                <td data-label="Word">qya</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">amuse, fun, enjoy</td>
                <td data-label="Phon">amiuz</td>
                <td data-label="Definition">X1 has fun, is amused by doing (vo) X2:+1</td>
                <td data-label="Comments">If amused by an object, X2 is a phrase about what it is/does.</td>
                <td data-label="Xref">vyu, kqn</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5, 2.5.2<br>Chinese: -qyau|cien<br>Latin: delect.are<br>Loglan: cmiza</td>
            </tr>

            <tr>
                <td data-label="Word">bwo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">job, work</td>
                <td data-label="Phon">jab</td>
                <td data-label="Definition">X1 works on job (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.5, 4.7.2<br>Chinese: -guw!dzuo<br>Latin: op.us<br>Loglan: turka</td>
            </tr>

            <tr>
                <td data-label="Word">216</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Double Actor Transitive Activities</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Main~actor X1 makes actor X2 do action (vo) X3+2</td>
                <td data-label="Comments">See also 2.3.3 Influencing Other People</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">beo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">obstacle, obstruct</td>
                <td data-label="Phon">obstakl</td>
                <td data-label="Definition">X1 is an obstacle keeping X2: from doing (vo) X3:+2</td>
                <td data-label="Comments">An obstacle is passive.  Hinders but not necessarily prevents.</td>
                <td data-label="Xref">drm</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: !jan!gai<br>Latin: obeks<br>Loglan: bladu*</td>
            </tr>

            <tr>
                <td data-label="Word">bwu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">help</td>
                <td data-label="Phon">help</td>
                <td data-label="Definition">X1 helps X2: to do (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">juou</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: -baw!ju<br>Latin: yuv.are<br>Loglan: helba</td>
            </tr>

            <tr>
                <td data-label="Word">drm</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">interfere, hinder</td>
                <td data-label="Phon">hyndr</td>
                <td data-label="Definition">X1 hinders X2: from doing (vo) X3:+2</td>
                <td data-label="Comments">Not necessarily prevents it.  X1 acts actively.</td>
                <td data-label="Xref">sir, beo</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: |dzu|jr<br>Latin: ymped.yre<br>Loglan: minzu*</td>
            </tr>

            <tr>
                <td data-label="Word">due</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">induce</td>
                <td data-label="Phon">yndus</td>
                <td data-label="Definition">X1 induces X2: to do (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fow</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: !suei/fu<br>Latin: ynduk.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fow</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">force</td>
                <td data-label="Phon">fors</td>
                <td data-label="Definition">X1 forces X2: to do (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">due</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: /qiaw-bi<br>Latin: kog.ere<br>Loglan: fosli</td>
            </tr>

            <tr>
                <td data-label="Word">juy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">allow</td>
                <td data-label="Phon">alau</td>
                <td data-label="Definition">X1 allows X2: to do (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tuw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: |ju#n<br>Latin: syn.ere<br>Loglan: letci</td>
            </tr>

            <tr>
                <td data-label="Word">jyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">interrupt, disturb</td>
                <td data-label="Phon">ynter#pt</td>
                <td data-label="Definition">X1 interrupts X2: from doing (vo) X3:+2</td>
                <td data-label="Comments">Forces temporary stop.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: -juw!duan<br>Latin: ynterf.ary<br>Loglan: draba</td>
            </tr>

            <tr>
                <td data-label="Word">kmi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">command</td>
                <td data-label="Phon">komand</td>
                <td data-label="Definition">X1 commands X2: to do (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">gul, dwl, zno, pli</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: !miw!liw<br>Latin: yub.ere<br>Loglan: korji</td>
            </tr>

            <tr>
                <td data-label="Word">sir</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">restrain</td>
                <td data-label="Phon">ristrain</td>
                <td data-label="Definition">X1 restrains X2: from doing (vo) X3:+2</td>
                <td data-label="Comments">X1 is active and does prevent X3.</td>
                <td data-label="Xref">biy, drm</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6<br>Chinese: !sian!jr<br>Latin: koerk.ere<br>Loglan: litnu</td>
            </tr>

            <tr>
                <td data-label="Word">kro</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">control</td>
                <td data-label="Phon">kntrol</td>
                <td data-label="Definition">X1 controls X2: in activity (vo) X3:+2</td>
                <td data-label="Comments">X2 can be a person or an object.</td>
                <td data-label="Xref">sao</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6, 2.4.4<br>Chinese: |guan/sia<br>Latin: koerk.ere<br>Loglan: troli</td>
            </tr>

            <tr>
                <td data-label="Word">cim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">demand, right</td>
                <td data-label="Phon">dimand</td>
                <td data-label="Definition">X1 demands that X2: do (vo) X3:+2</td>
                <td data-label="Comments">Often X1 is the 2nd case of X3, but no automatic merge for this.  X3 should be X2 of -gul (rule).  X3 is X1&#x27;s right.</td>
                <td data-label="Xref">gul, dmo, fai</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.6, 4.7.1<br>Chinese: -iau/ciou<br>Latin: poskere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">217</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Activities by a Pair or Group of Actors</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Competitor X1 and competitor X2 do activity (vo) X3+1, 2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">compete, prize</td>
                <td data-label="Phon">kompit</td>
                <td data-label="Definition">X1 competes with X2: in activity (vo) X3+1, 2 for prize X4</td>
                <td data-label="Comments">In team sports X1 and X2 are teams.  In typical races X2 is all the other competitors in extension.</td>
                <td data-label="Xref">vyw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: |bi!sai<br>Latin: kert.are<br>Loglan: kanpi</td>
            </tr>

            <tr>
                <td data-label="Word">cor</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">soccer, football</td>
                <td data-label="Phon">sakr</td>
                <td data-label="Definition">Team (xy) X1s plays football with team (xy) X2s</td>
                <td data-label="Comments">Typically soccer.  Use -cor |fw -vanl (olive ball) for American football, per Chinese.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: /dzu/co<br>Latin: <br>Loglan: futbo</td>
            </tr>

            <tr>
                <td data-label="Word">cwi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">billiards</td>
                <td data-label="Phon">byliards</td>
                <td data-label="Definition">X1 plays billiards with X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: !cuaw/cio<br>Latin: <br>Loglan: bilra</td>
            </tr>

            <tr>
                <td data-label="Word">dai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fight</td>
                <td data-label="Phon">fait</td>
                <td data-label="Definition">X1 fights with X2: about affair (vo) X3+</td>
                <td data-label="Comments">No case merge for X3.</td>
                <td data-label="Xref">dar</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: |da!jia<br>Latin: pugn.are<br>Loglan: kamda</td>
            </tr>

            <tr>
                <td data-label="Word">dar</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">war</td>
                <td data-label="Phon">uar</td>
                <td data-label="Definition">X1 is at war with X2: about affair (vo) X3+</td>
                <td data-label="Comments">War is a serious, prolonged and bitter fight.</td>
                <td data-label="Xref">dai</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: |da!jaw<br>Latin: bel.um<br>Loglan: dorja</td>
            </tr>

            <tr>
                <td data-label="Word">fla</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">court, flirt</td>
                <td data-label="Phon">flrt</td>
                <td data-label="Definition">X1 flirts with, courts X2:</td>
                <td data-label="Comments">Not symmetrical.</td>
                <td data-label="Xref">koi</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: !mai!now-fow/cyw<br>Latin: subland.yry<br>Loglan: sekci</td>
            </tr>

            <tr>
                <td data-label="Word">koi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">copulate</td>
                <td data-label="Phon">kopiulat</td>
                <td data-label="Definition">X1 copulates with X2:</td>
                <td data-label="Comments">Use -vr (q.v.) to produce a symmetrical meaning.</td>
                <td data-label="Xref">fla</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: -siw!jiau<br>Latin: koit.us<br>Loglan: kitsa</td>
            </tr>

            <tr>
                <td data-label="Word">kul</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">kiss</td>
                <td data-label="Phon">kys</td>
                <td data-label="Definition">X1 kisses X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: -jie|wen<br>Latin: oskul.ary<br>Loglan: skesa</td>
            </tr>

            <tr>
                <td data-label="Word">sal</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">dance</td>
                <td data-label="Phon">dans</td>
                <td data-label="Definition">Dancers (xy) X1s dance X2*</td>
                <td data-label="Comments">X1 is a set of dancers.  X2 is the name or type of the dance.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: !tiau|u<br>Latin: salt.are<br>Loglan: danse</td>
            </tr>

            <tr>
                <td data-label="Word">tun</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">together, all</td>
                <td data-label="Phon">tugetr</td>
                <td data-label="Definition">All the members of set (xy) X1s do activity (vo) X2+S1 together</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: !iy/tuw<br>Latin: kunkt.us<br>Loglan: kinci</td>
            </tr>

            <tr>
                <td data-label="Word">vyw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">win, prize, lose, compete</td>
                <td data-label="Phon">uyn</td>
                <td data-label="Definition">X1 wins prize X2 for doing feat (vo) X3+1+4; losers X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">bim</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7<br>Chinese: /iyw<br>Latin: vynk.ere<br>Loglan: gancu</td>
            </tr>

            <tr>
                <td data-label="Word">poe</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">oppose</td>
                <td data-label="Phon">opoz</td>
                <td data-label="Definition">X1 opposes X2: in issue (vo) X3+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7, 1.1.4<br>Chinese: |fan!duei<br>Latin: opon.ere<br>Loglan: pozfa</td>
            </tr>

            <tr>
                <td data-label="Word">twa</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">interact</td>
                <td data-label="Phon">yntrakt</td>
                <td data-label="Definition">X1 interacts with X2: in affair (vo) X3+</td>
                <td data-label="Comments">X1 and X2 are typically people.</td>
                <td data-label="Xref">qcy, jiy</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7, 1.1.4<br>Chinese: -jiau-tuw<br>Latin: <br>Loglan: socli</td>
            </tr>

            <tr>
                <td data-label="Word">biu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">argue</td>
                <td data-label="Phon">argiu</td>
                <td data-label="Definition">X1 argues with X2: about affair (vo) X3+</td>
                <td data-label="Comments">No case merge for X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7, 2.3.1<br>Chinese: !bian!lun<br>Latin: dysput.are<br>Loglan: targo</td>
            </tr>

            <tr>
                <td data-label="Word">dyw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">discuss</td>
                <td data-label="Phon">dysk#s</td>
                <td data-label="Definition">The members of set (xy) X1s discuss affair (vo) X2+</td>
                <td data-label="Comments">No case merge.</td>
                <td data-label="Xref">kuo</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7, 2.3.1<br>Chinese: -qaw-liaw<br>Latin: dyskept.are<br>Loglan: dislu</td>
            </tr>

            <tr>
                <td data-label="Word">kuo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">talk</td>
                <td data-label="Phon">talk</td>
                <td data-label="Definition">X1 talks to listener X2 about affair (vo) X3+</td>
                <td data-label="Comments">Let -vo turn objects into events.  -kuo is unsymmetrical; -dyw is symmetric.</td>
                <td data-label="Xref">dyw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.1.7, 2.3.1<br>Chinese: -quo!hua<br>Latin: lokuy<br>Loglan: takna</td>
            </tr>

            <tr>
                <td data-label="Word">220</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Motion Words</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Often combined with directional properties (1.4.0).  They compound with cases X1 and X2.  Note the very regular arguments.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">221</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Motions that Humans Do</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Mover X1 moves to destination X2 from origin X3 via route X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cam</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">climb</td>
                <td data-label="Phon">klaim</td>
                <td data-label="Definition">X1 climbs to X2: from X3: via X4:*</td>
                <td data-label="Comments">Climb a tree: the tree is X4.  One can climb down too.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: /pa<br>Latin: scand.ere<br>Loglan: cpare*</td>
            </tr>

            <tr>
                <td data-label="Word">cir</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">return</td>
                <td data-label="Phon">ritrn</td>
                <td data-label="Definition">X1 returns to X2: from X3: via X4:</td>
                <td data-label="Comments">Implies X1 went from X2 to X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: /huei!ciu<br>Latin: red.ere<br>Loglan: xutre*</td>
            </tr>

            <tr>
                <td data-label="Word">cyr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">go</td>
                <td data-label="Phon">go</td>
                <td data-label="Definition">X1 goes to X2: from X3: via X4:</td>
                <td data-label="Comments">Emphasizes the change of location.</td>
                <td data-label="Xref">duw</td>
                <td data-label="Notes">Rank: 13<br>Thes: 2.2.1<br>Chinese: !cu<br>Latin: yre<br>Loglan: godzo</td>
            </tr>

            <tr>
                <td data-label="Word">duw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">move</td>
                <td data-label="Phon">muv</td>
                <td data-label="Definition">X1 moves to X2: from X3: via X4:</td>
                <td data-label="Comments">Emphasizes the process of moving rather than the location change or the manner of movement.  Use -qkm for ``it moves its legs&#x27;&#x27;.</td>
                <td data-label="Xref">cyr, qkm</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: /siw!duw<br>Latin: mov.ery<br>Loglan: muvdo</td>
            </tr>

            <tr>
                <td data-label="Word">kal</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fall</td>
                <td data-label="Phon">fal</td>
                <td data-label="Definition">X1 falls to X2: from X3: via X4:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: !luo!sia<br>Latin: kad.ere<br>Loglan: felda</td>
            </tr>

            <tr>
                <td data-label="Word">suy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">swim</td>
                <td data-label="Phon">suym</td>
                <td data-label="Definition">X1 swims to X2: from X3: via X4:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: /iou|iuw<br>Latin: nare<br>Loglan: sucmi</td>
            </tr>

            <tr>
                <td data-label="Word">tal</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">jump</td>
                <td data-label="Phon">j#mp</td>
                <td data-label="Definition">X1 jumps to X2: from X3: via X4:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: !tiau<br>Latin: sal.yre<br>Loglan: volti</td>
            </tr>

            <tr>
                <td data-label="Word">vlw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">travel</td>
                <td data-label="Phon">travl</td>
                <td data-label="Definition">X1 travels to X2: from X3: via X4:</td>
                <td data-label="Comments">Going outside of X1&#x27;s usual territory.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: !liu/siw<br>Latin: yter<br>Loglan: traci</td>
            </tr>

            <tr>
                <td data-label="Word">vnl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">come</td>
                <td data-label="Phon">kum</td>
                <td data-label="Definition">X1 comes to X2: from X3: via X4:</td>
                <td data-label="Comments">Gets nearer the speaker.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: /lai<br>Latin: ven.yre<br>Loglan: kamla</td>
            </tr>

            <tr>
                <td data-label="Word">xau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">roundtrip</td>
                <td data-label="Phon">raundtryp</td>
                <td data-label="Definition">X1 makes a round trip to X2: from X3: and back, via X4:</td>
                <td data-label="Comments">X1 ends up at X3.</td>
                <td data-label="Xref">cyr</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1<br>Chinese: /lai/huei<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">pur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">run, gallop</td>
                <td data-label="Phon">r#n</td>
                <td data-label="Definition">X1 runs to X2: from X3: via X4:</td>
                <td data-label="Comments">Includes gallop for quadrupeds.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1, 2.2.2<br>Chinese: |pau<br>Latin: kur.ere<br>Loglan: prano</td>
            </tr>

            <tr>
                <td data-label="Word">xra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">trot, jog</td>
                <td data-label="Phon">trat</td>
                <td data-label="Definition">X1 trots to X2: from X3: via X4:</td>
                <td data-label="Comments">Includes the bipedal slow run called jogging.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1, 2.2.2<br>Chinese: /qiau|pau<br>Latin: grad.us<br>Loglan: jetru*</td>
            </tr>

            <tr>
                <td data-label="Word">zou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">walk</td>
                <td data-label="Phon">ualk</td>
                <td data-label="Definition">X1 walks to X2: from X3: via X4:</td>
                <td data-label="Comments">For both bipeds and quadrupeds.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.1, 2.2.2<br>Chinese: |dzou<br>Latin: ambul.are<br>Loglan: dzoru</td>
            </tr>

            <tr>
                <td data-label="Word">222</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Motions of Animals and Objects  </td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Mover X1 moves to destination X2 from origin X3 via route X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cma</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">canter</td>
                <td data-label="Phon">kantr</td>
                <td data-label="Definition">X1 canters to X2: from X3: via X4:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: !man|pao<br>Latin: <br>Loglan: jetru*</td>
            </tr>

            <tr>
                <td data-label="Word">day</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">dive, swoop</td>
                <td data-label="Phon">dayv</td>
                <td data-label="Definition">X1 swoops to X2: from X3: via X4:</td>
                <td data-label="Comments">Use -tal for diving into a pool.  Swooper stays airborne.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: !tu/ran!sia/jue<br>Latin: uryn.ary<br>Loglan: sfubu*</td>
            </tr>

            <tr>
                <td data-label="Word">fli</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fly</td>
                <td data-label="Phon">flai</td>
                <td data-label="Definition">X1 flies to X2: from X3: via X4:</td>
                <td data-label="Comments">Use -dri -fli for pilot.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: -fei<br>Latin: vol.are<br>Loglan: fleti</td>
            </tr>

            <tr>
                <td data-label="Word">flo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">float</td>
                <td data-label="Phon">flot</td>
                <td data-label="Definition">X1 floats to X2: from X3: via X4:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: /fu<br>Latin: yn.are<br>Loglan: flofu</td>
            </tr>

            <tr>
                <td data-label="Word">flu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">flow</td>
                <td data-label="Phon">flo</td>
                <td data-label="Definition">X1 flows to X2: from X3: via X4:</td>
                <td data-label="Comments">Rivers don&#x27;t flow; the water in them does.  Use -zna to get motion word arguments for a river.</td>
                <td data-label="Xref">pai</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: /lio!duw<br>Latin: flu.ere<br>Loglan: kroli</td>
            </tr>

            <tr>
                <td data-label="Word">gue</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hang</td>
                <td data-label="Phon">haw</td>
                <td data-label="Definition">X1 hangs to X2: from support X3*: via X4:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: !gua<br>Latin: pend.ere<br>Loglan: pendi</td>
            </tr>

            <tr>
                <td data-label="Word">jio</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">soak, absorb</td>
                <td data-label="Phon">sok</td>
                <td data-label="Definition">X1* soaks into X2: from X3 via X4</td>
                <td data-label="Comments">X2 is often considered the actor.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: !jin<br>Latin: byb.ere<br>Loglan: cokcu*</td>
            </tr>

            <tr>
                <td data-label="Word">jur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">turn, axis, angle, rotate</td>
                <td data-label="Phon">turn</td>
                <td data-label="Definition">X1 turns to angle X2 from X3: around axis X4</td>
                <td data-label="Comments">Alternatively, |syo for axis.  See -xye, -sye for rotation directions.</td>
                <td data-label="Xref">xye, sye</td>
                <td data-label="Notes">Rank: 10<br>Thes: 2.2.2<br>Chinese: |juan<br>Latin: konvers.yo<br>Loglan: trana</td>
            </tr>

            <tr>
                <td data-label="Word">kol</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">collide, crash</td>
                <td data-label="Phon">kolid</td>
                <td data-label="Definition">X1 crashes into target X2 from X3: via X4:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fey</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: -siaw!juaw<br>Latin: konflyg.ere<br>Loglan: janli*</td>
            </tr>

            <tr>
                <td data-label="Word">pai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">drain, empty</td>
                <td data-label="Phon">drain</td>
                <td data-label="Definition">X1 drains into X2: from X3: via X4:</td>
                <td data-label="Comments">X3 becomes empty, usually by gravity flow.</td>
                <td data-label="Xref">flu</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: /pai|quei<br>Latin: syk.are<br>Loglan: godru</td>
            </tr>

            <tr>
                <td data-label="Word">pue</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">spread</td>
                <td data-label="Phon">spred</td>
                <td data-label="Definition">X1 spreads over or into X2: from X3: via X4:</td>
                <td data-label="Comments">Dynamic, moving.</td>
                <td data-label="Xref">ten</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: -pu<br>Latin: pand.ere<br>Loglan: kuspo</td>
            </tr>

            <tr>
                <td data-label="Word">sla</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">slide, slip</td>
                <td data-label="Phon">slaid</td>
                <td data-label="Definition">X1 slips, slides to X2: from X3: via X4:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: /hua<br>Latin: laby<br>Loglan: clidu</td>
            </tr>

            <tr>
                <td data-label="Word">vol</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">roll</td>
                <td data-label="Phon">rol</td>
                <td data-label="Definition">X1 rolls to X2: from X3: via X4:</td>
                <td data-label="Comments">Moves on wheels, including turning the whole X1.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.2<br>Chinese: -gun<br>Latin: volvy<br>Loglan: gunro*</td>
            </tr>

            <tr>
                <td data-label="Word">223</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Transitive Motions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 makes cargo X2 move to destination X3 from origin X4 via route X5</td>
                <td data-label="Comments">Directional properties compound with cases X2 and X3 (mostly).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dio</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">excrete, throw~away, dump</td>
                <td data-label="Phon">ekskrit</td>
                <td data-label="Definition">X1 excretes excreta X2* into X3: from X4: via X5:</td>
                <td data-label="Comments">Also for throwing away trash.</td>
                <td data-label="Xref">dou</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: -diou!diau<br>Latin: abyk.ere<br>Loglan: sirmi*</td>
            </tr>

            <tr>
                <td data-label="Word">dou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">throw</td>
                <td data-label="Phon">trou</td>
                <td data-label="Definition">X1 throws missile X2* to X3: from X4: via X5:</td>
                <td data-label="Comments">X1 can be a machine or launcher.</td>
                <td data-label="Xref">dio</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: -diou<br>Latin: yak.ere<br>Loglan: renro</td>
            </tr>

            <tr>
                <td data-label="Word">dri</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">drive, ride, vehicle</td>
                <td data-label="Phon">draiv</td>
                <td data-label="Definition">Driver X1 drives vehicle X2* to X3: from X4: via X5:</td>
                <td data-label="Comments">For vehicles and riding animals.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: !jia|qr<br>Latin: vehy<br>Loglan: krani</td>
            </tr>

            <tr>
                <td data-label="Word">dui</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">guide</td>
                <td data-label="Phon">gaid</td>
                <td data-label="Definition">Guide X1 guides follower X2* to X3: from X4: via X5:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: !dai!lu<br>Latin: duk.ere<br>Loglan: glida</td>
            </tr>

            <tr>
                <td data-label="Word">fer</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">carry</td>
                <td data-label="Phon">kari</td>
                <td data-label="Definition">X1 carries cargo X2* to X3: from X4: via X5:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: -tiau<br>Latin: fere<br>Loglan: berti</td>
            </tr>

            <tr>
                <td data-label="Word">pei</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">push</td>
                <td data-label="Phon">p#q</td>
                <td data-label="Definition">X1 pushes X2* to X3: from X4: via X5:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: -tuei<br>Latin: pel.ere<br>Loglan: pucto</td>
            </tr>

            <tr>
                <td data-label="Word">suw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">send, messenger</td>
                <td data-label="Phon">send</td>
                <td data-label="Definition">X1 sends X2* to X3: from X4: via carrier X5</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">qly</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: !suw<br>Latin: myt.ere<br>Loglan: sundi</td>
            </tr>

            <tr>
                <td data-label="Word">swu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">suck, suction, vacuum</td>
                <td data-label="Phon">s#k</td>
                <td data-label="Definition">X1 sucks substance X2* into X3: from X4: via X5:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">jeum</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: -si<br>Latin: sug.ere<br>Loglan: sakci*</td>
            </tr>

            <tr>
                <td data-label="Word">taw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">set, place, put</td>
                <td data-label="Phon">p#t</td>
                <td data-label="Definition">X1 sets, places X2* at or on X3: from X4: via X5:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: !faw<br>Latin: statu.ere<br>Loglan: setfa</td>
            </tr>

            <tr>
                <td data-label="Word">tol</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">lift, lower</td>
                <td data-label="Phon">lyft</td>
                <td data-label="Definition">X1 lifts X2* to X3: from X4: via X5:</td>
                <td data-label="Comments">Use -vry -tol for lowering or un-lifting.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: |jiu<br>Latin: tol.ere<br>Loglan: lufta</td>
            </tr>

            <tr>
                <td data-label="Word">trl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">pull, drag</td>
                <td data-label="Phon">p#l</td>
                <td data-label="Definition">X1 pulls X2* to X3: from X4: via X5:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3<br>Chinese: -la<br>Latin: trah.ere<br>Loglan: cpula</td>
            </tr>

            <tr>
                <td data-label="Word">qly</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">mail, post</td>
                <td data-label="Phon">mail</td>
                <td data-label="Definition">X1 mails letter X2* to X3: from X4: via X5:</td>
                <td data-label="Comments">X5 is typically the carrier.</td>
                <td data-label="Xref">suw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.3, 2.3.2<br>Chinese: /iou!ji<br>Latin: lyterae<br>Loglan: mrilu*</td>
            </tr>

            <tr>
                <td data-label="Word">224</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Transitive Quasi-motions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 makes cargo X2 move to destination X3 from origin X4 via route X5</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gle</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">gather</td>
                <td data-label="Phon">gatr</td>
                <td data-label="Definition">X1 gathers (xo) X2:* from source X3</td>
                <td data-label="Comments">X2 is multi-repeated.</td>
                <td data-label="Xref">gew</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.4<br>Chinese: /qr|ci<br>Latin: leg.ere<br>Loglan: jmaji*</td>
            </tr>

            <tr>
                <td data-label="Word">gew</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">get</td>
                <td data-label="Phon">get</td>
                <td data-label="Definition">X1 gets X2:* from custodian X3</td>
                <td data-label="Comments">X3 can be a non-active reserve.  X1 comes to possess X2 (-kio).  Not for begetting.</td>
                <td data-label="Xref">gey, kio</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.4<br>Chinese: /de<br>Latin: kap.ere<br>Loglan: getsi</td>
            </tr>

            <tr>
                <td data-label="Word">gey</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">give</td>
                <td data-label="Phon">gyv</td>
                <td data-label="Definition">X1 gives gift X2* to recipient X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kio, gew</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.4<br>Chinese: |gei<br>Latin: d.are<br>Loglan: donsu</td>
            </tr>

            <tr>
                <td data-label="Word">jua</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">seek, search, look</td>
                <td data-label="Phon">src</td>
                <td data-label="Definition">X1 searches for goal X2* in or at territory X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.4<br>Chinese: /siun|jau<br>Latin: kuaer.ere<br>Loglan: sisku*</td>
            </tr>

            <tr>
                <td data-label="Word">jun</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">pursue, quarry, hunt</td>
                <td data-label="Phon">h#nt</td>
                <td data-label="Definition">X1 hunts, pursues quarry X2*</td>
                <td data-label="Comments">Strictly speaking, if X1 is not yet after a specific prey item you should say -xo -gu -X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.4<br>Chinese: /siun!jau<br>Latin: ven.ary<br>Loglan: janto</td>
            </tr>

            <tr>
                <td data-label="Word">qoe</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">harvest, reap</td>
                <td data-label="Phon">harvest</td>
                <td data-label="Definition">X1 harvests or reaps crop (xo) X2* from field X3</td>
                <td data-label="Comments">X2 is multi-repeated.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.4<br>Chinese: -qou-ge<br>Latin: met.ere<br>Loglan: crepu*</td>
            </tr>

            <tr>
                <td data-label="Word">san</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">sow, plant</td>
                <td data-label="Phon">plant</td>
                <td data-label="Definition">X1 plants X2* at or in field X3</td>
                <td data-label="Comments">Putting a plant or seed into soil.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.4<br>Chinese: |sa|juw<br>Latin: ser.ere<br>Loglan: sombo*</td>
            </tr>

            <tr>
                <td data-label="Word">225</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Static Quasi-motions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">peo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">balance</td>
                <td data-label="Phon">balans</td>
                <td data-label="Definition">X1 balances</td>
                <td data-label="Comments">Use -tuo or -qmy for the support.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: /piw/hew<br>Latin: kompenso<br>Loglan: balpi</td>
            </tr>

            <tr>
                <td data-label="Word">fle</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">load, deflect, bend</td>
                <td data-label="Phon">diflekt</td>
                <td data-label="Definition">X1 deflects under load X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vbn</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: -uan-ciu<br>Latin: deflekt.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fwi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">lay, lie, recline</td>
                <td data-label="Phon">lai</td>
                <td data-label="Definition">X1 lays on or in bed X2</td>
                <td data-label="Comments">Includes inanimate X1, horizontally oriented.  Use -can -fwi for lays down.</td>
                <td data-label="Xref">sio, duo, jan</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: !faw!sia<br>Latin: pon.ere<br>Loglan: vreta*</td>
            </tr>

            <tr>
                <td data-label="Word">jan</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">stand</td>
                <td data-label="Phon">stand</td>
                <td data-label="Definition">X1 stands on or in X2:</td>
                <td data-label="Comments">For animate X1 on its feet, or vertical inanimate X1.  Use -can -jan for stands up.</td>
                <td data-label="Xref">fwi</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: !jan<br>Latin: st.are<br>Loglan: stali</td>
            </tr>

            <tr>
                <td data-label="Word">sio</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rest, repose</td>
                <td data-label="Phon">rest</td>
                <td data-label="Definition">X1 rests or reposes on bed X2</td>
                <td data-label="Comments">For animate X1 that is resting.  Use -fwi for recline.</td>
                <td data-label="Xref">fwi</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: -siou-si<br>Latin: pon.ere<br>Loglan: resto</td>
            </tr>

            <tr>
                <td data-label="Word">duo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">sit</td>
                <td data-label="Phon">syt</td>
                <td data-label="Definition">X1 sits on or in seat X2</td>
                <td data-label="Comments">For animate X1 with its thorax vertical.  Use -can -duo for sits down.</td>
                <td data-label="Xref">fwi</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: !dzuo<br>Latin: sed.ere<br>Loglan: skitu</td>
            </tr>

            <tr>
                <td data-label="Word">ten</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">stretch</td>
                <td data-label="Phon">strec</td>
                <td data-label="Definition">X1 stretches to destination X2 from origin X3 via route X4</td>
                <td data-label="Comments">Static, not moving over.</td>
                <td data-label="Xref">pue, gzy</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: -la/caw<br>Latin: tend.ere<br>Loglan: tetcu</td>
            </tr>

            <tr>
                <td data-label="Word">tye</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">stick, adhere</td>
                <td data-label="Phon">styk</td>
                <td data-label="Definition">X1 sticks, adheres to substrate X2 by means of glue (xo) X3*</td>
                <td data-label="Comments">Insects and seeds also use spines and hooks for X3.</td>
                <td data-label="Xref">glue, fen</td>
                <td data-label="Notes">Rank: 16<br>Thes: 2.2.5<br>Chinese: -tie<br>Latin: fyg.ere<br>Loglan: gomni</td>
            </tr>

            <tr>
                <td data-label="Word">tou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">load, twist</td>
                <td data-label="Phon">tuyst</td>
                <td data-label="Definition">X1 twists under load X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.5<br>Chinese: |niou<br>Latin: torku.ere<br>Loglan: torni</td>
            </tr>

            <tr>
                <td data-label="Word">226</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Dynamic Quasi-motions and Falling Weather</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dym</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">explode</td>
                <td data-label="Phon">eksplod</td>
                <td data-label="Definition">X1 explodes into pieces X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.6<br>Chinese: !bau!ja<br>Latin: dyrumpy<br>Loglan: zbuma</td>
            </tr>

            <tr>
                <td data-label="Word">tim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">gymnast</td>
                <td data-label="Phon">jimnast</td>
                <td data-label="Definition">Gymnast X1 does gymnastic feat (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.6<br>Chinese: |ti-tsau<br>Latin: gimnyk.us<br>Loglan: gimna</td>
            </tr>

            <tr>
                <td data-label="Word">zoy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">step</td>
                <td data-label="Phon">step</td>
                <td data-label="Definition">X1 steps on or in X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.6<br>Chinese: |dzou<br>Latin: grady<br>Loglan: buste</td>
            </tr>

            <tr>
                <td data-label="Word">din</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">exchange, trade, back</td>
                <td data-label="Phon">ekscainj</td>
                <td data-label="Definition">X1 trades places with X2: via route X3</td>
                <td data-label="Comments">As decoration, means ``back&#x27;&#x27; as in ``hit him back&#x27;&#x27;.</td>
                <td data-label="Xref">dia</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.6, 1.5.5<br>Chinese: !diau!huan<br>Latin: permut.are<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">227</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Routes</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Route X1 leads to destination X2 from origin X3 via route X4</td>
                <td data-label="Comments">The arguments are the same as for ordinary motion words.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vya</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">road, street</td>
                <td data-label="Phon">rod</td>
                <td data-label="Definition">X1 is a road to X2: from X3: via X4:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vyie</td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.7<br>Chinese: !lu<br>Latin: vya<br>Loglan: rodlu</td>
            </tr>

            <tr>
                <td data-label="Word">zna</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">canal, river</td>
                <td data-label="Phon">kanal</td>
                <td data-label="Definition">X1 is a canal to X2: from X3: via X4:</td>
                <td data-label="Comments">Includes natural rivers as routes.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.7<br>Chinese: !iun/he<br>Latin: fosa<br>Loglan: kanla</td>
            </tr>

            <tr>
                <td data-label="Word">zur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">route</td>
                <td data-label="Phon">rut</td>
                <td data-label="Definition">X1 is a route to X2: from X3: via X4:</td>
                <td data-label="Comments">Compounding example: -zur -ze -zou for trail or walkway.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.2.7<br>Chinese: !lu<br>Latin: kurs.us<br>Loglan: rutma</td>
            </tr>

            <tr>
                <td data-label="Word">230</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Communication and Mental Activity</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">231</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Outgoing Communication Like Speech</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Speaker X1 says message (bi) X2 to listener X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gea</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">show, exhibit, display</td>
                <td data-label="Phon">qo</td>
                <td data-label="Definition">X1 shows object X2 to viewer X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1<br>Chinese: |gei!kan<br>Latin: ekshybyt<br>Loglan: jarco*</td>
            </tr>

            <tr>
                <td data-label="Word">glu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">greet, hail, hello, goodbye</td>
                <td data-label="Phon">grit</td>
                <td data-label="Definition">(ji) X1:M2 greets or hails listener (ju) X3M3 with signal (bi) X2</td>
                <td data-label="Comments">^glu alone means hello, while ^gr -glu means goodbye.  ^gl -glu is a nice insult.</td>
                <td data-label="Xref">qnu</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1<br>Chinese: !uen!hou<br>Latin: salut.are<br>Loglan: rinsa*</td>
            </tr>

            <tr>
                <td data-label="Word">kuw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">quote</td>
                <td data-label="Phon">kuot</td>
                <td data-label="Definition">(ji) X1M2 quotes (bi) X2:+ to (ju) X3:M3, author X4</td>
                <td data-label="Comments">Saying a text exactly as written.  When -kuw is the main predicate of a sentence you may need !vn -X2 to suppress default -bi.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1<br>Chinese: |iw!iuw<br>Latin: adf.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">pie</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">explain</td>
                <td data-label="Phon">eksplain</td>
                <td data-label="Definition">(ji) X1M2 explains event (vo) X2+ to (ju) X3:M3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1<br>Chinese: |jie!qr<br>Latin: ekspon.ere<br>Loglan: spaci*</td>
            </tr>

            <tr>
                <td data-label="Word">srn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">respond, answer</td>
                <td data-label="Phon">ansr</td>
                <td data-label="Definition">(ji) X1M2 gives answer (bi) X2+ to question (bi) X3@ speaking to (ju) X4:M2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">xue, pon</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1<br>Chinese: /huei/da<br>Latin: respond.ere<br>Loglan: dapli</td>
            </tr>

            <tr>
                <td data-label="Word">xue</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">ask, question</td>
                <td data-label="Phon">ask</td>
                <td data-label="Definition">(ji) X1M2 asks question (bi) X2+ of (ju) X3:M3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">srn, pon, stm</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1<br>Chinese: !uen<br>Latin: rog.are<br>Loglan: kenti</td>
            </tr>

            <tr>
                <td data-label="Word">jai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">say</td>
                <td data-label="Phon">sai</td>
                <td data-label="Definition">(ji) X1M2 says (bi) X2:+ to (ju) X3:M3</td>
                <td data-label="Comments">Modal case for speaker, and listener in dialog.</td>
                <td data-label="Xref">qnu, sai</td>
                <td data-label="Notes">Rank: 56<br>Thes: 2.3.1, 1.5.1<br>Chinese: |jiaw<br>Latin: dyk.ere<br>Loglan: cutse</td>
            </tr>

            <tr>
                <td data-label="Word">kam</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">cry</td>
                <td data-label="Phon">krai</td>
                <td data-label="Definition">(ji) X1M2 cries (bi) X2:+ to listener (ju) X3M3</td>
                <td data-label="Comments">Emotional upset, often but not necessarily loud.  Use -jai |kqe for shout.</td>
                <td data-label="Xref">faw, kli</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1, 1.5.2<br>Chinese: !jiau<br>Latin: klamor<br>Loglan: kraku</td>
            </tr>

            <tr>
                <td data-label="Word">faw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">emphatic</td>
                <td data-label="Phon">emfatyk</td>
                <td data-label="Definition">(ji) X1M2 says (bi) X2: emphatically to (ju) X3:M3</td>
                <td data-label="Comments">The written equivalent of loud or otherwise forceful speech.</td>
                <td data-label="Xref">kam</td>
                <td data-label="Notes">Rank: 12<br>Thes: 2.3.1, 1.5.5<br>Chinese: /ciaw!diau<br>Latin: vihemens<br>Loglan: basna*</td>
            </tr>

            <tr>
                <td data-label="Word">quo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">say, utter, language</td>
                <td data-label="Phon">utr</td>
                <td data-label="Definition">X1 utters (bi) X2:+ in language X3</td>
                <td data-label="Comments">Focus on linguistic aspect.</td>
                <td data-label="Xref">gua</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.1, 4.4.6<br>Chinese: -quo<br>Latin: ef.ary<br>Loglan: bacru*</td>
            </tr>

            <tr>
                <td data-label="Word">232</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Other Outgoing Communication</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Performer X1 performs art X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">caw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">song, sing</td>
                <td data-label="Phon">syw</td>
                <td data-label="Definition">X1M2 sings song X2 for audience (xy) X3sM3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.2<br>Chinese: !caw<br>Latin: kan.ere<br>Loglan: gritu</td>
            </tr>

            <tr>
                <td data-label="Word">fom</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">perform</td>
                <td data-label="Phon">prform</td>
                <td data-label="Definition">X1 performs work of art X2 for audience (xy) X3s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.2<br>Chinese: !si<br>Latin: fungy<br>Loglan: tigni*</td>
            </tr>

            <tr>
                <td data-label="Word">kry</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">write</td>
                <td data-label="Phon">rait</td>
                <td data-label="Definition">X1 writes message (bi) X2+ on media X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pym</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.2<br>Chinese: |sie<br>Latin: skryb.ere<br>Loglan: srite</td>
            </tr>

            <tr>
                <td data-label="Word">pym</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">print</td>
                <td data-label="Phon">prynt</td>
                <td data-label="Definition">X1 prints message (bi) X2+ on media X3</td>
                <td data-label="Comments">Using a machine rather than handwriting.</td>
                <td data-label="Xref">fpr, kry</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.2<br>Chinese: !in<br>Latin: ymprym.ere<br>Loglan: prina*</td>
            </tr>

            <tr>
                <td data-label="Word">sly</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">music, whistle</td>
                <td data-label="Phon">huysl</td>
                <td data-label="Definition">X1 whistles music X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.2<br>Chinese: -cuei|kou!qau<br>Latin: sybyl.are<br>Loglan: caslo</td>
            </tr>

            <tr>
                <td data-label="Word">koy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">think</td>
                <td data-label="Phon">tynk</td>
                <td data-label="Definition">(ji) X1M2 thinks thought (bi) X2+ to listener (zdmo) X3M3</td>
                <td data-label="Comments">Alternative modal case for speaker.  Except for psychic X1, X3 always defaults to copy X1.</td>
                <td data-label="Xref">swy</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.2, 1.5.2<br>Chinese: |siaw<br>Latin: kogyt.are<br>Loglan: penso</td>
            </tr>

            <tr>
                <td data-label="Word">233</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Influencing Other People</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Speaker X1 tells listener X2 about event (vo) X3+</td>
                <td data-label="Comments">No case merge for X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">byl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">publicize</td>
                <td data-label="Phon">publysyz</td>
                <td data-label="Definition">X1 publicizes (vo) X3:+ to audience X2</td>
                <td data-label="Comments">No case merge in case of self-promotion.  Note different case order from English.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: -gow-kai.-de#<br>Latin: kelebrytas<br>Loglan: blako</td>
            </tr>

            <tr>
                <td data-label="Word">kue</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">request, ask</td>
                <td data-label="Phon">rikuest</td>
                <td data-label="Definition">X1 requests to get thing X2 from custodian X3</td>
                <td data-label="Comments">Use -ciu to ask that X2 do something.</td>
                <td data-label="Xref">ciu</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: |ciw/ciou<br>Latin: prek.ary<br>Loglan: begco</td>
            </tr>

            <tr>
                <td data-label="Word">cuy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">suggest</td>
                <td data-label="Phon">sugjest</td>
                <td data-label="Definition">X1M2 suggests to (ju) X2:M3 that it do (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: /ti-cu<br>Latin: subyk.ere<br>Loglan: sange</td>
            </tr>

            <tr>
                <td data-label="Word">fal</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">deceive</td>
                <td data-label="Phon">disiv</td>
                <td data-label="Definition">X1 deceives X2: about (vo) X3:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: !u|in<br>Latin: fal.ere<br>Loglan: dupma</td>
            </tr>

            <tr>
                <td data-label="Word">gau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">warn</td>
                <td data-label="Phon">uarn</td>
                <td data-label="Definition">X1M2 warns (ju) X2:M3 about (vo) X3:+2</td>
                <td data-label="Comments">!xe X3 for an object, but a phrase is preferred for X3, e.g. -zu -crw !kqeo ``being eaten by the lion&#x27;&#x27; rather than just ``the lion&#x27;&#x27;.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: |jiw!gau<br>Latin: mon.ere<br>Loglan: kurni</td>
            </tr>

            <tr>
                <td data-label="Word">pom</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">promise</td>
                <td data-label="Phon">promys</td>
                <td data-label="Definition">X1M2 promises to (ju) X2:M3 that it will do (vo) X3:+1</td>
                <td data-label="Comments">X1 may or may not actually do it.  No case merge for X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: -da!iw<br>Latin: promyt.ere<br>Loglan: nupre*</td>
            </tr>

            <tr>
                <td data-label="Word">qlr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">honest</td>
                <td data-label="Phon">anest</td>
                <td data-label="Definition">X1 is honest with X2: about (vo) X3:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: |lau/qr<br>Latin: prob.us<br>Loglan: nesta</td>
            </tr>

            <tr>
                <td data-label="Word">sai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">say, assert</td>
                <td data-label="Phon">sai</td>
                <td data-label="Definition">X1 says that relation (vo) X2+ is true</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">jai</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: -quo<br>Latin: adfirm.are<br>Loglan: cutse</td>
            </tr>

            <tr>
                <td data-label="Word">teu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">protest</td>
                <td data-label="Phon">protest</td>
                <td data-label="Definition">X1M2 protests to (ju) X2:M3 about (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: |ju-jaw<br>Latin: rekus.are<br>Loglan: prutu</td>
            </tr>

            <tr>
                <td data-label="Word">tuw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">consent</td>
                <td data-label="Phon">knsent</td>
                <td data-label="Definition">X1 consents to do action (vo) X2+1 per requester X3</td>
                <td data-label="Comments">-tuw -juy if someone other than X1 will do it.</td>
                <td data-label="Xref">juy</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: /tuw!i<br>Latin: vele<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ciu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">request, ask</td>
                <td data-label="Phon">rikuest</td>
                <td data-label="Definition">X1M2 requests that (ju) X2:M3 do (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kue</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3<br>Chinese: |ciw/ciou<br>Latin: prek.ary<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">twi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">agree</td>
                <td data-label="Phon">agri</td>
                <td data-label="Definition">X1 agrees with X2: that fact (vo) X3+ is true</td>
                <td data-label="Comments">No case merge.  X2 is the primary holder of the opinion.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3, 1.1.5<br>Chinese: /tuw-i<br>Latin: konkyn.ere<br>Loglan: togri</td>
            </tr>

            <tr>
                <td data-label="Word">jim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">teach</td>
                <td data-label="Phon">tic</td>
                <td data-label="Definition">X1 teaches student X2 to do skill (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sui</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3, 2.1.6<br>Chinese: -jiau<br>Latin: dok.ere<br>Loglan: ditca</td>
            </tr>

            <tr>
                <td data-label="Word">xur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">curse, damn</td>
                <td data-label="Phon">kurs</td>
                <td data-label="Definition">X1 curses victim X2 to have (vo) X3:+2 happen by words or ritual (bi) X4@</td>
                <td data-label="Comments">Explicit !vo required for ritual.  A curse is usually bad for X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.3, 2.4.6<br>Chinese: !jou|dzu<br>Latin: eksekr.ary<br>Loglan: dapma*</td>
            </tr>

            <tr>
                <td data-label="Word">234</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Expressing How One Feels</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Experiencer X1 has a feeling about actor X2 doing event (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">ridicule, mock, scoff</td>
                <td data-label="Phon">skaf</td>
                <td data-label="Definition">X1 ridicules X2: for doing (vo) X3:+2</td>
                <td data-label="Comments">Use -cau =smi -qyw (ridicule wise behavior) for mock.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.4<br>Chinese: /cau!siau<br>Latin: deryd.ere<br>Loglan: ckasu*</td>
            </tr>

            <tr>
                <td data-label="Word">fry</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">laugh</td>
                <td data-label="Phon">laf</td>
                <td data-label="Definition">X1 laughs at event (vo) X2+</td>
                <td data-label="Comments">Laugh at a person: let -vo turn objects into events.</td>
                <td data-label="Xref">kqn</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.4<br>Chinese: !siau<br>Latin: ryd.ere<br>Loglan: clafo</td>
            </tr>

            <tr>
                <td data-label="Word">jou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">frown</td>
                <td data-label="Phon">fraun</td>
                <td data-label="Definition">X1 frowns at event (vo) X2+</td>
                <td data-label="Comments">Frown at a person: let -vo turn objects into events.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.4<br>Chinese: !jou/mei/tou<br>Latin: <br>Loglan: frumu*</td>
            </tr>

            <tr>
                <td data-label="Word">sma</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">smile</td>
                <td data-label="Phon">smail</td>
                <td data-label="Definition">X1 smiles at event (vo) X2+</td>
                <td data-label="Comments">Smile at a person: let -vo turn objects into events.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.4<br>Chinese: !siau<br>Latin: ryd.ere<br>Loglan: crano</td>
            </tr>

            <tr>
                <td data-label="Word">tan</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">annoy</td>
                <td data-label="Phon">anoi</td>
                <td data-label="Definition">X1 is annoyed that X2: does (vo) X3:+2</td>
                <td data-label="Comments">No automatic merge for X1.</td>
                <td data-label="Xref">gri</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.4<br>Chinese: |tau!ian<br>Latin: veks.are<br>Loglan: groci</td>
            </tr>

            <tr>
                <td data-label="Word">pli</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">please</td>
                <td data-label="Phon">pliz</td>
                <td data-label="Definition">(ji) X1 feels pleased that X2: does (vo) X3:+2</td>
                <td data-label="Comments">For English decoration &quot;please&quot; on imperatives.</td>
                <td data-label="Xref">dwl, kmi, gny</td>
                <td data-label="Notes">Rank: 13<br>Thes: 2.3.4, 2.4.5, 1.5.5, 2.1.1<br>Chinese: |ciw<br>Latin: sis<br>Loglan: pluci</td>
            </tr>

            <tr>
                <td data-label="Word">235</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Mental Activity</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Thinker X1 thinks that object X2* has property (vo) X3+2 because of input data (vo) X4+2@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dil</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">deduce</td>
                <td data-label="Phon">didus</td>
                <td data-label="Definition">X1 deduces that X2: is (vo) X3:+2 from input data (vo) X4+2@</td>
                <td data-label="Comments">There exists a logic (-sny, q.v.) from X4 to X3, which X1 discovers.</td>
                <td data-label="Xref">klu</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: -tuei!lu#n<br>Latin: konlyg.ere<br>Loglan: didni*</td>
            </tr>

            <tr>
                <td data-label="Word">diw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">decide</td>
                <td data-label="Phon">disaid</td>
                <td data-label="Definition">X1 decides that X2: is (vo) X3:+2 from input data (vo) X4+2@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: /jue!diw<br>Latin: statu.ere<br>Loglan: disri</td>
            </tr>

            <tr>
                <td data-label="Word">dme</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">remember, remind</td>
                <td data-label="Phon">rimembr</td>
                <td data-label="Definition">X1 remembers that X2: is (vo) X3:+2 prompted by input data (vo) X4+2@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: !ji-de<br>Latin: memynyse<br>Loglan: driki</td>
            </tr>

            <tr>
                <td data-label="Word">dyu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">judge</td>
                <td data-label="Phon">j#j</td>
                <td data-label="Definition">X1 judges that X2: is (vo) X3:+2 from input data (vo) X4+2@</td>
                <td data-label="Comments">Authoritative determination, not estimation, but not necessarily in court.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: |qen!pan<br>Latin: yudyk.are<br>Loglan: djudi</td>
            </tr>

            <tr>
                <td data-label="Word">klu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">infer</td>
                <td data-label="Phon">ynfr</td>
                <td data-label="Definition">X1 infers that X2: is (vo) X3:+2 from fact (vo) X4+2@</td>
                <td data-label="Comments">Compared to the logic (-sny, q.v.) of a deduction, inferential reasoning is based more on experience and probability.</td>
                <td data-label="Xref">zny, dil</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: -tuei!lun<br>Latin: konklud.ere<br>Loglan: nusna*</td>
            </tr>

            <tr>
                <td data-label="Word">pwi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">estimate</td>
                <td data-label="Phon">estymait</td>
                <td data-label="Definition">X1 estimates that X2: is (vo) X3:+2 from input data (vo) X4+2@</td>
                <td data-label="Comments">Generally X3 is quantitative.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: /piw!jia<br>Latin: kens.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qny</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">intuition</td>
                <td data-label="Phon">yntuyqn</td>
                <td data-label="Definition">X1 intuits that X2: is (vo) X3:+2 from input data (vo) X4+2@</td>
                <td data-label="Comments">Intuition.  The logic (-sny, q.v.), if any, from X4 to X3 is found only afterwards, if at all.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: !duw/ca<br>Latin: kognyt.yo<br>Loglan: jijnu*</td>
            </tr>

            <tr>
                <td data-label="Word">sui</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">learn</td>
                <td data-label="Phon">lrn</td>
                <td data-label="Definition">X1 learns to do skill (xo-vo) X2+1 from teacher X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">jim</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: /sue/si<br>Latin: dysk.ere<br>Loglan: cirna</td>
            </tr>

            <tr>
                <td data-label="Word">swy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">think</td>
                <td data-label="Phon">tynk</td>
                <td data-label="Definition">X1 thinks about affair (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">koy, cre</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: |siaw<br>Latin: kogyt.are<br>Loglan: penso</td>
            </tr>

            <tr>
                <td data-label="Word">zyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">discover</td>
                <td data-label="Phon">dysk#vr</td>
                <td data-label="Definition">X1 discovers that X2: is (vo) X3:+2 from input data (vo) X4+2@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.5<br>Chinese: -fa!sian<br>Latin: ynven.yre<br>Loglan: duvri</td>
            </tr>

            <tr>
                <td data-label="Word">236</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">States of Knowledge</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Thinker X1 knows that object X2* has property (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">believe</td>
                <td data-label="Phon">biliv</td>
                <td data-label="Definition">X1 believes that X2: is (vo) X3:+2    </td>
                <td data-label="Comments"></td>
                <td data-label="Xref">swy</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: -siaw!sin<br>Latin: cred.ere<br>Loglan: krido</td>
            </tr>

            <tr>
                <td data-label="Word">dua</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">doubt</td>
                <td data-label="Phon">daut</td>
                <td data-label="Definition">X1 doubts that X2: is (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: /huai/i<br>Latin: dubyt.are<br>Loglan: dutci</td>
            </tr>

            <tr>
                <td data-label="Word">dwe</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">certain</td>
                <td data-label="Phon">srten</td>
                <td data-label="Definition">X1 is certain that X2: is (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: /i!diw<br>Latin: kert.us<br>Loglan: sirna</td>
            </tr>

            <tr>
                <td data-label="Word">fun</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">confuse</td>
                <td data-label="Phon">kunfiuz</td>
                <td data-label="Definition">X1 is confused about X2: its property (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: |hu#n!luan<br>Latin: konfus.us<br>Loglan: cfipu*</td>
            </tr>

            <tr>
                <td data-label="Word">kui</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">curious</td>
                <td data-label="Phon">kuri#s</td>
                <td data-label="Definition">X1 is curious about X2: its property (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: !hau/ci-sin<br>Latin: kuryos.us<br>Loglan: kucli*</td>
            </tr>

            <tr>
                <td data-label="Word">pyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">opinion</td>
                <td data-label="Phon">opyni#n</td>
                <td data-label="Definition">X1 holds the opinion that X2: is (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">ciw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: !i!jian<br>Latin: opyn.yo<br>Loglan: jupni</td>
            </tr>

            <tr>
                <td data-label="Word">sim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">seem</td>
                <td data-label="Phon">sim</td>
                <td data-label="Definition">It seems to X1: that X2: is (vo) X3:+2</td>
                <td data-label="Comments">X1&#x27;s information says so, but may or may not be true.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: |hau!siaw<br>Latin: vyd.ery<br>Loglan: simci</td>
            </tr>

            <tr>
                <td data-label="Word">tel</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">understand</td>
                <td data-label="Phon">undrstand</td>
                <td data-label="Definition">X1 understands that X2: is (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: /miw-bai<br>Latin: yntelyg.ere<br>Loglan: jimpe*</td>
            </tr>

            <tr>
                <td data-label="Word">xou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">know</td>
                <td data-label="Phon">nou</td>
                <td data-label="Definition">X1 knows that X2: is (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: -jr-dau<br>Latin: sk.ire<br>Loglan: djano</td>
            </tr>

            <tr>
                <td data-label="Word">xny</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">guess, conjecture</td>
                <td data-label="Phon">ges</td>
                <td data-label="Definition">X1 guesses that X2: is (vo) X3:+2</td>
                <td data-label="Comments">An English guess is an answer; in \guaspi\  it is an opinion: static.  There is not enough information to be sure of it.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6<br>Chinese: -tsai<br>Latin: konyk.ere<br>Loglan: smadi*</td>
            </tr>

            <tr>
                <td data-label="Word">ciw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">opinion, subjective, feel</td>
                <td data-label="Phon">fil</td>
                <td data-label="Definition">X1 feels that subjective opinion (vo) X2+ is true</td>
                <td data-label="Comments">Modal case for the holder of a subjective opinion.</td>
                <td data-label="Xref">gae, sen, pyn</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6, 2.5.1, 1.5.2<br>Chinese: /gan|ciw<br>Latin: kap.ere<br>Loglan: filmo</td>
            </tr>

            <tr>
                <td data-label="Word">237</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Incoming Communication and Sensing</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Experiencer X1 perceives event (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">den</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">spectator, audience</td>
                <td data-label="Phon">audiens</td>
                <td data-label="Definition">X1M3 is a spectator or member of the audience at event (vo) X2+3 performer X3M2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">qou, knl</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7, 1.5.2<br>Chinese: -guan!dzow<br>Latin: audyent.es<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">dream</td>
                <td data-label="Phon">drim</td>
                <td data-label="Definition">X1M3 dreams event (vo) X2+3 done by (zdmo) X3:M2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: !m#w<br>Latin: somni.um<br>Loglan: revri</td>
            </tr>

            <tr>
                <td data-label="Word">jue</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">aware, conscious</td>
                <td data-label="Phon">auar</td>
                <td data-label="Definition">X1 is conscious or aware of (vo) X2:+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: /jue!u<br>Latin: sk.ire<br>Loglan: kance</td>
            </tr>

            <tr>
                <td data-label="Word">kan</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">read, book</td>
                <td data-label="Phon">rid</td>
                <td data-label="Definition">X1 reads text X2</td>
                <td data-label="Comments">The referent of X2 should be a text.  If the text has a title, that may appear (as a name) in X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: !kan<br>Latin: leg.ere<br>Loglan: ridle</td>
            </tr>

            <tr>
                <td data-label="Word">knl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">look</td>
                <td data-label="Phon">l#k</td>
                <td data-label="Definition">X1 looks at object X2</td>
                <td data-label="Comments">By eyeball.  Use -qnu, -kur, -den for various kinds of paying attention.</td>
                <td data-label="Xref">qnu, kur, den, qou</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: !kan<br>Latin: <br>Loglan: bleka</td>
            </tr>

            <tr>
                <td data-label="Word">kur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">attention</td>
                <td data-label="Phon">atenqn</td>
                <td data-label="Definition">X1 pays attention to event (vo) X2+</td>
                <td data-label="Comments">Use -qnu for data attended to.</td>
                <td data-label="Xref">qnu, knl</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: /lio/qin<br>Latin: kur.are<br>Loglan: tedji</td>
            </tr>

            <tr>
                <td data-label="Word">pen</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">perceive</td>
                <td data-label="Phon">persiv</td>
                <td data-label="Definition">X1 perceives event (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: -fa/jue<br>Latin: sent.yre<br>Loglan: simci</td>
            </tr>

            <tr>
                <td data-label="Word">qou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">watch</td>
                <td data-label="Phon">uac</td>
                <td data-label="Definition">X1 watches actor X2 do event (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">den, knl</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: -kan|qou<br>Latin: tu.ery<br>Loglan: katca</td>
            </tr>

            <tr>
                <td data-label="Word">tia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hear, sound, background</td>
                <td data-label="Phon">hiar</td>
                <td data-label="Definition">X1 hears sound (vo) X2+ against background (vo) X3@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sau, fsn</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: -tiw<br>Latin: aud.ire<br>Loglan: hirti</td>
            </tr>

            <tr>
                <td data-label="Word">vyi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">see, background</td>
                <td data-label="Phon">si</td>
                <td data-label="Definition">X1 sees object X2 against background X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7<br>Chinese: !kan<br>Latin: vyd.ere<br>Loglan: vizka</td>
            </tr>

            <tr>
                <td data-label="Word">qnu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">attention</td>
                <td data-label="Phon">atenqn</td>
                <td data-label="Definition">X1M3 attends to information (bi) X2+ from source or speaker X3M2</td>
                <td data-label="Comments">Modal case for listener.  -qnu is said by speaker; in dialog the narrator uses |jai !sa X instead.</td>
                <td data-label="Xref">kur, knl, glu, jai</td>
                <td data-label="Notes">Rank: 13<br>Thes: 2.3.7, 1.5.1<br>Chinese: !ju!i<br>Latin: kur.are<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sen</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">experience, sense, stimulus</td>
                <td data-label="Phon">sens</td>
                <td data-label="Definition">X1 senses stimulus (vo) X2+</td>
                <td data-label="Comments">Modal case for experiencer of more-or-less objective sensations.  X2 includes mental states like -psw (ordinary).</td>
                <td data-label="Xref">gae, ciw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.7, 1.5.2<br>Chinese: |gan/jue<br>Latin: sens.us<br>Loglan: speni</td>
            </tr>

            <tr>
                <td data-label="Word">240</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Transitive Activities</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Transitive means an actor does something to an object.  Most predicates are not transitive.  Use -qma to make them so.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">241</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Life Activities</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 does some life activity</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bri</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">breath</td>
                <td data-label="Phon">brit</td>
                <td data-label="Definition">X1 breathes air (xo) X2</td>
                <td data-label="Comments">X2 can be another breathing gas, or water in drowning.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: -hu-si<br>Latin: spyr.are<br>Loglan: brute</td>
            </tr>

            <tr>
                <td data-label="Word">gva</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">awake</td>
                <td data-label="Phon">auak</td>
                <td data-label="Definition">X1 is awake</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: |qiw<br>Latin: vygylans<br>Loglan: cidja</td>
            </tr>

            <tr>
                <td data-label="Word">jey</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">digest</td>
                <td data-label="Phon">dyjest</td>
                <td data-label="Definition">X1 digests food X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: -siau!hua<br>Latin: konkok.ere<br>Loglan: djesi</td>
            </tr>

            <tr>
                <td data-label="Word">jie</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hunger, thirst</td>
                <td data-label="Phon">hungr</td>
                <td data-label="Definition">X1 hungers to do activity (vo) X2+1</td>
                <td data-label="Comments">Feels a strong physiological drive.  Needs -jie -crw for hungers to eat.</td>
                <td data-label="Xref">pel</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: !jie<br>Latin: avyd.us<br>Loglan: kanji*</td>
            </tr>

            <tr>
                <td data-label="Word">pqi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">sleep</td>
                <td data-label="Phon">slip</td>
                <td data-label="Definition">X1 sleeps</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: !quei<br>Latin: dorm.yre<br>Loglan: sonli</td>
            </tr>

            <tr>
                <td data-label="Word">sil</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">relax</td>
                <td data-label="Phon">rilaks</td>
                <td data-label="Definition">X1 relaxes itself by doing activity (vo) X2+1</td>
                <td data-label="Comments">X1 is usually a person.</td>
                <td data-label="Xref">ksw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: -siou-si<br>Latin: languysk.ere<br>Loglan: surla*</td>
            </tr>

            <tr>
                <td data-label="Word">sou</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">cough</td>
                <td data-label="Phon">kaf</td>
                <td data-label="Definition">X1 coughs up sputum (xo) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: /k#!sou<br>Latin: tuss.yre<br>Loglan: kafso</td>
            </tr>

            <tr>
                <td data-label="Word">ste</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">wear~out</td>
                <td data-label="Phon">uer-aut</td>
                <td data-label="Definition">X1 wears out by itself</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">ksi, xda</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: !puo|suen<br>Latin: ter.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tsn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">sneeze</td>
                <td data-label="Phon">sniz</td>
                <td data-label="Definition">X1 sneezes</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: |da!ti-p#n<br>Latin: sternu.ere<br>Loglan: tsani</td>
            </tr>

            <tr>
                <td data-label="Word">vde</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">alive</td>
                <td data-label="Phon">#layv</td>
                <td data-label="Definition">X1 is alive</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1<br>Chinese: /huo-de<br>Latin: vyv.us<br>Loglan: clivi</td>
            </tr>

            <tr>
                <td data-label="Word">vom</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">vomit</td>
                <td data-label="Phon">vamyt</td>
                <td data-label="Definition">X1 vomits substance (xo) X2* on target X3 from origin X4 via route X5</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1, 2.2.3<br>Chinese: |ou<br>Latin: vom.ere<br>Loglan: vamtu</td>
            </tr>

            <tr>
                <td data-label="Word">kli</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">weep, cry, tear</td>
                <td data-label="Phon">uip</td>
                <td data-label="Definition">X1 weeps tears (xo) X2 because event (vo) X3+1 happens</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kam</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.1, 2.3.4<br>Chinese: /liou!lei<br>Latin: lakrym.are<br>Loglan: klaku*</td>
            </tr>

            <tr>
                <td data-label="Word">242</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Making Objects</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Producer X1 makes product X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">brw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">birth</td>
                <td data-label="Phon">brt</td>
                <td data-label="Definition">X1 gives birth to baby X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2<br>Chinese: -q#w<br>Latin: par.ere<br>Loglan: brana</td>
            </tr>

            <tr>
                <td data-label="Word">fwo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">sew</td>
                <td data-label="Phon">so</td>
                <td data-label="Definition">X1 sews part X2 onto clothes X3</td>
                <td data-label="Comments">Attaches X2 by sewing, or joins similar-sized X2 and X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2<br>Chinese: /f#w<br>Latin: su.ere<br>Loglan: djoso</td>
            </tr>

            <tr>
                <td data-label="Word">jre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">weave</td>
                <td data-label="Phon">uiv</td>
                <td data-label="Definition">X1 weaves cloth X2 from thread (xo) X3</td>
                <td data-label="Comments">X3 is the type of thread used, e.g. wool.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2<br>Chinese: -jr<br>Latin: teks.ere<br>Loglan: jivna*</td>
            </tr>

            <tr>
                <td data-label="Word">vey</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">invent</td>
                <td data-label="Phon">ynvent</td>
                <td data-label="Definition">X1 invents apparatus X2 that performs function (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2<br>Chinese: -fa/miw<br>Latin: ynven.yre<br>Loglan: vetfa</td>
            </tr>

            <tr>
                <td data-label="Word">zor</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">organize, system</td>
                <td data-label="Phon">org#naiz</td>
                <td data-label="Definition">X1 organizes parts (xy) X2s into system X3s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">smu</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2<br>Chinese: |dzu/jr<br>Latin: ordyn.are<br>Loglan: ganli</td>
            </tr>

            <tr>
                <td data-label="Word">dma</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">make, material</td>
                <td data-label="Phon">maik</td>
                <td data-label="Definition">X1 makes X2:* out of material (xo) X3</td>
                <td data-label="Comments">X2 should be a unitary object, not a system, for which use -smu.  -qma for transitive make.</td>
                <td data-label="Xref">smu, qma</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2<br>Chinese: !dzuo<br>Latin: fak.ere<br>Loglan: makso</td>
            </tr>

            <tr>
                <td data-label="Word">smu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">assemble, system, build</td>
                <td data-label="Phon">asembl</td>
                <td data-label="Definition">X1 builds or assembles system X2s by adding parts X3</td>
                <td data-label="Comments">Use -dma for a unitary object.</td>
                <td data-label="Xref">dma, zor, cur</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2, 2.1.1<br>Chinese: -qou/ji<br>Latin: stru.ere<br>Loglan: balci</td>
            </tr>

            <tr>
                <td data-label="Word">kow</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">cook, eat</td>
                <td data-label="Phon">k#k</td>
                <td data-label="Definition">X1 cooks food X2* for eater X3</td>
                <td data-label="Comments">Usually involves heat but includes preparing wholly cold food.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2, 4.3.5<br>Chinese: |ju!fan<br>Latin: kok.ere<br>Loglan: kokfa</td>
            </tr>

            <tr>
                <td data-label="Word">zde</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">designer, architect, engineer</td>
                <td data-label="Phon">dizain</td>
                <td data-label="Definition">X1 is an architect or designer of (xi) X2:*</td>
                <td data-label="Comments">Explicit !xe needed to say X1 designed a specific X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.2, 4.6.3<br>Chinese: !qe!ji<br>Latin: desygn.are<br>Loglan: tekto</td>
            </tr>

            <tr>
                <td data-label="Word">243</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Using Up or Destroying Objects</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 uses up object X2* making pieces X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">byw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">drink</td>
                <td data-label="Phon">drywk</td>
                <td data-label="Definition">X1 drinks beverage (xo) X2* out of vessel X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: -h#<br>Latin: byb.ere<br>Loglan: hompi</td>
            </tr>

            <tr>
                <td data-label="Word">cie</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">cut</td>
                <td data-label="Phon">k#t</td>
                <td data-label="Definition">X1 cuts X2: into pieces (xo) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: -cie<br>Latin: sek.are<br>Loglan: kutla</td>
            </tr>

            <tr>
                <td data-label="Word">fua</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">waste</td>
                <td data-label="Phon">uast</td>
                <td data-label="Definition">X1 wastes (xo) X2:* on activity (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">siu</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: !law!fei<br>Latin: efus.yo<br>Loglan: festi</td>
            </tr>

            <tr>
                <td data-label="Word">gmo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">grind</td>
                <td data-label="Phon">graind</td>
                <td data-label="Definition">X1 grinds X2: into powder (xo) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: /muo<br>Latin: mol.ere<br>Loglan: zalvi*</td>
            </tr>

            <tr>
                <td data-label="Word">koe</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">squish, squash, pulp, smash</td>
                <td data-label="Phon">skuaq</td>
                <td data-label="Definition">X1 smashes, squishes X2:* into a pulp (xo) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">sue</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: -ia!lan<br>Latin: konter.ere<br>Loglan: kraco</td>
            </tr>

            <tr>
                <td data-label="Word">poi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">destroy</td>
                <td data-label="Phon">destroi</td>
                <td data-label="Definition">X1 destroys X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: !puo!huai<br>Latin: perd.ere<br>Loglan: hutri</td>
            </tr>

            <tr>
                <td data-label="Word">siu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">consume, use, deplete</td>
                <td data-label="Phon">iuz</td>
                <td data-label="Definition">X1 uses up (xo) X2:* on activity (vo) X3+1</td>
                <td data-label="Comments">Not implying waste.</td>
                <td data-label="Xref">fua</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: -siau!hau<br>Latin: konsum.ere<br>Loglan: xaksu*</td>
            </tr>

            <tr>
                <td data-label="Word">sue</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">crunch, crush</td>
                <td data-label="Phon">kruq</td>
                <td data-label="Definition">X1 crushes, crunches X2:* into pieces (xo) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">koe</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: -ia!suei<br>Latin: oprym.ere<br>Loglan: zakra</td>
            </tr>

            <tr>
                <td data-label="Word">ter</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">tear, rip</td>
                <td data-label="Phon">ter</td>
                <td data-label="Definition">X1 tears X2: into shreds (xo) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: -sz!puo<br>Latin: skind.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">scrape</td>
                <td data-label="Phon">skraip</td>
                <td data-label="Definition">X1 scrapes X2:* dislodging shavings (xo) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.3<br>Chinese: -siau<br>Latin: rad.ere<br>Loglan: guska*</td>
            </tr>

            <tr>
                <td data-label="Word">crw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">eat</td>
                <td data-label="Phon">it</td>
                <td data-label="Definition">X1 eats food X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kqu</td>
                <td data-label="Notes">Rank: 13<br>Thes: 2.4.3, 4.3.5<br>Chinese: -cr<br>Latin: ed.are<br>Loglan: titci</td>
            </tr>

            <tr>
                <td data-label="Word">244</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Using Objects</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 uses object X2* in relation to object X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dry</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">distribute</td>
                <td data-label="Phon">dystrybiut</td>
                <td data-label="Definition">X1 distributes goods (xo) X2 to or among the members of set (xy) X3s</td>
                <td data-label="Comments">X2 is often servings but can be a set whose members are distributed.</td>
                <td data-label="Xref">xre</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: -fen|gei<br>Latin: dystrybu.ere<br>Loglan: petri</td>
            </tr>

            <tr>
                <td data-label="Word">fyl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fill, inflate</td>
                <td data-label="Phon">fyl</td>
                <td data-label="Definition">X1 fills vessel X2 with content (xo) X3*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: -cuw|man<br>Latin: ympl.ere<br>Loglan: flati</td>
            </tr>

            <tr>
                <td data-label="Word">qia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">bath</td>
                <td data-label="Phon">bat</td>
                <td data-label="Definition">X1 bathes in liquid (xo) X2*</td>
                <td data-label="Comments">X2 is the bathwater; use -xyn or -vel for a bathtub.</td>
                <td data-label="Xref">vla</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: |qi|dzau<br>Latin: lav.ary<br>Loglan: banci</td>
            </tr>

            <tr>
                <td data-label="Word">suo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rub</td>
                <td data-label="Phon">r#b</td>
                <td data-label="Definition">X1 rubs X2: with X3:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: -tsuo<br>Latin: ter.ere<br>Loglan: satro</td>
            </tr>

            <tr>
                <td data-label="Word">tmu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">touch</td>
                <td data-label="Phon">t#c</td>
                <td data-label="Definition">X1 touches X2: with X3:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tao</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: -muo<br>Latin: tang.ere<br>Loglan: totco</td>
            </tr>

            <tr>
                <td data-label="Word">vla</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">wash</td>
                <td data-label="Phon">uaq</td>
                <td data-label="Definition">X1 washes X2: in liquid (xo) X3</td>
                <td data-label="Comments">X3 is the bathwater; use |xyn or |vel for a bathtub.</td>
                <td data-label="Xref">qia</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: |si<br>Latin: lav.are<br>Loglan: vlaci</td>
            </tr>

            <tr>
                <td data-label="Word">xna</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hold</td>
                <td data-label="Phon">hold</td>
                <td data-label="Definition">X1 holds X2: with its body part X3-1</td>
                <td data-label="Comments">Not for the hold of a ship.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: /na<br>Latin: ten.ere<br>Loglan: jugra</td>
            </tr>

            <tr>
                <td data-label="Word">xre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">share</td>
                <td data-label="Phon">qer</td>
                <td data-label="Definition">Share X1 pertains to recipient X2 of goods (xo) X3* being distributed among set (xy) X4s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">dry</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4<br>Chinese: !fen<br>Latin: pars<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sle</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">select, choose</td>
                <td data-label="Phon">selekt</td>
                <td data-label="Definition">X1 selects member X2* from set (xy) X3s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4, 1.1.8<br>Chinese: -tiau|suan<br>Latin: leg.ere<br>Loglan: tisra</td>
            </tr>

            <tr>
                <td data-label="Word">tme</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">measure</td>
                <td data-label="Phon">mexr</td>
                <td data-label="Definition">X1 measures object X2 in quality (vo) X3+2</td>
                <td data-label="Comments">Use |pa or |kun for the result.</td>
                <td data-label="Xref">kun</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4, 1.3.6<br>Chinese: /liaw<br>Latin: met.yry<br>Loglan: merli</td>
            </tr>

            <tr>
                <td data-label="Word">ven</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">sell, buy, price</td>
                <td data-label="Phon">sel</td>
                <td data-label="Definition">X1 sells X2:* to buyer X3 for price X4</td>
                <td data-label="Comments">Use -dia for non-money trade.  Use -za -ven for buy.</td>
                <td data-label="Xref">dia</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.4, 4.7.2, 4.7.3<br>Chinese: !mai<br>Latin: vend.ere<br>Loglan: vedma</td>
            </tr>

            <tr>
                <td data-label="Word">245</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Helping or Transforming Objects</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 makes object X2* be or do event (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">few</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">protect, defend</td>
                <td data-label="Phon">protekt</td>
                <td data-label="Definition">X1 protects X2: from (vo) X3:+2</td>
                <td data-label="Comments">X1 can be an actor or an artifact e.g. paint.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5<br>Chinese: /faw!bei<br>Latin: defend.ere<br>Loglan: bandu*</td>
            </tr>

            <tr>
                <td data-label="Word">fol</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fold</td>
                <td data-label="Phon">fold</td>
                <td data-label="Definition">X1 folds X2:*</td>
                <td data-label="Comments">|pa for how many times.  Not for a corral.</td>
                <td data-label="Xref">vjou</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5<br>Chinese: /je<br>Latin: plyk.are<br>Loglan: foldi</td>
            </tr>

            <tr>
                <td data-label="Word">fyo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">repair, fix</td>
                <td data-label="Phon">fyks</td>
                <td data-label="Definition">X1 fixes, repairs X2: its fault (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kme</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5<br>Chinese: |siou|li<br>Latin: refyk.ere<br>Loglan: nakso</td>
            </tr>

            <tr>
                <td data-label="Word">jew</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">adjust</td>
                <td data-label="Phon">aj#st</td>
                <td data-label="Definition">X1 adjusts X2: in its function (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5<br>Chinese: |jew|ly<br>Latin: ordyn.are<br>Loglan: stuli</td>
            </tr>

            <tr>
                <td data-label="Word">kar</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">care, custodian</td>
                <td data-label="Phon">kar</td>
                <td data-label="Definition">Custodian X1 takes care of X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5<br>Chinese: !dzao!gu<br>Latin: kur.are<br>Loglan: kerju</td>
            </tr>

            <tr>
                <td data-label="Word">sru</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">serve</td>
                <td data-label="Phon">srv</td>
                <td data-label="Definition">X1 serves client X2 by doing (vo) X3:+1</td>
                <td data-label="Comments">Use -gey or -gey -fw -sru for serving food.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5<br>Chinese: /fu!u<br>Latin: serv.yre<br>Loglan: surva</td>
            </tr>

            <tr>
                <td data-label="Word">trm</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">stir</td>
                <td data-label="Phon">str</td>
                <td data-label="Definition">X1 stirs X2:*</td>
                <td data-label="Comments">|tum for the tool.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5<br>Chinese: |jiau<br>Latin: mov.ere<br>Loglan: jicla*</td>
            </tr>

            <tr>
                <td data-label="Word">xia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">reward</td>
                <td data-label="Phon">riuard</td>
                <td data-label="Definition">X1 rewards actor X2 for doing (vo) X3:+2 with reward X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pny</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5, 2.1.6<br>Chinese: |jiaw|qaw<br>Latin: remuner.ary<br>Loglan: barda</td>
            </tr>

            <tr>
                <td data-label="Word">gny</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">kind</td>
                <td data-label="Phon">kaind</td>
                <td data-label="Definition">X1 is kind to beneficiary X2 by doing (vo) X3:+1</td>
                <td data-label="Comments">No automatic X2 merge.</td>
                <td data-label="Xref">pli</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5, 2.1.5, 1.5.5<br>Chinese: /ren-tsz<br>Latin: benygn.us<br>Loglan: ckano</td>
            </tr>

            <tr>
                <td data-label="Word">qel</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">shelter</td>
                <td data-label="Phon">qeltr</td>
                <td data-label="Definition">X1 shelters (xo) X2:* from (vo) X3:+2</td>
                <td data-label="Comments">X1 can be an actor or an artifact e.g. a house; xo is there for compounds like -qel -fkar = garage.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5, 3.5.2, 4.2.9<br>Chinese: |bau!hu<br>Latin: teg.ere<br>Loglan: harko</td>
            </tr>

            <tr>
                <td data-label="Word">tuo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">support</td>
                <td data-label="Phon">s#port</td>
                <td data-label="Definition">X1 supports X2:</td>
                <td data-label="Comments">Primary meaning is mechanical; make good metaphors for secondary meanings.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5, 4.2.4<br>Chinese: -tuo!ju<br>Latin: sustyn.ere<br>Loglan: djupo</td>
            </tr>

            <tr>
                <td data-label="Word">van</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">translate</td>
                <td data-label="Phon">translait</td>
                <td data-label="Definition">X1 translates text X2 to language X3 from language X4</td>
                <td data-label="Comments">X2 may be ``someone&#x27;s speech&#x27;&#x27;.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5, 4.4.6<br>Chinese: -fan!i<br>Latin: vert.ere<br>Loglan: fanva*</td>
            </tr>

            <tr>
                <td data-label="Word">kme</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">doctor, disease, treat, medicine</td>
                <td data-label="Phon">daktor</td>
                <td data-label="Definition">X1 treats patient X2 for disease (vo) X3+2 with medicine X4</td>
                <td data-label="Comments">Not for Ph.D.</td>
                <td data-label="Xref">xym, zbi, fyo</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.5, 4.6.3<br>Chinese: -i-qew<br>Latin: medyk.us<br>Loglan: kicmu</td>
            </tr>

            <tr>
                <td data-label="Word">246</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Hurting Persons or Objects</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 harms victim X2* by doing event (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bao</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">bite</td>
                <td data-label="Phon">bait</td>
                <td data-label="Definition">X1 bites X2: on its body part X3-2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: |iao<br>Latin: mord.ere<br>Loglan: ditka</td>
            </tr>

            <tr>
                <td data-label="Word">fey</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hit</td>
                <td data-label="Phon">hyt</td>
                <td data-label="Definition">X1 hits X2: with weapon X3* on its body part X4-2</td>
                <td data-label="Comments">X3 can also be a body part of X1.</td>
                <td data-label="Xref">kol</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: |da<br>Latin: fer.ire<br>Loglan: bloda</td>
            </tr>

            <tr>
                <td data-label="Word">fon</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">stab, poke, jab</td>
                <td data-label="Phon">stab</td>
                <td data-label="Definition">X1 stabs X2: with knife X3* in body part X4-2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: !tsz<br>Latin: konfod.ere<br>Loglan: tunta*</td>
            </tr>

            <tr>
                <td data-label="Word">guw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">attack</td>
                <td data-label="Phon">attak</td>
                <td data-label="Definition">X1 attacks X2: to get goal (vo) X3+</td>
                <td data-label="Comments">No case merge.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: -guw/ji<br>Latin: opugn.are<br>Loglan: takma</td>
            </tr>

            <tr>
                <td data-label="Word">jar</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">harsh, severe</td>
                <td data-label="Phon">harq</td>
                <td data-label="Definition">X1 is harsh to X2: by doing (vo) X3:+1</td>
                <td data-label="Comments">No case merge for X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: -juaw/ian<br>Latin: asper<br>Loglan: jursa*</td>
            </tr>

            <tr>
                <td data-label="Word">kai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">take</td>
                <td data-label="Phon">taik</td>
                <td data-label="Definition">X1 takes object X2 away from former owner X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6, 2.2.4<br>Chinese: /na<br>Latin: kap.ere<br>Loglan: tokna</td>
            </tr>

            <tr>
                <td data-label="Word">kru</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">cruel</td>
                <td data-label="Phon">kruel</td>
                <td data-label="Definition">X1 is cruel to X2: by doing (vo) X3:+1</td>
                <td data-label="Comments">No merge of X2 into X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: /tsan!ku<br>Latin: krudel.ys<br>Loglan: kruli</td>
            </tr>

            <tr>
                <td data-label="Word">kyr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">kick</td>
                <td data-label="Phon">kyk</td>
                <td data-label="Definition">X1 kicks X2: on its body part X3-2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: -ti<br>Latin: kalkytr.are<br>Loglan: kekti</td>
            </tr>

            <tr>
                <td data-label="Word">pny</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">punish</td>
                <td data-label="Phon">p#nyq</td>
                <td data-label="Definition">X1 punishes X2: for doing (vo) X3:+2@! with punishment (vo) X4+2</td>
                <td data-label="Comments">X4 must often be converted due to case merge.</td>
                <td data-label="Xref">xia</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: /fa<br>Latin: pun.yre<br>Loglan: kasfa</td>
            </tr>

            <tr>
                <td data-label="Word">qae</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hurt</td>
                <td data-label="Phon">hrt</td>
                <td data-label="Definition">X1 hurts X2: by doing (vo) X3:+1</td>
                <td data-label="Comments">No automatic merge for X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: -qaw<br>Latin: laed.ere<br>Loglan: surna</td>
            </tr>

            <tr>
                <td data-label="Word">vem</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">trouble</td>
                <td data-label="Phon">tr#bl</td>
                <td data-label="Definition">X1 makes trouble for X2: by doing (vo) X3:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 14<br>Thes: 2.4.6<br>Chinese: /ma/fan<br>Latin: veks.are<br>Loglan: fatru</td>
            </tr>

            <tr>
                <td data-label="Word">znr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">prisoner</td>
                <td data-label="Phon">pryz#nr</td>
                <td data-label="Definition">X1 holds prisoner X2 in prison X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kio</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.6<br>Chinese: !fan/ren<br>Latin: kapt.ere<br>Loglan: preni</td>
            </tr>

            <tr>
                <td data-label="Word">247</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Activities of Objects   </td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Active~object X1 performs some activity</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">break</td>
                <td data-label="Phon">brak</td>
                <td data-label="Definition">X1 breaks by itself into pieces X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: !nuw!puo<br>Latin: frang.ere<br>Loglan: broko</td>
            </tr>

            <tr>
                <td data-label="Word">bvi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">vibrate</td>
                <td data-label="Phon">vaibrait</td>
                <td data-label="Definition">X1 vibrates</td>
                <td data-label="Comments">So fast you can&#x27;t see.</td>
                <td data-label="Xref">sur, bvi</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: !jen!duw<br>Latin: vibr.are<br>Loglan: canvi*</td>
            </tr>

            <tr>
                <td data-label="Word">qau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">radiate, shine, emit</td>
                <td data-label="Phon">qain</td>
                <td data-label="Definition">X1 radiates rays (xo) X2*</td>
                <td data-label="Comments">Many emitted substances (light, sound, smoke) have a case for the source.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: !jau<br>Latin: fulg.ere<br>Loglan: dirce*</td>
            </tr>

            <tr>
                <td data-label="Word">qkm</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">oscillate, shake, move</td>
                <td data-label="Phon">qaik</td>
                <td data-label="Definition">X1 shakes or oscillates</td>
                <td data-label="Comments">Use -sur for repetitive events.</td>
                <td data-label="Xref">sur, duw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: /iau<br>Latin: vibr.are<br>Loglan: siltu</td>
            </tr>

            <tr>
                <td data-label="Word">sao</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">operate, function, perform</td>
                <td data-label="Phon">operait</td>
                <td data-label="Definition">X1 operates performing function (vo) X2+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zom, kro, bro</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: -tsau!dzuo<br>Latin: <br>Loglan: bapra</td>
            </tr>

            <tr>
                <td data-label="Word">vbo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">boil</td>
                <td data-label="Phon">boil</td>
                <td data-label="Definition">X1 boils</td>
                <td data-label="Comments">Turns to vapor.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: |ju<br>Latin: ferv.ere<br>Loglan: bulju</td>
            </tr>

            <tr>
                <td data-label="Word">xby</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">hiss</td>
                <td data-label="Phon">hys</td>
                <td data-label="Definition">X1 makes a hissing sound</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: -<br>Latin: sybyl.are<br>Loglan: hesce</td>
            </tr>

            <tr>
                <td data-label="Word">zbr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">burn</td>
                <td data-label="Phon">brn</td>
                <td data-label="Definition">X1 burns</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">xgn, cfl</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.7<br>Chinese: -qau<br>Latin: ard.ere<br>Loglan: cabro</td>
            </tr>

            <tr>
                <td data-label="Word">248</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Miscellaneous Transitive Activities</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Actor X1 does some activity</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">del</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">develop, mature</td>
                <td data-label="Phon">divel#p</td>
                <td data-label="Definition">X1 develops or matures to become adult (vo) X2+1</td>
                <td data-label="Comments">Use -jaw for getting bigger.</td>
                <td data-label="Xref">jaw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: -fa/da<br>Latin: kresk.ere<br>Loglan: valda</td>
            </tr>

            <tr>
                <td data-label="Word">dye</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">dig</td>
                <td data-label="Phon">dyg</td>
                <td data-label="Definition">X1 digs up object X2 out of soil X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: /jue<br>Latin: efod.ere<br>Loglan: pafko</td>
            </tr>

            <tr>
                <td data-label="Word">jaw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">grow</td>
                <td data-label="Phon">gro</td>
                <td data-label="Definition">X1 grows to become (vo) X2+1</td>
                <td data-label="Comments">Gets bigger.</td>
                <td data-label="Xref">del</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: -qew|jaw<br>Latin: kresk.ere<br>Loglan: rodja</td>
            </tr>

            <tr>
                <td data-label="Word">bnl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">manage</td>
                <td data-label="Phon">man#j</td>
                <td data-label="Definition">X1 manages function (vo) X2+ in organization X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: !ban|li<br>Latin: trakt.are<br>Loglan: mande</td>
            </tr>

            <tr>
                <td data-label="Word">kel</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">celebrate</td>
                <td data-label="Phon">selebrat</td>
                <td data-label="Definition">X1 celebrates event (vo) X2+ by activity (vo) X3+1@!</td>
                <td data-label="Comments">X1 is often but not always happy about X2.  Includes funerals.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: !ciw!ju<br>Latin: kelebr.are<br>Loglan: salci*</td>
            </tr>

            <tr>
                <td data-label="Word">kio</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">keep, possess</td>
                <td data-label="Phon">kip</td>
                <td data-label="Definition">X1 keeps object X2 in his possession</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zua, qlu, znr, bou, zey</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: |iou<br>Latin: posyd.ere<br>Loglan: klipu</td>
            </tr>

            <tr>
                <td data-label="Word">pan</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">panic, crisis</td>
                <td data-label="Phon">panik</td>
                <td data-label="Definition">X1 panics, doing activity (vo) X2+1@!, in crisis (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: |kuw!bu<br>Latin: pav.ere<br>Loglan: pakno</td>
            </tr>

            <tr>
                <td data-label="Word">pre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">represent</td>
                <td data-label="Phon">reprizent</td>
                <td data-label="Definition">X1 represents client X2 in affair (vo) X3+</td>
                <td data-label="Comments">As actor; use -sni for symbols.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: !dai|li<br>Latin: prokurator<br>Loglan: dilri</td>
            </tr>

            <tr>
                <td data-label="Word">qlu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">lose</td>
                <td data-label="Phon">luz</td>
                <td data-label="Definition">X1 loses object X2</td>
                <td data-label="Comments">Loses possession.  Use -vyw for contests.</td>
                <td data-label="Xref">kio, vyw</td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8<br>Chinese: /i-shr<br>Latin: amyt.ere<br>Loglan: dirlu</td>
            </tr>

            <tr>
                <td data-label="Word">vrn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">govern</td>
                <td data-label="Phon">g#vrn</td>
                <td data-label="Definition">X1 governs set of people (xy) X2s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.4.8, 4.7.4<br>Chinese: !jr|li<br>Latin: gubern.are<br>Loglan: garni</td>
            </tr>

            <tr>
                <td data-label="Word">250</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Emotions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">251</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Emotions about Other People</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Experiencer X1 has an emotion because actor X2 does event (vo) X3+2</td>
                <td data-label="Comments">You may repeat X1 in X2 if X1 feels the emotion about itself.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cmy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">pity, regret, sorry</td>
                <td data-label="Phon">pyti</td>
                <td data-label="Definition">X1 pities X2: because it is (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: -k#/lian<br>Latin: myser.ery<br>Loglan: kecti</td>
            </tr>

            <tr>
                <td data-label="Word">fan</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">like, fond, care</td>
                <td data-label="Phon">fand</td>
                <td data-label="Definition">X1 likes, is fond of X2: because it is (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vam</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: /lian!nai<br>Latin: amans<br>Loglan: likci*</td>
            </tr>

            <tr>
                <td data-label="Word">gan</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">distress, anguish</td>
                <td data-label="Phon">dystres</td>
                <td data-label="Definition">X1 feels anguish because X2: is (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: |ku!nan<br>Latin: ang.ere<br>Loglan: dunku*</td>
            </tr>

            <tr>
                <td data-label="Word">gno</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">forgive</td>
                <td data-label="Phon">forgyv</td>
                <td data-label="Definition">X1 forgives X2: for doing/being (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: /uan!liaw<br>Latin: ygnosk.ere<br>Loglan: parce*</td>
            </tr>

            <tr>
                <td data-label="Word">gra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">grateful</td>
                <td data-label="Phon">graitfl</td>
                <td data-label="Definition">X1 is grateful to X2: for doing (vo) X3:+2</td>
                <td data-label="Comments">No automatic X1 merge.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: |gan!sie<br>Latin: grat.us<br>Loglan: garti</td>
            </tr>

            <tr>
                <td data-label="Word">gri</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">angry</td>
                <td data-label="Phon">angri</td>
                <td data-label="Definition">X1 is angry because X2: does (vo) X3:+2</td>
                <td data-label="Comments">No automatic X1 merge.  X2 may be the same as X1.  Distinguish anger at X2 from anger at event X3.</td>
                <td data-label="Xref">tan</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: -qew!ci<br>Latin: yraski<br>Loglan: groci</td>
            </tr>

            <tr>
                <td data-label="Word">jiw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">surprise</td>
                <td data-label="Phon">surpraiz</td>
                <td data-label="Definition">X1 is surprised that X2: does (vo) X3:+2</td>
                <td data-label="Comments">Not necessarily harming X1.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1, 1.5.5<br>Chinese: -jiw/ci<br>Latin: myr.ary<br>Loglan: stari</td>
            </tr>

            <tr>
                <td data-label="Word">pru</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">approve</td>
                <td data-label="Phon">apruv</td>
                <td data-label="Definition">X1 approves of X2: doing (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: -pi|ju#n<br>Latin: prob.are<br>Loglan: prusa</td>
            </tr>

            <tr>
                <td data-label="Word">sri</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">respect</td>
                <td data-label="Phon">rispekt</td>
                <td data-label="Definition">X1 respects X2: for doing/being (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">val</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: -dzun!jiw<br>Latin: observ.are<br>Loglan: rispe</td>
            </tr>

            <tr>
                <td data-label="Word">vam</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">love</td>
                <td data-label="Phon">l#v</td>
                <td data-label="Definition">X1 loves X2:</td>
                <td data-label="Comments">Use -fan for ``he loves her for her money&#x27;&#x27;.</td>
                <td data-label="Xref">fan</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: !ay<br>Latin: am.are<br>Loglan: cluva</td>
            </tr>

            <tr>
                <td data-label="Word">vli</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">jealous, envy</td>
                <td data-label="Phon">jel#s</td>
                <td data-label="Definition">X1 is jealous of X2: for doing/being (vo) X3:+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: /ji!du<br>Latin: livyd.us<br>Loglan: jilra*</td>
            </tr>

            <tr>
                <td data-label="Word">xai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hate</td>
                <td data-label="Phon">hait</td>
                <td data-label="Definition">X1 hates X2: for doing/being (vo) X3:+2</td>
                <td data-label="Comments">X1 is sufficiently motivated to try to destroy X2 even at personal risk.  No automatic X1 merge in X3.</td>
                <td data-label="Xref">psi</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.1<br>Chinese: !ian!u<br>Latin: odyse<br>Loglan: tsodi</td>
            </tr>

            <tr>
                <td data-label="Word">252</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Emotions about an Activity</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Experiencer has an emotion about activity (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bnr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">nervous</td>
                <td data-label="Phon">nrv#s</td>
                <td data-label="Definition">X1 is nervous about doing (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2<br>Chinese: !bu/faw-sin<br>Latin: tymyd.us<br>Loglan: narvo</td>
            </tr>

            <tr>
                <td data-label="Word">dyi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">disgust</td>
                <td data-label="Phon">dysg#st</td>
                <td data-label="Definition">X1 feels disgust at (vo) X2:+</td>
                <td data-label="Comments">Let -vo turn a disgusting object into an event.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2<br>Chinese: |tau!ian<br>Latin: fastidy.um<br>Loglan: tasgu</td>
            </tr>

            <tr>
                <td data-label="Word">jeu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">shock</td>
                <td data-label="Phon">qak</td>
                <td data-label="Definition">X1 feels shocked by (vo) X2:+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2<br>Chinese: !jen!duw<br>Latin: perturb.are<br>Loglan: tcaku</td>
            </tr>

            <tr>
                <td data-label="Word">jiu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fear</td>
                <td data-label="Phon">fir</td>
                <td data-label="Definition">X1 fears doing or experiencing (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2<br>Chinese: |k#w!jiu<br>Latin: metu.ere<br>Loglan: firpa</td>
            </tr>

            <tr>
                <td data-label="Word">jyr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">wonder, awe</td>
                <td data-label="Phon">u#ndr</td>
                <td data-label="Definition">X1 feels awe about (vo) X2:+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2<br>Chinese: /ci-ji<br>Latin: myr.ary<br>Loglan: manci*</td>
            </tr>

            <tr>
                <td data-label="Word">pel</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">impel</td>
                <td data-label="Phon">ympel</td>
                <td data-label="Definition">X1 is impelled to do (vo) X2:+1</td>
                <td data-label="Comments">Feels a strong emotional or intellectual drive.</td>
                <td data-label="Xref">jie</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2<br>Chinese: !bi-qu<br>Latin: ympel.are<br>Loglan: pulso</td>
            </tr>

            <tr>
                <td data-label="Word">gyl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">guilt, remorse</td>
                <td data-label="Phon">gylt</td>
                <td data-label="Definition">X1 feels guilty about (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2<br>Chinese: !dzuei<br>Latin: vyty.um<br>Loglan: zungi*</td>
            </tr>

            <tr>
                <td data-label="Word">vyu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">like, enjoy</td>
                <td data-label="Phon">laik</td>
                <td data-label="Definition">X1 likes to do (vo) X2:+1</td>
                <td data-label="Comments">Not an object; likes to eat apples, not likes apples.  Needs -tiu (continuous) or -fwu (habit) for usual English meaning.</td>
                <td data-label="Xref">qya</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.2, 2.1.4<br>Chinese: |si-huan<br>Latin: yuv.are<br>Loglan: fundi</td>
            </tr>

            <tr>
                <td data-label="Word">253</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Miscellaneous Emotional States</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Experiencer X1 has an emotion about property (vo) X2+1</td>
                <td data-label="Comments">For many words X2 can equally be an activity.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bum</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">humble, modest</td>
                <td data-label="Phon">humbl</td>
                <td data-label="Definition">X1 is humble about (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: -cian-bei<br>Latin: humyl.ys<br>Loglan: cumla*</td>
            </tr>

            <tr>
                <td data-label="Word">coy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">sad, regret</td>
                <td data-label="Phon">sad</td>
                <td data-label="Definition">X1 is sad about (vo) X2:+1</td>
                <td data-label="Comments">For regret, past tense |bir would normally go in the infinitive.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: -iou/cou<br>Latin: tryst.ys<br>Loglan: kecri</td>
            </tr>

            <tr>
                <td data-label="Word">dol</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">pain</td>
                <td data-label="Phon">pain</td>
                <td data-label="Definition">X1 feels pain in body part X2-1*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: !tuw<br>Latin: dolor<br>Loglan: puntu</td>
            </tr>

            <tr>
                <td data-label="Word">fel</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">happy</td>
                <td data-label="Phon">hapi</td>
                <td data-label="Definition">X1 is happy about (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: !siw/fu<br>Latin: felyx<br>Loglan: hapci</td>
            </tr>

            <tr>
                <td data-label="Word">pau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">proud</td>
                <td data-label="Phon">praud</td>
                <td data-label="Definition">X1 is proud of (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: -jiau!au<br>Latin: superb.us<br>Loglan: jardu*</td>
            </tr>

            <tr>
                <td data-label="Word">qim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">shame</td>
                <td data-label="Phon">qaim</td>
                <td data-label="Definition">X1 is ashamed of (vo) X2:+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: -sio|cr<br>Latin: dedek.us<br>Loglan: comtu</td>
            </tr>

            <tr>
                <td data-label="Word">tra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">attract, emotion</td>
                <td data-label="Phon">#trakt</td>
                <td data-label="Definition">X1 attracts person X2 emotionally by behavior (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: -qi|in<br>Latin: atrah.ere<br>Loglan: trili</td>
            </tr>

            <tr>
                <td data-label="Word">zuo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">frustrate</td>
                <td data-label="Phon">fr#strait</td>
                <td data-label="Definition">X1 feels frustrated by (vo) X2:+1</td>
                <td data-label="Comments">Let vo turn a frustrating object into an event.  Use -sir for restrain.</td>
                <td data-label="Xref">sir</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3<br>Chinese: !dzuo!fei<br>Latin: <br>Loglan: steba*</td>
            </tr>

            <tr>
                <td data-label="Word">gae</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">feel, emotion</td>
                <td data-label="Phon">imoqn</td>
                <td data-label="Definition">X1 feels emotion (vo) X2+</td>
                <td data-label="Comments">Modal case for experiencer of subjective emotions.</td>
                <td data-label="Xref">ciw, sen</td>
                <td data-label="Notes">Rank: <br>Thes: 2.5.3, 1.5.2<br>Chinese: |gan/jue<br>Latin: kap.ere<br>Loglan: sanse</td>
            </tr>

            <tr>
                <td data-label="Word">300</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Worldly Objects</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">The referent set of a one-argument predicate is not a set of objects but a set of one-member sets with one object each.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.0.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">310</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Animals and Plants</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Almost all of these have only one argument: X1 is a (creature).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">311</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Animals, Domestic</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kmor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">horse</td>
                <td data-label="Phon">hors</td>
                <td data-label="Definition">X1 is a horse</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: |ma<br>Latin: eku.#s<br>Loglan: horma</td>
            </tr>

            <tr>
                <td data-label="Word">jiuo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">turkey</td>
                <td data-label="Phon">trki</td>
                <td data-label="Definition">X1 is a turkey</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: |huo-ji<br>Latin: <br>Loglan: xruki*</td>
            </tr>

            <tr>
                <td data-label="Word">gowo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">goat</td>
                <td data-label="Phon">got</td>
                <td data-label="Definition">X1 is a goat</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: -san/iaw<br>Latin: kaper<br>Loglan: gotca</td>
            </tr>

            <tr>
                <td data-label="Word">kmel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">camel</td>
                <td data-label="Phon">kamel</td>
                <td data-label="Definition">X1 is a camel</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: !luo/tuo<br>Latin: kamel.us<br>Loglan: kamlo</td>
            </tr>

            <tr>
                <td data-label="Word">dayn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">donkey, jackass, ass</td>
                <td data-label="Phon">danki</td>
                <td data-label="Definition">X1 is a donkey</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: /liu.-dz<br>Latin: asyn.us<br>Loglan: xasli*</td>
            </tr>

            <tr>
                <td data-label="Word">pqiw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sheep</td>
                <td data-label="Phon">qip</td>
                <td data-label="Definition">X1 is a sheep</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: /iaw<br>Latin: ov.ys<br>Loglan: berci</td>
            </tr>

            <tr>
                <td data-label="Word">pory</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pig</td>
                <td data-label="Phon">pyg</td>
                <td data-label="Definition">X1 is a pig</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: -ju<br>Latin: pork.us<br>Loglan: porju</td>
            </tr>

            <tr>
                <td data-label="Word">pser</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">goose</td>
                <td data-label="Phon">gus</td>
                <td data-label="Definition">X1 is a goose</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: /e<br>Latin: anser<br>Loglan: gunse</td>
            </tr>

            <tr>
                <td data-label="Word">kmau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cat</td>
                <td data-label="Phon">kat</td>
                <td data-label="Definition">X1 is a cat</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: -mau<br>Latin: fel.ys<br>Loglan: katma</td>
            </tr>

            <tr>
                <td data-label="Word">cyen</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chicken</td>
                <td data-label="Phon">cyken</td>
                <td data-label="Definition">X1 is a chicken</td>
                <td data-label="Comments">Edible bird.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: -ji<br>Latin: pul.us<br>Loglan: jipci*</td>
            </tr>

            <tr>
                <td data-label="Word">tara</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rat, mouse</td>
                <td data-label="Phon">rat</td>
                <td data-label="Definition">X1 is a rat</td>
                <td data-label="Comments">Mouse is a small rat.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: |lau|qu<br>Latin: rat.us<br>Loglan: ratcu</td>
            </tr>

            <tr>
                <td data-label="Word">kani</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cow</td>
                <td data-label="Phon">kau</td>
                <td data-label="Definition">X1 is a cow</td>
                <td data-label="Comments">Includes bulls.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: /nio<br>Latin: vaka<br>Loglan: kasni</td>
            </tr>

            <tr>
                <td data-label="Word">xgom</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">dog</td>
                <td data-label="Phon">dag</td>
                <td data-label="Definition">X1 is a dog</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1<br>Chinese: |go<br>Latin: kan.ys<br>Loglan: kangu</td>
            </tr>

            <tr>
                <td data-label="Word">spym</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">spirit, ghost</td>
                <td data-label="Phon">spyryt</td>
                <td data-label="Definition">X1 is a spirit or ghost believed in by people (xy) X2s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.1, 4.6.1, 4.6.4<br>Chinese: |guei!guai<br>Latin: anyma<br>Loglan: spicu</td>
            </tr>

            <tr>
                <td data-label="Word">312</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Animals, Wild, Vertebrate</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">brni</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bird</td>
                <td data-label="Phon">b#rd</td>
                <td data-label="Definition">X1 is a bird</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: |niau<br>Latin: av.ys<br>Loglan: nirda</td>
            </tr>

            <tr>
                <td data-label="Word">dian</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">duck</td>
                <td data-label="Phon">d#k</td>
                <td data-label="Definition">X1 is a duck</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: -ia<br>Latin: anas<br>Loglan: datka*</td>
            </tr>

            <tr>
                <td data-label="Word">fcyw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">amphibian</td>
                <td data-label="Phon">amfibyan</td>
                <td data-label="Definition">X1 is an amphibian</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: -cyw-ua<br>Latin: <br>Loglan: banfi*</td>
            </tr>

            <tr>
                <td data-label="Word">dwym</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mammal</td>
                <td data-label="Phon">maml</td>
                <td data-label="Definition">X1 is a mammal</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: /pu|ru!duw!u<br>Latin: anymal<br>Loglan: mabru*</td>
            </tr>

            <tr>
                <td data-label="Word">fpym</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">fish</td>
                <td data-label="Phon">fyq</td>
                <td data-label="Definition">X1 is a fish</td>
                <td data-label="Comments">Any kind, not just teleosts.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: /u<br>Latin: pysk.ys<br>Loglan: ficli</td>
            </tr>

            <tr>
                <td data-label="Word">qleo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lion</td>
                <td data-label="Phon">lai#n</td>
                <td data-label="Definition">X1 is a lion</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: -qr.-dz<br>Latin: leo<br>Loglan: simba</td>
            </tr>

            <tr>
                <td data-label="Word">berw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bear</td>
                <td data-label="Phon">ber</td>
                <td data-label="Definition">X1 is a bear</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: |qow<br>Latin: urs.us<br>Loglan: conbe+</td>
            </tr>

            <tr>
                <td data-label="Word">guna</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">snake</td>
                <td data-label="Phon">snaik</td>
                <td data-label="Definition">X1 is a snake</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: /q#<br>Latin: angu.ys<br>Loglan: marpi</td>
            </tr>

            <tr>
                <td data-label="Word">smym</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">monkey</td>
                <td data-label="Phon">m#nki</td>
                <td data-label="Definition">X1 is a monkey</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: /hou.-dz<br>Latin: symya<br>Loglan: murki</td>
            </tr>

            <tr>
                <td data-label="Word">sper</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">reptile</td>
                <td data-label="Phon">reptail</td>
                <td data-label="Definition">X1 is a reptile</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: /pa/tsow<br>Latin: serpens<br>Loglan: respa*</td>
            </tr>

            <tr>
                <td data-label="Word">flel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">elephant</td>
                <td data-label="Phon">el#f#nt</td>
                <td data-label="Definition">X1 is an elephant</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2<br>Chinese: !siaw<br>Latin: elefas<br>Loglan: dumbo</td>
            </tr>

            <tr>
                <td data-label="Word">tiri</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tiger</td>
                <td data-label="Phon">taigr</td>
                <td data-label="Definition">X1 is a tiger</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 10<br>Thes: 3.1.2<br>Chinese: |lau|hu<br>Latin: tigr.ys<br>Loglan: tigra</td>
            </tr>

            <tr>
                <td data-label="Word">dwu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">animal</td>
                <td data-label="Phon">anim#l</td>
                <td data-label="Definition">X1 is an animal</td>
                <td data-label="Comments">Use -dwu -zu -jier for vertebrate.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.2, 4.6.1<br>Chinese: !duw!u<br>Latin: bestya<br>Loglan: nimla</td>
            </tr>

            <tr>
                <td data-label="Word">313</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Animals, Invertebrate</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">foma</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ant</td>
                <td data-label="Phon">ant</td>
                <td data-label="Definition">X1 is an ant</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: |ma|i<br>Latin: formika<br>Loglan: manti</td>
            </tr>

            <tr>
                <td data-label="Word">jawl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cockroach</td>
                <td data-label="Phon">kakroc</td>
                <td data-label="Definition">X1 is a cockroach</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: -jaw/law<br>Latin: <br>Loglan: jalra*</td>
            </tr>

            <tr>
                <td data-label="Word">curm</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">worm</td>
                <td data-label="Phon">urm</td>
                <td data-label="Definition">X1 is a worm</td>
                <td data-label="Comments">A snake is not a worm.  Use -curm |fsr for flatworm, -curm |klyl for roundworm and -curm |xer (not |canu) for annelid.</td>
                <td data-label="Xref">guna</td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: /cuw<br>Latin: verm.ys<br>Loglan: kurma</td>
            </tr>

            <tr>
                <td data-label="Word">bawa</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mollusc, clam, snail</td>
                <td data-label="Phon">klam</td>
                <td data-label="Definition">X1 is a mollusc</td>
                <td data-label="Comments">Normally bivalve.  Use -bawa -ksel for univalve (snail).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: !baw/k#<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jrar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">spider, arachnid</td>
                <td data-label="Phon">spaidr</td>
                <td data-label="Definition">X1 is a spider</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">ksyl</td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: -jr-ju<br>Latin: aranea<br>Loglan: jukni*</td>
            </tr>

            <tr>
                <td data-label="Word">tsai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">fly</td>
                <td data-label="Phon">flai</td>
                <td data-label="Definition">X1 is a fly</td>
                <td data-label="Comments">An insect, order diptera.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: -tsaw-iw<br>Latin: muska<br>Loglan: flaki</td>
            </tr>

            <tr>
                <td data-label="Word">sowy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">insect</td>
                <td data-label="Phon">ynsekt</td>
                <td data-label="Definition">X1 is an insect</td>
                <td data-label="Comments">-sowy -zu -jiau !zu -kr for millipede (myriapod).  -sowy -zu -kqel for crustacean.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: -kun/tsow<br>Latin: bestyola<br>Loglan: sekta</td>
            </tr>

            <tr>
                <td data-label="Word">bimi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bee</td>
                <td data-label="Phon">bi</td>
                <td data-label="Definition">X1 is a bee</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: !mi-f#w<br>Latin: ap.ys<br>Loglan: bifci</td>
            </tr>

            <tr>
                <td data-label="Word">peul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">louse</td>
                <td data-label="Phon">laus</td>
                <td data-label="Definition">X1 is a louse</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: -shr.-dz<br>Latin: pedykul.us<br>Loglan: ladzo</td>
            </tr>

            <tr>
                <td data-label="Word">diui</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">butterfly, moth</td>
                <td data-label="Phon">butrflai</td>
                <td data-label="Definition">X1 is a butterfly or moth</td>
                <td data-label="Comments">-diui -fw -diai (day) for butterfly, -diui -fw -qana (night) for moth.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3<br>Chinese: /hu/die<br>Latin: papyl.yo<br>Loglan: toldi*</td>
            </tr>

            <tr>
                <td data-label="Word">spon</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sponge</td>
                <td data-label="Phon">sp#nj</td>
                <td data-label="Definition">X1 is a sponge</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3, 4.1.3<br>Chinese: |hai/mian<br>Latin: spongya<br>Loglan: penja</td>
            </tr>

            <tr>
                <td data-label="Word">jiow</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">parasite</td>
                <td data-label="Phon">parasait</td>
                <td data-label="Definition">X1 is a parasite on host X2</td>
                <td data-label="Comments">Includes worms, germs, fungus, humans.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.3, 4.6.4<br>Chinese: !ji-q#w/tsow<br>Latin: adsekula<br>Loglan: parji*</td>
            </tr>

            <tr>
                <td data-label="Word">314</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Non-Edible Plants and Non-Animals</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfrn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">fern</td>
                <td data-label="Phon">frn</td>
                <td data-label="Definition">X1 is a fern</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: /iaw|cr<br>Latin: filyks<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">duiw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">virus</td>
                <td data-label="Phon">vairus</td>
                <td data-label="Definition">X1 is a virus</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: !biw/du<br>Latin: <br>Loglan: vidru*</td>
            </tr>

            <tr>
                <td data-label="Word">caiw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lichen</td>
                <td data-label="Phon">laiken</td>
                <td data-label="Definition">X1 is a lichen</td>
                <td data-label="Comments">A symbiotic mixture of fungus and alga</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: -ciw/tai<br>Latin: <br>Loglan: clika*</td>
            </tr>

            <tr>
                <td data-label="Word">fumo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">fungus, mold, mushroom</td>
                <td data-label="Phon">mold</td>
                <td data-label="Definition">X1 is a fungus</td>
                <td data-label="Comments">Use -ftu =fumo (fruit) or -tama -fw -fumo (hat) for mushroom.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: /mei<br>Latin: fung.us<br>Loglan: mledi*</td>
            </tr>

            <tr>
                <td data-label="Word">zoro</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">protozoa</td>
                <td data-label="Phon">protozo#</td>
                <td data-label="Definition">X1 is a protozoan</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: -<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gara</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">grass</td>
                <td data-label="Phon">gras</td>
                <td data-label="Definition">X1 is a grass plant</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: |tsau<br>Latin: gramen<br>Loglan: grasa</td>
            </tr>

            <tr>
                <td data-label="Word">zaol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">alga, algae</td>
                <td data-label="Phon">alga</td>
                <td data-label="Definition">X1 is an alga</td>
                <td data-label="Comments">Plural ``algae&#x27;&#x27; usually used in English.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: |dzao!lei<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">guro</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rose</td>
                <td data-label="Phon">roz</td>
                <td data-label="Definition">X1 is a rose</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: /mei!guai-hua<br>Latin: rosa<br>Loglan: rozme</td>
            </tr>

            <tr>
                <td data-label="Word">jeru</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">plant</td>
                <td data-label="Phon">plant</td>
                <td data-label="Definition">X1 is a plant</td>
                <td data-label="Comments">Use -jeru -zu -flua for angiosperm, -jeru -zu -fqui |co for monocot (|cu for dicot), -jeru -zu -fqui -fw -jeni for gymnosperm.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: /jr!u<br>Latin: herba<br>Loglan: herba</td>
            </tr>

            <tr>
                <td data-label="Word">qkue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">oak</td>
                <td data-label="Phon">ok</td>
                <td data-label="Definition">X1 is an oak</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: !siaw!qu<br>Latin: kuerk.us<br>Loglan: sokcu</td>
            </tr>

            <tr>
                <td data-label="Word">ciwi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">moss</td>
                <td data-label="Phon">mas</td>
                <td data-label="Definition">X1 is a moss</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: -ciw-tai<br>Latin: musk.us<br>Loglan: clika*</td>
            </tr>

            <tr>
                <td data-label="Word">glol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lotus</td>
                <td data-label="Phon">lot#s</td>
                <td data-label="Definition">X1 is a lotus plant</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: /lian<br>Latin: <br>Loglan: latna*</td>
            </tr>

            <tr>
                <td data-label="Word">germ</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">germ, bacteria</td>
                <td data-label="Phon">jrm</td>
                <td data-label="Definition">X1 is a bacterium</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: /uei-qew!u<br>Latin: germen<br>Loglan: jurme*</td>
            </tr>

            <tr>
                <td data-label="Word">bror</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tree</td>
                <td data-label="Phon">tri</td>
                <td data-label="Definition">X1 is a tree</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4<br>Chinese: !qu<br>Latin: arbor<br>Loglan: tricu</td>
            </tr>

            <tr>
                <td data-label="Word">kman</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cotton</td>
                <td data-label="Phon">katn</td>
                <td data-label="Definition">X1 is a cotton plant</td>
                <td data-label="Comments">-xbu -kman for cotton cloth.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.4, 4.1.7<br>Chinese: /mian<br>Latin: <br>Loglan: katna</td>
            </tr>

            <tr>
                <td data-label="Word">315</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Domesticated Fruits and Vegetables</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">glyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">flax, linen</td>
                <td data-label="Phon">lyn#n</td>
                <td data-label="Definition">X1 is a flax plant</td>
                <td data-label="Comments">-xbu -glyn for linen cloth.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.1.7<br>Chinese: /ma!bu<br>Latin: lynte.um<br>Loglan: linbu</td>
            </tr>

            <tr>
                <td data-label="Word">fcie</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tomato</td>
                <td data-label="Phon">t#mato</td>
                <td data-label="Definition">X1 is a tomato plant</td>
                <td data-label="Comments">-ftu -fcie for tomato fruit.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.2<br>Chinese: -fan/cie<br>Latin: <br>Loglan: tomto</td>
            </tr>

            <tr>
                <td data-label="Word">peir</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pear</td>
                <td data-label="Phon">per</td>
                <td data-label="Definition">X1 is a pear tree</td>
                <td data-label="Comments">-ftu -peir for pear fruit.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.2<br>Chinese: /li<br>Latin: pir.um<br>Loglan: perli</td>
            </tr>

            <tr>
                <td data-label="Word">bawo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">banana</td>
                <td data-label="Phon">banana</td>
                <td data-label="Definition">X1 is a banana tree</td>
                <td data-label="Comments">-ftu -bawo for banana fruit.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.2<br>Chinese: -qiaw-jio<br>Latin: <br>Loglan: banla</td>
            </tr>

            <tr>
                <td data-label="Word">plyw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">apple</td>
                <td data-label="Phon">apl</td>
                <td data-label="Definition">X1 is an apple tree</td>
                <td data-label="Comments">-ftu -plyw for apple fruit.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.2<br>Chinese: -pyw|guo<br>Latin: mal.um<br>Loglan: pligo</td>
            </tr>

            <tr>
                <td data-label="Word">guau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">squash</td>
                <td data-label="Phon">skuaq</td>
                <td data-label="Definition">X1 is a squash plant</td>
                <td data-label="Comments">-ftu -guau for squash fruit.  Misclassified in English as a vegetable.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.2<br>Chinese: -gua<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vanl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">olive</td>
                <td data-label="Phon">al#v</td>
                <td data-label="Definition">X1 is an olive tree</td>
                <td data-label="Comments">-ftu -vanl for olive fruit.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.2<br>Chinese: |gan|lan<br>Latin: olyva<br>Loglan: livbu</td>
            </tr>

            <tr>
                <td data-label="Word">tuou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cassava, taro</td>
                <td data-label="Phon">kasava</td>
                <td data-label="Definition">X1 is a cassava plant</td>
                <td data-label="Comments">Japanese: taro.  -dryr -tuou for the edible root.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.3<br>Chinese: !u/tou<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">piwu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">potato</td>
                <td data-label="Phon">p#taito</td>
                <td data-label="Definition">X1 is a potato plant</td>
                <td data-label="Comments">-dryr -piwu for the edible root.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.3<br>Chinese: |ma/liw|qu<br>Latin: <br>Loglan: palto</td>
            </tr>

            <tr>
                <td data-label="Word">cawi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tea</td>
                <td data-label="Phon">ti</td>
                <td data-label="Definition">X1 is a tea plant</td>
                <td data-label="Comments">-fqui -cawi for tea leaf, -psuw -cawi for tea beverage.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.4<br>Chinese: /ca<br>Latin: <br>Loglan: tcati</td>
            </tr>

            <tr>
                <td data-label="Word">kana</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">marijuana</td>
                <td data-label="Phon">maryhuana</td>
                <td data-label="Definition">X1 is a marijuana plant</td>
                <td data-label="Comments">-fqui -kana for marijuana leaf, -psye -kana for reefer.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.4<br>Chinese: /ma<br>Latin: kanab.ys<br>Loglan: ganja</td>
            </tr>

            <tr>
                <td data-label="Word">tsan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tobacco</td>
                <td data-label="Phon">t#bako</td>
                <td data-label="Definition">X1 is a tobacco plant</td>
                <td data-label="Comments">-fqui -tsan for tobacco leaf, -psye -tsan for tobacco cigarette.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.4<br>Chinese: -ian|tsau<br>Latin: <br>Loglan: bakco</td>
            </tr>

            <tr>
                <td data-label="Word">pawi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">parsley</td>
                <td data-label="Phon">parsli</td>
                <td data-label="Definition">X1 is a parsley plant</td>
                <td data-label="Comments">-fqui -pawi for parsley leaf.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.5<br>Chinese: -qiaw!tsai<br>Latin: apy.um<br>Loglan: parsi</td>
            </tr>

            <tr>
                <td data-label="Word">psun</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">asparagus</td>
                <td data-label="Phon">asperagus</td>
                <td data-label="Definition">X1 is an asparagus plant</td>
                <td data-label="Comments">-stem -psun for asparagus stalk.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.5<br>Chinese: /lu|su#n<br>Latin: <br>Loglan: spera</td>
            </tr>

            <tr>
                <td data-label="Word">tsuw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">onion</td>
                <td data-label="Phon">#ni#n</td>
                <td data-label="Definition">X1 is an onion plant</td>
                <td data-label="Comments">Includes scallions.  -jwuw -tsuw for the edible root.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.5<br>Chinese: -tsuw<br>Latin: kaepa<br>Loglan: sluni*</td>
            </tr>

            <tr>
                <td data-label="Word">sual</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">garlic</td>
                <td data-label="Phon">garlyk</td>
                <td data-label="Definition">X1 is a garlic plant</td>
                <td data-label="Comments">-jwuw -sual for the edible bulb.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.5, 4.3.5<br>Chinese: !suan<br>Latin: ali.um<br>Loglan: sunga*</td>
            </tr>

            <tr>
                <td data-label="Word">316</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Domesticated Grains and Beans</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">siai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rye</td>
                <td data-label="Phon">rai</td>
                <td data-label="Definition">X1 is a rye plant</td>
                <td data-label="Comments">-xgu -siai for rye grain.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: |siau!mai<br>Latin: <br>Loglan: mraji*</td>
            </tr>

            <tr>
                <td data-label="Word">bzn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">bean</td>
                <td data-label="Phon">bin</td>
                <td data-label="Definition">X1 is a bean plant</td>
                <td data-label="Comments">-smem -bzn for bean seed (what you eat).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: !dou<br>Latin: faba<br>Loglan: dembi*</td>
            </tr>

            <tr>
                <td data-label="Word">cmyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">millet</td>
                <td data-label="Phon">mylet</td>
                <td data-label="Definition">X1 is a millet plant</td>
                <td data-label="Comments">-xgu -cmyl for millet grain.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: -<br>Latin: myly.um<br>Loglan: cunmi*</td>
            </tr>

            <tr>
                <td data-label="Word">vena</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">oats</td>
                <td data-label="Phon">ot</td>
                <td data-label="Definition">X1 is an oat plant</td>
                <td data-label="Comments">-xgu -vena for oat grain.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: !mai<br>Latin: avena<br>Loglan: mavji*</td>
            </tr>

            <tr>
                <td data-label="Word">quma</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">maize, corn</td>
                <td data-label="Phon">maiz</td>
                <td data-label="Definition">X1 is a maize plant</td>
                <td data-label="Comments">-ftu -quma for the ear (seed assembly) or -xgu -quma for the edible grains.  In USA, corn means maize.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: !u|qu|qu<br>Latin: far<br>Loglan: mismi</td>
            </tr>

            <tr>
                <td data-label="Word">guri</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rice</td>
                <td data-label="Phon">rais</td>
                <td data-label="Definition">X1 is a rice plant</td>
                <td data-label="Comments">-xgu -guri for rice grain.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: |gu<br>Latin: <br>Loglan: rismi</td>
            </tr>

            <tr>
                <td data-label="Word">dwoi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">soya</td>
                <td data-label="Phon">soi#</td>
                <td data-label="Definition">X1 is a soya plant</td>
                <td data-label="Comments">-smem -dwoi for soybean.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: /huaw!dou<br>Latin: <br>Loglan: sobde*</td>
            </tr>

            <tr>
                <td data-label="Word">tymi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wheat</td>
                <td data-label="Phon">uit</td>
                <td data-label="Definition">X1 is a wheat plant</td>
                <td data-label="Comments">-xgu -tymi for wheat grain.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: !mai.-dz<br>Latin: trytyk.um<br>Loglan: ritma</td>
            </tr>

            <tr>
                <td data-label="Word">vdi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">barley</td>
                <td data-label="Phon">barli</td>
                <td data-label="Definition">X1 is a barley plant</td>
                <td data-label="Comments">-xgu -vdi for barley grain.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.3<br>Chinese: !da!mai<br>Latin: horda.um<br>Loglan: bavmi*</td>
            </tr>

            <tr>
                <td data-label="Word">fiei</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">coffee</td>
                <td data-label="Phon">kofi</td>
                <td data-label="Definition">X1 is a coffee plant</td>
                <td data-label="Comments">-smem -fiei for coffee bean, -psuw -fiei for coffee beverage. </td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.1.6, 4.3.4<br>Chinese: -ka-fei<br>Latin: <br>Loglan: skafi</td>
            </tr>

            <tr>
                <td data-label="Word">320</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Body Parts</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Generally X2 is the owner, e.g. claw of creature X2, but it can also be a superset, e.g. claw of paw X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">321</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Exterior of Head</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Body part X1: belongs to creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfro</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">brow, forehead</td>
                <td data-label="Phon">brou</td>
                <td data-label="Definition">X1 is the brow or forehead of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: /cia!ne<br>Latin: frons<br>Loglan: mebri*</td>
            </tr>

            <tr>
                <td data-label="Word">puou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">head</td>
                <td data-label="Phon">hed</td>
                <td data-label="Definition">X1 is the head of X2:*</td>
                <td data-label="Comments">Not for the business end of a machine.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: kaput<br>Latin: /tou<br>Loglan: hedto</td>
            </tr>

            <tr>
                <td data-label="Word">faia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">face</td>
                <td data-label="Phon">fais</td>
                <td data-label="Definition">X1 is the face of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: |lian<br>Latin: facy.es<br>Loglan: fasli</td>
            </tr>

            <tr>
                <td data-label="Word">zono</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">nose</td>
                <td data-label="Phon">noz</td>
                <td data-label="Definition">X1 is the nose of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: /bi.-dz<br>Latin: nas.us<br>Loglan: nazbi</td>
            </tr>

            <tr>
                <td data-label="Word">cnyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chin</td>
                <td data-label="Phon">cyn</td>
                <td data-label="Definition">X1 is the chin of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: !qia-ba<br>Latin: ment.um<br>Loglan: tcina</td>
            </tr>

            <tr>
                <td data-label="Word">qkol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">neck</td>
                <td data-label="Phon">nek</td>
                <td data-label="Definition">X1 is the neck of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: |jiw<br>Latin: kol.um<br>Loglan: sneku</td>
            </tr>

            <tr>
                <td data-label="Word">komu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mouth</td>
                <td data-label="Phon">maut</td>
                <td data-label="Definition">X1 is the mouth of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: |kou<br>Latin: os<br>Loglan: manko</td>
            </tr>

            <tr>
                <td data-label="Word">drur</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ear</td>
                <td data-label="Phon">ir</td>
                <td data-label="Definition">X1 is an ear of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: |er-duo<br>Latin: aur.ys<br>Loglan: sorgu</td>
            </tr>

            <tr>
                <td data-label="Word">cuei</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lip</td>
                <td data-label="Phon">lyp</td>
                <td data-label="Definition">X1 is a lip of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.1<br>Chinese: |dzuei/cun<br>Latin: labr.um<br>Loglan: zlupi</td>
            </tr>

            <tr>
                <td data-label="Word">jaiw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">eye</td>
                <td data-label="Phon">ai</td>
                <td data-label="Definition">X1 is an eye of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 13<br>Thes: 3.2.1<br>Chinese: |ian-jiw<br>Latin: okul.us<br>Loglan: menki</td>
            </tr>

            <tr>
                <td data-label="Word">322</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Inside of Head</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Body part X1: belongs to creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">brna</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">brain</td>
                <td data-label="Phon">brain</td>
                <td data-label="Definition">X1 is the brain of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.2<br>Chinese: |nau<br>Latin: kerebr.um<br>Loglan: berna</td>
            </tr>

            <tr>
                <td data-label="Word">qtou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tongue</td>
                <td data-label="Phon">t#ng</td>
                <td data-label="Definition">X1 is the tongue of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.2<br>Chinese: /qe-tou<br>Latin: lingua<br>Loglan: tongu</td>
            </tr>

            <tr>
                <td data-label="Word">toui</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">skull</td>
                <td data-label="Phon">sk#l</td>
                <td data-label="Definition">X1 is the skull of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.2<br>Chinese: /tou!gai|gu<br>Latin: kaput<br>Loglan: tosku</td>
            </tr>

            <tr>
                <td data-label="Word">vden</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tooth</td>
                <td data-label="Phon">tut</td>
                <td data-label="Definition">X1 is a tooth of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.2<br>Chinese: /ia<br>Latin: dens<br>Loglan: dante</td>
            </tr>

            <tr>
                <td data-label="Word">toul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">throat, gullet</td>
                <td data-label="Phon">trot</td>
                <td data-label="Definition">X1 is the throat or gullet of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.2<br>Chinese: /hou-luw<br>Latin: gula<br>Loglan: goltu</td>
            </tr>

            <tr>
                <td data-label="Word">323</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Arms and Legs</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Body part X1: belongs to creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jiau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">leg</td>
                <td data-label="Phon">leg</td>
                <td data-label="Definition">X1 is a leg of X2:*</td>
                <td data-label="Comments">Includes front legs of non-primates.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: |jiau<br>Latin: kr.us<br>Loglan: tugle</td>
            </tr>

            <tr>
                <td data-label="Word">junu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">claw, nail, talon</td>
                <td data-label="Phon">kla</td>
                <td data-label="Definition">X1 is a claw of X2:*</td>
                <td data-label="Comments">Includes primates&#x27; fingernails.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: |jua<br>Latin: ungu.ys<br>Loglan: jgalu*</td>
            </tr>

            <tr>
                <td data-label="Word">qnou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hand, paw</td>
                <td data-label="Phon">hand</td>
                <td data-label="Definition">X1 is a hand of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: |qou<br>Latin: man.us<br>Loglan: hanco</td>
            </tr>

            <tr>
                <td data-label="Word">pomu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">thumb</td>
                <td data-label="Phon">t#m</td>
                <td data-label="Definition">X1 is a thumb of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: |mu|jr<br>Latin: poleks<br>Loglan: pudja</td>
            </tr>

            <tr>
                <td data-label="Word">drme</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">shoulder, hip</td>
                <td data-label="Phon">qoldr</td>
                <td data-label="Definition">X1 is a shoulder of X2:*</td>
                <td data-label="Comments">Use -drme -zon or -drme -fw -jiau for hip.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: -jiaw|baw<br>Latin: humer.us<br>Loglan: janco*</td>
            </tr>

            <tr>
                <td data-label="Word">pewe</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">foot, paw</td>
                <td data-label="Phon">f#t</td>
                <td data-label="Definition">X1 is a foot of X2:*</td>
                <td data-label="Comments">Includes front feet of non-primates.  Not a substitute for \gua{-jiaw} (leg).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: |jiau<br>Latin: ped.es<br>Loglan: fitpi</td>
            </tr>

            <tr>
                <td data-label="Word">brai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">arm</td>
                <td data-label="Phon">arm</td>
                <td data-label="Definition">X1 is an arm of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: |baw!bi<br>Latin: braki.um<br>Loglan: barma</td>
            </tr>

            <tr>
                <td data-label="Word">xgyw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">finger, toe</td>
                <td data-label="Phon">fywgr</td>
                <td data-label="Definition">X1 is a finger or toe of X2:*</td>
                <td data-label="Comments">Use -xgyw -fw -pewe or -xgyw -fw -qnou to distinguish. </td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.3<br>Chinese: |qou|jr<br>Latin: dygyt.us<br>Loglan: dedjo</td>
            </tr>

            <tr>
                <td data-label="Word">324</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Exterior of Body</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Body part X1: belongs to creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ceuw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chest, thorax</td>
                <td data-label="Phon">cest</td>
                <td data-label="Definition">X1 is the chest of X2:*</td>
                <td data-label="Comments">Thorax, where lungs are.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: -siuw!bu<br>Latin: pekt.us<br>Loglan: tceti</td>
            </tr>

            <tr>
                <td data-label="Word">taun</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">vulva</td>
                <td data-label="Phon">kunt</td>
                <td data-label="Definition">X1 is the vulva of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: -in!tau<br>Latin: vulva<br>Loglan: konbi</td>
            </tr>

            <tr>
                <td data-label="Word">pnen</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">penis</td>
                <td data-label="Phon">penys</td>
                <td data-label="Definition">X1 is the penis of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: /iaw|jin<br>Latin: pen.ys<br>Loglan: pingu</td>
            </tr>

            <tr>
                <td data-label="Word">gunu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">buttock</td>
                <td data-label="Phon">butak</td>
                <td data-label="Definition">X1 is a buttock of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">gnan</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: -pi|gu<br>Latin: klun.ys<br>Loglan: rirgu</td>
            </tr>

            <tr>
                <td data-label="Word">qeni</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">body</td>
                <td data-label="Phon">bodi</td>
                <td data-label="Definition">X1 is the body of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: -qen|ti<br>Latin: korp.us<br>Loglan: korti</td>
            </tr>

            <tr>
                <td data-label="Word">skyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">skin</td>
                <td data-label="Phon">skyn</td>
                <td data-label="Definition">X1 is the skin of X2:*</td>
                <td data-label="Comments">Outer covering, also for nonliving X2.</td>
                <td data-label="Xref">kory</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: /pi<br>Latin: kut.ys<br>Loglan: skapi</td>
            </tr>

            <tr>
                <td data-label="Word">vene</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">belly, abdomen</td>
                <td data-label="Phon">beli</td>
                <td data-label="Definition">X1 is the belly of X2:*</td>
                <td data-label="Comments">The body section housing the digestive organs.</td>
                <td data-label="Xref">stma</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: !fu!bu<br>Latin: venter<br>Loglan: beldu</td>
            </tr>

            <tr>
                <td data-label="Word">gnan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">anus</td>
                <td data-label="Phon">anus</td>
                <td data-label="Definition">X1 is the anus of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">gunu</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: -gaw|men<br>Latin: an.us<br>Loglan: gasno</td>
            </tr>

            <tr>
                <td data-label="Word">beru</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">teat, milk</td>
                <td data-label="Phon">tit</td>
                <td data-label="Definition">X1 is a teat or milk gland of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4<br>Chinese: |ru/faw<br>Latin: uber<br>Loglan: titfa</td>
            </tr>

            <tr>
                <td data-label="Word">kqel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">shell</td>
                <td data-label="Phon">qel</td>
                <td data-label="Definition">X1 is a shell of X2:*</td>
                <td data-label="Comments">Also for nonliving X2.  A hard, rigid skin.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.4, 4.2.8, 3.1.3<br>Chinese: /k#<br>Latin: testa<br>Loglan: calku*</td>
            </tr>

            <tr>
                <td data-label="Word">325</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Inside Body</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Body part X1: belongs to creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">stma</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">stomach</td>
                <td data-label="Phon">st#m#k</td>
                <td data-label="Definition">X1 is the stomach of X2:*</td>
                <td data-label="Comments">Digestive organ.</td>
                <td data-label="Xref">vene</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: !uei<br>Latin: stomac.us<br>Loglan: beldu</td>
            </tr>

            <tr>
                <td data-label="Word">guou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bone</td>
                <td data-label="Phon">bon</td>
                <td data-label="Definition">X1 is a bone of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: |gu/tou<br>Latin: os<br>Loglan: bongu</td>
            </tr>

            <tr>
                <td data-label="Word">jier</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">vertebra, backbone</td>
                <td data-label="Phon">bakbon</td>
                <td data-label="Definition">X1 is a vertebra of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: |ji!ju<br>Latin: vertebra<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">glyr</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">liver</td>
                <td data-label="Phon">lyvr</td>
                <td data-label="Definition">X1 is the liver of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: -gan<br>Latin: yekur<br>Loglan: vrano</td>
            </tr>

            <tr>
                <td data-label="Word">jini</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">nerve</td>
                <td data-label="Phon">nrv</td>
                <td data-label="Definition">X1 is a nerve of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: /s#n-jin<br>Latin: <br>Loglan: nervi</td>
            </tr>

            <tr>
                <td data-label="Word">slmu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">muscle</td>
                <td data-label="Phon">musl</td>
                <td data-label="Definition">X1 is a muscle of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: -ji!rou<br>Latin: muskul.us<br>Loglan: muslo</td>
            </tr>

            <tr>
                <td data-label="Word">vyer</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">intestine, gut</td>
                <td data-label="Phon">yntestn</td>
                <td data-label="Definition">X1 is the intestine of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: /caw<br>Latin: vyskera<br>Loglan: visra</td>
            </tr>

            <tr>
                <td data-label="Word">xgon</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">gonad</td>
                <td data-label="Phon">gonad</td>
                <td data-label="Definition">X1 is a gonad of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: -q#w/x#!ci-guan<br>Latin: <br>Loglan: testi</td>
            </tr>

            <tr>
                <td data-label="Word">kror</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">heart</td>
                <td data-label="Phon">hart</td>
                <td data-label="Definition">X1 is the heart of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: -sin<br>Latin: kor<br>Loglan: karci</td>
            </tr>

            <tr>
                <td data-label="Word">zgum</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">uterus, womb</td>
                <td data-label="Phon">um</td>
                <td data-label="Definition">X1 is the uterus of X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5<br>Chinese: |dz-guw<br>Latin: uter.us<br>Loglan: gutra*</td>
            </tr>

            <tr>
                <td data-label="Word">guie</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">blood, sap, juice</td>
                <td data-label="Phon">blud</td>
                <td data-label="Definition">(xo) X1 is some blood of X2:*</td>
                <td data-label="Comments">Includes plant sap.  -guie -ftu means fruit juice.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.5, 3.3.3<br>Chinese: |sie<br>Latin: sangu.ys<br>Loglan: bludi</td>
            </tr>

            <tr>
                <td data-label="Word">326</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Body Parts of Nonhumans</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Body part X1: belongs to creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">flua</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">flower</td>
                <td data-label="Phon">flaur</td>
                <td data-label="Definition">X1 is a flower of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: -hua<br>Latin: flos<br>Loglan: flora</td>
            </tr>

            <tr>
                <td data-label="Word">glaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wing</td>
                <td data-label="Phon">uiw</td>
                <td data-label="Definition">X1 is a wing of X2:*</td>
                <td data-label="Comments">Includes mechanical X1.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: !cr|baw<br>Latin: ala<br>Loglan: tcela</td>
            </tr>

            <tr>
                <td data-label="Word">fqui</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">leaf</td>
                <td data-label="Phon">lif</td>
                <td data-label="Definition">X1 is a leaf of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: !qu!ie<br>Latin: foly.um<br>Loglan: clife</td>
            </tr>

            <tr>
                <td data-label="Word">daue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tail</td>
                <td data-label="Phon">tail</td>
                <td data-label="Definition">X1 is a tail of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: |uei<br>Latin: kauda<br>Loglan: tilba</td>
            </tr>

            <tr>
                <td data-label="Word">stem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">stem</td>
                <td data-label="Phon">stem</td>
                <td data-label="Definition">X1 is a stem of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: !qu!gan<br>Latin: kaul.ys<br>Loglan: staga</td>
            </tr>

            <tr>
                <td data-label="Word">tfen</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">feather</td>
                <td data-label="Phon">fetr</td>
                <td data-label="Definition">X1 is a feather of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: |u!mau<br>Latin: pena<br>Loglan: pluma</td>
            </tr>

            <tr>
                <td data-label="Word">dryr</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">root</td>
                <td data-label="Phon">rut</td>
                <td data-label="Definition">X1 is a root of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: -g#n<br>Latin: radyks<br>Loglan: ginru</td>
            </tr>

            <tr>
                <td data-label="Word">qkor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">horn</td>
                <td data-label="Phon">horn</td>
                <td data-label="Definition">X1 is a horn of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: |jiao<br>Latin: kornu<br>Loglan: horno</td>
            </tr>

            <tr>
                <td data-label="Word">qura</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">branch</td>
                <td data-label="Phon">branc</td>
                <td data-label="Definition">X1 is a branch of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.6<br>Chinese: !qu-jr<br>Latin: ram.us<br>Loglan: badjo</td>
            </tr>

            <tr>
                <td data-label="Word">327</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Miscellaneous and Detachable Body Parts</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">Body part X1: belongs to creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fpyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hair</td>
                <td data-label="Phon">hair</td>
                <td data-label="Definition">X1 is a hair of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kory</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7<br>Chinese: /mau<br>Latin: pyl.us<br>Loglan: herfa</td>
            </tr>

            <tr>
                <td data-label="Word">ftu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">fruit, vegetable</td>
                <td data-label="Phon">frut</td>
                <td data-label="Definition">X1 is a fruit of X2:*</td>
                <td data-label="Comments">Many English vegetables are actually fruits.</td>
                <td data-label="Xref">tsa</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7, 4.3.5<br>Chinese: |guo.-dz<br>Latin: frukt.us<br>Loglan: fruta</td>
            </tr>

            <tr>
                <td data-label="Word">gnor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">organ, viscus, gut</td>
                <td data-label="Phon">orgn</td>
                <td data-label="Definition">X1 is an organ of X2: for function (vo) X3+1</td>
                <td data-label="Comments">-gnor -xyn means viscus or guts.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7<br>Chinese: !ci-guan<br>Latin: vysk.us<br>Loglan: visra</td>
            </tr>

            <tr>
                <td data-label="Word">dmin</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mind</td>
                <td data-label="Phon">maind</td>
                <td data-label="Definition">X1 is the mind of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7<br>Chinese: -qin<br>Latin: mens<br>Loglan: smina</td>
            </tr>

            <tr>
                <td data-label="Word">cunu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">nut, nucleus, central</td>
                <td data-label="Phon">nut</td>
                <td data-label="Definition">X1 is a nut of X2:*</td>
                <td data-label="Comments">Also used metaphorically for central parts like atomic nucleus.</td>
                <td data-label="Xref">juw</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7, 4.3.5<br>Chinese: /hu<br>Latin: nuks<br>Loglan: krinu</td>
            </tr>

            <tr>
                <td data-label="Word">psel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">self</td>
                <td data-label="Phon">self</td>
                <td data-label="Definition">X1 is the self of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7<br>Chinese: !dz|ji<br>Latin: ypsy<br>Loglan: selji</td>
            </tr>

            <tr>
                <td data-label="Word">smem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">seed</td>
                <td data-label="Phon">sid</td>
                <td data-label="Definition">X1 is a seed of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">xgu</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7<br>Chinese: |juw.-dz<br>Latin: semen<br>Loglan: sidza</td>
            </tr>

            <tr>
                <td data-label="Word">toum</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">swelling, tumor</td>
                <td data-label="Phon">suelyw</td>
                <td data-label="Definition">X1 is a tumor of/on/in body part X2-3* of creature X3</td>
                <td data-label="Comments">Not necessarily cancerous.  Use -cul if the whole part is swollen.</td>
                <td data-label="Xref">jwuw, cul</td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7<br>Chinese: /liou<br>Latin: tumor<br>Loglan: sulba</td>
            </tr>

            <tr>
                <td data-label="Word">vdan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">egg, sperm</td>
                <td data-label="Phon">eg</td>
                <td data-label="Definition">X1 is an egg of X2:*</td>
                <td data-label="Comments">Use -vdan |vyl for sperm.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.2.7, 4.3.1<br>Chinese: !dan<br>Latin: ov.um<br>Loglan: negda</td>
            </tr>

            <tr>
                <td data-label="Word">330</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Materials</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Most materials have the form (xo) X1 is a serving or portion of (material).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">331</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Common Chemical Elements</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Use -kmy -fn -X, where X is the Latin name of the element, for elements not in this category.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jynu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">aluminum</td>
                <td data-label="Phon">alumynum</td>
                <td data-label="Definition">(xo) X1 is some aluminum</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: |lu<br>Latin: <br>Loglan: lalmi</td>
            </tr>

            <tr>
                <td data-label="Word">klor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chlorine</td>
                <td data-label="Phon">klorin</td>
                <td data-label="Definition">(xo) X1 is some chlorine</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: !lu<br>Latin: <br>Loglan: clori</td>
            </tr>

            <tr>
                <td data-label="Word">plum</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lead</td>
                <td data-label="Phon">led</td>
                <td data-label="Definition">(xo) X1 is some lead</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: -cian<br>Latin: plumb.um<br>Loglan: pubmu</td>
            </tr>

            <tr>
                <td data-label="Word">fern</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">iron</td>
                <td data-label="Phon">yrn</td>
                <td data-label="Definition">(xo) X1 is some iron</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: |tie<br>Latin: fer.um<br>Loglan: fernu</td>
            </tr>

            <tr>
                <td data-label="Word">gnim</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">magnesium</td>
                <td data-label="Phon">magnizi#m</td>
                <td data-label="Definition">(xo) X1 is some magnesium</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: /mei<br>Latin: <br>Loglan: magne</td>
            </tr>

            <tr>
                <td data-label="Word">kqyw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hydrogen</td>
                <td data-label="Phon">haidrojen</td>
                <td data-label="Definition">(xo) X1 is some hydrogen</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: -qyw<br>Latin: -<br>Loglan: hidro</td>
            </tr>

            <tr>
                <td data-label="Word">jiaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">oxygen</td>
                <td data-label="Phon">aksyjn</td>
                <td data-label="Definition">(xo) X1 is some oxygen</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: |iaw<br>Latin: <br>Loglan: loksi</td>
            </tr>

            <tr>
                <td data-label="Word">forw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">phosphorus</td>
                <td data-label="Phon">fasfor#s</td>
                <td data-label="Definition">(xo) X1 is some phosphorus</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: /liw<br>Latin: <br>Loglan: loksi</td>
            </tr>

            <tr>
                <td data-label="Word">gnyr</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">silver</td>
                <td data-label="Phon">sylvr</td>
                <td data-label="Definition">(xo) X1 is some silver</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: /in<br>Latin: argent.um<br>Loglan: sagla</td>
            </tr>

            <tr>
                <td data-label="Word">gaim</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">calcium</td>
                <td data-label="Phon">kalsi#m</td>
                <td data-label="Definition">(xo) X1 is some calcium</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: !gai<br>Latin: <br>Loglan: calsi</td>
            </tr>

            <tr>
                <td data-label="Word">syny</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">silicon</td>
                <td data-label="Phon">sylykn</td>
                <td data-label="Definition">(xo) X1 is some silicon</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: -qi<br>Latin: <br>Loglan: silco</td>
            </tr>

            <tr>
                <td data-label="Word">slul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sulfur</td>
                <td data-label="Phon">s#lfr</td>
                <td data-label="Definition">(xo) X1 is some sulfur</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: /liou/huaw<br>Latin: sulfur<br>Loglan: sulfa</td>
            </tr>

            <tr>
                <td data-label="Word">twuw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">copper</td>
                <td data-label="Phon">kapr</td>
                <td data-label="Definition">(xo) X1 is some copper</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: /tuw<br>Latin: aes<br>Loglan: cupri</td>
            </tr>

            <tr>
                <td data-label="Word">styn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tin</td>
                <td data-label="Phon">tyn</td>
                <td data-label="Definition">(xo) X1 is some tin</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: -si<br>Latin: stan.um<br>Loglan: snatu</td>
            </tr>

            <tr>
                <td data-label="Word">somo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sodium</td>
                <td data-label="Phon">sodi#m</td>
                <td data-label="Definition">(xo) X1 is some sodium</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: !na<br>Latin: <br>Loglan: nadri</td>
            </tr>

            <tr>
                <td data-label="Word">psim</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">potassium</td>
                <td data-label="Phon">patasi#m</td>
                <td data-label="Definition">(xo) X1 is some potassium</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: |jia<br>Latin: <br>Loglan: kalium</td>
            </tr>

            <tr>
                <td data-label="Word">jnan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">nitrogen</td>
                <td data-label="Phon">naitrojen</td>
                <td data-label="Definition">(xo) X1 is some nitrogen</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: !dan<br>Latin: <br>Loglan: nitro</td>
            </tr>

            <tr>
                <td data-label="Word">tiai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">titanium</td>
                <td data-label="Phon">taitanyum</td>
                <td data-label="Definition">(xo) X1 is some titanium</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: !tai<br>Latin: <br>Loglan: titna</td>
            </tr>

            <tr>
                <td data-label="Word">karo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">carbon</td>
                <td data-label="Phon">karbon</td>
                <td data-label="Definition">(xo) X1 is some carbon</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: !tan<br>Latin: karbo<br>Loglan: carbo</td>
            </tr>

            <tr>
                <td data-label="Word">jiol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">gold</td>
                <td data-label="Phon">gold</td>
                <td data-label="Definition">(xo) X1 is some gold</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1<br>Chinese: -jin<br>Latin: aur.um<br>Loglan: galru</td>
            </tr>

            <tr>
                <td data-label="Word">kmy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">chemical, pure</td>
                <td data-label="Phon">kemykl</td>
                <td data-label="Definition">(xo) X1 is a chemically pure instance of substance (xo) X2*</td>
                <td data-label="Comments">Add by metaphor the scientific Latin name of an element or compound with no \guaspi\  word.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.1, 3.4.3, 3.6.1, 1.5.6<br>Chinese: /tsu#n!du<br>Latin: <br>Loglan: kemdi</td>
            </tr>

            <tr>
                <td data-label="Word">332</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Inorganic Compounds and Mixtures</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfen</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chalk</td>
                <td data-label="Phon">calk</td>
                <td data-label="Definition">(xo) X1 is some chalk</td>
                <td data-label="Comments">-stil -cfen for chalk writing stick.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: |fen|bi<br>Latin: kreta<br>Loglan: tokri</td>
            </tr>

            <tr>
                <td data-label="Word">cail</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">steel</td>
                <td data-label="Phon">stil</td>
                <td data-label="Definition">(xo) X1 is some steel with major element for alloy (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: -gaw<br>Latin: calibs<br>Loglan: gasti</td>
            </tr>

            <tr>
                <td data-label="Word">kqua</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">water</td>
                <td data-label="Phon">uatr</td>
                <td data-label="Definition">(xo) X1 is some water</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: |quei<br>Latin: akua<br>Loglan: cutri</td>
            </tr>

            <tr>
                <td data-label="Word">tami</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ceramic</td>
                <td data-label="Phon">seramik</td>
                <td data-label="Definition">(xo) X1 is some ceramic</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: /tau!ci<br>Latin: <br>Loglan: staku*</td>
            </tr>

            <tr>
                <td data-label="Word">fcir</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">air</td>
                <td data-label="Phon">er</td>
                <td data-label="Definition">(xo) X1 is some air</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: -kuw!ci<br>Latin: air<br>Loglan: kerti</td>
            </tr>

            <tr>
                <td data-label="Word">kqou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rock, stone</td>
                <td data-label="Phon">rak</td>
                <td data-label="Definition">(xo) X1 is some stone, rock</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: /qr-tou<br>Latin: saks.um<br>Loglan: troku</td>
            </tr>

            <tr>
                <td data-label="Word">glai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">clay</td>
                <td data-label="Phon">klai</td>
                <td data-label="Definition">(xo) X1 is some clay</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: /ni|tu<br>Latin: argila<br>Loglan: kliti*</td>
            </tr>

            <tr>
                <td data-label="Word">tlme</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">metal</td>
                <td data-label="Phon">metl</td>
                <td data-label="Definition">(xo) X1 is some metal</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 12<br>Thes: 3.3.2<br>Chinese: |u-jin<br>Latin: metal.um<br>Loglan: metli</td>
            </tr>

            <tr>
                <td data-label="Word">tuol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">soil, dirt</td>
                <td data-label="Phon">drt</td>
                <td data-label="Definition">(xo) X1 is some soil or dirt</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">jrer</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: |tu!di<br>Latin: sol.um<br>Loglan: dertu</td>
            </tr>

            <tr>
                <td data-label="Word">vyol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">glass</td>
                <td data-label="Phon">glas</td>
                <td data-label="Definition">(xo) X1 is some glass</td>
                <td data-label="Comments">Use -qkul |vyol for a glass drinking cup.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: -buo-li<br>Latin: vytr.um<br>Loglan: gliso</td>
            </tr>

            <tr>
                <td data-label="Word">tora</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">brass</td>
                <td data-label="Phon">bras</td>
                <td data-label="Definition">(xo) X1 is some brass</td>
                <td data-label="Comments">Copper-zinc alloy.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: /huaw/tow<br>Latin: orycalk.um<br>Loglan: rasto</td>
            </tr>

            <tr>
                <td data-label="Word">cywu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bronze</td>
                <td data-label="Phon">bronz</td>
                <td data-label="Definition">(xo) X1 is some bronze</td>
                <td data-label="Comments">Copper-tin alloy.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: -cyw/tuw<br>Latin: ahene.us<br>Loglan: ransu*</td>
            </tr>

            <tr>
                <td data-label="Word">snan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sand</td>
                <td data-label="Phon">sand</td>
                <td data-label="Definition">(xo) X1 is some sand</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2<br>Chinese: -qa<br>Latin: harena<br>Loglan: sanca</td>
            </tr>

            <tr>
                <td data-label="Word">cani</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ammonia</td>
                <td data-label="Phon">amonia</td>
                <td data-label="Definition">(xo) X1 is some ammonia</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2, 3.6.1<br>Chinese: -an<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">psal</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">salt</td>
                <td data-label="Phon">salt</td>
                <td data-label="Definition">(xo) X1 is some salt, NaCl</td>
                <td data-label="Comments">-zao -psal for tastes salty.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.2, 4.3.5<br>Chinese: /ian<br>Latin: sal<br>Loglan: solte</td>
            </tr>

            <tr>
                <td data-label="Word">333</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Organic Compounds and Mixtures</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">joil</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">oil, grease, mucus, lubricate</td>
                <td data-label="Phon">oil</td>
                <td data-label="Definition">(xo) X1 is some lubricant for making surface X2* slippery</td>
                <td data-label="Comments">In animals often a polysaccharide solution (mucus), also used to flush out or immobilize predators or vermin.</td>
                <td data-label="Xref">deri, trou</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: -ji/iou<br>Latin: lubryk.o<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">trou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">oil, petroleum</td>
                <td data-label="Phon">petrole#m</td>
                <td data-label="Definition">(xo) X1 is some petroleum</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">joil</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: !ci/iou<br>Latin: <br>Loglan: ctile*</td>
            </tr>

            <tr>
                <td data-label="Word">pyuo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tar</td>
                <td data-label="Phon">tar</td>
                <td data-label="Definition">(xo) X1 is some tar</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: /buo/iou<br>Latin: pyks<br>Loglan: tarla*</td>
            </tr>

            <tr>
                <td data-label="Word">qniu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">urine</td>
                <td data-label="Phon">iuryn</td>
                <td data-label="Definition">(xo) X1 is some urine of creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: !niau<br>Latin: <br>Loglan: pinca</td>
            </tr>

            <tr>
                <td data-label="Word">krol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">coal</td>
                <td data-label="Phon">kol</td>
                <td data-label="Definition">(xo) X1 is some coal</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: /mei<br>Latin: karbo<br>Loglan: kolme</td>
            </tr>

            <tr>
                <td data-label="Word">veue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sputum, spit</td>
                <td data-label="Phon">spyt</td>
                <td data-label="Definition">(xo) X1 is some spit, sputum from creature X2*</td>
                <td data-label="Comments">Use -dou !kque for expectorate.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: |kou|quei<br>Latin: veru<br>Loglan: spetu</td>
            </tr>

            <tr>
                <td data-label="Word">skor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cork</td>
                <td data-label="Phon">kork</td>
                <td data-label="Definition">(xo) X1 is some cork</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: -sai.-dz<br>Latin: korteks<br>Loglan: korka</td>
            </tr>

            <tr>
                <td data-label="Word">qker</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wax, olefin</td>
                <td data-label="Phon">uaks</td>
                <td data-label="Definition">(xo) X1 is some wax</td>
                <td data-label="Comments">Includes propane, butane, etc.  -qker -kem !zbon |pa for specific chain length.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: !la<br>Latin: kera<br>Loglan: lakse</td>
            </tr>

            <tr>
                <td data-label="Word">qko</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">alcohol</td>
                <td data-label="Phon">alkohol</td>
                <td data-label="Definition">(xo) X1 is a portion of alcohol</td>
                <td data-label="Comments">-qko -kem !zbon |pa for specific chain length (propanol, etc.)</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: |jio-jiw<br>Latin: <br>Loglan: xalka*</td>
            </tr>

            <tr>
                <td data-label="Word">ster</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">feces, shit</td>
                <td data-label="Phon">qyt</td>
                <td data-label="Definition">(xo) X1 is some shit, feces of creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: |s#<br>Latin: sterk.us<br>Loglan: ctuda</td>
            </tr>

            <tr>
                <td data-label="Word">gliu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wood</td>
                <td data-label="Phon">u#d</td>
                <td data-label="Definition">(xo) X1 is some wood of tree (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.3<br>Chinese: !mu!liau<br>Latin: lign.um<br>Loglan: mubre</td>
            </tr>

            <tr>
                <td data-label="Word">334</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Artificial Materials</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bria</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rubber</td>
                <td data-label="Phon">r#br</td>
                <td data-label="Definition">(xo) X1 is some rubber</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tsi</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: !qu-jiau<br>Latin: <br>Loglan: ckabu</td>
            </tr>

            <tr>
                <td data-label="Word">crar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">paper</td>
                <td data-label="Phon">paipr</td>
                <td data-label="Definition">(xo) X1 is some paper</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: |jr<br>Latin: carta<br>Loglan: papre</td>
            </tr>

            <tr>
                <td data-label="Word">glue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">paste, glue</td>
                <td data-label="Phon">paist</td>
                <td data-label="Definition">(xo) X1 is some glue or paste</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tye</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: !jiaw-hu<br>Latin: gluten<br>Loglan: pasti</td>
            </tr>

            <tr>
                <td data-label="Word">pnyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">paint</td>
                <td data-label="Phon">paint</td>
                <td data-label="Definition">(xo) X1 is some paint</td>
                <td data-label="Comments">Color example: -pnyn |vba = white paint.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: /iou-ci<br>Latin: pyng.ere<br>Loglan: pinti</td>
            </tr>

            <tr>
                <td data-label="Word">plau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">plastic</td>
                <td data-label="Phon">plastyk</td>
                <td data-label="Definition">(xo) X1 is some plastic</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: !su-jiau<br>Latin: <br>Loglan: slasi*</td>
            </tr>

            <tr>
                <td data-label="Word">qeme</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ink</td>
                <td data-label="Phon">ynk</td>
                <td data-label="Definition">(xo) X1 is some ink</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: !m#|quei<br>Latin: atrament.um<br>Loglan: tinmo</td>
            </tr>

            <tr>
                <td data-label="Word">spom</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">soap</td>
                <td data-label="Phon">sop</td>
                <td data-label="Definition">(xo) X1 is some soap</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: /fei!dzau<br>Latin: sapo<br>Loglan: dzaso</td>
            </tr>

            <tr>
                <td data-label="Word">spol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">polish</td>
                <td data-label="Phon">palyq</td>
                <td data-label="Definition">(xo) X1 is some polish</td>
                <td data-label="Comments">For making things clean and shiny.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: -tsa<br>Latin: pol.yre<br>Loglan: palci</td>
            </tr>

            <tr>
                <td data-label="Word">baor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cardboard</td>
                <td data-label="Phon">kardbord</td>
                <td data-label="Definition">(xo) X1 is a piece of cardboard</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: !iw|j|ban<br>Latin: <br>Loglan: karto</td>
            </tr>

            <tr>
                <td data-label="Word">fliu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">fuel</td>
                <td data-label="Phon">fiuel</td>
                <td data-label="Definition">(xo) X1 is some fuel for powering engine (xi) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4<br>Chinese: /ran!liau<br>Latin: lygna<br>Loglan: livla*</td>
            </tr>

            <tr>
                <td data-label="Word">kory</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pelt, hide, leather</td>
                <td data-label="Phon">pelt</td>
                <td data-label="Definition">X1 is a pelt, cured hide or piece of leather from animal X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fpyl, skyn</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4, 4.1.7<br>Chinese: /pi<br>Latin: kory.um<br>Loglan: pelpi</td>
            </tr>

            <tr>
                <td data-label="Word">xbu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">cloth</td>
                <td data-label="Phon">klot</td>
                <td data-label="Definition">(xo) X1 is some cloth of material (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4, 4.1.7<br>Chinese: !bu<br>Latin: tekst.um<br>Loglan: klabu</td>
            </tr>

            <tr>
                <td data-label="Word">deri</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">grease, fat</td>
                <td data-label="Phon">gris</td>
                <td data-label="Definition">(xo) X1 is some grease</td>
                <td data-label="Comments">Liquid or solid, eaten or used to prepare food.  Use -joil for lubrication.</td>
                <td data-label="Xref">tfa, joil</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.4, 4.3.5<br>Chinese: /iou<br>Latin: adeps<br>Loglan: gresa</td>
            </tr>

            <tr>
                <td data-label="Word">335</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Forms of Materials</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">smom</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">smoke</td>
                <td data-label="Phon">smok</td>
                <td data-label="Definition">(xo) X1 is some smoke from emitter (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: -ian<br>Latin: fum.us<br>Loglan: smano</td>
            </tr>

            <tr>
                <td data-label="Word">cene</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">dust</td>
                <td data-label="Phon">d#st</td>
                <td data-label="Definition">(xo) X1 is some dust</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pul</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: /cen<br>Latin: pulv.ys<br>Loglan: dustu</td>
            </tr>

            <tr>
                <td data-label="Word">jeum</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">vacuum</td>
                <td data-label="Phon">vakium</td>
                <td data-label="Definition">(xo) X1 is a portion of vacuum</td>
                <td data-label="Comments">Specifically free of air.</td>
                <td data-label="Xref">swu</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: -jen-kuw<br>Latin: vaku#m<br>Loglan: sakci*</td>
            </tr>

            <tr>
                <td data-label="Word">kmen</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ore, mineral</td>
                <td data-label="Phon">men#r#l</td>
                <td data-label="Definition">(xo) X1 is some mineral or ore of product (xo) X2*</td>
                <td data-label="Comments">E.g. -kmen -gnyr = silver ore.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: !kuaw!u<br>Latin: aes<br>Loglan: minku</td>
            </tr>

            <tr>
                <td data-label="Word">pul</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">powder</td>
                <td data-label="Phon">paudr</td>
                <td data-label="Definition">(xo) X1 is some powder of substance (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">cene</td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: |fen<br>Latin: pulv.ys<br>Loglan: pudru</td>
            </tr>

            <tr>
                <td data-label="Word">pum</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">foam, froth</td>
                <td data-label="Phon">fom</td>
                <td data-label="Definition">(xo) X1 is a foam or froth of substance (xo) X2* inflated with gas (xo) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: !pau!muo<br>Latin: spuma<br>Loglan: fonmo*</td>
            </tr>

            <tr>
                <td data-label="Word">gaiw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ice</td>
                <td data-label="Phon">ais</td>
                <td data-label="Definition">(xo) X1 is some ice, frozen liquid (xo-kqua) X2*</td>
                <td data-label="Comments">For materials that are normally liquid or gas.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: -biw<br>Latin: glaki.es<br>Loglan: bisli</td>
            </tr>

            <tr>
                <td data-label="Word">slu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">solution</td>
                <td data-label="Phon">s#luqn</td>
                <td data-label="Definition">(xo) X1 is a solution in solvent (xo-kqua) X2 of solute (xo) X3*= repeated as needed</td>
                <td data-label="Comments">But only X3 compounds.  </td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: /ruw!ie<br>Latin: solut.yo<br>Loglan: runta*</td>
            </tr>

            <tr>
                <td data-label="Word">teie</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">precipitate</td>
                <td data-label="Phon">presypytait</td>
                <td data-label="Definition">(xo) X1 is a precipitate from solution (xo) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5<br>Chinese: /ts#n!dien<br>Latin: <br>Loglan: sicpi*</td>
            </tr>

            <tr>
                <td data-label="Word">tli</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">material</td>
                <td data-label="Phon">matiri#l</td>
                <td data-label="Definition">X1 is made of material (xo) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5, 1.5.1<br>Chinese: /tsai!liau<br>Latin: matery.es<br>Loglan: ctifu</td>
            </tr>

            <tr>
                <td data-label="Word">kql</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">liquid</td>
                <td data-label="Phon">lykuyd</td>
                <td data-label="Definition">(xo) X1 is some liquid which freezes at temperature (xu) X2 and boils at temperature (xu) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5, 3.4.2<br>Chinese: !i|ti<br>Latin: lykuor<br>Loglan: flidu</td>
            </tr>

            <tr>
                <td data-label="Word">psl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">solid</td>
                <td data-label="Phon">salyd</td>
                <td data-label="Definition">(xo) X1 is a serving of solid below temperature (xu) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5, 3.4.2<br>Chinese: !gu|ti<br>Latin: solyd.us<br>Loglan: saldi</td>
            </tr>

            <tr>
                <td data-label="Word">xga</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">gas, vapor</td>
                <td data-label="Phon">gas</td>
                <td data-label="Definition">(xo) X1 is a serving of gas, vapor above temperature (xu) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.3.5, 3.4.2<br>Chinese: !ci<br>Latin: vapor<br>Loglan: vapro</td>
            </tr>

            <tr>
                <td data-label="Word">340</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Physics and Meteorology</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">341</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Static Phenomena and Shapes</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">drop</td>
                <td data-label="Phon">drap</td>
                <td data-label="Definition">X1 is a drop of liquid (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: -di<br>Latin: guta<br>Loglan: drida</td>
            </tr>

            <tr>
                <td data-label="Word">kra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">scratch</td>
                <td data-label="Phon">skratc</td>
                <td data-label="Definition">X1 is a scratch in surface X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: -gua<br>Latin: skab.ere<br>Loglan: kraju</td>
            </tr>

            <tr>
                <td data-label="Word">ksl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">crystal</td>
                <td data-label="Phon">krystl</td>
                <td data-label="Definition">X1 is a crystal of chemical (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: !tou/miw<br>Latin: krystal.us<br>Loglan: krili*</td>
            </tr>

            <tr>
                <td data-label="Word">pil</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">pile, mountain</td>
                <td data-label="Phon">pail</td>
                <td data-label="Definition">X1 is a pile of stuff (xo) X2*</td>
                <td data-label="Comments">Use -pil -kqou for mountain.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: -duei<br>Latin: stru.es<br>Loglan: monca</td>
            </tr>

            <tr>
                <td data-label="Word">qka</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">hole, depress</td>
                <td data-label="Phon">hol</td>
                <td data-label="Definition">X1 is a hole or depression in surface X2*</td>
                <td data-label="Comments">-qka -pne is required for a penetrating hole.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: !duw<br>Latin: kav.um<br>Loglan: holdu</td>
            </tr>

            <tr>
                <td data-label="Word">spa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">space</td>
                <td data-label="Phon">spais</td>
                <td data-label="Definition">(xo) X1 is a region of space</td>
                <td data-label="Comments">That which stars and planets are in.</td>
                <td data-label="Xref">cme, tera, jomu</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: -kuw-jian<br>Latin: <br>Loglan: spasi</td>
            </tr>

            <tr>
                <td data-label="Word">kuai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">block</td>
                <td data-label="Phon">blok</td>
                <td data-label="Definition">X1 is a block made of material (xo) X2</td>
                <td data-label="Comments">Generally rectangular solid piece.</td>
                <td data-label="Xref">bryr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: |kuai<br>Latin: styp.es<br>Loglan: blaku*</td>
            </tr>

            <tr>
                <td data-label="Word">tmo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rhythm</td>
                <td data-label="Phon">rytm</td>
                <td data-label="Definition">X1 is a rhythm of process X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: /suan!liu<br>Latin: mod.us<br>Loglan: rinta</td>
            </tr>

            <tr>
                <td data-label="Word">tor</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">store, reserve, deposit</td>
                <td data-label="Phon">stor</td>
                <td data-label="Definition">(xe) X1 is a store, reserve, deposit of goods (xo) X2*</td>
                <td data-label="Comments">May be natural (of minerals) or artificial (of goods or money).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: /tsun<br>Latin: kopya<br>Loglan: sordi</td>
            </tr>

            <tr>
                <td data-label="Word">tyil</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">electricity</td>
                <td data-label="Phon">ilektryk</td>
                <td data-label="Definition">(xo) X1 is some electricity in conductor X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: !dian<br>Latin: <br>Loglan: lenki</td>
            </tr>

            <tr>
                <td data-label="Word">biwi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bead, pebble</td>
                <td data-label="Phon">bid</td>
                <td data-label="Definition">X1 is a bead made of material (xo) X2</td>
                <td data-label="Comments">Includes natural pebbles.  Small, roundish, may have a hole.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: /qr.-dz<br>Latin: baka<br>Loglan: bidju*</td>
            </tr>

            <tr>
                <td data-label="Word">zge</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">crack</td>
                <td data-label="Phon">krak</td>
                <td data-label="Definition">X1 is a crack in surface X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.1<br>Chinese: !lie/uen<br>Latin: ryma<br>Loglan: karku</td>
            </tr>

            <tr>
                <td data-label="Word">342</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Energetic Phenomena</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bza</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">ray</td>
                <td data-label="Phon">rai</td>
                <td data-label="Definition">X1 is a ray from emitter X2*</td>
                <td data-label="Comments">Mainly for subatomic particles but including null particles like photons.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: -guaw!sian<br>Latin: rady.us<br>Loglan: kreni</td>
            </tr>

            <tr>
                <td data-label="Word">cfl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">flame, fire</td>
                <td data-label="Phon">flaim</td>
                <td data-label="Definition">X1 is a flame from apparatus or fire X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zbr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: |huo/ian<br>Latin: flama<br>Loglan: flami</td>
            </tr>

            <tr>
                <td data-label="Word">fsn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">sound</td>
                <td data-label="Phon">saund</td>
                <td data-label="Definition">(xo) X1 is sound from emitter (vo) X2+</td>
                <td data-label="Comments">Bell ringing: ^fsn !qkm !tfel, not csn =tynl.</td>
                <td data-label="Xref">sau, tia</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: -qew-in<br>Latin: son.us<br>Loglan: sonda</td>
            </tr>

            <tr>
                <td data-label="Word">dvu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">wave</td>
                <td data-label="Phon">uav</td>
                <td data-label="Definition">X1 is a wave in medium X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: !law<br>Latin: unda<br>Loglan: valpu</td>
            </tr>

            <tr>
                <td data-label="Word">pqe</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">jet</td>
                <td data-label="Phon">jet</td>
                <td data-label="Definition">X1 is a jet of material (xo) X2*</td>
                <td data-label="Comments">X2 is flowing through space in a narrow stream.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: -p#n!qe<br>Latin: gagat.es<br>Loglan: jetce*</td>
            </tr>

            <tr>
                <td data-label="Word">qao</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">shade, light, shadow</td>
                <td data-label="Phon">qado</td>
                <td data-label="Definition">X1 is shade, the shadow of object X2* from light X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: |iw.-dz<br>Latin: umbra<br>Loglan: cedzu</td>
            </tr>

            <tr>
                <td data-label="Word">qca</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">tide</td>
                <td data-label="Phon">taid</td>
                <td data-label="Definition">X1 is a tide in sea X2 raised by planet X3</td>
                <td data-label="Comments">X2 is typically the sea; X3 then is the sun or moon.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: /cau|quei<br>Latin: aest.us<br>Loglan: ctaru*</td>
            </tr>

            <tr>
                <td data-label="Word">skl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">light, lamp</td>
                <td data-label="Phon">lait</td>
                <td data-label="Definition">(xo) X1 is light from source or lamp X2* on surface X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">xgm</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: -guaw<br>Latin: luks<br>Loglan: litla</td>
            </tr>

            <tr>
                <td data-label="Word">tma</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">magnet</td>
                <td data-label="Phon">magnet</td>
                <td data-label="Definition">Object X1 interacts with object X2 by magnetism</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: -qi|tie<br>Latin: magn.es<br>Loglan: maksi*</td>
            </tr>

            <tr>
                <td data-label="Word">xgn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">fire, fuel</td>
                <td data-label="Phon">fair</td>
                <td data-label="Definition">X1 is a fire in fuel X2*</td>
                <td data-label="Comments">X2 may be an object like a house.  Use -cfl for lanterns, etc.</td>
                <td data-label="Xref">zbr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.2<br>Chinese: |huo<br>Latin: ygn.ys<br>Loglan: fagro</td>
            </tr>

            <tr>
                <td data-label="Word">343</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Physical Abstractions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ftr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">matter</td>
                <td data-label="Phon">matr</td>
                <td data-label="Definition">(xo) X1 is matter</td>
                <td data-label="Comments">Use -qcy for ``what&#x27;s the matter&#x27;&#x27;.</td>
                <td data-label="Xref">qcy</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3<br>Chinese: !u/ji<br>Latin: korp.us<br>Loglan: ctifu</td>
            </tr>

            <tr>
                <td data-label="Word">kfi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">physical</td>
                <td data-label="Phon">fyzikal</td>
                <td data-label="Definition">(vo) X1 is a physical phenomenon</td>
                <td data-label="Comments">As opposed to mental or spiritual.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3<br>Chinese: !dz/ran!jie<br>Latin: fisyka<br>Loglan: fizdi</td>
            </tr>

            <tr>
                <td data-label="Word">psr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">object, thing</td>
                <td data-label="Phon">tyw</td>
                <td data-label="Definition">X1 is a thing or object</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3<br>Chinese: !u/jr<br>Latin: res<br>Loglan: bekti</td>
            </tr>

            <tr>
                <td data-label="Word">qcr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">phenomenon, nature</td>
                <td data-label="Phon">naitcr</td>
                <td data-label="Definition">(vo) X1 is a natural phenomenon</td>
                <td data-label="Comments">As opposed to magic.</td>
                <td data-label="Xref">fkr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3<br>Chinese: !di!qr<br>Latin: natural.ys<br>Loglan: natra</td>
            </tr>

            <tr>
                <td data-label="Word">psu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">atom, molecule, cell</td>
                <td data-label="Phon">atom</td>
                <td data-label="Definition">X1 is an atom of substance (xo) X2</td>
                <td data-label="Comments">Any indivisible building block; includes living cells.  X2 is the material or species.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3, 1.1.3<br>Chinese: /uen.-dz<br>Latin: korpuskul.um<br>Loglan: ratni*</td>
            </tr>

            <tr>
                <td data-label="Word">gyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">interval, time</td>
                <td data-label="Phon">yntrvl</td>
                <td data-label="Definition">X1 is the time interval from event (vo) X2@ to event (vo) X3@</td>
                <td data-label="Comments">Neither one merges.</td>
                <td data-label="Xref">swa</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3, 3.5.6, 1.4.4<br>Chinese: -jian/g#<br>Latin: ynterval.um<br>Loglan: ckemo</td>
            </tr>

            <tr>
                <td data-label="Word">fkr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">artifact</td>
                <td data-label="Phon">artyfakt</td>
                <td data-label="Definition">X1+ is made, done or caused by people</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">qcr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3, 4.4.5<br>Chinese: /ren-guw<br>Latin: arte<br>Loglan: ritna*</td>
            </tr>

            <tr>
                <td data-label="Word">ske</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">fact, science</td>
                <td data-label="Phon">saiens</td>
                <td data-label="Definition">(vo) X1 is a scientific fact</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.3, 4.4.5<br>Chinese: -k#/que<br>Latin: skyentya<br>Loglan: sensi</td>
            </tr>

            <tr>
                <td data-label="Word">344</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Weather Phenomena</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tony</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">thunder</td>
                <td data-label="Phon">tundr</td>
                <td data-label="Definition">X1 is thunder</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4<br>Chinese: /lei<br>Latin: tonytr.us<br>Loglan: ledri</td>
            </tr>

            <tr>
                <td data-label="Word">tfe</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">weather</td>
                <td data-label="Phon">uetr</td>
                <td data-label="Definition">X1 is a weather phenomenon</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4<br>Chinese: -tian!ci<br>Latin: kael.um<br>Loglan: tetri</td>
            </tr>

            <tr>
                <td data-label="Word">diny</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lightning</td>
                <td data-label="Phon">laitnyw</td>
                <td data-label="Definition">X1 is lightning</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4<br>Chinese: |qan!dian<br>Latin: fulmen<br>Loglan: bolti</td>
            </tr>

            <tr>
                <td data-label="Word">vnyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wind</td>
                <td data-label="Phon">uynd</td>
                <td data-label="Definition">X1 is a wind from direction (xi) X2*</td>
                <td data-label="Comments">Blows from X2 (north, etc., also can be a place) to its opposite.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4<br>Chinese: -f#w<br>Latin: vent.us<br>Loglan: brize</td>
            </tr>

            <tr>
                <td data-label="Word">kunu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cloud</td>
                <td data-label="Phon">klaud</td>
                <td data-label="Definition">X1 is a cloud of substance (xo-kqua) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4<br>Chinese: /iun<br>Latin: nub.es<br>Loglan: klada</td>
            </tr>

            <tr>
                <td data-label="Word">bau</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">hail</td>
                <td data-label="Phon">hail</td>
                <td data-label="Definition">(xo) X1 falls like hail on surface X2 from cloud X3 via route X4</td>
                <td data-label="Comments">Hail is solid rain.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4, 2.2.6<br>Chinese: /bau<br>Latin: grando<br>Loglan: bratu*</td>
            </tr>

            <tr>
                <td data-label="Word">ply</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rain</td>
                <td data-label="Phon">rain</td>
                <td data-label="Definition">X1 falls as rain on surface X2 from cloud X3 via route X4</td>
                <td data-label="Comments">Use -dra -ply = raindrop.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4, 2.2.6<br>Chinese: |u<br>Latin: pluvya<br>Loglan: crina</td>
            </tr>

            <tr>
                <td data-label="Word">ksny</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">snow</td>
                <td data-label="Phon">sno</td>
                <td data-label="Definition">X1 falls as snow on surface X2 from cloud X3 via route X4</td>
                <td data-label="Comments">Snow is fluffy ice crystals.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4, 3.3.2, 2.2.6<br>Chinese: |sue<br>Latin: nyks<br>Loglan: snice</td>
            </tr>

            <tr>
                <td data-label="Word">vbu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">fog</td>
                <td data-label="Phon">fag</td>
                <td data-label="Definition">X1 is a fog of material (xo) X2*</td>
                <td data-label="Comments">Typically water.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.4.4, 3.3.5<br>Chinese: !u<br>Latin: nebula<br>Loglan: fragu</td>
            </tr>

            <tr>
                <td data-label="Word">350</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Places and Seasons</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">X2 of a place is usually either a larger structure containing it or a more general place where it is located.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">351</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Natural Places on a Planet</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gvry</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">river, basin, drain</td>
                <td data-label="Phon">ryvr</td>
                <td data-label="Definition">X1 is a river draining basin X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1<br>Chinese: /h#<br>Latin: flumen<br>Loglan: vrici</td>
            </tr>

            <tr>
                <td data-label="Word">tera</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">land, region</td>
                <td data-label="Phon">land</td>
                <td data-label="Definition">X1 is a piece of land in region X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1<br>Chinese: |tu!di<br>Latin: tera<br>Loglan: landi</td>
            </tr>

            <tr>
                <td data-label="Word">diar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">field, farm</td>
                <td data-label="Phon">fild</td>
                <td data-label="Definition">X1 is a field of farm X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1<br>Chinese: /tian!di<br>Latin: ager<br>Loglan: fildi</td>
            </tr>

            <tr>
                <td data-label="Word">kqla</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lake</td>
                <td data-label="Phon">laik</td>
                <td data-label="Definition">X1 is a lake in region X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1<br>Chinese: /hu<br>Latin: lak.us<br>Loglan: vlako</td>
            </tr>

            <tr>
                <td data-label="Word">biai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bay, coast</td>
                <td data-label="Phon">bai</td>
                <td data-label="Definition">X1 is a bay on coast X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1<br>Chinese: |hai-uan<br>Latin: sayn.us<br>Loglan: banbe</td>
            </tr>

            <tr>
                <td data-label="Word">dlau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">island</td>
                <td data-label="Phon">ailand</td>
                <td data-label="Definition">X1 is an island in sea X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1<br>Chinese: |dau<br>Latin: ynsula<br>Loglan: cilda</td>
            </tr>

            <tr>
                <td data-label="Word">sima</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sea</td>
                <td data-label="Phon">si</td>
                <td data-label="Definition">X1 is a sea of planet X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1<br>Chinese: |hai<br>Latin: mare<br>Loglan: mursi</td>
            </tr>

            <tr>
                <td data-label="Word">skai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sky</td>
                <td data-label="Phon">skai</td>
                <td data-label="Definition">X1 is the sky of planet X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1, 3.4.4<br>Chinese: -tian<br>Latin: kael.um<br>Loglan: skati</td>
            </tr>

            <tr>
                <td data-label="Word">qkae</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cave</td>
                <td data-label="Phon">kav</td>
                <td data-label="Definition">X1 is a cave in region X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.1, 4.2.8<br>Chinese: !duw<br>Latin: kaverna<br>Loglan: kuvla</td>
            </tr>

            <tr>
                <td data-label="Word">352</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Celestial and Miscellaneous Places</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qyun</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">satellite, moon</td>
                <td data-label="Phon">mun</td>
                <td data-label="Definition">X1 is a satellite of primary body X2</td>
                <td data-label="Comments">Typically Earth&#x27;s Moon.  -qo -:luna is the formal name of Earth&#x27;s moon.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2<br>Chinese: !uei-qyw<br>Latin: luna<br>Loglan: lunra</td>
            </tr>

            <tr>
                <td data-label="Word">jomu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">universe, cosmos</td>
                <td data-label="Phon">kosm#s</td>
                <td data-label="Definition">X1 is the universe</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">spa</td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2<br>Chinese: |iu!jou<br>Latin: mund.us<br>Loglan: munje*</td>
            </tr>

            <tr>
                <td data-label="Word">jrer</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">homeworld, earth</td>
                <td data-label="Phon">rt</td>
                <td data-label="Definition">X1 is the homeworld of person (ji) X2</td>
                <td data-label="Comments">Typically Earth.  -qo -tera is the formal name for Earth.</td>
                <td data-label="Xref">tuol</td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2<br>Chinese: !qr!jie<br>Latin: tera<br>Loglan: terla</td>
            </tr>

            <tr>
                <td data-label="Word">star</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">star, galaxy</td>
                <td data-label="Phon">star</td>
                <td data-label="Definition">X1 is a star in galaxy X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2<br>Chinese: -qiw<br>Latin: stela<br>Loglan: tarci</td>
            </tr>

            <tr>
                <td data-label="Word">stel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">planet, star, sun</td>
                <td data-label="Phon">planet</td>
                <td data-label="Definition">X1 is a planet orbiting star X2</td>
                <td data-label="Comments">Typically Earth&#x27;s Sun.  -qo -sol is the formal name for the Sun.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2<br>Chinese: -siw<br>Latin: stela<br>Loglan: solra</td>
            </tr>

            <tr>
                <td data-label="Word">vni</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">environment</td>
                <td data-label="Phon">environment</td>
                <td data-label="Definition">X1 is the environment of event (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2<br>Chinese: /huan!jiw<br>Latin: <br>Loglan: vanbi*</td>
            </tr>

            <tr>
                <td data-label="Word">tein</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">territory</td>
                <td data-label="Phon">terytori</td>
                <td data-label="Definition">X1 is a place in the territory of creature X2*</td>
                <td data-label="Comments">Use -xy to get the whole territory.</td>
                <td data-label="Xref">jiwe</td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2, 3.6.2<br>Chinese: |tu!di<br>Latin: fin.es<br>Loglan: tutra*</td>
            </tr>

            <tr>
                <td data-label="Word">juo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">habitat</td>
                <td data-label="Phon">habytat</td>
                <td data-label="Definition">X1 is a place in the habitat of species (xr) X2s*</td>
                <td data-label="Comments">Use -xy to get whole habitat.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.2, 3.6.2<br>Chinese: -ju/lio!di<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">353</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Human Work Places</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: is a place of significance X2 at locality X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">barn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">office, station</td>
                <td data-label="Phon">afys</td>
                <td data-label="Definition">X1 is the office or duty station of worker X2</td>
                <td data-label="Comments">Use -zu -toa for office in the sense of a government position.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: !ban-guw!qr<br>Latin: taberna<br>Loglan: fusto</td>
            </tr>

            <tr>
                <td data-label="Word">fary</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">factory, mill</td>
                <td data-label="Phon">faktori</td>
                <td data-label="Definition">X1 is a mill, factory where product (xo) X2* is made, at X3:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: -guw|caw<br>Latin: fabryka<br>Loglan: molci</td>
            </tr>

            <tr>
                <td data-label="Word">taio</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">post~office</td>
                <td data-label="Phon">post-afys</td>
                <td data-label="Definition">X1 is a post office of locality X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: /iou!jew/ju<br>Latin: tabelarii<br>Loglan: posta</td>
            </tr>

            <tr>
                <td data-label="Word">bana</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bank, financial</td>
                <td data-label="Phon">bank</td>
                <td data-label="Definition">X1 is a financial institution of locality X2</td>
                <td data-label="Comments">Not for river banks.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: /in/haw<br>Latin: argentarya<br>Loglan: banko</td>
            </tr>

            <tr>
                <td data-label="Word">kmaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">market, store, shop</td>
                <td data-label="Phon">mark#t</td>
                <td data-label="Definition">X1 is a market, trade site where product (xo) X2* is sold, at X3:</td>
                <td data-label="Comments">Includes single stores or organized groups.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 15<br>Thes: 3.5.3<br>Chinese: !qr|caw<br>Latin: makel.um<br>Loglan: marto</td>
            </tr>

            <tr>
                <td data-label="Word">jaue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">church, god, temple</td>
                <td data-label="Phon">curc</td>
                <td data-label="Definition">X1 is a temple or church of gods X2* at X3:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: !jiau!huei<br>Latin: eklesya<br>Loglan: tepli</td>
            </tr>

            <tr>
                <td data-label="Word">skul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">school</td>
                <td data-label="Phon">skul</td>
                <td data-label="Definition">Students X1 learn skill (vo) X2+1 at school X3*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: /sue<br>Latin: skola<br>Loglan: ckela</td>
            </tr>

            <tr>
                <td data-label="Word">stan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">station, transport</td>
                <td data-label="Phon">staqn</td>
                <td data-label="Definition">X1 is a station in transport sytem X2* at X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: !jan<br>Latin: <br>Loglan: stana</td>
            </tr>

            <tr>
                <td data-label="Word">carm</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">farm</td>
                <td data-label="Phon">farm</td>
                <td data-label="Definition">X1 is a farm of locality X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.3<br>Chinese: /nuw|caw<br>Latin: praedy.um<br>Loglan: fanra</td>
            </tr>

            <tr>
                <td data-label="Word">354</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Places to Visit</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: is a place at locality X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tana</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">restaurant</td>
                <td data-label="Phon">restarant</td>
                <td data-label="Definition">X1 is a restaurant at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">feae</td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: !fan|guan<br>Latin: taberna<br>Loglan: resra</td>
            </tr>

            <tr>
                <td data-label="Word">bzow</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cabaret</td>
                <td data-label="Phon">kabarai</td>
                <td data-label="Definition">X1 is a cabaret at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: !ie|dzow!huei<br>Latin: <br>Loglan: kabre</td>
            </tr>

            <tr>
                <td data-label="Word">doel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hotel</td>
                <td data-label="Phon">hotel</td>
                <td data-label="Definition">X1 is a hotel at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: |liu|guan<br>Latin: deversory.um<br>Loglan: hotle</td>
            </tr>

            <tr>
                <td data-label="Word">feae</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cafe, eatery</td>
                <td data-label="Phon">kafe</td>
                <td data-label="Definition">X1 is a cafe at X2:</td>
                <td data-label="Comments">A small, informal or fast-food eatery.</td>
                <td data-label="Xref">tana</td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: -ka-fei|guan<br>Latin: <br>Loglan: ckafe</td>
            </tr>

            <tr>
                <td data-label="Word">vnan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tavern</td>
                <td data-label="Phon">tavrn</td>
                <td data-label="Definition">X1 is a tavern at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: |jiou|guan<br>Latin: kaupona<br>Loglan: barju</td>
            </tr>

            <tr>
                <td data-label="Word">spya</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hospital</td>
                <td data-label="Phon">hospytal</td>
                <td data-label="Definition">X1 is a hospital at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: -i!uan<br>Latin: <br>Loglan: hospa</td>
            </tr>

            <tr>
                <td data-label="Word">triu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">theater</td>
                <td data-label="Phon">ti#tr</td>
                <td data-label="Definition">X1 is a theater at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: !si!uan<br>Latin: teatr.um<br>Loglan: tatro</td>
            </tr>

            <tr>
                <td data-label="Word">ziuo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">museum</td>
                <td data-label="Phon">miuzi#m</td>
                <td data-label="Definition">X1 is a museum for preserving (xi) X2* in locality X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.4<br>Chinese: /buo!u|guan<br>Latin: <br>Loglan: muzga*</td>
            </tr>

            <tr>
                <td data-label="Word">355</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Other Human Places</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: is a place at locality X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">guar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">park</td>
                <td data-label="Phon">park</td>
                <td data-label="Definition">X1 is a park at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5<br>Chinese: -guw/uan<br>Latin: vyvari.um<br>Loglan: panki*</td>
            </tr>

            <tr>
                <td data-label="Word">scew</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">city, town</td>
                <td data-label="Phon">syti</td>
                <td data-label="Definition">X1 is a town or city at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5<br>Chinese: /cew!qr<br>Latin: urbs<br>Loglan: sitci</td>
            </tr>

            <tr>
                <td data-label="Word">vyie</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">street, road</td>
                <td data-label="Phon">strit</td>
                <td data-label="Definition">X1 is a street at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vya</td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5<br>Chinese: -jie<br>Latin: vya<br>Loglan: trida</td>
            </tr>

            <tr>
                <td data-label="Word">turu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rural</td>
                <td data-label="Phon">rur#l</td>
                <td data-label="Definition">X1 is a rural area at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5<br>Chinese: -siaw-tsun-de<br>Latin: rustyk.us<br>Loglan: nurma*</td>
            </tr>

            <tr>
                <td data-label="Word">xbur</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">suburb</td>
                <td data-label="Phon">s#brb</td>
                <td data-label="Definition">X1 is a suburb of metropolis X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5<br>Chinese: -jiau!uai<br>Latin: suburbs<br>Loglan: jarbu*</td>
            </tr>

            <tr>
                <td data-label="Word">gnar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">garden</td>
                <td data-label="Phon">gardn</td>
                <td data-label="Definition">X1 is a garden at X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5<br>Chinese: -huai/uan<br>Latin: hort.us<br>Loglan: gardi</td>
            </tr>

            <tr>
                <td data-label="Word">stam</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">platform</td>
                <td data-label="Phon">platform</td>
                <td data-label="Definition">X1 is a platform of structure X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5, 4.2.6<br>Chinese: /tai<br>Latin: sugest.us<br>Loglan: stadi</td>
            </tr>

            <tr>
                <td data-label="Word">qkam</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">camp</td>
                <td data-label="Phon">kamp</td>
                <td data-label="Definition">X1 is a camp of occupant X2* at locality X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5, 4.2.8<br>Chinese: /iw<br>Latin: kastra<br>Loglan: kampo</td>
            </tr>

            <tr>
                <td data-label="Word">bryo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bridge, span</td>
                <td data-label="Phon">brydj</td>
                <td data-label="Definition">X1 is a bridge spanning chasm X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">for</td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5, 4.2.8<br>Chinese: /ciau<br>Latin: pons<br>Loglan: cibra</td>
            </tr>

            <tr>
                <td data-label="Word">jiwe</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">homeland, people, nation</td>
                <td data-label="Phon">naqn</td>
                <td data-label="Definition">X1 is the homeland, nation of people (xu) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tein</td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.5, 4.7.4<br>Chinese: -jia-siaw<br>Latin: gens<br>Loglan: gunti</td>
            </tr>

            <tr>
                <td data-label="Word">356</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Time and Seasons</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">See also Units of Time (4.5.1).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zane</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">morning, evening, noon</td>
                <td data-label="Phon">morn#w</td>
                <td data-label="Definition">X1 is the morning of day X2</td>
                <td data-label="Comments">-gr -zane = evening, -gl -zane = noon.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.6<br>Chinese: |dzau/cen<br>Latin: mane<br>Loglan: monza</td>
            </tr>

            <tr>
                <td data-label="Word">qana</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">nighttime, night</td>
                <td data-label="Phon">nait</td>
                <td data-label="Definition">X1 is the nighttime of day X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.6<br>Chinese: |uan!qaw<br>Latin: noks<br>Loglan: natli</td>
            </tr>

            <tr>
                <td data-label="Word">diai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">daytime, day</td>
                <td data-label="Phon">daitaim</td>
                <td data-label="Definition">X1 is the daytime of day X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.6<br>Chinese: /bai-tian<br>Latin: di.es<br>Loglan: denli</td>
            </tr>

            <tr>
                <td data-label="Word">sprw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">spring</td>
                <td data-label="Phon">spr#w</td>
                <td data-label="Definition">X1 is the spring of year X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.6<br>Chinese: -cu#n!ji<br>Latin: ver<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tumu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">autumn</td>
                <td data-label="Phon">atum</td>
                <td data-label="Definition">X1 is the autumn of year X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.6<br>Chinese: -ciu-tian<br>Latin: autumn.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">taem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">summer</td>
                <td data-label="Phon">s#mr</td>
                <td data-label="Definition">X1 is the summer of year X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.6<br>Chinese: !sia-tian<br>Latin: aestas<br>Loglan: cimra</td>
            </tr>

            <tr>
                <td data-label="Word">tiem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">winter</td>
                <td data-label="Phon">uyntr</td>
                <td data-label="Definition">X1 is the winter of year X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.5.6<br>Chinese: -duw-tian<br>Latin: hiems<br>Loglan: dotra</td>
            </tr>

            <tr>
                <td data-label="Word">360</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Scientific Nomenclature</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">See also the respective object categories.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">361</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Chemistry</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">See also category 3.3, Materials.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">coni</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">radical</td>
                <td data-label="Phon">oni#m</td>
                <td data-label="Definition">(xo) X1 is a serving of a radical of (xo) X2:* and hydrogen</td>
                <td data-label="Comments">E.g. phosphonium or pyridinium: perhydro and positive.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.1<br>Chinese: -<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jywi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">radical</td>
                <td data-label="Phon">ait</td>
                <td data-label="Definition">(xo) X1 is a serving of a radical of (xu) X2: oxygens and (xo) X3:*</td>
                <td data-label="Comments">E.g. nitrate.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.1<br>Chinese: -<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kem</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">chemical</td>
                <td data-label="Phon">kemykal</td>
                <td data-label="Definition">(xo) X1 is a serving of chemical compound composed of (xo) X2:= repeated as needed</td>
                <td data-label="Comments">May be elements or radicals; use clauses for multiplicities.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.1<br>Chinese: !hua|que<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">drio</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hydroxide</td>
                <td data-label="Phon">haidroksaid</td>
                <td data-label="Definition">(xo) X1 is some hydroxide radical</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kyoy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">oxy-acid</td>
                <td data-label="Phon">oksiasyd</td>
                <td data-label="Definition">(xo) X1 is a serving of an oxy-acid with (xu) X2: oxygens and (xo) X3:*</td>
                <td data-label="Comments">E.g. perchloric acid; an example of a non-oxy acid is -kqyw-klor = HCl.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.1<br>Chinese: -<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dyry</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">radical</td>
                <td data-label="Phon">radykl</td>
                <td data-label="Definition">(xo) X1 is a serving of a radical composed of (xo) X2:= repeated as needed</td>
                <td data-label="Comments">E.g. fluoborate.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.1<br>Chinese: -<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">362</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Biology</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">See also category 3.1, Animals and Plants.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zbi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">disease</td>
                <td data-label="Phon">dysiz</td>
                <td data-label="Definition">X1 is a disease in creature X2* caused by parasite X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fti, kme, fpu</td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.2<br>Chinese: /ji!biw<br>Latin: morb.us<br>Loglan: malbi</td>
            </tr>

            <tr>
                <td data-label="Word">gei</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">species</td>
                <td data-label="Phon">spisiz</td>
                <td data-label="Definition">X1 is a member of species X2s*</td>
                <td data-label="Comments">The Latin name normally is put on by metaphor.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.2, 1.1.2<br>Chinese: |juw!lei<br>Latin: gen.us<br>Loglan: jutsi*</td>
            </tr>

            <tr>
                <td data-label="Word">kymu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">community</td>
                <td data-label="Phon">kamunyti</td>
                <td data-label="Definition">X1 is a community of creatures (xy) X2s*</td>
                <td data-label="Comments">May be humans.  When making a compound word, give dominant species.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.6.2, 4.7.1<br>Chinese: !qe!huei<br>Latin: kyvytas<br>Loglan: camcu*</td>
            </tr>

            <tr>
                <td data-label="Word">370</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Mathematics</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">371</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Mathematical Functions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">The X2 argument is an equivalence class, hence has article -xu.  Predicate that something has the result value, or use -xu for the result equivalence class.  See also 0.3.1 and 0.3.2, Digits and Quasidigits.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qnun</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">function, arity</td>
                <td data-label="Phon">funkqn</td>
                <td data-label="Definition">X1 is a mathematical function of arity (xu) X2</td>
                <td data-label="Comments">X2 is the number of arguments.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: |ian!suan<br>Latin: <br>Loglan: fancu*</td>
            </tr>

            <tr>
                <td data-label="Word">cmu</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">multiply, product, times, divide</td>
                <td data-label="Phon">multyplai</td>
                <td data-label="Definition">X1 IEC the product of (xu) X2:= as many as needed</td>
                <td data-label="Comments">Division: -zu-cmu: $X_2 = X_1/X_3$; -zm-cmu: $X_3 = (1/X_2) X_1$</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: /cew<br>Latin: multyplyk.are<br>Loglan: jalti</td>
            </tr>

            <tr>
                <td data-label="Word">cwa</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">mean, average</td>
                <td data-label="Phon">av#raj</td>
                <td data-label="Definition">X1 IEC the mean, average of (xy) X2s:*</td>
                <td data-label="Comments">X2 is a set of expressions.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: /piw/caw<br>Latin: medy.us<br>Loglan: norma</td>
            </tr>

            <tr>
                <td data-label="Word">dum</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">remainder, modulo</td>
                <td data-label="Phon">madulo</td>
                <td data-label="Definition">X1 IEC the remainder of (xu) X2: modulo (xu) X3:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">dya</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: !qew!sia-de<br>Latin: resydu#m<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jril</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">real</td>
                <td data-label="Phon">ril</td>
                <td data-label="Definition">X1 is a real number</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dya</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">quotient, divide</td>
                <td data-label="Phon">dyvaid</td>
                <td data-label="Definition">X1 IEC (xu) X2: divided by (xu) X3:</td>
                <td data-label="Comments">Normally real or rational division; use -dya -fw -dum for integer division.</td>
                <td data-label="Xref">vyn, dum</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -f#n-kai<br>Latin: dyvyd.ere<br>Loglan: brato</td>
            </tr>

            <tr>
                <td data-label="Word">dyr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">base, radix</td>
                <td data-label="Phon">radyks</td>
                <td data-label="Definition">X1 IEC the value of (bu) X3: with radix-1 (xu) X2*</td>
                <td data-label="Comments">X2 is the highest allowed digit because the radix itself is 10 by definition.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -<br>Latin: radyks<br>Loglan: saclu*</td>
            </tr>

            <tr>
                <td data-label="Word">fqnl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rational</td>
                <td data-label="Phon">raq#nl</td>
                <td data-label="Definition">X1 is a rational number</td>
                <td data-label="Comments">Compound with -dya to give numerator and denominator.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -f#n!qu<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vje</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">integer</td>
                <td data-label="Phon">yntejer</td>
                <td data-label="Definition">X1 is an integer number</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: |j#w!qu<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jyne</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">integral</td>
                <td data-label="Phon">yntegral</td>
                <td data-label="Definition">X1 IEC the integral of function (xu) X2-S3 over domain (xy) X3s by its argument (bu) X4@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">cme</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: |q#/uan|j#w<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">piw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">power, exponent, logarithm, base, e</td>
                <td data-label="Phon">paur</td>
                <td data-label="Definition">X1 IEC base (xu) X3? to the power of exponent (xu) X2</td>
                <td data-label="Comments">Logarithm -zu-piw: $x_2 = log_{x_3} x_1$.  -xu-za-piw represents 2.71828, the natural log base, called e.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -piw-fw<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">plw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">plus, add, sum, minus, subtract, moreover</td>
                <td data-label="Phon">pl#s</td>
                <td data-label="Definition">X1 IEC the sum of (xu) X2:= repeated as needed</td>
                <td data-label="Comments">Subtraction: -zu-plw: $X_2 = X_1 - X_3$; -zm-plw: $X_3 = -X_2 + X_1$. Use -zm-plw for discursive plus or moreover.</td>
                <td data-label="Xref">gr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -jia<br>Latin: <br>Loglan: sumji</td>
            </tr>

            <tr>
                <td data-label="Word">qkoi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cosine</td>
                <td data-label="Phon">kosain</td>
                <td data-label="Definition">X1 IEC the cosine of angle (xu) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -<br>Latin: -<br>Loglan: sinso*</td>
            </tr>

            <tr>
                <td data-label="Word">plem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">complex</td>
                <td data-label="Phon">kampleks</td>
                <td data-label="Definition">X1 is a complex number</td>
                <td data-label="Comments">Compound with -sty to give components.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sun</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">number, count, cardinal</td>
                <td data-label="Phon">kaunt</td>
                <td data-label="Definition">(xy) X1s has the same number of members as (xy) X2s:</td>
                <td data-label="Comments">-xu -sun !X2 = the number of members in X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: !ji!suan<br>Latin: numer.are<br>Loglan: konte</td>
            </tr>

            <tr>
                <td data-label="Word">cfyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">infinity, finite, infinitesimal, small</td>
                <td data-label="Phon">ynfynyt</td>
                <td data-label="Definition">(xy) X1s has infinitely many members</td>
                <td data-label="Comments">|pa for aleph index.  -gr-cfyn = infinitesimal, -gl-cfyn = finite.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: /u!sian<br>Latin: ynfyny.tas<br>Loglan: cimni*</td>
            </tr>

            <tr>
                <td data-label="Word">tany</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tangent</td>
                <td data-label="Phon">tanjnt</td>
                <td data-label="Definition">X1 IEC the tangent of curve (xu) X2*</td>
                <td data-label="Comments">For the point of tangency use |jir or preferably give an argument to X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -<br>Latin: <br>Loglan: tango*</td>
            </tr>

            <tr>
                <td data-label="Word">vyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">inverse, divide</td>
                <td data-label="Phon">ynvrs</td>
                <td data-label="Definition">X1 IEC the multiplicative inverse of (xu) X2:*</td>
                <td data-label="Comments">X2 is typically a number but can be a matrix etc.</td>
                <td data-label="Xref">dya, kl</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: /dau|dzuan<br>Latin: ynvers.us<br>Loglan: brato</td>
            </tr>

            <tr>
                <td data-label="Word">bril</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">derivative, rate</td>
                <td data-label="Phon">rait</td>
                <td data-label="Definition">X1 IEC the derivative of function (xu) X2 by its argument (bu) X3@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: |bil!u<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sain</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sine</td>
                <td data-label="Phon">sain</td>
                <td data-label="Definition">X1 IEC the sine of angle (xu) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1<br>Chinese: -<br>Latin: <br>Loglan: sinso*</td>
            </tr>

            <tr>
                <td data-label="Word">vrl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">frame, reference, vertical, coordinate</td>
                <td data-label="Phon">vrtykl</td>
                <td data-label="Definition">X1 is a reference frame in which event (vo) X2+ is interpreted</td>
                <td data-label="Comments">Modal case often used with vertical-horizontal properties.  Includes coordinate systems.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.1, 1.5.2<br>Chinese: /ji!li<br>Latin: rekt.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">372</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Points, Lines and Surfaces</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">biar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">edge</td>
                <td data-label="Phon">edj</td>
                <td data-label="Definition">X1 is an edge of polygon X2*</td>
                <td data-label="Comments">-biar must be 1-D, typically straight, but X2 can have higher dimensions. </td>
                <td data-label="Xref">baia</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: -bian<br>Latin: margo<br>Loglan: bidje</td>
            </tr>

            <tr>
                <td data-label="Word">cme</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">measure, kernel</td>
                <td data-label="Phon">mexr</td>
                <td data-label="Definition">X1 IEC the measure of set (xy) X2s using kernel (vo) X3</td>
                <td data-label="Comments">Typically volume.  A kernel is a function taking an independent variable point in X2 as its second case; it is integrated over X2.</td>
                <td data-label="Xref">jyne</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: /cew!du<br>Latin: mensura<br>Loglan: spasi</td>
            </tr>

            <tr>
                <td data-label="Word">fpal</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">polyhedron</td>
                <td data-label="Phon">palyhidr#n</td>
                <td data-label="Definition">X1 is a polyhedron with face count IEC (xu) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: <br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gln</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">angle</td>
                <td data-label="Phon">angl</td>
                <td data-label="Definition">X1 IEC the angle between line X2 and line X3</td>
                <td data-label="Comments">Also for dihedrals and higher dimensions.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: |qie!du<br>Latin: angul.us<br>Loglan: jaglo</td>
            </tr>

            <tr>
                <td data-label="Word">kuei</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">locus</td>
                <td data-label="Phon">lokus</td>
                <td data-label="Definition">X1 is the locus of function (xu) X2s*</td>
                <td data-label="Comments">X2 is a point set interpreted as a geometric object; typically the range of a 2-D function of a 1-D interval, which is rarely straight.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: |guei-ji<br>Latin: lok.us<br>Loglan: korva</td>
            </tr>

            <tr>
                <td data-label="Word">ksel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">helix</td>
                <td data-label="Phon">helyks</td>
                <td data-label="Definition">X1 is a helix</td>
                <td data-label="Comments">|syo for axis, |zu -syry for radius, |pa for pitch (distance per angle).</td>
                <td data-label="Xref">sluo</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: /luo|quen<br>Latin: helyks<br>Loglan: sarlu*</td>
            </tr>

            <tr>
                <td data-label="Word">psa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">straight, line</td>
                <td data-label="Phon">lain</td>
                <td data-label="Definition">Line X1 is straight</td>
                <td data-label="Comments">Includes straight objects.  Use |sto !(points) for points it passes through.</td>
                <td data-label="Xref">vbn</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2, 1.3.1<br>Chinese: /jr!sian<br>Latin: lynea<br>Loglan: clina</td>
            </tr>

            <tr>
                <td data-label="Word">sluo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">spiral</td>
                <td data-label="Phon">spairl</td>
                <td data-label="Definition">X1 is a spiral</td>
                <td data-label="Comments">|dyn for center, |pa (or expression) for unwinding rate.</td>
                <td data-label="Xref">ksel</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: /luo/suan<br>Latin: <br>Loglan: sarlu*</td>
            </tr>

            <tr>
                <td data-label="Word">qnum</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">number</td>
                <td data-label="Phon">n#mbr</td>
                <td data-label="Definition">X1 is a number</td>
                <td data-label="Comments">An equivalence class of equal-count sets.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: !qu<br>Latin: numer.us<br>Loglan: numcu</td>
            </tr>

            <tr>
                <td data-label="Word">qkur</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">vector, tangent</td>
                <td data-label="Phon">vektr</td>
                <td data-label="Definition">X1 IEC curve X2 at point X3</td>
                <td data-label="Comments">The equivalence is being tangent with same arc derivative; this defines a vector.  X1 can be a list of component expressions.</td>
                <td data-label="Xref">qyr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: -faw!qiaw<br>Latin: kurs.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">poin</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">vertex, point</td>
                <td data-label="Phon">point</td>
                <td data-label="Definition">X1 is a vertex of polygon X2*</td>
                <td data-label="Comments">Also for polyhedra and higher dimensions.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: |jiau<br>Latin: verteks<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">baia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">side</td>
                <td data-label="Phon">said</td>
                <td data-label="Definition">X1 is a side or boundary polygon of polyhedron X2*</td>
                <td data-label="Comments">If X2 has N dimensions, X1 has N-1.  Includes polygonal surfaces of physical objects.  -biar is a 1-D -baia.  Use -bie for ``beside&#x27;&#x27; horizontally.</td>
                <td data-label="Xref">biar</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: -bian<br>Latin: lat.us<br>Loglan: spali</td>
            </tr>

            <tr>
                <td data-label="Word">zgay</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">polygon</td>
                <td data-label="Phon">palygan</td>
                <td data-label="Definition">X1 is a polygon with side count IEC (xu) X2:*</td>
                <td data-label="Comments">|pa for side length(s).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2<br>Chinese: <br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">point</td>
                <td data-label="Phon">point</td>
                <td data-label="Definition">X1 is a point of set (xy) X2s</td>
                <td data-label="Comments">|sya for topology.  Objects with organized geometry (topological spaces) are sets of points, with a topology given.</td>
                <td data-label="Xref">jin, vdr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2, 1.1.2<br>Chinese: |dian<br>Latin: lok.us<br>Loglan: penta</td>
            </tr>

            <tr>
                <td data-label="Word">tmy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">limit</td>
                <td data-label="Phon">lymyt</td>
                <td data-label="Definition">X1 is a limit point of process (xy) X2s*</td>
                <td data-label="Comments">X2 is a set or a process.  Any open set containing X1 has points both inside and outside X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2, 1.1.3, 3.7.4<br>Chinese: !jie!sian<br>Latin: termyn.us<br>Loglan: limji</td>
            </tr>

            <tr>
                <td data-label="Word">gyo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">parallel</td>
                <td data-label="Phon">paralel</td>
                <td data-label="Definition">X1 is parallel to X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.2, 1.4.4<br>Chinese: /piw/siw<br>Latin: e-regyone<br>Loglan: pirle</td>
            </tr>

            <tr>
                <td data-label="Word">373</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Shapes</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">couo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sphere, ball</td>
                <td data-label="Phon">bal</td>
                <td data-label="Definition">X1 is a sphere</td>
                <td data-label="Comments">Sphere is hollow.  -xyn -couo for a solid ball.  |dyn for center, |pa or |zu -syry for the radius.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: /ciou<br>Latin: glob.us<br>Loglan: balma</td>
            </tr>

            <tr>
                <td data-label="Word">fsr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">flat, surface, plane</td>
                <td data-label="Phon">srf#s</td>
                <td data-label="Definition">Surface X1 is flat or plane</td>
                <td data-label="Comments">Use |sto for contained points or lines.</td>
                <td data-label="Xref">xbr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: !mian<br>Latin: superfyky.es<br>Loglan: pilno</td>
            </tr>

            <tr>
                <td data-label="Word">fqiw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cube</td>
                <td data-label="Phon">kiub</td>
                <td data-label="Definition">X1 is a cube</td>
                <td data-label="Comments">|pa for side length.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: !s#-faw-qiw<br>Latin: tesera<br>Loglan: kubli*</td>
            </tr>

            <tr>
                <td data-label="Word">kono</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cone</td>
                <td data-label="Phon">kon</td>
                <td data-label="Definition">X1 is a cone</td>
                <td data-label="Comments">|pa for the opening angle, |dyn for the apex, |syo for axis.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: /uen-dzuei<br>Latin: kon.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">syry</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">circle, round</td>
                <td data-label="Phon">syrkl</td>
                <td data-label="Definition">X1 is a circle of radius (xu) X2*</td>
                <td data-label="Comments">Also for rings.  Use -xyn -syry for discs.  |dyn for center.  |pa also gives radius.  </td>
                <td data-label="Xref">canu</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: -ciuan<br>Latin: orb.ys<br>Loglan: rande</td>
            </tr>

            <tr>
                <td data-label="Word">klyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cylinder, roll, rod, round</td>
                <td data-label="Phon">sylyndr</td>
                <td data-label="Definition">X1 is a circular cylinder</td>
                <td data-label="Comments">-klyl is hollow.  Use -xyn -klyl for a solid.  |pa or |zu -syry for radius, |syo for axis.  |fma X for a noncircular shape.</td>
                <td data-label="Xref">gvyr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: /uan<br>Latin: kylyndr.us<br>Loglan: rolgu</td>
            </tr>

            <tr>
                <td data-label="Word">plue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">loop</td>
                <td data-label="Phon">lup</td>
                <td data-label="Definition">X1 is a loop in X2</td>
                <td data-label="Comments">Between points where X2, a curve or long object, intersects itself.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: -cuen<br>Latin: lakuens<br>Loglan: clupa*</td>
            </tr>

            <tr>
                <td data-label="Word">skur</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">square</td>
                <td data-label="Phon">skuer</td>
                <td data-label="Definition">X1 is a square</td>
                <td data-label="Comments">|pa for the side length.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: !sz-faw<br>Latin: kuadra<br>Loglan: kurfa</td>
            </tr>

            <tr>
                <td data-label="Word">sti</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">symmetry</td>
                <td data-label="Phon">symetri</td>
                <td data-label="Definition">X1 is symmetrical</td>
                <td data-label="Comments">Various restrictions for what kind, axis, etc.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: !duei!ts#n<br>Latin: kongruentia<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">syo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">axis</td>
                <td data-label="Phon">aksys</td>
                <td data-label="Definition">Shape X1 has axis X2</td>
                <td data-label="Comments">Typically an axis of symmetry.  Includes rotation axis of a spherical planet.</td>
                <td data-label="Xref">dyn</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: /dzou<br>Latin: aksys<br>Loglan: -</td>
            </tr>

            <tr>
                <td data-label="Word">tror</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">torus</td>
                <td data-label="Phon">tor#s</td>
                <td data-label="Definition">X1 is a torus of minor radius (xu) X2*</td>
                <td data-label="Comments">|pa or |zu -syry for major radius, |dyn for center, |syo for major axis.</td>
                <td data-label="Xref">syry</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: -<br>Latin: tor.us<br>Loglan: torsu+</td>
            </tr>

            <tr>
                <td data-label="Word">vjou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wrinkle, crease</td>
                <td data-label="Phon">rynkl</td>
                <td data-label="Definition">X1 is a wrinkle in surface X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fol</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3<br>Chinese: !jou<br>Latin: ruga<br>Loglan: cinje*</td>
            </tr>

            <tr>
                <td data-label="Word">fma</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">shape, form</td>
                <td data-label="Phon">qaip</td>
                <td data-label="Definition">X1 is in the same equivalence class on shape as shape X2* is</td>
                <td data-label="Comments">-xu-fma !X for ``the form of X&#x27;&#x27;.</td>
                <td data-label="Xref">zia, jrm</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3, 1.3.6<br>Chinese: !iaw.-dz<br>Latin: forma<br>Loglan: forma</td>
            </tr>

            <tr>
                <td data-label="Word">dyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">center, midpoint</td>
                <td data-label="Phon">sentr</td>
                <td data-label="Definition">X1 is the midpoint of shape X2</td>
                <td data-label="Comments">Center of symmetry (or mass if no symmetry) of shape of any dimension.</td>
                <td data-label="Xref">syry, syo, juw</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3, 1.4.2<br>Chinese: -juw-siyn|dian<br>Latin: medy.us<br>Loglan: midju</td>
            </tr>

            <tr>
                <td data-label="Word">jwuw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bulb, swell</td>
                <td data-label="Phon">suel</td>
                <td data-label="Definition">X1 is a bulb on stem X2</td>
                <td data-label="Comments">A swelling at the end of a stem, as in plants or light bulbs.</td>
                <td data-label="Xref">toum</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.3, 4.2.4, 3.2.6<br>Chinese: |juw<br>Latin: tum.ere<br>Loglan: bulbi</td>
            </tr>

            <tr>
                <td data-label="Word">374</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Relations of Logic and Mathematic</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bya</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">abstract, concrete</td>
                <td data-label="Phon">abstrakt</td>
                <td data-label="Definition">(vo) X1+ is an abstract event of which instances (xe-vo) X2@ are concrete</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">plm</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4<br>Chinese: -cou!syaw<br>Latin: oblyv.yo<br>Loglan: sucta*</td>
            </tr>

            <tr>
                <td data-label="Word">kla</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">logic</td>
                <td data-label="Phon">lajyk</td>
                <td data-label="Definition">X1 is a logic to reason from premise (vo) X2@ to conclusion (vo) X3@</td>
                <td data-label="Comments">A list of deductions from X2 to X3, each entails next, steps small enough for listener to understand.  |sya for axioms.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4<br>Chinese: !lun|li/sue<br>Latin: logyka<br>Loglan: lodji</td>
            </tr>

            <tr>
                <td data-label="Word">vrer</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mathematics, expression</td>
                <td data-label="Phon">ekspreqn</td>
                <td data-label="Definition">(bi) X1 is a mathematical expression</td>
                <td data-label="Comments">An argument (phrase) which can be interpreted as having a numeric value.</td>
                <td data-label="Xref">qtem</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4<br>Chinese: -<br>Latin: verb.um<br>Loglan: cmaci*</td>
            </tr>

            <tr>
                <td data-label="Word">qre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rule, algorithm, procedure, recipe</td>
                <td data-label="Phon">resypi</td>
                <td data-label="Definition">(vo) X1@ is a rule or procedure often useful to achieve result (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">gul, fta, jrm</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4<br>Chinese: /qr|pu<br>Latin: <br>Loglan: rulni</td>
            </tr>

            <tr>
                <td data-label="Word">qtem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mathematics</td>
                <td data-label="Phon">matematyks</td>
                <td data-label="Definition">(vo) X1 is a mathematical statement</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vrer</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4<br>Chinese: !qu/sue<br>Latin: matematyka<br>Loglan: cmaci*</td>
            </tr>

            <tr>
                <td data-label="Word">dve</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">correct, right</td>
                <td data-label="Phon">korekt</td>
                <td data-label="Definition">(vo) X1 is correct</td>
                <td data-label="Comments">|fta for the standard.  Means X1 is done according to prespecified axioms, procedures, etc.</td>
                <td data-label="Xref">tso, stw, qkr, ge, qtr, fpe</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 1.2.2<br>Chinese: !duei<br>Latin: ver.us<br>Loglan: dreti</td>
            </tr>

            <tr>
                <td data-label="Word">sfa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">false</td>
                <td data-label="Phon">fals</td>
                <td data-label="Definition">(vo) X1 is false</td>
                <td data-label="Comments">|fta for the standard or epistomology by which it is judged.</td>
                <td data-label="Xref">qtr, tso</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 1.2.2<br>Chinese: -siu|jia<br>Latin: fals.us<br>Loglan: falji</td>
            </tr>

            <tr>
                <td data-label="Word">qtr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">true</td>
                <td data-label="Phon">tru</td>
                <td data-label="Definition">(vo) X1 is true</td>
                <td data-label="Comments">|fta for the standard or epistomology by which it is judged.</td>
                <td data-label="Xref">sfa, qkr, dve, ge</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 1.2.2<br>Chinese: -jen<br>Latin: ver.us<br>Loglan: tradu</td>
            </tr>

            <tr>
                <td data-label="Word">ska</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">exact</td>
                <td data-label="Phon">eksakt</td>
                <td data-label="Definition">(vo) X1 is exact</td>
                <td data-label="Comments">|fta for the standard.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 1.2.2<br>Chinese: !jew!cue<br>Latin: eksakt.us<br>Loglan: satci*</td>
            </tr>

            <tr>
                <td data-label="Word">kym</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">pattern</td>
                <td data-label="Phon">patrn</td>
                <td data-label="Definition">X1 IEC the pattern in process X2 its property (vo) X3+2</td>
                <td data-label="Comments">A generalizable regularity of how X3 varies from one part of X2 to another.  Includes non-visual patterns.</td>
                <td data-label="Xref">fma, gvr</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 1.3.2, 4.4.5<br>Chinese: /muo!iaw<br>Latin: spekymen<br>Loglan: morna*</td>
            </tr>

            <tr>
                <td data-label="Word">sya</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">basis, axiom</td>
                <td data-label="Phon">basys</td>
                <td data-label="Definition">X1s is a basis of set (xy) X2s*</td>
                <td data-label="Comments">X2 is a vector space, a topology, or a logical structure (X1 contains axioms).</td>
                <td data-label="Xref">daun</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 1.5.2<br>Chinese: -ji|cu<br>Latin: bas.ys<br>Loglan: basni</td>
            </tr>

            <tr>
                <td data-label="Word">poa</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">assume</td>
                <td data-label="Phon">asum</td>
                <td data-label="Definition">Thinker X1 assumes that fact (vo) X2 is true</td>
                <td data-label="Comments">X2 may or may not be true.</td>
                <td data-label="Xref">gu, gy</td>
                <td data-label="Notes">Rank: <br>Thes: 2.3.6, 3.7.4<br>Chinese: |jia!q#<br>Latin: pon.ere<br>Loglan: sruma*</td>
            </tr>

            <tr>
                <td data-label="Word">kom</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">calculate, arithmetic, reckon</td>
                <td data-label="Phon">rekn</td>
                <td data-label="Definition">Actor X1 calculates answer X3 which is IEC value (xu) X2</td>
                <td data-label="Comments">X2, a math expression, is the problem.  Note reverse order of X3 and X2.</td>
                <td data-label="Xref">stm</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 2.4.8<br>Chinese: !ji!suan<br>Latin: komput.are<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qkr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">fact</td>
                <td data-label="Phon">fakt</td>
                <td data-label="Definition">(vo) X1 is a fact</td>
                <td data-label="Comments">A fact is an event (-qin) which most people think is real (-stw).  They could be wrong.</td>
                <td data-label="Xref">stw, ge, qtr, dve</td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 3.4.3<br>Chinese: !qr/qr<br>Latin: res<br>Loglan: fekto</td>
            </tr>

            <tr>
                <td data-label="Word">jia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">satisfy</td>
                <td data-label="Phon">satysfai</td>
                <td data-label="Definition">Expression X1 satisfies statement or equation (vo) X2 when substituted for its argument (bi) X3@</td>
                <td data-label="Comments">Makes the statement true.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 3.7.4, 4.4.6<br>Chinese: |jie/da<br>Latin: plak.ere<br>Loglan: mansa*</td>
            </tr>

            <tr>
                <td data-label="Word">400</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Human Objects and Relations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.0.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">410</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Artifacts</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">411</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Containers</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: contains content X2*</td>
                <td data-label="Comments">There are more containers in Cooking and Eating (4.1.2).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kuan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">can</td>
                <td data-label="Phon">kan</td>
                <td data-label="Definition">X1 is a can containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: !guan<br>Latin: urke.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kara</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">box</td>
                <td data-label="Phon">baks</td>
                <td data-label="Definition">X1 is a box containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: /h#.-dz<br>Latin: arka<br>Loglan: bakso</td>
            </tr>

            <tr>
                <td data-label="Word">scor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">basket</td>
                <td data-label="Phon">basket</td>
                <td data-label="Definition">X1 is a basket containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: |dou<br>Latin: corb.ys<br>Loglan: banse</td>
            </tr>

            <tr>
                <td data-label="Word">kaia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">package</td>
                <td data-label="Phon">pakaij</td>
                <td data-label="Definition">X1 is a package containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: -bau|guo<br>Latin: sarkina<br>Loglan: badlo</td>
            </tr>

            <tr>
                <td data-label="Word">saia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sack</td>
                <td data-label="Phon">sak</td>
                <td data-label="Definition">X1 is a sack containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: !dai<br>Latin: sak.us<br>Loglan: sakli</td>
            </tr>

            <tr>
                <td data-label="Word">tuen</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bucket</td>
                <td data-label="Phon">buket</td>
                <td data-label="Definition">X1 is a bucket containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: /pen.-dz<br>Latin: sytula<br>Loglan: bakto</td>
            </tr>

            <tr>
                <td data-label="Word">vel</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">contain, vessel, full</td>
                <td data-label="Phon">vesl</td>
                <td data-label="Definition">Vessel X1 contains content (xo) X2:*</td>
                <td data-label="Comments">Not necessarily completely full.</td>
                <td data-label="Xref">cul</td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: /ruw!ci<br>Latin: vas<br>Loglan: veslo</td>
            </tr>

            <tr>
                <td data-label="Word">vdra</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">drawer</td>
                <td data-label="Phon">drar</td>
                <td data-label="Definition">X1 is a drawer containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1<br>Chinese: -to!ti<br>Latin: <br>Loglan: drara</td>
            </tr>

            <tr>
                <td data-label="Word">piwl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bottle</td>
                <td data-label="Phon">batl</td>
                <td data-label="Definition">X1 is a bottle containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.1, 4.1.2<br>Chinese: /piw.-dz<br>Latin: lagena<br>Loglan: batpi</td>
            </tr>

            <tr>
                <td data-label="Word">412</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Cooking and Eating</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: contains content X2*</td>
                <td data-label="Comments">See also Containers (4.1.1).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">pana</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pan</td>
                <td data-label="Phon">pan</td>
                <td data-label="Definition">X1 is a pan containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: -guo<br>Latin: patyna<br>Loglan: panba</td>
            </tr>

            <tr>
                <td data-label="Word">guan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pot</td>
                <td data-label="Phon">pat</td>
                <td data-label="Definition">X1 is a pot containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: !guan<br>Latin: ola<br>Loglan: patpe</td>
            </tr>

            <tr>
                <td data-label="Word">pany</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">dish, plate</td>
                <td data-label="Phon">dyq</td>
                <td data-label="Definition">X1 is a plate or dish containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: /pan.-dz<br>Latin: patyna<br>Loglan: plata</td>
            </tr>

            <tr>
                <td data-label="Word">fera</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tray</td>
                <td data-label="Phon">trai</td>
                <td data-label="Definition">X1 is a tray containing or bearing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: /pan<br>Latin: ferkul.um<br>Loglan: trali</td>
            </tr>

            <tr>
                <td data-label="Word">psoy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chopstick</td>
                <td data-label="Phon">copstyk</td>
                <td data-label="Definition">X1 is a chopstick holding (xo) X2:</td>
                <td data-label="Comments">Invariably paired, but |cu will normally be omitted.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: /kuai.-dz<br>Latin: <br>Loglan: cinza*</td>
            </tr>

            <tr>
                <td data-label="Word">qkei</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">kettle</td>
                <td data-label="Phon">ketl</td>
                <td data-label="Definition">X1 is a kettle containing (xo) X2:*</td>
                <td data-label="Comments">A covered pot, usually with a spout.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: |qei/hu<br>Latin: kortyna<br>Loglan: ketli</td>
            </tr>

            <tr>
                <td data-label="Word">qkul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cup</td>
                <td data-label="Phon">k#p</td>
                <td data-label="Definition">X1 is a cup containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: -bei<br>Latin: pokul.um<br>Loglan: kupta</td>
            </tr>

            <tr>
                <td data-label="Word">spun</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">spoon</td>
                <td data-label="Phon">spun</td>
                <td data-label="Definition">X1 is a spoon containing (xo) X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: /cr.-dz<br>Latin: kokle.are<br>Loglan: sputa</td>
            </tr>

            <tr>
                <td data-label="Word">kfor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">fork</td>
                <td data-label="Phon">fork</td>
                <td data-label="Definition">X1 is a fork bearing (xo) X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.2<br>Chinese: -tsa-dz<br>Latin: furka<br>Loglan: forka</td>
            </tr>

            <tr>
                <td data-label="Word">413</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Household Tools</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sara</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">parasol, umbrella</td>
                <td data-label="Phon">parasol</td>
                <td data-label="Definition">X1 is an umbrella or parasol</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.3<br>Chinese: |san<br>Latin: umbela<br>Loglan: sanre</td>
            </tr>

            <tr>
                <td data-label="Word">jeni</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">needle</td>
                <td data-label="Phon">nidl</td>
                <td data-label="Definition">X1 is a needle</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.3<br>Chinese: -jen<br>Latin: ak.us<br>Loglan: nidla</td>
            </tr>

            <tr>
                <td data-label="Word">gven</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">oven</td>
                <td data-label="Phon">#ven</td>
                <td data-label="Definition">X1 is an oven</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.3<br>Chinese: /lu<br>Latin: furn.us<br>Loglan: zavno</td>
            </tr>

            <tr>
                <td data-label="Word">qkom</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">comb</td>
                <td data-label="Phon">kom</td>
                <td data-label="Definition">X1 is a comb</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.3<br>Chinese: -qu.-dz<br>Latin: pekten<br>Loglan: komcu</td>
            </tr>

            <tr>
                <td data-label="Word">zryr</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">scissors</td>
                <td data-label="Phon">syzrs</td>
                <td data-label="Definition">X1 is a scissor</td>
                <td data-label="Comments">Invariably paired, but |cu is normally omitted.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.3<br>Chinese: |jian.-dz<br>Latin: forfyk.es<br>Loglan: cirzo</td>
            </tr>

            <tr>
                <td data-label="Word">quae</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">brush</td>
                <td data-label="Phon">bruq</td>
                <td data-label="Definition">X1 is a brush</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.3<br>Chinese: -qua<br>Latin: skopae<br>Loglan: brocu</td>
            </tr>

            <tr>
                <td data-label="Word">414</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Other Household Artifacts</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kuel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">curtain</td>
                <td data-label="Phon">kurten</td>
                <td data-label="Definition">X1 is a curtain over X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: /lian.-dz<br>Latin: vel.um<br>Loglan: kurti</td>
            </tr>

            <tr>
                <td data-label="Word">kriw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">screen</td>
                <td data-label="Phon">skrin</td>
                <td data-label="Definition">X1 is a screen</td>
                <td data-label="Comments">Like a room divider.  Use -kriw -zu -gai if the screen covers something, -fcuy -tene for window screen, -za -jiwi for movie screen.</td>
                <td data-label="Xref">vdeo, jiwi</td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: /piw-few<br>Latin: umbrakul.um<br>Loglan: codji+</td>
            </tr>

            <tr>
                <td data-label="Word">ftul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sofa</td>
                <td data-label="Phon">sof#</td>
                <td data-label="Definition">X1 is a sofa</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: -qa-fa<br>Latin: lektul.us<br>Loglan: sofna</td>
            </tr>

            <tr>
                <td data-label="Word">jume</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">table</td>
                <td data-label="Phon">taibl</td>
                <td data-label="Definition">X1 is a table</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: -juo.-dz<br>Latin: mensa<br>Loglan: tobme</td>
            </tr>

            <tr>
                <td data-label="Word">puyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pad, cushion</td>
                <td data-label="Phon">pad</td>
                <td data-label="Definition">X1 is a cushion or pad</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: !dian.-dz<br>Latin: pulvyn.us<br>Loglan: padzi</td>
            </tr>

            <tr>
                <td data-label="Word">toma</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mat</td>
                <td data-label="Phon">mat</td>
                <td data-label="Definition">X1 is a mat</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: /si.-dz<br>Latin: storea<br>Loglan: matci*</td>
            </tr>

            <tr>
                <td data-label="Word">scer</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chair</td>
                <td data-label="Phon">cer</td>
                <td data-label="Definition">X1 is a chair</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: |i.-dz<br>Latin: sela<br>Loglan: cersi</td>
            </tr>

            <tr>
                <td data-label="Word">tere</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mattress</td>
                <td data-label="Phon">matres</td>
                <td data-label="Definition">X1 is a mattress</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: !ru.-dz<br>Latin: <br>Loglan: spadi</td>
            </tr>

            <tr>
                <td data-label="Word">klow</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">clock</td>
                <td data-label="Phon">klok</td>
                <td data-label="Definition">X1 is a clock</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.4<br>Chinese: -jow<br>Latin: <br>Loglan: jokla</td>
            </tr>

            <tr>
                <td data-label="Word">415</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Clothes</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is an item of clothing for wearer X2 covering its body part X3-2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">drew</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">dress</td>
                <td data-label="Phon">dres</td>
                <td data-label="Definition">X1 is a dress on X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: -i-fu<br>Latin: vest.ys<br>Loglan: cadre</td>
            </tr>

            <tr>
                <td data-label="Word">fpan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pant, trousers, sleeve</td>
                <td data-label="Phon">pant</td>
                <td data-label="Definition">X1 is a trouser or pant on X2: its X3:-2</td>
                <td data-label="Comments">Tubular garment.  Modern pants are joined in pairs, but |cu is usually omitted.  -fpan=brai for arm sleeve.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: |duan!ku<br>Latin: <br>Loglan: panku</td>
            </tr>

            <tr>
                <td data-label="Word">fpau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">robe, tunic, gown</td>
                <td data-label="Phon">rob</td>
                <td data-label="Definition">X1 is a robe on X2:</td>
                <td data-label="Comments">A long garment open at the bottom.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: /pau<br>Latin: vest.ys<br>Loglan: pastu*</td>
            </tr>

            <tr>
                <td data-label="Word">klem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">boot</td>
                <td data-label="Phon">but</td>
                <td data-label="Definition">X1 is a boot on X2: its X3:-2</td>
                <td data-label="Comments">A thick or durable shoe.</td>
                <td data-label="Xref">psie, qoma</td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: /sie<br>Latin: kalke.us<br>Loglan: butpa</td>
            </tr>

            <tr>
                <td data-label="Word">plal</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lap-lap</td>
                <td data-label="Phon">lap-lap</td>
                <td data-label="Definition">X1 is a lap-lap on X2:</td>
                <td data-label="Comments">Clothing wrapped around the waist, in SE Asia and Pacific islands.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: -<br>Latin: -<br>Loglan: lapla</td>
            </tr>

            <tr>
                <td data-label="Word">psie</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">shoe</td>
                <td data-label="Phon">qu</td>
                <td data-label="Definition">X1 is a shoe on X2: its X3:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">qoma</td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: /sie<br>Latin: kalke.us<br>Loglan: cutci</td>
            </tr>

            <tr>
                <td data-label="Word">gaio</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">coat</td>
                <td data-label="Phon">kot</td>
                <td data-label="Definition">X1 is a coat on X2:</td>
                <td data-label="Comments">A long warm garment</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: !uai-i<br>Latin: toga<br>Loglan: kosta</td>
            </tr>

            <tr>
                <td data-label="Word">qnan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">shirt, blouse</td>
                <td data-label="Phon">qrt</td>
                <td data-label="Definition">X1 is a shirt on X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">csa</td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: !cen-qan<br>Latin: tunyka<br>Loglan: curtu</td>
            </tr>

            <tr>
                <td data-label="Word">cnin</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">skirt</td>
                <td data-label="Phon">skrt</td>
                <td data-label="Definition">X1 is a skirt on X2:</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: /ci#n.-dz<br>Latin: <br>Loglan: skara</td>
            </tr>

            <tr>
                <td data-label="Word">dana</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sock</td>
                <td data-label="Phon">sak</td>
                <td data-label="Definition">X1 is a sock on X2: its X3:-2</td>
                <td data-label="Comments">Use -dana -gnua for hose-pipe, -fey for hit.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: |duan!ua<br>Latin: tybyale<br>Loglan: hozda</td>
            </tr>

            <tr>
                <td data-label="Word">tama</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hat</td>
                <td data-label="Phon">hat</td>
                <td data-label="Definition">X1 is a hat on X2: its X3:-2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: !mau.-dz<br>Latin: petas.us<br>Loglan: kapma</td>
            </tr>

            <tr>
                <td data-label="Word">tfu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">garment, clothing</td>
                <td data-label="Phon">garment</td>
                <td data-label="Definition">X1 is a garment or item of clothing for wearer X2 covering its body part X3-2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: -i-fu<br>Latin: vest.ys<br>Loglan: resfu</td>
            </tr>

            <tr>
                <td data-label="Word">qoma</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">glove</td>
                <td data-label="Phon">gl#v</td>
                <td data-label="Definition">X1 is a glove on X2: its X3:-2</td>
                <td data-label="Comments">Typically on the hands.</td>
                <td data-label="Xref">psie</td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.5<br>Chinese: |qou!tau<br>Latin: manyk.um<br>Loglan: gluva</td>
            </tr>

            <tr>
                <td data-label="Word">416</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Parts of Clothes, and Jewelry</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">psai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pocket</td>
                <td data-label="Phon">paket</td>
                <td data-label="Definition">X1 is a pocket of garment X2* with content X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.6<br>Chinese: !dai<br>Latin: sakul.us<br>Loglan: packe</td>
            </tr>

            <tr>
                <td data-label="Word">buou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">button</td>
                <td data-label="Phon">butn</td>
                <td data-label="Definition">X1 is a button of garment X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.6<br>Chinese: !kou<br>Latin: <br>Loglan: botni</td>
            </tr>

            <tr>
                <td data-label="Word">vjue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">jewel</td>
                <td data-label="Phon">juel</td>
                <td data-label="Definition">X1 is a jewel</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.6<br>Chinese: -ju|bau<br>Latin: gema<br>Loglan: djula</td>
            </tr>

            <tr>
                <td data-label="Word">qnyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">collar</td>
                <td data-label="Phon">kalr</td>
                <td data-label="Definition">X1 is a collar of garment X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.6<br>Chinese: -i|liw<br>Latin: monyle<br>Loglan: kalra</td>
            </tr>

            <tr>
                <td data-label="Word">xbuw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">brooch</td>
                <td data-label="Phon">bruc</td>
                <td data-label="Definition">X1 is a brooch</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.6<br>Chinese: -siuw-jen<br>Latin: fybula<br>Loglan: bruci</td>
            </tr>

            <tr>
                <td data-label="Word">417</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Cloth</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">skan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">canvas</td>
                <td data-label="Phon">kanvas</td>
                <td data-label="Definition">(xo) X1 is some canvas</td>
                <td data-label="Comments">A coarse cotton cloth.</td>
                <td data-label="Xref">kman</td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.7<br>Chinese: -fan!bu<br>Latin: karbas.us<br>Loglan: konva</td>
            </tr>

            <tr>
                <td data-label="Word">ksyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">silk, spiderweb</td>
                <td data-label="Phon">sylk</td>
                <td data-label="Definition">(xo) X1 is some silk from creature X2</td>
                <td data-label="Comments">Includes spider silk.  -xbu -ksyl for silk cloth.</td>
                <td data-label="Xref">jrar</td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.7<br>Chinese: /cou<br>Latin: seryk.us<br>Loglan: colku</td>
            </tr>

            <tr>
                <td data-label="Word">jawu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wool</td>
                <td data-label="Phon">u#l</td>
                <td data-label="Definition">(xo) X1 is some wool</td>
                <td data-label="Comments">-xbu -jawu for wool cloth.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.7<br>Chinese: /iaw/mau<br>Latin: lana<br>Loglan: lunli</td>
            </tr>

            <tr>
                <td data-label="Word">418</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Assembled Bulk Materials</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dair</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wire</td>
                <td data-label="Phon">uair</td>
                <td data-label="Definition">(xo) X1 is some wire</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: !dian!sian<br>Latin: fil.um<br>Loglan: tirca</td>
            </tr>

            <tr>
                <td data-label="Word">ftai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tape</td>
                <td data-label="Phon">taip</td>
                <td data-label="Definition">(xo) X1 is some tape</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: !dai.-dz<br>Latin: taenya<br>Loglan: tapni+</td>
            </tr>

            <tr>
                <td data-label="Word">gnua</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pipe, tube</td>
                <td data-label="Phon">paip</td>
                <td data-label="Definition">(xo) X1 is some tube or pipe</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: -guan<br>Latin: tub.us<br>Loglan: tubli</td>
            </tr>

            <tr>
                <td data-label="Word">pqew</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cord, rope</td>
                <td data-label="Phon">rop</td>
                <td data-label="Definition">(xo) X1 is some cord or rope</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: /qew.-dz<br>Latin: fun.ys<br>Loglan: korce</td>
            </tr>

            <tr>
                <td data-label="Word">pqia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sheet, foil</td>
                <td data-label="Phon">qit</td>
                <td data-label="Definition">(xo) X1 is a sheet of material (xo) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: !pian<br>Latin: lamyna<br>Loglan: boxla*</td>
            </tr>

            <tr>
                <td data-label="Word">qkar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">card</td>
                <td data-label="Phon">kard</td>
                <td data-label="Definition">X1 is a card</td>
                <td data-label="Comments">A rectangular piece of stiff paper, usually small.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: |ka!pian<br>Latin: carta<br>Loglan: karda</td>
            </tr>

            <tr>
                <td data-label="Word">cnan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chain</td>
                <td data-label="Phon">cain</td>
                <td data-label="Definition">(xo) X1 is some chain</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: |suo!lian<br>Latin: katena<br>Loglan: tcena</td>
            </tr>

            <tr>
                <td data-label="Word">tene</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">net</td>
                <td data-label="Phon">net</td>
                <td data-label="Definition">X1 is a net</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8<br>Chinese: |uaw<br>Latin: rete<br>Loglan: netre</td>
            </tr>

            <tr>
                <td data-label="Word">fire</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">thread</td>
                <td data-label="Phon">tred</td>
                <td data-label="Definition">(xo) X1 is some thread</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.1.8, 4.1.7<br>Chinese: !sian<br>Latin: fil.um<br>Loglan: citre</td>
            </tr>

            <tr>
                <td data-label="Word">420</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Tools, Machines and Buildings</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">In many of these words X2 is a system or structure that includes X1.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">421</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Tools and Weapons</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fcai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">match</td>
                <td data-label="Phon">mac</td>
                <td data-label="Definition">X1 is a match or fire starter</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: |huo/cai<br>Latin: <br>Loglan: metca</td>
            </tr>

            <tr>
                <td data-label="Word">cuem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hammer</td>
                <td data-label="Phon">hamr</td>
                <td data-label="Definition">X1 is a hammer</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: /cuei.-dz<br>Latin: male.us<br>Loglan: mroza</td>
            </tr>

            <tr>
                <td data-label="Word">fluy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">whip</td>
                <td data-label="Phon">uyp</td>
                <td data-label="Definition">X1 is a whip</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: -bian.-dz<br>Latin: flagr.um<br>Loglan: bitce</td>
            </tr>

            <tr>
                <td data-label="Word">pene</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pen</td>
                <td data-label="Phon">pen</td>
                <td data-label="Definition">X1 is a pen</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: |bi<br>Latin: kalam.us<br>Loglan: penbi</td>
            </tr>

            <tr>
                <td data-label="Word">cawo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tongs, pincers, pliers</td>
                <td data-label="Phon">taw</td>
                <td data-label="Definition">X1 is a tong or pincer</td>
                <td data-label="Comments">Invariably paired, but |cu is normally omitted.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: /cian.-dz<br>Latin: forkeps<br>Loglan: cinza*</td>
            </tr>

            <tr>
                <td data-label="Word">qlal</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">shovel</td>
                <td data-label="Phon">q#vl</td>
                <td data-label="Definition">X1 is a shovel</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: |can.-dz<br>Latin: pala<br>Loglan: cavle</td>
            </tr>

            <tr>
                <td data-label="Word">fciw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">gun</td>
                <td data-label="Phon">g#n</td>
                <td data-label="Definition">X1 is a gun firing bullets (xi) X2* with fuel (xi) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: -ciaw<br>Latin: -<br>Loglan: pantu*</td>
            </tr>

            <tr>
                <td data-label="Word">sci</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">weapon</td>
                <td data-label="Phon">uep#n</td>
                <td data-label="Definition">X1 is a weapon</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: |u!ci<br>Latin: tel.um<br>Loglan: tarmu</td>
            </tr>

            <tr>
                <td data-label="Word">stil</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pencil</td>
                <td data-label="Phon">pensyl</td>
                <td data-label="Definition">X1 is a pencil</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: -cian|bi<br>Latin: stil.us<br>Loglan: pinsi</td>
            </tr>

            <tr>
                <td data-label="Word">tynl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bell</td>
                <td data-label="Phon">bel</td>
                <td data-label="Definition">X1 is a bell</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">fsn</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: /liw<br>Latin: tyntynabul.um<br>Loglan: bekli</td>
            </tr>

            <tr>
                <td data-label="Word">plar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">plow</td>
                <td data-label="Phon">plau</td>
                <td data-label="Definition">X1 is a plow</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: /li<br>Latin: aratr.um<br>Loglan: plado</td>
            </tr>

            <tr>
                <td data-label="Word">vbom</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bomb</td>
                <td data-label="Phon">bom</td>
                <td data-label="Definition">X1 is a bomb</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: !ja!dan<br>Latin: <br>Loglan: bomba</td>
            </tr>

            <tr>
                <td data-label="Word">xguw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bow, arrow</td>
                <td data-label="Phon">bo</td>
                <td data-label="Definition">X1 is a bow with arrows X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1<br>Chinese: -guw<br>Latin: ark.us<br>Loglan: borku</td>
            </tr>

            <tr>
                <td data-label="Word">fnau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">knife</td>
                <td data-label="Phon">naif</td>
                <td data-label="Definition">X1 is a knife</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.1, 4.1.3<br>Chinese: -dau<br>Latin: kulter<br>Loglan: najda</td>
            </tr>

            <tr>
                <td data-label="Word">422</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Machines and Musical Instruments</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">instrument, musical</td>
                <td data-label="Phon">musykal</td>
                <td data-label="Definition">X1 is a musical instrument</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: !ue!ci<br>Latin: fyd.es<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dvyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">television</td>
                <td data-label="Phon">televyx#n</td>
                <td data-label="Definition">X1 is a television set</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: !dian!qr<br>Latin: <br>Loglan: telvi</td>
            </tr>

            <tr>
                <td data-label="Word">fpin</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">piano</td>
                <td data-label="Phon">piano</td>
                <td data-label="Definition">X1 is a piano</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: -gaw/cin<br>Latin: <br>Loglan: plano</td>
            </tr>

            <tr>
                <td data-label="Word">tuwy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pump</td>
                <td data-label="Phon">p#mp</td>
                <td data-label="Definition">X1 is a pump for substance (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: -ji|tuw<br>Latin: antlya<br>Loglan: dampa</td>
            </tr>

            <tr>
                <td data-label="Word">gyar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">guitar, violin</td>
                <td data-label="Phon">gytar</td>
                <td data-label="Definition">X1 is a stringed musical instrument</td>
                <td data-label="Comments">Use -gyar -fw -xguw for violin.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: |guan/quen!ue<br>Latin: kitara<br>Loglan: jgita*</td>
            </tr>

            <tr>
                <td data-label="Word">ciwu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">oboe, clarinet, reed</td>
                <td data-label="Phon">rid</td>
                <td data-label="Definition">X1 is a reed musical instrument</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: /huaw!ue!ci<br>Latin: kalam.us<br>Loglan: xagri*</td>
            </tr>

            <tr>
                <td data-label="Word">qkia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">key</td>
                <td data-label="Phon">ki</td>
                <td data-label="Definition">X1 is a key to lock X2</td>
                <td data-label="Comments">Not for switches, piano keys, etc., but X2 may be a key-operated switch.</td>
                <td data-label="Xref">klau, bzo</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: !iau-qr<br>Latin: klav.ys<br>Loglan: tocki</td>
            </tr>

            <tr>
                <td data-label="Word">kmum</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">computer</td>
                <td data-label="Phon">kumpiutr</td>
                <td data-label="Definition">X1 is a computer</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: !dian|nau<br>Latin: komput.are<br>Loglan: skani*</td>
            </tr>

            <tr>
                <td data-label="Word">dmim</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">drum</td>
                <td data-label="Phon">dr#m</td>
                <td data-label="Definition">X1 is a drum</td>
                <td data-label="Comments">Any percussion musical instrument</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: |gu<br>Latin: timpan.um<br>Loglan: damri*</td>
            </tr>

            <tr>
                <td data-label="Word">klau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lock</td>
                <td data-label="Phon">lak</td>
                <td data-label="Definition">X1 is a lock on door X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">qkia</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: !i|ba!suo<br>Latin: klaustra<br>Loglan: sluko</td>
            </tr>

            <tr>
                <td data-label="Word">teon</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">telephone</td>
                <td data-label="Phon">telefon</td>
                <td data-label="Definition">X1 is a telephone in system X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: !dian!hua<br>Latin: <br>Loglan: telfo</td>
            </tr>

            <tr>
                <td data-label="Word">tywy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">flute, pipe, whistle</td>
                <td data-label="Phon">flut</td>
                <td data-label="Definition">X1 is a flute</td>
                <td data-label="Comments">Musical instrument, sound from Coanda effect.  Includes fixed-wedge whistles.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: /di.-dz<br>Latin: tybya<br>Loglan: flani*</td>
            </tr>

            <tr>
                <td data-label="Word">jiam</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">camera</td>
                <td data-label="Phon">kamera</td>
                <td data-label="Definition">X1 is a camera</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: !jau!siaw-jy<br>Latin: <br>Loglan: kamra</td>
            </tr>

            <tr>
                <td data-label="Word">qoio</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">radio</td>
                <td data-label="Phon">raidio</td>
                <td data-label="Definition">X1 is a radio for type of signal X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: -qou-in-ji<br>Latin: <br>Loglan: radlo</td>
            </tr>

            <tr>
                <td data-label="Word">xbam</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">trumpet, horn, brass</td>
                <td data-label="Phon">tr#mpet</td>
                <td data-label="Definition">X1 is a brass-type musical instrument</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.2<br>Chinese: |la-ba<br>Latin: tuba<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">423</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Transportation Devices and Parts</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sail</td>
                <td data-label="Phon">sail</td>
                <td data-label="Definition">X1 is a sail of boat X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: -fan<br>Latin: vel.um<br>Loglan: salfa</td>
            </tr>

            <tr>
                <td data-label="Word">fkar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">car, truck</td>
                <td data-label="Phon">kar</td>
                <td data-label="Definition">X1 is a car or truck for carrying cargo (xi) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">stre</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: !ci-c#<br>Latin: kar.us<br>Loglan: tcaro</td>
            </tr>

            <tr>
                <td data-label="Word">cwuo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">train</td>
                <td data-label="Phon">train</td>
                <td data-label="Definition">X1 is a train for carrying cargo (xi) X2* of system X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: |huo-c#<br>Latin: <br>Loglan: trena</td>
            </tr>

            <tr>
                <td data-label="Word">gvy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">vehicle</td>
                <td data-label="Phon">vihykl</td>
                <td data-label="Definition">X1 is a vehicle for travel on kind of surface (xr) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: -c#<br>Latin: vehykul.um<br>Loglan: marce*</td>
            </tr>

            <tr>
                <td data-label="Word">qcue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ski</td>
                <td data-label="Phon">ski</td>
                <td data-label="Definition">X1 is a ski</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: /hua|que-cau<br>Latin: <br>Loglan: skizo</td>
            </tr>

            <tr>
                <td data-label="Word">stre</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cart, trailer</td>
                <td data-label="Phon">kart</td>
                <td data-label="Definition">X1 is a cart for carrying cargo (xi) X2*</td>
                <td data-label="Comments">Moved by a person, animal or separate tractor.  Includes trailers or caravans.</td>
                <td data-label="Xref">fkar</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: -ce<br>Latin: plaustr.um<br>Loglan: karti</td>
            </tr>

            <tr>
                <td data-label="Word">cana</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">boat</td>
                <td data-label="Phon">bot</td>
                <td data-label="Definition">X1 is a boat to carry cargo (xi) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: /cuan<br>Latin: nav.ys<br>Loglan: botsu</td>
            </tr>

            <tr>
                <td data-label="Word">vjia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rocket</td>
                <td data-label="Phon">raket</td>
                <td data-label="Definition">X1 is a rocket for carrying cargo (xi) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: |huo!jian<br>Latin: <br>Loglan: jakne*</td>
            </tr>

            <tr>
                <td data-label="Word">vbra</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">brake</td>
                <td data-label="Phon">brak</td>
                <td data-label="Definition">X1 is a brake of vehicle X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: /ja<br>Latin: <br>Loglan: breko</td>
            </tr>

            <tr>
                <td data-label="Word">glui</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wheel</td>
                <td data-label="Phon">uil</td>
                <td data-label="Definition">X1 is a wheel of vehicle X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3<br>Chinese: -c#/lu#n<br>Latin: rota<br>Loglan: krilu</td>
            </tr>

            <tr>
                <td data-label="Word">fyni</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">fin, oar</td>
                <td data-label="Phon">fyn</td>
                <td data-label="Definition">X1 is an oar of boat X2*</td>
                <td data-label="Comments">Also fins of fishes.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.3, 3.2.6<br>Chinese: /u/qi<br>Latin: pina<br>Loglan: rotca</td>
            </tr>

            <tr>
                <td data-label="Word">424</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Static Parts of Devices</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">beol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bolt, screw</td>
                <td data-label="Phon">bolt</td>
                <td data-label="Definition">X1 is a screw or bolt</td>
                <td data-label="Comments">Use -beol |fmy for a nut.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: /luo-sz-dau<br>Latin: obeks<br>Loglan: skori</td>
            </tr>

            <tr>
                <td data-label="Word">jino</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">knot</td>
                <td data-label="Phon">nat</td>
                <td data-label="Definition">X1 is a knot in cords (xy) X2s*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: /jie<br>Latin: nod.us<br>Loglan: nanda</td>
            </tr>

            <tr>
                <td data-label="Word">canu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">around, ring</td>
                <td data-label="Phon">ryw</td>
                <td data-label="Definition">Ring X1 goes around mandrel X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">syry, jui</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: -cuan<br>Latin: anul.us<br>Loglan: djale</td>
            </tr>

            <tr>
                <td data-label="Word">fen</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">fasten, connect, attach</td>
                <td data-label="Phon">fasten</td>
                <td data-label="Definition">X1 attaches part X2 to part X3</td>
                <td data-label="Comments">A part holding X2 on, not a person putting X2 on.</td>
                <td data-label="Xref">tye, cun</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: /lien-jie<br>Latin: adfyg.ere<br>Loglan: lasna*</td>
            </tr>

            <tr>
                <td data-label="Word">fpyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pin</td>
                <td data-label="Phon">pyn</td>
                <td data-label="Definition">X1 is a pin</td>
                <td data-label="Comments">A small fastener, usually sharp.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: -jen<br>Latin: ak.us<br>Loglan: pinda</td>
            </tr>

            <tr>
                <td data-label="Word">trar</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">layer, stratum</td>
                <td data-label="Phon">lair</td>
                <td data-label="Definition">X1 is a layer of structure X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: /ts#n<br>Latin: strat.um<br>Loglan: senta*</td>
            </tr>

            <tr>
                <td data-label="Word">blam</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">blade</td>
                <td data-label="Phon">blaid</td>
                <td data-label="Definition">X1 is a blade of tool X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: -dao-fow<br>Latin: lamyna<br>Loglan: blada</td>
            </tr>

            <tr>
                <td data-label="Word">kliw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">nail</td>
                <td data-label="Phon">nail</td>
                <td data-label="Definition">X1 is a nail</td>
                <td data-label="Comments">An inter-fibrous friction fastener.  Use -junu for claw.</td>
                <td data-label="Xref">junu</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: -diw<br>Latin: klav.ys<br>Loglan: naldi</td>
            </tr>

            <tr>
                <td data-label="Word">xgou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hook</td>
                <td data-label="Phon">h#k</td>
                <td data-label="Definition">X1 is a hook</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.4<br>Chinese: -gou<br>Latin: ham.us<br>Loglan: gokru</td>
            </tr>

            <tr>
                <td data-label="Word">425</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Active Parts of Devices</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ftow</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lens</td>
                <td data-label="Phon">lenz</td>
                <td data-label="Definition">X1 is a lens of apparatus X2*</td>
                <td data-label="Comments">|xgl |pa for the focal length, |pa by itself for the f-number (ratio of focal length to aperture).</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.5<br>Chinese: !tou!jiw<br>Latin: -<br>Loglan: lenzo</td>
            </tr>

            <tr>
                <td data-label="Word">gvew</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">lever</td>
                <td data-label="Phon">levr</td>
                <td data-label="Definition">X1 is a lever of apparatus X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.5<br>Chinese: !gaw|gan<br>Latin: vekt.ys<br>Loglan: levka</td>
            </tr>

            <tr>
                <td data-label="Word">spwy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">spring</td>
                <td data-label="Phon">spryw</td>
                <td data-label="Definition">X1 is a spring</td>
                <td data-label="Comments">Elastic device.</td>
                <td data-label="Xref">tsi</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.5<br>Chinese: -fa/tiau<br>Latin: fons<br>Loglan: sporu</td>
            </tr>

            <tr>
                <td data-label="Word">jiwi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">projector, screen</td>
                <td data-label="Phon">projektr</td>
                <td data-label="Definition">X1 is a projector that puts picture X2 on screen X3</td>
                <td data-label="Comments">Normally cinema but includes projection TV.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.5<br>Chinese: !faw|iw-ji<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vdeo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">monitor, crt, screen, video</td>
                <td data-label="Phon">vydeo</td>
                <td data-label="Definition">X1 is a video monitor of system X2</td>
                <td data-label="Comments">Includes television screen.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.5<br>Chinese: -<br>Latin: <br>Loglan: vidni*</td>
            </tr>

            <tr>
                <td data-label="Word">duwi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">engine, motor</td>
                <td data-label="Phon">enjn</td>
                <td data-label="Definition">X1 is a motor or engine of apparatus X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.5<br>Chinese: -fa!duw-ji<br>Latin: macina<br>Loglan: motci</td>
            </tr>

            <tr>
                <td data-label="Word">426</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Building Materials and Parts</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">paim</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">frame</td>
                <td data-label="Phon">fraim</td>
                <td data-label="Definition">X1 is a frame or load-bearing part of structure X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: |gu/ge<br>Latin: kompag.es<br>Loglan: frama</td>
            </tr>

            <tr>
                <td data-label="Word">daun</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">support, foundation</td>
                <td data-label="Phon">faundaqn</td>
                <td data-label="Definition">Foundation X1 supports structure X2*</td>
                <td data-label="Comments">Includes slabs.  X2 is a house, a machine, etc.</td>
                <td data-label="Xref">sya, baim</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: -ji|cu<br>Latin: fundamenta<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gvyr</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rod</td>
                <td data-label="Phon">rad</td>
                <td data-label="Definition">X1 is a rod in structure X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">klyl</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: !gun<br>Latin: vyrga<br>Loglan: kanra</td>
            </tr>

            <tr>
                <td data-label="Word">klum</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">column</td>
                <td data-label="Phon">kalum</td>
                <td data-label="Definition">X1 is a column in structure X2*</td>
                <td data-label="Comments">Vertical loadbearing part.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: !dzu.-dz<br>Latin: kolumna<br>Loglan: kamju*</td>
            </tr>

            <tr>
                <td data-label="Word">kuaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">stick</td>
                <td data-label="Phon">styk</td>
                <td data-label="Definition">X1 is a stick of material X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: !jaw<br>Latin: bakul.um<br>Loglan: stuka</td>
            </tr>

            <tr>
                <td data-label="Word">baim</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">support, pedestal, base, stand</td>
                <td data-label="Phon">bais</td>
                <td data-label="Definition">Pedestal X1 supports object X2*</td>
                <td data-label="Comments">Includes a skinny or folding stand.</td>
                <td data-label="Xref">daun</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: !jia<br>Latin: bas.ys<br>Loglan: zbepi*</td>
            </tr>

            <tr>
                <td data-label="Word">baul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">board</td>
                <td data-label="Phon">bord</td>
                <td data-label="Definition">X1 is a board of material (xo) X2*</td>
                <td data-label="Comments">Typically wood.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: |ban<br>Latin: tabula<br>Loglan: barta</td>
            </tr>

            <tr>
                <td data-label="Word">xgai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">rail</td>
                <td data-label="Phon">rail</td>
                <td data-label="Definition">X1 is a rail in structure X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: /lan-gan<br>Latin: tign.um<br>Loglan: trelu</td>
            </tr>

            <tr>
                <td data-label="Word">xgua</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tile</td>
                <td data-label="Phon">tail</td>
                <td data-label="Definition">X1 is a tile of material (xo) X2*</td>
                <td data-label="Comments">Piece is thin and many fit together to cover a surface.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6<br>Chinese: -juan<br>Latin: tegula<br>Loglan: tapla*</td>
            </tr>

            <tr>
                <td data-label="Word">bryr</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">brick</td>
                <td data-label="Phon">bryk</td>
                <td data-label="Definition">X1 is a brick of material (xo) X2*</td>
                <td data-label="Comments">Typically fired clay.</td>
                <td data-label="Xref">kuai</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.6, 3.3.4<br>Chinese: -juan<br>Latin: later<br>Loglan: briku</td>
            </tr>

            <tr>
                <td data-label="Word">427</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Parts of Houses</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">koaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">room</td>
                <td data-label="Phon">rum</td>
                <td data-label="Definition">X1 is a room in house X2* for activity (vo) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: /faw<br>Latin: konklave<br>Loglan: kruma</td>
            </tr>

            <tr>
                <td data-label="Word">fcuy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">window</td>
                <td data-label="Phon">uyndo</td>
                <td data-label="Definition">X1 is a window in structure X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: -cuaw<br>Latin: fenestra<br>Loglan: cundo</td>
            </tr>

            <tr>
                <td data-label="Word">diwu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">roof</td>
                <td data-label="Phon">ruf</td>
                <td data-label="Definition">X1 is a roof in house X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: -u|diw<br>Latin: tekt.um<br>Loglan: trufa</td>
            </tr>

            <tr>
                <td data-label="Word">psae</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wall, fence</td>
                <td data-label="Phon">fens</td>
                <td data-label="Definition">X1 is a fence or wall around territory X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pawa</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: /lan-gan<br>Latin: saep.es<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">flol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">floor</td>
                <td data-label="Phon">flor</td>
                <td data-label="Definition">X1 is a floor in structure X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: !di|ban<br>Latin: sol.um<br>Loglan: fordi</td>
            </tr>

            <tr>
                <td data-label="Word">pawa</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wall</td>
                <td data-label="Phon">ual</td>
                <td data-label="Definition">X1 is a wall in house X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">psae</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: /ciaw<br>Latin: pary.es<br>Loglan: tcali</td>
            </tr>

            <tr>
                <td data-label="Word">quel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">shelf</td>
                <td data-label="Phon">qelf</td>
                <td data-label="Definition">X1 is a shelf in structure X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: -qu!jia<br>Latin: plute.us<br>Loglan: celna</td>
            </tr>

            <tr>
                <td data-label="Word">sker</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">stair, staircase</td>
                <td data-label="Phon">ster</td>
                <td data-label="Definition">X1 is a staircase in house X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: /ji<br>Latin: skalae<br>Loglan: stire</td>
            </tr>

            <tr>
                <td data-label="Word">stio</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">door</td>
                <td data-label="Phon">dor</td>
                <td data-label="Definition">X1 is a door in structure X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: /men<br>Latin: osti.um<br>Loglan: darto</td>
            </tr>

            <tr>
                <td data-label="Word">bnia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">balcony</td>
                <td data-label="Phon">balkoni</td>
                <td data-label="Definition">X1 is a balcony of house X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.7<br>Chinese: /iaw/tai<br>Latin: <br>Loglan: balko</td>
            </tr>

            <tr>
                <td data-label="Word">428</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Houses and Other Buildings</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1 is a residence of resident X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.8<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dowu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">house, resident, reside</td>
                <td data-label="Phon">haus</td>
                <td data-label="Definition">X1 is a house of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 15<br>Thes: 4.2.8<br>Chinese: /faw-u<br>Latin: dom.us<br>Loglan: hasfa</td>
            </tr>

            <tr>
                <td data-label="Word">ksaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cabin</td>
                <td data-label="Phon">kabyn</td>
                <td data-label="Definition">X1 is a cabin of X2:* on conveyance X3</td>
                <td data-label="Comments">E.g. on a ship.  For a small house use -dowu |spl.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.8<br>Chinese: /faw-tsaw<br>Latin: kasa<br>Loglan: kabna</td>
            </tr>

            <tr>
                <td data-label="Word">stuo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">nest</td>
                <td data-label="Phon">nest</td>
                <td data-label="Definition">X1 is a nest of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.8<br>Chinese: -uo<br>Latin: nid.us<br>Loglan: nensu</td>
            </tr>

            <tr>
                <td data-label="Word">vdyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">building</td>
                <td data-label="Phon">byldw</td>
                <td data-label="Definition">X1 is a building with content X2*</td>
                <td data-label="Comments">X2 could be houses, shops, a school.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.8<br>Chinese: !da/lou<br>Latin: edyfik.ium<br>Loglan: hasfa</td>
            </tr>

            <tr>
                <td data-label="Word">pwen</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tent</td>
                <td data-label="Phon">tent</td>
                <td data-label="Definition">X1 is a tent of X2:*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.8<br>Chinese: !jaw/p#w<br>Latin: tabernakul.um<br>Loglan: tenta</td>
            </tr>

            <tr>
                <td data-label="Word">zbew</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bed</td>
                <td data-label="Phon">bed</td>
                <td data-label="Definition">X1 is a bed of sleeper X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.8<br>Chinese: /cuaw<br>Latin: lekt.us<br>Loglan: bedpu</td>
            </tr>

            <tr>
                <td data-label="Word">429</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">General and Abstract Artifacts</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.9<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cin</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">machine</td>
                <td data-label="Phon">maqin</td>
                <td data-label="Definition">X1 is a machine with function (vo) X2+1</td>
                <td data-label="Comments">-cin is a unitary thing while -fwa is a system.</td>
                <td data-label="Xref">fwa, tsy</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.9<br>Chinese: -ji!ci<br>Latin: macina<br>Loglan: matci</td>
            </tr>

            <tr>
                <td data-label="Word">fwa</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">device, apparatus</td>
                <td data-label="Phon">divais</td>
                <td data-label="Definition">X1 is a device or apparatus for function (vo) X2+1</td>
                <td data-label="Comments">-fwa is a system as compared to -cin which is more of a unit.</td>
                <td data-label="Xref">cin, tsy</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.9<br>Chinese: -faw|fa<br>Latin: aparat.us<br>Loglan: patce</td>
            </tr>

            <tr>
                <td data-label="Word">gom</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">structure</td>
                <td data-label="Phon">str#kcr</td>
                <td data-label="Definition">X1 is a structure for purpose (vo) X2+1</td>
                <td data-label="Comments">A space-filling system of parts in which motion is not the major goal; generally support is the purpose.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.9<br>Chinese: !gou!dzau<br>Latin: kompag.es<br>Loglan: truke</td>
            </tr>

            <tr>
                <td data-label="Word">kma</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">equipment, furniture</td>
                <td data-label="Phon">ikuypmnt</td>
                <td data-label="Definition">X1 is an item of equipment for purpose (vo) X2+</td>
                <td data-label="Comments">Use -kma -koaw for room furniture.</td>
                <td data-label="Xref">tum</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.9<br>Chinese: -gow!ju<br>Latin: arma<br>Loglan: nilce*</td>
            </tr>

            <tr>
                <td data-label="Word">tum</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">tool, instrument</td>
                <td data-label="Phon">tul</td>
                <td data-label="Definition">X1 is a tool for activity (vo) X2+1</td>
                <td data-label="Comments">Modal case for a tool specifically; use |ziu when the sense is a means to an end.</td>
                <td data-label="Xref">ziu</td>
                <td data-label="Notes">Rank: <br>Thes: 4.2.9, 1.5.2<br>Chinese: -guw!jiu<br>Latin: ynstrument.um<br>Loglan: trime</td>
            </tr>

            <tr>
                <td data-label="Word">430</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Food</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">You rarely devour the whole creature.  Name the edible part and put the species predicate in its X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">431</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Protein and Milk Products</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">buiu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">butter</td>
                <td data-label="Phon">butr</td>
                <td data-label="Definition">(xo) X1 is some butter</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.1<br>Chinese: /niu/iou<br>Latin: <br>Loglan: batra</td>
            </tr>

            <tr>
                <td data-label="Word">kimi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cream</td>
                <td data-label="Phon">krim</td>
                <td data-label="Definition">(xo) X1 is some cream</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.1<br>Chinese: |nai/iou<br>Latin: <br>Loglan: krima</td>
            </tr>

            <tr>
                <td data-label="Word">kseo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cheese</td>
                <td data-label="Phon">ciz</td>
                <td data-label="Definition">(xo) X1 is some cheese</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.1<br>Chinese: |lu!lo<br>Latin: kase.us<br>Loglan: nikri</td>
            </tr>

            <tr>
                <td data-label="Word">qkmy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">milk</td>
                <td data-label="Phon">mylk</td>
                <td data-label="Definition">(xo) X1 is some milk of animal X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.1<br>Chinese: |nai<br>Latin: lak<br>Loglan: malna</td>
            </tr>

            <tr>
                <td data-label="Word">stai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">steak</td>
                <td data-label="Phon">staik</td>
                <td data-label="Definition">X1 is a steak from kind of animal (xo) X2*</td>
                <td data-label="Comments">A piece of meat making a single serving.</td>
                <td data-label="Xref">koro</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.1<br>Chinese: /niou/pai<br>Latin: <br>Loglan: bifte</td>
            </tr>

            <tr>
                <td data-label="Word">koro</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">meat</td>
                <td data-label="Phon">mit</td>
                <td data-label="Definition">(xo) X1 is some meat of animal X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">stai</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.1<br>Chinese: !rou<br>Latin: karo<br>Loglan: mitro</td>
            </tr>

            <tr>
                <td data-label="Word">432</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Fruits and Sweets</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">drma</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">marmelade</td>
                <td data-label="Phon">marmelad</td>
                <td data-label="Definition">(xo) X1 is some marmelade</td>
                <td data-label="Comments">Orange peel jelly.</td>
                <td data-label="Xref">vjiw</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: /ju-dz!jiaw<br>Latin: <br>Loglan: marme</td>
            </tr>

            <tr>
                <td data-label="Word">fcol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">chocolate</td>
                <td data-label="Phon">cokolat</td>
                <td data-label="Definition">(xo) X1 is some chocolate</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: -<br>Latin: -<br>Loglan: tcoko</td>
            </tr>

            <tr>
                <td data-label="Word">gmel</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">melon</td>
                <td data-label="Phon">mel#n</td>
                <td data-label="Definition">X1 is a melon</td>
                <td data-label="Comments">A big, juicy fruit with many seeds.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: -gua<br>Latin: <br>Loglan: melno</td>
            </tr>

            <tr>
                <td data-label="Word">kowo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cocoa</td>
                <td data-label="Phon">koko</td>
                <td data-label="Definition">(xo) X1 is some cocoa</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: -<br>Latin: -<br>Loglan: kalko</td>
            </tr>

            <tr>
                <td data-label="Word">psow</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">soda, carbonated, coke</td>
                <td data-label="Phon">sod#</td>
                <td data-label="Definition">(xo) X1 is some soda of main flavor (xr) X2</td>
                <td data-label="Comments">A beverage.  Not for Na_2CO_3.  ``Coke&#x27;&#x27; is a trademark of the Coca-Cola Bottling Company, sometimes misused generically.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: -su/da<br>Latin: <br>Loglan: sodva</td>
            </tr>

            <tr>
                <td data-label="Word">biaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">berry</td>
                <td data-label="Phon">beri</td>
                <td data-label="Definition">X1 is a berry of plant X2*</td>
                <td data-label="Comments">A small, round fruit.</td>
                <td data-label="Xref">ftu</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: !jiaw|guo<br>Latin: baka<br>Loglan: jbari*</td>
            </tr>

            <tr>
                <td data-label="Word">qtaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sugar</td>
                <td data-label="Phon">q#gr</td>
                <td data-label="Definition">(xo) X1 is some sugar</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: /taw<br>Latin: <br>Loglan: sakta</td>
            </tr>

            <tr>
                <td data-label="Word">vjiw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">jelly</td>
                <td data-label="Phon">jeli</td>
                <td data-label="Definition">(xo) X1 is some jelly from fruit (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.2<br>Chinese: |guo!jiaw<br>Latin: <br>Loglan: dzeli</td>
            </tr>

            <tr>
                <td data-label="Word">433</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Starch and Grains</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dlnu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">noodle</td>
                <td data-label="Phon">nudl</td>
                <td data-label="Definition">X1 is a noodle of grain (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.3<br>Chinese: !mian<br>Latin: <br>Loglan: nudlo+</td>
            </tr>

            <tr>
                <td data-label="Word">qkao</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cake</td>
                <td data-label="Phon">kak</td>
                <td data-label="Definition">X1 is a cake with special ingredient (xo) X2*</td>
                <td data-label="Comments">E.g. carrot cake, banana cake.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.3<br>Chinese: -gao<br>Latin: plakenta<br>Loglan: grato</td>
            </tr>

            <tr>
                <td data-label="Word">vda</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">starch</td>
                <td data-label="Phon">starc</td>
                <td data-label="Definition">X1 is some starch</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.3<br>Chinese: !dian|f#n<br>Latin: <br>Loglan: jalna*</td>
            </tr>

            <tr>
                <td data-label="Word">bene</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bread</td>
                <td data-label="Phon">bred</td>
                <td data-label="Definition">(xo) X1 is some bread made of grain (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.3<br>Chinese: !mien|bau<br>Latin: pan.ys<br>Loglan: breba</td>
            </tr>

            <tr>
                <td data-label="Word">xgu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">grain</td>
                <td data-label="Phon">grain</td>
                <td data-label="Definition">X1 is a grain of plant X2*</td>
                <td data-label="Comments">Edible seed of grass.  Not for small bits.</td>
                <td data-label="Xref">smem</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.3<br>Chinese: |u|gu<br>Latin: frument.um<br>Loglan: grunu</td>
            </tr>

            <tr>
                <td data-label="Word">434</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Recreational Drugs</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gvin</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">wine</td>
                <td data-label="Phon">uain</td>
                <td data-label="Definition">(xo) X1 is some wine from fruit (xo) X2*</td>
                <td data-label="Comments">X2 typically grapes.</td>
                <td data-label="Xref">kuor</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.4<br>Chinese: |jiou<br>Latin: vin.um<br>Loglan: vinjo</td>
            </tr>

            <tr>
                <td data-label="Word">fpir</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">beer</td>
                <td data-label="Phon">bir</td>
                <td data-label="Definition">(xo) X1 is some beer from grain (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kuor</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.4<br>Chinese: /pi|jo<br>Latin: <br>Loglan: birju</td>
            </tr>

            <tr>
                <td data-label="Word">jiue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cigar</td>
                <td data-label="Phon">sygar</td>
                <td data-label="Definition">X1 is a cigar of species of leaf (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.4<br>Chinese: -si|ue-jia-ian<br>Latin: <br>Loglan: sagro</td>
            </tr>

            <tr>
                <td data-label="Word">kuor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">liquor</td>
                <td data-label="Phon">lykuor</td>
                <td data-label="Definition">(xo) X1 is some liquor with special ingredient (xo) X2*</td>
                <td data-label="Comments">Distilled, alcoholic.</td>
                <td data-label="Xref">gvin, fpir</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.4<br>Chinese: |jio<br>Latin: <br>Loglan: likro</td>
            </tr>

            <tr>
                <td data-label="Word">psye</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cigarette</td>
                <td data-label="Phon">sygaret</td>
                <td data-label="Definition">X1 is a cigarette of kind of leaf (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.4<br>Chinese: -siaw-ian<br>Latin: <br>Loglan: sigre</td>
            </tr>

            <tr>
                <td data-label="Word">435</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Vegetables and Other Foods</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fki</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">meal</td>
                <td data-label="Phon">mil</td>
                <td data-label="Definition">X1 is a meal of foods (xy) X2s*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: -tsan<br>Latin: kib.us<br>Loglan: milfa</td>
            </tr>

            <tr>
                <td data-label="Word">kqu</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">food</td>
                <td data-label="Phon">fud</td>
                <td data-label="Definition">(xo) X1 is some food for eater X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">crw</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: /qr!u<br>Latin: kib.us<br>Loglan: tcidi</td>
            </tr>

            <tr>
                <td data-label="Word">psan</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sandwich</td>
                <td data-label="Phon">sanduyc</td>
                <td data-label="Definition">X1 is a sandwich of food (xo) X2* between slices (xo-bene) X3</td>
                <td data-label="Comments">Includes structural materials not for eating.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: -san/uen!jr<br>Latin: <br>Loglan: sandi*</td>
            </tr>

            <tr>
                <td data-label="Word">psuw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">soup</td>
                <td data-label="Phon">sup</td>
                <td data-label="Definition">(xo) X1 is some soup with major ingredient (xo) X2*</td>
                <td data-label="Comments">Includes coffee and tea.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: -taw<br>Latin: <br>Loglan: supta</td>
            </tr>

            <tr>
                <td data-label="Word">sawi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sauce</td>
                <td data-label="Phon">sas</td>
                <td data-label="Definition">X1 is a sauce for food (xo) X2 with major ingredient (xo) X3*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: !jiaw/iou<br>Latin: yus<br>Loglan: sanso*</td>
            </tr>

            <tr>
                <td data-label="Word">tsa</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">vegetable</td>
                <td data-label="Phon">vejt#bl</td>
                <td data-label="Definition">X1 is a vegetable</td>
                <td data-label="Comments">Edible roots and stems.  In English some fruits are mis-classified as vegetables, e.g. tomato or squash.</td>
                <td data-label="Xref">ftu</td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: !tsai<br>Latin: hol.ys<br>Loglan: stagi*</td>
            </tr>

            <tr>
                <td data-label="Word">tewa</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">salad</td>
                <td data-label="Phon">sal#d</td>
                <td data-label="Definition">X1 is a salad with main ingredient (xo) X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: -qew!tsai<br>Latin: aketerya<br>Loglan: salta*</td>
            </tr>

            <tr>
                <td data-label="Word">siwi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">spice</td>
                <td data-label="Phon">spais</td>
                <td data-label="Definition">(xo) X1 is some spice</td>
                <td data-label="Comments">Minor ingredient to add flavor.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.3.5<br>Chinese: -siaw!liau<br>Latin: kondyment.um<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">440</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Information</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">441</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Works of Art</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: is a work of art about topic X2 by author X3 interpreted by performer X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jiul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">drama, play</td>
                <td data-label="Phon">drama</td>
                <td data-label="Definition">X1 is a drama about (vo) X2: by X3:M2 performed by X4:</td>
                <td data-label="Comments">With live actors.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: !si!jiu<br>Latin: fabula<br>Loglan: draci*</td>
            </tr>

            <tr>
                <td data-label="Word">fpyr</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">picture</td>
                <td data-label="Phon">pykcr</td>
                <td data-label="Definition">X1 is a picture of X2: by X3:M2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: !hua<br>Latin: pyktura<br>Loglan: tcure</td>
            </tr>

            <tr>
                <td data-label="Word">zymu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">music</td>
                <td data-label="Phon">miuzyk</td>
                <td data-label="Definition">X1 is a musical composition about (vo) X2: by X3:M2 performed by X4:</td>
                <td data-label="Comments">Only ``program music&#x27;&#x27; has a legitimate X2; case order matches other works of art.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: -in!ue<br>Latin: musyka<br>Loglan: muzgi</td>
            </tr>

            <tr>
                <td data-label="Word">kqnu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">fiction</td>
                <td data-label="Phon">fykqn</td>
                <td data-label="Definition">X1 is a work of fiction about (vo) X2: by X3:M2</td>
                <td data-label="Comments">Emphasizes that the content is not fact.</td>
                <td data-label="Xref">stor</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: !gu-qr<br>Latin: fabula<br>Loglan: fikco</td>
            </tr>

            <tr>
                <td data-label="Word">kquy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">book</td>
                <td data-label="Phon">buk</td>
                <td data-label="Definition">X1 is a book about (vo) X2: by X3:M2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: -qu<br>Latin: lyber<br>Loglan: bukcu</td>
            </tr>

            <tr>
                <td data-label="Word">psyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">cinema, movie</td>
                <td data-label="Phon">synema</td>
                <td data-label="Definition">X1 is a movie or cinema about (vo) X2: by X3:M2 performed by X4:</td>
                <td data-label="Comments">Includes videotape.  X3 would include the author of the story or screenplay.  The director could be in X4.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: !dian|iw<br>Latin: <br>Loglan: sinma</td>
            </tr>

            <tr>
                <td data-label="Word">krme</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">poem</td>
                <td data-label="Phon">poem</td>
                <td data-label="Definition">X1 is a poem about (vo) X2: by X3:M2</td>
                <td data-label="Comments">With rhyming or otherwise beautiful words.</td>
                <td data-label="Xref">pror</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: -qr<br>Latin: karmen<br>Loglan: virsa</td>
            </tr>

            <tr>
                <td data-label="Word">qtul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">map</td>
                <td data-label="Phon">map</td>
                <td data-label="Definition">X1 is a map of X2: by X3:M2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: !di/tu<br>Latin: tabula<br>Loglan: cartu</td>
            </tr>

            <tr>
                <td data-label="Word">pror</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">prose</td>
                <td data-label="Phon">proz</td>
                <td data-label="Definition">X1 is a piece of prose about (vo) X2: by X3:M2</td>
                <td data-label="Comments">Ordinary speech as opposed to a poem.</td>
                <td data-label="Xref">krme</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: |san/uen<br>Latin: orat.yo<br>Loglan: proza</td>
            </tr>

            <tr>
                <td data-label="Word">stor</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">history</td>
                <td data-label="Phon">hystori</td>
                <td data-label="Definition">X1 is a history of (vo) X2: by X3:M2</td>
                <td data-label="Comments">A factual report of event or process X2.</td>
                <td data-label="Xref">kqnu</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: !li|qr<br>Latin: hystorya<br>Loglan: cisti</td>
            </tr>

            <tr>
                <td data-label="Word">xgur</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">story</td>
                <td data-label="Phon">stori</td>
                <td data-label="Definition">X1 is a story about (vo) X2: by X3:M2</td>
                <td data-label="Comments">X2 is an event or process, not necessarily factual, and the interest is in describing it.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1<br>Chinese: !gu-qr<br>Latin: fabula<br>Loglan: stuci</td>
            </tr>

            <tr>
                <td data-label="Word">pla</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">plan</td>
                <td data-label="Phon">plan</td>
                <td data-label="Definition">X1 is a plan for (vo) X2: by X3:M2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.1, 4.4.5<br>Chinese: !ji!hua<br>Latin: forma<br>Loglan: danci</td>
            </tr>

            <tr>
                <td data-label="Word">442</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Other Documents</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: is a document about topic X2 by author X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">beyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">memo, note, notice</td>
                <td data-label="Phon">not</td>
                <td data-label="Definition">X1 is a memo about (vo) X2: by X3:M2 to recipient X4:M3</td>
                <td data-label="Comments">A memo is supposed to be a short letter, easily remembered.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2<br>Chinese: !ji!lu<br>Latin: lybel.us<br>Loglan: noxta*</td>
            </tr>

            <tr>
                <td data-label="Word">der</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">describe</td>
                <td data-label="Phon">deskraib</td>
                <td data-label="Definition">X1 is a description of (vo) X2: given by X3:M2</td>
                <td data-label="Comments">Use -jai -fw -der for saying a description.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2<br>Chinese: /siw/r#w<br>Latin: deskryb.ere<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">stul</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">letter</td>
                <td data-label="Phon">letr</td>
                <td data-label="Definition">X1 is a letter about (vo) X2: from X3:M2 to recipient X4M3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2<br>Chinese: !sin<br>Latin: epystula<br>Loglan: lerci</td>
            </tr>

            <tr>
                <td data-label="Word">vjin</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">gene</td>
                <td data-label="Phon">jin</td>
                <td data-label="Definition">X1 is a gene for phenotype (vo) X2 of organism (xi) X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2<br>Chinese: -ji-in<br>Latin: <br>Loglan: jgina*</td>
            </tr>

            <tr>
                <td data-label="Word">dyrn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">journal, newspaper, magazine</td>
                <td data-label="Phon">jrnl</td>
                <td data-label="Definition">X1 is a journal about (vo) X2: from publisher X3</td>
                <td data-label="Comments">Normally published regularly, each issue contains related stories, descriptions, etc.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2<br>Chinese: !r!bau<br>Latin: akta-dyurna<br>Loglan: barnu*</td>
            </tr>

            <tr>
                <td data-label="Word">vdy</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">comment</td>
                <td data-label="Phon">kament</td>
                <td data-label="Definition">X1M2 makes comment (bi) X2@ about affair (vo) X3+ to listener (ju) X4M3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2, 2.3.2<br>Chinese: /piw!ju<br>Latin: dykt.um<br>Loglan: pinka*</td>
            </tr>

            <tr>
                <td data-label="Word">tri</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rite, ceremony, ritual</td>
                <td data-label="Phon">rytiu#l</td>
                <td data-label="Definition">(vo) X1@! is a ceremony or ritual about (vo) X2:+ of culture (xy) X3s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">ga, jil, jrm</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2, 4.7.1<br>Chinese: |li<br>Latin: rit.us<br>Loglan: ritli*</td>
            </tr>

            <tr>
                <td data-label="Word">spia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">ticket</td>
                <td data-label="Phon">tyk#t</td>
                <td data-label="Definition">X1 is a ticket allowing attendee X2 to do activity (vo) X3+2 from impresario X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2, 4.7.2<br>Chinese: !piau<br>Latin: tesera<br>Loglan: ketpi</td>
            </tr>

            <tr>
                <td data-label="Word">vdaw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">bill</td>
                <td data-label="Phon">byl</td>
                <td data-label="Definition">X1 is a bill of account for services or goods X2 from vendor X3 to buyer X4</td>
                <td data-label="Comments">X4 is supposed to pay X3 for X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2, 4.7.3<br>Chinese: !jaw-dan<br>Latin: rat.yo<br>Loglan: kanti</td>
            </tr>

            <tr>
                <td data-label="Word">spau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">passport</td>
                <td data-label="Phon">pasport</td>
                <td data-label="Definition">X1 is a passport issued to traveller X2 by government X3 for travel in country X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.2, 4.7.4<br>Chinese: !hu!jau<br>Latin: <br>Loglan: paspo</td>
            </tr>

            <tr>
                <td data-label="Word">443</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Records and Information</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bzo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">code, cypher, encrypt</td>
                <td data-label="Phon">kod</td>
                <td data-label="Definition">X1 is a coded record of plain text X2* using code X3</td>
                <td data-label="Comments">Code is secret writing.  Use -qkia for the key.</td>
                <td data-label="Xref">qkia, saw</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: -mi|ma<br>Latin: notae<br>Loglan: mifra*</td>
            </tr>

            <tr>
                <td data-label="Word">dva</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">document</td>
                <td data-label="Phon">dakiument</td>
                <td data-label="Definition">X1 is a document in which author X3 says that fact (vo) X2+ is true</td>
                <td data-label="Comments">No case merge.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: /uen!jian<br>Latin: lyterae<br>Loglan: dokta</td>
            </tr>

            <tr>
                <td data-label="Word">flyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">flag</td>
                <td data-label="Phon">flag</td>
                <td data-label="Definition">X1 is a flag of organization X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: /ci<br>Latin: veksyl.um<br>Loglan: flaci</td>
            </tr>

            <tr>
                <td data-label="Word">fpr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">print</td>
                <td data-label="Phon">prynt</td>
                <td data-label="Definition">X1 is a printed image of original X2 on media X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pym</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: !in-qua/pin<br>Latin: ymprym.ere<br>Loglan: capri</td>
            </tr>

            <tr>
                <td data-label="Word">sta</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">mark</td>
                <td data-label="Phon">mark</td>
                <td data-label="Definition">X1 is a mark on media X2*</td>
                <td data-label="Comments">Use -syry -sta for spot.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: |dian<br>Latin: nota<br>Loglan: marka</td>
            </tr>

            <tr>
                <td data-label="Word">vbl</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">label</td>
                <td data-label="Phon">laibl</td>
                <td data-label="Definition">X1 is a label for object X2</td>
                <td data-label="Comments">Descriptive writing on or near it.  Use -xe -bn -vbl to get its text.  Use -xim for ``name&#x27;&#x27;.</td>
                <td data-label="Xref">xim, dre</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: -tie|jr<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xgyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">page</td>
                <td data-label="Phon">paij</td>
                <td data-label="Definition">X1 is a page in book X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: !ie<br>Latin: pagyna<br>Loglan: pidri</td>
            </tr>

            <tr>
                <td data-label="Word">zda</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">record, medium</td>
                <td data-label="Phon">rekrd</td>
                <td data-label="Definition">X1 is a record describing event (vo) X2+ on medium X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3<br>Chinese: !ji!dzai<br>Latin: tabulae<br>Loglan: rirda</td>
            </tr>

            <tr>
                <td data-label="Word">dal</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">datum, statistic</td>
                <td data-label="Phon">data</td>
                <td data-label="Definition">X1 is a datum about object X2 its property (vo) X3+2</td>
                <td data-label="Comments">The degree or presence/absence of the property.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3, 3.7.4<br>Chinese: -dz!liau<br>Latin: <br>Loglan: datni*</td>
            </tr>

            <tr>
                <td data-label="Word">dvro</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">advertise</td>
                <td data-label="Phon">advrtiz</td>
                <td data-label="Definition">X1 is an advertisement about services or goods X2* appearing in publication X3</td>
                <td data-label="Comments">X3 includes non-print media</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.3, 4.7.2<br>Chinese: |guaw!gau<br>Latin: proscryb.ere<br>Loglan: virta</td>
            </tr>

            <tr>
                <td data-label="Word">444</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Signs and Symbols</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">address</td>
                <td data-label="Phon">adres</td>
                <td data-label="Definition">(bi) X1 is an address of object X2*</td>
                <td data-label="Comments">A sign or text saying which X2 is chosen, often for sending messages.</td>
                <td data-label="Xref">der, vbl</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.4<br>Chinese: !dy|jr<br>Latin: ynskript.yo<br>Loglan: judri*</td>
            </tr>

            <tr>
                <td data-label="Word">pon</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">answer, question</td>
                <td data-label="Phon">ansr</td>
                <td data-label="Definition">(bi) X1 is an answer to question (bi) X2@ from interrogator X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">xue, srn, stm</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.4<br>Chinese: /huei/da<br>Latin: respons.um<br>Loglan: retpi</td>
            </tr>

            <tr>
                <td data-label="Word">qna</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">connotation</td>
                <td data-label="Phon">kanotaqn</td>
                <td data-label="Definition">(vo) X1@ is a connotation of word (bi) X2</td>
                <td data-label="Comments">A meaning beyond the official referent set.  Discouraged in \guaspi.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.4<br>Chinese: !nai/han<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">sni</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">mean, sign</td>
                <td data-label="Phon">sain</td>
                <td data-label="Definition">Sign X1 has meaning (vo) X2 to listener X3</td>
                <td data-label="Comments">X1 should have a similar referent set to ``!xe -vo X2&#x27;&#x27; or ``!xe -vn -X2&#x27;&#x27;, except X1 may be foreign or non-language.  Use -vbl for a placard.</td>
                <td data-label="Xref">vbr</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.4<br>Chinese: !i-sz<br>Latin: sygnyfyk.are<br>Loglan: sanpa</td>
            </tr>

            <tr>
                <td data-label="Word">viw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">view</td>
                <td data-label="Phon">viu</td>
                <td data-label="Definition">X1 is a view of object X2 from viewpoint X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.4<br>Chinese: -f#w|jiw<br>Latin: prospekt.us<br>Loglan: vidju</td>
            </tr>

            <tr>
                <td data-label="Word">xim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">name</td>
                <td data-label="Phon">naim</td>
                <td data-label="Definition">The referent of nameholder X1 has the name X2</td>
                <td data-label="Comments">To assign a name to an argument you need -ga (performative), e.g. (argument) |ga -xim =(name).</td>
                <td data-label="Xref">vbl, xgnl</td>
                <td data-label="Notes">Rank: 25<br>Thes: 4.4.4<br>Chinese: /miw.-dz<br>Latin: nomen<br>Loglan: namci</td>
            </tr>

            <tr>
                <td data-label="Word">gzn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">news</td>
                <td data-label="Phon">nuz</td>
                <td data-label="Definition">(vo) X1@! is a piece of news about affair (vo) X2+ from source X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.4<br>Chinese: -sin/uen<br>Latin: nunty.us<br>Loglan: nuzvo</td>
            </tr>

            <tr>
                <td data-label="Word">tem</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">date, time</td>
                <td data-label="Phon">dat</td>
                <td data-label="Definition">X1M4 is the date of event (vo) X2+ starting with unit (xu-jani) X3* in calendar X4</td>
                <td data-label="Comments">X1 is a list of (xu) numbers, largest first.  X2 auto-converts.  X3 compounds.  Hour: -tem -qrau</td>
                <td data-label="Xref">qrau</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.4, 4.5.3<br>Chinese: !r/ci<br>Latin: temp.us<br>Loglan: detri*</td>
            </tr>

            <tr>
                <td data-label="Word">445</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Ideas</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.5<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jil</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">religion</td>
                <td data-label="Phon">rilyj#n</td>
                <td data-label="Definition">(vo) X1 is a religious belief or practice of people (xy) X2s*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">qew, tri</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.5<br>Chinese: -dzuw!jiau<br>Latin: relyg.yo<br>Loglan: lidji</td>
            </tr>

            <tr>
                <td data-label="Word">qar</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">art</td>
                <td data-label="Phon">art</td>
                <td data-label="Definition">X1 practices art (xo-vo) X2+1</td>
                <td data-label="Comments">The art of doing some activity.</td>
                <td data-label="Xref">dur</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.5<br>Chinese: !i!qu<br>Latin: ars<br>Loglan: larte</td>
            </tr>

            <tr>
                <td data-label="Word">qew</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">holy, sacred</td>
                <td data-label="Phon">holi</td>
                <td data-label="Definition">X1 is sacred to people (xy) X2s*</td>
                <td data-label="Comments">Usually an object or place; use -jil for activity.</td>
                <td data-label="Xref">jil</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.5<br>Chinese: !qew/jie<br>Latin: saker<br>Loglan: censa*</td>
            </tr>

            <tr>
                <td data-label="Word">sml</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">model</td>
                <td data-label="Phon">madl</td>
                <td data-label="Definition">X1 is a model of real object (xo) X2*</td>
                <td data-label="Comments">A metaphoric object, usually small, showing only essential features.</td>
                <td data-label="Xref">toi</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.5<br>Chinese: /muo/siw<br>Latin: eksemplar<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">toi</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">toy</td>
                <td data-label="Phon">toi</td>
                <td data-label="Definition">X1 is a toy representing real objct (xo) X2*</td>
                <td data-label="Comments">A metaphoric object used for playing.</td>
                <td data-label="Xref">sml</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.5<br>Chinese: /uan!jiu<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">xno</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">idea</td>
                <td data-label="Phon">aidia</td>
                <td data-label="Definition">X1 is an idea about affair (vo) X2+</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.5<br>Chinese: !i-sz<br>Latin: not.yo<br>Loglan: vidre</td>
            </tr>

            <tr>
                <td data-label="Word">dur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">industry</td>
                <td data-label="Phon">yndustri</td>
                <td data-label="Definition">X1 is an industrial art for making goods (xi) X2*</td>
                <td data-label="Comments">|tue for culture.</td>
                <td data-label="Xref">qar</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.5, 4.7.2<br>Chinese: -guw!ie<br>Latin: yndustrya<br>Loglan: gotri</td>
            </tr>

            <tr>
                <td data-label="Word">446</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Linguistics and Language Elements</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.6<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">gua</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">language</td>
                <td data-label="Phon">languaj</td>
                <td data-label="Definition">X1 is a language of culture X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">quo</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.6<br>Chinese: |u/ian<br>Latin: lingua<br>Loglan: lengu</td>
            </tr>

            <tr>
                <td data-label="Word">gvo</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">voice</td>
                <td data-label="Phon">vois</td>
                <td data-label="Definition">X1 is a vocal signal of creature X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.6<br>Chinese: -qew<br>Latin: voks<br>Loglan: volsa</td>
            </tr>

            <tr>
                <td data-label="Word">vbr</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">word</td>
                <td data-label="Phon">urd</td>
                <td data-label="Definition">(bu) X1 is a word of language X2 with meaning X3</td>
                <td data-label="Comments">X3&#x27;s referent set suggests what ``-xe X1&#x27;&#x27; would produce if it were \guaspi\  --- training aid only.</td>
                <td data-label="Xref">sni, qury</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.6<br>Chinese: !hua<br>Latin: verb.um<br>Loglan: purda</td>
            </tr>

            <tr>
                <td data-label="Word">zga</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">grammar, syntax</td>
                <td data-label="Phon">gramr</td>
                <td data-label="Definition">X1 is a grammar of language X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.6<br>Chinese: /uen|fa<br>Latin: gramatyka<br>Loglan: gerna*</td>
            </tr>

            <tr>
                <td data-label="Word">zim</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">rhyme</td>
                <td data-label="Phon">raim</td>
                <td data-label="Definition">Word (bi) X1@ rhymes with word (bi) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.6<br>Chinese: -ia/un<br>Latin: <br>Loglan: rimni*</td>
            </tr>

            <tr>
                <td data-label="Word">447</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">\protect\Guaspi\ Grammatical Categories</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tirl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">article</td>
                <td data-label="Phon">artikl</td>
                <td data-label="Definition">X1 is an article</td>
                <td data-label="Comments">Prefix which selects referent subset.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">kona</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">consonant</td>
                <td data-label="Phon">kons#n#nt</td>
                <td data-label="Definition">X1 is a consonant phoneme</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">vumu</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: |fu-in<br>Latin: konsonans<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">vumu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">vowel</td>
                <td data-label="Phon">vaul</td>
                <td data-label="Definition">X1 is a vowel phoneme</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">kona</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: |mu-in<br>Latin: <br>Loglan: marli</td>
            </tr>

            <tr>
                <td data-label="Word">qury</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">predicate</td>
                <td data-label="Phon">predyk#t</td>
                <td data-label="Definition">(bu) X1 is a predicate word of \guaspi\  with meaning X2</td>
                <td data-label="Comments">X2&#x27;s referent set suggests what ``-xe X1&#x27;&#x27; would produce --- training aid only.  </td>
                <td data-label="Xref">vbr</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: !qu|u<br>Latin: atrybut.yo<br>Loglan: bridi*</td>
            </tr>

            <tr>
                <td data-label="Word">skam</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">case, parameter</td>
                <td data-label="Phon">kas</td>
                <td data-label="Definition">X1 is the first case of relation (vo) X2+</td>
                <td data-label="Comments">Convert X2 for N&#x27;th case.  Use -qin for case occupant or actual argument.</td>
                <td data-label="Xref">gna, dlmo</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: -<br>Latin: kas.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">spro</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">pronoun</td>
                <td data-label="Phon">pronaun</td>
                <td data-label="Definition">X1 is a pronoun</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: !dai/miw/tsz<br>Latin: pronomen<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">tler</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">letter</td>
                <td data-label="Phon">letr</td>
                <td data-label="Definition">X1 is a letter of alphabet X2</td>
                <td data-label="Comments">Of the alphabet that goes with language X2.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: !dz|mu<br>Latin: lytera<br>Loglan: letra</td>
            </tr>

            <tr>
                <td data-label="Word">triy</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">restrict, phrase</td>
                <td data-label="Phon">ristrykt</td>
                <td data-label="Definition">(bi) X1 is a restrictive phrase</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zdua</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: !qo!qien!j#.-de<br>Latin: fyn.yre<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dinu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">tone</td>
                <td data-label="Phon">ton</td>
                <td data-label="Definition">X1 is the tone of word (bu) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: -in!diau<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">garm</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">assert</td>
                <td data-label="Phon">asert</td>
                <td data-label="Definition">(bi) X1 is an assertion</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">zdua</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: -suaw!gau<br>Latin: adfyrmat.yo<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dlmo</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">modal</td>
                <td data-label="Phon">modl</td>
                <td data-label="Definition">X1 is the modal case of relation (vo) X2@! on dimension (vo) X3+</td>
                <td data-label="Comments">-qin |dlmo for actual argument.  X3 is the modal predicate and X1 is its 2nd case after autoconversion.</td>
                <td data-label="Xref">gna, skam, qin</td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cimu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mood</td>
                <td data-label="Phon">mud</td>
                <td data-label="Definition">X1 is a mood prefix word</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: |u!ci<br>Latin: mod.us<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">zdua</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">phrase, sentence, argument</td>
                <td data-label="Phon">fraiz</td>
                <td data-label="Definition">(bi) X1 is a phrase of language X2*</td>
                <td data-label="Comments">X2 typically is \guaspi.  Use -sym -zdua for main or discourse-level sentence.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7<br>Chinese: |duan!ju<br>Latin: lokut.yo<br>Loglan: steti</td>
            </tr>

            <tr>
                <td data-label="Word">zin</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">referent</td>
                <td data-label="Phon">min</td>
                <td data-label="Definition">X1 is in the referent set of word (bi) X2</td>
                <td data-label="Comments">Use !xu to get the whole set. </td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.4.7, 1.1.3, 1.5.6<br>Chinese: !i-sz<br>Latin: vys<br>Loglan: marni*</td>
            </tr>

            <tr>
                <td data-label="Word">450</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Units of Measure</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">A unit is a function that multiplies an expression by a basis element giving the class of events that big on the relevant dimension.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">451</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Units of Time</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: is in the equivalence class of value (xu) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dman</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">second</td>
                <td data-label="Phon">sek#nd</td>
                <td data-label="Definition">X1 IEC (xu) X2:* seconds</td>
                <td data-label="Comments">SI basis unit of time.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.1<br>Chinese: |miau<br>Latin: moment.um<br>Loglan: sekmi</td>
            </tr>

            <tr>
                <td data-label="Word">jani</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">year</td>
                <td data-label="Phon">ir</td>
                <td data-label="Definition">X1 IEC (xu) X2:* years</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.1<br>Chinese: /nian<br>Latin: an.us<br>Loglan: nirne</td>
            </tr>

            <tr>
                <td data-label="Word">qrau</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">hour</td>
                <td data-label="Phon">aur</td>
                <td data-label="Definition">X1 IEC (xu) X2:* hours</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">tem</td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.1<br>Chinese: |siau/qr<br>Latin: hora<br>Loglan: jorta</td>
            </tr>

            <tr>
                <td data-label="Word">jeme</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">month</td>
                <td data-label="Phon">m#nt</td>
                <td data-label="Definition">X1 IEC (xu) X2:* months</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.1<br>Chinese: !ue<br>Latin: mens.ys<br>Loglan: mensa</td>
            </tr>

            <tr>
                <td data-label="Word">tyny</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">minute</td>
                <td data-label="Phon">myn#t</td>
                <td data-label="Definition">X1 IEC (xu) X2:* minutes</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.1<br>Chinese: -f#n<br>Latin: punkt.um<br>Loglan: minta</td>
            </tr>

            <tr>
                <td data-label="Word">vdia</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">day</td>
                <td data-label="Phon">dai</td>
                <td data-label="Definition">X1 IEC (xu) X2:* days</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.1<br>Chinese: -tian<br>Latin: di.es<br>Loglan: denli</td>
            </tr>

            <tr>
                <td data-label="Word">xbai</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">week</td>
                <td data-label="Phon">uik</td>
                <td data-label="Definition">X1 IEC (xu) X2:* weeks</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.1<br>Chinese: |li!bai<br>Latin: <br>Loglan: likta</td>
            </tr>

            <tr>
                <td data-label="Word">452</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Units of Other Dimensions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition">X1: is in the equivalence class of value (xu) X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dini</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">radian, angle</td>
                <td data-label="Phon">radian</td>
                <td data-label="Definition">X1 IEC (xu) X2:* times one radian of angle</td>
                <td data-label="Comments">1/2pi of a circle.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">ful</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">quantity, ful</td>
                <td data-label="Phon">ful</td>
                <td data-label="Definition">X1 IEC value (xu) X3 times the capacity of container (xi) X2*</td>
                <td data-label="Comments">As in spoonful.</td>
                <td data-label="Xref">kun</td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: |man<br>Latin: <br>Loglan: kanli</td>
            </tr>

            <tr>
                <td data-label="Word">cmol</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mole</td>
                <td data-label="Phon">mol</td>
                <td data-label="Definition">X1 IEC (xu) X2:* moles</td>
                <td data-label="Comments">CGS and (apparently) SI basis unit of amount of material, 6.02E23 atoms or molecules.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -<br>Latin: <br>Loglan: molro*</td>
            </tr>

            <tr>
                <td data-label="Word">gvyn</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">kelvin, degree</td>
                <td data-label="Phon">kelvyn</td>
                <td data-label="Definition">X1 IEC (xu) X2:* degrees Kelvin</td>
                <td data-label="Comments">SI basis unit of temperature.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -<br>Latin: -<br>Loglan: kelvo*</td>
            </tr>

            <tr>
                <td data-label="Word">dean</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">candela</td>
                <td data-label="Phon">kandela</td>
                <td data-label="Definition">X1 IEC (xu) X2:* candela</td>
                <td data-label="Comments">SI basis unit of luminosity.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -<br>Latin: -<br>Loglan: cando*</td>
            </tr>

            <tr>
                <td data-label="Word">kyam</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">kilogram</td>
                <td data-label="Phon">kylogram</td>
                <td data-label="Definition">X1 IEC (xu) X2:* kilograms</td>
                <td data-label="Comments">SI basis unit of mass.  Not compound (kilo-gram) in \guaspi.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -cian!k#<br>Latin: -<br>Loglan: kigra</td>
            </tr>

            <tr>
                <td data-label="Word">stir</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">steradian</td>
                <td data-label="Phon">stiraidi#n</td>
                <td data-label="Definition">X1 IEC (xu) X2:* times one steradian of solid angle</td>
                <td data-label="Comments">1/4pi of a sphere.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -<br>Latin: <br>Loglan: stero*</td>
            </tr>

            <tr>
                <td data-label="Word">vdei</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">degree</td>
                <td data-label="Phon">degri</td>
                <td data-label="Definition">X1 IEC (xu) X2:* times one degree of angle</td>
                <td data-label="Comments">1/360 of a circle.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: |jiau!du<br>Latin: <br>Loglan: dugri</td>
            </tr>

            <tr>
                <td data-label="Word">dmem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">meter</td>
                <td data-label="Phon">mitr</td>
                <td data-label="Definition">X1 IEC (xu) X2:* meter</td>
                <td data-label="Comments">SI basis unit of length.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -guw|c#<br>Latin: dekempeda<br>Loglan: metro</td>
            </tr>

            <tr>
                <td data-label="Word">gram</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">gram</td>
                <td data-label="Phon">gram</td>
                <td data-label="Definition">X1 IEC (xu) X2:* grams</td>
                <td data-label="Comments">CGS basis unit for mass.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2<br>Chinese: -<br>Latin: -<br>Loglan: gramo</td>
            </tr>

            <tr>
                <td data-label="Word">cni</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">money, piece, dollar</td>
                <td data-label="Phon">m#ni</td>
                <td data-label="Definition">X1 IEC (xu) X2:* basis money units of culture X3</td>
                <td data-label="Comments">You may attach the native money word by metaphor.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.5.2, 4.7.3<br>Chinese: /cian<br>Latin: num.us<br>Loglan: pesra</td>
            </tr>

            <tr>
                <td data-label="Word">460</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Categories of Humans and Others</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">461</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Reproductive and Family Status</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cil</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">child</td>
                <td data-label="Phon">cild</td>
                <td data-label="Definition">X1 is a child of parent X2</td>
                <td data-label="Comments">Human only.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: 14<br>Thes: 4.6.1<br>Chinese: /hai.-dz<br>Latin: puer<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dvyr</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">man</td>
                <td data-label="Phon">man</td>
                <td data-label="Definition">X1 is a male human</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: /nan/ren<br>Latin: vyr<br>Loglan: mrenu</td>
            </tr>

            <tr>
                <td data-label="Word">fmy</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">female</td>
                <td data-label="Phon">fimail</td>
                <td data-label="Definition">X1 is a female of species X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: -tz<br>Latin: femyna<br>Loglan: femdi</td>
            </tr>

            <tr>
                <td data-label="Word">gnue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">girl</td>
                <td data-label="Phon">grl</td>
                <td data-label="Definition">X1 is a girl of parents X2</td>
                <td data-label="Comments">Female human child.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: |nu.-dz<br>Latin: puela<br>Loglan: nirli</td>
            </tr>

            <tr>
                <td data-label="Word">pso</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">person</td>
                <td data-label="Phon">prs#n</td>
                <td data-label="Definition">X1 is a person</td>
                <td data-label="Comments">Not necessarily human.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: /ren<br>Latin: homo<br>Loglan: pernu</td>
            </tr>

            <tr>
                <td data-label="Word">cfn</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">woman</td>
                <td data-label="Phon">u#m#n</td>
                <td data-label="Definition">X1 is a female human</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: |nu/ren<br>Latin: femyna<br>Loglan: fumna</td>
            </tr>

            <tr>
                <td data-label="Word">vyl</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">male</td>
                <td data-label="Phon">mail</td>
                <td data-label="Definition">X1 is a male of species X2*</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: -guw<br>Latin: vyryl.ys<br>Loglan: mendi</td>
            </tr>

            <tr>
                <td data-label="Word">vdm</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">human</td>
                <td data-label="Phon">hiumn</td>
                <td data-label="Definition">X1 is a human</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: /ren<br>Latin: homo<br>Loglan: humni</td>
            </tr>

            <tr>
                <td data-label="Word">vboi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">boy</td>
                <td data-label="Phon">boi</td>
                <td data-label="Definition">X1 is a boy of parents X2</td>
                <td data-label="Comments">Male human child.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1<br>Chinese: /nan/hai<br>Latin: puer<br>Loglan: botci</td>
            </tr>

            <tr>
                <td data-label="Word">bew</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">adult</td>
                <td data-label="Phon">#d#lt</td>
                <td data-label="Definition">X1 is an adult</td>
                <td data-label="Comments">Any species.</td>
                <td data-label="Xref">bia</td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1, 4.6.2<br>Chinese: /qew/ren<br>Latin: pubes<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">bia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">baby</td>
                <td data-label="Phon">baibi</td>
                <td data-label="Definition">X1 is a baby of parents X2</td>
                <td data-label="Comments">Any species.</td>
                <td data-label="Xref">bew</td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1, 4.6.2<br>Chinese: -iw/hai<br>Latin: infans<br>Loglan: cinta</td>
            </tr>

            <tr>
                <td data-label="Word">tfir</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">embryo, fetus</td>
                <td data-label="Phon">fit#s</td>
                <td data-label="Definition">X1 is a fetus of parents X2</td>
                <td data-label="Comments">Any species.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.1, 4.6.2<br>Chinese: -tai/r<br>Latin: fet.us<br>Loglan: tarbi*</td>
            </tr>

            <tr>
                <td data-label="Word">462</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Family Relations</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments">Of all areas where \guaspi\ is culturally biased, the family relations are the most blatant.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cfyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">son</td>
                <td data-label="Phon">s#n</td>
                <td data-label="Definition">Male X1: is the son of parents X2</td>
                <td data-label="Comments">X2 is any sex, may include both parents.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.2<br>Chinese: /er.-dz<br>Latin: fyly.us<br>Loglan: sunho</td>
            </tr>

            <tr>
                <td data-label="Word">fter</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">father</td>
                <td data-label="Phon">fatr</td>
                <td data-label="Definition">Male X1: is the father of offspring X2 by female mother X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.2<br>Chinese: !fu<br>Latin: pater<br>Loglan: farfu</td>
            </tr>

            <tr>
                <td data-label="Word">trer</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">brother</td>
                <td data-label="Phon">brotr</td>
                <td data-label="Definition">Male X1: is a brother of sibling X2 by parents X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.2<br>Chinese: -siuw!di<br>Latin: frater<br>Loglan: brudi</td>
            </tr>

            <tr>
                <td data-label="Word">term</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">mother</td>
                <td data-label="Phon">m#tr</td>
                <td data-label="Definition">Female X1: is the mother of offspring X2 by male father X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.2<br>Chinese: |mu-cin<br>Latin: mater<br>Loglan: matma</td>
            </tr>

            <tr>
                <td data-label="Word">qwow</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sibling</td>
                <td data-label="Phon">syblyw</td>
                <td data-label="Definition">X1: is a sibling of X2: by parents X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.2<br>Chinese: -qow!di|jie!mei<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">soro</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">sister</td>
                <td data-label="Phon">systr</td>
                <td data-label="Definition">Female X1: is a sister of sibling X2 by parents X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.2<br>Chinese: |jie-jie<br>Latin: soror<br>Loglan: sorme</td>
            </tr>

            <tr>
                <td data-label="Word">drya</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">daughter</td>
                <td data-label="Phon">datr</td>
                <td data-label="Definition">Female X1: is a daughter of parents X2</td>
                <td data-label="Comments">X2 is any sex, may include both parents.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.2<br>Chinese: |nu/er<br>Latin: filya<br>Loglan: detra</td>
            </tr>

            <tr>
                <td data-label="Word">463</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Ordinary Professions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jror</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">warrior</td>
                <td data-label="Phon">uarior</td>
                <td data-label="Definition">X1 is a warrior of nation X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.3<br>Chinese: !jan!qr<br>Latin: myl.es<br>Loglan: bilca</td>
            </tr>

            <tr>
                <td data-label="Word">skri</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">secretary</td>
                <td data-label="Phon">sekr#teri</td>
                <td data-label="Definition">X1 is a secretary of bureaucrat X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.3<br>Chinese: -qu!ji<br>Latin: skribu<br>Loglan: mukri</td>
            </tr>

            <tr>
                <td data-label="Word">dmyl</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">soldier</td>
                <td data-label="Phon">soldir</td>
                <td data-label="Definition">X1 is a soldier of nation X2</td>
                <td data-label="Comments">Land warrior.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.3<br>Chinese: -biw<br>Latin: myl.es<br>Loglan: solda</td>
            </tr>

            <tr>
                <td data-label="Word">stue</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">student</td>
                <td data-label="Phon">student</td>
                <td data-label="Definition">X1 is a student at school X2 studying skill (xo-vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.3<br>Chinese: /sue-qew<br>Latin: dyskypul.us<br>Loglan: stude</td>
            </tr>

            <tr>
                <td data-label="Word">pliw</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">police</td>
                <td data-label="Phon">polis</td>
                <td data-label="Definition">X1 is a policeman of organization X2</td>
                <td data-label="Comments">X2 is the unit protected, e.g. city, state.  Includes private security forces.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.3, 4.7.4<br>Chinese: |jiw/ca<br>Latin: aedyl.es<br>Loglan: pulji*</td>
            </tr>

            <tr>
                <td data-label="Word">plma</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">diplomat, consul</td>
                <td data-label="Phon">dyplamat</td>
                <td data-label="Definition">X1 is a diplomat of nation X2 in place X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.3, 4.7.4<br>Chinese: |liw!shr<br>Latin: legat.us<br>Loglan: konsu</td>
            </tr>

            <tr>
                <td data-label="Word">464</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Other Professions</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fuiu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">deputy, vice</td>
                <td data-label="Phon">depiuti</td>
                <td data-label="Definition">X1 is a deputy to chief X2*</td>
                <td data-label="Comments">X1 has X2&#x27;s authority when X2 isn&#x27;t there.</td>
                <td data-label="Xref">juou</td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.4<br>Chinese: !fu<br>Latin: legat.us<br>Loglan: vipsi*</td>
            </tr>

            <tr>
                <td data-label="Word">ken</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">captain</td>
                <td data-label="Phon">kapten</td>
                <td data-label="Definition">X1 is the captain of team or crew (xy) X2s</td>
                <td data-label="Comments">Includes ship captains.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.4<br>Chinese: |jaw<br>Latin: prynkeps<br>Loglan: kapta</td>
            </tr>

            <tr>
                <td data-label="Word">juou</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">assistant</td>
                <td data-label="Phon">asystant</td>
                <td data-label="Definition">X1 is an assistant to chief X2*</td>
                <td data-label="Comments">X1 cannot do X2&#x27;s job alone.</td>
                <td data-label="Xref">fuiu, bwu</td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.4<br>Chinese: !ju|qou<br>Latin: adyutor<br>Loglan: helba</td>
            </tr>

            <tr>
                <td data-label="Word">vdem</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">god</td>
                <td data-label="Phon">gad</td>
                <td data-label="Definition">X1 is a god responsible for function (vo) X2+1</td>
                <td data-label="Comments">|tue for the culture.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.6.4<br>Chinese: /s#n<br>Latin: de.us<br>Loglan: gandi</td>
            </tr>

            <tr>
                <td data-label="Word">470</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Human Society</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.0<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">471</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Culture</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.1<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">dmo</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">moral, rule</td>
                <td data-label="Phon">mor#l</td>
                <td data-label="Definition">Rule (bi) X1@ requires behavior (vo) X2+ in moral system or religion X3</td>
                <td data-label="Comments">X2 includes obligee.</td>
                <td data-label="Xref">gul</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.1<br>Chinese: !dau/de!liu<br>Latin: mor.es<br>Loglan: marde*</td>
            </tr>

            <tr>
                <td data-label="Word">fai</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">may, entitle</td>
                <td data-label="Phon">mai</td>
                <td data-label="Definition">X1 is entitled to do activity (vo) X2+1 because of rule (vo) X3+@</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">cim</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.1<br>Chinese: |ke|i<br>Latin: fas<br>Loglan: oe</td>
            </tr>

            <tr>
                <td data-label="Word">gul</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">must, rule, oblige, require, imperative</td>
                <td data-label="Phon">rul</td>
                <td data-label="Definition">Actor X1 must do activity (vo) X2+1 by rule (bi) X3@ promulgated by authority X4</td>
                <td data-label="Comments">Use -qre for scientific rules.</td>
                <td data-label="Xref">fyn, qre, cim, dmo, fta, zno, jrm</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.1<br>Chinese: !guei/dz#<br>Latin: leks<br>Loglan: rulni</td>
            </tr>

            <tr>
                <td data-label="Word">spi</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">culture, person, people</td>
                <td data-label="Phon">pipl</td>
                <td data-label="Definition">X1 is the local culture containing people (xu) X2</td>
                <td data-label="Comments">The usual self-referential word: only -xa -zu -spi are people!</td>
                <td data-label="Xref">zgn</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.1<br>Chinese: /min<br>Latin: kivys<br>Loglan: logli@</td>
            </tr>

            <tr>
                <td data-label="Word">try</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">tradition</td>
                <td data-label="Phon">tr#dyq#n</td>
                <td data-label="Definition">(vo) X1 is a tradition of culture X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.1<br>Chinese: /cuan|tuw<br>Latin: memorya<br>Loglan: tadnu*</td>
            </tr>

            <tr>
                <td data-label="Word">tue</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">culture</td>
                <td data-label="Phon">k#ltiur</td>
                <td data-label="Definition">X1 is a culture supported by people X2 consisting of behaviors (vo) X3+2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.1<br>Chinese: /uen!hua<br>Latin: <br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">472</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Business</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.2<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">qur</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">insure, peril, premium</td>
                <td data-label="Phon">ynqur</td>
                <td data-label="Definition">X1 insures client X2 against peril (vo) X3+2 for premium (xu) X4</td>
                <td data-label="Comments">X2 pays X4 to X1.  X4 is usually money per time.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.2<br>Chinese: |bau|sian<br>Latin: <br>Loglan: curdi</td>
            </tr>

            <tr>
                <td data-label="Word">ski</td>
                <td data-label="Class">q</td>
                <td data-label="Engl">company</td>
                <td data-label="Phon">kumpani</td>
                <td data-label="Definition">X1 is a company for activity (vo) X2+1 chartered by authority X3</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.2<br>Chinese: -gow-sz<br>Latin: sokietas<br>Loglan: kompi</td>
            </tr>

            <tr>
                <td data-label="Word">dia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">trade, exchange, barter</td>
                <td data-label="Phon">traid</td>
                <td data-label="Definition">X1 trades goods X2* with other trader X3 in exchange for goods X4</td>
                <td data-label="Comments">For barter; use -ven for selling for money.</td>
                <td data-label="Xref">ven, din</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.2, 2.4.4<br>Chinese: !diau!huan<br>Latin: permut.yo<br>Loglan: batmi</td>
            </tr>

            <tr>
                <td data-label="Word">frw</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">offer, price</td>
                <td data-label="Phon">afr</td>
                <td data-label="Definition">X1 offers goods X2 to buyer X3 for price or exchange X4</td>
                <td data-label="Comments">Also use for non-exchange offers, e.g. ``he offered her some grapes&#x27;&#x27;.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.2, 2.4.4<br>Chinese: !swu<br>Latin: of.ere<br>Loglan: tifru</td>
            </tr>

            <tr>
                <td data-label="Word">473</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Finance and Money</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">cenu</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">coin, bill, money</td>
                <td data-label="Phon">koyn</td>
                <td data-label="Definition">X1 is a coin or bill IEC denomination (xu) X2 issued by government X3</td>
                <td data-label="Comments">Use -cenu -tlme for coin, -cenu -crar for bill.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: /tuw/cien<br>Latin: num.us<br>Loglan: cmeni</td>
            </tr>

            <tr>
                <td data-label="Word">cia</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">owe</td>
                <td data-label="Phon">o</td>
                <td data-label="Definition">X1 owes money (xu) X2 to lender X3 for or secured by asset X4</td>
                <td data-label="Comments">X2 is typically money but doesn&#x27;t have to be.</td>
                <td data-label="Xref">jen, kre</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: !cian<br>Latin: deb.ere<br>Loglan: djeta</td>
            </tr>

            <tr>
                <td data-label="Word">jen</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">loan, lend, rent, interest</td>
                <td data-label="Phon">lend</td>
                <td data-label="Definition">X1 lends goods X2 to borrower X3 for IEC rent (xu) X4</td>
                <td data-label="Comments">Includes renting, and no-fee lending.  If X2 is repeated (e.g. money), X4 is money per X2 unit, usually also per time.</td>
                <td data-label="Xref">cia, kre</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: !jie-cu<br>Latin: faener.ary<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">jrn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">earn</td>
                <td data-label="Phon">rn</td>
                <td data-label="Definition">X1 earns wages (xu) X2 for work (vo) X3+1</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: !juan/qian<br>Latin: mer.ere<br>Loglan: jurna</td>
            </tr>

            <tr>
                <td data-label="Word">kre</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">credit</td>
                <td data-label="Phon">kredyt</td>
                <td data-label="Definition">X1 gives amount of credit (xu) X3 to borrower X2 for interest (xu) X4</td>
                <td data-label="Comments">Credit is a potential money loan.</td>
                <td data-label="Xref">cia, tew, jen</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: !jie!dai<br>Latin: kred.ere<br>Loglan: kredi</td>
            </tr>

            <tr>
                <td data-label="Word">plr</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">profit</td>
                <td data-label="Phon">prafyt</td>
                <td data-label="Definition">X1 is the profit to entrepreneur X2 from transaction (vo) X3</td>
                <td data-label="Comments">No case merge or compounding for X3.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: !li!i<br>Latin: lukr.um<br>Loglan: prali</td>
            </tr>

            <tr>
                <td data-label="Word">pra</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">price</td>
                <td data-label="Phon">prais</td>
                <td data-label="Definition">X1 IEC the price of goods X2* to buyer X3</td>
                <td data-label="Comments">Needs explicit -vo X2 for a service.</td>
                <td data-label="Xref">sol</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: !jia/cian<br>Latin: prety.um<br>Loglan: prati</td>
            </tr>

            <tr>
                <td data-label="Word">sol</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">pay</td>
                <td data-label="Phon">pai</td>
                <td data-label="Definition">X1 gives payment (xu) X2 to vendor X3 for goods or services X4</td>
                <td data-label="Comments"></td>
                <td data-label="Xref">pra</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.3<br>Chinese: !fu<br>Latin: solv.ere<br>Loglan: petci</td>
            </tr>

            <tr>
                <td data-label="Word">474</td>
                <td data-label="Class">t</td>
                <td data-label="Engl">Government</td>
                <td data-label="Phon">-</td>
                <td data-label="Definition"></td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.4<br>Chinese: -<br>Latin: -<br>Loglan: </td>
            </tr>

            <tr>
                <td data-label="Word">fyn</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">obligation</td>
                <td data-label="Phon">oblygaqn</td>
                <td data-label="Definition">X1 has a legal obligation to do activity (vo) X2+1</td>
                <td data-label="Comments">|gul for the rule and the authority or agency.</td>
                <td data-label="Xref">gul</td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.4<br>Chinese: |ben!fen<br>Latin: ofyky.um<br>Loglan: lilfa</td>
            </tr>

            <tr>
                <td data-label="Word">zina</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">nation, citizen</td>
                <td data-label="Phon">naiqn</td>
                <td data-label="Definition">X1 is a nation or state with citizens (xy) X2s</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.4<br>Chinese: /min/dzu<br>Latin: kyvytas<br>Loglan: poldi</td>
            </tr>

            <tr>
                <td data-label="Word">jimi</td>
                <td data-label="Class">p</td>
                <td data-label="Engl">army</td>
                <td data-label="Phon">armi</td>
                <td data-label="Definition">X1 is an army of nation X2</td>
                <td data-label="Comments"></td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.4<br>Chinese: !lu-ji#n<br>Latin: ekserkit.us<br>Loglan: narmi</td>
            </tr>

            <tr>
                <td data-label="Word">vei</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">tax</td>
                <td data-label="Phon">taks</td>
                <td data-label="Definition">X1 is taxed for activity (vo) X2+1 by agency X3 at rate (xu) X4</td>
                <td data-label="Comments">For tax on things: X2 is -ziu X or -bou X.  |pa for the amount.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.4<br>Chinese: !quei<br>Latin: vektigal<br>Loglan: cteki</td>
            </tr>

            <tr>
                <td data-label="Word">kei</td>
                <td data-label="Class">r</td>
                <td data-label="Engl">crime</td>
                <td data-label="Phon">kraim</td>
                <td data-label="Definition">(vo) X1+ is a crime</td>
                <td data-label="Comments">|gul for the law, |tue for the culture.</td>
                <td data-label="Xref"></td>
                <td data-label="Notes">Rank: <br>Thes: 4.7.4, 4.7.1<br>Chinese: !dzuei<br>Latin: skel.us<br>Loglan: tsime</td>
            </tr>

    </tbody>
</table>
