---
"title": "Mathematical Expressions"
---



<table width="100%">
  <tbody>
    <tr>
      <td align="center">
        <a href="conclusn.html">
        Next
        </a>
      </td>
      <td align="center">
        <a href="vocab1.html">
        Previous
        </a>
      </td>
      <td align="center">
        <a href="guarefmn.html">
        Contents
        </a>
      </td>
    </tr>
  </tbody>
</table>


 

* * *

## Mathematical Expressions

Even uneducated speakers quantify phrases, that is, they say how many or how big some phrase is. It turns out that to support just simple dimensioned quantities the language has to include a complete facility for mathematical expressions. 

### Numbers, Expressions and Functions

Cardinal numbers (here exemplified by _<span class="latex">cu</span>_ \- set of two) are defined as <span class="latex">X1 is a set containing so many members X2</span>. The converted predicate means <span class="latex">X2 is a member of a set X1 of so many members</span>. Quantifiers are subordinate clauses on an argument, e.g. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !cil |zu -cu ^ji /fi -vyl
        </i>
      </td>
      <td>
        My twins are male
      </td>
    </tr>
  </tbody>
</table>




How do you say <span class="latex">the number two</span>? Any set with two members can be put in 1-1 correspondence with any other such set, but not with a set with different count; this forms an equivalence relation that segregates sets by count. Among the ways to define <span class="latex">the number two</span> the one that fits best in _gua\spi_ is _<span class="latex">xu -cu</span>_ , designating this equivalence class. All kinds of mathematical objects, such as rational, real, complex and dimensioned numbers, can be produced by various extension maneuvers from these equivalence classes, and can be named in _gua\spi_ by _<span class="latex">xu -N</span>_. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        !xu -cu -cw -ci
        </i>
      </td>
      <td>
        The number 2.5 (the class of all sets of <span class="latex">count</span> 2.5)
      </td>
    </tr>
  </tbody>
</table>




Mathematical functions are defined with such classes as formal parameters, and hence have _<span class="latex">xu</span>_ on parameter cases by default --- _<span class="latex">xu</span>_ means the entire referent set of an argument, as a set (or class). The first case of a function is its value, and the function is defined as <span class="latex">X1 is in the equivalence class that comes from doing (function) on (_xu_) X2</span>, possibly with several parameters. Thus a function can be used to predicate that something has a particular count or measure. _<span class="latex">xu</span>_ recovers the equivalence class. The abbreviation <span class="latex">IEC</span>, meaning <span class="latex">in equivalence class</span>, is used thus: <span class="latex">X1 IEC the result of (whatever)</span>. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !xa -ca /plw !co ^cu
        </i>
      </td>
      <td>
        3 is the sum of 1 and 2 (all triplets
        IEC 1+2)
      </td>
    </tr>
  </tbody>
</table>




This syntax for mathematical expressions is neat, compact and unambiguous. No special syntax needs to be added to _gua\spi_ beyond that already in use for ordinary arguments and sentences. 

Functions always deliver their value in the first case and take arguments in the second and following cases. For the range and domain of a function F, use _<span class="latex">xu -F</span>_ and _<span class="latex">xu -zu -F</span>_ respectively. 

### Ordinal Numbers and List Ends

An ordinal number, cued by the quasidigit _<span class="latex">tr</span>_ , means <span class="latex">X1 is N'th in list (_xy_) X2 starting at X3</span>. For example: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i -brn !junu !qnou =ji |tio /ve -tr -ca
        </i>
      </td>
      <td>
        Broken is the third claw of my right paw (hand)
      </td>
    </tr>
  </tbody>
</table>




List ends and segments are built with <span class="latex">_bny_ -begin</span> and <span class="latex">_fne_ -end</span> restricted by a numeric predicate. Note the definition, <span class="latex">X1 is the next or previous member of (xy) X2 after X3</span>; restrict with a numeric predicate to change to the N'th next or previous member. Without X3 the list ends are produced, but don't be confused by the polarity: <span class="latex">_bny_ -next also means ``beginning</span> or <span class="latex">least</span> when the list is ordered by size or degree; <span class="latex">_fne_ -previous</span> means <span class="latex">end</span> or <span class="latex">most</span>. It is clearer to use an ordinal number when you can. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i |vi -pli ^jo /can -fne !psa -gvu
        </i>
      </td>
      <td>
        Please go to the end of the line
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !ji /bny |cu ^sty -kqa !diu -sui
        </i>
      </td>
      <td>
        I am the second smallest in the class
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !ji /tr -cu !sty -kqa !diu -sui
        </i>
      </td>
      <td>
        Same thing, better
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !bny |te -ca ^sty -bir !kuo |tum =teon ^ji
        /fi -za -gey |jro ^su -xo -spia
        </i>
      </td>
      <td>
        The first three people (in order by time) to phone me
        will be given tickets
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !tr -te -ca !sty -bir !kuo |tum =teon ^ji
        /fi -za -gey |jro ^su -xo -spia
        </i>
      </td>
      <td>
        Same thing, better
      </td>
    </tr>
  </tbody>
</table>




Lists are ordered with smaller or negative numbers first, so the <span class="latex">smallest</span> is _<span class="latex">bny -sty -kqa</span>_ whereas the largest would be _<span class="latex">fne -sty -kqa</span>_ or, sorting the list in reverse order, _<span class="latex">/bny !sty -spl</span>_. See also the discussion of <span class="latex">_sym_ -chief</span> under [Comparative and Superlative](../vocab2.html#sym-chief) for a better way to do <span class="latex">second smallest</span> and the like. 

### Vectors, Dates and Times

You express a vector as a <span class="latex">_stl_ -list</span> of expressions. Units of measure applied to a vector multiply each component individually. A matrix (by components) is a list of vectors, and so on. A date or time is also a list of expressions. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !vnyn /zm -cmu !dman ^dmem !stl !ci ^ca -cy
        </i>
      </td>
      <td>
        The wind is (5, 30) meters per second (per second meter 5, 30)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qo -kauai:i /jir !vdei !stl !co -ke ^kl -co -ci -ko
        </i>
      </td>
      <td>
        Hawaii is at (19, -156) degrees
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i -tem =jani !su -jn ^stl !co -ke -ka -ke ^cu ^co -ke
        </i>
      </td>
      <td>
        The date today is 2/19/1989 (order: year, month, day)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qo -kamleto /zu -fom |tem =qrau !stl !cu -cy ^ca -cy
        </i>
      </td>
      <td>
        Hamlet will be performed at 20:30 hours
      </td>
    </tr>
  </tbody>
</table>




The date is defined as <span class="latex">X1 is the date of event (vo) X2+ starting with unit (xu-jani) X3* in calendar X4</span> in which auto-conversion lets it restrict a sentence directly, while the unit can still be compounded. The first vector component has that unit, and subsequent components are multiplied by sub-units in the order years, months, days, hours, minutes, seconds. The default unit is <span class="latex">_jani_ -years</span>. 

### Units of Measure

Units of measure are defined to multiply a number or other expression by the unit. The resulting equivalence class is considered to contain _gua\spi_ events whose degree or measure are that big; hence the unit expression takes the form of a subordinate clause, and the main sentence predicate tells what dimension is being measured. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !ji /vga |kyam !ku -cy
        </i>
      </td>
      <td>
        I weigh 70 kilos (I heavy kilo 7 0)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !tor =cenu /cni !ti -kl -co -cw -cu -ka -kn -ku
        </i>
      </td>
      <td>
        The account balance is about minus 12.8 million dollars 
        ($ about -1.28E7)
      </td>
    </tr>
  </tbody>
</table>




<span class="latex">Scientific notation</span> is used in _gua\spi_ instead of the thousands and millions typical of English and in place of the metric prefixes; it is more compact and much easier to specify syntactically. 

This definition of a unit is reasonable mathematically since a physical unit of measure can be interpreted as a basis member of a 1-dimensional vector space of things having that dimension. For example, consider mass. Take the set of all things with mass, and take equivalence classes of things with equal mass. Those equivalence classes occupy, and can be extended to create, a 1-D vector space. Any single member is a basis, and a unit is a member selected by convention, e.g. _the_ standard kilogram. Now for the word, its referent could be the unit, but you have to multiply it by the number (e.g. 2.5 times grams), which makes expressions too wordy. So the unit word is defined as a math function that multiplies by the unit. 

In units of measure, the first argument occupants are not things but properties, e.g. masses of things, which are events, e.g. <span class="latex">something is massive</span>. The need for a predicate to go with the thing being measured is easiest to see in 3-D, e.g. the argument could be high, wide or deep but all are measured by the single dimension of meters. Then the unit becomes a modal case of the predicate. These examples show how to use MKS and provincial units: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !ji /gal |dmem !co-cw-ku-ce
        </i>
      </td>
      <td>
        I am 1.74 meters high
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !ji /gal |xnu -fn -:inca !ko-ke
        </i>
      </td>
      <td>
        I am 69 inches high
      </td>
    </tr>
  </tbody>
</table>




In particular, no quantifiable relation (e.g. <span class="latex">heavy</span> or <span class="latex">exceeds in dimension _vo_ X3</span>) has an explicit case for how much it is, relying instead on the modal case of units. There is one exception: <span class="latex">_kun_ -quantity</span> is like a unit in providing a modal case for quantity, but provides an identity transformation, so that a question word can be dropped into the multiplicand argument without forcing a specific unit. 

To talk about the unit rather than to use it, use _<span class="latex">xu vo <unit></span>_, as in <span class="latex">the pound is a provincial unit</span>. _<span class="latex">xe vo <unit></span>_ will deliver the standard unit, if there is one, given suitable context cues. 

Compound units, like ohms, require a product or quotient of several units. One may use the personal name units (ohm, volt, pascal, celsius) in the same manner as provincial units. 

## Quantification and Negation

### Some Important Quantifiers

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        <u>
        xa
        </u>
        -tara
        </i>
      </td>
      <td>
        <em>
        All
        </em>
        rats (anywhere, any time)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        <u>
        xa -xe
        </u>
        -tara
        </i>
      </td>
      <td>
        <em>
        All
        </em>
        the rats (in an in-mind set)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        <u>
        xa
        </u>
        -tara |xyn !dowu
        </i>
      </td>
      <td>
        <em>
        All
        </em>
        the rats in the house
      </td>
    </tr>
    <tr>
      <td>
        <i>
        <u>
        xi
        </u>
        -tara |xyn !dowu
        </i>
      </td>
      <td>
        <em>
        Most
        </em>
        of the rats in the house
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tara
        <u>
        |zu -vdu
        </u>
        </i>
      </td>
      <td>
        <em>
        Many
        </em>
        rats
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tara
        <u>
        |zu -pqu
        </u>
        </i>
      </td>
      <td>
        <em>
        Few
        </em>
        rats
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tara
        <u>
        |gou -sun
        </u>
        </i>
      </td>
      <td>
        <em>
        Enough
        </em>
        rats
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tara
        <u>
        |gr -gou -sun
        </u>
        </i>
      </td>
      <td>
        <em>
        Too few
        </em>
        rats
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tara
        <u>
        |gou -pqu
        </u>
        </i>
      </td>
      <td>
        <em>
        Few enough
        </em>
        rats
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tara
        <u>
        |gr -gou -pqu
        </u>
        </i>
      </td>
      <td>
        <em>
        Too many
        </em>
        rats (insufficiently few)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tara |zu
        <u>
        -ti-ta
        </u>
        -cu-cy-cy
        </i>
      </td>
      <td>
        <em>
        Almost
        </em>
        a hundred rats
      </td>
    </tr>
    <tr>
      <td>
        <i>
        <u>
        jmo
        </u>
        -vjr
        </i>
      </td>
      <td>
        <em>
        Almost
        </em>
        vertical
      </td>
    </tr>
    <tr>
      <td>
      </td>
    </tr>
  </tbody>
</table>




### Words for Something

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !ji /crw |bir
        </i>
      </td>
      <td>
        I already ate (
        <em>
        something
        </em>
        implied)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !ji /daw -crw
        <u>
        !jy
        </u>
        </i>
      </td>
      <td>
        I want to eat
        <em>
        something
        </em>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !ji /crw
        <u>
        !xo
        </u>
        -kseo
        </i>
      </td>
      <td>
        I am eating
        <em>
        some cheese
        </em>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !jw /vdr !xy
        <u>
        -jy
        </u>
        |kfa /vu -sny
        </i>
      </td>
      <td>
        Logically, he must have
        <em>
        some
        </em>
        family (a set)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i
        <u>
        !xi -jy
        </u>
        ^:u -xun !vo !zglo /gr -zu -gul ^vo !zglo /qma -tfa
        </i>
      </td>
      <td>
        <em>
        Most things
        </em>
        are illegal or fattening
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i
        <u>
        !xa -jy
        </u>
        |vdr !xo -sto -fw -kaia  . . .
        </i>
      </td>
      <td>
        For
        <em>
        anything
        </em>
        in a compact set  . . .
      </td>
    </tr>
  </tbody>
</table>




### Nine Varieties of Negation

_^:i _-sfa_ !kio !ji ^tara |zey !ju_
     _It is false_ that I have your rat. This is the prototype of negation, and it is the policy in _gua\spi_ to use predicates when possible rather than prefixes or other structure words. However, the negated sentence is an extra level down, a problem for speakers. 
_^:i _-go_ !ji /kio !tara |zey !ju_
     I _don't_ have your rat. _<span class="latex">go</span>_ is a mood prefix which means that the asserted sentence is counter to fact. It is simpler and more familiar to natural language speakers than <span class="latex">_sfa_ -false</span> is, and it works in subordinate clauses where _<span class="latex">sfa</span>_ doesn't. 
_^:i !ji /kio !tara _|go_ -zey !ju_
    I have a rat which _isn't_ yours. _<span class="latex">go</span>_ can equally be used in subordinate clauses, or even in argument predicates. 
_^:i !ji /kio _!xn_ -kseo_
     I have _no_ cheese. _<span class="latex">xn</span>_ means that of the members of the full referent set of the argument, none fit in the predicated relation. Unlike the rest of the articles, this is actually a statement about the excluded members, and means the same as _<span class="latex">^:i !ji _/go_ -kio !xa -kseo</span>_ \--- freely translated, <span class="latex">for all pieces of cheese, I don't have it</span>. (See De Morgan's rules below.) 
_^:i !ji /kio !kseo _|zu -cy__
     I have _zero_ pieces of cheese. This is the most natural form of argument negation in _Loglan_ , but _gua\spi_ looks strictly at referent sets, and if you say you have all the members of the null set, it isn't a cheesy null set --- there is only one null set. The statement is a tautology, and says nothing about cheese. Many logical fallacies, such as St. Anselm's ontological proof of the existence of God, are like this example in that they prove a statement about the members of a set which may not have any members. In _gua\spi_ use _<span class="latex">xn</span>_ as above. 
_^:i !ji /kio _!ple_ !tara_
     I have something which _isn't_ the rat. The full referent set of _<span class="latex">ple !xe -tara</span>_ (and therefore its referent subset) is in the complement of the referent subset of _<span class="latex">xe -tara</span>_. 
_^:i !jw |kseo /fi _-stu_ -zao_
     This cheese is _bad_ in flavor. In George Orwell's 1984, the language <span class="latex">newspeak</span> was designed to destroy the ability of people to think, and one of its design features was that negative words were eliminated; <span class="latex">bad</span> became <span class="latex">ungood</span>. _Gua\spi_ (imitating _Loglan_) offers specific negated words for major predicates when the negations are used frequently. Nonetheless, most negations will have to be done with compound words as in the next examples. Be alert for creative expression possibilities such as _<span class="latex">^:i !jw |kseo !fu _-zu -dyi_ </span>_ \--- <span class="latex">this cheese is _disgusting_ </span>. 
_^:i !jw |kseo !fu _/gl_ -zao_
     This cheese is flavor _less_. Many dimensions are quantifiable (more or less) but unsigned, so their degree ranges from zero to larger values. This is how to assert that the degree is zero or negligible. 
_^:i !jw |kseo !fu _/gr_ -ksi_
     This cheese is _not_ fresh. When the dimension ranges from positive to negative values, _<span class="latex">gr</span>_ interchanges positive and negative. On occasion, _<span class="latex">gl</span>_ will also apply to indicate the zero point, though it is meaningless with <span class="latex">_ksi_ -fresh</span>. For extremes of unfreshness one can use <span class="latex">_fpu_ -rotten</span>. 
_^:i !jw |kseo /fi _-vry_ -can -psl_
     This cheese is _de_ solidifying. When a process occurs in the reverse of the usual order, <span class="latex">_vry_ -reverse</span> indicates this. 

### De Morgan's Rules in Quantification

Negation interacts with <span class="latex">and</span> and <span class="latex">or</span>, which necessarily occur in sentences which are quantified or whose arguments have multiple referents. Therefore it is advisable to digress into some elementary symbolic logic. Here is De Morgan's rule for negation, stated four ways: (A and B are sentences) 

> 

<table>
  <tbody>
    <tr>
      <td align="right">
        A
      </td>
      <td>
        and
      </td>
      <td align="right">
        B
      </td>
      <td>
        = not(
      </td>
      <td align="right">
        (not A)
      </td>
      <td>
        or
      </td>
      <td align="right">
        (not B))
      </td>
    </tr>
    <tr>
      <td align="right">
        (not A)
      </td>
      <td>
        and
      </td>
      <td align="right">
        (not B)
      </td>
      <td>
        = not(
      </td>
      <td align="right">
        A
      </td>
      <td>
        or
      </td>
      <td align="right">
        B)
      </td>
    </tr>
    <tr>
      <td align="right">
        A
      </td>
      <td>
        or
      </td>
      <td align="right">
        B
      </td>
      <td>
        = not(
      </td>
      <td align="right">
        (not A)
      </td>
      <td>
        and
      </td>
      <td align="right">
        (not B))
      </td>
    </tr>
    <tr>
      <td align="right">
        (not A)
      </td>
      <td>
        or
      </td>
      <td align="right">
        (not B)
      </td>
      <td>
        = not(
      </td>
      <td align="right">
        A
      </td>
      <td>
        and
      </td>
      <td align="right">
        B)
      </td>
    </tr>
  </tbody>
</table>




Remember that in logic, <span class="latex">A or B</span> is true if one or _both_ of the statements is true, unlike in English where the <span class="latex">or</span> generally excludes both being true. 

Universal quantification means a statement is true when applied to all members of a set, of the form <span class="latex">S1 and S2 and S3 and . . .</span>, where S1 is the statement applied to member 1 and so on. Existential quantification means that a statement is true about at least one set member, in form <span class="latex">S1 or S2 or S3 or . . .</span> When such statements are negated, De Morgan's rule applies. Here are some more specific examples. 

_^:i -kio !ji ^kseo_
     I have the cheese. This will be the basic example sentence. Let us make the existential quantification more explicit: 
_^:i -kio !ji ^kseo |zu -to_
     I have at least one piece of cheese. Existential quantification like this means the same as <span class="latex">I have piece 1 _or_ I have piece 2 _or_ . . .</span> for all pieces of cheese. Now the simplest negation of this sentence is simply: 
_^:i -sfa !kio !ji ^kseo |zu -to_
     It is false that I have at least one piece of cheese. This form does not suit typical speakers; we want to negate the relation word <span class="latex">_kio_ -possess</span>, not the whole sentence, like this: 
_^:i !ji _/go_ -kio !xa -kseo_
     I don't have any cheese --- I don't have piece 1 _and_ I don't have piece 2 _and_ . . . To negate (or de-negate) a disjunction (compound sentence with <span class="latex">or</span>), we had to change <span class="latex">or</span> to <span class="latex">and</span>, producing a universal quantification. The same principle applies when you start with a universal: 
_^:i !xa -xe -cil /jir_
     All the children are here --- Child 1 is here _and_ child 2 is here _and_ . . . Rather than negating the whole sentence with <span class="latex">_sfa_ -false</span>, let us negate the predicate <span class="latex">_jir_ -here</span>: 
_^:i -go -jir !cil _|zu -to__
     At least one of the children is not here --- Child 1 is not here _or_ child 2 is not here _or_ . . . In general, when you negate the predicate of a sentence involving quantification or multiple argument referents of any kind, you will also have to reverse the type of quantification or conjunction used. 

## Sentence Forms

### Moods and Imperatives

These are the mood prefixes in _gua\spi_ , which indicate the manner of assertion of a phrase. A top level sentence has _<span class="latex">ge</span>_ on it by default unless another mood prefix appears. 

> 

<table width="100%">
  <colgroup>
  <col width="10%"/>
  <col width="45%"/>
  <col width="45a%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ge
        </i>
      </td>
      <td colspan="2">
        Asserted to be real or factual
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !vo
        <u>
        -ge
        </u>
        -dae !kara !fu -bal !crw |jro ^tara ^kseo
        </i>
      </td>
      <td>
        If the box is open,
        <em>
        which it is,
        </em>
        then the rat could eat the cheese
      </td>
    </tr>
    <tr>
      <td>
        <i>
        gi
        </i>
      </td>
      <td colspan="2">
        Potentially true; actual truth is irrelevant
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !vo -ge -dae !kara !fu -bal
        <u>
        !gi
        </u>
        -crw |jro ^tara ^kseo
        </i>
      </td>
      <td>
        If the box is open then the rat
        <em>
        could
        </em>
        eat the cheese
      </td>
    </tr>
    <tr>
      <td>
        <i>
        go
        </i>
      </td>
      <td colspan="2">
        Unreal or counter to fact
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        -go
        </u>
        !ji /kio !tara |zey !ju
        </i>
      </td>
      <td>
        I
        <em>
        don't
        </em>
        have your rat
      </td>
    </tr>
    <tr>
      <td>
        <i>
        gu
        </i>
      </td>
      <td colspan="2">
        Hypothetical; reality is irrelevant
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ji
        <u>
        /gu
        </u>
        -fli ^:o -sar
        <u>
        !gu
        </u>
        -vlw !ji ^qyun
        </i>
      </td>
      <td>
        If I
        <em>
        could
        </em>
        fly I
        <em>
        would
        </em>
        go to the moon
      </td>
    </tr>
  </tbody>
</table>




Closely related to the mood prefixes is the aspect operator <span class="latex">_tri_ -ritual</span>, a sign of a performative phrase. <span class="latex">Performative</span> means that by uttering the words the speaker makes something true, as in a marriage vow or the illustrated naming ceremony. Note that auto-conversion is suppressed by _<span class="latex">zo</span>_ ; without it, the sentence would merely be the topic of a ceremony, not the ceremony itself. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i
        <u>
        |zo -tri
        </u>
        ^qo -ben /zu -xim !jw |cil
        </i>
      </td>
      <td>
        (Performative:) Ben is the name of this child
      </td>
    </tr>
  </tbody>
</table>




In English there is an imperative mood; however, in _gua\spi_ you make a sentence imperative by using <span class="latex">_jo_ -you</span> or <span class="latex">_ja_ -we</span> in the case for the actor, generally the first. These pronouns are distinguished from the non-imperative <span class="latex">_ju_ -you</span> and <span class="latex">_je_ -we</span>. A decoration <span class="latex">_pli_ -please</span> softens the command. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i |faw ^vu -qnu !qo -josefo /jo /qma -duw !gunu !ju
        </i>
      </td>
      <td>
        Josepho, move your ass!
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i |vi -pli ^jo /pin -dwo
        </i>
      </td>
      <td>
        Please be patient.
      </td>
    </tr>
  </tbody>
</table>




### Special Features of Infinitives

In an infinitive the previous argument is replicated by default as the infinitive's first argument, while the first argument of a subordinate clause comes normally from the restricted phrase. Hence numbered cases skip over the first argument, and you must use the caselink _<span class="latex">so</span>_ for any explicit first case in an infinitive or subordinate clause. In an infinitive with _<span class="latex">vo</span>_ a predicate is made out of the sub-sentence that follows, including arguments and clauses. In the rare case where a sub-phrase (like a subordinate clause) must go on the infinitive predicate rather than into the sub-sentence, you can put a prefix before _<span class="latex">vo</span>_ , like an article, and put the clause between the article and _<span class="latex">vo</span>_. 

When an infinitive with _<span class="latex">vo</span>_ is an argument, the main sentence asserts the relation of arguments to the infinitive's events, but does not make a separate assertion of those events. To additionally assert or deny the sub-phrase, use _<span class="latex">ge</span>_ or _<span class="latex">go</span>_ respectively. For example: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !qo -kira /juy -xna !do ^qnou !xgno
        </i>
      </td>
      <td>
        Kira allows it to hold his hand (offers --- but
        instead it swims away --- infinitive not asserted)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !do /qou !qo -kira ^ge -qma -za -pai !cana ^ve -tum =tuen
        </i>
      </td>
      <td>
        It watches as Kira bails (drains) the boat with a bucket (infinitive
        is also asserted)
      </td>
    </tr>
  </tbody>
</table>




###  Comparative and Superlative

Natural languages have various complicated arrangements to change a simple property to become comparative or superlative. _Gua\spi_ does it with a predicate. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !X1 /qaw -xgi !X2
        </i>
      </td>
      <td>
        X1 is equally green as X2
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !X1 /gre -xgi !X2
        </i>
      </td>
      <td>
        X1 is more green than X2
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !X1 /sym -xgi !X2
        </i>
      </td>
      <td>
        X1 is (one of) the greenest
        member(s) of set X2
      </td>
    </tr>
  </tbody>
</table>




In the case of <span class="latex">_sym_ -superlative</span> it is possible for several members to be equally green, each being greener than the remaining members. Also, a numeric predicate modifying _<span class="latex">sym</span>_ produces the N'th greenest member. Here are some sentences with comparatives and superlatives: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !star -fn -siriu ^qo -prosyon /gre -xgm
        </i>
      </td>
      <td>
        The star Sirius is brighter than Procyon
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qo -jupiter /sym -kqa !stel
        </i>
      </td>
      <td>
        Jupiter is the largest planet
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qo -siriu /sym -xgm |cu ^xu -star
        |vu -sen !zu -jrer \hfil
        <br/>
        ^:i !qo -siriu /fne |cu ^sty -xgm !xu -star
        </i>
      </td>
      <td>
        Sirius is the second brightest of all stars, as seen
        from Earth (two ways)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qo -siriu /sym -xgm !tei !star ^qo -sol
        </i>
      </td>
      <td>
        Sirius is the brightest star except for the Sun
      </td>
    </tr>
  </tbody>
</table>




### Causal Sentence Connectives

_^:i !tara /crw !kseo ^:o _-kau_ !gai -tuol !kseo_
     The rat eats the cheese, and that _causes_ it to be dirty. A cause is rather mechanical. Actors with free will are rarely caused to do anything, despite their protestations. Here the rat may have free will, but the cheese, caused to be dirty, certainly does not. 
_^:i !ji /gri !tara ^kai |kei ^kseo ^:o _-kmo_ !qma -qtu !ji ^tara_
     I am angry at the rat for stealing the cheese, which _motivates_ me to kill the rat. The theft motivates the anger and the anger motivates the planned killing. When a free agent acts it is usually because of a motivation. Here the speaker includes <span class="latex">_kei_ -crime</span> in the sentence as a justification for his action. The definition of this word reminds you that it has the modal case <span class="latex">_tue_ -culture</span>, which presumably includes the speaker --- but not the rat. 
_^:i !xi -tara /qai -crw |jro ^kseo ^:o _-zu -zni_ !vel !klo ^kseo_
     So that rats cannot eat the cheese, is the _reason_ the cheese is in a closed container. A reason is an end (ending event) or consequence that _motivates_ someone to make a starting event happen, such as keeping the cheese in the box, that will _cause_ the consequence. The concept of <span class="latex">_zni_ -reason</span> is rather slippery. First, the desired or planned consequence should be stated, not its inverse; _<span class="latex">^:i !xo -tara /gi -crw !kseo</span>_ = <span class="latex">A rat might eat the cheese</span> is the negative of the correct consequence. Second, we say in English <span class="latex">past event Y is the reason for action Z</span> where the _gua\spi_ definition of <span class="latex">_zni_ -reason</span> requires <span class="latex">vengeance for past event Y</span> --- a future consequence of action Z. _<span class="latex">vou</span>_ = <span class="latex">vengeance</span>. Third, a <span class="latex">_gul_ -rule</span> can be said to _cause_ its reason, provided the obligees obey it. 
_^:i -dae !kara ^:o _-sny_ !pwo -cyr -xyn !xi -tara ^kara_
     The box being open _implies_ that a rat can go into it. The relation of logical entailment has to do with definitions and theorems, not with the arrangement of the real world or the will of its actors. <span class="latex">_zny_ -imply</span> is the corresponding set operator: <span class="latex">X1 is the union of X2 and the complement of X3</span>, where X2 and X3 can be infinitives with _<span class="latex">vo</span>_. Perhaps the distinction between _<span class="latex">sny</span>_ and _<span class="latex">zny</span>_ is merely an artifact of old _Loglan_ and English usage. We shall see if this is true as _gua\spi_ matures. 
_^:i -dae !kara ^:o _-bal_ !crw |jro ^tara ^kseo_
     If the box is open _then maybe_ the rat will eat the cheese. This kind of fuzzy inference based on real-world consequences is what people use most often, rather than pure logic. 
_^:i !ji _/gu_ -fli ^:o _-sar !gu_ -vlw !ji ^qyun_
     _If_ I could fly I _would_ go to the moon. Necessary conditions are very commonly expressed and the logical <span class="latex">if-then</span> catches their true meaning poorly. Related is <span class="latex">_sno_ -sufficient</span>. 

These are the sentence connectives most often seen. But the speaker may connect sentences with any useful word having suitable cases. And like all _gua\spi_ words, the sentence connectives can also be useful as arguments and as modal caselinks. 

### Logical Sentence Connectives

Old _Loglan_ was intended to be a <span class="latex">logical language</span>, thereby to differ as much as possible from English. Therefore, one of its key features is support for what amounts to spoken symbolic logic. This feature is de-emphasized in _gua\spi_ ; in practice, what language users encounter most often, and stumble over, are Cartesian expansion of multiple arguments, non-commutative quantification, and complicated negations. These topics are well-supported in _gua\spi_. Nonetheless, set arithmetic can be performed on infinitives and the result is a set of events to which the listener's attention is drawn, just as with a more normal sentence. The logician's <span class="latex">if-then</span> can be realized through _<span class="latex">zny</span>_. Here are some examples of logical sentence connectives: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i
        <u>
        !xun
        </u>
        !vo !ji /crw !ftu =plyw /vo !ji /crw !ftu =peir
        </i>
      </td>
      <td>
        I eat an apple
        <em>
        or
        </em>
        I eat a pear (or both, per logic)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !ji /crw !ftu
        <u>
        !xun
        </u>
        !plyw ^peir
        </i>
      </td>
      <td>
        I eat a fruit of the apple
        <em>
        or
        </em>
        pear tree (better sentence)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i
        <u>
        !zny
        </u>
        !vo !xa -fma /zu -bor !cy /vo !fma /bor !jy
        </i>
      </td>
      <td>
        <em>
        If
        </em>
        a shape has void boundary
        <em>
        then
        </em>
        it is
        itself the boundary of something
      </td>
    </tr>
  </tbody>
</table>




## Features of Thesaurus Categories

The _gua\spi_ words have been put into groups with related meanings, for ease of learning and for ease of creation. The dictionary includes a thesaurus of these categories. Many categories have closely related cases, or certain special features, which are described below. 

### Abstract Comparisons

Many abstract comparisons (1.1.1) and set member words (1.1.3) include a dimension on which comparison occurs. In a compound with the dimension as sub-word, its cases merge in an unusual manner. Considering the dimension to be single-ended (e.g. a color, as opposed to a directional property), its first case is applied to several arguments as noted in the definitions, e.g. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !X1 /qaw -xgi !X2
        </i>
      </td>
      <td>
        X1 is equally green as X2
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !X1 /gre -xgi !X2
        </i>
      </td>
      <td>
        X1 is more green than X2
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !X1 /sym -xgi !X2
        </i>
      </td>
      <td>
        X1 is (one of) the greenest
        member(s) of set X2
      </td>
    </tr>
  </tbody>
</table>




<span class="latex">_xgi_ -green</span> is applied to both X1 and X2 in the first and second sentence. This is described as a <span class="latex">dual merge</span>. In the last sentence, <span class="latex">_xgi_ -green</span> is applied to X1 and to members of X2. The dictionary indicates all these special merges. 

<span class="latex">_stl_ -list</span> involves a dimension which is applied pairwise to members of the list, indicating the ordering. 

<span class="latex">_qaw_ -equally</span> has a very unusual definition: the first case is an infinitive into whose first case the rest of the cases are copied in turn; the predicate means that all the arguments fit in the infinitive equally. Normally the predicate of this infinitive is provided by compounding, as in the example above. 

### Sets

For several words in category 1.1.2 (sets) of the form <span class="latex">(set) X1 is a (whatever)</span>, you can make a compound _<span class="latex">vdr =W</span>_ to get the members. 

When _<span class="latex">xy</span>_ (in-mind set) is the default article for a case, then if the referents are sets the default changes automatically to _<span class="latex">xe</span>_ (in-mind in extension). But _<span class="latex">xu</span>_ (whole set) does not change to _<span class="latex">xa</span>_ (same in extension) because in math functions the usual occupant of such a case is supposed to be a set of equal-count sets. 

The predicates <span class="latex">_tla_ -set</span> and <span class="latex">_stl_ -list</span> have a special arrangement of cases. They mean <span class="latex">X1 is a set (in extension) or list (ordered) consisting of members X2, X3, X4, . . .</span>, as many cases as needed. If X2 etc. have multiple referents in extension (which must be ordered for _<span class="latex">stl</span>_), all referents go in the set or list. Five or six words have this <span class="latex">as many as needed</span> argument list. 

### Properties

Noncomparative Properties are distinguished in _Loglan_ from the Comparative Properties in that it is not useful to say that X is more <whatever> than Y; for example, X is more dead than Y. For this reason _Loglan_ Comparative Properties each have a case for the compared item and Noncomparative Properties do not. Nonetheless, many of its members may actually be used comparatively (like <span class="latex">_ksu_ -delicious</span>) and the distinction is rather artificial. In _gua\spi_ , Properties do not have comparative arguments. 

Directional Properties (1.5): These are often compounded with motion words, in which the moving case is related to the destination. (Special case: <span class="latex">_tai_ -outside</span> merges with the start point. Examples in <span class="latex">Compound Words</span>.) Note that the polarity (e.g. up/down) in such compounds is often backwards from English. 

Timelike Directional Properties (1.5.3): These are the relation words for the tense modal case. 

### Behaviors

Abstract Behaviors(2.1): These have the form <span class="latex">X1 does (vo) X2+1</span>, in which X1 is automatically replicated as the first case of the infinitive _<span class="latex">vo X2</span>_. 

Double Actor Transitive Activities (2.1.3): These have the prototype <span class="latex">X1 makes X2 do (vo) X3+2</span>, in which X2 is automatically replicated as the first case of _<span class="latex">vo X3</span>_. 

Games for Two Players (2.1.4): Generally you will want to use a reciprocal construction like this, unless the relation really is unilateral: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !qo -jan ^fe -qo -mery /kul !vr -zdmo
        </i>
      </td>
      <td>
        John and Mary kissed each other
      </td>
    </tr>
  </tbody>
</table>




Motion Words (2.2): The prototype is <span class="latex">X1 goes to X2 (destination) from X3 (start point) via X4 (route)</span>. Since motion words are complicated, effort has been put in to make them all regular. They are very frequently combined with directional properties, q.v. 

Transitive Motion Words (2.2.3): The prototype is <span class="latex">X1 makes X2 go to X3 from X4 via X5</span>, and again they are all regular. Directional properties relate X2, the mover, with X3, the start point. 

Quasi-motions and Routes (2.2.4): The routes are set up as regular motion words. The quasi-motions can profitably be compounded with motion words. 

Communication and Mental Activity (2.3): The pattern <span class="latex">X1 knows that X2 is (vo) X3+2</span> is common, with X2 merging as the first case of X3. However, quite a few predicates in this category have different patterns, so watch out. 

Transitive Activities with an Object (2.4): A number of these words have an X3 case for a tool or means which is typically filled by a transitive compound, as in: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !ji /fey =cuem !kliw
        </i>
      </td>
      <td>
        I pound on the nail (hammer hit)
      </td>
    </tr>
  </tbody>
</table>




### Things and Materials

Animals and Plants (3.1): These have just one argument. The animals and plants category has been extended to include a primitive for each phylum, or at least most of them. 

Body Parts (3.2): These have the prototype <span class="latex">X1 is a (part) of creature X2*</span>. 

Materials (3.3): Almost all of these are of the form <span class="latex">(xo) X1 is a serving/portion of (material)</span>. The _<span class="latex">xo</span>_ appears by default when the word is used as an argument, unless the containing sentence provides a default article other than the usual _<span class="latex">xe</span>_. 

Places, Seasons and Weather (3.5): Places mostly have the form <span class="latex">X1 is a (place) of locality or superset X2</span>. 

Containers (4.1.1) and Cooking and Eating (4.1.2): These have the form <span class="latex">X1 is a container containing (xo) X2*</span>. Constructions like <span class="latex">spoonful</span> are handled with <span class="latex">_ful_ -contained quantity</span>, like this: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !ji /crw !ze -kme |ful =spun
        </i>
      </td>
      <td>
        I take a spoonful of medicine
      </td>
    </tr>
  </tbody>
</table>




Transport (4.1.4), Machines (4.1.5), and Parts of Structures (4.1.7): Many of these are like body parts: <span class="latex">X1 is a (part) of structure X2*</span>. 

Houses (4.1.8): House parts are as above. Houses themselves have the form <span class="latex">X1 is a (house) of resident X2*</span>. 

Cloth and Parts of Clothes (4.2.2): Parts are as above. Cloth has the form <span class="latex">(xo) X1 is a portion of (cloth)</span>. 

Food (4.3): Mostly of the form <span class="latex">(xo) X1 is a serving/portion of (food)</span>. 

Works of Art (4.4.1): All have the form <span class="latex">X1 is a (thing) about X2 created by X3 and performed by X4</span>. X2 may be an event or a thing; there is no _<span class="latex">vo</span>_ default. X4 is present only on relevant words such as <span class="latex">_jiul_ -drama</span>. 

### Miscellaneous Categories

Nationalities (4.7.1): _Loglan_ has words for nationalities, for the languages spoken there, and for the basis money unit of the nation. But only about fifteen arbitrarily chosen nations are supported, mainly European ones. _Gua\spi_ uses foreign names for these concepts, through <span class="latex">_zina_ -nation</span>, <span class="latex">_gua_ -language</span>, and <span class="latex">_cni_ -money</span>. <span class="latex">_spi_ -person</span> translates the usual self-referential word in primitive languages for ethnic members of that culture. 

Business (4.7.3): A number of these words have the form <span class="latex">X1 (sells) goods or services X2 to other trader X3 for amount of money (xu) X4</span>. 

## Most Frequent Words

So far, the corpus of _gua\spi_ text available for analysis consists of 3140 words of fiction representing a teenager setting up a small business and interacting with younger children, parents, customers and girlfriend. I originally wrote this story in _Loglan_ to test various features, and it is known that word frequencies will differ in other topics. However, this text gives some guidance about which words a beginner should be sure to learn. 

> 

<table width="100%">
  <colgroup>
  <col width="15%"/>
  <col width="15%"/>
  <col width="70%"/>
  </colgroup>
  <tbody>
    <tr>
      <th>
        Word
      </th>
      <th>
        Count
      </th>
      <th>
        Meaning
      </th>
    </tr>
    <tr>
      <td>
      </td>
      <td colspan="2">
        <b>
        Structure Words
        </b>
      </td>
    </tr>
    <tr>
      <td>
        :i
      </td>
      <td>
        259
      </td>
      <td>
        Sentence start
      </td>
    </tr>
    <tr>
      <td>
        zu
      </td>
      <td>
        89
      </td>
      <td>
        2nd case conversion
      </td>
    </tr>
    <tr>
      <td>
        ql
      </td>
      <td>
        55
      </td>
      <td>
        Speaker \leftrightarrow listener
      </td>
    </tr>
    <tr>
      <td>
        fi
      </td>
      <td>
        43
      </td>
      <td>
        Grammar to level zero
      </td>
    </tr>
    <tr>
      <td>
        va
      </td>
      <td>
        39
      </td>
      <td>
        Subordinate assertion
      </td>
    </tr>
    <tr>
      <td>
        sa
      </td>
      <td>
        35
      </td>
      <td>
        3rd caselink
      </td>
    </tr>
    <tr>
      <td>
        qo
      </td>
      <td>
        33
      </td>
      <td>
        Foreign name
      </td>
    </tr>
    <tr>
      <td>
        qa
      </td>
      <td>
        31
      </td>
      <td>
        Pop modal stack
      </td>
    </tr>
    <tr>
      <td>
        fe
      </td>
      <td>
        30
      </td>
      <td>
        Conjunction
      </td>
    </tr>
    <tr>
      <td>
        :a
      </td>
      <td>
        29
      </td>
      <td>
        Next sent in sequence
      </td>
    </tr>
    <tr>
      <td>
        qe
      </td>
      <td>
        28
      </td>
      <td>
        Stack modal default
      </td>
    </tr>
    <tr>
      <td>
        xo
      </td>
      <td>
        28
      </td>
      <td>
        Article <span class="latex">any</span>
      </td>
    </tr>
    <tr>
      <td>
        :e
      </td>
      <td>
        26
      </td>
      <td>
        Sentence conjunction
      </td>
    </tr>
    <tr>
      <td>
        :o
      </td>
      <td>
        24
      </td>
      <td>
        Retroactive downjump
      </td>
    </tr>
    <tr>
      <td>
        vo
      </td>
      <td>
        23
      </td>
      <td>
        Infinitive
      </td>
    </tr>
    <tr>
      <td>
        za
      </td>
      <td>
        21
      </td>
      <td>
        3rd case conversion
      </td>
    </tr>
    <tr>
      <td>
        gr
      </td>
      <td>
        18
      </td>
      <td>
        Linear negation
      </td>
    </tr>
    <tr>
      <td>
        gl
      </td>
      <td>
        17
      </td>
      <td>
        Polar negation
      </td>
    </tr>
    <tr>
      <td>
        xi
      </td>
      <td>
        17
      </td>
      <td>
        Article <span class="latex">typical</span>
      </td>
    </tr>
    <tr>
      <td>
        qi
      </td>
      <td>
        14
      </td>
      <td>
        Replace modal default
      </td>
    </tr>
    <tr>
      <td>
        vi
      </td>
      <td>
        14
      </td>
      <td>
        Attitude indicator
      </td>
    </tr>
    <tr>
      <td>
        fy
      </td>
      <td>
        13
      </td>
      <td>
        Retroactive downjump
      </td>
    </tr>
    <tr>
      <td>
        vu
      </td>
      <td>
        11
      </td>
      <td>
        Restrictive clause
      </td>
    </tr>
    <tr>
      <td>
        xa
      </td>
      <td>
        11
      </td>
      <td>
        Article <span class="latex">all</span>
      </td>
    </tr>
    <tr>
      <td>
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td colspan="2">
        <br/>
        <b>
        Pronouns
        </b>
      </td>
    </tr>
    <tr>
      <td <td="" do="">
        179
      </td>
      <td>
        Variables
      </td>
    </tr>
    <tr>
      <td>
        ji
      </td>
      <td>
        132
      </td>
      <td>
        Me
      </td>
    </tr>
    <tr>
      <td>
        ju
      </td>
      <td>
        77
      </td>
      <td>
        You
      </td>
    </tr>
    <tr>
      <td>
        jo
      </td>
      <td>
        48
      </td>
      <td>
        You (imperative)
      </td>
    </tr>
    <tr>
      <td>
        zgly
      </td>
      <td>
        24
      </td>
      <td>
        Previous sentence
      </td>
    </tr>
    <tr>
      <td>
        jw
      </td>
      <td>
        20
      </td>
      <td>
        Object being shown
      </td>
    </tr>
    <tr>
      <td>
        po
      </td>
      <td>
        17
      </td>
      <td>
        Yes-no question
      </td>
    </tr>
    <tr>
      <td>
        vgry
      </td>
      <td>
        15
      </td>
      <td>
        Question sentence
      </td>
    </tr>
    <tr>
      <td>
        jy
      </td>
      <td>
        10
      </td>
      <td>
        Anonymous variable
      </td>
    </tr>
    <tr>
      <td>
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td colspan="2">
        <br/>
        <b>
        Modal Cases
        <b>
        </b>
        </b>
      </td>
    </tr>
    <tr>
      <td>
        jai
      </td>
      <td>
        56
      </td>
      <td>
        Speaker and listener
      </td>
    </tr>
    <tr>
      <td>
        xim
      </td>
      <td>
        25
      </td>
      <td>
        Name
      </td>
    </tr>
    <tr>
      <td>
        bir
      </td>
      <td>
        23
      </td>
      <td>
        Past tense
      </td>
    </tr>
    <tr>
      <td>
        jro
      </td>
      <td>
        21
      </td>
      <td>
        Future tense
      </td>
    </tr>
    <tr>
      <td>
        gza
      </td>
      <td>
        18
      </td>
      <td>
        Paragraph
      </td>
    </tr>
    <tr>
      <td>
        bwy
      </td>
      <td>
        16
      </td>
      <td>
        Different
      </td>
    </tr>
    <tr>
      <td>
        cnu
      </td>
      <td>
        13
      </td>
      <td>
        Present tense
      </td>
    </tr>
    <tr>
      <td>
        pli
      </td>
      <td>
        13
      </td>
      <td>
        Please
      </td>
    </tr>
    <tr>
      <td>
        qnu
      </td>
      <td>
        13
      </td>
      <td>
        Pay attention
      </td>
    </tr>
    <tr>
      <td>
        faw
      </td>
      <td>
        12
      </td>
      <td>
        Emphatic
      </td>
    </tr>
    <tr>
      <td>
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td colspan="2">
        <br/>
        <b>
        Words in Compounds
        </b>
      </td>
    </tr>
    <tr>
      <td>
        qma
      </td>
      <td>
        45
      </td>
      <td>
        Transitive conversion
      </td>
    </tr>
    <tr>
      <td>
        can
      </td>
      <td>
        25
      </td>
      <td>
        Change to become
      </td>
    </tr>
    <tr>
      <td>
        co
      </td>
      <td>
        25
      </td>
      <td>
        Various digits
      </td>
    </tr>
    <tr>
      <td>
        fto
      </td>
      <td>
        14
      </td>
      <td>
        Such (more than usual)
      </td>
    </tr>
    <tr>
      <td>
        cyr
      </td>
      <td>
        13
      </td>
      <td>
        Go
      </td>
    </tr>
    <tr>
      <td>
        tai
      </td>
      <td>
        12
      </td>
      <td>
        Outside
      </td>
    </tr>
    <tr>
      <td>
        gre
      </td>
      <td>
        11
      </td>
      <td>
        More (comparative)
      </td>
    </tr>
    <tr>
      <td>
        kau
      </td>
      <td>
        11
      </td>
      <td>
        Cause (sent. conn.)
      </td>
    </tr>
    <tr>
      <td>
        pql
      </td>
      <td>
        11
      </td>
      <td>
        Only (less than usual)
      </td>
    </tr>
    <tr>
      <td>
        jur
      </td>
      <td>
        10
      </td>
      <td>
        Turn
      </td>
    </tr>
    <tr>
      <td>
        xyn
      </td>
      <td>
        8
      </td>
      <td>
        Inside
      </td>
    </tr>
    <tr>
      <td>
        zni
      </td>
      <td>
        8
      </td>
      <td>
        Reason (sent. conn.)
      </td>
    </tr>
    <tr>
      <td>
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td colspan="2">
        <br/>
        <b>
        Story Topic Words
        <b>
        </b>
        </b>
      </td>
    </tr>
    <tr>
      <td>
        tye
      </td>
      <td>
        16
      </td>
      <td>
        Adhere
      </td>
    </tr>
    <tr>
      <td>
        dowu
      </td>
      <td>
        15
      </td>
      <td>
        House
      </td>
    </tr>
    <tr>
      <td>
        kmaw
      </td>
      <td>
        15
      </td>
      <td>
        Shop
      </td>
    </tr>
    <tr>
      <td>
        cil
      </td>
      <td>
        14
      </td>
      <td>
        Child
      </td>
    </tr>
    <tr>
      <td>
        vem
      </td>
      <td>
        14
      </td>
      <td>
        Trouble
      </td>
    </tr>
    <tr>
      <td>
        crw
      </td>
      <td>
        13
      </td>
      <td>
        Eat
      </td>
    </tr>
    <tr>
      <td>
        jaiw
      </td>
      <td>
        13
      </td>
      <td>
        Eye
      </td>
    </tr>
    <tr>
      <td>
        tlme
      </td>
      <td>
        12
      </td>
      <td>
        Metal
      </td>
    </tr>
    <tr>
      <td>
        cun
      </td>
      <td>
        11
      </td>
      <td>
        Connect
      </td>
    </tr>
    <tr>
      <td>
        tiri
      </td>
      <td>
        10
      </td>
      <td>
        Tiger
      </td>
    </tr>
  </tbody>
</table>




* * *



<table width="100%">
  <tbody>
    <tr>
      <td align="center">
        <a href="conclusn.html">
        Next
        </a>
      </td>
      <td align="center">
        <a href="vocab1.html">
        Previous
        </a>
      </td>
      <td align="center">
        <a href="guarefmn.html">
        Contents
        </a>
      </td>
    </tr>
  </tbody>
</table>


 
