---
"title": "Vocabulary"
---



<table width="100%">
  <tbody>
    <tr>
      <td align="center">
        <a href="vocab2.html">
        Next
        </a>
      </td>
      <td align="center">
        <a href="semantic.html">
        Previous
        </a>
      </td>
      <td align="center">
        <a href="guarefmn.html">
        Contents
        </a>
      </td>
    </tr>
  </tbody>
</table>


 

* * *

# Vocabulary

A great deal of the machinery of language, which in natural languages is shared between the grammar and the vocabulary, is handled in _gua\spi_ purely by words. Here is an explanation of how to say a wide variety of basic language patterns. Frequently I have thought that some form or meaning required a new primitive word, or even a change in the grammar, but it has turned out that existing words were more than adequate if creatively used. Make this fact your prejudice in similar situations. 

A major difference between _gua\spi_ and Old _Loglan_ (and, I fear, _Lojban_) is that _Loglan_ relies heavily on metaphor and on the human ability to understand metaphors, whereas _gua\spi_ compound words mean what they do because specific rules say how words combine. To say it differently, the meaning of a _Loglan_ compound arises from wishful thinking, not from rules designed into the language. _Gua\spi_ can represent metaphors --- efficiently too. But in my _Loglan_ writings I found that about 90% of all compound words could be interpreted according to rules I uncovered in the definitions, which Jim Brown was following unconsciously. I expect that even more compounds will turn out to be lawful in _gua\spi_ , in which the definitions are tailored to make compounding easy, rather than taking the semantically slippery form of a true metaphor. 

## Functional Categories of Words

_Gua\spi_ words have a relation between function and morphology. The CV pattern is for structure words, a few pronouns, and digits. CVV is for <span class="latex">real</span> relations, what in English are verbs. CCV is for abstract <span class="latex">nouns</span>, normally used to denote objects. CCVV is used for more concrete <span class="latex">nouns</span> such as species, chemical elements, or household artifacts. The purpose of these assignments is to cater to the known proclivities of natural language speakers, who like to segregate nouns from verbs, and to simplify the process of making words for meanings. Nothing in the language depends on these assignments, and the language never actually distinguishes between nouns and verbs. If you find that some word has a morphological form other than what you expect, this is simply an effort to keep related words together, and it will have no effect on the efficiency of the language. 

Here is the distribution of _gua\spi_ words by functional and morphological category. There are 11 V's, and 14 regular C's. <span class="latex">:</span> is allowed only in CV words such as _<span class="latex">^:i</span>_ , and <span class="latex">#</span> does not count towards differences in words. There are 74 allowed CC digraphs out of 196 possible pairs; many CC's are too hard for people to recognize reliably. 

> 

<table>
  <tbody>
    <tr>
      <th>
        Category
      </th>
      <th>
        Form
      </th>
      <th>
        Quantity
      </th>
      <th>
        Total
      </th>
    </tr>
    <tr>
      <td>
        Prefixes
      </td>
      <td>
        CV
      </td>
      <td>
        61
      </td>
      <td>
        61
      </td>
    </tr>
    <tr>
      <td>
        Pronouns
      </td>
      <td>
        CV,CCVV
      </td>
      <td>
        54
      </td>
      <td>
      </td>
    </tr>
    <tr>
      <td>
        Digits
      </td>
      <td>
        CV
      </td>
      <td>
        26
      </td>
      <td>
      </td>
    </tr>
    <tr>
      <td>
        Other structure words
      </td>
      <td>
      </td>
      <td>
      </td>
      <td>
        80
      </td>
    </tr>
    <tr>
      <td>
        Primitives
      </td>
      <td>
        CVV
      </td>
      <td>
        568
      </td>
      <td>
      </td>
    </tr>
    <tr>
      <td>
        Primitives
      </td>
      <td>
        CCVV
      </td>
      <td>
        532
      </td>
      <td>
      </td>
    </tr>
    <tr>
      <td>
        Letterals
      </td>
      <td>
        CCVV
      </td>
      <td>
        104
      </td>
      <td>
      </td>
    </tr>
    <tr>
      <td>
        Predicates
      </td>
      <td>
      </td>
      <td>
      </td>
      <td>
        1410
      </td>
    </tr>
    <tr>
      <td>
        Total words
      </td>
      <td>
      </td>
      <td>
      </td>
      <td>
        1551
      </td>
    </tr>
  </tbody>
</table>




> 

<table>
  <tbody>
    <tr>
      <th>
        Form
      </th>
      <th>
        Used
      </th>
      <th>
        Available
      </th>
      <th>
        Fraction Used
      </th>
    </tr>
    <tr>
      <td>
        CV
      </td>
      <td>
        98
      </td>
      <td>
        165
      </td>
      <td>
        59%
      </td>
    </tr>
    <tr>
      <td>
        CCV
      </td>
      <td>
        206
      </td>
      <td>
        814
      </td>
      <td>
        25%
      </td>
    </tr>
    <tr>
      <td>
        CVV
      </td>
      <td>
        568
      </td>
      <td>
        1694
      </td>
      <td>
        34%
      </td>
    </tr>
    <tr>
      <td>
        CCVV
      </td>
      <td>
        679
      </td>
      <td>
        8954
      </td>
      <td>
        8%
      </td>
    </tr>
  </tbody>
</table>




## Word Creation

The words of natural languages appear to be arbitrary symbol strings of tremendous variety of sound. _Gua\spi_ is similar in that its words were generated by a partially random process. To begin, the word lists of _Loglan_ [L4] and _Lojban_ [Lja] were merged and some additional words were added. For most words an English, Chinese and Latin translation was determined. 

Then experimental phonetic data [NB2] was used to assess candidate words for the ease with which speakers could recognize them. For each _gua\spi_ meaning, randomly generated word candidates were evaluated for recognizability, for distance from other _gua\spi_ words, and also for similarity to their natural language equivalents. The final assignments were determined through a process of numerical annealing so as to maximize the summed quality scores. 

Because the words are modestly similar to their natural language counterparts, learners are helped a bit in remembering them; and the sound patterns are anchored to forms known to please humans, since a prior attempt with purely random sounds was unacceptably ugly. The base natural languages included English because it is very widely spoken, Chinese (Mandarin) for the same reason, and Latin as a proxy for the other European languages, all of which have been influenced heavily by Latin. (Latinoid English words were avoided.) Both _Loglan_ and _Lojban_ use many more natural languages as word creation fodder. 

CV structure words were assigned by hand; related structure words, like articles, have the same C and varying V's. Structure words pertaining to numbered cases have the same V's as the corresponding digits, but contrasting consonants, making learning easier. 

A question often asked is, why create new words? Why not use Chinese or English words? First, some attempt has been made to keep _gua\spi_ culturally neutral, and if Chinese words were used it would intimidate English speakers and vice versa. More important, Chinese words are designed for use with Chinese. Many required meanings, like articles, simply do not exist in Chinese, and similarly in English. And those meanings that are present are only approximations of the _gua\spi_ meanings; while users have to invest a lot of effort to learn the new words and their definitions, they will find it even harder to keep straight what a word of their native language <span class="latex">really</span> means in _gua\spi_. That is why the approach was rejected of simply stealing natural language vocabulary. 

Given some set, a <span class="latex">basis</span> is a subset from which all its members can be derived, as with vectors. Each vector space has a specific dimension, or number of basis elements, but words are not so simple. _Loglan_ has about 1000 primitive words and it was intended that virtually any meaning should be achievable as combinations of these words; that is, the primitive words form a basis of nearly all meanings. Experiment proved that this intention had been accomplished for the most part, but that as anticipated, some areas were incompletely or imprecisely covered. The _Lojban_ project of LeChevalier [Lja] is a continuation of Brown's work on _Loglan_ [L1], and he has added about 300 primitive words, mainly about human emotion and interaction. For _gua\spi_ I took over LeChevalier's primitive word list, with his kind assistance. I rewrote all the definitions to match _gua\spi_ usage. I also added and deleted a small number of words to deal with specific _gua\spi_ issues, and I expanded the scientific vocabulary in mathematics, chemistry, zoology, botany and agriculture. As a result, _gua\spi_ has about 1400 primitive words. Some people are interested to discover just how few basis words we can get by with. However, I have experience with the _Loglan_ word list and I have confidence in its ability to handle the required meanings; and while I do not believe it is minimal, I think it is fairly close. Thus I chose to use existing word lists for _gua\spi_ rather than to try for radical pruning or _de novo_ creation. 

## Words and Grammar

###  Phrase-Relative Pronouns

The CCVV pattern is used for organized groups of noun-type words such as the phrase-relative pronouns. These words have a CCV part and a final V, which matches the V in the caselink and the conversion for the same case, as well as the corresponding digit. 

> 

<table>
  <tbody>
    <tr>
      <th>
        1st part
      </th>
      <th>
        Phrase where antecedent of pronoun is located
      </th>
    </tr>
    <tr>
      <td>
        zdm
      </td>
      <td>
        Phrase that pronoun is in
      </td>
    </tr>
    <tr>
      <td>
        xdr
      </td>
      <td>
        Phrase restricted by phrase containing pronoun
      </td>
    </tr>
    <tr>
      <td>
        vgr
      </td>
      <td>
        Phrase to which replies are directed
      </td>
    </tr>
    <tr>
      <td>
        xgn
      </td>
      <td>
        Enclosing main-level sentence
      </td>
    </tr>
    <tr>
      <td>
        zgl
      </td>
      <td>
        Previous main-level sentence
      </td>
    </tr>
    <tr>
      <th>
        Last letter
      </th>
      <th>
        Which case is represented
      </th>
    </tr>
    <tr>
      <td>
        o
      </td>
      <td>
        1st case
      </td>
    </tr>
    <tr>
      <td>
        u
      </td>
      <td>
        2nd case
      </td>
    </tr>
    <tr>
      <td>
        a
      </td>
      <td>
        3rd case
      </td>
    </tr>
    <tr>
      <td>
        e
      </td>
      <td>
        4th case
      </td>
    </tr>
    <tr>
      <td>
        i
      </td>
      <td>
        5th case
      </td>
    </tr>
    <tr>
      <td>
        y
      </td>
      <td>
        The whole phrase
      </td>
    </tr>
    <tr>
      <td>
      </td>
    </tr>
  </tbody>
</table>




Here is a list of all the phrase-relative pronouns. There is also _<span class="latex">zgln</span>_ meaning <span class="latex">the previous discourse in general</span> and _<span class="latex">zglr</span>_ meaning <span class="latex">the event just finished or still continuing</span>. 

> 

<table>
  <tbody>
    <tr>
      <th>
        Phrase
      </th>
      <th>
        1
      </th>
      <th>
        2
      </th>
      <th>
        3
      </th>
      <th>
        4
      </th>
      <th>
        5th
      </th>
      <th>
        Case (converted) of phrase . . .
      </th>
    </tr>
    <tr>
      <td>
        <i>
        zdmy
        </i>
      </td>
      <td>
        <i>
        zdmo
        </i>
      </td>
      <td>
        <i>
        zdmu
        </i>
      </td>
      <td>
        <i>
        zdma
        </i>
      </td>
      <td>
        <i>
        zdme
        </i>
      </td>
      <td>
        <i>
        zdmi
        </i>
      </td>
      <td>
        That the pronoun is in
      </td>
    </tr>
    <tr>
      <td>
        <i>
        xdry
        </i>
      </td>
      <td>
        <i>
        xdro
        </i>
      </td>
      <td>
        <i>
        xdru
        </i>
      </td>
      <td>
        <i>
        xdra
        </i>
      </td>
      <td>
        <i>
        xdre
        </i>
      </td>
      <td>
        <i>
        xdri
        </i>
      </td>
      <td>
        Being restricted
      </td>
    </tr>
    <tr>
      <td>
        <i>
        xgny
        </i>
      </td>
      <td>
        <i>
        xgno
        </i>
      </td>
      <td>
        <i>
        xgnu
        </i>
      </td>
      <td>
        <i>
        xgna
        </i>
      </td>
      <td>
        <i>
        xgne
        </i>
      </td>
      <td>
        <i>
        xgni
        </i>
      </td>
      <td>
        Enclosing top level sentence
      </td>
    </tr>
    <tr>
      <td>
        <i>
        zgly
        </i>
      </td>
      <td>
        <i>
        zglo
        </i>
      </td>
      <td>
        <i>
        zglu
        </i>
      </td>
      <td>
        <i>
        zgla
        </i>
      </td>
      <td>
        <i>
        zgle
        </i>
      </td>
      <td>
        <i>
        zgli
        </i>
      </td>
      <td>
        Previous top level sentence
      </td>
    </tr>
    <tr>
      <td>
        <i>
        vgry
        </i>
      </td>
      <td>
        <i>
        vgro
        </i>
      </td>
      <td>
        <i>
        vgru
        </i>
      </td>
      <td>
        <i>
        vgra
        </i>
      </td>
      <td>
        <i>
        vgre
        </i>
      </td>
      <td>
        <i>
        vgri
        </i>
      </td>
      <td>
        Question to be answered
      </td>
    </tr>
  </tbody>
</table>




### Letterals

Letterals are words representing letters, which are built up on a regular pattern like the pronouns are. A letteral means <span class="latex">X1 is an instance of the letter (whatever)</span>. _<span class="latex">zu -fma !xo - <letteral></span>_ is the right way to say that something has the shape of a letter. To spell a word, compound the letters start to end. The result means <span class="latex">X1 is an instance of something spelled (whatever)</span>. 

Among letterals there are different forms for V's and C's, and upper and lower case in two alphabets are supported. The first table shows stem forms arranged phonetically, while the second shows what to substitute for the asterisks to signal alphabets and cases. 

> 

<table width="75%">
  <tbody>
    <tr>
      <td>
        p
      </td>
      <td>
        <i>
        psl*
        </i>
      </td>
      <td>
        f
      </td>
      <td>
        <i>
        fsl*
        </i>
      </td>
      <td>
        b
      </td>
      <td>
        <i>
        bzl*
        </i>
      </td>
      <td>
        v
      </td>
      <td>
        <i>
        vzl*
        </i>
      </td>
      <td>
        m
      </td>
      <td>
        <i>
        **lm
        </i>
      </td>
      <td>
        u
      </td>
      <td>
        <i>
        **lu
        </i>
      </td>
    </tr>
    <tr>
      <td>
        t
      </td>
      <td>
        <i>
        tfl*
        </i>
      </td>
      <td>
        s
      </td>
      <td>
        <i>
        sfl*
        </i>
      </td>
      <td>
        d
      </td>
      <td>
        <i>
        dvl*
        </i>
      </td>
      <td>
        z
      </td>
      <td>
        <i>
        zvl*
        </i>
      </td>
      <td>
        n
      </td>
      <td>
        <i>
        **ln
        </i>
      </td>
      <td>
        o
      </td>
      <td>
        <i>
        **lo
        </i>
      </td>
    </tr>
    <tr>
      <td>
        c
      </td>
      <td>
        <i>
        cfl*
        </i>
      </td>
      <td>
        q
      </td>
      <td>
        <i>
        qfl*
        </i>
      </td>
      <td>
        j
      </td>
      <td>
        <i>
        jvl*
        </i>
      </td>
      <td>
        x
      </td>
      <td>
        <i>
        xvl*
        </i>
      </td>
      <td>
        l
      </td>
      <td>
        <i>
        **rl
        </i>
      </td>
      <td>
        i
      </td>
      <td>
        <i>
        **li
        </i>
      </td>
    </tr>
    <tr>
      <td>
        k
      </td>
      <td>
        <i>
        kfl*
        </i>
      </td>
      <td>
      </td>
      <td>
        <i>
        </i>
      </td>
      <td>
        g
      </td>
      <td>
        <i>
        gvl*
        </i>
      </td>
      <td>
      </td>
      <td>
        <i>
        </i>
      </td>
      <td>
        w
      </td>
      <td>
        <i>
        **lw
        </i>
      </td>
      <td>
        y
      </td>
      <td>
        <i>
        **ly
        </i>
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
      </td>
      <td>
        e
      </td>
      <td>
        <i>
        **le
        </i>
      </td>
      <td>
        :
      </td>
      <td>
        <i>
        :zla
        </i>
      </td>
      <td>
        #
      </td>
      <td>
        <i>
        #vla
        </i>
      </td>
      <td>
        r
      </td>
      <td>
        <i>
        **lr
        </i>
      </td>
      <td>
        a
      </td>
      <td>
        <i>
        **la
        </i>
      </td>
    </tr>
  </tbody>
</table>




To select cases and alphabets, use these for * or **: 

> 

<table width="60%">
  <colgroup>
  <col width="25%"/>
  <col width="25%"/>
  <col width="25%"/>
  <col width="25%"/>
  </colgroup>
  <tbody>
    <tr>
      <th align="LEFT">
        *
      </th>
      <th align="LEFT">
        **
      </th>
      <th align="LEFT">
        Alphabet
      </th>
      <th align="LEFT">
        Case
      </th>
    </tr>
    <tr>
      <td>
        a
      </td>
      <td>
        bx
      </td>
      <td>
        Roman
      </td>
      <td>
        Lower
      </td>
    </tr>
    <tr>
      <td>
        e
      </td>
      <td>
        dx
      </td>
      <td>
        Roman
      </td>
      <td>
        Upper
      </td>
    </tr>
    <tr>
      <td>
        y
      </td>
      <td>
        vx
      </td>
      <td>
        Greek
      </td>
      <td>
        Lower
      </td>
    </tr>
    <tr>
      <td>
        o
      </td>
      <td>
        zx
      </td>
      <td>
        Greek
      </td>
      <td>
        Upper
      </td>
    </tr>
  </tbody>
</table>




The relation of Greek letters to _gua\spi_ Roman letters is basically phonetic; the arbitrary assignments below are marked by <span class="latex">*</span>. The <span class="latex">:</span> can be used for the aspiration mark, an apostrophe in Greek or <span class="latex">h</span> in English transliteration, as in <span class="latex">Hellas</span>. In principle one can also use a form like _<span class="latex">tler -fn -:alfa</span>_ (the letter alpha) to refer to Greek letters. 

> 

<table width="100%">
  <colgroup>
  <col width="4%"/>
  <col width="12%"/>
  <col width="4%"/>
  <col width="12%"/>
  <col width="4%"/>
  <col width="12%"/>
  <col width="4%"/>
  <col width="12%"/>
  <col width="4%"/>
  <col width="12%"/>
  <col width="4%"/>
  <col width="12%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        p
      </td>
      <td>
        Pi
      </td>
      <td>
        f
      </td>
      <td>
        Phi
      </td>
      <td>
        b
      </td>
      <td>
        Beta
      </td>
      <td>
        v
      </td>
      <td>
        Psi*
      </td>
      <td>
        m
      </td>
      <td>
        Mu
      </td>
      <td>
        u
      </td>
      <td>
        Upsilon
      </td>
    </tr>
    <tr>
      <td>
        t
      </td>
      <td>
        Tau
      </td>
      <td>
        s
      </td>
      <td>
        Sigma
      </td>
      <td>
        d
      </td>
      <td>
        Delta
      </td>
      <td>
        z
      </td>
      <td>
        Zeta
      </td>
      <td>
        n
      </td>
      <td>
        Nu
      </td>
      <td>
        o
      </td>
      <td>
        Omicron
      </td>
    </tr>
    <tr>
      <td>
        c
      </td>
      <td>
        Chi*
      </td>
      <td>
        q
      </td>
      <td>
        Theta*
      </td>
      <td>
        j
      </td>
      <td>
        ---
      </td>
      <td>
        x
      </td>
      <td>
        Xi*
      </td>
      <td>
        l
      </td>
      <td>
        Lambda
      </td>
      <td>
        i
      </td>
      <td>
        Iota
      </td>
    </tr>
    <tr>
      <td>
        k
      </td>
      <td>
        Kappa
      </td>
      <td>
      </td>
      <td>
      </td>
      <td>
        g
      </td>
      <td>
        Gamma
      </td>
      <td>
      </td>
      <td>
      </td>
      <td>
        w
      </td>
      <td>
        Omega*
      </td>
      <td>
        y
      </td>
      <td>
        Eta
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
      </td>
      <td>
        e
      </td>
      <td>
        Epsilon
      </td>
      <td>
        :
      </td>
      <td>
        '
      </td>
      <td>
        #
      </td>
      <td>
        ---
      </td>
      <td>
        r
      </td>
      <td>
        Rho
      </td>
      <td>
        a
      </td>
      <td>
        Alpha
      </td>
    </tr>
  </tbody>
</table>




In English we use acronyms freely, but in _gua\spi_ the letterals for the acronym are as long or longer than the words themselves. It is better to make an ordinary compound word for the concept. 

### Foreign Words

It is the policy in _gua\spi_ to use foreign words as-is (except for necessary mangling to make them fit the CV pattern), to represent the names of foreign people, places, flora, fauna, units of measure, foods, clothes, and so on. Certain of these word categories have a few members assigned CCV words. These are in _gua\spi_ because they were in _Loglan_ , and they were in _Loglan_ because they occurred with high frequency in European literature. In _Loglan_ it has proven impractical to manufacture in-language primitive words for every possible primitive, not for lack of word space but rather because those working on the language have other issues to attend to than making a continuous stream of predicates. For example, such an obvious animal as <span class="latex">bear</span> didn't make it into _Loglan_ and probably never will. _Gua\spi_ will have primitive words for more fauna and flora, but as in _Loglan_ , the majority of species will never have _gua\spi_ primitive words, and neither will most ethnic foods, foreign countries, provincial units and so on. 

When foreign words fit neatly into the language, speakers are tempted to over-use them. Agglutinative languages like _gua\spi_ and _Loglan_ have great power to produce compound words with quite precise meanings, and speakers should try very hard to learn to produce such words. It is a fact that despite _Loglan_ 's limited set of nouns and, at that time, its lack of foreign words, I was able to write about 20,000 words of text while inventing only four unapproved primitive words (and a fifth was made for me after the fact): bear, torus, tape, noodle and oar. Speakers of _gua\spi_ should try to emulate this performance and to use foreign words only for truly local concepts, such as the <span class="latex">|mu</span> (a Chinese area unit for land) or <span class="latex">adobo</span> (a Filipino chicken stew). 

See the discussion under [Pronouns: Foreign Words](../pronouns.html#c-foreign) about attaching foreign words to _gua\spi_ predicates to provide cases. 

### Retroactive Downjumps

Sentences are usually connected by a retroactive downjump _<span class="latex">^:o</span>_. With this operator the preceeding sentence is taken out of the discourse and is inserted in the first case of the word following _<span class="latex">^:o</span>_ (which will need a default _<span class="latex">vo</span>_). Thus the following two sentences are equivalent: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i -dae !kara ^:o -bal !crw |jro ^tara ^kseo
        </i>
      </td>
      <td>
        If the box is open then maybe the rat will eat the cheese
        (With retroactive downjump)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !vo -ge -dae !kara !fu -bal !crw |jro ^tara ^kseo
        </i>
      </td>
      <td>
        (With explicit infinitive)
      </td>
    </tr>
  </tbody>
</table>




The form with the explicit infinitive is more natural in _gua\spi_. When retroactive downjumps are allowed you have to finish an entire sentence structure and hear the next word, possibly a downjump, before you can place the structure in the parse tree. However, all natural languages allow afterthought sentence connectives as in the above examples, and speakers rarely use forethought forms where the beginning of the antecedent sentence is marked. I wonder if users might resist an absolute requirement to put _<span class="latex">!vo -ge</span>_ at the beginning of the antecedent sentence. 

Speakers, please try to minimize the use of retroactive downjumps. We shall see if it is feasible to outlaw them completely. 

Since the antecedent sentence starts out at the top level, it is asserted by default and remains thus after the downjump. The consequent sentence is an ordinary infinitive, which is not asserted. If you wish to assert it, or the antecedent when not using the retroactive downjump, put in a _<span class="latex">ge</span>_ prefix as shown for the explicit infinitive antecedent. 

A sentence start word _<span class="latex">^:u</span>_ connects sentences with coordinated arguments, and such a group acts as a unit for retroactive downjumps. _<span class="latex">^:e</span>_ also makes such units, but the arguments are not coordinated. More complicated groupings are best handled by making explicit infinitive arguments out of the component sentences and using _<span class="latex">ge</span>_ to assert them, or by assigning names to the sentences and subsequently asserting a causal relation among the antecedents of the names. 

The retroactive downjump _<span class="latex">fy</span>_ relocates the sub-phrase before it at the same level, to become the first case of the following predicate at the same level. It roughly translates the infix <span class="latex">and</span> that connects a list of arguments in English. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !tara /crw !kseo ^fy -tla !qkao |spl /ftu =plyw
        </i>
      </td>
      <td>
        The rat eats the cheese
        <em>
        and
        </em>
        the cookie
        <em>
        and
        </em>
        the apple 
        (an unordered set)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !ji /vlw !qo -:nuarko ^fy -stl !qo -trentn ^qo -prinstn
        </i>
      </td>
      <td>
        I travelled to Newark
        <em>
        and
        </em>
        Trenton
        <em>
        and
        </em>
        Princeton (an ordered list)
      </td>
    </tr>
  </tbody>
</table>




This is one way to do multiple arguments (see also the section [just below](../vocab1.html#conjunctions)), and is just about the only use for _<span class="latex">fy</span>_ \--- but difficult for hard-core English speakers to give up. Needless to say, the retroactive downjump is not mandatory. <span class="latex">_tla_ -set</span> is used when the arguments form an unordered collection, while <span class="latex">_stl_ -list</span> is for arguments that have a sequence. Both words take as many arguments as you wish. 

When a sentence is complicated, one can use <span class="latex">_fl_ -begin</span> and <span class="latex">_fr_ -end</span> to mark the beginning and end of a grammatical unit. A matching pair of _<span class="latex">fl</span>_ and _<span class="latex">fr</span>_ are supposed to be at the same grammatical level; if they are not, someone has made an error. They have no meaning beyond this checking function. 

### Error Correction

Another organizational transformation related to the retroactive downjump is error correction with _<span class="latex">fa</span>_. When prefixed to a phrase, it causes the previous phrase at the same level to vanish and to be replaced by the one that follows. _<span class="latex">/fi -fa</span>_ is a quick way to delete the current sentence. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !ji /vyu !gunu !ju /fa !diu -sui |zu -ken !ju
        </i>
      </td>
      <td>
        I like your ass, I mean, your class
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i -po !ju /crw !ftu =plyw |zey !ji /fi -fa
        </i>
      </td>
      <td>
        Did you eat my apple . . . Forget it.
      </td>
    </tr>
  </tbody>
</table>




## Subphrase Forms

###  Conjunctions, Mixtures and Masses

The conjunction _<span class="latex">fe</span>_ has several functions depending on what it joins. First, when it joins phrase predicates it makes a collection of phrases with the same arguments; usually it is unseen in this function since the first tone <span class="latex">-</span> is usually sufficient to cue a parallel phrase compound. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !jo
        <u>
        /cyr
        </u>
        <u>
        -tai
        </u>
        !sa-kqua
        </i>
      </td>
      <td>
        Everyone
        <em>
        get out
        </em>
        of the water
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qu -jaiw =tiri /cur -cie
        <u>
        !qka
        </u>
        <u>
        -pne
        </u>
        !qno =cail
        </i>
      </td>
      <td>
        Tigereye cuts a
        <em>
        hole through
        </em>
        the piece of steel
      </td>
    </tr>
  </tbody>
</table>




Despite our monkeylike eagerness to treat these words as units, we should remember that in _gua\spi_ there are phrases being conjoined. Thus everyone is told to go from the water _and_ to be out of the water; and the result of cutting is both a hole _and_ goes through the steel; the referent of this argument satisfies two predicates. 

_<span class="latex">fe</span>_ also can join arguments. The first of the following examples shows a conjunction with _<span class="latex">fe</span>_ in which successive arguments are joined into one. (For details, see [Semantics: Cartesian Expansion](../semantic.html#S-conjunction).) The second example shows the same sentence rendered with <span class="latex">_tla_ -set</span> in which the set members are listed. _<span class="latex">fe</span>_ produces referents only in extension whereas _<span class="latex">tla</span>_ produces a set in suitable context. There is a similar word <span class="latex">_stl_ -list</span> when the arguments must have a specific order. For both words you may give as many arguments as you need. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !kmau ^fe -kani /crw !tara ^fe -gara
        </i>
      </td>
      <td>
        The cat and the cow eat the rat and the grass
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !tla !kmau ^kani /fi -crw !tla !tara ^gara
        </i>
      </td>
      <td>
        (The same with sets)
      </td>
    </tr>
  </tbody>
</table>




Here is a particularly troublesome example of <span class="latex">or</span> in a set of arguments: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i |vi -pli ^jo /sle !xo -zu -co ^xo -psuw =fiei 
        ^fe -xo -psuw =cawi ^fe -xo -qkmy
        </i>
      </td>
      <td>
        Coffee, tea or milk?  (Please choose one from the list)
      </td>
    </tr>
  </tbody>
</table>




Mixtures are expressed in several ways. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !faia !do /fi -gai !xy -fpyl |sew !fkl ^qki
        </i>
      </td>
      <td>
        Its face was covered by blue-gray fur --- in the overlap (
        <i>
        sew
        </i>
        ) between
        blue and gray
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !flyl /zar !dvr ^vba ^fkl
        </i>
      </td>
      <td>
        The flag is red, white and blue --- some parts in each color (
        <i>
        zar
        </i>
        )
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !jw /dmy !qkmy ^qtaw |zu -dma !xo -bimi
        </i>
      </td>
      <td>
        This is a mixture (
        <i>
        dmy
        </i>
        ) of milk and honey (sugar from bees)
      </td>
    </tr>
  </tbody>
</table>




_Loglan_ has a concept of a <span class="latex">mass individual</span>. According to Brown [L1] it is more characteristic of non-Western cultures. Here is my best explanation of it. Take the full referent set of an argument, and personify it so that, potentially at least, it is the same kind of thing as its members. For example, all sharks can be considered to be instances or manifestations of an archetypical shark god. This composite object is the mass individual. In _Loglan_ , arguments in the <span class="latex">serving or portion</span> category, like <span class="latex">_cutri_ -water</span>, generally are used as mass individuals. 

Concepts and features which in other languages seem unitary are revealed in _gua\spi_ to be various. The mixtures above are one example, and mass individuals are another. Here are some examples related to mass individuals. Note that _<span class="latex">xo</span>_ is the default first case article for servings and portions and so in argument sites with the normal default you need not say _<span class="latex">xo</span>_. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        !xo -kqua
        </i>
      </td>
      <td>
        A portion of water (any one)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        !xe -kqua
        </i>
      </td>
      <td>
        The portion of water
      </td>
    </tr>
    <tr>
      <td>
        <i>
        !xe -psu -kqua
        </i>
      </td>
      <td>
        The water molecule
      </td>
    </tr>
    <tr>
      <td>
        <i>
        !xy -fpyl
        </i>
      </td>
      <td>
        The hair (set)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        !xy -sur -fpyl
        </i>
      </td>
      <td>
        The fur (emphasizing repetition)
      </td>
    </tr>
  </tbody>
</table>




### Named Arguments

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !qo -:mobi -dyk /kqnu |bir ^sa -qo -german -:melvyl
        </i>
      </td>
      <td>
        <em>
        Moby Dick
        </em>
        was written by Herman Melville
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qu -jaiw =tiri /fom !qu -kmaw =za -tye =tlme |va -zo -kqnu !sa -ji
        </i>
      </td>
      <td>
        Tigereye is a character in
        <em>
        The Welding Shop,
        </em>
        which I wrote
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qu -gua |xim !cfle /vu -zu -ziu !sa -kmi =xi -kmum 
        /fi -pror |bir ^sa -xu -tla !qo -krnygan ^qo -:ryci
        </i>
      </td>
      <td>
        <em>
        The <span class="latex">C</span> Programming Language
        </em>
        was written by Kernighan and Ritchie
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !qu -vo -tri -qtu =jy /zu -xim !xgnl |qe -zo -zymu !sa -qo -gabriel -fora
        </i>
      </td>
      <td>
        <em>
        Requiem
        </em>
        by Gabriel Faurï¿½ (title on the score)
      </td>
    </tr>
  </tbody>
</table>




<span class="latex">Moby Dick</span> is a bit ambiguous; it names both the book and the whale in it. The fault lies with the author for using one name for two referents. In any case, it is obvious what a foreign name means when referring to an object or a person. In the second example we have two _gua\spi_ predicate names, conveniently all compound words so that they feel the same as the foreign names. But in the third example the predicate name is quite intricate, extends over three grammatical levels, and includes an imbedded name, <span class="latex">C</span>, represented by a letteral. Nonetheless the principle is the same; _<span class="latex">qu</span>_ converts the following phrase into a name. 

The fourth example is perhaps the most difficult: the declaration of a title. The title is not part of the discourse but rather tells about it, hence it takes the form of a decoration with _<span class="latex">vi</span>_ in a nonsentence. With it the by-line appears in the usual form for setting a modal case default. 

### Modal Cases

Here are examples of the most important modal cases. However, virtually any word with two or more cases can be construed as a modal operator. Be alert for creative opportunities for expression. 

<table width="100%">
  <colgroup>
  <col width="10%"/>
  <col width="45%"/>
  <col width="45%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        cnu
        </i>
      </td>
      <td colspan="2">
        Present tense
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ji /za -ven !su -fkar ^vu
        <u>
        -cnu
        </u>
        !jrn !ji ^pra !fkar
        </i>
      </td>
      <td>
        I will buy the car
        <em>
        when
        </em>
        I have earned its price
      </td>
    </tr>
    <tr>
      <td>
        <i>
        bir
        </i>
      </td>
      <td colspan="2">
        Past tense
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ji /crw !kseo ^vu
        <u>
        -bir
        </u>
        !jun -vnl !tara
        </i>
      </td>
      <td>
        I ate the cheese
        <em>
        before
        </em>
        the rat came hunting
      </td>
    </tr>
    <tr>
      <td>
        <i>
        jro
        </i>
      </td>
      <td colspan="2">
        Future tense
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ji /qma -klo !kara ^vu
        <u>
        -jro
        </u>
        !crw !tara ^kseo |zu -vel !kara
        </i>
      </td>
      <td>
        I closed the box
        <em>
        after
        </em>
        the rat ate the cheese in it
      </td>
    </tr>
    <tr>
      <td>
        <i>
        jir
        </i>
      </td>
      <td colspan="2">
        The location of an event
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ji /fom !zu -plu
        <u>
        |jir
        </u>
        !pil -fn -:olimpu
        </i>
      </td>
      <td>
        I performed in the Olympic games, the games
        <em>
        at
        </em>
        Mount Olympus
      </td>
    </tr>
    <tr>
      <td>
        <i>
        zey
        </i>
      </td>
      <td colspan="2">
        Genitive or possessive case: a relation of pertinence
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !trer =ji /dri !fkar
        <u>
        |zey
        </u>
        !ji
        </i>
      </td>
      <td>
        My brother is driving
        <em>
        my
        </em>
        car
      </td>
    </tr>
    <tr>
      <td>
        <i>
        jai
        </i>
      </td>
      <td colspan="2">
        The speaker
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |jai
        </u>
        !qo -kira /ju /dwu -csn -zu -jeu
        </i>
      </td>
      <td>
        <em>
        Said
        </em>
        Kira, <span class="latex">You're a monster</span>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        koy
        </i>
      </td>
      <td colspan="2">
        The thinker, analogous to the speaker
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |koy
        </u>
        !qo -kira /dri -fli /bni -siw -dan |qma
        </i>
      </td>
      <td>
        <em>
        Thought
        </em>
        Kira, <span class="latex">The pilot needs to be rescued</span>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        qnu
        </i>
      </td>
      <td colspan="2">
        Vocative case: the listener paying attention
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |qnu
        </u>
        !qo -jan /tara /jun !kseo !zey !ju
        </i>
      </td>
      <td>
        <em>
        John,
        </em>
        the rat is after your cheese
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ciw
        </i>
      </td>
      <td colspan="2">
        The holder of a subjective opinion
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !xi -tara /fpl
        <u>
        |ciw
        </u>
        !ji
        </i>
      </td>
      <td>
        Rats are beautiful, I
        <em>
        feel
        </em>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        gae
        </i>
      </td>
      <td colspan="2">
        The experiencer of an emotion (most have a case for this)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ju /csn
        <u>
        |gae
        </u>
        !ji
        </i>
      </td>
      <td>
        You're wierd, I
        <em>
        feel
        </em>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        sen
        </i>
      </td>
      <td colspan="2">
        The experiencer of an objective sensation
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ftu -plyw /qke
        <u>
        |sen
        </u>
        !ji
        </i>
      </td>
      <td>
        The apple tastes [is] sour
        <em>
        to me
        </em>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        brm
        </i>
      </td>
      <td colspan="2">
        What something is part of (many parts have a case for this)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        -xo -bryr
        <u>
        |brm
        </u>
        !dowu !ji
        </i>
      </td>
      <td>
        A brick
        <em>
        of
        </em>
        my house
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tum
        </i>
      </td>
      <td colspan="2">
        The instrument for doing an event
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !qo -kira /qma -pai !cana
        <u>
        ^vu
        </u>
        <u>
        -tum
        </u>
        !tuen
        </i>
      </td>
      <td>
        Kira bailed the boat [made it drain]
        <em>
        with
        </em>
        the bucket
      </td>
    </tr>
    <tr>
      <td>
        <i>
        zia
        </i>
      </td>
      <td colspan="2">
        The way or manner of an event
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !xau =spa |cana /fi -fli
        <u>
        |zia
        </u>
        !fli !xi -bryr
        </i>
      </td>
      <td>
        The space shuttle (roundtrip spaceship) flies
        <em>
        like
        </em>
        a brick (flies)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        fta
        </i>
      </td>
      <td colspan="2">
        A standard or rule
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !xo -dair |xnu -syry -fn -:ameri-ka !co -ce /fi -pwo !ze -flu
        |xnu -fn -:ampere !co -cy ^fi
        <u>
        -vu
        </u>
        <u>
        -fta
        </u>
        !za -gul 
        !xi -tyil ^se -zina
        </i>
      </td>
      <td>
        A wire of 14 AWG [American Wire Gauge] can carry 15 amperes
        <em>
        according to
        </em>
        the National Electrical Code
      </td>
    </tr>
    <tr>
      <td>
        <i>
        vrl
        </i>
      </td>
      <td colspan="2">
        The reference frame
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !guna /xbr
        <u>
        |vrl
        </u>
        !qura |va -jmo -vjr
        </i>
      </td>
      <td>
        The snake is horizontal
        <em>
        relative to
        </em>
        the branch, which is
        almost vertical
      </td>
    </tr>
    <tr>
      <td>
        <i>
        plm
        </i>
      </td>
      <td colspan="2">
        Such as: an example
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        -xi -pso
        <u>
        |psi
        </u>
        ^vu -plm !xi -kai |kei
        </i>
      </td>
      <td>
        Bad people
        <em>
        such as
        </em>
        thieves
      </td>
    </tr>
  </tbody>
</table>


 There are several moderately complex cases, such as <span class="latex">_tue_ -culture</span>, and <span class="latex">_fta_ -standard for judgement</span>, which are relevant to only four or five words each. These are served by modal cases as a matter of policy, rather than having numbered cases on each word. 

### Tenses and Aspects

In English and all Indo-European languages, every sentence has a tense, that is, the syntax indicates (with great complexity) when the sentence occurred. Stories, for example, frequently have every narrative sentence in the past tense. _Gua\spi_ uses instead the modal case default for tense, and explicit tense modal cases appear only for sentences off the default. The sentence start word _<span class="latex">^:a</span>_ links sentences that occur in sequence. Here are some example sentences with tenses. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !tara /crw !kseo ^vu
        <u>
        -cnu
        </u>
        !vn -juw -qana
        </i>
      </td>
      <td>
        The rat ate the cheese
        <em>
        at
        </em>
        midnight
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !tara /crw !qkao -spl ^vu
        <u>
        -jro
        </u>
        !xdry !su -kseo
        </i>
      </td>
      <td>
        The rat ate the cookie
        <em>
        after
        </em>
        [it ate] the cheese
      </td>
    </tr>
    <tr>
      <td>
        <i>
        <u>
        ^:a
        </u>
        !kmau /crw !tara
        </i>
      </td>
      <td>
        <em>
        Then
        </em>
        the cat ate the rat
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i
        <u>
        |qe
        </u>
        <u>
        -bir
        </u>
        |fto ^jn /vu -qe -jro |pql ^cyr -xyn !qo
        -kaesar ^qo -gal
        </i>
      </td>
      <td>
        A long time ago, Caesar had just entered Gaul 
        (a nonsentence, it asserts nothing but does set the tense
        default)
      </td>
    </tr>
  </tbody>
</table>




In Russian, every verb is formally assigned an <span class="latex">aspect</span>: <span class="latex">perfective</span>, meaning that the sentence's event is considered as a unit, including its completion, and <span class="latex">imperfective</span>, meaning that the predicated relation is continuous. English has these aspects too, though each verb can have either aspect depending on a moderately complicated syntactic cue (<span class="latex">ing</span> for imperfective and various others for perfective). Speakers also like to distinguish a <span class="latex">completed</span> versus <span class="latex">aborted</span> aspect, whether an event reached its usual conclusion. In _gua\spi_ the unmodified predicates are perfective or imperfective according to their meanings, but subordinate clauses or compounding words can express whatever aspects are necessary. Here are a few aspects in _gua\spi_ : 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !xo -kqua
        <u>
        /tiu
        </u>
        -flu !se -bil !bryo
        </i>
      </td>
      <td>
        Water
        <em>
        continuously
        </em>
        flows under the bridge (imperfective)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !tara /crw
        <u>
        |scu
        </u>
        ^kseo
        </i>
      </td>
      <td>
        The rat
        <em>
        completely
        </em>
        eats the cheese (perfective)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !kmau
        <u>
        /qem
        </u>
        -jun -xna !tara
        </i>
      </td>
      <td>
        The cat
        <em>
        tries to
        </em>
        catch the rat (might or might not
        succeed)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !kmau
        <u>
        /qai
        </u>
        -jun -xna !tara
        </i>
      </td>
      <td>
        The cat
        <em>
        fails to
        </em>
        catch the rat  (though it tries)
      </td>
    </tr>
  </tbody>
</table>




### Decorations

A decoration is a short subordinate clause. Sometimes it expresses the speaker's attitude about the sentence or the relation between sentences, in which case its prefix is _<span class="latex">vi</span>_ , or it can be a subordinate assertion with _<span class="latex">va</span>_ , or an actual part of the main assertion, with _<span class="latex">vu</span>_ or <span class="latex">|</span> tone. 



<table width="100%">
  <colgroup>
  <col width="10%"/>
  <col width="45%"/>
  <col width="45%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        bwy
        </i>
      </td>
      <td colspan="2">
        On the other hand; Contrast
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ji /pql -gal ^:i
        <u>
        |vi -zo -bwy
        </u>
        ^ji /bzu
        </i>
      </td>
      <td>
        I am short;
        <em>
        on the other hand
        </em>
        , I am wide.
      </td>
    </tr>
    <tr>
      <td>
        <i>
        smy
        </i>
      </td>
      <td colspan="2">
        Similarly, Likewise
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ji /jie -crw ^:e
        <u>
        |vi -zo -smy
        </u>
        ^ji /jie -byw
        </i>
      </td>
      <td>
        I am hungry, and likewise I am thirsty
      </td>
    </tr>
    <tr>
      <td>
        <i>
        csn
        </i>
      </td>
      <td colspan="2">
        Strangely
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |vi -csn
        </u>
        ^tara /go -crw !kseo
        </i>
      </td>
      <td>
        <em>
        Strangely
        </em>
        , the rat didn't eat the cheese
      </td>
    </tr>
    <tr>
      <td>
        <i>
        spo
        </i>
      </td>
      <td colspan="2">
        Maybe
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |spo
        </u>
        ^kqu /zu -vel !kara -zgy |zey =ji
        </i>
      </td>
      <td>
        <em>
        Maybe
        </em>
        food is in my refrigerator
      </td>
    </tr>
    <tr>
      <td>
        <i>
        zba
        </i>
      </td>
      <td colspan="2">
        Likely
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |zba
        </u>
        /fpu !kqu |zu -vel !kara -zgy |zey =ji
        </i>
      </td>
      <td>
        <em>
        Probably
        </em>
        the food in my refrigerator is spoiled
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tfn
        </i>
      </td>
      <td colspan="2">
        Importantly
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |vi -zo -tfn
        </u>
        ^jo /ser -sui
        </i>
      </td>
      <td>
        <em>
        Importantly
        </em>
        , you must study
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tsu
        </i>
      </td>
      <td colspan="2">
        Suddenly
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i |qe -jai !do
        <u>
        ^ve -tsu
        </u>
        ^ve -fto -faw . . .
        </i>
      </td>
      <td>
        He says
        <em>
        suddenly
        </em>
        and very emphatically . . .
      </td>
    </tr>
    <tr>
      <td>
        <i>
        jiw
        </i>
      </td>
      <td colspan="2">
        Surprise
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |va -jiw
        </u>
        ^cana -fer /vnl
        </i>
      </td>
      <td>
        <em>
        Hey,
        </em>
        the barge is coming
      </td>
    </tr>
    <tr>
      <td>
        <i>
        pli
        </i>
      </td>
      <td colspan="2">
        Please
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |vi -pli
        </u>
        ^jo /pin -dwo
        </i>
      </td>
      <td>
        Please be patient
      </td>
    </tr>
    <tr>
      <td>
        <i>
        gny
        </i>
      </td>
      <td colspan="2">
        Kindly
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |vi -gny
        </u>
        ^jo /gey !xo -kqua ^ji
        </i>
      </td>
      <td>
        <em>
        Kindly
        </em>
        give me some water
      </td>
    </tr>
    <tr>
      <td>
        <i>
        faw
        </i>
      </td>
      <td colspan="2">
        Exclamation Point
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |faw
        </u>
        ^jw /pei -bil !ji ^kqua
        </i>
      </td>
      <td>
        He dunked me!
      </td>
    </tr>
    <tr>
      <td>
        <i>
        din
        </i>
      </td>
      <td colspan="2">
        Do Back
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i |ql ^jo /pei -bil !jw
        <u>
        |din
        </u>
        /kqua
        </i>
      </td>
      <td>
        So dunk him
        <em>
        back
        </em>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        gza
        </i>
      </td>
      <td colspan="2">
        Start of Paragraph
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |vi -gza
        </u>
        ^qu -jaiw =tiri /qou !dvu |jir =zna
        </i>
      </td>
      <td>
        ¶ Tigereye watches the waves in the canal
      </td>
    </tr>
    <tr>
      <td>
        <i>
        qti
        </i>
      </td>
      <td colspan="2">
        Thesis (Topic Sentence)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |vi -qti
        </u>
        ^gua =spi /pwo !xa jy |zu -pwo !gua =fn -:ewlan
        </i>
      </td>
      <td>
        <i>
        Gua\spi
        </i>
        can do everything English can do
      </td>
    </tr>
    <tr>
      <td>
        <i>
        sku
        </i>
      </td>
      <td colspan="2">
        Thus, Conclusion
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i
        <u>
        |vi -sku
        </u>
        ^zge |xne !gua =vdm ^gua =cin /fi -klo 
        |va -ge -qma !gua !spi
        </i>
      </td>
      <td>
        Thus the gap between human and machine languages is closed by
        <i>
        gua\spi
        </i>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        tl
        </i>
      </td>
      <td colspan="2">
        Sequence Decoration
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !vo -gi -vgry /gi -kau -tiw !vem |zu -tw ^ji ^vu -cnu 
        ^va -zu -plm !qo -:mei -ci
        <u>
        |tl -co
        </u>
        </i>
      </td>
      <td>
        That would relieve me of many present troubles, 
        Mei Chi being
        <em>
        number one
        </em>
      </td>
    </tr>
    <tr>
      <td>
        <i>
        va
        </i>
      </td>
      <td colspan="2">
        That Is
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ji /kio !xo -kqu
        <u>
        |va
        </u>
        -ftu =plyw
        </i>
      </td>
      <td>
        I have some food,
        <em>
        that is
        </em>
        , an apple
      </td>
    </tr>
  </tbody>
</table>


 

* * *



<table width="100%">
  <tbody>
    <tr>
      <td align="center">
        <a href="vocab2.html">
        Next
        </a>
      </td>
      <td align="center">
        <a href="semantic.html">
        Previous
        </a>
      </td>
      <td align="center">
        <a href="guarefmn.html">
        Contents
        </a>
      </td>
    </tr>
  </tbody>
</table>


 
