---
"title": "Argument Referent Sets"
---



<table width="100%">
  <tbody>
    <tr>
      <td align="center">
        <a href="vocab1.html">
        Next
        </a>
      </td>
      <td align="center">
        <a href="pronouns.html">
        Previous
        </a>
      </td>
      <td align="center">
        <a href="guarefmn.html">
        Contents
        </a>
      </td>
    </tr>
  </tbody>
</table>


 

* * *

# Argument Referent Sets

As stated earlier, a predicate word expresses a relation between the occupants of its cases, and is defined by a referent set consisting of lists of case occupants that are thus related. 

To interpret an argument, you start with its predicate's referent set. You retain members consistent with any sub-phrases. From each member you extract the first case occupant, and out of these you make the <span class="latex">full referent set</span> of the argument. (The full referent set is empty in important special cases.) The <span class="latex">referent subset</span>, which is the set of actual referents of the argument, is a subset of the full set which depends on a prefix word called an <span class="latex">article</span>. 

<span class="latex">Consistent with sub-phrases</span> means this: the n'th case occupant of each main predicate referent set member must be in the referent subset of the n'th case sub-argument. In addition, if the sub-argument has a prefix <span class="latex">_ve_ -each</span>, then make equivalence classes of main referent set members (that survive all restrictions simultaneously) which differ only in the n'th case. If the set of n'th case occupants from an equivalence class is not equal to the sub-argument referent subset (i.e. it is not true that each sub-argument referent is in the equivalence class), reject the whole equivalence class. For subordinate clauses, the same procedure applies except the predicate is from the clause and the restricted phrase acts as one of its sub-arguments. 

## The Articles

Here are the articles. There are two articles for each meaning; the first unfolds the referent subset so each member is a referent, while the second specifies that the referent is the referent subset as a set. The careful distinction between sets and extensions of their members is characteristic of _gua\spi_. 

_<span class="latex">xe</span>_ , _<span class="latex">xy</span>_ : 
    The most common article is _<span class="latex">xe</span>_ , and it is assumed with most predicates when arguments lack an article. Its English translation is <span class="latex">the</span>. The referent subset is whichever members the speaker has in mind to talk about, but generally there are prior context cues to show which out of numerous possibilities are intended as the referents. In particular, if a set of referents has been designated before and if it is the only such set that is a subset of the full referent set of the argument, then those are the referents of the argument. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !fkar |xda ^vu -xge /fi -can -tai !qel =fkar
        </i>
      </td>
      <td>
        The old, black car emerged from its garage.
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !fkar /cyr -vle
        </i>
      </td>
      <td>
        The car turned left.
      </td>
    </tr>
  </tbody>
</table>




<span class="latex">_fkar_ -car</span> appears three times; in each instances its article is <span class="latex">_xe_ -the</span> but the article is unseen, being provided by default. The first instance of <span class="latex">_fkar_ -car</span> designates one referent in detail. The other two instances are typical arguments with <span class="latex">_xe_ -the</span>: since the prior referent fits this predicate (and in the second sentence <span class="latex">its garage</span> does not), the prior referent is being redesignated. Because _gua\spi_ words are so short it is just as efficient to redesignate an argument like this as to use a phrase-relative pronoun, so pronouns are less commonly used in _gua\spi_ than in English. 

_<span class="latex">xa</span>_ , _<span class="latex">xu</span>_ : 
    The subset equals the full referent set. The referents are everything that fits the predicate. Mathematical expressions almost invariably have _<span class="latex">xu</span>_ as the article, as in _<span class="latex">xu -cu</span>_ = <span class="latex">the equivalence class of all pairs</span> = <span class="latex">the number two</span>. 
_<span class="latex">xi</span>_ , _<span class="latex">xr</span>_ : 
    Only a few members are left out, which the speaker has in mind as being <span class="latex">atypical</span>. By judiciously using _<span class="latex">xi</span>_ the speaker can prune out excessive special cases from his discussion. But unfortunately listeners have a lot of trouble to identify correctly which members are being left out. Beware. 
_<span class="latex">xo</span>_ , _<span class="latex">xw</span>_ : 
    From the full referent set one or more members are selected, and it doesn't matter which ones. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i |vi -pli ^jo ^sa -ji /gey !xo -kliw
        </i>
      </td>
      <td>
        Please give me some nails
      </td>
    </tr>
  </tbody>
</table>




All in the box are equivalent and it doesn't matter which you get. _<span class="latex">xo</span>_ is often used for arguments in the <span class="latex">serving or portion</span> category, called <span class="latex">partitive nouns</span> in English. 

_<span class="latex">xn</span>_ : 
    No members of the full referent set are in the referent subset. This article is useful for negative statements like 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !tara /crw !xn -kseo
        </i>
      </td>
      <td>
        The rat eats no cheese
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !xa -kseo /go -zu -crw !tara
        </i>
      </td>
      <td>
        Every cheese is not eaten by the rat
        (for every cheese, the rat doesn't eat it)
      </td>
    </tr>
  </tbody>
</table>




Actually _<span class="latex">xn</span>_ makes a statement about the excluded referent set members; were it regarded as a statement about all the members of an empty set, there could be no examples or counterexamples and the sentence would assert nothing. The second example is the contrapositive of the first, and shows what _<span class="latex">xn</span>_ really means. 

Each case of each predicate has a default prefix, used with any arguments that do not have explicit articles. Most of these defaults are _<span class="latex">xe</span>_ ; _<span class="latex">xu</span>_ is used with math operators because of the meaning of numbers; _<span class="latex">xy</span>_ is used for cases that need sets; _<span class="latex">xe vo</span>_ is common for words that deal with events; and _<span class="latex">xe bi</span>_ appears in a few cases that need texts. In the latter two cases appearance of any article cancels both _<span class="latex">xe</span>_ and _<span class="latex">vo</span>_ or _<span class="latex">bi</span>_. _<span class="latex">xy</span>_ defaults have a special behavior: they change to _<span class="latex">xe</span>_ if the argument is already a set. 

When an argument predicate has a default article for its first case other than _<span class="latex">xe</span>_ , and when it is in a case with a _<span class="latex">xe</span>_ default, the argument predicate's article is used. Otherwise if the defaults are unequal and not _<span class="latex">xe</span>_ , the situation is ambiguous and the speaker is required to say the article he wants. 

## Cartesian Expansion of Arguments

The reason arguments are in a phrase is to select particular events from the definition of the phrase predicate. When there are several arguments in a phrase their referent sets are multiplied in the sense of Descartes (Cartesian product) to give the events in the phrase referent set: each of the first argument referents is paired with each of the second argument referents, and so on for more arguments. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !tara |zu -cu /fi -crw !kseo |zu -cu
        </i>
      </td>
      <td>
        Each of the two rats eats from each of the two cheeses
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !kmau ^fe -kani /crw !tara ^fe -gara
        </i>
      </td>
      <td>
        The cat and the cow eat the rat and the grass (but which eats which?)
      </td>
    </tr>
  </tbody>
</table>




The second example could easily be interpreted the same as the first, but if one knows that particular events are not in the definition of the predicate --- cows do not <span class="latex">_crw_ -eat</span> rats --- one will normally discount such terms in the Cartesian expansion without thought. The arguments then merely select pre-known events from the definition. If the speaker wishes to assert that a cow ate a rat, he should put the unusual event in a separate sentence and should emphasize it. 

Often within a sentence --- this applies to top-level sentences, not just phrases --- the same argument appears in several cases, either as a pronoun or explicitly redesignated. In each member of the referent set of the sentence the occupants of the replicated case are equal --- they are not selected independently from the referent sets of the replicated argument, as they would be if the arguments were different. Sub-phrases restrict main phrase events one by one, and the occupant of a replicated case in the sub-phrase is also equal to the one in the main phrase. For example: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !kmau -bia |zu -ca /fi -jun !daue =xgno
        </i>
      </td>
      <td>
        The three kittens chased their tails; each one chased its
        own tail
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !cil |duo !ple !scer |zey =cil /fi -zu -pny |jro
        </i>
      </td>
      <td>
        The children who are not sitting in their own chairs will be punished
        (child sit other than chair of child . . .)
      </td>
    </tr>
  </tbody>
</table>




There is one exception: if an argument is prefixed by _<span class="latex">vl</span>_ , its referent is chosen independently of any other copies of it. _<span class="latex">vr</span>_ as a prefix means <span class="latex">_inter alia_ </span> or <span class="latex">each other</span>. Its meaning is like _<span class="latex">vl</span>_ except that in the sentence's referent set the prefixed argument's referent may not duplicate that of other copies of the same argument. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !vdr =cor /dou -kyr !couo ^vr -zdmo
        </i>
      </td>
      <td>
        The members of the soccer team kicked the ball to each
        other; none kicked it to himself
      </td>
    </tr>
  </tbody>
</table>




If an argument prefixed by _<span class="latex">vr</span>_ or _<span class="latex">vl</span>_ is replicated by a pronoun the same referent is used both places, but if the pronoun has its own prefix that one supercedes any in the antecedent and the referent is chosen independently. 

In addition, the sentence start words _<span class="latex">:u</span>_ and _<span class="latex">:o</span>_ mean that the sentence should be interpreted coordinately with the one before it. The referent sets of the two sentence predicates are multiplied in the sense of Descartes and the argument set members are fitted into their respective cases the same as in a single sentence. In particular, arguments replicated in both sentences have the replicated cases equal in each referent set member. 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !ftu =plyw /xgi ^:o -bal !qke !zglo
        <br/>
        ^:i !ftu =plyw /xgi ^:o -bal !qke !ftu =plyw
        </i>
      </td>
      <td>
        Since the apple is green, then likely it is sour; the same
        apple is sour
      </td>
    </tr>
  </tbody>
</table>




The same statement is shown twice; the first one uses a pronoun while the second repeats the argument _<span class="latex">ftu =plyw</span>_ explicitly. 

For statements of logic one may produce a nonsentence containing the arguments to be discussed, called <span class="latex">prenex arguments</span>, and then state one or more sentences about them, starting each sentence with _<span class="latex">^:u</span>_ and repeating the arguments or using pronouns. Since the Cartesian product is not commutative when negation is involved, or with mixed universal and existential quantification, the speaker may be forced to produce arguments in an inconvenient order, and prenex arguments may sound better. Here is an example of prenex arguments: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !xa -tara ^jy |ga -xim =da ^:u !da /vam !tara
        </i>
      </td>
      <td>
        For all rats, there exists some X such that X loves the rat
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !xa -tara /zu -vam !jy
        </i>
      </td>
      <td>
        All rats are loved by someone (same without prenex)
      </td>
    </tr>
  </tbody>
</table>




A conjunction is a pair or list of similar grammatical structures which act as if they were one unit. We have seen the conjunction word _<span class="latex">fe</span>_ in compound words, but it also works with arguments to combine several into one, just as when one argument designates several referents. Here is a tricky example from before: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !kmau ^fe -kani /crw !tara ^fe -gara
        </i>
      </td>
      <td>
        The cat and the cow eat the rat and the grass
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !dwu /crw !kqu
        </i>
      </td>
      <td>
        The animals eat the foods
      </td>
    </tr>
  </tbody>
</table>




The two argument pairs are Cartesian multiplied to select referent set members of <span class="latex">_crw_ -eat</span> just as in the second example the two arguments designate multiple referents which are Cartesian multiplied. See also [Vocabulary: Conjunctions](../vocab1.html#conjunctions) for other kinds of conjunctions. 

## Miscellany about Arguments

Formally the articles are described as prefixes, but it makes sense semantically to regard them as predicates with two arguments; a full referent set comes in (as a set) to the second argument and the appropriate referent subset comes out in the first. With this definition, for example, _<span class="latex">xa</span>_ (full referent set in extension) would mean exactly the same as <span class="latex">_xor_ -set member</span>. It is easier that way to interpret compound articles like _<span class="latex">xo -xi</span>_ = <span class="latex">any typical X</span>. However, articles have to be prefixes grammatically so the argument's main predicate can have its own arguments before it as well as after. 

Most Indo-European languages distinguish between genders and numbers of arguments. Like Chinese and English, _gua\spi_ has no gender, though you may use a subordinate clause like <span class="latex">_|fmy_ -female</span>. Number comes from the referent sets, not the grammar. You may specify the exact number of referents with a numeric predicate, like this: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i |vi -pli ^jo ^sa -ji /gey !xo -beol |fmy ^vu -zu -cu
        </i>
      </td>
      <td>
        Please give me two nuts (female screws)
      </td>
    </tr>
  </tbody>
</table>




* * *



<table width="100%">
  <tbody>
    <tr>
      <td align="center">
        <a href="vocab1.html">
        Next
        </a>
      </td>
      <td align="center">
        <a href="pronouns.html">
        Previous
        </a>
      </td>
      <td align="center">
        <a href="guarefmn.html">
        Contents
        </a>
      </td>
    </tr>
  </tbody>
</table>


 
