---
"title": "Pronouns Represent Words, Not Things"
---



<table width="100%">
  <tbody>
    <tr>
      <td align="center">
        <a href="semantic.html">
        Next
        </a>
      </td>
      <td align="center">
        <a href="cases.html">
        Previous
        </a>
      </td>
      <td align="center">
        <a href="guarefmn.html">
        Contents
        </a>
      </td>
    </tr>
  </tbody>
</table>


 

* * *

## Pronouns Represent Words, Not Things

The next organizational issue is the pronoun. In English, pronouns have referents just like any other argument. But _gua\spi_ pronouns represent words, not the referent of words. In computer terms, they are like macro-instructions rather than in-line functions. The represented words are called the <span class="latex">antecedent</span> of the pronoun, and the sentence is analysed as if each pronoun were taken out and replaced by its antecedent. The antecedents, not the pronouns, have referents. In this way the organizational syntax level can be kept free of meaning, and the semantic level has to deal with only one class of words, predicates. 

For example, a document typically will have a signature line saying in effect <span class="latex">this text is the output of Jim Carter</span>. (Spoken discourse is completely analogous.) Then when there appears the pronoun _<span class="latex">ji</span>_ (<span class="latex">me</span> in English) the effect is as if the words <span class="latex">Jim Carter</span> had been written in its place. That is, <span class="latex">A rat ate my cheese</span> and <span class="latex">A rat ate Jim Carter's cheese</span> mean exactly the same thing. 

Phrases attached to a pronoun replace or supplement phrases in its antecedent. In general, if two arguments are given for the same case, numbered or modal, it is not an error but the first is ignored. 

### Phrase-Relative Pronouns

_Gua\spi_ has phrase-relative pronouns, question pronouns, names and modal pronouns. Phrase-relative pronouns are for copying neighboring phrases --- arguments or entire sentences. Each point of use may have a different neighbor, so the same word used in different places may have different antecedents, while to reach the same antecedent from different places may require different words. The pronouns whose antecedent is a whole phrase are automatically infinitives; an explicit _<span class="latex">vo</span>_ is not needed. The most often used such pronouns are: 

> 

<table>
  <tbody>
    <tr>
      <td>
        zdmo
      </td>
      <td>
        First case of phrase where pronoun is
      </td>
    </tr>
    <tr>
      <td>
        xgno
      </td>
      <td>
        First case of current sentence
      </td>
    </tr>
    <tr>
      <td>
        xdro
      </td>
      <td>
        Referent of restricted argument
      </td>
    </tr>
    <tr>
      <td>
        xdry
      </td>
      <td>
        Phrase restricted by subordinate clause
      </td>
    </tr>
    <tr>
      <td>
        zglo
      </td>
      <td>
        First case of previous sentence
      </td>
    </tr>
    <tr>
      <td>
        zgly
      </td>
      <td>
        Entire previous sentence
      </td>
    </tr>
    <tr>
      <td>
        vgry
      </td>
      <td>
        Question sentence being answered
      </td>
    </tr>
    <tr>
      <td>
        zgln
      </td>
      <td>
        Previous discourse in general
      </td>
    </tr>
  </tbody>
</table>




There are pronouns for five cases and the whole phrase, for five phrase types --- 30 in all. The complete list is under [Vocabulary: Phrase-Relative Pronouns](../vocab1.html#pronouns). Phrase-relative pronouns like <span class="latex">it</span> are common in English, but in _gua\spi_ it is easier to redesignate an argument, so phrase-relative pronouns are less used in _gua\spi_. 

### Question Pronouns

For question pronouns the listener is supposed to say the antecedent; in other words, the speaker provides a sentence and the listener is to fill in the blanks. Here are the question pronouns: 

> 

<table width="100%">
  <colgroup>
  <col width="7%"/>
  <col width="43%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        pu
        </i>
      </td>
      <td>
      </td>
      <td>
        What (argument)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ju /crw !pu
        </i>
      </td>
      <td>
        What are you eating?  (You eat what?)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !xo -ftu =plyw
        </i>
      </td>
      <td>
        An apple fruit (nonsentence)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        py
        </i>
      </td>
      <td>
      </td>
      <td>
        How (descriptive predicate)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i -py !ftu =plyw
        </i>
      </td>
      <td>
        What kind of apple is it?
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i -xgi !ftu =plyw
        </i>
      </td>
      <td>
        A green apple  (Green is apple)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        pa
        </i>
      </td>
      <td>
      </td>
      <td>
        How many (numeric predicate)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ju /crw !ftu =plyw |zu -pa
        </i>
      </td>
      <td>
        You ate how many apples?
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i -co !ftu =plyw
        </i>
      </td>
      <td>
        One apple
      </td>
    </tr>
    <tr>
      <td>
        <i>
        pr
        </i>
      </td>
      <td>
      </td>
      <td>
        Which one (identification predicate)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ju /crw !ftu =plyw |pr
        </i>
      </td>
      <td>
        Which apple are you eating?
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i !ftu =plyw |zey !ju
        </i>
      </td>
      <td>
        Your apple (nonsentence)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        po
        </i>
      </td>
      <td>
      </td>
      <td>
        Is it (mood)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i -po -qke !ftu =plyw
        </i>
      </td>
      <td>
        Is the apple sour?
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        ^:i ge --- ^:i go
        </i>
      </td>
      <td>
        Yes --- No
      </td>
    </tr>
  </tbody>
</table>




### Names

In _gua\spi_ a name is a pronoun. A name consists of a predicate prefixed by _<span class="latex">qu</span>_ , or _<span class="latex">qo</span>_ for foreign names, which disconnects the usual meaning of the predicate and substitutes the pronoun behavior. People are assigned permanent names at birth through a performative (ritual) statement like this: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i |zo -tri ^qo -ben /xim !jw |cil
        </i>
      </td>
      <td>
        (Performative:) Ben is the name of this child
      </td>
    </tr>
  </tbody>
</table>




From then on, _<span class="latex">!jw |cil</span>_ (<span class="latex">this child</span>, with context so the listeners remember which one) is the antecedent of the name _<span class="latex">qo -ben</span>_. Subsequently when Ben is introduced to people a speaker will make a similar statement, except lacking <span class="latex">_tri_ -ritual</span> so it is constative (a statement of fact). Either statement lets the listener know what is the antecedent of the pronoun _<span class="latex">qo -ben</span>_. The antecedent then has a referent, which is the actual person being named. 

The meaning (if any) of the predicate without _<span class="latex">qu</span>_ is not changed. There is no implication that the antecedent may fit in the first case of the name, e.g. <span class="latex">Mr. Coward</span> may be quite courageous. A single referent can, and usually does, have several names. Semantics, though perhaps not law, allows you to put a new antecedent on a name at any time. 

The six variables _da, de, di, do, du, dy_ are names which you can assign to important concepts in nonfiction or characters in fiction. In mathematics it is common to use letter words as names for mathematical expressions, which in _gua\spi_ have the form of arguments. When the name antecedent, or any pronoun antecedent, is assigned all pronouns therein are already replaced by their antecedents, so that if those contained pronouns are later reassigned the name antecedent is unchanged. 

### Personal Pronouns and Modal Defaults

Modal cases have a default value which is inserted in each sentence lacking explicit words for that case. Let us again use the speaker's modal case as an example. Most or all sentences in the document have the same speaker even though no speaker clause appears on them explicitly. There is a default value for the speaker, which is like a pronoun in that the antecedent words of the default are placed automatically into every sentence lacking an explicit speaker clause. The same default is the antecedent of the personal pronoun <span class="latex">_ji_ -me</span>. The subordinate clause to identify the speaker initially is _<span class="latex">|qi -jai !X</span>_ ; the _<span class="latex">qi</span>_ prefix indicates that the default modal case for the speaker should be changed to X. The default value is like a pronoun, in that the antecedent words of the default are placed into the sentences. 

<span class="latex">Personal</span> pronouns, so called because <span class="latex">me</span> and <span class="latex">you</span> are among them, mostly represent certain important modal case defaults. There have already been several examples. The personal pronouns are: 

> 

<table>
  <tbody>
    <tr>
      <td>
        ji
      </td>
      <td>
        me
      </td>
      <td>
        The speaker
      </td>
    </tr>
    <tr>
      <td>
        ju
      </td>
      <td>
        you
      </td>
      <td>
        The listener
      </td>
    </tr>
    <tr>
      <td>
        je
      </td>
      <td>
        we
      </td>
      <td>
        The speaker and the listener
      </td>
    </tr>
    <tr>
      <td>
        ja
      </td>
      <td>
        we
      </td>
      <td>
        Speaker and listener in imperative sentences
      </td>
    </tr>
    <tr>
      <td>
        jo
      </td>
      <td>
        you
      </td>
      <td>
        The listener in imperative sentences
      </td>
    </tr>
    <tr>
      <td>
        jn
      </td>
      <td>
        now
      </td>
      <td>
        Current time default
      </td>
    </tr>
    <tr>
      <td>
        jr
      </td>
      <td>
        here
      </td>
      <td>
        Current place default
      </td>
    </tr>
    <tr>
      <td>
        jw
      </td>
      <td>
        this
      </td>
      <td>
        Object being shown or pointed out
      </td>
    </tr>
    <tr>
      <td>
        jm
      </td>
      <td>
        that
      </td>
      <td>
        Alternate object being shown
      </td>
    </tr>
    <tr>
      <td>
        jy
      </td>
      <td>
        that which
      </td>
      <td>
        The referent of the argument
      </td>
    </tr>
  </tbody>
</table>




_<span class="latex">jy</span>_ marks the open case of an argument, where the referent goes. It appears by default in the first case, but you may link something else there explicitly with _<span class="latex">so</span>_ and put _<span class="latex">jy</span>_ explicitly elsewhere. Conversion is neater. 

The modal case default has a kind of stack, so that a previous default value can be saved, replaced, and later restored. Here is a list of the control prefixes for the modal cases and their stacks. Except _<span class="latex">ql</span>_ , each must be used in front of a predicate, which identifies which modal case is being affected. 

> 

<table>
  <colgroup>
  <col width="10%"/>
  <col width="90%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        qe
      </td>
      <td>
        The current default is saved and a new one put in effect
      </td>
    </tr>
    <tr>
      <td>
        qa
      </td>
      <td>
        The current default is removed and the prior one restored
      </td>
    </tr>
    <tr>
      <td>
        qi
      </td>
      <td>
        The current default is replaced by a new one
      </td>
    </tr>
    <tr>
      <td>
        qr
      </td>
      <td>
        The current and prior defaults are exchanged
      </td>
    </tr>
    <tr>
      <td>
        ql
      </td>
      <td>
        The speaker and listener cases are exchanged (for dialog)
      </td>
    </tr>
    <tr>
      <td>
        qy
      </td>
      <td>
        X1 is the default modal argument for the predicate.  The 
        default is not changed; the sentence is simply true or
        false.
      </td>
    </tr>
  </tbody>
</table>




Here is an example of stacked cases, in story dialog: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i |qe -jai !qo -kira /fi !py /zu-zni !cyr -far !ju
        </i>
      </td>
      <td>
        Said Kira, <span class="latex">Why do you flee?</span> (default saved, set)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i -po -sfa -daw -can -siw -dan !ju
        </i>
      </td>
      <td>
        <span class="latex">Don't you want to be rescued?</span>  (default inserted automatically)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i |vi -pli ^vi -pql ^jo /kuo !ji
        </i>
      </td>
      <td>
        <span class="latex">Please, at least talk to me!</span>   (default inserted automatically)
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i |qa -jai ^qo -kira /jun !suy
        </i>
      </td>
      <td>
        Kira pursued the swimmer.  (prior default = narrator)
      </td>
    </tr>
  </tbody>
</table>




Kira said the first three sentences, and the effect is as if the words _<span class="latex">|jai !qo -kira</span>_ were added to the second and third, while the narrator said the last one, and _<span class="latex">qa</span>_ restores him as speaker. 

Tenses are also handled this way, as is any modal case. If you put _<span class="latex">|qe -cnu !X</span>_ on the opening descriptive sentence (where X is an event identifying when the sentence happens) then it will be propagated to subsequent sentences automatically --- unlike in English where a syntactically complicated and less precise tense has to be used on every sentence. John Parks-Clifford, then with the Loglan Institute, originally developed this concept of tense defaults [TL43]. 

In the third dialog line above, notice the use of <span class="latex">_jo_ -you</span> to make the sentence imperative. The decoration <span class="latex">_|vi-pli_ -please</span> shows the speaker's attitude but does not by itself make the sentence imperative. 

## Compound Predicates

A key organizational element of _gua\spi_ is the compound word, a sequence of predicates and structure words. The first word's tone shows where the compound attaches. There may be several following words in the compound, each of which has high even tone <span class="latex">-</span> or low even tone <span class="latex">=</span>. A phrase predicate often begins with prefixes, such as the caselink _<span class="latex">sa</span>_ or the conversion _<span class="latex">zu</span>_ , but the most significant use of compounding is to join two or more predicate words. 

The motivation to make compounds is twofold. First, you can use a single argument list to say what amounts to two sentences, which when compounded are much easier for the listener to interpret. Second, just as we use Latin prefixes in English to make many words from one, e.g. <span class="latex">ob-ject</span>, <span class="latex">pro-ject</span>, <span class="latex">in-ject</span>, <span class="latex">ab-ject</span>, most meanings in _gua\spi_ are achieved by combining a much broader range of predicates. A beginner can learn the primitive words, about 1400, and then stick them together in self-created compounds which he can expect any listener to understand, while to achieve the same range of expression in natural languages the speaker and the listener must master a huge vocabulary in which most of the words are rarely used. 

Though humans like to think of compound predicates as separate words analogous to the primitive words, compounds are actually defined through the transformations described below, so that each primitive word heads a separate phrase. For example in a transitive compound the compounded object is to be taken off and put in its proper case as a sub-phrase. Thus one can easily and reliably interpret a compound word that one has never heard before, as long as one knows all the primitive words. 

### Infinitive Argument

There are three main patterns to the compounds. First, if the main word has a case with a default linker of _<span class="latex">vo</span>_ or _<span class="latex">bi</span>_ \--- that is, a case for an infinitive --- a word compounded with high even tone <span class="latex">-</span> is the predicate of that infinitive, and the main word case before the infinitive (before conversion) becomes the infinitive's first case. (Exceptions are noted in the dictionary.) Here are examples: 

> 

<table width="100%">
  <colgroup>
  <col width="10%"/>
  <col width="40%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td colspan="2">
        <i>
        ^:i !qo -kira /can -xna !fyni
        </i>
      </td>
      <td>
        Kira takes hold of the oar
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        can
        </i>
      </td>
      <td>
        X1 changes so (
        <i>
        vo
        </i>
        ) X2 becomes true
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        xna
        </i>
      </td>
      <td>
        X1 holds X2 with (body part) X3
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !qo -kira /xna !fyni
        </i>
      </td>
      <td>
        Kira holds the oar (X2 of
        <i>
        /can
        </i>
        )
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <i>
        ^:i !du /juy -xna !do ^qnou !du
        </i>
      </td>
      <td>
        He offers it his hand
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        juy
        </i>
      </td>
      <td>
        X1 allows X2 to do (
        <i>
        vo
        </i>
        ) X3 (offers)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        xna
        </i>
      </td>
      <td>
        X1 (
        <i>
        !do
        </i>
        ) holds X2 (
        <i>
        !qnou !du
        </i>
        ) with (body part) X3
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !do /xna !qnou !du
        </i>
      </td>
      <td>
        It holds his hand (X3 of
        <i>
        /juy
        </i>
        )
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <i>
        ^:i !du /qma -jur !do
        </i>
      </td>
      <td>
        He turns it over
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        qma
        </i>
      </td>
      <td>
        X1 makes X2 do (
        <i>
        vo
        </i>
        ) X3
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        jur
        </i>
      </td>
      <td>
        X1 (
        <i>
        !do
        </i>
        ) turns by itself . . . (motion word)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !do /jur
        </i>
      </td>
      <td>
        It turns (X3 of
        <i>
        /qma
        </i>
        )
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <i>
        ^:i -po -go -daw -siw -dan !ju
        </i>
      </td>
      <td>
        Do you want to be
        saved?
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        daw
        </i>
      </td>
      <td>
        X1 desires to be/do (
        <i>
        vo
        </i>
        ) X2
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        siw
        </i>
      </td>
      <td>
        X1 stops being/doing (
        <i>
        vo
        </i>
        ) X2
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        dan
        </i>
      </td>
      <td>
        X1 is in danger of having (
        <i>
        vo
        </i>
        ) X2 happen to it
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !ju /dan
        </i>
      </td>
      <td>
        You are in danger (X2 of
        <i>
        /siw
        </i>
        )
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !ju /siw -dan
        </i>
      </td>
      <td>
        You are out of danger (X2 of
        <i>
        /daw
        </i>
        )
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td colspan="2">
        <i>
        ^:i -po -go !ju /daw (!vo !ju /siw (!vo !ju /dan (!vo !ju /X2)))
        </i>
      </td>
    </tr>
  </tbody>
</table>




The patterns with <span class="latex">_can_ -change</span> and <span class="latex">_qma_ -make</span> are as common in _gua\spi_ as the pre-pro-in-ob-ab Latin prefix set is in English. In the second and third examples, the infinitive first case is a copy of the main sentence case before the infinitive: the second case. _Gua\spi_ predicate words are usually not transitive, and the third example shows how transitive predicates are produced. (There is a separate word <span class="latex">_fow_ -force</span>.) As shown in the fourth example, multiple compounds are common. The expansion of this sentence is also shown with all defaults written out in full. 

### Shared Argument List

Second, the words may share an argument list. The effect is as if you had made two sentences with the arguments copied into each. This pattern is cued by <span class="latex">-</span> when the infinitive argument pattern does not apply, or by a conjunction _<span class="latex">-fe</span>_ when it does. For example: 

> 

<table width="100%">
  <colgroup>
  <col width="10%"/>
  <col width="40%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td colspan="2">
        <i>
        ^:i !du /xna -zon !puou !do
        </i>
      </td>
      <td>
        He holds its head from behind
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !du /xna !puou + !du /zon !puou
        </i>
      </td>
      <td>
        He holds the head; he is behind the head
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <i>
        ^:i !fnau /zu -vel !tfu -fen !do
        </i>
      </td>
      <td>
        The knife is in his harness
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !jy /tfu !do + !jy /fen !do . . .
        </i>
      </td>
      <td>
        His garment; which joins him to . . . (
        <i>
        <span class="latex">jy</span>
        </i>
        = referent placeholder)
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <i>
        ^:i !do /suy -pne -qmy !kqua
        </i>
      </td>
      <td>
        It swims down through the water
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !do /suy !kqua + !do /pne !kqua + !do /qmy !kqua
        </i>
      </td>
      <td>
        It swims to water; it penetrates that water; it is above that water.
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <i>
        ^:i !du /trl -bil !do ^fcir
        </i>
      </td>
      <td>
        He drags it up to the air
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !du /trl !do ^fcir + !do /bil !fcir
        </i>
      </td>
      <td>
        He pulls it to air; it is below the air
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <i>
        ^:i !do /suy -far !sa -du
        </i>
      </td>
      <td>
        It swims away from him
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        !do /suy !sa -du + !do /far !X2
        </i>
      </td>
      <td>
        It swims from him; its destination is far
      </td>
    </tr>
  </tbody>
</table>




The first sentence shows this pattern plainly. In the second, the predicate of an argument is compound and the pronoun _<span class="latex">jy</span>_ is used in the paired expansions to represent its open first case. It is very common for a motion word and a directional property to share arguments, as in the last three sentences. In the fourth one, with a transitive motion word the directional property relates the thing that moves, not the actor, to the destination. The polarity of the direction is often reverse of English: <span class="latex">swims down</span> means it is <span class="latex">_qmy_ -above</span> the destination. A better translation is <span class="latex">swims from above</span>. 

Most usually the first and second cases of all the predicates go together. For exceptions as in the fourth sentence above the dictionary shows which cases merge. 

### Object of Transitive Predicate

A third pattern is found in which a transitive main word is followed by its object as a compound. It is cued by the tone <span class="latex">=</span>. In this pattern the main word's second case (before conversion) receives the sub-word as an argument, except that if the main word is converted so the second case is unavailable, the first case (before conversion) gets the sub-word. For organizing the other arguments the effect is the same as if an explicit caselink _<span class="latex">!su</span>_ had been used. For example: 

> 

<table width="100%">
  <colgroup>
  <col width="10%"/>
  <col width="40%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td colspan="2">
        <i>
        ^:i -spo !bri =kqua |bir ^dri =fli
        </i>
      </td>
      <td>
        Maybe the pilot already drowned
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        bri
        </i>
      </td>
      <td>
        X1 breathes X2
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        kqua
        </i>
      </td>
      <td>
        X1 is a serving/portion of water
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        bri =kqua
        </i>
      </td>
      <td>
        X1 drowns
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        dri
        </i>
      </td>
      <td>
        X1 drives X2 to X3 . . . (transitive motion word)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        fli
        </i>
      </td>
      <td>
        X1 flies to X2 . . . (motion word)
      </td>
    </tr>
    <tr>
      <td>
      </td>
      <td>
        <i>
        dri =fli
        </i>
      </td>
      <td>
        X1 drives flyers (airplanes) to X2 . . .
      </td>
    </tr>
  </tbody>
</table>




_<span class="latex">dri -fli</span>_ would be the second type of compound, meaning that its referent both drives and flies, like a bird driving a car. This is not quite the right meaning. 

### Foreign Words and Metaphors

The prefixes _<span class="latex">fo</span>_ , _<span class="latex">fn</span>_ and _<span class="latex">qo</span>_ start a foreign word, and all subsequent compounded words are part of it. The word must start with a C and end with a V, and so you may have to modify the word either by removing or adding letters. Put a glottal stop before an initial vowel. Sounds not in _gua\spi_ are mangled to fit. _<span class="latex">qo</span>_ is for foreign names, _<span class="latex">fo</span>_ marks a non-name predicate, and _<span class="latex">fn</span>_ is for foreign metaphors. As a predicate the foreign word means <span class="latex">X1 is (whatever)</span> but listeners rarely know its meaning, so cases are never recognized on a foreign word. Normally you attach it as a metaphor to a _gua\spi_ predicate, both to provide cases and to give the listener a cue, if not to the exact meaning, at least to the category of the meaning. For example, 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !qo -jan /dwu -fn -:au-stralo-pi-te-ku
        </i>
      </td>
      <td>
        John is  an  australopithecine
      </td>
    </tr>
    <tr>
      <td>
        <i>
        ^:i !dlau -fn -borneo /juo !xr -bror -fn -:ma-ka-gani
        </i>
      </td>
      <td>
        Mahogany trees live on the island of Borneo
      </td>
    </tr>
  </tbody>
</table>




Here the foreign name <span class="latex">John</span> could be pronounced without change (note the phonetic spelling), but <span class="latex">australopithecine</span> needed work. While in English we use the adjective or set-membership form of the word, in _gua\spi_ it works better to use the root form of the foreign word, if you know it: <span class="latex">australopithecus</span>. A glottal stop <span class="latex">:</span> was added at the beginning, <span class="latex">th</span> was changed to <span class="latex">t</span>, the final consonant <span class="latex">s</span> was removed (a V could have been added), and the word was stuck on <span class="latex">_dwu_ -animal</span> to provide cases. This long word has five _gua\spi_ syllables, treated in morphology as separate words, and they are stuck together by compounding tone <span class="latex">-</span>. (Normally the <span class="latex">-</span> tone symbols are not written inside a foreign word.) 

Similarly on the other sentence, _gua\spi_ predicates are put in front of the foreign words to help the listener interpret them. An educated human knows what a Borneo is, but a naive listener, particularly mechanical, needs the assistance of <span class="latex">_dlau_ -island</span>. 

Foreign words make the organization ambiguous: when a word has compounding tone is it compound or does it continue a foreign word? The Procrustean method is used to resolve the ambiguity: a foreign word eats all following first tone words. 

While metaphors are most common with foreign words, they are also available with _gua\spi_ predicates, being cued by the conjunction _<span class="latex">fw</span>_. They resemble shared-argument compounds but the meaning is not so precisely derived from the combined words. Only the cases of the main word appear; the sub-word's cases are ignored. (But metaphors are clearer if the first cases of all the words can merge.) Use regular compounds if at all possible, as in the last example, because they are unambiguous. 

> 

<table width="100%">
  <colgroup>
  <col width="33%"/>
  <col width="33%"/>
  <col width="33%"/>
  </colgroup>
  <tbody>
    <tr>
      <td colspan="2">
        <i>
        bror -fn -:ma-ka-gani
        </i>
      </td>
      <td>
        Mahogany tree
      </td>
    </tr>
    <tr>
      <td>
        <i>
        dvu -fw -tal -xgi
        </i>
      </td>
      <td>
        Animal jumper green
      </td>
      <td>
        Frog
      </td>
    </tr>
    <tr>
      <td>
        <i>
        kem -fw -kql -gnyr
        </i>
      </td>
      <td>
        Chemical liquid silver
      </td>
      <td>
        Hydrargyrum
      </td>
    </tr>
    <tr>
      <td>
        <i>
        kem -fw -gnyr -kua
        </i>
      </td>
      <td>
        Chemical silver fast
      </td>
      <td>
        Quicksilver
      </td>
    </tr>
    <tr>
      <td>
        <i>
        xgm -tsu -zu -jeu
        </i>
      </td>
      <td>
        Bright sudden shock (not metaphor)
      </td>
      <td>
        Flash
      </td>
    </tr>
  </tbody>
</table>




### Special Cases

Numbers are a special case in organization. Compounded digits after the first build up a multi-digit cardinal number, with a possible sign, exponent and decimal point. Quasidigits, which appear first, mean <span class="latex">approximately</span>, <span class="latex">at least</span>, and so on. As a predicate a cardinal number means <span class="latex">X1 is a set of N members, one of which is X2</span>. An ordinal number, cued by the quasidigit _<span class="latex">tr</span>_ , means <span class="latex">X1 is N'th in list (_xy_) X2 starting at X3</span>. For example: 

> 

<table width="100%">
  <colgroup>
  <col width="50%"/>
  <col width="50%"/>
  </colgroup>
  <tbody>
    <tr>
      <td>
        <i>
        ^:i !tor =cenu /cni !ti -kl -co -cw -cu -ka -kn -ku
        </i>
      </td>
      <td>
        The account balance is about minus 12.8 million dollars 
        ( about $-1.28E7)
      </td>
    </tr>
  </tbody>
</table>




Conversion of compound words is a bit tricky. The conversion prefix carries the tone for joining to preceeding material. If the converted predicate has compounding (high even, <span class="latex">-</span>) tone, it alone is converted. But if it has sixth (low even, <span class="latex">=</span>) tone, it and all compound attached words are converted as a unit. (There is no provision for leftward grouping.) 

That is how _gua\spi_ is organized. Let us now turn to the semantics of arguments. 

* * *



<table width="100%">
  <tbody>
    <tr>
      <td align="center">
        <a href="semantic.html">
        Next
        </a>
      </td>
      <td align="center">
        <a href="cases.html">
        Previous
        </a>
      </td>
      <td align="center">
        <a href="guarefmn.html">
        Contents
        </a>
      </td>
    </tr>
  </tbody>
</table>


 
