---
"title": "Introduction to the Dictionary"
---

# Introduction to the Dictionary

### James F. Carter

15 September 1991

This is the dictionary of the _gua\spi_ language. It is organized into three parts in which words are ordered by _gua\spi_ spelling (with morphological formats in separate sections), by the English translation, and by thesaurus categories. The table of contents also serves as an outline of the categories. 

This edition includes only primitive words of _gua\spi_. Only a few compound words appear. A future project will be to go through a list of the N most common English words and either to verify that each one has a primitive translation or to recommend a compound representation of it. Note the word <span class="latex">recommend</span>. The speaker of _gua\spi_ is expected to represent his meaning by compounding primitive words creatively, and the architect of _gua\spi_ does not insist on particular compound words to translate particular English words. 

But since the vocabulary of English is so vast, even the working vocabulary of an educated person, most English words will never be in this dictionary. Here is where the thesaurus can help. Look at the primitive words in the category where your meaning is, and try to modify one of them by compounding to achieve the meaning you want. 

To get the most use out of _gua\spi_ you have to know all the primitive words. For this the thesaurus can be helpful as it forms an organized structure whose lists are a convenient size for memorization. 

Be sure to remember that _gua\spi_ predicates can be converted. The English word used in the definition is the one most representative of the unconverted _gua\spi_ case order, but by conversion you can get up to four additional English meanings. 

In one trial of _Loglan_ about half of the predicates were compound, and likely more will be compound in _gua\spi_. Be alert for creative opportunities for expression --- don't use only the words identified as being <span class="latex">common in compounds</span>. But resist the temptation to specify a predicate over-precisely with many compounded words; one thinks differently in _gua\spi_ , and mashing _gua\spi_ words to fit English preconceptions does not give the best results. 

Acronyms, so popular in illiterate English, are useless in _gua\spi_ because the letterals of the acronym are longer than the compound word or phrase that they abbreviate. Again, keep the compound short. 

An example of a definition is <span class="latex">X1 likes to do (vo) X2+1</span>. The symbols X1 and X2 represent the first and second numbered cases of the predicate <span class="latex">like</span>. Words in parentheses before the case symbols, such as <span class="latex">(vo)</span>, are provided by default before that argument unless there is an explicit article there --- which cancels both the default article and the default phrase linker if any. All arguments receive _<span class="latex">xe</span>_ as a prefixed article by default, unless a different article is shown in the dictionary or is said explicitly. Signs following the case numbers indicate special features of compound words and case merging in infinitives. Here they are illustrated decorating the second case, but the same pattern applies for all cases. 

X2*
    In a transitive compound (tone <span class="latex">=</span>), this is the case where the object goes. It is the second case by default (but the dictionary even so shows many X2*'s explicitly). 
X2+1
     In an infinitive compound (tone <span class="latex">-</span>), this is the case where the infinitive goes. Note that a few words do not do infinitive compounds (they do parallel compounds instead) even though they have a case for an infinitive. All cases of these words lack <span class="latex">+</span> or have <span class="latex">@</span>. The <span class="latex">1</span> selects the first case of the main predicate. This argument is replicated as the first case of the infinitive (whether explicit or from a compound). The notation <span class="latex">+1,2</span> means that referents from both cases are replicated. A <span class="latex">+</span> alone signals infinitive compounding but with no case replication. 
X2-3
     Usually used with a <span class="latex">+</span> decoration, the -3 means that the third case of the main predicate is replicated as the second case of the infinitive. 
X2+S1
     The <span class="latex">S</span> means that, X1 normally being a set, its members are replicated in extension into the first case of the infinitive. <span class="latex">-S1</span> is also used for the infinitive second case. 
X2+P1
     The <span class="latex">P</span> means that the infinitive is applied pairwise to members of the first case set, as in sorting or finding an extreme member. 
X2+1@
     The <span class="latex">@</span> indicates that this case is not eligible for infinitive compounds, though the indicated replication occurs for explicit infinitives. 
X2=
     The <span class="latex">=</span> means that starting with the indicated case (here X2), all following cases have a similar role, as many cases as needed. The sum of several numbers, as many as needed, is a typical example. 
X2?
     The <span class="latex">?</span> indicates a special case replication, described after the definition. 

Here are the types of compounds. See the reference manual for a complete explanation with examples. 

Infinitive
     The second word is the predicate of an infinitive in one of the first word's cases. (Tone <span class="latex">-</span>.) 
Parallel
     Both words share the same arguments so both relations are simultaneously true of each argument list. (Tone <span class="latex">-</span>, or _<span class="latex">-fe</span>_ if an infinitive compound would supervene.) 
Transitive
     The second word is the predicate of an argument in one of the first word's cases, the second case unless otherwise noted. (Tone <span class="latex">=</span>.) 

Here is a reminder of the non-English letters of _gua\spi_. See the reference manual for more examples. 

> 

<table width="100%">
  <colgroup>
  <col width="15%"/>
  <col width="15%"/>
  <col width="70%"/>
  </colgroup>
  <tbody>
    <tr>
      <th>
        <i>
        Gua\spi
        </i>
      </th>
      <th>
        English
      </th>
      <th>
        Examples of Pronunciation
      </th>
    </tr>
    <tr>
      <td>
        c
      </td>
      <td>
        ch
      </td>
      <td>
        CHew, Ciao (Italian)
      </td>
    </tr>
    <tr>
      <td>
        q
      </td>
      <td>
        sh
      </td>
      <td>
        SHoe
      </td>
    </tr>
    <tr>
      <td>
        x
      </td>
      <td>
        zh
      </td>
      <td>
        aZure, breZHnev (Russian)
      </td>
    </tr>
    <tr>
      <td>
        :
      </td>
      <td>
        (pause)
      </td>
      <td>
        the:apple, hawai:i (glottal stop)
      </td>
    </tr>
    <tr>
      <td>
        #
      </td>
      <td>
        uh
      </td>
      <td>
        thE, Among (schwa)
      </td>
    </tr>
    <tr>
      <td>
        y
      </td>
      <td>
        i
      </td>
      <td>
        knIt
      </td>
    </tr>
    <tr>
      <td>
        i
      </td>
      <td>
        i, ee
      </td>
      <td>
        grEEn machIne (not eye)
      </td>
    </tr>
    <tr>
      <td>
        e
      </td>
      <td>
        e
      </td>
      <td>
        bEd
      </td>
    </tr>
    <tr>
      <td>
        w
      </td>
      <td>
        ng
      </td>
      <td>
        stroNG
      </td>
    </tr>
    <tr>
      <td>
      </td>
    </tr>
  </tbody>
</table>



