## Lesson 9. Logical conjunctions

Logical conjunctions in Lojban are based on 4 primitive ones: **.a**, **.e**, **.o**, **.u**. In this lesson, we'll cover them in detail.

### Logical conjunctions for arguments

Here are the conjunctions combining two words: _this_ and _that_.

- **ti .a ta** = _this and/or that_

 > **mi ba vitke le mamta .a le tamne**
 >_I'll visit the mother or the cousin._
 
 Note that **.a** can also be translated as _at least one of the two values_, and thus leaves open the possibility that I will get around to visiting both of them at some point.

- **ti .e ta** = _this and that_

 > **mi ralte le pa gerku .e le re mlatu**
 >_I've got a dog and two cats._
 >`I keep one dog and two cats.`

- **ti .o ta** = _either this and that, or none_

 > **mi ba vitke le mamta .o le tamne**
 >_I will visit either both the mother and the cousin, or none of them._

 Note that **.o** can also be translated as _not one of the two values_, and thus denotes that I will get around to visiting both of them at some point or none.

- **ti .u ta** = _this, and perhaps that_, _this whether or not that_

 > **mi ba vitke le mamta .u le tamne**
 >_I'll visit the mother whether or not I'll visit the cousin._

 **.u** just emphasizes that the second value does not affect the truth of the sentence.

Placing **nai** after a conjunction negates what is to the right of it. Placing **na** before a conjunction negates what is to the left of it:

- **ti .e nai ta** = _this and not that_

 > **mi nelci la .bob. e nai la .alis.**
 >_I like Bob but not Alice._
 >`I like Bob and not Alice`

 We can also say **ti .e nai ku'i ta** (_this but not that_) adding a flavor of contrast for the second argument.

- **ti na .e ta** = _not this but that_

 > **mi nelci la .alis. na .e la .bob.**
 >_I don't like Alice but I do like Bob._
 >`I like Alice not and Bob`

 This may sound a bit weird for English speakers (`I like Alice not…`) so you might prefer to swap the arguments and use **.e nai** instead: **mi nelci la .bob. e nai la .alis.** or even **mi nelci la .bob. i mi na ku nelci la .alis.** will mean the same.

- **ti na .e nai ta** = _neither this nor that (none)_

 > **mi nelci la .alis. na .e nai la .bob.**
 >_I don't like neither Alice nor Bob_

Negating with other primitive conjunctions might not look intuitively usable, you can just learn them from examples:
- **ti .a nai ta** = _this if that_, _for this the exclusive condition to happen is that_

 > **mi ba vitke le mamta .a nai le tamne**
 > _I will visit the mother but for that to happen I need to visit the cousin._

 Thus, **ti .a nai ta** means that **ta** is necessary (but may not be the only condition) for **ti** to be applied.

- **ti .o nai ta** = _either this or that_

 > **mi ba vitke le mamta .o nai le tamne**
 > _I'll visit either the mother or the cousin._

 **.o nai** can also be translated as _exactly one of the two values_.

 If I want to say that I will visit either the mother or the cousin but not both, I need **.o nai** (_either/or_). It's unlike **.a** (_and/or_) where I can visit both of them.

- **ti na .u ta** = doesn't influence _(not this, but perhaps that)_
- **ti na .u nai ta** = doesn't influence _(not this, but perhaps that)_

- **ti se .u ta** = _perhaps this, and that_
- **ti se .u nai ta** = _perhaps this but not that_

<!-- **se** is used only for **.u** because in other cases it leads to no effect in meaning. -->

These are used for connecting arguments. For connecting parts of compound relations we use similar conjunctions: **ja**, **je**, **jo**, **ju**. So instead of the dot (pause) we use **j** here.

<!-- It's common to use **ja**, **je**, **jo**, **ju** for connecting arguments too. -->

### Logical conjunctions for sentences

This is a more concise way of saying:

> **mi ralte le pa gerku .i je mi ralte le re mlatu**
> _I have a dog, and I have two cats._

**.i je** joins two sentences with a logical _and_, showing that both sentences are part of one thought and are true.

Here are examples of other conjunctions for sentences:

> **la .rome'os. cu prami la .djuliet. i je la .djuliet. cu prami la .rome'os.**
> _Romeo loves Juliet, <u>and</u> Juliet loves Romeo._

This means both statements are true, i.e., Romeo and Juliet love each other.

The same applies to other conjunctions:

> **la .rome'os. cu prami la .djuliet. i ja la .djuliet. cu prami la .rome'os.**
> _Romeo loves Juliet, and/or Juliet loves Romeo._

This means one of them loves the other, and perhaps both of them do.

> **la .rome'os. cu prami la .djuliet. i jo nai la .djuliet. cu prami la .rome'os.**
> _Either Romeo loves Juliet or Juliet loves Romeo._

Here, either Romeo loves Juliet (but Juliet doesn't love him), or Juliet loves Romeo (but he doesn't love her).

> **la .rome'os. cu prami la .djuliet. i ja nai la .djuliet. cu prami la .rome'os.**
> _For Romeo to love Juliet, it's necessary that Juliet loves Romeo._

This means that if Juliet loves Romeo, he definitely loves her, but he may love her anyway (the only impossible outcome is that Juliet loves Romeo but he doesn't love her).

> **la .rome'os. cu prami la .djuliet. i jo la .djuliet. cu prami la .rome'os.**
> _Either Romeo loves Juliet and Juliet loves Romeo, or neither of the two events happens._

This means that if Juliet loves Romeo, he loves her, and if she doesn't love him, he doesn't love her.

> **la .rome'os. cu prami la .djuliet. i ju la .djuliet. cu prami la .rome'os.**
> _Romeo loves Juliet whether or not Juliet loves Romeo._

Notice how we Lojbanize the name "Romeo": the combination "eo" is impossible in Lojban, so we used "e'o" and added a consonant at the end of his name.

Note that **da** refers to the same entity when several sentences are connected.

### Logical conjunctions inside compound relations

> **le melbi xunre fonxa**
> _beautifully red phones_

<!-- -->

> **le melbi je xunre fonxa**
> _beautiful and red phones_

Other conjunctions also make sense:

> **mi nelci ro tu voi xajmi ja melbi prenu**
> _I like all persons who are funny or handsome (or both)._

<!-- -->

> **mi nelci ro tu voi xajmi jo nai melbi prenu**
> _I like all persons who are either funny or beautiful._

This might be explained if, for example, I find the qualities of humor and good looks incompatible, i.e., a mixture of the two would be just too much.

> **mi nelci ro tu voi xajmi ju melbi nanmu**
> _I like all persons who are funny (whether or not beautiful)._

And once again, we shouldn't forget the difference between connecting arguments and connecting parts of compound relation constructs:

> **mi ba vitke le pa pendo .e le pa speni**
> _I will visit a friend and a spouse._

<!-- -->

> **mi ba vitke le pa pendo je speni**
> _I will visit a friend-and-spouse._

The last Lojban sentence means that the friend is also a spouse.

### Logical conjunctions for relation tails

> **pu ku mi uantida la .soker. gi'e klama le zdani gi'e citka le badna**
> _I played soccer, went home, ate the banana._

uantida
: non-official relation: $x_1$ plays the game $x_2$, participates in the game $x_2$

**gi'e** connects several relations into one with some terms shared. Look at this: It expands into **pu ku mi kelci la .soker. i je pu ku mi klama le zdani** … which would be lengthier.

With **gi'e**, we keep the head of the relation constant and specify terms after each of the relation construct (**kelci la .soker.**, **klama le zdani** …).

Thus, when using **gi'e**, we have several relations in the tail joined together but having a common head.

**gi'e** has the same final vowel as in **je** and thus means _and_.

Other conjunctions for joining relation tails:

- **gi'a** for _and/or_
- **gi'o nai** for _either … or_
- **gi'u** for _whether or not_ etc.

These conjunctions have the same ending as those in the **.a**, **.o**, **.u** series.

### Terms in sentences with several tails

Note that tenses as terms and tenses attached to the main relation of the relation make a difference when applied to sentences that contain several attached relations:

- A term in the head of the sentence is applied to all its tails:

 >**mi ba'o cu citka le badna gi'e pinxe**
 >_I no longer eat the banana and no longer drink._

 Here, **ba'o** is applied to **citka le badna gi'e pinxe**.

- A tense word that is a part of the relation is applied to that relation only:

 >**mi ba'o citka le badna gi'e pinxe**
 >_I no longer eat the banana, but I do drink._

 Here, **ba'o** is applied to the implied **mi citka le badna** relation only but not to the implied **mi pinxe** relation. 

### Choice questions

Another type of English "or" can be found in questions:

> **— xu do pinxe le tcati .o nai le ckafi?**
> **— pinxe**
> _— Will you drink tea or coffee?_
> _— Yes._

That's a peculiar, but perfectly reasonable answer: _Yes, I will drink tea or coffee._

This happens because "or" has several meanings in English:

1. _A or B_ can mean _either A, or B but not both_. We use **.o nai** here.
2. _A or B_ can mean _A or B or both_. We use **.a** here.
3. _A or B?_ can be a question meaning _select from A and B, which of them do you choose?_ We use **ji** here.

Thus, in the last case, we use a separate question conjunction **ji**:

> **— do pinxe le tcati ji le ckafi?**
> _— Will you drink tea or coffee?_

Possible answers:

> **le tcati .e le ckafi**
> _Tea and coffee._

<!-- -->

> **le tcati**
> _Tea._

<!-- -->

> **le ckafi**
> _Coffee._

It is also possible to use conjunctions when replying:

> **.e** — <span>_Both_ (the first and the second item is chosen)</span>

<!-- -->

> **.e nai** — <span>_The first one (tea)_ (the first but not the second one is chosen)</span>

<!-- -->

> **na .e** — <span>_The second one (coffee)_ (not the first but the second one is chosen)</span>

<!-- -->

> **na .e nai** — <span>_Neither_ (not the first and not the second one is chosen)</span>

You can ask questions in the same way about the other kinds of conjunctions we have looked at. The interrogative conjunction for relation tails is **gi'i**, for compound relations — **je'i**, for sentences — **.i je'i**.

Indirect questions are achieved by using **ji kau**:

Consider the waiter asks a visitor

> **- le'e dembi ji le'e rismi**
> _- The beans or the rice?_

Once the visitor answers, the waiter knows whether the visitor wants to eat lamb or beef:

> **ba le nu le vitke cu spusku kei le bevri cu djuno le du'u le vitke cu djica le nu ri citka le'e dembi ji kau le'e rismi**
> _After the visitor replies, the waiter knows whether the visitor wants to eat the beans or the rice._

### Forethought conjunctions

> **ge do gi mi**
> _both you and I_

<!-- -->

> **ge nai do gi mi**
> _Not you but I_

<!-- -->

> **ge do gi nai mi**
> _You but not I_

<!-- -->

> **go nai do gi mi**
> _Either you or I_

The forethought conjunction **ge** means _and_, but it's placed before the first argument term, with **gi** separating the two arguments. This series is parallel to other conjunctions: **ga**, **ge**, **go**, **gu**, as well as **ga nai**, **ge nai**, **go nai**, etc. The separator **gi** is the same for all of them.

Using these conjunctions is a matter of convenience:

> **mi citka ge nai le badna gi le plise**
> _I eat not the banana but the apple._

Here, like in English, _not_ is stated before the first argument.

**ge** and words in this series can also be used for connecting relations:

> **ge mi dansu gi mi zgipli le pipno**
> _I both dance and play the piano._

zgipli
: $x_1$ plays musical instrument $x_2$

le pipno
: piano

> **.i ga nai pu zi carvi gi ca cilmo**
> _If it has been raining recently, it's wet now._