## Lesson 8. Terms and math

### ‘_Possibly can_’, ‘_have been_’ and ‘_haven't yet been_’

<pixra url="/assets/pixra/cilre/kahe_vofli.webp" caption="le cipni ka'e vofli" definition="The bird possibly can fly."></pixra>

> **le'e cipni ka'e vofli**
> _Birds can fly._

<!-- -->

> **le pendo be mi ca'a xendo prenu**
> _My friend shows himself as a friendly person._

<!-- -->

> **le pendo be mi ka'e litru bu'u ro da**
> _A friend of mine can travel in any place._

<!-- -->

> **mi ca'a zvati la .madrid.**
> _I am in Madrid._

<!-- -->

> **mi pu'i zvati la .madrid.**
> _I have been to Madrid._

<!-- -->

> **mi nu'o zvati la .madrid.**
> _I have never been to Madrid._

ka'e
: term of potential: possibly can

ca'a
: term of potential: actually is

pu'i
: term of potential: has already happened

nu'o
: term of potential: hasn't ever happened

This series of so-called terms of potential describes possible situations.

Note that **ka'e** means that an event can happen, whereas, for example,

> **le'e cipni cu kakne le ka vofli**
> _Birds are capable of flying._

describes abilities dependent on actions of participants.

### ‘_Plus_’ and ‘_minus_’

<!-- -->

> **li mu du li re su'i ci**
> _Five equals two plus three._

**li** that we saw earlier is similar to **le** but it starts a mathematical expression (or just a number or a timestamp).

Note that **li re su'i ci** (_2+3_) is considered a single expression and treated as one argument.

**du** is a relation word and means _… is equal to …_.

- **su'i** means _plus_.
- **vu'u** means _minus_.
- **pi'i** means _times_ and is used for multiplication.
- **fe'i** means _divided by_ and is used for division.

**pi** is a decimal separator, so **no pi mu** means _0.5_, and **ci ze pi pa so** means _37.19_.

In some notations, 0.35 can be written as .35, and in Lojban, we can also drop zero by saying **pi mu**.

Here are some other examples:

> **li pare fe'i ci du li vo**
> _12 : 3 = 4._

<!-- -->

> **li re pi'i re du li vo**
> _two times two is four_

<!-- -->

> **li pano vu'u mu pi'i re du li no**
> _10 — 5 ⋅ 2 = 0._

Notice that you put **li** only once before the equation and once after it. Thus, _12 : 3_ is considered one number. Indeed, _4_ is the same as _12 : 3_. They are both numbers.

For asking for a number, we use **ma**:

> **li ci su'i vo du ma**
> _3 + 4 = ?_

<!-- -->

> **li ze**
> _7_

### ‘_first_ — «**pa moi**», ‘_second_’ — «**re moi**», ‘_last_’ — «**ro moi**»

Ordinal numbers such as _first_, _second_, and _third_ are used to arrange items in order. In Lojban, they are formed by adding a number followed by **moi**:

pa moi
: $x_1$ is first among $x_2$ (set)

re moi
: $x_1$ is second among $x_2$ (set)

ci moi
: $x_1$ is third among $x_2$ (set)

…

ro moi
: $x_1$ is last among $x_2$ (set)

Relations can also be used instead of numbers:

me mi moi
: $x_1$ is mine

me do moi
: $x_1$ is yours

In this case, we had to convert pronouns to relations using **me**.

> **le prenu cu pa moi le'i se prami be mi**
> _He is my first love._

<!-- -->

> **tu ro moi le'i ratcu pe mi**
> _That is my last rat._

<!-- -->

> **le cerni tarci cu ro moi le'i tarci poi cumki fa le nu viska ke'a pu le nu co'a donri**
> _The morning star is the last star that's visible before the dawning of the day._

<!-- -->

> **tu me mi moi**
> _That's mine._

<!-- -->

> **tu me mi moi le'i stizu**
> **tu me mi moi stizu** (using a compound relation for conciseness)

> _That's my place._

<!-- -->

> **.i ti voi stizu cu me mi moi le'i pa ci stizu poi jibni le jubme**
> _This place is mine among the 13 places near the table._

Cardinal numbers are placed before ordinal numbers in a string and separated by **boi**:

> **le ci boi pa moi be le'i kabri pe le ckafi**
> _the first three cups of coffee_

Without **boi**, it would turn into **ci pa moi** — _thirty-first_.

### «**gau**» — make them do it

The term **gau** marks the agent of an event:

> **le canko cu kalri**
> _The window is open._

<!-- -->

> **le canko gau do kalri**
> _You open the window._
> `The window driven-by you is open`

gau
: modal term: caused by … (agent), driven by … (someone, some object)

kalri
: $x_1$ is open

Thus, verbs like _to open something_ and _to move something_ can be rephrased as _to make something open_ and _to make something move_. Therefore, we don't need to learn extra verbs for every such meaning. Instead, we add the term **gau** all the time.

There is also another method that retains the same order of words as in English:

> **le canko gau ko kalri**
> **ko jai gau kalri fai le canko**
> _Open the window!_

Here, we transform the relation **kalri** — _to be open_ into a new relation:

jai gau kalri
: to open something

The first place of **kalri** can be shown by using a place tag **fai**.

Some more variations:

> **le pa karce cu muvdu**
> _The car moves._

<!-- -->

> **ko jai gau muvdu fai le karce**
> **le karce gau ko muvdu**
> _Move the car! Make the car move!_

<!-- -->

> **le karce cu muvdu ti**
> **fa le karce cu muvdu fe ti**
> _The car moves here._

<!-- -->

> **ko jai gau muvdu fai le karce fe ti**
> _Move the car here!_

**muvdu** — _moves to some place_ is transformed into a new relation **jai gau muvdu** — _to move something or someone to some place_.

muvdu
: $x_1$ moves to $x_2$ from $x_3$ via $x_4$

jai gau muvdu fai le karce
: $x_1$ moves the car to $x_2$ from $x_3$ via $x_4$

> **la .alis. cu klama**
> _Alice comes._

<!-- -->

> **la .alis. gau ko klama**
> _Make Alice come!_

### ‘_Why_?’ — «**ri'a**», «**ni'i**», «**mu'i**», «**ki'u**»

> **- ri'a ma carvi**
> _- Why is it raining?_

> **- le nu le dilnu ca klaku**
> _- Because the clouds are crying._

ri'a
: modal term: because of … (some event)

ri'a ma
: why?

klaku
: $x_1$ cries

Unlike **gau**, the term **ri'a** expects not an agent, but an event, such as _the clouds are crying_:

> **le dilnu cu klaku ri'a le nu le dargu cu cilmo**
> _The skies are crying, resulting in the wet road._

_Therefore_ is the reverse word compared to _because_:

> **le dilnu cu klaku .i se ri'a bo le dargu cu cilmo**
> _The skies are crying. Therefore, the road is wet._

**cilmo**
: … is wet

Another type of _why_ is **ni'i**:

> **- ni'i ma nicte**
> **- le nu le solri na ku te gusni**
> _- Why is it night?_
> _- Because the sun is not shining._

<!-- -->

> **le solri na ku te gusni .i se ni'i bo nicte**
> _The sun is not shining. Therefore, it's night._

**ni'i**
: modal term: logically because of …

**se ni'i**
: modal term: with the logical consequence that …, logically therefore

Here, we can't use **ri'a** as we are talking not about a result but about logical implication. The fact that it is night just logically follows from the sun not shining.

> **mi darxi la .kevin. mu'i le nu ky. lacpu le kerfa be mi**
> _I hit Kevin because he pulled my hair._

**mu'i**
: term: because (of motive …)

In this example, what we have is not two events that are physically connected, like clouds and rain, but three events:

1. Kevin pulls my hair.
2. I decide, as a result of this, to hit Kevin.
3. I hit Kevin.

English omits the second event and says _Sally hit Joey because he pulled her hair._ However, this is not only vague but, some would say, psychologically dangerous. People do not generally react to stimuli automatically, but as a result of motivation, and confusing complex responses with simple physical causation may lead us to believe that we have no control over our emotions or even our actions. Thus, it is often useful to say not just physical reactions (**ri'a**) but emphasize responses which have a cognitive/emotional element (**mu'i**).

> **le ctuca pu plicru la .ben. le jemna ki'u le nu by. pu zabna gunka**
> _The teacher gave Ben the gem as a present because he worked well._

**le ctuca**
: the teacher

**le jemna**
: the gem

zabna
: $x_1$ is cool, nice

gunka
: $x_1$ works

ki'u
: modal term: because (due to explanation …)

The difference between motivation and justification is not always clear, but we can say that justification involves some rule or standard, while motivation does not require it. Compare:

> **le ctuca pu plicru la .ben. le jemna ki'u le nu by. pu zabna gunka**
> _The teacher gave Ben the gem as a present, motivated by his nice work._

This says only that Ben's hard work motivated the teacher to give him the gem, whereas with **ki'u**, we might imply that it is the custom for teachers to give gems as a reward for good work.

Note: Don't get **ki'u** mixed up with **ku'i**, which means _but, however_.

**ki'u** appeals to more general considerations than **mu'i**, but it still deals with human standards, not logical laws. Only a very naive student would believe that if a student is given a gem, it must logically imply that the student has worked nicely.

In the case of **ni'i ma nicte**, however, the fact that the Sun isn't shining at night logically entails that the Sun isn't shining. Here, we can confidently use **ni'i**.

### ‘_So … that_’

The expression _so … that_ is expressed in Lojban by splitting the sentence into two:

> **mi tai galtu plipe .i ja'e bo mi farlu**
> _I jumped so high that I fell down._

ja'e
: modal term: with the result of …

tai
: modal term: in the manner of …

Other examples:

> **mi tai zukte**
> _I act this way_

<!-- -->

> **mi tai fengu**
> _I am so angry._

fengu
: $x_1$ is angry at $x_2$ (clause) for action $x_3$ (property of $x_2$)

### ‘_If … then_’

> **ba ku fau le nu do cizra kei mi prami do**
> _If you are strange then I'll love you._

fau
: modal term: with the event of …, under circumstances …, concurrently with …

**fau** is much like **ca** (_when_) or **bu'u** (_at (some place)_).

In many cases, we can replace **fau** with **ca** to get almost the same meaning (sometimes more precise):

> **mi ba prami do ca le nu do cizra**
> _I'll love you when you are strange._

We can replace **le** with **ro lo** in such terms getting a new meaning:

> **mi ba prami do ca ro lo nu do cizra**
> _I'll love you whenever you are strange._

### «**fau**» and «**da'i**». ‘_What if …_’

> **da'i mi turni**
> _I could be a governor._

<!-- -->

> **da'i nai mi turni**
> _I am a governor._

- The interjection **da'i** marks the relation in which it is put as describing an imaginary event.
- The opposite interjection **da'i nai** marks the relation as describing an actual, real event.

Constructs with **da'i** are usually translated to English with auxiliary verbs such as _can/could, will/would, may/might, should_, and _must_. Relations marked with **da'i** in English are said to be in the _subjunctive mood_.

Omitting **da'i** or **da'i nai** makes the sentence clear only from context, which is usually quite transparent. That's why **da'i** or **da'i nai** is not obligatory. We use it for clarity when needed.

Relations with **da'i** may include the term with **fau**:

> **da'i mi gleki fau le nu mi ponse le rupnusudu be li pa ki'o ki'o**
> _I would/could be happy if I had one million dollars._

fau
: with the event of …

rupnusudu
: $x_1$ costs $x_2$ (number) US dollars

pa ki'o ki'o
: 1 million

> **mo da'i fau le nu mi cusku lu ie nai li'u**
> _What if I say "no"?_

Here, the event inside **fau** is equally imagined together with **mi gleki**. And here is the reverse example:

> **da'i nai mi gleki fau le nu mi ponse le rupnusudu be li pa ki'o ki'o**
> _Having one million dollars, I am happy._

In many circumstances, the word **fau** can be safely replaced with just **ca** (_at the same time as …_):

> **da'i nai mi gleki ca le nu do klama**
> _I'm happy when you come._

Other prepositions can be used when necessary:

> **da'i mi denpa ze'a le nu do limna**
> _I would wait while you took a swim._

denpa
: $x_1$ waits for $x_2$ (event)…

ze'a
: through some time, for a while, during …

limna
: $x_1$ swims

### Probabilities

Suppose you come home and hear someone scratching. You can say one of the following sentences:

> **fau su'o da tu mlatu**
> **fau da tu mlatu**
> _This might be/possibly is a cat. It is possible that this is a cat._
> (You keep several animals at home. So it might be your cat scratching, but you are not sure.)

<!-- -->

> **fau ro da tu mlatu**
> _This must be/certainly is the cat._
> (You have a cat, and such noise can be produced by only one object, that cat.)

<!-- -->

> **fau so'e da tu mlatu**
> _This should be/probably is the cat._
> (If you have a dog, then it can also produce such sounds, but your dog usually doesn't do that, so the cat is more likely.)

<!-- -->

> **fau so'u da tu mlatu**
> _It is not probable that this is the cat._

<!-- -->

> **fau no da tu mlatu**
> _This can't be the cat. This mustn't be the cat. It is impossible that this is the cat._

Notice that we omitted **da'i** for brevity. But if we want to be explicitly clear about the events being imaginary, **da'i** in these examples is to be put inside the **fau** relation:

1. **fau da'i da** denotes that the event in this relation _is possible, may/can possibly happen._
2. **fau da'i ro da** — the event _would necessarily happen._
3. **fau da'i so'e da** — the event _is probable, will probably happen, is likely to happen._
4. **fau da'i so'o da** — the event _is remotely probable, could/might happen._
5. **fau da'i so'u da** — the event _is not likely, probably doesn't happen._
6. **fau da'i no da** — the event _is not possible._

The difference between these is in the number of imaginary situations we take into account. We don't describe those situations; we just mark them as **da** (_something_), letting the context (or our listeners) decide what those situations are.

### Possibility implied in places of relations

Some relations have **da'i** implied in some of their slots when you don't use **da'i** explicitly:

> **mi pacna le nu do ba pluka sipna**
> _I hope you will have a pleasant sleep._

pacna
: $x_1$ hopes for $x_2$ (possible event) with likelihood $x_3$ (number, by default **li so'a** i.e. close to 1)

> **mi kanpe le nu do klama**
> _I expect you to come._

<!-- -->

> **mi kanpe le nu do ba jinga kei li so'e**
> _You'll probably win._
> `I expect with a high probability that you will win.`

<!-- -->

> **mi kanpe le nu mi cortu fau ro lo nu su'o lo rokci cu farlu le tuple be mi**
> _I know for a fact that if a rock lands on my foot, it will hurt._

kanpe
: $x_1$ expects $x_2$ (possible event) with expected likelihood $x_3$ (a number from 0 till 1, the default value is **li so'a**, i.e. near 1)

Unlike **pacna**, the relation **kanpe** doesn't necessarily imply hope or wish. It can describe impartial expectation, subjective evaluation of the probability of a situation.

> **cumki fa le nu do jinga**
> _It is possible that you win._

<!-- -->

> **- xu ba carvi**
> **- cumki**
> _- Will it rain?_
> _- Maybe._

cumki
: $x_1$ (possible event) is possible, $x_1$ may, might occur, $x_1$ is a maybe.

> **- xu ba carvi**
> **- lakne**
> _- Will it rain?_
> _- Probably._

lakne
: $x_1$ (possible event) is probable, likely

> **mi djica le nu do jinga**
> _I want you to win._

<!-- -->

> **mi djica le nu mi klama la .paris.**
> _I would rather visit Paris. I want to visit Paris._

djica
: $x_1$ wants $x_2$ (possible event)

> **mi te mukti le ka klama la .paris.**
> _I will visit Paris. I am motivated to visit Paris._

<!-- -->

> **mi te mukti klama la .paris.**
> _I'm visiting Paris intentionally._

te mukti
: $x_1$ is motivated to bring about goal $x_2$ (possible event) by motive $x_3$ (event)

> **mi kakne le ka limna**
> _I am able to swim._

<!-- -->

> **mi pu kakne le ka gunka**
> _I could work. I was able to work._

kakne
: $x_1$ can, is able to do $x_2$ (property of $x_1$)

$x_2$ describes a possible event.

> **mi nitcu le nu mi sipna**
> _I need to sleep._

nitcu
: $x_1$ needs $x_2$ (possible event)

> **mi bilga le ka gunka**
> _I must work. I am obliged to work._

bilga
: $x_1$ must, is obliged to do $x_2$ (property of $x_1$)

> **mi curmi le nu do citka ti**
> _I allow you to eat this._

curmi
: $x_1$ allows/permits $x_2$ (possible event)

> **mi tolcru le nu do nerkla**
> _I forbid you to enter._

tolcru
: $x_1$ forbids/prohibits $x_2$ (possible event)

> **xu do stidi le ka sipna kei mi**
> _Do you suggest that I sleep?_

stidi
: $x_1$ inspires $x_2$ (possible action) in actor $x_3$

<!-- >**mi na ku birti le du'u ra klama**
>_I'm not sure if he comes._

birti
: $x_1$ is sure that $x_2$ (proposition) is true -->

> **mi senpi le du'u ra kakne le ka limna**
> _I doubt that he can swim._

senpi
: $x_1$ doubts that $x_2$ (proposition) is true

<!-- **senpi** is the same as **na'e birti** -->

> **mi se xanri le nu mi pavyseljirna**
> _I imagine myself being a unicorn. I could be a unicorn._

<!-- -->

> **se xanri**
> _$x_1$ imagines $x_2$ (possible event)_

<!-- -->

> **xanri**
> _$x_1$ (possible event) is imagined by $x_2$_