## Lesson 7. Letters, referring to relations, dates

### Names of letters in Lojban

Each letter has a name in Lojban.

The following table represents the basic Lojban alphabet and how to pronounce letters (below each letter):

<table>
<tbody><tr>
<td>'
</td>
<td><b><font  class="guibutton" color="#FF1493">a</font></b>
</td>
<td>b
</td>
<td>c
</td>
<td>d
</td>
<td><b><font  class="guibutton" color="#FF1493">e</font></b>
</td></tr>
<tr>
<td><b>.y'y.</b>
</td>
<td><b>.a bu</b>
</td>
<td><b>by.</b>
</td>
<td><b>cy.</b>
</td>
<td><b>dy.</b>
</td>
<td><b>.ebu</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>f
</td>
<td>g
</td>
<td><b><font  class="guibutton" color="#FF1493">i</font></b>
</td>
<td>j
</td>
<td>k
</td>
<td>l
</td></tr>
<tr>
<td><b>fy.</b>
</td>
<td><b>gy.</b>
</td>
<td><b>.i bu</b>
</td>
<td><b>jy.</b>
</td>
<td><b>ky.</b>
</td>
<td><b>ly.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>m
</td>
<td>n
</td>
<td><b><font class="guibutton" color="#FF1493">o</font></b>
</td>
<td>p
</td>
<td>r
</td>
<td>s
</td></tr>
<tr>
<td><b>my.</b>
</td>
<td><b>ny.</b>
</td>
<td><b>.o bu</b>
</td>
<td><b>py.</b>
</td>
<td><b>ry.</b>
</td>
<td><b>sy.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>t
</td>
<td><b><font  class="guibutton" color="#FF1493">u</font></b>
</td>
<td>v
</td>
<td>x
</td>
<td><b><font  class="guibutton" color="#FF1493">y</font></b>
</td>
<td>z
</td></tr>
<tr>
<td><b>ty.</b>
</td>
<td><b>.u bu</b>
</td>
<td><b>vy.</b>
</td>
<td><b>xy.</b>
</td>
<td><b>.y bu</b>
</td>
<td><b>zy.</b>
</td></tr></tbody></table>

As you can see:

- to get the name for a vowel, we add the word **bu**.
- to get the name for a consonant, we add **y.** to the consonant.
- the word for **'** (apostrophe) is **.y'y**.

We can spell words using these names. For example, CNN will be **cy. ny. ny.**

<!-- A capital letter alone has a special meaning. It denotes the name of that letter:

**A** is the same as **.abu**, **B** is the same as **by.** and so on. They means the same and even are read the same as normal **.abu**, **by.** etc. So _CNN_ can also be written as **CNN** in Lojban and it will be still pronounced and mean the same as **cy. ny. ny.** -->

### Letters instead of ‘_he_’ and ‘_she_’

A string of one or more letter names can function as a pronoun, providing an alternative method for referring to previously mentioned arguments in speech.

> **la .alis. pu klama le nurma .i le nurma cu melbi la .alis.**
> **la .alis. pu klama le nurma .i ri melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi .a bu**
> _Alice went to the country. The rural area is beautiful to Alice._
> _Alice went to the country. It is beautiful to her._

All the Lojban variants above have the same meaning.

Since the first letter in **.alis.** is **a** (ignoring the dot) and the first letter in **nurma** is **n**, we can use letter words to refer to those arguments correspondingly:

- **.a bu** refers to **la .alis.**
- **ny.** refers to **le nurma**

This method might be more convenient than English _he_ or _she_, or even Lojban **ri** or **ra**. It allows us to make speech more concise yet precise, without having to repeat potentially long names or other argument terms repeatedly.

However, it's important to note that there may be situations where we want to refer back to, for example, **le nurma**, but another argument starting with **n** appears in the meantime, making **ny.** unable to refer to the rural area. In such cases, the quickest solution is to repeat the entire argument, i.e., say **le nurma**:

> **bu'u le nurma la .alis. pu penmi la .nik. i ri se zdani bu'u le nurma**
> _In the country, Alice met Nick. He has his home in the country._

zdani
: … is a home to …

se zdani
: … has a home …, … lives in …

If a name consists of several cmevla, you can use the first letters of them to refer to that name. The same applies to compound relations:

> **la .djan.smit. cu citka le glare stasu .i dy.sy. nelci fy.sy.**
> _John Smith is eating the hot soup. He likes it._

glare
: … is hot

**dy.sy.** is a single pronoun. The same applies to **fy.sy.**.

If you need to put several pronouns one after another, separate them with the word **boi**:

> **mi klama la .paris. la .moskov.**
> _I go to Paris from Moscow._

<!-- -->

> **mi klama py. boi my.**
> _I go to P from M._

The sentence **mi klama py. my.** would mean _I go to PM_, which would mean something different.

> **la .tom.silver. pu zvati .i je'u ty. sy. boi .ui pu sidju mi**
> _Tom Silver was present. And actually, TS (yay!) helped me._

If you put an interjection after such letters, separate them with **boi**. Without **boi**, interjections will refer to the last letter.

### Different ways of saying ‘_we_’ in Lojban

In Lojban, there are several pronouns close in meaning to _we_:

mi'o
: you and I

mi'a
: we without you

ma'a
: you, I, and others

So, when speaking, you have to be more careful about which meaning of _we_ you need.

And finally:

mi
: I or the speakers

**mi** can also mean _we_! Lojban makes no distinction between singular and plural by default. So, if several people are speaking together, **mi** (which refers to one or more speakers) is perfectly correct for _we_. In practice, you'll usually find **mi** used like this when one person is presuming to speak (or more often, to write) on behalf of others.

Some examples:

> **mi prami do**
> _I love you._

<!-- -->

> **mi'a ba penmi do**
> _We'll meet you._

<!-- -->

> **ma'a remna**
> _We are all human._

<!-- -->

> **mi djica le nu do cliva**
> _We want you to go away._

cliva
: $x_1$ leaves

### «**ri**» instead of ‘_he_’ and ‘_she_’

Earlier, we learned about the pronoun **ri**:

ri
: pronoun: refers to the previous argument that just finished (skipping stable pronouns like **mi**, **do**, words for _we_)

> **mi catlu le nanmu .i ri melbi**
> _I look at the man. He is handsome._

melbi
: $x_1$ is beautiful / pretty / handsome to someone $x_2$

**ri** refers to the previous completed argument used in text or someone's speech:

> **la .alis. cu sipna bu'u le sledi'u pe la .alis.**
> _Alice sleeps in Alice's room._
> `Alice sleeps-in the of-Alice room.`

> **la .alis. cu sipna bu'u le sledi'u pe ri**
> _Alice sleeps in her room._
> `Alice sleeps in the room of [previous argument term].`

sledi'u
: $x_1$ is a room for purpose $x_2$ (proposition)

The **ri** is equivalent to repeating the last argument, which is **la .alis.** here.

One aspect to notice is that **ri** does not repeat **le sledi'u pe ri** (which is also an argument), because **ri** is a part of that argument and therefore that argument is not "previous", not finished yet when **ri** appears. This prevents **ri** from making it recursively refer to itself.

Another example:

> **le du'u le prenu cu melbi cu se djuno ri**
> _That the person is pretty is known to herself._

The **ri** refers to **le prenu** (and not **le du'u le prenu cu melbi** although both arguments are complete: **le prenu** starts last, after the start of **le du'u le prenu cu melbi**).

Relation inside **sei** forms a parallel text. **ri** skips arguments inside **sei**-relations:

> **mi viska la .lukas. sei la .doris. pu cusku .i ri jibni la .micel.**
> _I see Lucas, — Doris said. He is near Michelle._

In this example, **ri** cannot refer to **la .doris.** We simply skip the whole **sei la .doris. pu cusku** relation when deciding what **ri** should refer to.

Pronouns that are stable across the dialogue or story are ignored by **ri**. We just repeat them directly:

> **mi lumci mi**
> _I wash myself._
> `I wash me`

lumci
: $x_1$ washes $x_2$

> **mi prami mi**
> _I love myself._
> `I love me.`

However:

- the pronouns **ti**, **ta**, **tu** are picked up by **ri** because you might have changed what you are pointing at, so repeating **tu** may not be effective.
- similarly, **ri** itself (or rather, its antecedent) can be repeated by a later **ri**. In fact, a string of **ri** words with no other intervening arguments will always repeat the same argument:

 > **la .alis. cu catlu le nanmu .i ri melbi .i ri co'a zgana .a bu**
 > _Alice notices a man. He is handsome. He notices Alice._

zgana
: to observe

co'a zgana
: to start observing, to notice

In this example, the second **ri** has the first **ri** as its antecedent, which in turn has **le nanmu** as its antecedent. All three refer to the same thing: the man.

Ultimately, you decide what, where, and when to use in speech: the method with **le** + relation, the method with letter names, or with **ri**.

<!-- ### "_Myself, themselves_"

In Slavic languages people say literally _I wash self_. In order to be closer to a Slavic style we can use **lo nei**.

>**mi nelci mi**
>_I like myself._

>`I like me.`

It is the same in meaning as:

>**mi nelci lo nei**
>_I like myself._

>**mi lumci mi**
>**mi lumci lo nei**
>_I wash myself._

>**la ian ca lumci lo nei**
>**la ian ca lumci ri**
>_Yan washes himself._

**lo nei** links to the first noun of the current relation.

Remember that **ri** can't refer back to pronouns like **mi** so **lo nei** might be preferred in the last example. When changing the first noun **lo nei** doesn't change which is quite handy:

>**mi lumci lo nei i do lumci lo nei i la ian cu lumci lo nei**
>_I wash myself. You wash yourself. Yan washes himself._

>**la .doris. cu pensi lo nei**
>_Doris thinks about herself._

>**pa gerku cu batci lo nei**
>_A dog bites itself._

---

**nei** works well when a sentence only contains one relation. But when it has several embedded relations we might need something different. In

>**la .doris. cu djuno lo du'u la .alis. cu prami lo nei**
>_Doris knows that Alice loves herself._

**lo nei** refers to **la .alis.**

What if we want to refer to Doris? Here is a solution:

>**la .doris. cu djuno lo du'u la .alis. cu prami vo'a**
>_Doris knows that Alice loves her._

So while **lo nei** refers to the first noun of the current relation, **vo'a** refers to the first noun of the current sentence.

When there are no embedded relations those two words mean the same:

>**la .alis. cu prami vo'a** is the same as **la .alis. cu prami lo nei**
>_Alice loves herself._

- **vo'a** refers to the first noun of the current sentence.
- **vo'e** refers to the second noun of the current sentence.
- **vo'i** refers to the third noun of the current sentence.
- **vo'o** refers to the 4th noun of the current sentence.
- **vo'u** refers to the 5th noun of the current sentence.

---

**lo nei** can give funny results when applied to mutual actions:

>**la .alis. e la .kevin. cu cinba lo nei**
>_Alice kisses herself, and Kevin kisses himself._

Here is the solution:

>**la .alis. jo'u la .kevin. cu cinba zu'ai**
>_Alice and Kevin kiss each other_

It means the same as:

>**la alis cu cinba la kevin i je la kevin cu cinba la alis**
>_Alice kisses Kevin, and Kevin kisses Alice._

**zu'ai** is put into the second place of the verb. It shows the mutual action between the first place and the second place. Members of this mutual action are put to the first and connected with the conjunction **jo'u**. -->

### «**go'i**» for the previous relation

> **la .alis. cu klama le barja .i la .alis. cu viska le nanmu**
> **la .alis. cu klama le barja .i le go'i cu viska le nanmu**
> _Alice comes to the bar. She sees a man._

- **le go'i** refers to the first place of the previous relation.
  - **go'i** presents yet another way of referring back to an argument that we need.
- **le se go'i** refers to the second place of the previous relation.
- **le te go'i** refers to the third place, and so on.

Examples:

> **.i la .alis. cu zgana le nanmu .i ri melbi**
> **.i la .alis. cu zgana le nanmu .i le se go'i cu melbi**
> _Alice watches a man. He is handsome._

Here, **le se go'i** refers to the second place ($x_2$) of the preceding relation, which is **le nanmu**.

Another example:

> _Bill saw Nick. He hit him._

English doesn't bother with precision here — _he_ just means _some male person mentioned somewhere near in the text or deduced from context._ Did Bill hit Bob, or did Bob hit Bill? We don't know. In Lojban, we can say:

> **la .bil. pu viska la .nik. .i le se go'i cu darxi le go'i**
> _Bill saw Nick. Nick hit Bill._

However, in most cases, **ri** or letter words can be used:

> **la .bil. cu viska la .nik. i ri darxi la .bil.**
> **la .bil. cu viska la .nik. i ny. darxi by.**
> _Bill saw Nick. Nick hit Bill._

**go'i** itself is a relation word, and it thus has a place structure:

> **mi tatpi .i do ji'a go'i**
> _I'm tired. And you too._

When we say **do go'i**, we repeat the previous relation but replace its first place with **do**. In other words, **do ji'a go'i** here is the same as saying **do ji'a tatpi**.

<!-- ### What does **go'i** copy?

Interjections like **pei** (when used alone), **xu**, **.ui**, **.u'i**, **je'u** those formed with **sei** and the question interjection are not parts of relations. Thus they are not copied by **go'i**.

Terms like **na ku**, **pu**, left negators like **na'e**, **no'e**, **to'e** are parts of relations.

Thus, **go'i** copies the previous relation with those particles:

>— **la .bob. na ku prami la .alis.**
>— _**go'i**_

>— _It is not true that Bob loves Alice._

>— _ He doesn't (love)._

> **— la .bob. na'e prami la .alis.**
> _— Bob doesn't love Alice._

> **— go'i**
> _— He doesn't (love)._

In order to say "No, he does love her" we use the needed verb directly:

> **— la .bob. na ku prami la .alis.**
> _Bob doesn't love Alice._

> **— ja'a ku go'i**
> _Bob does love Alice._

Here, **ja'a ku** replaces **na ku** in the original relation. -->

### Time of day

> **— ma tcika ti**
> _What's the time?_

<!-- -->

> **— li cacra bu pa pa**
> _Eleven hours_

tcika
: $x_1$ (hours, minutes, seconds) is the time of event $x_2$

In Lojban, times are always the times of something. So we ask what the time is of **ti**, meaning _this event/thing_, or, in other words, _now_.

**li**, a prefix for numbers, is used for timestamps too.

- **cacra bu** is a prefix signaling that the number of hours follows. 24-hour time is used almost always in Lojban.
- **mentu bu** is a prefix signaling that the number of minutes follows.
- **snidu bu** is a prefix signaling that the number of seconds follows.

> **li cacra bu pa pa mentu bu pa no**
> _11:10 (Ten minutes past eleven)_

<!-- -->

> **li cacra bu pa pa mentu bu pa no snidu bu pa ci**
> _11 hours, 10 minutes and 13 seconds._

<!-- -->

> **li cacra bu pa no mentu bu mu no**
> _10:50, ten to eleven_

If we want to give the time of an event, rather than just tell the time, the second place is filled:

> **li cacra bu pa no tcika le nu mi klama**
> _Ten o'clock is the time that I come._

By using the term **de'i** we can get a more naturally sounding sentence:

> **mi klama de'i li cacra bu pa no**
> _I am coming at 10 o'clock._

de'i
: at … (time), on … (date)

And one useful example:

> **ca tcika le nu .ei sipna**
> _It's time to sleep._

### Dates

> **— ma detri ti**
> _What's the date today?_

> **— li mastu bu ze djedi bu pa**
> _It's July, 1._

detri
: $x_1$ (year, month, day) is the date/time of event $x_2$

Another option:

> **— ma ca detri**
> _— What is the date now?_

- **nanca bu** is a prefix signaling that the year follows.
- **masti bu** is a prefix signaling that the month follows.
- **jefydei bu** is a prefix signaling that the day of week follows.
- **djedi bu** is a prefix signaling that the day follows.

Prefixes with numbers after them can be used in any order (let's use digits to show numbers):

> **li djedi bu 2 ca detri**
> _It's the second day of the month now._

<!-- -->

> **li masti bu 4 djedi bu 1 ca detri**
> _It's April, the first now._

<!-- -->

> **li djedi bu 5 masti bu 7 nanca bu 2005 detri le nu mi jbena**
> _The fifth of July (seventh month), year 2005 is when I was born._

jbena
: $x_1$ is born

We can also use **de'i**:

> **mi ba klama de'i li masti bu pano**
> _I will come in October._

Particles in Lojban can be written without spaces in between, like in this **pano**, which is the same as **pa no**.

For days of the week, usually, Monday is the first day:

> **mi gunka de'i li jefydei bu pa**
> _I work on Monday._

<!-- -->

> **mi gunka ca ro se detri be li jefydei bu re**
> _I work every Tuesday._

<!-- -->

> **xu do pu zvati la .paris. de'i li jefydei bu ci**
> _Were you in Paris on Wednesday?_

### Specifying time intervals

> **mi nanca li re re**
> _I am 22 years old._

nanca
: $x_1$ is of duration of $x_2$ (number) years

**nanca** specifies the duration, and to say _two years long_, fill the second place with a number prefixed by **li**.

> **le verba cu masti li re**
> _The child is two months old._

masti
: $x_1$ is $x_2$ months long

> **le nu carvi cu djedi li ci**
> _It's raining for three days._

djedi
: $x_1$ (event) is $x_2$ (number) full days long

### New verbs from one scale: ‘_other than_’ — «**na'e**», ‘_anti-_’ — «**to'e**»

> **mi na'e nelci do**
> _I other than like you._

"Left scalar" particles (to which **na'e** belongs) are placed to the left of constructs they affect, forming a scale:

The scale itself can be specified using the modal tag **ci'u**.

- **je'a** = _indeed (the affirmative position on the scale)_. The word **je'a** confirms the meaning of a part of a sentence. Usually, it's just omitted.

 > **mi je'a nelci do**
 > _I indeed like you._

- **na'e** = _non- (other than the affirmative position on the scale)_

 > **mi na'e nelci do**
 > _I other than like you._

 > **le stizu cu na'e xunre be ci'u le ka skari**
 > _The chair is of a non-red color._
 > `The chair is other-than red on the scale of having a color`

- **no'e** = _not really (midpoint on the scale)_. The word **no'e** gives a part of a sentence a middle meaning.

 > **mi no'e nelci do**
 > _As for whether I love or hate you, I'm indifferent to you. I neither like nor hate you._

- **to'e** = _anti-, dis-, mis- etc. (opposite on the scale)_. The word **to'e** gives a part of a sentence an opposite meaning. It's similar to the English prefix _anti-_.

 > **mi to'e nelci do**
 > _I hate you._
 > `I anti-like you`

**na'e** is more vague than **no'e** and **to'e**; it can mean any of them when you don't care about the exact meaning.

### Complex modal terms: ‘_because_’ — «**ki'u**», ‘_despite_’ — «**to'e ki'u nai**»

Modal terms can be negated in two ways to obtain related meanings.

ki'u
: modal term: because, due to explanation …, which can be explained by the fact that …

> **ki'u ma do cusku zo co'o**
> _Why do you say goodbye?_

Adding the suffix **nai** changes the meaning:

ki'u nai
: modal term: not because, which cannot be explained by the fact that …?!

> **mi se nabmi ki'u nai le nu mi laldo ce'e ki'u le nu mi na certu**
> _I'm in trouble not because I'm old but because I'm not an expert._

nabmi
: $x_1$ is a problem to $x_2$

se nabmi
: $x_1$ has a problem $x_2$

laldo
: $x_1$ is old …

certu
: $x_1$ is an expert, professional in property $x_2$

Adding **to'e** sets the negation of the meaning:

to'e ki'u
: because not, which can be explained by the fact that it does not happen that …

> **mi jinga to'e ki'u le nu mi pu surla**
> _I won because I hadn't rested._

Combining both **to'e** and **nai** we get:

to'e ki'u nai
: despite the reason …, not because not, which cannot be explained by the fact that it does not happen…, 

> **.i to'e ki'u nai le nu le mamta cu sanga su'o melbi kei le verba na snada lo ka sipna**
> _Despite the mother singing beautifully, the child doesn't succeed in falling asleep._

Using **se** changes the order of arguments. Otherwise, the meaning is preserved.

se ki'u
: therefore, which explains the fact that …

> **ra bilma se ki'u le nu ra na pu cusku zo coi do**
> _He is ill, which explains why he didn't say hello to you._

se ki'u nai
: but it does not follow that …, which does not explain the fact that …

> **ra bilma se ki'u nai le nu ra klama le drata tcadu**
> _He is ill, which doesn't explain why he is going to another city._

se to'e ki'u
: …, the absence of which explains the fact that …

> **ra bilma se to'e ki'u le nu ra klama le drata tcadu**
> _He is not ill, and that explains why he is going to another city._

se to'e ki'u nai
: …, the absence of which does not explain the fact that …

> **ra bilma se to'e ki'u nai le nu ra penmi le mikce**
> _He is not ill, and that doesn't explain why he is meeting the doctor._

mikce
: $x_1$ is a doctor