## Lesson 5. Modal terms, «**da**», their relative position

### How do modal terms refer to the relation?

Some modal terms, like those that describe time (tense), connect the current relation with the one in the argument after them:

> **mi cadzu ca le nu le cipni cu vofli**
> _I walk when the birds fly._

cadzu
: … walks

le cipni
: the bird/birds

vofli
: … flies to …

> **mi pu cadzu fa'a le rirxe**
> _I walked towards the river._

<!-- -->

> **mi pu cadzu se ka'a le rirxe**
> _I walked to the river._

se ka'a
: coming to …

fa'a
: directly towards …

Modal terms don't remove ordered places (**fa**, **fe**, **fi**, **fo**, **fu**) from the relation:

> **mi klama se ka'a le rirxe le dinju**
> **mi klama fe le rirxe .e le dinju**
> _I go to a river, to a house._

In the first example, **se ka'a** connects **le rirxe** and then the second place of **klama** follows, being filled with **le dinju**. It's the same as just filling the second place of **klama** two times, connecting them with **.e** — _and_.

However, **se ka'a** is useful when applied to other relations like **cadzu** in a previous example.

> **le prenu pu cadzu tai le nu ri bevri su'o da poi tilju**
> _The person walked as if he was carrying something heavy._

bevri
: $x_1$ carries $x_2$

tai
: modal term: like …, resembling …

<!--
- Some terms describe relations of the first place of the relation with the noun after the term:

>**mi jinga se rai le ka clani**
>_I win being the tallest one._

se rai
: term from **se traji**: being most in …

Here $x_1$ of the relation corresponds to the most one in comparison specified after **se rai**.

- Finally, some terms describe relations of the first place of the relation and the relation itself with the noun after the term:

>**le fragari cu se nelci mi te rai le'i jbari**
>_Out of berries, I like strawberries most._

te rai
: term from **te traji**: preferring out of …

lo fragari
: strawberries

lo jbari
: berries

$x_1$ of the relation describes the most one in this comparison, the relation itself describes the comparison.

The dictionary explains such tricky cases where the relation defined by the term might pose difficulty. In practice, the relation is often clear from the examples provided. -->

### Using «**ne**» + term. «**se mau**» — ‘_more than …_’

> **mi ne se mau do cu melbi**
> _I am prettier than you._

se mau
: term from **se zmadu**: more than; the relation itself describes the comparison

This example is similar to

> **mi zmadu do le ka melbi**
> _I exceed you in prettiness._

In other words, the main relation **melbi** is similar to the third place of **zmadu**, which specifies the comparison criteria. Two more examples:

> **mi prami do ne se mau la .doris.**
> _I love you more than Doris._

<!-- -->

> **mi ne se mau la .doris. cu prami do**
> _I love you more than Doris does._
> _I love you more than Doris loves you._
> `I (more than Doris) love you.`

More examples:

> **mi nelci le'e pesxu ne se mau le'e jisra**
> _I like jam more than juice._

pesxu
: … is jam

> **le'e pesxu cu zmadu le'e jisra le ka mi nelci**
> _I like jam more than juice._
> `Jam exceeds juice in how much I like it.`

And now an interesting sentence:

> _Bob likes Betty more than Mary._

It can mean two different things in English!

1. Bob likes Betty and he likes Mary less.
2. Bob likes Betty but Mary likes Betty too, though not as much as Bob does!

Do we compare Betty with Mary in how Bob likes them?

Or instead we compare Bob with Mary in how they like Betty?

English is ambiguous in this regard.

In Lojban, we can differentiate the two meanings by attaching **se mau** to suitable arguments:

> **la .bob. ne se mau la .maris. cu nelci la .betis.**
> _Bob (compared to Mary) likes Betty more. Mary likes Betty less._
> _Bob likes Betty more than Mary._

<!-- -->

> **la .bob. cu nelci la .betis. ne se mau la .maris.**
> _Bob likes Betty, and he like Mary less._
> _Bob likes Betty more than Mary._

### Comparisons: ‘_equal_’, ‘_the same_’

> **mi dunli le mensi be mi le ka mitre .i ku'i mi na ku du le mensi**
> _I am as big as my sister. But I'm not her._
> I equal the sister of me in meters. But I am not identical to the sister._

dunli
: $x_1$ (any type) is equal to $x_2$ (any type) in $x_3$ (property of $x_1$ and $x_2$ with **kau**)

mitre
: $x_1$ is $x_2$ meters long

du
: $x_1$ (any type) is identical to $x_2$ (any type)

**dunli** compares two places for a single property, while **du** compares for identity. My sister and I are the same height, but we are not the same person. Clark Kent and Superman have different admirers, but they are the same person.

The same goes for these two verbs:

> **mi frica do le ka nelci ma kau**
> *We differ from each other in what we like.*
> _I differ from you in liking what._

<!-- -->

> **le drata be mi cu kakne le ka sidju**
> *Someone other than me is able to help.*

frica
: $x_1$ (any type) differs from $x_2$ (any type) in $x_3$ (property of $x_1$ and $x_2$ with **kau**)

drata
: $x_1$ (any type) is not the same as $x_2$ (any type)

### The concept of ‘_only_’

> **mi .e no le pendo be mi cu nelci le'e badna**
> _I and none of my friends like bananas._
> _Among my friends I'm the only one who likes bananas._

The concept of _not only_ is similarly expressed:

> **mi .e le su'o pendo be mi cu nelci le'e badna**
> _It's not just me who likes bananas among my friends._
> _I and some of my friends like bananas._

<!-- A more precise one:

> **mi se steci le ka nelci le'e badna kei le'i pendo be mi**
> _I'm the only one who likes bananas among my friends._ (by the way, implying that you are a friend to yourself)

se steci
: $x_1$ is the only one in $x_2$ (property of $x_1$) among $x_3$ (set) -->

<!-- Note that this example implies that you are a friend to yourself :) Otherwise, please, use an even more precise statement:

> **mi se steci le ka nelci le'e badna kei le'i me mi .e le pendo be mi**
> _I'm the only one who likes bananas among the set of me and my friends._ -->

<!-- Negating this we get:

> **na ku mi se steci le ka nelci le'e badna**
> _It's not true that only I like bananas._

— maybe no one likes bananas, maybe me + others lime them. -->

<!-- One more interesting example:

> **le'e troci cu se steci le ka snada**
> _Only the one who tries succeeds._
> `Who tries is the only one who succeeds.`

> **le'e po'o zukte be le ka troci cu fliba**
> _The only who only tries fails._
> `The one who does attempts and nothing but it fails.`

troci
: $x_1$ tries to do $x_2$ (property of $x_1$)

snada
: $x_1$ succeeds in doing $x_2$ (property of $x_1$)
.
fliba
: $x_1$ fails in doing $x_2$ (property of $x_1$)

And one more solution:

> **ro snada pu troci**
> _Everyone who succeeds tried._

ro
: number: each, every

As you can see, Lojban offers different methods of saying the same, some of which can significantly differ from English forms. -->

### ‘_Most_’, ‘_many_’ and ‘_too much_’

Words like _most_ and _many_ are also numbers in Lojban:

<table>
<tbody><tr>
<td><b>ro</b>
</td>
<td><i>each</i>
</td></tr>
<tr>
<td><b>so'a</b>
</td>
<td><i>almost all</i>
</td></tr>
<tr>
<td><b>so'e</b>
</td>
<td><i>most</i>
</td></tr>
<tr>
<td><b>so'i</b>
</td>
<td><i>many</i>, <i>a lot of</i>
</td></tr>
<tr>
<td><b>so'o</b>
</td>
<td><i>several</i>
</td></tr>
<tr>
<td><b>so'u</b>
</td>
<td><i>few</i>
</td></tr>
<tr>
<td><b>no</b>
</td>
<td><i>zero</i>, <i>none</i>
</td></tr>
<tr>
<td><b>su'e</b>
</td>
<td><i>at most</i>
</td></tr>
<tr>
<td><b>su'o</b>
</td>
<td><i>at least</i>
</td></tr>
<tr>
<td><b>za'u</b>
</td>
<td><i>more than …</i>
</td></tr>
<tr>
<td><b>du'e</b>
</td>
<td><i>too many</i>
</td></tr></tbody></table>

Some examples:

> **su'e re no le prenu ba klama**
> _No more than 20 of the people will come._

<!-- -->

> **su'o pa le prenu cu prami do**
> _At least one person loves you._

### ‘_never_’ — «**no roi**», ‘_always_’ — «**ro roi**»

Terms specifying the number of times:

- **no roi** = _never_
- **pa roi** = _once_
- **re roi** = _twice_
- **ci roi** = _thrice_

…

- **so'i roi** = _many times_
- **so'u roi** = _a few times_
- **du'e roi** = _too many times_
- **ro roi** = _always_

> **mi du'e roi klama le zarci**
> _I go to the market too often._

zarci
: $x_1$ is a market

> **mi pu re roi klama le zarci**
> _I went to the market twice._

Without **pu**, the construct **re roi** may mean that I went to the market once but the second time I will be there will only happen in the future. These time-related particles can be used with an argument after them:

> **mi klama ti pa roi le jeftu**
> _I come here once a week._

### ‘_for the first time_’ — «**pa re'u**», ‘_for the last time_’ — «**ro re'u**»

- **pa re'u** = _for the first time_
- **re re'u** = _for the second time_

…

- **za'u re'u** = _again_
- **ro re'u** = _for the last time_

The time-related particle **re'u** works like **roi**, but tells the number of iterations for which the event occurs.

Compare:

> **mi pa roi klama le muzga**
> _I visited the museum once._

<!-- -->

> **mi pa re'u klama le muzga**
> _I visited the museum for the first time._

<!-- -->

> **mi za'u roi klama le muzga**
> _I visited the museum more times._

<!-- -->

> **mi za'u re'u klama le muzga**
> _I visited the museum again._

<!-- -->

> **mi za'u pa roi klama le muzga**
> _I visited the museum more than once._

<!-- -->

> **mi za'u pa re'u klama le muzga**
> _I visited the museum not for the first time (maybe for the second/third etc.))_

vitke
: to visit (somebody or something)

Note the difference between:

za'u re'u
: again, not for the first time

re re'u
: for the second time (same here, no context is needed, and even the exact number of times is given)

### Modal particles: their location within a relation

> **le nu tcidu kei ca cu nandu**
> _Reading is now difficult._

<!-- -->

> **ca ku le nu tcidu cu nandu**
> _Now reading is difficult._

Bare terms without arguments after them can be moved around the sentence by adding **ku** after them.

**ku** prevents the following argument terms from attaching to such terms. Compare:

> **ca le nu tcidu cu nandu**
> _When reading, it's difficult._

Here are several places where modal particles can go.

- Modal term modifies the relation to the right of it:

 >**ca ku mi citka**
 >_Now I eat._

  — here the term is labeled with a word **ku** as being completed.

 >**ca le cabdei mi citka**
 >_Today I eat._

  — here the term has an argument after it.

 >**mi ca citka**
 >_I now eat._

  — here the modal particle is a part of the main relation construct and without an argument.

- Modal term is applied to the whole relation:

 >**mi citka ca**
 >_I eat now._

  — here the modal term at the end of the relation.

### Joining statements with modals

> **mi pinxe le jisra ca le nu do co'i klama le zdani**
> _I am drinking the juice when you come home._

<!-- -->

> **mi pinxe le jisra .i ca bo do co'i klama le zdani**
> _I am drinking the juice, and at the same time you come home._

The two examples convey the same meaning. The second option is mostly used when any of the original relations sound bulky.

Another use is to move modal terms out of scope of other modal terms:

> **mi na ku te vecnu ki'u le nu kargu**
> _It's not true that I buy because it's expensive._

In this example, one might suppose that I only buy things if they are expensive. However, that's not the case.

Here, **na ku** negates that _I buy things because they are expensive_. **na ku** is applied to the whole relation, thus it "covers" **ki'u**.

> **mi na ku te vecnu .i ki'u bo kargu**
> _I don't buy. It's because it's expensive._

In this case, I don't buy things. Why? Because they are expensive. Maybe I prefer only cheap things.

Here, **ki'u** is placed in another sentence. Thus, **na ku** doesn't scope over it.

Both examples could be translated as _I don't buy because it's expensive._ However, they mean different things.

A special rule is for using **.i ba bo** and **.i pu bo**. Compare:

> **mi cadzu pu le nu mi citka**
> _I walk before I eat._

<!-- -->

> **mi cadzu .i ba bo mi citka**
> _I walk, and then I eat._

**.i ba bo** means _afterwards, then_. The sentence after **.i ba bo** refers to something that took place later than what took place in the relation before.

**pu** is changed into **ba**, and vice versa. This special rule for Lojban was made by analogy of natural languages. So you just have to remember this special behavior of these two words.

### Existing things, ‘_there are …_’

There are actually three words in the **da** series: **da**, **de**, and **di**. We use them when referring to different objects in one discourse:

> **ci le mlatu cu citka re le finpe**
> _There are three cats, there are two fishes for each cat, and each cat eats two fishes._

If you need more such words in one discourse add a suffix **xi** to them and then any number (which we can call an index). Thus,

- **da xi pa** is the same as simple **da**,
- **da xi re** is the same as **de**,
- **da xi ci** is the same as **di**
- **da xi vo** is the fourth "something" and so on …

### Topic and comment. «**zo'u**»

Sometimes it is useful to show the topic of a relation and then say a comment about it:

> **le'e finpe zo'u mi nelci le'e salmone**
> _As for fish I like salmon._

salmone
: … is a salmon

zo'u
: ends the topic and starts the comment of the relation

**zo'u** is more useful when a pronoun like **da** is defined in the topic and then used in the comment:

> **su'o da zo'u mi viska da**
> _There is a thing such that I see it._

<!-- -->

> **ro da poi gerku zo'u mi nelci da**
> _For each thing that is a dog: I like it._
> _I like all dogs._

<!-- -->

> **da de zo'u da viska de**
> _There is **da** and **de** such that **da** sees **de**._

The two pronouns **da** and **de** indicate that there are two things which stand in the relationship that one sees the other. It might be the case that the supposed two things are really just a single thing that loves itself: nothing in the sentence rules out that interpretation, which is why the colloquial translation does not say _Somebody sees somebody else._ The things referred to by different pronouns of **da** series may be different or the same.

It is perfectly okay for these pronouns to appear more than once in the same sentence:

> **da zo'u da prami da**
> _There is **da** such that **da** loves **da**. There is someone who loves himself/herself._

It is not necessary for a pronoun to be the direct argument of the relation:

> **da zo'u le gerku pe da cu viska mi**
> _There is **da** such that the dog of them sees me. Somebody's dog sees me._

### ‘_any_’ and ‘_some_’ in examples

The words _any_ and _some_, along with their derivatives, have many meanings in English. We should be careful when translating the intended meaning:

Translating as **da**:

- _some_: something unspecified:

 >**da pu klama .i je ko smadi le du'u da me ma kau**
 >_Somebody came. Guess who it was._

  <!-- -->

 >**mi pu tirna da .i je mi fliba le ka jimpe le du'u da mo kau**
 >_I heard something, but I fail to understand what it was._

- _some_ in questions turns into _anything_, _anybody_; in Lojban, it's still **da**:

 >**xu su'o da pu klama**
 >_Did anybody come?_

- _some_ when using commands, requests, or suggestions:

 >**.e'u mi'o pilno su'o da poi drata**
 >_Let's try something else. Let's try other things._

  <!-- -->

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Let's try somewhere else._

- _any_ can be used in inner relations:

 >**mi rivbi le ka jdice da**
 >_I avoided taking any decision._

 Like in relations inside modal terms:

 >**ba le nu do zgana da kei ko klama**
 >_After you notice anything, come!_

- Scope: _any_ is used in English when negating, while Lojban uses **na ku** but then still **da**:

 >**mi na ku viska su'o da poi prenu**
 >_I don't see anybody._

- _any_ is used when making no distinction among members we talk about:

 >**.au nai mi tavla su'o da poi na ku slabu mi**
 >_I don't want to talk to just anybody._

- Scope: Negation should be used in an appropriate relation, as shown below:

 >**mi jinvi le du'u na ku da jimpe**
 >_I don't think that anybody understands._

 This can be rephrased as:

 >**mi jinvi le du'u no da jimpe**
 >_I think that nobody understands._

- In comparisons, _every_ is turned into _any_ and translated as **ro da**:

 >**do zmadu ro da le ka se canlu**
 >_You are taller than anybody._
 >`You exceed everybody in size.`

- When providing choice, _any_ is used and translated as **ro da**:

 >**ro da poi do nelci zo'u .e'a do citka da**
 >_You may eat anything you like._
 >`For everything that you like, I allow you to eat it.`

- For terms like _anyone_ and _somewhere_:

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Let's try somewhere else._

 Here, **su'o da poi drata** means _any other thing or things, place or places_. The number of such places is not specified, although any such place might fit.

 To say _any place but only one place_, use:

 >**.e'u mi'o troci bu'u pa da poi drata**
 >_Let's try at another place._

- Translating _any_ as **le'e** in generic statements:

 >**le'e gerku cu se tuple le vo da**
 >_Any dog has four legs. Dogs are expected to have four legs._

- Using **le** when describing specific objects, places, or events:

 >**le drata zo'u .e'u mi'o pilno ri**
 >_The other thing, let's use it._

 >**le drata stuzi zo'u .e'u mi'o troci bu'u ri**
 >_The other place, let's try there._

### Resume: which constructs does scope affect?

Scope is created only by:

- borders of relations,
- modal terms and modal particles of the main relation construct,
- argument terms starting with numbers (like **pa le prenu** — _one of the persons_).
<!-- - discursive interjections **po'o**, **ji'a**. -->

**da**, **de**, **di** if used without a prenex and without an explicit number in front are meant to mean **su'o da**, **su'o de**, **su'o di** and thus also create scope.

Thus, the relative order of such constructs changes the meaning:

> **pa le prenu ca ku zvati**
> _There is one person who is now present._

> **ca ku pa le prenu ca zvati**
> _Now there is one person._

Scope isn't relevant for relation constructs and for arguments starting with **le** (like **le prenu** or **le re prenu**). Both these sentences mean the same:

> **le prenu ca ku zvati le zdani**
> **ca ku le prenu cu zvati le zdani**
> **ca ku fe le zdani fa le prenu cu zvati**
> _People are now present._

Modal term scopes from where it's used to the right of the relation until the relation and all its inner relations (if present) end.

Here, **ki'u le nu kargu** is under the scope of **na ku**:

> **na ku mi te vecnu ki'u le nu kargu**
> _It's not true that: I buy because it's expensive._

But here, **ki'u le ne kargu** is not under the scope of **na ku**. **ki'u** is applied to the whole previous sentence, including **na ku**:

> **mi na ku te vecnu .i ki'u bo kargu**
> _I don't buy. It's because it's expensive._