## Lesson 4. Practice

Now we know the most crucial parts of the grammar and can start accumulating new words through situations.

### Colloquial expressions

Here are some common structures used by fluent speakers of Lojban, along with examples illustrating their usage.

They may help you get used to colloquial Lojban more quickly.

- <dl><dt>.i ku'i</dt><dd>But…</dd></dl>
 > **mi djuno .i ku'i mi na ku djica**
 > _I know. But I don't want._
- <dl><dt>mi djica le nu</dt><dd>I want that …</dd></dl>

 > **mi djica le nu mi sipna**
 > _I want to sleep._
 > `I want that I sleep.`
- <dl><dt>mi djuno le du'u ma kau</dt><dd>I know what/who …</dd></dl>

 > **mi djuno le du'u ma kau smuni zo coi**
 > _I know what is the meaning of **coi**._

 <!-- -->

 > **mi na ku djuno**
 > _I don't know._
- <dl><dt>jinvi le du'u</dt><dd>… has an opinion that …</dd></dl>

 > **mi jinvi le du'u la .lojban. cu zabna**
 > _I think that Lojban is cool._

 <!-- -->

 > **coi ro do**
 > _Hello, everyone!_

 <!-- -->

 > **co'o ro do**
 > _Bye, everyone!_
- <dl><dt>jinvi le du'u</dt><dd>… has an opinion that …</dd></dl>

 > **ai mi cliva .i co'o**
 > _I'm going to leave. Bye!_
- <dl><dt>.ei mi</dt><dd>I should …</dd></dl>

 > **.ei mi citka .i co'o**
 > _I should eat. Bye!_
- <dl><dt>ca le nu</dt><dd>when …</dd></dl>

 > **mi pu bebna ca le nu mi citno**
 > _I was stupid when I was young._
- <dl><dt>va'o le nu</dt><dd>provided that …</dd></dl>

 > **va'o le nu do djica kei mi ka'e ciksi**
 > _If you want I can explain._
- <dl><dt>simlu le ka</dt><dd>… seems to be …</dd></dl>

 > **simlu le ka zabna**
 > _It seems to be cool._
- <dl><dt>ca le cabdei</dt><dd>today</dd></dl>

 > **pu ce'e ca le cabdei mi surla**
 > _Today I took a rest._
- <dl><dt>mi nelci</dt><dd>I like</dd></dl>

 > **mi nelci le mlatu**
 > _I like the cat._
- <dl><dt>le nu pilno</dt><dd>using …</dd></dl>

 > **na ku le nu pilno le vlaste cu nandu**
 > _Using dictionaries isn't hard._
- <dl><dt>kakne le ka</dt><dd>capable of …</dd></dl>

 > **xu do kakne le ka sutra tavla**
 > _Are you able to talk quickly?_
- <dl><dt>tavla fi</dt><dd>talk about …</dd></dl>

 > **.e'ei tavla fi le skami**
 > _Let's talk about computers!_
- <dl><dt>mutce le ka</dt><dd>very …</dd></dl>

 > **mi mutce le ka se cinri**
 > _I am very interested._
- <dl><dt>troci le ka</dt><dd>… tries to …</dd></dl>

 > **mi troci le ka tavla fo la .lojban.**
 > _I am trying to talk in Lojban._
- <dl><dt>rinka le nu</dt><dd>(event) leads to …</dd></dl>

 > **le nu mi tadni la .lojban. cu rinka le nu mi jimpe fi do**
 > _That I study Lojban makes me understand you._
- <dl><dt>gasnu le nu</dt><dd>(agent) causes …</dd></dl>

 > **mi pu gasnu le nu le skami pe mi co'a spofu**
 > _I made it so that my computer got broken._
- <dl><dt>xusra le du'u</dt><dd>assert that …</dd></dl>

 > **xu do xusra le du'u mi na ku drani**
 > _Do you state that I am not right?_
- <dl><dt>kanpe le du'u</dt><dd>expect (in the sense of assessment, prediction) that …</dd></dl>

 <!-- -->

 > **mi na ku kanpe le du'u mi jinga**
 > _I don't expect myself to win._

### A simple dialogue

> **coi la .alis.**
> _Hi, Alice!_
<!-- -->
> **coi la .doris.**
> _Hi, Doris!_
<!-- -->
> **do mo**
>_How are you?_
<!-- -->
> **mi kanro .i mi ca tadni la .lojban. .i mi troci le ka tavla do**
> _I'm healthy. I now study Lojban. I'm trying to talk to you._

kanro
: to be healthy

tadni
: to study … (something)

troci
: to try … (to do something)

tavla
: to talk [to someone]

> **zabna .i ma tcima ca le bavlamdei**
> _Good. What will be the weather tomorrow?_

zabna
: … is nice, cool

tcima
: … is the weather

ca
: at (some time)

le bavlamdei
: tomorrow day (day as an event)

> **mi na ku djuno .i le solri sei mi pacna**
> _I don't know. It'll be sunny, I hope._

djuno
: to know (fact)

le solri
: the sun

Note that **le solri cu tcima** (literally _the sun is the weather_) is the way of using **tcima** in Lojban.

sei
: comment starts

pacna
: to hope (for some event)

> **mi jimpe**
> _I understand._

> **co'o**
> _Goodbye._

### Human senses

> **ju'i la .alis.**
> _Hey, Alice!_

ju'i
: vocative that draws attention: _Hey! Psst! Ahem! Attention!_

> **re'i**
> _Listening._

re'i
: vocative: _I'm ready to receive information._

> **xu do viska ta**
> _Do you see that thing near you?_

In English we say _Сan you see_, in Lojban we say just **xu do viska** — _You see?_

----

Relations describing perception will be explained after the dialogue.

> **viska .i plise**
> **.i le plise cu xunre .i skari le ka xunre**
> _Yes. It is an apple._
> _The apple is red. It's colored red._

> **xu do viska le tarmi be le plise**
> _Can you see the form of the apple?_

<!-- -->

> **viska .i le plise cu barda**
> _Yes. The apple is big._

<!-- -->

> **xu do jinvi le du'u le plise ca makcu**
> _Do you think that the apple is ripe?_

makcu
: … is ripe

> **.au mi zgana le sefta be le plise**
> _I'd like to palpate it._

> **.i ua xutla**
> _Oh, it is smooth._

> **.i mi pacna le nu makcu ie**
> _I hope that it is ripe, yeah._

<!-- -->

> **panci pei**
> _What about the smell?_

> **.i .e'o do sumne le plise**
> _Please, smell it._

<!-- -->

> **le xrula cu panci**
> _It smells of flowers._

> **.i .au mi zgana le vrusi be le plise**
> _I'd like to taste the apple._

> **.i .oi nai le kukte cu vrusi**
> _Yum, it tastes sweet._

> **.i .oi**
> _Oh-no._

le xrula
: the flower(s)

<pixra url="/assets/pixra/cilre/xrula.webp" caption="xrula" definition="flower"></pixra>

> **ma pu fasnu**
> _What happened?_

<!-- -->

> **mi pu farlu**
> _I fell down._

farlu
: ... falls down to ...

<!-- -->

> **xu do cortu**
> _Do you feel pain?_

<!-- -->

> **cortu .i mi cortu le cidni**
> _Yes, I feel pain in the knee._

> **.i na ku ckape**
> _It's not dangerous._

> **.i ca ti mi ganse le nu da vi zvati**
> _And now I can sense a presence of someone here._

<!-- -->

> **doi la .alis. do cliva .e'o sai**
> _Alice, please, return immediately!_

<!-- -->

> **ko denpa .i mi ca tirna le sance**
> _Wait, I can hear some sound._

<!-- -->

> **le sance be ma**
> _A sound of what?_

<!-- -->

> **mi pu tirna le nu le prenu cu tavla**
> _I heard a person talking._

> **.i ca ti mi zgana le lenku**
> _Now I feel cold._

<!-- -->

> **ju'i la .alis.**
> _Hey, Alice!.._

In this dialogue, the most important concepts for human senses were touched. In the following sections we shall explain their place structures, along with additional relations and examples.

#### Vision

viska
: $x_1$ sees $x_2$ (object, form, color)

skari
: $x_1$ is an object with the color $x_2$ (property)

tarmi
: $x_1$ is the form of $x_2$

cukla
: $x_1$ is round (in form)

<pixra url="/assets/pixra/cilre/coha_viska.webp" caption="le prenu co'a viska le cipni" definition="The person notices, begins to see the bird."></pixra>

> **mi viska le plise**
> _I see the apple._

> **mi viska le tarmi be le plise**
> _I see the form of the apple._

> **.i le plise cu se tarmi le cukla**
> _The apple is round._


<!-- -->
<!-- > **mi viska le se skari be le plise**
> _I see the color of the apple._ -->

> **.i le plise cu skari le ka xunre**
> _The apple is colored red._

Note: we can both say _see the form of the apple_ and _see the apple_.

#### Hearing

tirna
: $x_1$ hears $x_2$ (object or sound)

<pixra url="/assets/pixra/cilre/le_prenu_cu_tirna_lei_djacu.webp" caption="le prenu cu tirna lei djacu" definition="The person hears the waters."></pixra>

> **mi tirna le palta**
> _I hear the plate_

<!-- -->

> **mi tirna le sance be le palta poi ca'o porpi**
> _I hear the sound of a plate that is falling._

> **.i le palta cu se sance le cladu**
> _It sounds loud._


le palta
: the plate

cladu
: $x_1$ is loud

tolycladu
: $x_1$ is quite in sound

tonga
: $x_1$ is a tone of $x_2$

We can use **cladu** and similar words directly:

> **mi tirna le cladu**
> _I hear something loud._

<!-- -->

> **mi tirna le tolycladu**
> _I hear something quite in sound._

<!-- -->

> **mi tirna le tonga be le palta poi farlu**
> _I hear the tone of the plate falling down._

Similarly to vision, we can say _hear a sound_ and _hear something producing the sound_:

> **— ma sance gi'e se tirna do**
> _— What sound do you hear?_

> **— le zgike**
> _— The music._

<!-- -->

> **— do tirna le sance be ma**
> _— You hear a sound of what?_

> **— le plise poi co'i farlu**
> _— The apple that has fallen down._

#### Perception in general

We can also use the vague **ganse** — _to sense stimulus_.

ganse
: $x_1$ senses stimulus $x_2$ (object, event) by means $x_3$

ganse le glare
: to feel the heat

ganse le lenku
: to feel the cold

> **mi ganse le plise**
> _I sense the apple._

<!-- -->

For observing our perceptions we can use **zgana**:

<pixra url="/assets/pixra/cilre/zgana_le_sefta.webp" caption="le prenu cu zgana le sefta be le xrula" definition="The person palpates the surface of the flower."></pixra>

> **mi zgana le tarmi be le plise**
> _I observe the form of an apple._

> **.i le plise cu se tarmi le'e cukla**
> _The apple is round._

zgana
: $x_1$ notices, observes, watches $x_2$. Not limited to vision

Some arguments can be used with different sensory relations. For example, we can

viska le sefta
: to see the surface

zgana le sefta
: to palpate the surface


#### Sense of smell

sumne
: $x_1$ smells $x_2$ (odor)

panci
: $x_1$ is an odor of $x_2$ (object)

<pixra url="/assets/pixra/cilre/sumne.webp" caption="le mlatu cu sumne le xrula" definition="The cat smells the flower."></pixra>

> **mi sumne le xrula**
> _I smell the flower._


<!-- -->

> **mi sumne le panci be le za'u xrula**
> _I smell the odor of flowers._

<!-- -->

> **mi sumne le panci be le plise**
> _I smell the odor of the apple._

> **.i le plise cu se panci le xrula**
> _The apple smells of flowers._

Note that English can be confusing when it comes to distinguishing between smelling an odor and smelling an object that produces that odor. We say _to smell the apple_, _the apple smells of flowers (has the scent of flowers)_. This two-fold distinction is important because an apple produces aromatic particles that are distinct from the apple itself. The same applies to a falling plate and its sound — we may not want to mix them.

In Lojban, we can easily separate these cases, as demonstrated in the examples above.


#### Sense of taste

vrusi
: $x_1$ is a taste of $x_2$

<pixra url="/assets/pixra/cilre/se_vrusi_lo_ka_kukte.webp" caption="le prenu cu zgana le vrusi be le grute" definition="The person tastes, observes the taste of the fruit."></pixra>

> **mi zgana le vrusi be le grute**
> _I taste the apple._
> `I observe the taste of the fruit`

le grute
: the fruit, the fruits
<!-- -->

> **.i le plise cu se vrusi le titla**
> _The apple tastes sweet._

titla
: … is sweet, … is a sweetie

#### Sense of touch

sefta
: $x_1$ is a surface of $x_2$

> **mi zgana le sefta be le plise**
> _I palpate, touch-feel the surface of the apple._

<!-- -->

> **.i le plise cu se sefta le xutla**
> _The apple has a smooth surface._

#### Pain

> **mi cortu le birka be mi**
> _I feel pain in my arm._
> _My arm hurts._

<!-- -->

<pixra url="/assets/pixra/cilre/cortu.webp" caption="mi cortu le cidni be mi" definition="My knee hurts."></pixra>

> **mi cortu le cidni**
> _I feel pain in my knee, my knee hurts._

cortu
: $x_1$ has pain in organ $x_2$, which is a part of $x_1$\'s body

cidni
: $x_1$ is a knee of $x_2$

#### Colors

Different languages use different sets of words to denote colors. Some languages simply refer to colors by referencing other "prototype" objects with similar colors, shades, or forms. In Lojban, we use all the options:

> **ti xunre**
> _This is red._

xunre
: $x_1$ is red

> **ti skari le ka xunre**
> _This is red. This has the color or red things._

<!-- -->

> **ti skari le ka ciblu**
> _This has the color of blood._

le ciblu
: the blood

Here are some color examples that align with the English language. You can also use other color words, reflecting the way how speakers of different languages typically categorize things.

> **le tsani cu xunre ca le cerni**
> _The sky is red in the morning._

le tsani
: the sky

> **.i le solri cu simlu le ka narju**
> _The sun seems to be orange._

le solri
: the Sun

<pixra url="/assets/pixra/cilre/tsani.webp" caption="tsani .i solri" definition="The sky. The sun."></pixra>

simlu
: $x_1$ looks like $x_2$ (property of $x_1$)

> **.i le pelxu xrula cu se farna le solri**
> _Yellow flowers are oriented towards the Sun._

se farna
: $x_1$ is oriented towards $x_2$

farna
: $x_1$ is the direction of $x_2$

> **.i le pezli be le tricu cu crino**
> _Leaves of trees are green._

pezli
: $x_1$ is a leaf of $x_2$

le tricu
: tree

> **.i mi zvati le korbi be le blanu xamsi**
> _I am at the border of a blue sea._

zvati
: … is present at …

korbi
: $x_1$ is the border of $x_2$

le xamsi
: sea

> **.i mi catlu le prenu noi dasni le zirpu taxfu**
> _I look at a person who wears the violet dress._

dasni
: $x_1$ wears $x_2$ (something)

xunre
: $x_1$ is red

narju
: $x_1$ is orange

pelxu
: $x_1$ is yellow

crino
: $x_1$ is green

blanu
: $x_1$ is blue

zirpu
: $x_1$ is violet

Other useful relations:

> **le gusni be le manku pagbu pu na ku carmi**
> _The light illuminating dark areas was not intense._

<!-- -->

> **le gusni be fi le solri pu carmi**
> _The light from the Sun was intense._

gusni
: $x_1$ is a light illuminating $x_2$ from the light source $x_3$

carmi
: $x_1$ is intense, bright

manku
: $x_1$ is dark

### «**sipna**» — ‘_to sleep_’, «**sanji**» — ‘_to be aware_’

The following examples illustrate some basic aspects of the mind:

> **pu ku mi cikna gi'e ku'i na ganse le nu do klama**
> _I was awake but didn't sense your arrival._

<!-- -->

> **pu ku ca le nu mi sipna kei mi ganse ku'i le nu do klama**
> _While I was asleep I nevertheless sensed you coming._

<!-- -->

<pixra url="/assets/pixra/cilre/le_prenu_cu_senva_tuha_le_nei.webp" caption="mi ca'o sipna gi'e sanji le nu mi sipna" definition="I sleep and I'm aware that I sleep."></pixra>

> **pu ku mi ca'o sipna gi'e sanji le nu mi sipna**
> _I was sleeping and I was aware that I was sleeping._
> _I was having a lucid dream._

<!-- -->

> **mi sanji le nu mi sanji**
> _I am aware that I'm aware._
> _I am self-conscious._

sipna
: $x_1$ sleeps

cikna
: $x_1$ is awake

ganse
: observer $x_1$ senses, notices some stimulus (event) by mrans $x_3$

sanji
: $x_1$ is conscious, aware of $x_2$ (event)

**ganse** doesn't imply any mental processing; it just describes perception, recognition, detection of some stimulus via sensory channels (specified in $x_3$).

On the other hand, **sanji** describes passive sensing, which involves mental processing but not necessarily via sensory inputs at all (some mental relationships are not detected by the senses).

### Emotions: «**cmila**» — ‘_to laugh_’, «**cisma**» — ‘_to smile_’

> **coi**
> **.i ma nuzba**
> **.i do simlu le ka badri**
> _Hi._
> _What are the news?_
> _You seem to be sad._

badri
: $x_1$ is sad about $x_2$

<pixra url="/assets/pixra/cilre/badri.webp" caption="le prenu cu simlu lo ka badri" definition="The person seems to be sad."></pixra>

> **mi steba le nu le bruna be mi co'a speni le ninmu**
> _I am frustrated that my brother gets married the woman._

steba
: $x_1$ feels frustration about $x_2$

> **mi se cfipu**
> **.i xu do na ku gleki le nu le bruna co'a speni**
> _I am confused._
> _You are not happy that the brother gets married?_

se cfipu
: $x_1$ is confused about $x_2$

gleki
: $x_1$ is happy about $x_2$

> **ie**
> **.i le ninmu cu pindi**
> **.i le ninmu na ku ponse le jdini**
> **.i mi na ku kakne le ka ciksi**
> _Yeah._
> _The woman is poor._
> _She doesn't have money._
> _I am not able to explain._

le jdini
: the money

kakne
: $x_1$ is capable of $x_2$ (property of $x_1$)

> **ua**
> **.i la'a do kanpe le nu le ninmu na ku prami le bruna**
> _Ah!_
> _Probably, you expect that the woman doesn't like the brother._

la'a
: interjection: probably, it's likely

kanpe
: $x_1$ expects $x_2$ (some event )

> **mi terpa le nu le ninmu ba tarti lo xlali**
> **.i ku'i le bruna cu cisma ca ro nu ri tavla le ninmu**
> **.i ri ta'e cmila**
> _I am afraid that she will behave bad._
> _But the brother smiles every time he talks to her._
> _And she usually laughs._

terpa
: $x_1$ fears $x_2$

cisma
: $x_1$ smiles

cmila
: $x_1$ laughs

<pixra url="/assets/pixra/cilre/cisma.webp" caption="le prenu cu cisma" definition="The person smiles."></pixra>
<pixra url="/assets/pixra/cilre/cmila.webp" caption="ra cmila" definition="He/she laughs."></pixra>

> **mi kucli le nu le ninmu cu prami le bruna**
> _I wonder whether the girl likes the brother._

kucli
: $x_1$ is curious of $x_2$

> **mi na ku kanpe**
> _I don't expect that._

kanpe
: $x_1$ expects that $x_2$ (event) happens

> **ko surla**
> _Relax!_

surla
: $x_1$ relaxes by doing $x_2$ (property of $x_1$)

cinmo
: $x_1$ feels emotion $x_2$ (property of $x_1$)

nelci
: $x_1$ likes $x_2$

manci
: $x_1$ feels awe or wonder about $x_2$

fengu
: $x_1$ is angry about $x_2$

xajmi
: $x_1$ thinks $x_2$ is funny

se zdile
: $x_1$ is amused by $x_2$

zdile
: $x_1$ is amusing

djica
: $x_1$ desires $x_2$

pacna
: $x_1$ hopes that $x_2$ is true

### Health

> **ca glare**
> _It's hot now._

<!-- -->

> **.i ku'i mi ganse le lenku**
> _But I feel cold._

ku'i
: interjection: but, however

> **xu do bilma**
> _Are you ill?_

<!-- -->

> **bilma**
> _Yes._

<!-- -->

> **xu do bilma fi le vidru**
> **.i .e'u do klama le mikce**
> _Do you have a virus? I suggest you go to a doctor._

le vidru
: the virus

le mikce
: doctor

> **mi bilma le ka cortu le galxe**
> **.i mi sruma le du'u mi bilma fi la .zukam.**
> _My symptoms is that my throat aches._
> _I assume that I have a cold._

cortu
: $x_1$ has pain in organ $x_2$, which is a part of $x_1$\'s body

la .zukam.
: common cold (disease)

> **ko kanro**
> _Get well!_

kanro
: $x_1$ is healthy

> **ki'e**
> _Thanks._

bilma
: $x_1$ is ill or sick with symptoms $x_2$ from disease $x_3$

Note that the second place of **bilma** describes symptoms, such as **le ka cortu le galxe** = _to have pain in the throat_. The third place indicates the name of the disease causing those symptoms. Obviously, you may wish to skip filling these places of **bilma**.

### Human body

> **le nanmu cu se xadni le clani**
> _The man has a long body. The man is tall._

se xadni
: $x_1$ has the body $x_2$

xadni
: $x_1$ is the body of $x_2$

> **mi pu darxi fi le stedu .e le zunle xance**
> **.i ca ti le degji be le xance cu cortu**
> **.i ku'i le pritu xance na ku cortu**
> _I hit something with the head and the left hand. Now the finger of the hand hurts. But the right hand doesn't hurt._

darxi
: $x_1$ hits $x_2$ with $x_3$

Most of words for parts of body have the same place structure as **xadni**:

stedu
: $x_1$ is a head of $x_2$

However, some describe smaller parts:

degji
: $x_1$ is a finger/toe on part $x_2$ (hand, foot)

> **le degji be le xance be le ninmu cu clani**
> _The woman's fingers are long._
> `Digits of hand of the woman are long`

> **mi viska le jamfu .i ku'i mi na ku viska le degji be le jamfu**
> _I can see the feet. But I don't see its toes._

janco
: $x_1$ is a joint attaching limbs $x_2$

ctebi
: $x_1$ is a lip of mouth, orifice $x_2$

cidni
: $x_1$ is a knee or elbow of limb $x_2$

![](/assets/pixra/cilre/xadni1.svg)

![](/assets/pixra/cilre/xadni2.svg)

### Kinship

> **coi do mi se cmene zo .adam.**
> **.i ti du la .alis.**
> **.i ri speni mi**
> _Hello to you. I am called "Adam"._
> _This is Alice._
> _She is my wife._

<!-- -->

> **pluka fa le nu penmi do**
> **.i .e'o do klama le nenri be le dinju**
> _Pleasure to meet you._
> _Please, come into the house._

<!-- -->

> **ki'e**
> _Thanks._

<!-- -->

> **.i .au gau mi do co'a slabu le lanzu be mi**
> **.i le re verba cu panzi mi**
> **.i le tixnu cu se cmene zo .flor.**
> **.i la .karl. cu du le bersa**
> _I'd like you to get to know my family._
> _The two children are my offspring._
> _The daughter is called "Flor"._
> _Karl is the son._

<!-- -->

> **la .karl. cu mutce citno**
> _Karl is very young._

<!-- -->

> **ie**
> _Yeah._

<!-- -->

> **.i ji'a mi se tunba re da noi ca na ku zvati le dinju**
> **.i sa'e mi se tunba le pa bruna .e le pa mensi**
> _Also I have two siblings who are now not in the house._
> _To be precise, I have a brother and a sister._

<!-- -->

> **ue**
> **.i le lanzu be do cu barda**
> _Wow!_
> _Your family is large._

<!-- -->

> **je'u pei**
> _Really?_

je'u
: interjection: truly

The words for names of family members have a similar place structure:

speni
: $x_1$ is a husband/wife of $x_2$

**co'a speni** means _to get married_:

> **mi co'a speni la .suzan.**
> _I married Susan._

lanzu
: $x_1$ is a family including $x_2$

panzi
: $x_1$ is a child of $x_2$

tixnu
: $x_1$ is a daughter of $x_2$

bersa
: $x_1$ is a son of $x_2$

tunba
: $x_1$ is a sibling (brother/sister) of $x_2$

bruna
: $x_1$ is a brother of $x_2$

mensi
: $x_1$ is a sister of $x_2$

Note that **panzi** can be applied to grown-up children:

verba
: $x_1$ is a child, immature person of age $x_2$ (event)

panzi
: $x_1$ is a child, offspring of $x_2$

**verba** doesn't necessarily talk of the child as of a family member:

> **le bersa be le pendo be mi cu verba le nanca be li ci**
> _The son of my friend is a child of three years old._

citno
: $x_1$ is young

laldo
: $x_1$ is old, aged

Pairs of traditional words (for humans only):

le ninmu
: woman / women

le nanmu
: male man / male men

le nixli
: the girls

le nanla
: the boys

le remna
: the humans

Note that **le prenu** means _the people_ or _the persons_. In fairy tales and fantastic stories, not only humans (**lo'e remna**) but also animals or alien beings from other planets can be considered persons.

These words can be used to describe genetically determined sex (both in animals and humans) as opposed to gender:

le fetsi
: the female

le nakni
: male

These word describe parental (not necessarily genetic) relations:

mamta
: $x_1$ is a mother of $x_2$, $x_1$ acts maternally

patfu
: $x_1$ is a father of $x_2$

rirni
: $x_1$ is a parent of $x_2$, $x_1$ raises $x_2$

### In the shop

> **ue**
> **do pu te vecnu le laldo karce**
> _Wow!_
> _You bought an old car._

<!-- -->

> **ie**
> **.i ku'i mi na ku pu pleji le so'i jdini**
> _Yeah._
> _But I didn't pay much money._

<!-- -->

> **ma pu jdima le karce**
> _What was the price of the car?_

<!-- -->

> **mi pu pleji le rupnusudu be li pa ki'o le kagni le karce**
> _I paid a thousand dollars to the company for the car._

<!-- -->

> **mi pu vecnu le laldo karce pe mi le pendo be mi**
> **.i le pendo pu pleji le rupne'uru be li re ki'o mi le karce**
> _I sold an old car of mine to my friend._
> _The friend paid 2 000 euro for the car._

ki'o
: comma between digits so that **pa ki'o** is _1, 000_ (_one thousand_)

vecnu
: $x_1$ sells $x_2$ to $x_3$

te vecnu
: $x_1$ buys $x_2$ from $x_3$

pleji
: $x_1$ pays $x_2$ to $x_3$ for $x_4$

jdima
: $x_1$ is the price of $x_2$

jdini
: $x_1$ is money

rupnusudu
: $x_1$ costs $x_2$ (number) US dollars

rupne'uru
: $x_1$ costs $x_2$ (number) euro

### Shop, buildings

> **ma stuzi le zdani be do**
> _What is the location of your home?_

<!-- -->

> **le korbi be le cmana**
> **.i mi se zdani le nurma**
> **.i le zdani be mi cu barda dinju gi'e se sledi'u ci da .e le vimstu .e le lumstu**
> _The edge of the mountain._
> _I live in the country._
> _My home is a big house and has three rooms plus a toilet plus a bathroom._

<!-- -->

> **je'e**
> **.i ku'i mi pu jbena le tcadu .i je ca ti mi se zdani le jarbu be la .paris.**
> **.i mi xabju ne'a le zarci**
> _I see._
> _But I was born in the city, and now I live in the suburbs of Paris._
> _I live near a shop._

stuzi
: $x_1$ is a place

dinju
: $x_1$ is a building, house

sledi'u
: $x_1$ is a room, a part of a building $x_2$

vimstu
: $x_1$ is a toilet, a place for excreting

lumstu
: $x_1$ is a bathroom, a place for washing something

zdani
: $x_1$ is a home of $x_2$

se zdani
: $x_1$ lives in $x_2$, $x_1$ inhabits $x_2$

tcadu
: $x_1$ is a city or town

jarbu
: $x_1$ is a suburban are of city/town $x_2$

nurma
: $x_1$ is a rural area, $x_1$ is in the country

zarci
: $x_1$ is a shop