## Lesson 3. Quoting. Questions. Interjections

### «**sei**»: comments to the text

The particle **sei** allows inserting a comment about our attitude regarding what is said in a relation:

> **do jinga sei mi gleki**
> _You won! (I'm happy about that!)_

However:

> **do jinga sei la .ian. cu gleki**
> _You won! (And Yan is happy about that!)_

Like with arguments formed using **le**, the relation formed with **sei** must end in a relation construct.

> **la .alis. cu prami sei la .bob. cu gleki la .kevin.**

Let's add brackets to make it more easily readable.

> **la .alis. cu prami (sei la .bob. cu gleki) la .kevin.**
> _Alice loves (Bob is happy) Kevin._
> _Alice loves Kevin (Bob is happy)._

We can of course add more arguments to the relation with **be** and **bei** as we do inside argument terms:

> **do jinga sei mi zausku be fo la fircku**
> _You won! (I'll post congrats on Facebook)_

la fircku
: Facebook

zausku
: $x_1$ praises $x_2$ for audience $x_3$ via means $x_4$

### Quotation marks

For quoting text, we place the quotation particle **lu** before the quote and place **li'u** after it. The result is an argument representing the quoted text:

> **mi cusku lu mi prami do li'u**
> _I say "I love you."_

cusku
: $x_1$ expresses/says $x_2$ (quote) to audience $x_3$

A nice feature of Lojban is that **lu** — «quote» and **li'u** — «unquote» marks are pronounceable. It is quite handy since, in spoken Lojban, you don't have to change intonation to show where a quoted text starts and ends.

However, in written text that quotes a conversation, the author often draws the reader's attention to the content of quotations. In such cases, **sei** is preferred.

We can also nest quotations, for example:

> **la .ian. pu cusku lu la .djein. pu cusku lu coi li'u mi li'u**
> _Yan said, "Jane said, ‘Hello’ to me."_

which is similar to

> **la .ian. pu cusku lu la .djein. pu rinsa mi li'u**
> _Yan said, "Jane greeted me."_

rinsa
: $x_1$ greets someone $x_2$

<pixra url="/assets/pixra/cilre/rinsa2.webp" caption="le prenu cu rinsa mi" definition="The person greets me."></pixra>

Note that in Lojban, we distinguish things and their names:

> **lu le munje li'u cu cmalu**
> _"The universe" is small._

<!-- -->

> **le munje na ku cmalu**
> _The universe is not small._

le munje
: the universe, world

Here, the text _"the universe"_ is small, whereas the universe is not.

---

Interjections and vocatives work like **sei** constructs:

> **je'u mi jinga sei ra cusku**
> _Truly, "I won", he said._

je'u
: interjection: truly

As you can see, **je'u** is not part of his words. It represents your attitude toward the relation. If you want to quote "**je'u mi jinga**", use quotation marks like this:

> **lu je'u mi jinga li'u se cusku ra**
> _"Truly, I won", he said._

Notice the difference between the two examples?

Here are several common relation words related to talking:

> **ra pu retsku lu do klama ma li'u**
> _She asked, "Where do you go?"_

<!-- -->

> **mi pu spusku lu mi klama le zdani li'u**
> _I replied, "I am going home."_

<!-- -->

> **mi pu spuda le se retsku be ra le ka spusku lu mi klama le zdani li'u**
> _I replied to her question by saying, "I am going home."_

spuda
: $x_1$ replies to $x_2$ by doing $x_3$ (property of $x_1$)

The remaining three relation words have identical place structure:

cusku
: $x_1$ expresses/says $x_2$ (quote) to audience $x_3$

retsku
: $x_1$ asks $x_2$ (quote) to audience $x_3$

spusku
: $x_1$ replies/says answer $x_2$ (quote) to audience $x_3$

### «**zo**» — quoting one word

**zo** is a quotation marker, similar to **lu**. However, **zo** quotes only one word immediately following it. This means it does not require an unquote word like **li'u**; we already know where the quotation ends. By doing this, we save two syllables and make our speech more concise.

> **zo .robin. cmene mi**
> _"Robin" is my name._
> _My name is Robin._

cmene
: $x_1$ (quote) is a name of $x_2$ …

To present yourself in Lojban using your Lojbanized name, follow the example above. If your name consists of more than one word, use **lu … li'u**:

> **lu .robin.djonsyn. li'u cmene mi**
> _Robin Johnson is my name._

Another approach is to use **me**:

> **mi me la .robin.djonsyn.**
> _I'm Robin Johnson._

Notice the difference: _"Robin"_ with quotation marks is a quoted name, whereas Robin is a person.

To show this better, here is a silly variation:
> **zo .robin. cmene la .robin.**
> _"Robin" is Robin's name._
> _"Robin" is a name of Robin._

The first place of **cmene** is a quote, a text. Therefore, we use **lu … li'u** or **zo** to create a quote and fill the first place of **cmene** with it, instead of **la** (prefix for names).

### Verbs of speech

Here are some relations describing speech:

> **mi pu skicu le purdi le pendo be mi lo ka bredi**
> _I told my friend about my garden being ready._

skicu
: $x_1$ tells about $x_1$ (object/event/state) to $x_3$ with description $x_4$ (property)

bredi
: … is ready to …

> **mi pu cusku lu le purdi cu bredi li'u le pendo be mi lo ka cladu bacru**
> _I said to my friend, "The garden is ready," by uttering it loudly._

cusku
: $x_1$ says $x_2$ (text) for audience $x_3$ via medium $x_4$

cladu
: … is loud

> **mi pu tavla le pendo be mi le nu le purdi cu bredi kei le lojbo**
> _I talked to my friend in Lojban about the garden being ready._

tavla
: $x_1$ talks to $x_2$ about subject $x_3$ in language $x_4$

In short:

* **skicu** means _to tell_, _to describe with some description_,
* **cusku** means _to say some text_,
* **tavla** means _to talk in a language_.

### Content questions

English has several _wh-_ question words — _who_, _what_ etc. In Lojban, for both of them we use one word: **ma**. This word is an argument (like **mi**, **le prenu** etc.) and it'ss like a suggestion to to fill in the missing place. For example:

> **— do klama ma**
> **— la .london.**
> _— Where are you going?_
> _— London._

<!-- -->

> **— ma klama la .london.**
> **— la .kevin.**
> _— Who's going to London?_
> _— Kevin._

<!-- -->

> **— mi plicru do ma**
> **— le plise**
> <span>_— I give you what?_ (probably meaning _What was it I was supposed to be giving you?_)</span>
> _— The apple._

To translate _which/what_, we also use **ma**:

> **— ma gugde gi'e se xabju do**
> **— le gugde'usu**
> _— In what country do you live?_
> _— USA_
> `— What is a country and is inhabited by you`
> `— USA`

xabju
: … (someone) inhabits … (some place)

se xabju
: … (some place) is inhabited by … (someone)

**mo** is similar to **ma**, but it is a relation word.

**mo** suggests to fill in a relation instead of an argument. It's like asking _What does X do?_ or _What is X?_ in English (Lojban doesn't force you to distinguish between being and doing).

We can see **mo** as asking someone to describe the relationship between the arguments in the question.

> **— do mo**
> _— How do you do? What's up?_
> `— You are what, you do what?`

This is the most common way of asking _How do you do?_ or _Howdy?_ in Lojban. Some possible answers:

> **— mi gleki**
> _— I'm happy._

gleki
: $x_1$ is happy

> **— mi kanro**
> _— I'm healthy._

<!-- -->

> **mi tatpi**
> _I'm tired._

<!-- -->

> **mi gunka**
> _I'm working._

Another way of asking _How do you do?_:

> **— do cinmo le ka mo**
> _— How do you feel (emotionally)?_

cinmo
: $x_1$ feels $x_2$ (property of $x_1$)

Other examples:

> **ti mo**
> _What is this?_

<!-- -->

> **la .meilis. cu mo**
> _Who is Mei Li? / What is Mei Li? / What is Mei Li doing?_

Possible answers depending on context:

- **ninmu**: _She's a woman._
- **jungo**: _She's Chinese._
- **pulji**: _She's a police officer._
- **sanga**: _She's a singer_ or _She's singing._

> **do mo la .kevin.**
> _What are you to Kevin?_
> `You are what (you do what) to Kevin.`

The answer depends on the context. Possible answers to this question are:

- **nelci**: _I like him._
- **pendo**: _I am his friend_
- **prami**: _I adore/am in love with him._
- **xebni**: _I hate him._
- **fengu**: _I'm angry with him._
- **cinba**: _I kissed him._

Note once again that the time is not important here: just as **cinba** can mean _kiss_, _kissed_, _will kiss_ and so on, **mo** does not ask a question about any particular time.

If we do want to differentiate between _to do_ and _to be someone or something_ we use additional relations:

> **la meilis cu zukte ma**
> `Mei Li does what?`
> _What does Mei Li do?_

> **le ka lumci**
> _cleaning._

<!-- -->

> **la meilis cu zukte le ka lumci**
> _Mei Li is does cleaning._

zukte
: $x_1$ does $x_2$ (property of $x_1$)

lumci
: ... cleans up or washes ... (something)

<pixra url="/assets/pixra/cilre/lumci.webp" caption="ra lumci le zdani" definition="She cleans up the home."></pixra>

> **do du ma**
> `You are who?`

> **mi du le ctuca**
> _I am the teacher._

Using modal terms with **ma** can give us other useful questions:

<table>
<tbody><tr>
<th>word
</th>
<th>meaning
</th>
<th><code>[literally]</code>
</th></tr>
<tr>
<td><b>ca ma</b>
</td>
<td>When?
</td>
<td>during what
</td></tr>
<tr>
<td><b>bu'u ma</b>
</td>
<td>Where?
</td>
<td>at what
</td></tr>
<tr>
<td><b>ma prenu gi'e …</b>
</td>
<td>Who?
</td>
<td>who is a person and …
</td></tr>
<tr>
<td><b>ma dacti gi'e</b>
</td>
<td>What? (about objects)
</td>
<td>what is an object and …
</td></tr>
<tr>
<td><b>ri'a ma</b>
</td>
<td>Why?
</td>
<td>because of what
</td></tr>
<tr>
<td><b>pe ma</b>
</td>
<td>Whose? Which? About what?
</td>
<td>pertaining to what or whom
</td></tr>
<tr>
<td><b>le mlatu poi mo</b>
</td>
<td>Which cat? Which kind of cat?
</td>
<td>
</td></tr></tbody></table>

**pe ma** is attached only to arguments:

> **le penbi pe ma cu zvati le jubme**
> _Whose pen is on the table?_

### Number questions

> **le xo prenu cu klama ti**
> _How many people are coming here?_

<!-- -->

> **mu**
> _Five._

The word **xo** means _How many?_ and thus asks for a number. The full answer will be:

> **le mu prenu cu klama ti**
> _The 5 people are coming to this place._

The person being asked is supposed to put an appropriate value in place of **xo**.

Here are a few more examples:

> **le xo botpi cu kunti**
> _How many bottles are empty?_

<!-- -->

> **do ralte le xo gerku**
> _How many dogs do you keep?_

### Verbs of facts

Consider the example:

> **mi djuno le du'u do stati**
> _I know that you are smart._

djuno
: $x_1$ knows $x_2$ (proposition) about $x_3$

> **mi jimpe le du'u do pu citka**
> _I understand that you were eating._

jimpe
: $x_1$ understands $x_2$ (proposition) about $x_3$

<pixra url="/assets/pixra/cilre/na_jimpe.webp" caption="mi na jimpe" definition="I don't understand."></pixra>

In places that describe facts, the particle **du'u** is used (instead of **nu**).

**djuno** (_to know_) and **jimpe** (_to understand_) describe facts. It would be illogical to say, _I understand that you were eating, but in fact, you weren't._

Note that the relation started with **du'u** doesn't have to be true:

> **le du'u do mlatu cu jitfa**
> _That you are a cat is false._

jitfa
: $x_1$ (proposition) is false

When should you use **du'u** and when should you use **nu**? You may consult the dictionary:

- The label _(du'u)_ or _(proposition)_ marks places where **du'u** is recommended.
- The label _(nu)_ or _(event)_ marks places where **nu** is recommended.

If you mistakenly use **nu** instead of **du'u**, you will still be understood. However, fluent Lojban speakers typically distinguish between these particles.

### Indirect questions

> **mi djuno le du'u ma kau tadni la .lojban.**
> _I know who is studying Lojban._

This is called an indirect question. The word _who_ here is not a request for information, and there is no question mark. The answer is presumed, and in fact, you yourself know the answer to the question _Who is learning Lojban?_

**kau** is an interjection that we put after a question word to indicate it's an indirect question.

If I ask you the question **ma tadni la .lojban.**, you know what value to fill in the **ma** slot with: **la .kevin.** So you could just say

> **ma tadni la .lojban.**
> _Who is studying Lojban?_

<!-- -->

> **mi djuno le du'u ma kau tadni la .lojban.**
> _I know who is studying Lojban. I know the identity of the person studying Lojban._

<!-- -->

> **mi djica le nu ma tadni la .lojban.**
> _Who do I want to study Lojban?_
> `I want who to study Lojban?`

This can never be an indirect question: it is asking for an answer (even if you're doing it rhetorically).

You can put it after other question words:

> **mi djuno le du'u le xo kau prenu cu tadni la .lojban.**
> _I know how many people study Lojban._

### Indirect quotations (reported speech): ‘_I said that I would come._’

A relation like _Alice said, "Michelle said, 'Hello' to me"_ can also be expressed in a subtler way:

> **la .alis. pu cusku zo'e pe le nu la .micel. pu rinsa la .alis.**
> _Alice said something about Michelle greeting her before._
> `Alice said something about the event of Michelle greeting her.`

Alternatively, you can make it shorter:

> **la .alis. pu cusku le se du'u la .micel. pu rinsa la .alis.**
> _Alice said that Michelle had greeted her._

The combination **se du'u** allows the expression of indirect speech.

Here are some examples of relations useful for reported speech:

> **le ninmu pu retsku le se du'u mi klama ma kau**
> _She asked where I was going._

<!-- -->

> **mi pu spusku le se du'u mi klama le zdani**
> _I replied that I was going home._

<!-- -->

> **mi pu spuda le se retsku be le ninmu le ka spusku le se du'u mi klama le zdani**
> _I replied to her question by saying in reply that I was going home._

Questions in reported speech:

> **mi pu cusku le se du'u ma tadni la .lojban.**
> _Who did I say is studying Lojban?_
> `I said who is studying Lojban?`

Thus, Lojban has several words for _that …_, depending on what sort of thing is meant.

- If _that_ describes what can be seen, heard, or what happens, use **nu**.
- If _that_ describes what you think, some fact, or information, use **du'u**.
- If _that_ describes what you say, use **se du'u**.
  - But if you need a literal quote, use **lu … li'u**.

### Emotional interjections: ‘_Yay!_’ = «**ui**», ‘_Aye!_’ = «**ie**», ‘_Phew!_’ = «**.o'u**»

We know such interjections as **ui** (_Yay!_), **.a'o** (_I hope_).

> **do jinga ui**
> _You won! (I'm happy about that!)_

ui
: interjection: _Yay!_, interjection of happiness

<pixra url="/assets/pixra/cilre/ui_jinga.webp" caption="ui mi jinga" definition="Yay! I won!"></pixra>

Interjections work like **sei** with their relations. **ui** means the same as **sei mi gleki** so we could as well say **do jinga sei mi gleki** meaning the same (although it's a bit more lengthy).

There are interjections expressing other emotional states. They are similar to smileys like ;-) or :-( but in Lojban, we can be more specific about our emotions while still remaining concise in our speech.

> **ie tu mlatu**
> _Agreed, that is a cat._

<!-- -->

> **ie nai .i tu na ku mlatu**
> _No, I don't agree. That is not a cat._

ie
: interjection: _Yeah! Aye!_ (agreement)

ie nai
: interjection: disagreement

> **.ai mi vitke do**
> _I'm going to visit you._

.ai
: interjection: _I'm going to …_ (intent)

> **.au do kanro**
> _I wish you were healthy._

.au
: interjection of desire

<pixra url="/assets/pixra/cilre/clira.webp" caption="mi clira klama" definition="I came early."></pixra>

> **.a'o do clira klama**
> _I hope you come early._

.a'o
: interjection: I hope

clira
: $x_1$ happens early

<pixra url="/assets/pixra/cilre/ciska.webp" caption=".ei mi ciska le xatra ti voi pelji ku'o le penbi" definition="I should write the letter on this paper using the pen."></pixra>

> **.ei mi ciska le xatra le pelji le penbi**
> _I should write the letter on the paper using the pen._

.ei
: I should … (obligation)

ciska
: $x_1$ writes $x_2$ on medium $x_4$

> **.i'e do pu gunka le vajni**
> _Very good! You did important work._

.i'e
: interjection: _Fine!_ (approval)

> **.o'u tu mlatu**
> _Oh, that's only a cat._

.o'u
: interjection: _Phew!_ (relaxation)

In this case, you probably thought that was something dangerous, but it's only a cat, so you are saying **.o'u**.

> **.u'i ti zmitci**
> _Ha-ha, this is a robot._

.u'i
: interjection: _Ha-ha!_ (amusement)

zmitci
: … is an automatic tool

You can add or remove interjections to or from a sentence without the risk of breaking it.

Any word that starts with a pure vowel (excluding **u** and **i** before vowels) is prefixed with a dot in Lojban in writing and with a pause in speech. So, the correct spelling is **.a'o** and so on. It's common to omit dots in writing. However, while speaking, you should always show this dot by making a short pause before saying such a word to prevent merging two neighboring words together into one.

Like with **xu** or **sei**-relations, we can add interjections after any argument or relation construct, thus expressing our attitude towards that part of the sentence.

### Urging interjections

A special group of "imperative/hortative" interjections are used for instigations, commands, and requests. We have already encountered **.e'o**:

> **.e'o mi ciksi da poi mi cusku djica**
> _Please, let me explain what I want to say._

.e'o
: interjection: _Please …_ (request)

> **— au mi klama le nenri**
> **— .e'a**
> _— I'd like to enter._
> _— Please do._

.e'a
: interjection: _I allow, you may …_ (permission)

le nenri
: the interior, what is inside

> **.e'ei do zukte**
> _C'mon, do it!_

.e'ei
: interjection: _Come on!_ (encouragement, instigation, provocation). Unofficial word

> **.e'i do zutse doi le verba**
> _Sit down, child!_

.e'i
: interjection: _Do that!_ (command)

> **.e'u do pinxe le jisra**
> _I suggest that you drink the juice. You'd better drink the juice._

.e'u
: interjection: _Let's …_ (suggestion)

### «**ko**» for quicker urges

> **do bajra**
> _You run._

<!-- -->

> **bajra**
> _Someone runs._

In English, the verb itself is a command:

> _Run!_

In Lojban, **bajra** as a sentence means _Someone runs_ (or _is running_ / _was running_, depending on context). **bajra** can also mean a command, _Do run!_, but sometimes context isn't enough to determine if it's an urge to run or simply a statement that someone runs or is running.

The pronoun **ko** is used instead of **do** to make requests, suggestions, or commands:

> **ko bajra**
> _Run! Do run! Do it so that you run!_

**ko** is a more vague alternative to **do .e'o**, **do .e'u**, **do .e'i**.

It's perfectly fine to say something more precise, like:

> **do .e'o bajra**
> _You, please run!_

putting the emphasis in our politeness onto **do** (_you_).

By moving **ko** in a relation, the command/request is moved to that part. For example:

> **nelci ko**
> _Make it so you are liked by someone!_

nelci
: … likes … (something or someone)

As you can see, we have to restructure this relation in English, which still sounds strange. However, you could use it in Lojban in the sense of _Try to make a good impression._

Note that **prami** corresponds to English _to love_, while **nelci** corresponds to English _to like_.

We can even have several **ko** in one sentence:

> **ko kurji ko**
> _Take care of yourself._

kurji
: … takes care of … (someone or something)

### Discursive interjections

> **au mi citka le salta .e ji'a le grute**
> _I'd like to eat the salad and the fruits too._

ji'a
: _additionally, also_, means that there exist others who also are the same (_you_ in this case) or who do the same

salta
: … is some salad

grute
: … is a fruit

> **mi si'a nelci do**
> `I too like you`

<!-- -->
> **— mi nelci le'e mlatu**
> **— mi si'a nelci le'e mlatu**
> _— I like cats._
> _— I like cats too (Me too)._

si'a
: _similarly, too_, denotes that something is similar while being different in other unmentioned aspects

### Structure of interjections: «**nai**», «**sai**», «**pei**», «**dai**»

Interjections can consist of

1. the root, like **ui** (_Yay!_)
2. after it suffixes like **pei**, **dai**, **zo'o**:

    > **ui zo'o**
    > _Yay! (kidding, I'm not actually happy)_

3. both the root and each of the suffixes can be modified with scalar particles like **nai**:

    > **ui nai**
    > _Alas!_

    <!-- -->
    > **ui nai zo'o**
    > _Alas! (kidding, I'm not serious in this feeling)_

    <!-- -->
    > **ui nai zo'o nai**
    > _Alas, I'm not kidding, I feel unhappy_

Some examples of how scalar particles work.

- **ju'o** = _interjection: I'm sure (certaintty)_
- **ju'o cu'i** = _interjection: maybe, perhaps (uncertainty)_
- **ju'o nai** = _interjection: I have no idea!_

Common examples of interjections:

- an interjection made of a bare root:

 > **ju'o le bruna co'i klama**
 > _I'm sure, the brother has come._

- the scalar particle **cu'i** turns a bare root interjection into its middle attitude:

 > **ju'o cu'i le bruna co'i klama**
 > _Maybe the brother has come, I'm not sure._

- the scalar particle **nai** turns inttheyerjection into the opposite attitude:

 > **ju'o nai le bruna co'i klama**
 > _Maybe the brother has come, maybe not, I have no idea_

 Similarly, **ui** is _Whee! Yay!_, while **ui nai** means _Alas!_

 Precise meanings of interjections that are meaningful with their scalar particles **cu'i** and **nai** are given in the dictionary.

- the scalar particle **sai** denotes strong intensity of interjection:

 > **.u'i sai**
 > _Ha-ha-ha!_

Vocatives can also be modified with scalar particles:

> **ki'e sai do**
> _Thank you a lot!_

Suffixes are added after the root of the interjection (together with its scalar particles if we used them):

- the interjection suffix **pei** turns interjection into a question.

 > **— .au pei do .e mi klama le zarci**
 > **— .au cu'i**
 > _— Do you want that you and I go to the store?_
 > _— Meh, I don't have any preferences._

 <!-- -->

 > **— ie pei tu melbi**
 > **— ie**
 > _— That one is pretty, isn't it?_
 > _— Yeah._

- the interjection suffix **dai** shows feelings of others, not feelings of the speaker:

 > **ui nai dai do na ku co'i jinga**
 > _You must be sad, you haven't won._

 <!-- -->

 > **.a'u**
 > _That's interesting!_

 <!-- -->

 > **.a'u dai**
 > _That must have been interesting for you!_

- Bare interjections express the speaker's attitude. **ei do cliva** means not _You ought to leave_, but _I feel the obligation for you to leave_. **dai** shows that the speaker is empathizing someone else's feelings.

 > **.ei dai do cliva**
 > _You feel the obligation for yourself to leave._

Note that interjections don't necessarily show attitude towards the speakers themselves. Instead, they express the speakers' attitude towards other things.

- the interjection suffix **zo'o** marks the attitude as expressed not seriously:

 > **.e'u zo'o do pinxe ti**
 > _I suggest that you drink it (kidding)._

- Suffixes can also be modified with scalar particles:

 > **ie zo'o nai**
 > _I agree (not kidding)._

- **zo'o nai** is used to show that the information is not a joke:

 >**zo'o nai ra pu klama la .paris.**
 >_— I'm serious, he went to Paris._

- Suffixes can be used on its own:

  - **pei** when used alone asks for any interjection that the listener would feel appropriate:

 >**— pei le lunra cu crino**
 >**— .ie nai**
 >_— The moon is green (what is your feeling about it?)_
 >_— I disagree._

- For other suffixes, it means that the root interjection **ju'a** (_I state_) was omitted:

 > **zo'o do kusru**
 > **ju'a zo'o do kusru**
 > _You are cruel (kidding)._

 ju'a
 : interjection: I state (don't confuse it with **ju'o** (I'm sure))

### Just for reference: interjections in tables

Here is a more comprehensive view: emotional, urging, and various other interjections by series.

<table>
<tbody><tr>
<td><b>.au</b><br/><i>Wish …</i>
</td>
<td><b>.ai</b><br/><i>I'm gonna…</i>
</td>
<td><b>.ei</b><br/><i>It should be…</i>
</td>
<td><b>.oi</b><br/><i>Ouch!</i>
</td></tr>
<tr>
<td><b>.au cu'i</b><br/><i>meh</i><br/>indifference
</td>
<td><b>.ai cu'i</b><br/>indecision
</td>
<td><b>.ei cu'i</b>
</td>
<td><b>.oi cu'i</b>
</td></tr>
<tr>
<td><b>.au nai</b><br/><i>Nuh-uh!</i><br/>disinclination, reluctance
</td>
<td><b>.ai nai</b><br/>unintentionally, accidentally
</td>
<td><b>.ei nai</b><br/>freedom, how things might need not be
</td>
<td><b>.oi nai</b><br/>pleasure
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
<td><b>ua</b><br/><small>"wah" as in "<u>wo</u>n", "<u>o</u>nce"</small><br/><i>Aha! Eureka!</i>
</td>
<td><b>ue</b><br/><small>"weh" as in "<u>we</u>t"</small><br/><i>What a surprise!</i>
</td>
<td><b>ui</b><br/><small>"weeh" as "we"</small><br/><i>hooray!</i>
</td>
<td><b>uo</b><br/><small>"woh" as in "<u>wo</u>mbat", "<u>wha</u>t"</small><br/><i>voila!</i>
</td>
<td><b>uu</b><br/><small>"wooh" as "woo"</small><br/><i>oh poor thing</i>
</td></tr>
<tr>
<td><b>ua cu'i</b><br/>&nbsp;
</td>
<td><b>ue cu'i</b><br/><i>I'm not really surprised</i>
</td>
<td><b>ui cu'i</b><br/>&nbsp;
</td>
<td><b>uo cu'i</b><br/>&nbsp;
</td>
<td><b>uu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ua nai</b><br/><i>Duh! I don't get it!</i><br/>confusion
</td>
<td><b>ue nai</b><br/>expectation, lack of surprise
</td>
<td><b>ui nai</b><br/><i>Alas!</i><br/>feeling unhappy
</td>
<td><b>uo nai</b><br/>feeling incomplete
</td>
<td><b>uu nai</b><br/><i>Mwa ha ha!</i><br/>cruelty
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
<td><b>ia</b><br/><small>"yah" as in "<u>ya</u>rd"</small><br/><i>I believe</i>
</td>
<td><b>ie</b><br/><small>"yeh" as in "<u>ye</u>s"</small><br/><i>aye! agreed!</i>
</td>
<td><b>ii</b><br/><small>"yeeh" as in "hear <u>ye</u>"</small><br/><i>yikes!</i>
</td>
<td><b>io</b><br/><small>"yoh" as in "<u>yo</u>gurt"</small><br/><i>respect</i>
</td>
<td><b>iu</b><br/><small>"yooh" as in "c<u>u</u>te, d<u>ew</u>"</small><br/><i>I love it</i>
</td></tr>
<tr>
<td><b>ia cu'i</b><br/>&nbsp;
</td>
<td><b>ie cu'i</b><br/>&nbsp;
</td>
<td><b>ii cu'i</b><br/>&nbsp;
</td>
<td><b>io cu'i</b><br/>&nbsp;
</td>
<td><b>iu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ia nai</b><br/><i>Pshaw!</i><br/>disbelief
</td>
<td><b>ie nai</b><br/>disagreement
</td>
<td><b>ii nai</b><br/><i>I feel safe</i>
</td>
<td><b>io nai</b><br/>disrespect
</td>
<td><b>iu nai</b><br/>hatred
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
<td><b>.u'a</b><br/><small>"oohah" as in "t<u>wo ha</u>lves"</small><br/><i>gain</i>
</td>
<td><b>.u'e</b><br/><small>"ooheh" as in "t<u>wo hea</u>ds"</small><br/><i>what a wonder!</i>
</td>
<td><b>.u'i</b><br/><small>"ooheeh" as in "t<u>wo hee</u>ls"</small><br/><i>hahaha!</i>
</td>
<td><b>.u'o</b><br/><small>"oohoh" as in "t<u>wo haw</u>ks"</small><br/><i>courage</i>
</td>
<td><b>.u'u</b><br/><small>"oohooh" as in "t<u>wo hoo</u>ds"</small><br/><i>sorry!</i>
</td></tr>
<tr>
<td><b>.u'a cu'i</b><br/>&nbsp;
</td>
<td><b>.u'e cu'i</b><br/>&nbsp;
</td>
<td><b>.u'i cu'i</b><br/>&nbsp;
</td>
<td><b>.u'o cu'i</b><br/>shyness
</td>
<td><b>.u'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.u'a nai</b><br/>loss
</td>
<td><b>.u'e nai</b><br/><i>Pff!</i><br/>commonplace
</td>
<td><b>.u'i nai</b><br/><i>Blah</i><br/>weariness
</td>
<td><b>.u'o nai</b><br/>cowardice
</td>
<td><b>.u'u nai</b><br/>&nbsp;
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Attitude</th></tr></thead>
<tbody>
<tr>
<td><b>.i'a</b><br/><small>"eehah" as in "t<u>eaho</u>use"</small><br/><i>ok, I accept it</i>
</td>
<td><b>.i'e</b><br/><small>"eeheh" as in "t<u>eahea</u>d"</small><br/><i>I approve!</i>
</small></td>
<td><b>.i'i</b><br/><small>"eeheeh" as in "w<u>e hea</u>t"</small><br/><i>I'm with you in that</i>
</td>
<td><b>.i'o</b><br/><small>"eehoh" as in "w<u>e haw</u>"</small><br/><i>thanks to it</i>
</td>
<td><b>.i'u</b><br/><small>"eehooh" as in "w<u>e hoo</u>k"</small><br/><i>familiarity</i>
</td></tr>
<tr>
<td><b>.i'a cu'i</b><br/>&nbsp;
</td>
<td><b>.i'e cu'i</b><br/>non-approval
</td>
<td><b>.i'i cu'i</b><br/>&nbsp;
</td>
<td><b>.i'o cu'i</b><br/>&nbsp;
</td>
<td><b>.i'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.i'a nai</b><br/>resistance
</td>
<td><b>.i'e nai</b><br/><i>Boo!</i><br/>disapproval
</td>
<td><b>.i'i nai</b><br/>feeling antagonism
</td>
<td><b>.i'o nai</b><br/>envy
</td>
<td><b>.i'u nai</b><br/>unfamiliarity
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Attachment to situation</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.a'a</b><br/><small>"ahah" as "aha"</small><br/><i>I'm listening</i>
</td>
<td><b>.a'e</b><br/><small>"aheh"</small><br/><i>alertness</i>
</td>
<td><b>.a'i</b><br/><small>"aheeh" as in "Sw<u>ahi</u>li"</small><br/><i>oomph!</i><br/>effort
</td>
<td><b>.a'o</b><br/><small></small><br/><i>I hope</i>
</td>
<td><b>.a'u</b><br/><small></small><br/><i>hm, I wonder…</i>
</td></tr>
<tr>
<td><b>.a'a cu'i</b><br/>inattentively
</td>
<td><b>.a'e cu'i</b><br/>&nbsp;
</td>
<td><b>.a'i cu'i</b><br/>no special effort
</td>
<td><b>.a'o cu'i</b><br/>&nbsp;
</td>
<td><b>.a'u cu'i</b><br/><i>Ho-hum</i><br/>disinterest
</td></tr>
<tr>
<td><b>.a'a nai</b><br/>avoiding
</td>
<td><b>.a'e nai</b><br/><i>I'm tired</i>
</td>
<td><b>.a'i nai</b><br/>repose
</td>
<td><b>.a'o nai</b><br/><i>Gah!</i><br/>despair
</td>
<td><b>.a'u nai</b><br/><i>Eww! Yuck!</i><br/>repulsion
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Urging</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.e'a</b><br/><small>"ehah"</small><br/><i>you may</i>
</td>
<td><b>.e'ei</b><br/><small>"ehey"</small><br/><i>come on, do it!</i>
</td>
<td><b>.e'i</b><br/><small>"eheeh"</small><br/><i>do it!</i>
</td>
<td><b>.e'o</b><br/><small>"ehoh"</small><br/><i>please, do it</i>
</td>
<td><b>.e'u</b><br/><small>"ehooh"</small><br/><i>I suggest</i>
</td></tr>
<tr>
<td><b>.e'a cu'i</b><br/>&nbsp;
</td>
<td><b>.e'ei cu'i</b><br/>&nbsp;
</td>
<td><b>.e'i cu'i</b><br/>&nbsp;
</td>
<td><b>.e'o cu'i</b><br/>&nbsp;
</td>
<td><b>.e'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.e'a nai</b><br/>prohibiting
</td>
<td><b>.e'ei nai</b><br/>expressing discouragement, demoralization
</td>
<td><b>.e'i nai</b><br/>&nbsp;
</td>
<td><b>.e'o nai</b><br/>offering, granting
</td>
<td><b>.e'u nai</b><br/>warning, disadvise
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.o'a</b><br/><small>"ohah"</small><br/><i>pride</i>
</td>
<td><b>.o'e</b><br/><small>"oheh"</small><br/><i>I feel it at hand</i>
</td>
<td><b>.o'i</b><br/><small>"oheeh"</small><br/><i>danger!</i>
</td>
<td><b>.o'o</b><br/><small>"ohoh" as in "s<u>awho</u>rse"</small><br/><i>patience</i>
</td>
<td><b>.o'u</b><br/><small>"ohooh"</small><br/><i>relaxation</i>
</td></tr>
<tr>
<td><b>.o'a cu'i</b><br/>modesty, humility
</td>
<td><b>.o'e cu'i</b><br/>&nbsp;
</td>
<td><b>.o'i cu'i</b><br/>&nbsp;
</td>
<td><b>.o'o cu'i</b><br/>mere tolerance
</td>
<td><b>.o'u cu'i</b><br/>composure, balance
</td></tr>
<tr>
<td><b>.o'a nai</b><br/><i>How embarrassing.<br/>It makes me ashamed.</i>
</td>
<td><b>.o'e nai</b><br/>distance
</td>
<td><b>.o'i nai</b><br/>rashness, recklessness
</td>
<td><b>.o'o nai</b><br/>impatience, intolerance
</td>
<td><b>.o'u nai</b><br/>stress, anxiety
</td></tr></tbody></table>

Notice how an emotion changes to its opposite when using **nai**, and to the middle emotion when using **cu'i**.

Why are some cells of interjections with **cu'i** and **nai** empty? Because English lacks concise ways of expressing such emotions.

Moreover, many of these interjections are rarely used.

### Combining interjections

> **iu ui nai**
> _Unhappily in love._

<!-- -->

> **ue ui do jinga**
> _Oh, you won! I'm so happy!_

jinga
: … wins

In this case, the victory was improbable, so I'm surprised and happy at the same time.

Interjections (unlike scalar particles and interjection suffixes) don't modify each other:

> **ue ui do jinga**
> **ui ue do jinga**
> _Oh, you won! I'm so happy!_

Here, two interjections modify the same construct (the whole sentence) but they don't modify each other so their order is not important.

> **pei .u'i le gerku cu sutra plipe**
> _(What do you feel?) Heh, the dog is quickly jumping._

Here, **pei** is used alone and doesn't modify **.u'i**, which is put after it.

### Forgot to put an interjection at the beginning?

> **do pu sidju mi ui**
> _You help me (yay!)_

**ui** modifies only the pronoun **mi** putting the attitude only to _me_.

> **ui do pu sidju mi**
> _Yay, you helped me._

What if we forgot to add **ui** at the beginning of this sentence?

We can explicitly label the relation as complete with **vau** and then put the interjection:

> **do pu sidju mi vau ui**
> _You helped me, yay!_