## Lesson 11. Trickier topics

### Know your first language too

When trying to express yourself in Lojban, it's important not to make it merely a copy of English.

Consider the phrase:

> _Terry, the tiger, visits the big city._

It might be tempting to use the relation

vitke
: $x_1$ (guest) visits $x_2$ (someone) at $x_3$

However, the phrase _visits the big city_ implies visiting a place, not someone at that place, which highlights the fact that the English verb _to visit_ might have several meanings.

Indeed, for instance, if we consider French, we see separate solutions:

> I would like to visit my friends.<br/>
> J'aimerais rendre visite à mes amis.

<!-- -->

> I would like to visit this city.<br/>
> J'aimerais visiter cette ville.

French uses _rendre visite_ when visiting someone and _visiter_ when visiting a place.

In Lojban, we translate the meaning, not just words.

Understanding the peculiarities of your own language is also important when trying to express something in Lojban.

The solutions to the example above might be:

> **la .teris. poi tirxu cu klama le barda tcadu**
> _Terry, the tiger, comes to the big city._

tirxu
: $x_1$ is a tiger

> **la .teris. poi tirxu cu pa roi klama le barda tcadu**
> _Terry, the tiger, once comes to the big city._

<!-- -->

> **la .teris. poi tirxu cu pa re'u mo'u klama le barda tcadu**
> _Terry, the tiger, for the first time arrives at the big city._

<!-- -->

> **la .teris. poi tirxu cu co'a klama le barda tcadu**
> _Terry, the tiger, departs to the big city._

### Four meanings of ‘_you_’ in English

We've already seen two personal pronouns, **mi** (_I_ or _me_) and **do** (_you_). However, _you_ in English can have multiple meanings, which are translated to Lojban in specific ways:

- _you_ as _the one person I'm talking to_:

 >**le pa do**<br/>
 >_you one_

 We know that **le re prenu** means _the two people_. It's also possible to put numbers after **le** and before pronouns.

- _you_ as _all of the people I'm talking to_:

 >**ro do**<br/>
 >_each of you_, _all of you_ (or Southern U.S. _y'all_)

 One can also use numbers with **ko**:

 >**ro ko klama ti**<br/>
 >_All of you, get over here._

- _you_ as _a specific number of people I'm talking to_:

 >**le re do**<br/>
 >_you two_

 For example, one can start emails to their parents with **coi le re do**.

 Notice that **re do** means _two of you_ and **re le ci do** means _two of you three_.

- _you_ as _the person or people I'm talking to plus some other person or people_:

 >**do'o**<br/>
 >_you and someone else_

- _you_ as _anyone_ (e.g., _Money can't buy you love._):

 It's typically expressed by:

 >**ro da**<br/>
 >_all **da**_

 or

 >**ro lo prenu**<br/>
 >_all persons_

 However, you can often omit it altogether or place **zo'e** in that position.
<!-- The recommended method is turning pronouns into verbs first:

>**lo re me do ko klama ti**
>_You two, come here._

It's possible to omit **me** in this position and say **lo re do ko klama ti** but this can lead to confusion in beginners. -->

### More about short relative clauses

Short relative clauses with a pronoun following them can be placed immediately after **le**:

> **le gerku pe mi**
> _My dog_

In such cases, **pe** can even be omitted:

> **le gerku pe mi**
> **le mi gerku**
> _My dog_

**le mi gerku** means exactly the same as **le gerku pe mi**.

Thus, "**le** + argument + relation construct" is equivalent to "**le** + relation construct + **pe** + argument".

A few rules:

- if you want to use an argument converted from a relation (for example, with **le**) or if it's a name, it is advisable to use **pe** and place it after the argument: **le gerku pe la .alis.** (_Alice's dog_).
- omitting **pe** is acceptable only when using pronouns without numbers in front of them: **le do gerku** (_your dog_) but not **le pa do gerku** (= **le pa do cu gerku** = _one of you is a dog_).

It is much safer to use **pe** explicitly and place it after the argument to which it is attached: **le gerku pe la .alis.** and **le gerku pe mi** are the most intuitive constructs.

### Quoting text in different languages

**zoi** is a quotation mark for quoting non-Lojban text. Its syntax is **zoi X. text .X**, where X is a Lojban word (called the delimiting word) which is separated from the quoted text by pauses, and which is not found in the written text or spoken phoneme stream inside that quotation. It is common, but not required, to use the name of some letter, which corresponds to the Lojban name of the language being quoted:

> **zoi gy. John is a man .gy. cu glico jufra**
> _“John is a man” is an English sentence._

glico
: $x_1$ is English

where **gy.** stands for **glico**. Other popular choices of delimiting words are the word _zoi_ itself and a Lojban word suggesting the topic of the quotation.

Lojban strictly avoids any confusion between things and the names of things:

> **zo .bob. cmene la .bob.**
> `The-word “Bob” is-the-name-of the-one-named Bob.`

**zo .bob.** is the word, whereas **la .bob.** is the thing named by the word. The short qualifier words **la'e** and **lu'e** placed before terms convert back and forth between references and their referents:

> **zo .bob. cmene la'e zo .bob.**
> _The-word “Bob” is-the-name-of the-referent-of the-word “Bob”._

<!-- -->

> **lu'e la .bob. cmene la .bob.**
> _A-symbol-for Bob is-the-name-of Bob._

The last two examples mean the same. But this is different:

> **la .bob. cu cmene la .bob.**
> _Bob is the name of Bob._

and says that Bob is both the name and the thing named, an unlikely situation. People are not names.

**la'o** serves to mark non-Lojban names, for example, the Linnaean binomial names (such as "Homo sapiens"), which are the internationally standardized names for species of animals and plants.

Internationally known names which can more easily be recognized by spelling rather than pronunciation, such as _Goethe_, can also appear in Lojban text with **la'o**:

> **la'o dy. Goethe .dy. cu me la'o ly. Homo sapiens .ly.**
> _Goethe is a Homo sapiens._

Using **la'o** for all names rather than adapting them to Lojban, however, can make for a cumbersome text.

Everything expressed in text should also be expressed in speech and vice versa. Therefore, there cannot be any punctuation which is not pronounced. This means that Lojban has a wide range of words to quote other words. All Lojban convert a text into an argument term.

**lu** … **li'u** quote only text that is grammatically correct. To quote any Lojban text, we use **lo'u** … **le'u** quotes instead.

> **— xu lo'u je le'u lojbo sumsmi**
> **— na ku sumsmi**
> _— Is "je" a term?_
> _— No._

<!-- -->

> **ma xe fanva zoi gy.What's up?.gy. la .lojban.**
> _How to translate "What's up?" to Lojban?_

### Internal terms

Using **be**, you can fill in not only slots of relations but also add modal terms:

> **le xatra be de'i li vo cu se mrilu de'i li ze**
> _This letter, dated the 4th, is mailed on the 7th_

xatra
: $x_1$ is a letter

A date tagged with **de'i** applies only to the **xatra**. Compare:

> **le xatra de'i li vo cu se mrilu de'i li ze**
> _The letter on the 4th is mailed on the 7th_ (whatever that can mean)

Without **be**, the term **de'i li vo** would apply to the whole relation, not to **xatra**. What we want to say is that the former date applies just to the letter, and the latter date applies to the mailing of the letter. This means that in **le xatra be de'i li vo** the part **de'i li vo** (_the 4th, as a date_), applies only to the argument **le xatra**, and not to the entire sentence.

### Compound relations in detail

The grouping of terms in Lojban grammar is particularly important when it comes to tanru (compound relations). The way relations group together in a tanru determines what that tanru means. For example,

> _the bad music magazine_

has two interpretations in English: a bad magazine about music or a magazine about bad music. In Lojban, its equivalent

> **le xlali zgike karni**

has only the interpretation _a bad-music magazine_, because the first two relations (_xlali zgike_ — _bad music_) group together first. It is important to modify the grouping of relations to ensure the tanru conveys the intended meaning. For that reason, Lojban has a couple of mechanisms in place for making tanru group together properly.

In English, we use brackets to structure the text. Similarly, for tanru, we use **ke** for the left bracket and **ke'e** for the right bracket.

**le xlali ke zgike karni** means _the bad (music magazine)_.

As you can see, we separated **xlali** from the rest of the tanru and made it apply to the whole tanru. There is no need for **ke'e** at the end of the tanru since we already know that it ends here.

> **.i mi pu zi te vecnu le xlali ke zgike karni .i to'e zanru la'o gy.Eurythmics.gy.**
> _I just bought a bad (music magazine). It dissed the Eurythmics._

That's one way of grouping together components in tanru. The other way is to use **bo** in a new role. When **bo** appears between two components, it means that those components group together more tightly than anything else. So an alternative way of saying _bad (music magazine)_ is

le xlali zgike bo karni
: the bad music-magazine

**bo** here is similar to the hyphen in the English translation. This means that **zgike bo karni** should count as a unit, to which **xlali** (_bad_) applies.

So **bo** makes the connections tighter:

> **la .doris. e la .alis. o nai bo la .bob.**
> _Doris and (either Alice or Bob)_

**ke** can also be used with connectives (though not with sentences; they have their own kind of bracket, **tu'e … tu'u**). So we could also say

> **la .doris. e ke la .alis. o nai la .bob.**

Remember that the right bracket **ke'e** can often be left out without changing the meaning (as in this case).

Forethought conjunctions are also frequently used because they can eliminate the need for right brackets:

> **ge la .doris. gi go nai la .alis. gi la .bob.**
> _Doris and either Alice or Bob_

and

> **go nai ge la .doris. gi la .alis. gi la .bob.**
> _Either Doris and Alice, or Bob_

There is no need for **bo** or **ke** with forethought conjunctions.

### «**co**» for changing the order in compound relations

There is another way of restructuring compound relations.

> **mi fanva se jibri**
> _I'm a professional translator_

jibri
: $x_1$ is a job of $x_2$

If I wanted to say that I'm a professional translator from English to German, I could use **be** and **bei**:

> **mi fanva be le dotco bei le glico be'o se jibri**
> _I'm a professional translator to German from English._

dotco
: $x_1$ is German

The fact that it was a compound relation could quickly be lost in speech due to the complicated structure of the sentence. Here, we can use the word **co**:

**co** — inverts the compound relation, making the rightmost component modify the leftmost instead of the other way around. Any previous argument term fills the modified, any following argument term fills the modifier.

> **mi se jibri co fanva le dotco le glico**

It is the same relation as the previous Lojban one, but much easier to understand. Notice that any argument before the compound relation fills **se jibri**, while any following it only fills the modifying component: **fanva**.

The strength by which two components are bound together with **co** is very weak — even weaker than normal compound relation grouping without any grouping words. This ensures that, in a co-construct, the leftmost component is always the component being modified, and the rightmost component always modifies, even if any of those parts are compound relations. This makes a **co**-construct easy to understand:

> **ti pelxu plise co kukte**

is read as **ti (pelxu plise) co kukte**, which is the same as **ti kukte pelxu bo plise**. This also means that a **ke … ke'e** cannot encompass a **co**.

Another example:

> **mi merko limna co mutce certu**
> _I am a much experienced American swimmer._

merko
: $x_1$ is American (the USA sense)

Here is the list of different kinds of groupers in compound relations ranked from the tightest to the most loose:

1. **bo** and **ke … ke'e**
2. logical connectives inside compound relations like **je**
3. not using grouping words
4. **co**

### Explicit termination of arguments

The small word **ku** can be used at the end of an argument to explicitly show its right border. **ku** is analogous to the right bracket in math.

> **tu du le badna ku ui**
> **tu du le ui badna**
> _That is the banana (yay!)_

As opposed to:

> **tu du le badna ui**
> _That is the banana (yay that it's a banana and not something else in nature!)_

### Avoiding explicit termination
Another style of speaking involves avoiding termination. Here are some common cases:

Elimination of **li'u**, the right quotation mark:

> **lu mi prami do li'u cu se cusku la .alis.**
> **lu mi prami do li'u se cusku la .alis.**
> **lu mi prami do cu se cusku la .alis.**
> _"I love you," said Alice._

**li'u** can be omitted here because there cannot be two main relation constructs in one sentence. Hence, we first read the **lu mi prami do** part, and then when we see the **cu**, we realize that we cannot continue this quoted sentence further. We assume that the quotation has ended and the outer sentence continues. Thus, no ambiguity arises.

Elimination of **ku'o**, the right border of relative clauses:

> **le prenu noi mi zgana ke'a ku'o ca tavla le pendo be mi**
> **le prenu noi mi zgana ke'a ca tavla le pendo be mi**
> _The person whom I'm observing is now talking to my friend._

**ku'o** can be omitted here when the relative clause that we need (**mi zgana ke'a**) ends in a term, **ke'a** in this case. After the relative clause, something other than a term starts, so the relative clause cannot be continued, and thus we know it successfully ends without any explicit right bracket words.

A similar trick would be to always place **ke'a** at the end of the relative clause:

> **le prenu noi ke'a melbi ku'o ca tavla le pendo be mi**
> **le prenu noi melbi fa ke'a ca tavla le pendo be mi**
> _The person who is pretty is now talking to my friend._

However, in the following case, termination is necessary:

> **le prenu noi mi zgana ke'a ku'o le pendo be mi ca tavla**
> _The person whom I'm observing is now talking to my friend._

because after the relative clause **mi zgana ke'a**, we chose to place another term (**le pendo be mi**) not belonging to the current relative clause.

A semi-trick here would be to use **ce'e**:

> **le prenu noi mi ke'a zgana ce'e le pendo be mi ca tavla**
> _The person whom I'm observing is now talking to my friend._

Here, we end the relative clause with the main relation construct **zgana**. Then we have the conjunction **ce'e** and a term afterward (**le pendo be mi**). Since **ce'e** can join only terms, we know that to the left of **ce'e**, we have a term, which can only be **le prenu noi mi ke'a**. Hence, the meaning is retained, and no ambiguity arises. Note that we still need a separate word, **ce'e**, in such cases, so although we eliminated the bright bracket word, we still had to introduce something else.

Elimination of **kei**, the right border of inner sentences:

> **mi cinmo le ka badri kei le tcini**
> **le ka badri cu se cinmo mi le tcini**
> **mi cinmo fi le tcini fe le ka badri**
> **mi cinmo le ka badri ce'e le tcini**
> _I feel sad regarding the situation._

> **mi stidi lo ka citka su'o da kei do**
> **mi stidi lo ka ce'u su'o da citka ce'e do**
> _I suggest that you eat something._

As you can see, no trick makes the result shorter than the original with **kei**, so for conciseness, you may wish to use **kei**.

### Conversion from sets to masses

> **le prenu cu pa moi le'i pendo be mi ku noi lu'o ke'a ca smaji**
> _He is the first among my friends who keep silence together._
> _The person is the first among the set of my friends who are now, as a crowd, being silent._

The qualifier word **lu'o** placed before an argument converts it into a mass made of members of that argument. In this case, **ke'a** refers to the set of my friends **le'i pendo be mi** and then **lu'o** converts the members of the set into a mass, the crowd of my friends.

### Sets and subsets

Some infinitives may imply more than one **ce'u**:

> **le'i prenu cu simxu le ka prami**
> **le'i prenu cu simxu le ka ce'u prami ce'u**
> _The people love each other._

simxu
: members of the set $x_1$ reciprocally do $x_2$

The relation **simxu** takes every possible pair from the set specified in place $x_1$ and asserts the relation specified within $x_2$.

If we have three people, then it would mean all of them love each other.

> **do ce la .alis. ce mi simxu le ka prami**
> **do ce la .alis. ce mi simxu le ka ce'u prami ce'u**
> _You, Alice, and I all love each other._

ce
: conjunction: joins several arguments into a set

The conjunction **ce** merges arguments into a set. Thus, **do ce la .alis. ce mi** might be a more verbose way of **le'i prenu** from the previous example when we want to name the members of the set.

<pixra url="/assets/pixra/cilre/simxu_tunba.webp" caption="le'i ci prenu cu simxa le ka tunba" definition="The three people are all siblings to each other."></pixra>

In total, we assert 6 relations:

1. You love Alice.
2. You love me.
3. Alice loves me.
4. Alice loves you.
5. I love Alice.
6. I love you.

Hence, **simxu** is a nice shortcut for expressing mutual relations.

Now consider the example:

> **le'i su'o cmima be le'i prenu cu simxu le ka prami**
> _Some of the people love each other._

cmima
: $x_1$ is a member of set $x_2$

In this example, we show that a subset of the people in question (a subset of **le'i prenu**) has mutual love.

This allows us to convey even trickier ideas:

> **le'i su'o citno cmima be le'i stati prenu cu simxu le ka prami**
> _Some youngsters from those smart people love each other._
> `Some young members of the set of smart people love each other.`

<!-- https://www.whitman.edu/mathematics/higher_math_online/section02.04.html -->
<!-- ### Math problems

Below is a list of some concepts and problems in math that illustrate how Lojban can deal with them.

* uniqueness
	> $\exists ! x\,(x^2=0)$<br/>
	>There exists a unique value for the varialble $x$ such that for this value the expression $x^2+1=2x$ is true.<br/>
	> **pa da zo'u li no du lo tenfa be nu'i da li re**<br/>
	> There is just one $x$ such that $0$ is equal to the exponential result of $x$ to power $2$.<br/>
	> **su'o da ro de zo'u du go da de gi li no lo tenfa be nu'i ge da li re gi de li re**<br/>
	> For every $x$ (that has some value) and for every $y$ whatever they might be: either 1. $x$ is equal to $y$ and 2. $0$ is equal to the exponential result of both $x$ to power $2$ and $y$ to power $2$; or 1. is false and 2. is false.

	This math problem postulates that there exists only one unique value of $x$ such that the expression $(x^2=0)$ is true. "Uniqueness" can be expressed either as **pa** (_one_) or in a more verbose way: 

	1. we postulate that $x$ has some value making our math statement true, hence we use **su'o da**, and
	2. we define a second variable, e.g. $y$ and show that whenever $(x^2=0)$ and $(y^2=0)$ then $x=y$.
* Fibonacci numbers

	Fibonacci numbers are a sequence of numbers in which each number is the sum of the two preceding ones, usually starting with 0 and 1. The sequence goes: 0, 1, 1, 2, 3, 5, 8, 13, 21, 34, and so on.


	There are several ways to calculate Fibonacci numbers. One straightforward approach is to use recursion, where the $n$-th Fibonacci number is calculated as the sum of the $(n-1)$th and $(n-2)$th Fibonacci numbers. 

	The Fibonacci function has $n$ as its input and the $n$-th Fibonacci number as its output.

	> **ro da poi kacna'u zo'u**
	> **ge da du li no gi lo ka fibno da du cu ka du li no**
	> **.i jonaibo**
	> **ge da du li pa gi lo ka fibno da du cu ka du li pa**
	> **.i jonaibo**
	> **lo ka fibno da du cu ka sumji lo fibno be lo se sumji be da bei li pa be'o lo fibno be lo se sumji be da bei li re**

	> _For every $n$ that is a natural number, if $n=0$ then the $n$th Fibonacci number is equal to $0$._
	> _Or if if $n=1$ then the $n$th Fibonacci number is equal to $1$._
	> _Otherwise, the $n$th Fibonacci number is equal to the sum of the $n-1$th Fibonacci number and the $n-2$th Fibonacci number._

	In this solution, an ad hoc brivla **fibno** corresponds to the Fibonacci function is used.

	The sum of two numbers is expressed using **sumji lo fibno ... lo fibno**
	The difference of two numbers is expressed using **se sumji lo fibno ... lo fibno** -->

<!-- i ja
ge da du li za'u pa gi lo ka fibno da du cu ka du li mo'e lo fibno be li mo'e da ni'u pa te'u su'i mo'e lo fibno be li mo'e da ni'u re
i ja
ge da du li za'u pa gi lo ka fibno da du cu ka sumji lo fibno be li mo'e da ni'u pa lo fibno be li mo'e da ni'u re -->

<!-- ## Second order logic

We've seen **da** (and **de**, **di**) being a "variable" in noun form with declared meanings depending on propositions given.
It's usually translated as _there is X, there are X such that …_

However, for curiosity I must mention the series of verbs that also serve the purpose of "variables" but in verb, i.e. relationship form:

>**su'o bu'a zo'u mi bu'a do**
>_There is some relationship or property: I have this relationship to you._
> _You and I are related in at least one way._

>**ro bu'a zo'u ga nai le'e mlatu cu bu'a gi la .dinas. bu'a**
>>_For every possible relation or property: if cats have it then Dinah has it too._ (Thus we assume Dinah is a cat.)

The reasoning behind these variable verbs is hidden in formal logic. Needless to say, they are rearely used in speech but here is one possible example:

su'o bu'a zo'u ge ge da na bu'a gi su'o da su'o de zo'u ge da .e de bu'a gi da manci de gi ro da ro de zo'u da bu'a .ije da manci de .inaja de bu'a
- fix the sentence

<!-- ## Things not yet formalized in Lojban

Though Lojban might be the speakable language No.1 in the world is how detailed its grammar is. Still there are some
It's unknown what **ta'e na** means as opposed to **na ta'e**.

It's unknown how to deal with **na go'i**.

It's unknown how xorlo works when we need explicit conversion between sets and masses, how to operate sets in general, how to use xorlo together with second order logic like bu'a.

postoxorlo working with anaphora and outer quantifiers. -->

<!-- ## Non-standard connective system

Some people for connecting nouns instead of

- **a**, **e**, **o**, **u**

use

- **ja**, **je**, **jo**, **ju**

That is instead of

>**mi e do nelci le plise**
>_I like apples, and you like apples._

they say

>**mi je do nelci le plise**
>_I like apples, and you like apples._

This is a non-standard approach. People use this style because in it there are fewer conjunctions to remember.

But you should be careful not to forget **le** or numbers to form nouns: **mi nelci le plise je jisra** would mean _I like something that is an apple (or apples) and is juice_ (?!)

The correct sentence uses **le** to form every noun:

>**mi nelci le plise je le jisra**
>_I like apples and juice._

In standard approach the speaker uses a separate conjunction **e** when connecting nouns, and it's easier to see the difference and the correct meaning:

>**mi nelci le plise .e le jisra**
>_I like apples and juice._ -->