## Lesson 10. Structuring text

### «**ju'a**» and assertions

The main relation of a sentence asserts some information unless modified by some interjection:

> **mi viska do**
> _I see you._
> `I assert that I see you`
<!-- -->
> **.au mi viska do**
> _I wish I saw you._

In the last example I only have a wish but I don't assert that I see you.

Another pair of examples: 

> **le prenu cu cizra .i ji'a je la .alis. cu jinvi le du'u go'i**
> _The person is strange. And Alice thinks that too._

<!-- -->

> **la .alis. cu jinvi le du'u le prenu cu cizra**
> _Alice has an opinion that the person is strange._

Relations that are inside places may not be asserted. In the last example, the man being strange (**le prenu cu cizra**) is not asserted by the speaker; it's only Alice's opinion.

The interjection **ju'a** makes the relation asserted by the speaker. The first sentence can be rephrased as:

> **la .alis. cu jinvi le du'u ju'a le prenu cu cizra**
> _Alice has an opinion that the person is strange, and it is so._

<!-- -->

> **ju'a .au mi viska do**
> _I wish I saw you. But I do see you at the same time._

English often fails to translate this powerful **ju'a** concisely, so the English translation doesn't follow the word order of the Lojban original.

Here's another example:

> **mi nelci le nu do dansu**
> _I like when you dance._

<!-- -->

> **mi nelci le nu ju'a do dansu**
> _I like that you dance._

In the second case, the speaker asserts _You dance_.

### «**pe'a**» for metaphors, «**za'e**» for nonce words, «**ba'e**» for emphasis

> **le ninmu cu tarci pe'a .i va'i ri misno**
> *The woman is a star, metaphorically speaking. In other words, she is famous.*

pe'a
: interjection: marks a construct as metaphorically used.

tarci
: $x_1$ is a star

**tarci** denotes real stars, objects in the sky. The interjection **pe'a** transforms it into a metaphorical meaning.

> **.i ba ku mi pu viska le cizra stuzi poi le fagri cu nenri .i mi pu klama za'e le fagrystu**
> *Then, I saw a strange place with a fire inside. I approached the, let's say, "fire-place."*

za'e
: left interjection: marks the following construct as used not in its usual meaning

Left interjections, as their name suggests, are placed before a modified construct (whereas other interjections are placed after it).

The left interjection **za'e** shows that the following construct, **le fagrystu** in this case, is made up or used not in its standard meaning. Thus, there is no need to look it up in the dictionary or ask the speaker specifically about the meaning of this word since the word is used to further describe the story.

> **ba'e la .alis. e nai la .kevin. pu darxi mi**
> *Alice, not Kevin, hit me!*

<!-- -->

> **mi djuno le du'u ma kau pu darxi ba'e mi .i ku'i mi na ku djuno le du'u ma kau pu darxi do**
> *I know who hit me. However, I don't know who hit you.*

ba'e
: left interjection: puts an emphasis on the following construct

To emphasize a word, we would use stress in spoken English, and underlining, italics, or capital letters in written English. In Lojban, we use the left interjection **ba'e**.

### Paragraphs and separating sentences

**ni'o** works exactly like **.i** but starts a new paragraph. Paragraphs are usually associated with new topics.

It is normal to use **.i** in speech to separate sentences, but you might want to use **ni'o** especially in written text to structure it.

<table>
 <tr>
  <td>ni'o</td>
  <td></td>
 </tr>
 <tr>
  <td>.i le pa nintadni cu klama le ctuca bu'u le galtu bu'u le darno cmana</td>
  <td>A newbie visited the master far high in the mountains.</td>
 </tr>
 <tr>
  <td>.i sei le nintadni cu cusku doi le ctuca noi certu tavla fo la .lojban. ku'o do skicu .e'o fi mi fe le nu fi ma kau fa la .lojban. cu frica le'e drata bangu</td>
  <td>The newbie said: "Master, you speak fluent Lojban. Please, tell me what is the difference between Lojban and other languages."</td>
 </tr>
 <tr>
  <td>.i le ctuca cu friti tu'a le kabri be lei jinto djacu le nintadni gi'e ba bo cusku</td>
  <td>The master offered him a cup of spring water and then said:</td>
 </tr>
 <tr>
  <td>lu .i ca ti ko catlu le djacu gi'e skicu ri li'u</td>
  <td>Now look at the water and describe it.</td>
 </tr>
 <tr>
  <td>.i ku'i sei le nintadni cu cusku mi mo'u pinxe ri i je mi na ku kakne le ka catlu</td>
  <td>The newbie said: "But I drank it up. I can't look at it."</td>
 </tr>
 <tr>
  <td>.i ki'u ma do na ku kakne sei le ctuca cu cusku</td>
  <td>Why can't you?, the master said.</td>
 </tr>
 <tr>
  <td>.i sei le nintadni cu cusku le djacu ca pagbu le xadni be mi</td>
  <td>The newbie said: "Now it's a part of my body."</td>
 </tr>
 <tr>
  <td>ni'o</td>
  <td></td>
 </tr>
 <tr>
  <td>.i su'o da poi prenu zo'u le mudri co'a pagbu le zdani be da</td>
  <td>A piece of wood becomes a part of someone's house.</td>
 </tr>
 <tr>
  <td>.i su'o de poi prenu zo'u su'o lo bangu poi se tadni cu co'a pagbu le menli be de</td>
  <td>A language learnt becomes a part of someone's mind.</td>
 </tr>
 <tr>
  <td>.i su'o di zo'u le dirgo be le djacu co'a pagbu da poi zmadu fi le ka banli</td>
  <td>A drop of water becomes a part of something greater.</td>
 </tr>
</table>


dirgo
: $x_1$ is a drop of material $x_2$ …

### «**to**» … «**toi**» for parenthetical remarks

Comments placed inside parentheses in English text are formed using the word **to** instead of the left parenthesis and **toi** instead of the right parenthesis:

> **ti poi to vi'o nai do mi na ku djica tu'a su'o lo drata toi plise cu fusra**
> _This (no, I don't want another one!) apple is rotten._

djica
: to desire

drata
: … is different from …

plise
: $x_1$ is an apple

fusra
: $x_1$ rots or decays with agent $x_2$

Parenthetical remarks can go anywhere interjections can, meaning they can be placed pretty much anywhere in a Lojban sentence. With parentheses, just like with quotes, you need to know where the parenthesis starts and where it ends.

### Fixing errors in speech

When correcting yourself, it's important to know how to fix your mistakes. You can use two words to delete your previous words:

si
: deletion: deletes the last word only

sa
: deletion: deletes back until the next cmavo spoken

They delete words as if those words have never been spoken. However, they do not work inside certain quotes (all quotes except **lu…li'u**), as that would make it impossible to quote these words. Using multiple **si** in a row deletes multiple words.

In English, when you make a mistake while speaking (factual or grammatical), you usually don't bother to correct it, even if you realize you made a mistake. That's because English is fairly redundant (for this very reason!). If we catch ourselves making an error in English, we quickly provide a correction without going into details like how many words should be canceled: context usually helps us. For example:

> _I'm learning the English word, … er, Lojban word._

Context and common sense dictate that _Lojban word_ is meant to replace _English word_. But what if it was meant to replace _I'm learning the English word_? We wouldn't normally care in natural languages.

However, Lojban allows you to be more precise about which words you are correcting.

**si** erases the immediately preceding word. If you want to erase two words in a row, you say **si si** after them. In Lojban, the correction above would be:

> **.i mi tadni le glico valsi si si lojbo valsi**
> _I'm learning the English word, … er, Lojban word._

valsi
: $x_1$ is a word with the meaning $x_2$ in language $x_3$

The problem with **si** is that you have to count words. This can become tedious, and you shouldn't have to keep a transcript of your words when you want to correct yourself.

The other correction word **sa** is more helpful: **sa** takes as its argument the word following it. Then this **sa** deletes words back until it finds the same word or a word of the same class. For example:

> **.i mi tadni le sa .i mi tadni le lojbo valsi**
> _I'm learning the … er, I'm learning the Lojban word._
> **.i mi tadni le lojbo valsi**

The argument of **sa** is the word **.i**. So the sentence following **sa** replaces the current sentence up to and including **sa**. Or consider:

> **.i mi mrilu fi do de'i li jefydei bu pa sa de'i li jefydei bu re**
> _I mailed to you on Monday, … er, on Tuesday._
> _On Monday I mailed it to you, … er, actually, it was Tuesday._
> **.i mi mrilu fi do de'i li jefydei bu re**

The correction is **de'i li jefydei bu re** — _on Tuesday_. So what it replaces is everything from the last relation beginning with **de'i**: **de'i li jefydei bu pa** — _on Monday_.

### Dealing with misunderstanding

> **— .i mi pu zi te vecnu le flokati**
> **— .i le flokati ki'a**
> _— I just bought a flokati._
> _— Flokati, huh?_

ki'a
: interjection inquiry: confusion about something said. _Huh? Whaat?? (confusion), pardon?_

When you don't understand what someone has just said — whether because you don't get what they were referring to, you don't know the word, or the grammar confused you — you can repeat the word or relation you didn't get and add **ki'a** as a plaintive request for clarification. This is even better than _Huh?_, because you can point out exactly what made you say _Huh?_

Here is a dialogue:

> **— mi nelci le kalci**
> **— ki'a ?**
> _— I like shit._
> _— Whaat???_

**Note:** Since **zo** quotes any word following it — any word — it turns out that **zo ki'a** doesn't mean _zo? Huh?_ at all, but _The word **ki'a**._ To ask _zo? Huh?_, you'll have to resort to **zo zo ki'a**.

### Reverse «**mi**» and «**do**» using «**ra'o**»

> **- mi prami do**
> **- go'i ra'o**
> _- I love you._
> _- I love you too._

ra'o
: interjection: updates meaning from the viewpoint of the current speaker

If someone says **mi prami do** and you reply **go'i ra'o**, that reverses the pronouns **mi** and **do** so that they apply from your point of view. Thus, every pronoun gets re-evaluated.

Compare:

> **- mi prami do**
> **- go'i**
> _- I love you._
> _- You do._

A simple **go'i** still makes **mi** refer to the person who used it, and **do** refer to the listener of the person who said it.