---
title: krulermorna alphabet
---

**la krulermorna** is an alternative orthography that more strictly implements audio-visual isomorphism of Lojban spelling.

1.  Most letters are from the original Latin-based orthography.
2.  Glides **i** and **u** in front of vowels are considered consonants and thus are expressed via distinct letters:
    *   **i** => **ɩ**
    *   **u** => **w**
3.  Diphthongs that act like other "pure" vowels are expressed via distinct letters:
    *   **au** => **ǎ**
    *   **ai** => **ą**
    *   **ei** => **ę**
    *   **oi** => **ǫ**
4.  in other positions **i** and **u** are retained as they are in the original Latin orthography.

## Usage

la krulermorna is used by an algorithm in [la sutysisku](https://la-lojban.github.io/sutysisku/en/ "la sutysisku") app to search for rhymes to Lojban words.

It can also help understand Lojban morphology.

Other than that it's mostly an art project.

The overal number of letters in Lojban alphabet is raised from 26 in the official spelling up to 32 in la krulermorna, which may not be desirable for people using small on-screen keyboards like those on portable devices.

## la vlipa krulermorna

<figure class="wide">
	<img src="https://github.com/La-Lojban/suho-pixra-pe-la-jbotcan/blob/master/320px-la_vlipa_krulermorna.png?raw=true" alt="la vlipa krulermorna">
	<figcaption>
	.i coi do<br/>.i mi ca jai gau djuno fai do<br/>lo du'u wi mi ca pilno<br/>la krulermorna<br/>lo ka ciska dei<br/>.i ɩa ky. jai cinri
	</figcaption>
</figure>

_la vlipa krulermorna_ is a modification of la krulermorna where the letter **ǎ** is replaced with Unicode Character 'LATIN SMALL LETTER AU'. The latter isn't supported in most used fonts and therefore this variant of la krulermorna orthography is less used.

## Interjections according to krulerske

|          |           |              |        |
| -------- | --------- | ------------ | ------ |
| .ǎ       | .ą        | .ę           | .ǫ     |
| Wish ... | I'm gonna | it should be | ouch\! |

<div class="first_col">

|     | a               | e                | i                   | o             | u               |
| --- | --------------- | ---------------- | ------------------- | ------------- | --------------- |
| .   |                 |                  |                     |               |                 |
| ɩ   | I believe       | aye\! agreed\!   | yikes\!             | respect       | I love it       |
| w   | discovery       | What a surprise  | hooray\!            | voila\!       | oh poor thing   |
| .a' | I'm listening   | alertness        | oomph\! (effort)    | I hope        | hm, I wonder... |
| .e' | you may         | come on, do it\! | do it\!             | please, do it | I suggest       |
| .i' | ok, I accept it | I approve\!      | I know that feeling | thanks to it  | familiarity     |
| .o' | pride           | closeness        | danger\!            | patience      | relaxation      |
| .u' | gain            | what a wonder\!  | hahaha\!            | courage       | sorry\!         |

</div>

## Alternative representation

<div class="first_col">

|     | a          | e          | i            | o            | u           | ǎ      | ą      | ę          | ǫ              |
| --- | ---------- | ---------- | ------------ | ------------ | ----------- | ------ | ------ | ---------- | -------------- |
| .   |            |            |              |              |             | desire | intent | obligation | complaint/pain |
| ɩ   | belief     | agreement  | fear         | respect      | love        |        |        |            |                |
| w   | discovery  | surprise   | happiness    | completion   | pity        |        |        |            |                |
| .a' | attentive  | alertness  | effort       | hope         | interest    |        |        |            |                |
| .e' | permission | competence | constraint   | request      | suggestion  |        |        |            |                |
| .i' | acceptance | approval   | togetherness | appreciation | familiarity |        |        |            |                |
| .o' | pride      | closeness  | caution      | patience     | relaxation  |        |        |            |                |
| .u' | gain       | wonder     | amusement    | courage      | repentance  |        |        |            |                |

</div>