---
title: How to say "play" in Lojban
summary: Translations of the English word "play" to the Lojban logical language
---
The English verb *to play* has several meanings, most common of which are

* to play
	* to act recreationaly, non-seriously as opposed to work, to have fun. *They played long.*
	* to perform in a competition, to participate in a game. *They played soccer.*
	* to act a role (e.g. in  theater performances). *He played Hamlet.*
	* to produce music using an instrument. *He played the piano, first he played Chopin, then he played Beethoven's Moonlight Sonata.*
	* to use a device for watching or listening. *I played a DVD.*

Now the Lojban language is not a simply an encrypted English language. It can't always have the same range of meanings for a single word as English has. There is usually no one-to-one mapping.

Here is a list of existing official words with their adapted definitions:

* **kelci** - *... plays with a toy ...*
	* **le citno mlatu pu ca'o kelci le skori** - *The kitten was playing with rope.*
* **jivna** - *... competes with opponent ... in contest/competition ... (event) for gain/prize ...*
	* **.i la .alis. pu jivna le drata nixli le nu vi'i ve'u bajra vau le ka cpacu le jdini** - *Alice competed with other girls in a long distance race with a monetary prize for the winner.*

Not much. No official word for playing music, playing a device, playing in a theater performance. However, there are words for related concepts that can be combined to convey the idea. Plus one can propose new unofficial words. So here is the list of meanings of the verb "to play" with possible translations. 

* *They played long.*
	* **le prenu pu nalgunka se zdile**, literally `The people did non-workingly have fun`.
* *They played soccer.*
	* **le prenu pu uantida la fudbol**, literally `The people played-the-game-of Soccer`. Uses a non-standard word **uantida** meaning *... plays the game, participates in the game ... where the game has a set of rules*. Etymologically, **uantida** is made of various Chinese words for playing games like 玩 ("wán", a verb for playing games with hitting using legs, such as soccer) 踢 ("tī", a verb for sports with hitting using hands, such as basketball), 打 ("dǎ", a verb for sports with throwing something, e.g. discus). Notice that Chinese like any East Asian languages uses separate verbs forplaying different sports unlike this proposal for Lojban.
* *He played Hamlet.*
	* **ra dracyka'i la .amlet.**, the proposed word **dracyka'i** means *... plays the role of ... in play ...*
* *He played the piano, first he played Chopin, then he played Beethoven's Moonlight Sonata.*
	* The proposed verb **zgipli** means *... uses instrument ... to play music ...* hence
	**ra zgipli le pipno .i pamai ra zgipli fi tu'a la .copen. i remai re zgipli fi la lunra gusni zgikrsonata**, literally, `He plays the piano. Firstly, he plays some instrument to produce some music related to Chopin. Secondly, he played some instrument to produce the music of Moonlight Sonata.`
* *I played a DVD.*
	* **gau mi dyvydy. ca'a jai se zgike**, literally, `Due to me, DVD actually is a source of music.`
	* **gau mi le tutci ca'a tivni**, literally, `Due to me, the tool actually televises something.`