---
title: Are verbs in Lojban broken?
---

<div class="lojbo simple_blockquotes"></div>

## Question

It seems that learning definitions of verbs in Lojban, such as

> *$x_1$ runs on surface $x_1$ using limbs $x_1$ with gait $x_1$*

could be challenging because almost every verb has its own distinct place structure. Is there a way to make this require less mental effort? Why is Lojban designed this way?

## Answer

English functions similarly in a pragmatic sense. It has verbs with their implied place structure. The main difference is that Lojban dictionaries explicitly state the place structure, while most English dictionaries do not. The reason for this system is that having a separate preposition for each place would be even more burdensome and sometimes even unworkable. 

Having a limited set of prepositions would make the language highly subjective and not universal. For instance, in English we say

> I depend on you.

but in Russian it literally translates to

> I depend from you.

while in Portuguese and Spanish it literally translates to

> I depend of you.

Certain prepositions combined with specific verbs could create unusual meanings, leading to even more randomness than the current system with $x_1$, $x_2$, etc.

It's important to note that most Lojban verbs have up to three places only. Only about 30 core verbs (lo gismu) have five places. Moreover, you don't need to know the place structure of every core verb to speak fluent Lojban. For example, is it crucial to know the place structure of 'trigonometric sine function' when discussing food preparation?

It's true that _I give you a present_ doesn't require prepositions, while the place structures of other verbs do. However, there isn't more memorization involved. English requires learning metaphors. Why is it _I give TO you_ and _I talk TO you_ when the processes are completely different?

Consider the following translations as well:

> [English] *I think of you*

> [Russian] *Ya dumayu o tebe* (I think about you)

> [Spanish] *Yo pienso en ti* (I think in/into you)

Some Lojban place structures are less straightforward than others, just like in English. For instance, why is it "This movie is pleasing to me" instead of "I like this movie"?

Lojban verbs, like English verbs, can be grouped into frames with identical place structures, e.g.

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=mlatu&bangu=en&versio=masno">mlatu</a> - $x_1$ is a cat of species $x_1$

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=gerku&bangu=en&versio=masno">gerku</a> - $x_1$ is a dog of species $x_1$

## Place Structure is Easy to Learn, But...

Often, the place structure is easy to learn. However, the concept of movement presents a random set of place structures. Consider the following:

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a> - $x_1$ (object) moves to destination/receiver $x_1$ [away] from origin $x_1$ over path/route $x_1$.

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> - $x_1$ runs on surface $x_1$ using limbs $x_1$ with gait $x_1$.

Why not have one place structure for all of them?

## Answer

<a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a>, <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a>, and <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=cadzu&bangu=en&versio=masno">cadzu</a> depict a similar process from very different perspectives. In <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a>, the origin and destination are not important; the emphasis is on the form. It's not "running to from" as in English. Please, don't confuse English glosses with the actual process that Lojban verbs describe. To be in a <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> state means having a certain gait while touching a surface with your limbs and doing so quickly.

A person using a treadmill doesn't have any "to" or "from" points but is simply running while remaining in the same place. This is a good example of a bajra state without being in a klama state.

In summary, Lojban is not a relexed English, although common usage and the Lojban-English dictionary might suggest that.

The issue lies more with English's ambiguity than with the Lojban language itself.

Lastly, one can use lo tanru, like bajra klama (to run-come), to express both running and coming to a specific place.
