# Tlön, Uqbar and La Gleki's fishy apples

![Their language and the derivations of their language — religion, letters, metaphysics — all presuppose idealism. The world for them is not a concourse of objects in space; it is a heterogeneous series of independent acts. It is successive and temporal, not spatial.](https://github.com/La-Lojban/suho-pixra-pe-la-jbotcan/blob/master/C_solarcorona2003.gif?raw=true)

![A Chinese prose writer has observed that the unicorn, because of its own anomaly, will pass unnoticed. Our eyes see what they are accustomed to seeing.](https://github.com/La-Lojban/suho-pixra-pe-la-jbotcan/blob/master/Costa_Rica_Unicorn_2800px.jpg?raw=true)

What I state here is that there are no objects in linguistic sense. Do they exist in reality is of no matter from this viewpoint. What is an apple? It's not an object. It's just a combination of properties.

> Something smooth+red+round+tasty => apple.

In order to make this even more clear let's assume you close your eyes and someone puts a slice of something salty in your mouth. You <u>taste</u> it. You are sure it's a piece of a fish. You say "It's a fish".

Now open your eyes. Now you <u>see</u> that it's an apple. Whaat?? An apple that tasted of fish? Yes. And yes, that's unusual.

Now you would probably be shocked. You'll definitely try to invent a new word for this apple as it's not a true apple. You'll probably call it "fishy apple".

This is where fuzzy logic starts. I don't think I would call a brown apple **[cribe](https://la-lojban.github.io/sutysisku/en/#sisku/cribe)** just because it shares some properties with bears (namely, the color). Although I wouldn't object much if you decide otherwise.

However, what I state is that humans can't perceive such continuum. They need fixed combinations of time/space/property. They call such combinations "objects".

There is a legend that the Indians could not see Christopher Columbus' ships as they approached just because they didn't perceive such strange combinations of properties as objects. They obviously had no words for "ships". They had to learn to understand such things. The same can be said about UFOs. In Middle Ages people called them "angels". We call them "alien ships". Camera thinks otherwise. One needs to get clear understanding what's going on to convert a number of properties into an "object=combination of properties".

The "invisible ships" myth suggests that when European explorers first approached certain lands, their ships were so unfamiliar to native people that they couldn't perceive them. It is likely based on a passage of Joseph Banks' diary describing the HMS Endeavour's arrival in Botany Bay. Banks wrote that the natives did not appear surprised or concerned from a distance (but unlike the myth, once the ships approached land they were confronted by armed men).

And of course one needs to read the story [Tlön, Uqbar, Orbis Tertius](https://raw.githubusercontent.com/La-Lojban/suho-pixra-pe-la-jbotcan/master/Uqbar.pdf) to get full understanding what it means to have words for such combinations of properties as

> the sun and the water on a swimmer's chest, the vague tremulous rose color we see with our eyes closed, the sensation of being carried along by a river and also by sleep.

When you come home and hear someone scratching against your door (whether it's a hypothetical situation or you hear it every day when you come home) it's the same object **[da](https://la-lojban.github.io/sutysisku/en/#sisku/da)**. More precisely **[da sraku](https://la-lojban.github.io/sutysisku/en/#sisku/da%20sraku)**. However, even if you have two animals at home each of whom can scratch it'll be the same **[da](https://la-lojban.github.io/sutysisku/en/#sisku/da)** every day. **[da](https://la-lojban.github.io/sutysisku/en/#sisku/da)** doesn't need to distribute over real individuals. **[da](https://la-lojban.github.io/sutysisku/en/#sisku/da)** just has the property of scratching. It can magically transform from a dog into a cat. That's how **[da mlatu ca de](https://la-lojban.github.io/sutysisku/en/#sisku/da%20mlatu%20ca%20de)** or **[da mlatu fau de](https://la-lojban.github.io/sutysisku/en/#sisku/da%20mlatu%20fau%20de)** works (**[de](https://la-lojban.github.io/sutysisku/en/#sisku/de)** = **[lo nu da sraku](https://la-lojban.github.io/sutysisku/en/#sisku/lo%20nu%20da%20sraku)**, **[de](https://la-lojban.github.io/sutysisku/en/#sisku/de)** is a world/situation).

# Three types of languages

There are 3 types of languages in the world: object languages, property languages and process languages.

The verb "to be" can be split into two in certain Romance languages. For example, the Spanish "ser" vs. "estar". This permanent vs. temporary sort of difference might be expressed in Lojban by the abundance of aspects and tenses, but what is really important that Sapir-Whorf hypothesis is clearly shown here. If some Native Americans call river "flowing of water" it is indeed a process. It's the same as if you start pouring water from a kettle. Likewise, the river might've started flowing thousands of years ago and might stop one day due to tectonic process for example.

In property languages instead of "Moon" one has to say something like "bright yellow high round".

In object languages people divide the world into

- objects that
- exist or do not exist

Lojban shouldn't force people to use either philosophy.

## Further reading

- ['Tlön, Uqbar, Orbis Tertius' by Jorge Luis Borges](https://raw.githubusercontent.com/La-Lojban/suho-pixra-pe-la-jbotcan/master/Uqbar.pdf)
- [Sapir-Whorf Hypothesis](https://mw.lojban.org/papri/Sapir-Whorf_Hypothesis)
- [Bear goo](https://mw.lojban.org/papri/Bear_goo)
- [BPFK Section: sensory gismu](https://mw.lojban.org/papri/BPFK_Section:_sensory_gismu)
- [ELG: Subjunctives in detail](https://mw.lojban.org/papri/ELG:_Subjunctives_in_detail)
- [Cognitive dissonance](https://en.wikipedia.org/wiki/Cognitive_dissonance)
- [Andrew Hurley, 'The Zahir and I, The Garden of Forking Paths, part of TheModernWorld.com.'](http://www.themodernword.com/borges/Zahir_and_I.html)