---
title: Cmavo dictionary
icon: 🧩
meta.type: article
meta.description: A more user-friendly list of cmavo definitions with examples
---

## KOhA

### Constructs

- mi:
  - definitions:
    - 1:
      - type: personal pro-sumti
      - definition: This pro-sumti refers to the speaker of the utterance. It may encompass the speaker alone or include others whom the speaker represents (e.g., a group or organization). The referent of **mi** can be either an individual or a mass, depending on context.
      - examples:
        - 1:
          - lojban: mi klama le zarci
          - translation: I go to the store.
- do:
  - definitions:
    - 1:
      - type: personal pro-sumti
      - definition: This pro-sumti refers to the listener or listeners of the utterance. Similar to **mi**, the referent can be either an individual or a mass, depending on the context.
      - examples:
        - 1:
          - lojban: do catlu le cukta
          - translation: You see the book.
- mi'o:
  - definitions:
    - 1:
      - type: personal pro-sumti
      - definition: This pro-sumti refers to the mass entity formed by the speaker and the listener(s) together and no one else. It always represents a mass, incorporating the properties and characteristics of both individuals.
      - examples:
        - 1:
          - lojban: mi'o klama le zarci
          - translation: You and I go to the store together.
- mi'a:
  - definitions:
    - 1:
      - type: personal pro-sumti
      - definition: This pro-sumti refers to the mass entity formed by the speaker and others, excluding the listener(s). It always represents a mass, encompassing the collective properties and characteristics of the individuals involved.
      - examples:
        - 1:
          - lojban: mi'a klama le zarci
          - translation: We, but not you, go to the store.
- ma'a:
  - definitions:
    - 1:
      - type: personal pro-sumti
      - definition: This pro-sumti refers to the mass entity formed by the speaker, the listener(s), and any other unspecified individuals. It always represents a mass, encompassing the collective properties and characteristics of all individuals involved.
      - examples:
        - 1:
          - lojban: ma'a casnu le jbobau
          - translation: We all discuss Lojban.
- do'o:
  - definitions:
    - 1:
      - type: personal pro-sumti
      - definition: This pro-sumti refers to the mass entity formed by the listener(s) and others, excluding the speaker. It always represents a mass, encompassing the collective properties and characteristics of the individuals involved.
      - examples:
        - 1:
          - lojban: do'o klama le zarci
          - translation: You and others, but not me, go to the store.
- ko:
  - definitions:
    - 1:
      - type: personal pro-sumti
      - definition: This pro-sumti is equivalent to **do** but is used specifically in commands or imperatives, indicating the listener should take action to make the statement true.
      - examples:
        - 1:
          - lojban: ko klama le zarci
          - translation: Go to the store!
- ti:
  - definitions:
    - 1:
      - type: demonstrative pro-sumti
      - definition: This pro-sumti refers to a specific object or location near the speaker, typically something that can be pointed to.
      - examples:
        - 1:
          - lojban: ti barda
          - translation: This (thing near me) is big.
- ta:
  - definitions:
    - 1:
      - type: demonstrative pro-sumti
      - definition: Similar to **ti**, this pro-sumti refers to a specific object or location, but one that is closer to the listener than the speaker.
      - examples:
        - 1:
          - lojban: ta xekri gerku
          - translation: That thing near you is a black dog.
- tu:
  - definitions:
    - 1:
      - type: demonstrative pro-sumti
      - definition: This pro-sumti refers to a specific object or location that is distant from both the speaker and the listener.
      - examples:
        - 1:
          - lojban: tu barda cmana
          - translation: That far away thing is a big mountain.
- di'u:
  - definitions:
    - 1:
      - type: utterance pro-sumti
      - definition: This pro-sumti refers to the most recently completed utterance in the discourse.
      - examples:
        - 1:
          - lojban: mi klama le zarci .i la'e di'u xamgu
          - translation: I go to the store. And that is good.
- de'u:
  - definitions:
    - 1:
      - type: utterance pro-sumti
      - definition: This pro-sumti refers to an earlier utterance in the discourse, further back than the one referenced by **di'u**.
- da'u:
  - definitions:
    - 1:
      - type: utterance pro-sumti
      - definition: This pro-sumti refers to a much earlier utterance in the discourse, further back than the one referenced by **de'u**.
- di'e:
  - definitions:
    - 1:
      - type: utterance pro-sumti
      - definition: This pro-sumti refers to the next utterance in the discourse, the one that will follow the current utterance.
      - examples:
        - 1:
          - lojban: la .saimn. cusku di'e
          - translation: Simon says the following:
- de'e:
  - definitions:
    - 1:
      - type: utterance pro-sumti
      - definition: This pro-sumti refers to a later utterance in the discourse, further ahead than the one referenced by **di'e**.
- da'e:
  - definitions:
    - 1:
      - type: utterance pro-sumti
      - definition: This pro-sumti refers to a much later utterance in the discourse, further ahead than the one referenced by **de'e**.
- dei:
  - definitions:
    - 1:
      - type: utterance pro-sumti
      - definition: This pro-sumti refers to the current utterance, the one being spoken or written at the moment.
      - examples:
        - 1:
          - lojban: dei jufra
          - translation: This is a sentence.
- do'i:
  - definitions:
    - 1:
      - type: utterance pro-sumti
      - definition: This pro-sumti refers to some unspecified utterance within the discourse, without specifying its position or content.
- ko'a:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: This pro-sumti can be assigned to any sumti using the cmavo **goi** and then used to refer to that sumti for the remainder of the discourse or until reassigned.
      - examples:
        - 1:
          - lojban: le gerku goi ko'a cu xekri. .i ko'a klama le zdani
          - translation: The dog, which we'll call it-1, is black. And it-1 goes to the house.
- ko'e:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the second selected sumti using **goi** and later used to refer to that sumti.
- ko'i:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the third selected sumti using **goi** and later used to refer to that sumti.
- ko'o:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the 4th selected sumti using **goi** and later used to refer to that sumti.
- ko'u:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the 5th selected sumti using **goi** and later used to refer to that sumti.
- fo'a:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the 6th selected sumti using **goi** and later used to refer to that sumti.
- fo'e:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the 7th selected sumti using **goi** and later used to refer to that sumti.
- fo'i:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the 8th selected sumti using **goi** and later used to refer to that sumti.
- fo'o:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the 9th selected sumti using **goi** and later used to refer to that sumti.
- fo'u:
  - definitions:
    - 1:
      - type: assignable pro-sumti
      - definition: Similar to **ko'a**, this pro-sumti can be assigned to the 10th selected sumti using **goi** and later used to refer to that sumti.
- ri:
  - definitions:
    - 1:
      - type: anaphoric pro-sumti
      - definition: This pro-sumti refers to the last complete sumti appearing before the **ri**.
      - examples:
        - 1:
          - lojban: la .alis. sipna ne'i le ri kumfa
          - translation: Alice sleeps in her room.
- ra:
  - definitions:
    - 1:
      - type: anaphoric pro-sumti
      - definition: This pro-sumti repeats a previously used sumti but is more vague than **ri**, requiring the listener to infer the referent from context. It cannot refer to the last complete sumti if **ri** is already used.
- ru:
  - definitions:
    - 1:
      - type: anaphoric pro-sumti
      - definition: Similar to **ra**, this pro-sumti repeats a previously used sumti but with even greater vagueness, referring to a sumti further back in the discourse than **ra**.
- zo'e:
  - definitions:
    - 1:
      - type: indefinite pro-sumti
      - definition: This pro-sumti represents an unspecified value that would make the bridi true.
      - examples:
        - 1:
          - lojban: mi tavla zo'e do
          - translation: I talk to someone about you.
- zu'i:
  - definitions:
    - 1:
      - type: indefinite pro-sumti
      - definition: This pro-sumti represents the typical value for a given place in the bridi, based on the listener's understanding of the context.
      - examples:
        - 1:
          - lojban: mi klama le bartu be le zdani le nenri be le zdani zu'i zu'i
          - translation: I go to the outside of the house from the inside of the house by the typical route and by typical means.
- zi'o:
  - definitions:
    - 1:
      - type: indefinite pro-sumti
      - definition: This pro-sumti represents a nonexistent value, indicating the specific place in the selbri is irrelevant to the relationship being expressed.
      - examples:
        - 1:
          - lojban: loi jmive cu se zbasu zi'o loi selci
          - translation: Living things are made from cells.
- vo'a:
  - definitions:
    - 1:
      - type: reflexive pro-sumti
      - definition: This pro-sumti refers to the sumti occupying the x1 place of the same bridi.
      - examples:
        - 1:
          - lojban: mi lumci vo'a
          - translation: I wash myself.
- vo'e:
  - definitions:
    - 1:
      - type: reflexive pro-sumti
      - definition: This pro-sumti refers to the sumti occupying the x2 place of the same bridi.
      - examples:
        - 1:
          - lojban: mi klama le zarci vo'e
          - translation: I go to the store from itself. [By some route unspecified.]
- vo'i:
  - definitions:
    - 1:
      - type: reflexive pro-sumti
      - definition: This pro-sumti functions similarly to **vo'a** and **vo'e** but refers to the sumti occupying the x3 place of the same bridi.
- vo'o:
  - definitions:
    - 1:
      - type: reflexive pro-sumti
      - definition: This pro-sumti functions similarly to **vo'a** and **vo'e** but refers to the sumti occupying the x4 place of the same bridi.
- vo'u:
  - definitions:
    - 1:
      - type: reflexive pro-sumti
      - definition: This pro-sumti functions similarly to **vo'a** and **vo'e** but refers to the sumti occupying the x5 place of the same bridi.
- da:
  - definitions:
    - 1:
      - type: bound variable pro-sumti
      - definition: This pro-sumti acts as a variable within a prenex, typically bound by a quantifier like **ro** (all) or **su'o** (at least one).
      - examples:
        - 1:
          - lojban: ro da zo'u da viska mi
          - gloss: For every X : X sees me.
          - translation: Everything sees me.
- de:
  - definitions:
    - 1:
      - type: bound variable pro-sumti
      - definition: This pro-sumti function similarly to **da** but is used for the second bound variable in a prenex.
- di:
  - definitions:
    - 1:
      - type: bound variable pro-sumti
      - definition: This pro-sumti function similarly to **da** but is used for the third bound variable in a prenex.
- ke'a:
  - definitions:
    - 1:
      - type: pro-sumti
      - definition: This pro-sumti is used within relative clauses to refer to the sumti to which the clause is attached (the "relativized sumti").
      - examples:
        - 1:
          - lojban: mi viska le mlatu ku poi zo'e zbasu ke'a loi slasi
          - translation: I see the cat made of plastic.
- ma:
  - definitions:
    - 1:
      - type: pro-sumti
      - definition: This pro-sumti is used to form sumti questions, asking for a sumti to fill the place where **ma** appears.
      - examples:
        - 1:
          - lojban: do klama ma
          - translation: Where are you going?
- ce'u:
  - definitions:
    - 1:
      - type: pro-sumti
      - definition: This pro-sumti is used within abstraction bridi, particularly with **ka** (property) abstractions, to indicate the sumti whose property is being abstracted.
      - examples:
        - 1:
          - lojban: le ka ce'u gleki
          - translation: The property of being happy

## NU

### Constructs

- nu:
  - definitions:
    - 1:
      - type: abstractor
      - place structure: x1 is an event of (the bridi)
      - definition: This abstractor forms an event abstraction. It refers to the entire event or state described by the bridi, encapsulating all its aspects and participants as a single entity.
      - examples:
        - 1:
          - lojban: le nu mi vasxu
          - translation: the event-of my breathing
          - comment: This describes the ongoing act of the speaker breathing, encompassing every instance of inhalation and exhalation throughout their life.
- ka:
  - definitions:
    - 1:
      - type: abstractor
      - place structure: x1 is a property of (the bridi)
      - definition: This abstractor forms a property abstraction. It refers to a property or quality possessed by one or more of the sumti (arguments) within the bridi. The specific sumti whose property is being referenced is indicated by the pro-sumti **ce'u** within the abstraction.
      - examples:
        - 1:
          - lojban: le ka xunre [kei]
          - translation: the property-of being-red
          - comment: This refers to the abstract property of redness, independent of any specific object possessing that property.
- ni:
  - definitions:
    - 1:
      - type: abstractor
      - place structure: x1 is the amount of (the bridi) on scale x2
      - definition: This abstractor forms an amount abstraction. It refers to the measurable quantity or degree to which the bridi holds true. It requires a second place to specify the scale or dimension on which the amount is measured.
      - examples:
        - 1:
          - lojban: le ni le pixra cu blanu [kei]
          - translation: the amount-of (the picture being-blue )
          - comment: This refers to the quantifiable amount of blueness present in the picture, presumably measurable with a tool like a colorimeter.
- jei:
  - definitions:
    - 1:
      - type: abstractor
      - place structure: x1 is the truth value of (the bridi) under epistemology x2
      - definition: This abstractor forms a truth-value abstraction. It expresses the degree of truth of the bridi under a specific epistemological framework. The resulting value is a number between 0 (false) and 1 (true), enabling representations of fuzzy logic.
      - examples:
        - 1:
          - lojban: le jei li re su'i re du li vo [kei]
          - translation: the truth-value-of the-number 2 + 2 – the-number 4) – This refers to the truth value of the statement "2 + 2 – 4", which would be 1 (true) under standard arithmetic.
- li'i:
- si'o:
  - definitions:
    - 1:
      - type: abstractor
      - place structure: x1 is the idea/concept of (the bridi) in the mind of x2
      - definition: This abstractor forms a concept abstraction. It refers to a mental image, idea, or concept held in someone's mind, corresponding to the event or state described by the bridi. It requires a second place to specify the mind in which the concept resides.
      - examples:
        - 1:
          - lojban: mi nelci le si'o la .lojban. cu mulno
          - translation: I enjoy the concept-of that-named Lojban being-complete
          - comment: This expresses the speaker's enjoyment of the idea of Lojban being complete, referring to a mental image or understanding of a finished and fully developed Lojban language.
- du'u:
  - definitions:
    - 1:
      - type: abstractor
      - place structure: x1 is the predication (the bridi), expressed in sentence x2
      - definition: This abstractor forms a predication abstraction. It refers to the predication or statement itself, as expressed in a particular sentence. It is often used with selbri expressing propositional attitudes like "knowing" or "believing".
      - examples:
        - 1:
          - lojban: mi djuno le du'u la .frank. cu bebna [kei]
          - translation: I know the predication that Frank is a fool
          - comment: This signifies that the speaker knows the truth of the statement "Frank is a fool".

## LE

### Constructs

- le:
  - definitions:
    - 1:
      - type: descriptor
      - implicit quantifiers:
        - outer:
          - ro:
            - translation: all
            - comment: indicating the speaker refers to all of the things they have in mind that fit the description.
        - inner:
          - su'o:
            - translation: at least one
            - comment: implying the speaker has at least one specific thing in mind that they are describing as X.
      - definition: The sumti "le X" refers to one or more specific things that the speaker has in mind and chooses to describe as X (where X is a selbri), regardless of the actual truth of that description.
      - examples:
        - 1:
          - lojban: le zarci
          - translation: the market. The speaker has one or more specific markets in mind.
        - 2:
          - lojban: le mlatu cu gerku
          - translation: The cat is a dog. The speaker describes someone they thought was a cat as actually being a dog.
- lo:
  - definitions:
    - 1:
      - type: descriptor
      - implicit quantifiers:
        - outer:
          - su'o:
            - translation: at least one
            - comment: implying there exists at least one thing that truly is X.
        - inner:
          - ro:
            - translation: all
            - comment: referring to all the things that truly are X.
      - definition: The sumti "lo X" refers to one or more of all the things that truly are X (where X is a selbri). It asserts the existence of things that actually fit the description. Equivalent to bare selbri without a gadri
      - examples:
        - 1:
          - lojban: lo zarci
          - translation: a market
          - comment: The speaker refers to one or more markets that actually exist.
        - 2:
          - lojban: lo mlatu cu gerku
          - equivalents:
            - su'o da mlatu gi'e gerku
            - su'o da poi mlatu cu gerku
          - translation: That which really is a cat is a dog
          - comment: This sentence is false because nothing can be both a cat and a dog.
- lo'e:
  - definitions:
    - 1:
      - type: descriptor
      - implicit quantifiers:
        - outer:
          - su'o:
            - translation: at least one
            - comment: implying there exists at least one typical instance.
        - inner:
          - ro:
            - translation: all
            - comment: encompassing all the characteristics of a typical instance.
      - definition: The sumti "lo'e X" refers to the typical instance of X, an abstract or imaginary entity that best exemplifies the characteristics of the set of all things that are truly X.
      - examples:
        - 1:
          - lojban: lo'e cinfo cu xabju le fi'ortu'a
          - translation: The typical lion dwells in the African land.
          - comment: Refers to the concept of a typical lion with characteristics like living in Africa.
- lei:
  - definitions:
    - 1:
      - type: descriptor
      - implicit quantifiers:
        - outer:
          - pisu'o:
            - translation: some part of
            - comment: indicating the speaker refers to some part of the mass.
        - inner:
          - su'o:
            - translation: at least one
            - comment: implying the speaker has at least one specific thing in mind that they are describing as X to form the mass.
      - definition: The sumti "lei X" refers to a mass entity formed from one or more specific things that the speaker has in mind and describes as X, regardless of the actual truth of that description.
      - examples:
        - 1:
          - lojban: lei prenu cu bevri le pipno
          - translation: The mass-of persons carry the piano.
          - comment: Refers to a group of people acting together to carry the piano.
- loi:
  - definitions:
    - 1:
      - type: descriptor
      - implicit quantifiers:
        - outer:
          - pisu'o:
            - translation: some part of
            - comment: indicating reference to some portion of the mass.
        - inner:
          - ro:
            - translation: all
            - comment: encompassing all the things that truly are X to form the mass.
      - definition: The sumti "loi X" refers to some part of the mass entity formed from all the things that truly are X.
      - examples:
        - 1:
          - lojban: loi cinfo cu xabju le fi'ortu'a
          - translation: Part of the mass of lions dwell in the African land.
          - comment: Refers to some lions (not necessarily all) that live in Africa.
- le'i:
  - definitions:
    - 1:
      - type: descriptor
      - implicit quantifiers:
        - outer:
          - piro:
            - translation: the whole of
            - comment: referring to the entire set.
        - inner:
          - su'o:
            - translation: at least one
            - comment: implying the speaker has at least one specific thing in mind that they are describing as X to form the set.
      - definition: The sumti "le'i X" refers to the set of all things that the speaker has in mind and describes as X, regardless of the actual truth of that description, treated as a set with its own properties.
      - examples:
        - 1:
          - lojban: lo'i ratcu cu barda
          - translation: The set of rats is large
          - comment: refers to the set of all rats as having a large number of members.
- le'e:
  - definitions:
    - 1:
      - type: descriptor
      - implicit quantifiers:
        - outer:
          - ro:
            - translation: all
            - comment: encompassing all the characteristics of the stereotypical instance.
        - inner:
          - su'o:
            - translation: at least one
            - comment: implying the speaker has at least one specific thing in mind that they are describing as X to form the stereotype.
      - definition: The sumti "le'e X" refers to the stereotypical instance of X, an abstract or imaginary entity that best exemplifies the characteristics of the set of those things that the speaker has in mind and describes as X.
      - examples:
        - 1:
          - lojban: le'e skina cu se finti ne'i la .xali,uyd.
          - The-stereotypical movie is-invented in that-named Hollywood.:
          - translation: The stereotypical movie is made in Hollywood.
          - comment: This statement is probably true to an American, but might be false (not the stereotype) to someone living in Antarctica.

## BAI

### Constructs

- se ba'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: se basti
      - definition: [sumti] ne se ba'i [sumti] = [sumti] instead of [sumti]. Indicates substitution or replacement.
      - examples:
        - 1:
          - lojban: mi klama le zarci ne se ba'i le zdani
          - translation: I go to the store instead of going home.
- bai:
  - definitions:
    - 1:
      - type: modal tag
      - source: bapli
      - definition: [bridi] happens due to the compelling force of [sumti] (the source of compulsion).
      - examples:
        - 1:
          - lojban: bai tu'a le pulji la .djan. stali
          - translation: Because the police compel him, John stays.
- bau:
  - definitions:
    - 1:
      - type: modal tag
      - source: bangu
      - definition: the concept [bridi] is defined in the language/by means of the language [sumti].
      - examples:
        - 1:
          - lojban: le ve ciksi be bau le drata cu nandu
          - translation: The explanation the other language is hard.
- be'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: benji
      - definition: [sumti] is sent/transmitted by sender [sumti].
      - examples:
        - 1:
          - lojban: le cukta ne be'i la .meiris.
          - translation: The book that is sent by Mary.
- ca'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: catni
      - definition: By the authority of [sumti] the event of [bridi] happens.
      - examples:
        - 1:
          - lojban: ca'i la .djan. mi klama le zarci
          - translation: By John's authority, I go to the store.
- se cau:
  - definitions:
    - 1:
      - type: modal tag
      - source: se claxu
      - definition: Lacking/without property [sumti], the event of [bridi] happens.
      - examples:
        - 1:
          - lojban: mi ciska se cau lo ka pilno lo penbi
          - translation: I write without a pen.
- ci'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: ciste
      - definition: [sumti] ne ci'e [sumti] = rules [sumti] are in the system/context of [sumti]
      - examples:
        - 1:
          - lojban: le flalu ne ci'e le gugde cu pluja
          - translation: The law in the system of the country is complex.
- se ci'o:
  - definitions:
    - 1:
      - type: modal tag
      - source: cinmo
      - definition: [sumti] ne se ci'o [sumti] = [sumti] feels emotion described as property [sumti]
      - examples:
        - 1:
          - lojban: mi ne se ci'o lo ka gleki cu viska do
          - translation: Feeling happy, I see you.
- ci'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: ckilu
      - definition: [bridi] is measured on the scale identified by property [sumti]
      - examples:
        - 1:
          - lojban: ci'u lo ka blabi kei ti xekri
          - translation: On the scale of white, this is black.
- cu'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: cusku
      - definition: [sumti] ne cu'u [sumti] = [sumti] is expressed/said by [sumti]
      - examples:
        - 1:
          - lojban: lu coi li'u ne cu'u la .djan. jufra le nu rinsa le fange prenu
          - translation: "Hello", said by John, is a sentence about greeting the alien person.
- de'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: detri
      - definition: the event of [bridi] is dated by number [sumti]. If one number is used it is assumed to be the day of a month
      - examples:
        - 1:
          - lojban: de'i li 2023 pi'e 10 pi'e 27 le dunju co'a se zbasu
          - translation: Dated October 27, 2023, the construction of the building began.
        - 2:
          - lojban: de'i li 3 mi co'a litru
          - translation: I started my trip on the third day of the month.
- se di'o:
  - definitions:
    - 1:
      - type: modal tag
      - source: se diklo
      - definition: [sumti] pe se di'o [sumti] = [sumti] that is at the location/locus [sumti]
      - examples:
        - 1:
          - lojban: lo'e bakni pe se di'o le nurma cu barda
          - translation: Typical cows in the rural area are big.
- do'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: co'e
      - definition: X is vaguely/generally related to Y (where X and Y are sumti).
      - examples:
        - 1:
          - lojban: le nanmu be do'e le tcadu cu klama le zdani
          - translation: The man of the city came home.
- du'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: dunli
      - definition: [sumti] ne du'i [sumti] = [sumti] as much as/equally to [sumti] (where [bridi] is the standard of comparison).
      - examples:
        - 1:
          - lojban: xu do ne du'i mi zukcfu
          - translation: Are you as busy as I am?
- du'o:
  - definitions:
    - 1:
      - type: modal tag
      - source: djuno
      - definition: [bridi] is true according to the knowledge of [sumti].
      - examples:
        - 1:
          - lojban: du'o mi ti lojbo
          - translation: According to my knowledge, this is Lojbanic.
- fau:
  - definitions:
    - 1:
      - type: modal tag
      - source: fasnu
      - definition: In the event/case of [sumti], the event of [bridi] happens.
      - examples:
        - 1:
          - lojban: fau le nu carvi kei mi na klama le zarci
          - translation: In the case of rain, I don't go to the store.
- fi'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: finti
      - definition: [sumti] ne [sumti] = [sumti] created/invented by [sumti].
      - examples:
        - 1:
          - lojban: le zdani ne fi'e la .djan.
          - translation: The house, which is built by John.
- ga'a:
  - definitions:
    - 1:
      - type: modal tag
      - source: zgana
      - definition: As observed/seen by [sumti], the event of [bridi] happens
      - examples:
        - 1:
          - lojban: ga'a mi le zdani cu xekri
          - translation: As seen by me, the house is black.
- gau:
  - definitions:
    - 1:
      - type: modal tag
      - source: gasnu
      - definition: With [sumti] as the agent/actor, the event of [bridi] happens.
      - examples:
        - 1:
          - lojban: gau la .djan. le canko cu kalri
          - translation: The window is opened by John.
- ja'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: jalge
      - definition: As a result/consequence of [sumti], the event of [bridi] happens.
      - examples:
        - 1:
          - lojban: ja'e le nu carvi kei mi na ku klama le zarci
          - translation: As a result of the rain, I don't go to the store.
- ja'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: javni
      - definition: According to the rule/law [sumti], the event of [bridi] happens.
      - examples:
        - 1:
          - lojban: ja'i le flalu do na klama le zdani
          - translation: According to the law, you may not enter the house.
- ji'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: jimte
      - definition: [sumti] ne ji'e [sumti] = [sumti] limited by [sumti] is described in [bridi].
      - examples:
        - 1:
          - lojban: le zbani ne ji'e le xamsi cu ganra
          - translation: The shore limited by the sea is wide.
- ji'o:
  - definitions:
    - 1:
      - type: modal tag
      - source: jitro
      - definition: [sumti] ne ji'o [sumti] = [sumti] under the direction/control of [sumti] does what [bridi] described.
      - examples:
        - 1:
          - lojban: le gerku ne ji'o la .djan. cu klama
          - translation: Under John's control, the dog comes.
- ji'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: jicmu
      - definition: Based on the assumption/support of X, Y (where X is the assumption and Y is the thing based on it).
      - examples:
        - 1:
          - lojban: lo'e dacti cu muvdu ji'u le za'u javni be fi le daiske
          - translation: Typical objects move governed by the laws of physics.
- kai:
  - definitions:
    - 1:
      - type: modal tag
      - source: ckaji
      - definition: [sumti] pe kai [sumti] = property [sumti] that [sumti] manifests.
      - examples:
        - 1:
          - lojban: lo ka xunre kei pe kai le makcu tamca cu se simlu so'i le plise
          - translation: Red color as in this ripe tomato is what many of the apples seem to have.
- se ka'a:
  - definitions:
    - 1:
      - type: modal tag
      - source: klama
      - definition: [sumti] ne se ka'a [sumti] = [sumti] coming to [sumti] does what [bridi] describes.
      - examples:
        - 1:
          - lojban: mi ne se ka'a le zdani cu bajra
          - translation: I run home.
- se ka'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: se krati
      - definition: [sumti] ne se ka'i [sumti] = [sumti] representing/on behalf of [sumti] does what [bridi] describes.
      - examples:
        - 1:
          - lojban: mi ne se ka'i la .djan. cu cusku lu co'o li'u
          - translation: On behalf of John, I say "goodbye".
- ki'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: ckini
      - definition: [sumti] ne ki'i [sumti] = [sumti] that is specifically associated with [sumti].
      - examples:
        - 1:
          - lojban: ti'e le sance ne ki'i le barda mabru cu tsali
          - translation: They say, the sound from the big mammal is pretty strong.
- ki'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: krinu
      - definition: With the justification/reason of [sumti], [bridi] happens.
      - examples:
        - 1:
          - lojban: ki'u le nu mi tatpi kei mi na ku klama le zarci
          - translation: With the reason that I am tired, I don't go to the store.
- koi:
  - definitions:
    - 1:
      - type: modal tag
      - source: korbi
      - definition: [bridi] is bounded by/has the border [sumti].
      - examples:
        - 1:
          - lojban: le verba pu kelci koi le bitmu
          - translation: The child played bounded by the fence.
- ku'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: kulnu
      - definition: In the culture/society of X, Y (where X is the culture and Y is the thing related to it).
      - examples:
        - 1:
          - lojban: ku'u le merko lo'e prenu cu tavla fo le glibau
          - translation: In American culture, people speak English.
- la'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: klani
      - definition: With the quantity/amount of X, Y (where X is the quantity and Y is the thing quantified).
      - examples:
        - 1:
          - lojban: la .frank. cu sanli zu'a nu'i la .djordj. la'u lo mitre be li mu
          - translation: Frank is standing five meters to the left of George.
- le'a:
  - definitions:
    - 1:
      - type: modal tag
      - source: klesi
      - definition: [sumti] ne le'a [sumti] = [sumti] that is in category/cetegorized by [sumti].
      - examples:
        - 1:
          - lojban: le'i spati ne le'a lo'i se pezli lo crino cu ckaji lo ka lu'a ce'u vasru so'i tirse
          - translation: The set of plants that are in category of leafy plants are such that each member of the set has lots of iron.
- li'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: lidne
      - definition: [sumti] pe li'e [sumti] = [sumti] that is followed by [sumti] in sequence.
      - examples:
        - 1:
          - lojban: ro lojbo ba'urvlasle pe li'e pa karsnasni cu sunsnasni
          - translation: Every Lojban phoneme followed by a vowel is a consonant.
- se ma'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: se marji
      - definition: [sumti] ne se ma'e [sumti] = [sumti] made of/composed of material [sumti].
      - examples:
        - 1:
          - lojban: le mudri ne se ma'e le dinju cu denmi
          - translation: The wood of the building is dense.
- ma'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: manri
      - definition: [bridi] happens in the reference frame [sumti].
      - examples:
        - 1:
          - lojban: ma'i le junla li ze tcika
          - translation: According to the clock, it's 7 o'clock.
- se mau:
  - definitions:
    - 1:
      - type: modal tag
      - source: se zmadu
      - definition: [sumti] ne se mau [sumti] = [sumti] exceeds [sumti] in what [bridi] describes.
      - examples:
        - 1:
          - lojban: mi se mau la .djan. cu prami la .alis.
          - translation: I love Alice more than John does.
- se me'a:
  - definitions:
    - 1:
      - type: modal tag
      - source: se mleca
      - definition: [sumti] ne se me'a [sumti] = [sumti] is less than [sumti] in what [bridi] describes.
      - examples:
        - 1:
          - lojban: lei ckafi ne se me'a lei tcati cu glare
          - translation: The coffee is less hot than the tea.
- me'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: cmene
      - definition: [sumti] ne me'e [sumti] = [sumti] named as [sumti] (quotation)
      - examples:
        - 1:
          - lojban: le verba ne me'e zo .alis. cu vi zutse
          - translation: The child named "Alice" sits nearby.
- mu'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: mukti
      - definition: Motivated by/having the motive of [sumti] the event of [bridi] happens
      - examples:
        - 1:
          - lojban: mi di'i tadni mu'i lo nu mi djica lo nu mi certu
          - translation: I study regularly motivated by my desire to be an expert.
- mu'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: mupli
      - definition: [sumti] ne mu'u [sumti] = property [sumti] exemplified by [sumti].
      - examples:
        - 1:
          - lojban: lo ka carmi gunka kei ne mu'u le bersa be mi cu se banli so'i le diklo xabju
          - translation: Hard work as shown by my son is what many of the local inhabitants are great in.
- ni'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: nibli
      - definition: [bridi] happens logically entailed by/because of event [sumti].
      - examples:
        - 1:
          - lojban: ni'i le nu do remna kei do ka'e jbena
          - translation: Because you are a human, you can be born.
- pa'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: pagbu
      - definition: [sumti] ne pa'u [sumti] = [sumti], of which [sumti] is a part.
      - examples:
        - 1:
          - lojban: le skami ne pa'u le vidni cu spofu
          - translation: The computer, of which the mointor is a part, is broken.
- se pi'o:
  - definitions:
    - 1:
      - type: modal tag
      - source: se pilno
      - definition: [sumti] ne se pi'o [sumti] = [sumti] makes the event of the bridi happen by using the tool [sumti].
      - examples:
        - 1:
          - lojban: mi ne se pi'o le forca cu citka
          - translation: I eat by using a fork.
- se po'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: se porsi
      - definition: [sumti] ne se po'i [sumti] = the sequence [sumti], which is formed by rules [sumti].
      - examples:
        - 1:
          - lojban: la .alis. ce'o la .bob. ce'o la .cen. vu'o ne le ka ce'u dzena ce'u cu te bridi lo ka sinma
          - translation: The sequence of Alice, Bob, and Sher, ordered from ancestors to descendants, is such that each person respects the next one in the sequence.
- pu'a:
  - definitions:
    - 1:
      - type: modal tag
      - source: pluka
      - definition: [sumti] ne pu'a [sumti] = [sumti], which is pleasant to [sumti].
      - examples:
        - 1:
          - lojban: le pu'a mi sance be le nu le verba cu cmila cu se minra pa'o le panka
          - translation: The sound of a child's laughter, which is pleasant to me, is echoing through the park.
- se pu'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: se pruce
      - definition: [sumti] ne se pu'e [sumti] = the process [sumti] with inputs [sumti].
      - examples:
        - 1:
          - lojban: le te jukpa ne se pu'e lo sunga cu nandu
          - translation: The process of cooking with garlic as input is hard.
- se ra'a:
  - definitions:
    - 1:
      - type: modal tag
      - source: se srana
      - definition: pertaining to/concerning [sumti].
      - examples:
        - 1:
          - lojban: se ra'a le spofu patxu pu snuti pe'i
          - translation: Concerning the broken pot, I think it was an accident.
- ra'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: krasi
      - definition: from the source/origin of/originating from [sumti].
      - examples:
        - 1:
          - lojban: mi pu ganse le pluka panci pe ra'i le purdi
          - translation: I felt a pleasant smell originating from the garden.
- rai:
  - definitions:
    - 1:
      - type: modal tag
      - source: traji
      - definition: [sumti] ne rai [sumti] = [sumti], of which [sumti] is superlative in that [bridi] describes..
      - examples:
        - 1:
          - lojban: mi nelci le'e jbari ne rai lo'e fragari
          - translation: I like berries with strawberries being my favorite ones.
- ri'a:
  - definitions:
    - 1:
      - type: modal tag
      - source: rinka
      - definition: Caused by/with the physical cause of X, Y (where X is the cause and Y is the effect).
      - examples:
        - 1:
          - lojban: ri'a le nu carvi kei mi na ku klama le zarci
          - translation: Because of the rain, I don't go to the store.
- ri'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: lifri
      - definition: Experienced by [sumti], the event of [bridi] happens.
      - examples:
        - 1:
          - lojban: ri'i la tom da sance lo darno lindi ca le nu le tcima cu zenba lo ka vlile
          - translation: As experienced by Tom, there was a sound of distant thunder as the weather grew stormy.
- sau:
  - definitions:
    - 1:
      - type: modal tag
      - source: sarcu
      - definition: with event [sumti] being necessary, the event of [bridi] happens.
      - examples:
        - 1:
          - lojban: sau lo nu carvi kei le spati cu banro
          - translation: With rain being necessary, the plant grows.
        - 2:
          - lojban: sau lo nu troci kei da snada
          - translation: With effort being necessary, one succeeds.
- si'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: sidju
      - definition: [sumti] ne si'u [sumti] = [sumti] with the help of [sumti] does whatever [bridi] describes.
      - examples:
        - 1:
          - lojban: mi ne si'u la .djan. cu klama le zarci
          - translation: With John's help, I go to the store.
- ta'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: tadji
      - definition: the event of [bridi] happens by the method/technique of [sumti].
      - examples:
        - 1:
          - lojban: ta'i lo nu loi djacu gau di'i carvi le spati kei ri banro
          - translation: By watering the plant regularly, its growth occurs.
        - 2:
          - lojban: ta'i da do pu pu'i limna pa'o le mi'u rirxe
          - translation: Somehow, you were able to swim across the river.
- tai:
  - definitions:
    - 1:
      - type: modal tag
      - source: tamsmi
      - definition: the event of [bridi] is similar to [sumti]; the event of [bridi] is like [sumti]; the event of [bridi] happens in manner [sumti]
      - examples:
        - 1:
          - lojban: i le murta taxfu cu kluza tai lo nu cerni bumru
          - translation: The veil was mottled like river morning mist 
- ti'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: stidi
      - definition: the event of [bridi] is suggested by [sumti].
      - examples:
        - 1:
          - lojban: ti'i la .alis. ra pu klama le zarci
          - translation: As suggested by Alice he went to the store.
- ti'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: tcika
      - definition: [bridi] happens at the time/during the time with timestamp [sumti].
      - examples:
        - 1:
          - lojban: ti'u li xa mi klama le zdani
          - translation: I go home at 6 o'clock.
- tu'i:
  - definitions:
    - 1:
      - type: modal tag
      - source: stuzi
      - definition: At the location/site of X, Y (where X is the location and Y is the thing located there).
      - examples:
        - 1:
          - lojban: le zarci ne tu'i le ralj klaji na smaji
          - translation: The shop located at Main street is not quiet.
- va'o:
  - definitions:
    - 1:
      - type: modal tag
      - source: vanbi
      - definition: [bridi] happens under the conditions/circumstances [sumti].
      - examples:
        - 1:
          - lojban: .e'o va'o lo nu do ganse lo se srera kei do cikre
          - translation: If you see a mistake, then please correct it.
- se va'u:
  - definitions:
    - 1:
      - type: modal tag
      - source: se xamgu
      - definition: [bridi] happens for the benefit of [sumti].
      - examples:
        - 1:
          - lojban: do .e'o cikre le karce se va'u le lanzu
          - translation: lease, fix the car for the benefit of the family.
- zau:
  - definitions:
    - 1:
      - type: modal tag
      - source: zanru
      - definition: the event of [bridi] happens with the approval of [sumti].
      - examples:
        - 1:
          - lojban: zau la .djan. mi klama le zarci
          - translation: With John's approval, I go to the store.
- te zu'e:
  - definitions:
    - 1:
      - type: modal tag
      - source: te zukte
      - definition: [bridi] happens with the goal/purpose/intention [sumti].
      - examples:
        - 1:
          - lojban: mi citka tezu'e lo nu mi jmive
          - translation: I eat so I may live.

## NAI

### Constructs

- nai:
  - definitions:
    - 1:
      - type: scalar modifier
      - definition: Negates the preceding indicator or grammatical construct, creating the opposite meaning on the scale. This applies to indicators and attitudinals (UI or CAI). For example, **.uinai** expresses unhappiness, and **.ienai** expresses disagreement, not ambivalence.
      - examples:
        - 1:
          - lojban: .uinai
          - translation: (interjection of unhappiness)
    - 2:
      - type: scalar modifier
      - definition: In vocatives of selma'o COI, **nai** negates the word, creating the opposite communication intent, such as a negative acknowledgment.
      - example: **je'enai** means "I didn't get that."
    - 3:
      - type: scalar modifier
      - definition: When attached to tenses or modals, **nai** indicates a contradictory negation, meaning the action or state described is false. 
      - examples:
        - 1:
          - lojban: mi punai klama le zarci
          - translation: I didn't go to the market.
    - 4:
      - type: scalar modifier
      - definition: when attached to logical connectives, **nai** negates a part of the connective or one of the connected bridi or sumti.
      - example: **ge la .djan. nanmu ginai la .djeimyz. ninmu** means "John is a man and James is not a woman."
    - 5:
      - type: scalar modifier
      - definition: In non-logical connectives (like JOI or BIhI), **nai** signals scalar negation, indicating the bridi is false under the given connection but could be true under a different one.
      - example: **mi paroinai dansu le bisli** means "I danced on the ice either zero or two or more times."

- cu'i:
  - definitions:
    - type: scalar modifier
    - 1:
      - definition: indicates a middle position on the scale. For example, .uicui expresses neither happiness nor unhappiness.

## UI

### Constructs

- re'e:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Spiritual - Indicates that the preceding attitudinal is focused towards the spiritual / religious / numinous / supernatural.
      - examples:
        - 1:
          - lojban: ki'e lojbot do pairnu'i io re'e
          - gloss: Thanks Lojbot you fair-judge [respect] [spiritually]
          - translation: Thank you, Lojbot. You are fair and just (in a spiritual sense).
        - 2:
          - lojban: .ua re'e
          - gloss: [Discovery] spiritual
          - translation: I feel a spiritual sense of discovery.
- re'e cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Secular - Indicates that the preceding attitudinal is not focused towards the spiritual / religious / numinous / supernatural, and is therefore secular in nature.
      - examples:
        - 1:
          - lojban: .uisai re'ecu'i lo bavlamdei ku detri lo xisyjbenunsla
          - gloss: [Happy] [secular] the tomorrow is-date-of the Christian-birth-celebration
          - translation: Hooray! Tomorrow is Christmas! (secular celebration)
        - 2:
          - lojban: .uu re'ecu'i
          - gloss: [Pity] secular
          - translation: I feel pity, but without any spiritual context.
- re'e nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Sacrilegious - Indicates that the preceding attitudinal is focused away from the spiritual / religious / numinous / supernatural, into active sacrilege.
      - examples:
        - 1:
          - lojban: no cevni cu zasti re'enai
          - gloss: No god exists [sacrilegeously]
          - translation: There is no god. (said sacrilegiously)

- ro'a:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Social - Indicates that the preceding attitudinal is focused towards the speaker's interaction with society.
      - examples:
        - 1:
          - lojban: .oi ro'a ba'e ca ku mi se cfipu po'o
          - gloss: [Pain] [social] [emphasize] now I am-confused only
          - translation: Awkward. Now I'm just confused! (in a social context)
        - 2:
          - lojban: .ui ro'a
          - gloss: [Happiness] social
          - translation: I feel socially happy.
        - 3:
          - lojban: .o'unai ro'a
          - gloss: [Anxiety] social
          - translation: I feel social anxiety, possibly distress in a group setting.
- ro'a cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Asocial - Indicates that the preceding attitudinal is not focused towards the speaker's interaction with society.
      - examples:
        - 1:
          - lojban: .ui ro'a cu'i mi cikre le mi skami
          - gloss: [Happy] [asocial] I repair the my computer
          - translation: I'm just puttering here by myself, fixing my computer.

- ro'a nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Antisocial - Indicates that the preceding attitudinal is focused away from the speaker's interaction with society, towards the speaker's isolation from society.
      - examples:
        - 1:
          - lojban: .ui nai ro'a nai mi mo'u zbasu le mi selkei no'u la .gandam.
          - gloss: [Unhappy] [antisocial] I complete build the my model namely Gundam
          - translation: I finished building my Gundam model. I feel so lonely.
        - 2:
          - lojban: .uinai ro'anai
          - gloss: [Sadness] antisocial
          - translation: I feel an antisocial sadness, pushing away social interactions.
        - 3:
          - lojban: .ei ro'anai
          - gloss: [Obligation] antisocial
          - translation: I feel obligated, but in a manner that disregards social expectations.
- ro'e:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Mental - Indicates that the preceding attitudinal is focused towards the mental / intellectual / thoughtful / contemplative.
      - examples:
        - 1:
          - lojban: .oi ro'e mu'i ma pau nai lo nu tavla cusku zo galxe cu mutce nandu fi lo nu galxe bilma
          - gloss: [Pain] [mental] motivation what-question [lacking] the event-of talk say word throat is-very difficult for the event-of throat is-ill
          - translation: Stupid brain! Why is saying "galxe" so very difficult with a sore throat?
        - 2:
          - lojban: .ei ro'e
          - gloss: [Obligation] mental
          - translation: I feel a mental obligation to do something.
- ro'e cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-mental - Indicates that the preceding attitudinal is not focused towards the mental / intellectual / thoughtful / contemplative.
      - examples:
        - 1:
          - lojban: .a'i ro'e cu'i mi snada
          - gloss: [Effort] [non-mental] I succeed
          - translation: I did it, through much hard work, though it took but little thought.

- ro'e nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Mindless - Indicates that the preceding attitudinal is focused away from the mental / intellectual / thoughtful / contemplative, and towards mindless action.
      - examples:
        - 1:
          - lojban: le'o ro'e nai catra ko
          - gloss: [Aggressive] [mindless] kill you-imperative
          - translation: Die! (said mindlessly)

- ro'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Emotional - Indicates that the preceding attitudinal is focused towards the speaker's feelings / emotions.
      - examples:
        - 1:
          - lojban: oi cai ro'i mi mutce caucni
          - gloss: [Pain] [intense] [emotional] I very-much cry-intend
          - translation: I am so lonely I think I'm going to cry.
        - 2:
          - lojban: .oi ro'i
          - gloss: [Pain] emotional
          - translation: I feel emotional pain.
- ro'i cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-emotional - Indicates that the preceding attitudinal is not focused towards the speaker's feelings / emotions.
      - examples:
        - 1:
          - lojban: .i xu do kanro vau ro'i cu'i
          - gloss: [Question] you healthy [end] [non-emotional]
          - translation: How do you do. (asked non-emotionally)

- ro'i nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Unemotional - Indicates that the preceding attitudinal is focused away from the speaker's feelings / emotions.
      - examples:
        - 1:
          - lojban: .i mi na jinvi ro'i nai
          - gloss: I not opine [unemotional]
          - translation: I don't care that I don't have an opinion.
        - 2:
          - lojban: .ui ro'inai
          - gloss: [Happiness] denying emotion
          - translation: I express happiness but without emotional involvement.
- ro'o:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Physical - Indicates that the preceding attitudinal is focused towards the physical, which can include the speaker's own body, but also the physical surroundings.
      - examples:
        - 1:
          - lojban: .oi nai ro'o le cidja cu kukte
          - gloss: [Pain] [not] [physical] the food is-delicious
          - translation: Yum, this food is delicious!
        - 2:
          - lojban: .uinai ro'o
          - gloss: [Sadness] physical
          - translation: I feel physical sadness, perhaps manifesting as lethargy.
- ro'o cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-physical - Indicates that the preceding attitudinal is not focused towards the physical, which can include the speaker's own body, but also the physical surroundings.
      - examples:
        - 1:
          - lojban: .ii ro'o cu'i le cidja cu mutce kukte .i ku'i lo nu ri kargu cu terpa mi
          - gloss: [Fear] [non-physical] the food is-very delicious . But the event-of it expensive frightens me
          - translation: Gulp! The food is delicious, but I'm afraid of how expensive it's going to be.

- ro'o nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-physical (focused away from the physical) - Indicates that the preceding attitudinal is focused away from the physical, which can include the speaker's own body, but also the physical surroundings.
      - examples:
        - 1:
          - lojban: ro'o nai dai do ka'e sutra zenba .i ko lo du'u go'i cu jinvi po'o na gi'e ba'e djuno
          - gloss: [Non-physical] [empathy] you can quickly increase . You-imperative the statement-that previous-statement opine only not and [emphasize] know
          - translation: You're faster than this. Don't just think you are, know you are.
        - 2:
          - lojban: .uu ro'onai
          - gloss: [Pity] denying physical
          - translation: I feel pity but without any physical reaction.

- ro'u:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Sexual - Indicates that the preceding attitudinal is focused towards sexuality.
      - examples:
        - 1:
          - lojban: melbi ro'u
          - gloss: Beautiful [sexual]
          - translation: Damn, she's HOT!
        - 2:
          - lojban: .ei ro'u
          - gloss: [Obligation] sexual
          - translation: I feel a sexual obligation.
- ro'u cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Asexual - Indicates that the preceding attitudinal is not focused towards sexuality.
      - examples:
        - 1:
          - lojban: .iu ro'u cu'i
          - gloss: [Love] [asexual]
          - translation: I love you, there's just no spark.

- ro'u nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-sexual - Indicates that the preceding attitudinal is focused away from sexuality.
      - examples:
        - 1:
          - lojban: .iu ro'o nai
          - gloss: [Love] [non-sexual]
          - translation: I love you like a brother.
        - 2:
          - lojban: .au ro'unai
          - gloss: [Desire] abstinence
          - translation: I feel desire, but without sexual involvement.
- bu'o:
  - definitions:
    - 1:
      - type: UI7
      - definition: Start emotion - Used to indicate that the state referred to by the preceding attitudinal is just beginning.
      - examples:
        - 1:
          - lojban: .ui bu'o do tolcliva
          - gloss: [Happy] [start-emotion] you arrive
          - translation: I'm happy now that you've arrived.

- bu'o cu'i:
  - definitions:
    - 1:
      - type: UI*7
      - definition: Continuing emotion - Used to indicate that the state referred to by the preceding attitudinal is ongoing (i.e., not presently beginning or ending).
      - examples:
        - 1:
          - lojban: .ue bu'o cu'i do ji'a xu co'e doi brutus
          - gloss: [Surprise] [continuing-emotion] you also [question] do-ellipsis O Brutus
          - translation: Et tu, Brute?

- bu'o nai:
  - definitions:
    - 1:
      - type: UI*7
      - definition: End emotion - Used to indicate that the state referred to by the preceding attitudinal is now ending.
      - examples:
        - 1:
          - lojban: .iu bu'onai .uinai
          - gloss: [Love] [end-emotion] [unhappy]
          - translation: I don't love you anymore; I'm sad.

- fu'e:
  - definitions:
    - 1:
      - type: FUhE
      - definition: Begin indicator scope - Marks the beginning of an alternate scope that can have attitudinals applied to it.
      - examples:
        - 1:
          - lojban: mi viska le fu'e .ia blanu zdani fu'o ponse
          - gloss: I see the [begin-scope] [belief] blue house [end-scope] owner
          - translation: I see the owner of what I believe to be a blue house.
        - 2:
          - lojban: .i fu'e po'o lo za'i prami .e lo za'i gleki fu'o cu se cinmo lo se gugde be la skatygug
          - gloss: [Begin-scope] only the state-of love and the state-of happy [end-scope] is-felt-by the country-folk of Scatland
          - translation: There is only love and happiness in Scatland.

- fu'o:
  - definitions:
    - 1:
      - type: FUhO
      - definition: End indicator scope - Marks the end of an alternate scope that can have attitudinals applied to it.
      - examples:
        - 1:
          - lojban: mi viska le fu'e .ia blanu zdani fu'o ponse
          - gloss: I see the [begin-scope] [belief] blue house [end-scope] owner
          - translation: I see the owner of what I believe to be a blue house.

- .a'a:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Attentive: Expresses attentiveness, concentration, or paying attention.
      - examples:
        - 1:
          - lojban: .a'a .i ko di'a co'e .i ba ku ma fasnu
          - gloss: [Attentively] . You again do-ellipsis . After that what happens?
          - translation: I'm listening. Go on, what happened next?
        - 2:
          - lojban: .a'a mi tirna lo cnino zgike
          - gloss: [Attentively] I listen-to the new music.
          - translation: I'm paying close attention to the new music.

- re'e:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Spiritual - Indicates that the preceding attitudinal is focused towards the spiritual / religious / numinous / supernatural.
      - examples:
        - 1:
          - lojban: ki'e lojbot do pairnu'i io re'e
          - gloss: Thanks Lojbot you fair-judge [respect] [spiritually]
          - translation: Thank you, Lojbot. You are fair and just (in a spiritual sense).

- re'e cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Secular - Indicates that the preceding attitudinal is not focused towards the spiritual / religious / numinous / supernatural, and is therefore secular in nature.
      - examples:
        - 1:
          - lojban: .uisai re'ecu'i lo bavlamdei ku detri lo xisyjbenunsla
          - gloss: [Happy] [secular] the tomorrow is-date-of the Christian-birth-celebration
          - translation: Hooray! Tomorrow is Christmas! (secular celebration)

- re'e nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Sacrilegious - Indicates that the preceding attitudinal is focused away from the spiritual / religious / numinous / supernatural, into active sacrilege.
      - examples:
        - 1:
          - lojban: no cevni cu zasti re'enai
          - gloss: No god exists [sacrilegeously]
          - translation: There is no god. (said sacrilegiously)

- ro'a:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Social - Indicates that the preceding attitudinal is focused towards the speaker's interaction with society.
      - examples:
        - 1:
          - lojban: .oi ro'a ba'e ca ku mi se cfipu po'o
          - gloss: [Pain] [social] [emphasize] now I am-confused only
          - translation: Awkward. Now I'm just confused! (in a social context)

- ro'a cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Asocial - Indicates that the preceding attitudinal is not focused towards the speaker's interaction with society.
      - examples:
        - 1:
          - lojban: .ui ro'a cu'i mi cikre le mi skami
          - gloss: [Happy] [asocial] I repair the my computer
          - translation: I'm just puttering here by myself, fixing my computer.

- ro'a nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Antisocial - Indicates that the preceding attitudinal is focused away from the speaker's interaction with society, towards the speaker's isolation from society.
      - examples:
        - 1:
          - lojban: .ui nai ro'a nai mi mo'u zbasu le mi selkei no'u la .gandam.
          - gloss: [Unhappy] [antisocial] I complete build the my model namely Gundam
          - translation: I finished building my Gundam model. I feel so lonely.

- ro'e:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Mental - Indicates that the preceding attitudinal is focused towards the mental / intellectual / thoughtful / contemplative.
      - examples:
        - 1:
          - lojban: .oi ro'e mu'i ma pau nai lo nu tavla cusku zo galxe cu mutce nandu fi lo nu galxe bilma
          - gloss: [Pain] [mental] motivation what-question [lacking] the event-of talk say word throat is-very difficult for the event-of throat is-ill
          - translation: Stupid brain! Why is saying "galxe" so very difficult with a sore throat?

- ro'e cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-mental - Indicates that the preceding attitudinal is not focused towards the mental / intellectual / thoughtful / contemplative.
      - examples:
        - 1:
          - lojban: .a'i ro'e cu'i mi snada
          - gloss: [Effort] [non-mental] I succeed
          - translation: I did it, through much hard work, though it took but little thought.

- ro'e nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Mindless - Indicates that the preceding attitudinal is focused away from the mental / intellectual / thoughtful / contemplative, and towards mindless action.
      - examples:
        - 1:
          - lojban: le'o ro'e nai catra ko
          - gloss: [Aggressive] [mindless] kill you-imperative
          - translation: Die! (said mindlessly)

- ro'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Emotional - Indicates that the preceding attitudinal is focused towards the speaker's feelings / emotions.
      - examples:
        - 1:
          - lojban: oi cai ro'i mi mutce caucni
          - gloss: [Pain] [intense] [emotional] I very-much cry-intend
          - translation: I am so lonely I think I'm going to cry.

- ro'i cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-emotional - Indicates that the preceding attitudinal is not focused towards the speaker's feelings / emotions.
      - examples:
        - 1:
          - lojban: .i xu do kanro vau ro'i cu'i
          - gloss: [Question] you healthy [end] [non-emotional]
          - translation: How do you do. (asked non-emotionally)

- ro'i nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Unemotional - Indicates that the preceding attitudinal is focused away from the speaker's feelings / emotions.
      - examples:
        - 1:
          - lojban: .i mi na jinvi ro'i nai
          - gloss: I not opine [unemotional]
          - translation: I don't care that I don't have an opinion.

- ro'o:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Physical - Indicates that the preceding attitudinal is focused towards the physical, which can include the speaker's own body, but also the physical surroundings.
      - examples:
        - 1:
          - lojban: .oi nai ro'o le cidja cu kukte
          - gloss: [Pain] [not] [physical] the food is-delicious
          - translation: Yum, this food is delicious!

- ro'o cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-physical - Indicates that the preceding attitudinal is not focused towards the physical, which can include the speaker's own body, but also the physical surroundings.
      - examples:
        - 1:
          - lojban: .ii ro'o cu'i le cidja cu mutce kukte .i ku'i lo nu ri kargu cu terpa mi
          - gloss: [Fear] [non-physical] the food is-very delicious . But the event-of it expensive frightens me
          - translation: Gulp! The food is delicious, but I'm afraid of how expensive it's going to be.

- ro'o nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-physical (focused away from the physical) - Indicates that the preceding attitudinal is focused away from the physical, which can include the speaker's own body, but also the physical surroundings.
      - examples:
        - 1:
          - lojban: ro'o nai dai do ka'e sutra zenba .i ko lo du'u go'i cu jinvi po'o na gi'e ba'e djuno
          - gloss: [Non-physical] [empathy] you can quickly increase . You-imperative the statement-that previous-statement opine only not and [emphasize] know
          - translation: You're faster than this. Don't just think you are, know you are.

- ro'u:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Sexual - Indicates that the preceding attitudinal is focused towards sexuality.
      - examples:
        - 1:
          - lojban: melbi ro'u
          - gloss: Beautiful [sexual]
          - translation: Damn, she's HOT!

- ro'u cu'i:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Asexual - Indicates that the preceding attitudinal is not focused towards sexuality.
      - examples:
        - 1:
          - lojban: .iu ro'o cu'i
          - gloss: [Love] [asexual]
          - translation: I love you, there's just no spark.

- ro'u nai:
  - definitions:
    - 1:
      - type: emotional category modifier
      - definition: Non-sexual - Indicates that the preceding attitudinal is focused away from sexuality.
      - examples:
        - 1:
          - lojban: .iu ro'o nai
          - gloss: [Love] [non-sexual]
          - translation: I love you like a brother.

- bu'o:
  - definitions:
    - 1:
      - type: UI7
      - definition: Start emotion - Used to indicate that the state referred to by the preceding attitudinal is just beginning.
      - examples:
        - 1:
          - lojban: .ui bu'o do tolcliva
          - gloss: [Happy] [start-emotion] you arrive
          - translation: I'm happy now that you've arrived.

- bu'o cu'i:
  - definitions:
    - 1:
      - type: UI*7
      - definition: Continuing emotion - Used to indicate that the state referred to by the preceding attitudinal is ongoing (i.e., not presently beginning or ending).
      - examples:
        - 1:
          - lojban: .ue bu'o cu'i do ji'a xu co'e doi brutus
          - gloss: [Surprise] [continuing-emotion] you also [question] do-ellipsis O Brutus
          - translation: Et tu, Brute?

- bu'o nai:
  - definitions:
    - 1:
      - type: UI*7
      - definition: End emotion - Used to indicate that the state referred to by the preceding attitudinal is now ending.
      - examples:
        - 1:
          - lojban: .iu bu'onai .uinai
          - gloss: [Love] [end-emotion] [unhappy]
          - translation: I don't love you anymore; I'm sad.

- fu'e:
  - definitions:
    - 1:
      - type: FUhE
      - definition: Begin indicator scope - Marks the beginning of an alternate scope that can have attitudinals applied to it.
      - examples:
        - 1:
          - lojban: mi viska le fu'e .ia blanu zdani fu'o ponse
          - gloss: I see the [begin-scope] [belief] blue house [end-scope] owner
          - translation: I see the owner of what I believe to be a blue house.
        - 2:
          - lojban: .i fu'e po'o lo za'i prami .e lo za'i gleki fu'o cu se cinmo lo se gugde be la skatygug
          - gloss: [Begin-scope] only the state-of love and the state-of happy [end-scope] is-felt-by the country-folk of Scatland
          - translation: There is only love and happiness in Scatland.

- fu'o:
  - definitions:
    - 1:
      - type: FUhO
      - definition: End indicator scope - Marks the end of an alternate scope that can have attitudinals applied to it.
      - examples:
        - 1:
          - lojban: mi viska le fu'e .ia blanu zdani fu'o ponse
          - gloss: I see the [begin-scope] [belief] blue house [end-scope] owner
          - translation: I see the owner of what I believe to be a blue house.
          
- .a'a cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Inattentive: Expresses inattentiveness or distraction.
      - examples:
        - 1:
          - lojban: .a'a cu'i ko denpa lo nu mi mulgau ti
          - gloss: [Inattentively] You wait the event-of I complete this.
          - translation: Eh, just a second, let me finish this.
        - 2:
          - lojban: .a'a cu'i mi na pu tirna
          - gloss: [Inattentively] I didn't past listen.
          - translation: Sorry, I wasn't really paying attention.

- .a'a nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Avoiding: Expresses avoidance or evasion.
      - examples:
        - 1:
          - lojban: .a'a nai mi na tirna
          - gloss: [Avoidingly] I not listen.
          - translation: La la la, I'm not listening.
        - 2:
          - lojban: .a'a nai mi cliva ti
          - gloss: [Avoidingly] I leave here.
          - translation: I'm getting out of here (to avoid something).

- .a'e:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Alertness: Expresses alertness, readiness, or enthusiasm.
      - examples:
        - 1:
          - lojban: .a'e le cabdei ba xamgu djedi
          - gloss: [Alertly] The now-day future good day.
          - translation: Today is going to be a good day!
        - 2:
          - lojban: .a'e mi bredi lo nu ci'erkei
          - gloss: [Alertly] I ready the event-of compete.
          - translation: I'm ready and eager to compete!

- .a'e nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Tired: Expresses exhaustion, fatigue, or weariness.
      - examples:
        - 1:
          - lojban: .a'e nai mi klama lo ckana
          - gloss: [Tiredly] I go-to the bed.
          - translation: Yawn... I'm going to bed.
        - 2:
          - lojban: .a'e nai mi nitcu lo nu sipna
          - gloss: [Tiredly] I need the event-of sleep.
          - translation: I'm exhausted, I need to sleep.

- .a'u:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Interest: Expresses interest or curiosity.
      - examples:
        - 1:
          - lojban: .a'u ma ba'o se lifri do
          - gloss: [Interestedly] What has-been experienced-by you?
          - translation: What happened to you?
        - 2:
          - lojban: .a'u do cusku lo cnino
          - gloss: [Interestedly] You express the new.
          - translation: Tell me more, that's interesting!

- .a'u cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Disinterest: Expresses lack of interest or indifference.
      - examples:
        - 1:
          - lojban: .a'u cu'i na cuntu mi
          - gloss: [Disinterestedly] Not affair-of me.
          - translation: That's none of my business.
        - 2:
          - lojban: .a'u cu'i mi na djica lo nu djuno
          - gloss: [Disinterestedly] I not want the event-of know.
          - translation: I don't really care to know.

- .a'u nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Repulsion: Expresses repulsion or disgust.
      - examples:
        - 1:
          - lojban: .a'u nai ta panci simsa lo kalci
          - gloss: [Repulsedly] That odor similar-to the feces.
          - translation: Yuck, that smells like shit!
        - 2:
          - lojban: .a'u nai mi na djica lo nu viska ta
          - gloss: [Repulsedly] I not want the event-of see that.
          - translation: Ugh, I don't want to see that.

- .i'a:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Acceptance: Expresses acceptance or agreement.
      - examples:
        - 1:
          - lojban: .i'a ta banzu
          - gloss: [Acceptingly] That suffices.
          - translation: Okay, that will do.
        - 2:
          - lojban: .i'a mi jimpe
          - gloss: [Acceptingly] I understand.
          - translation: I see, I understand and accept that.

- .i'a nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Refusal: Expresses refusal / rejection / eschewal / resistance / dissatisfaction / blame / incrimination / inculpation.
      - examples:
        - 1:
          - lojban: .i'a nai ta mi za'o na mansa
          - gloss: [Refusingly] That me still not satisfies.
          - translation: No, that still doesn't satisfy me.
        - 2:
          - lojban: .i'a nai mi na zasti ti
          - gloss: [Refusingly] I not approve this.
          - translation: I don't accept this at all.

- .i'e:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Approval: Expresses approval or endorsement.
      - examples:
        - 1:
          - lojban: .i'e do xautce gunka
          - gloss: [Approvingly] You excellent work.
          - translation: Very good! You did an excellent job.
        - 2:
          - lojban: .i'e mi nelci ta
          - gloss: [Approvingly] I like that.
          - translation: I approve of that, I like it.

- .i'e cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Neutrality: Expresses non-approval and non-disapproval.
      - examples:
        - 1:
          - lojban: .i'e cu'i lo cmaci ka'e cfipu lo co'a ve ckule
          - gloss: [Neutrally] The mathematics can-be confusing the beginner type-of student.
          - translation: Speaking objectively, math can be confusing for beginners.
        - 2:
          - lojban: .i'e cu'i mi na jinvi
          - gloss: [Neutrally] I not opine.
          - translation: I have no opinion on that either way.

- .i'e nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Disapproval: Expresses disapproval or criticism.
      - examples:
        - 1:
          - lojban: .i'e nai le pixra cu korcu dandu
          - gloss: [Disapprovingly] The picture - crooked hang.
          - translation: Hm, the picture is hanging crooked.
        - 2:
          - lojban: .i'e nai ta na xamgu
          - gloss: [Disapprovingly] That not good.
          - translation: I disapprove of that, it's not good.

- .i'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Togetherness: Expresses a feeling of togetherness or camaraderie.
      - examples:
        - 1:
          - lojban: .i'i mi ba jinga
          - gloss: [Together] We future win.
          - translation: Yay! We're gonna win!
        - 2:
          - lojban: .i'i mi'o gunka tai traji
          - gloss: [Together] We work like best.
          - translation: We make such a great team!

- .i'i nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Separation: Expresses a desire for privacy or solitude.
      - examples:
        - 1:
          - lojban: .i'i nai ko cliva
          - gloss: [Separately] You leave.
          - translation: Go away, I want to be alone!
        - 2:
          - lojban: .i'i nai mi djica lo nu stali
          - gloss: [Separately] I want the event-of stay.
          - translation: I'd rather stay by myself.

- .i'o:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Appreciation: Expresses appreciation or gratitude.
      - examples:
        - 1:
          - lojban: .i'o do je'a pendo
          - gloss: [Appreciatively] You indeed friend.
          - translation: Ah, you're a true friend.
        - 2:
          - lojban: .i'o do pu sidju mi
          - gloss: [Appreciatively] You past help me.
          - translation: Thank you, I really appreciate your help.

- .i'o nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Envy: Expresses envy or resentment.
      - examples:
        - 1:
          - lojban: .i'o nai do ro roi se funca lo zabna
          - gloss: [Enviously] You all times is-luckied the good.
          - translation: Damn you, you always have good luck!
        - 2:
          - lojban: .i'o nai mi djica lo nu mi ponse ta
          - gloss: [Enviously] I want the event-of I possess that.
          - translation: I'm so jealous, I wish I had that.

- .i'u:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Familiarity: Expresses familiarity or recognition.
      - examples:
        - 1:
          - lojban: .i'u mi ta xabju ze'a lo nanca be li so'i
          - gloss: [Familiarly] I that inhabit for-time the year of-number many.
          - translation: Yes, I lived there for many years.
        - 2:
          - lojban: .i'u mi djuno ro da
          - gloss: [Familiarly] I know all that.
          - translation: I'm familiar with all of that.

- .i'u nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Unfamiliarity: Expresses unfamiliarity or mystification.
      - examples:
        - 1:
          - lojban: .i'u nai no da sidbo fi mi lo du'u pleji ma kau fo ta
          - gloss: [Unfamiliarly] No one knows to me the statement-of pay what-amount for that.
          - translation: I have no idea how much they are paying for that.
        - 2:
          - lojban: .i'u nai mi na djuno lo du'u makau fasnu
          - gloss: [Unfamiliarly] I not know the statement-of what happens.
          - translation: I'm completely unfamiliar with what's going on.

- ii:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Fear: Expresses fear or terror.
      - examples:
        - 1:
          - lojban: ii le tirxu cu xruti
          - gloss: [Fearfully] The tiger - returns.
          - translation: Oh, no! The tiger is back!
        - 2:
          - lojban: ii mi terpa lo nu farlu
          - gloss: [Fearfully] I fear the event-of fall.
          - translation: I'm terrified of falling!

- ii nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Security: Expresses security or fearlessness.
      - examples:
        - 1:
          - lojban: ii nai le ctuca na ba tolcri mi'o ti
          - gloss: [Securely] The teacher not future find us here.
          - translation: Heh, the teacher won't find us here.
        - 2:
          - lojban: ii nai mi na terpa
          - gloss: [Securely] I not afraid.
          - translation: I'm not scared at all, I feel completely safe.

- io:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Respect: Expresses respect or deference.
      - examples:
        - 1:
          - lojban: io ko mi jersi doi nolnau
          - gloss: [Respectfully] You-imperative me follow , O noble-person.
          - translation: This way, Sir, if you please.
        - 2:
          - lojban: io mi ckire do
          - gloss: [Respectfully] I thank you.
          - translation: I respectfully thank you.

- io nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Disrespect: Expresses disrespect or scorn.
      - examples:
        - 1:
          - lojban: io nai ko ti klama doi bebna
          - gloss: [Disrespectfully] You-imperative here come , O stupid-one.
          - translation: Get your ass over here, you idiot!
        - 2:
          - lojban: io nai do na certu
          - gloss: [Disrespectfully] You not expert.
          - translation: You're incompetent and I have no respect for you.

- iu:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Love: Expresses love or affection.
      - examples:
        - 1:
          - lojban: iu do melbi
          - gloss: [Lovingly] You beautiful.
          - translation: You're beautiful.
        - 2:
          - lojban: iu mi prami do
          - gloss: [Lovingly] I love you.
          - translation: I love you.

- iu nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Hatred: Expresses hatred or antipathy.
      - examples:
        - 1:
          - lojban: iu nai do palci
          - gloss: [Hatefully] You evil.
          - translation: You're evil.
        - 2:
          - lojban: iu nai mi xebni do
          - gloss: [Hatefully] I hate you.
          - translation: I hate you.

- .o'a:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Pride: Expresses pride / dignity / self-confidence / smugness / bravado / grandiloquence / pomposity / cockiness / conceit / arrogance.
      - examples:
        - 1:
          - lojban: .o'a ju'i mamta mi kakne lo ka tcidu
          - gloss: [Proudly] [attention] mother I able the event-of read.
          - translation: Look Mummy, I can read!
        - 2:
          - lojban: .o'a mi jinga
          - gloss: [Proudly] I win.
          - translation: I won the competition!

- .o'a cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Modesty: Expresses modesty or humility.
      - examples:
        - 1:
          - lojban: .o'a cu'i ba'e mi lumci pi su'o po'o le loldi
          - gloss: [Modestly] [emphasize] I clean some only the floor.
          - translation: Oh, *I* mopped only some part of the floor.
        - 2:
          - lojban: .o'a cu'i mi na traji
          - gloss: [Modestly] I not superlative.
          - translation: I'm not the best, just doing my part.

- .o'a nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Shame: Expresses shame or embarrassment.
      - examples:
        - 1:
          - lojban: .o'a nai mi mrilu le notci lo srera noigri
          - gloss: [Shamefully] I mail the message the wrong newsgroup.
          - translation: Oops, I posted the message to the wrong newsgroup.
        - 2:
          - lojban: .o'a nai mi pu zukte lo srera
          - gloss: [Shamefully] I past do the mistake.
          - translation: I'm ashamed, I made a terrible mistake.

- .o'e:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Closeness: Expresses intimacy, closeness, affinity, sympathy, rapport
      - examples:
        - 1:
          - lojban: .o'e do pu se nandu
          - gloss: [Intimacy!] You in-past has-problem.
          - translation: Your problems resonated with me.
          - comment: The speaker feels closeness with others' problems.
        - 2:
          - lojban: .o'e mi zvati le zdani
          - gloss: [Intimacy!] I is-present-at the home.
          - translation: Honey, I'm back home.
          - comment: The speaker feels emotionally close by the fact of being at home.

- .o'e nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Distance: Expresses emotional distance or reserve.
      - examples:
        - 1:
          - lojban: .o'e nai doi dirba mi to'e cinmo
          - gloss: [Distantly] O dear I opposite-of emotion.
          - translation: Frankly, my dear, I don't give a damn.
        - 2:
          - lojban: .o'e nai mi na djica lo nu tavla do
          - gloss: [Distantly] I not desire the event-of talk-to you.
          - translation: I don't want to talk to you, leave me alone.

- .o'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Caution: Expresses caution / carefulness / prudence / vigilance
      - examples:
        - 1:
          - lojban: .o'i le loldi cu se sakli
          - gloss: [Cautiously] The floor - is-slippery.
          - translation: Careful! The floor is slippery.
        - 2:
          - lojban: .o'i ko jundi klama o'i
          - gloss: [Cautiously] You-imperative attentive go.
          - translation: Be careful as you go!

- .o'i nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Rashness: Expresses recklessness or rashness.
      - examples:
        - 1:
          - lojban: .o'i nai ko gunta
          - gloss: [Recklessly] You-imperative attack.
          - translation: Charge!
        - 2:
          - lojban: .o'i nai mi darsi
          - gloss: [Recklessly] I dare.
          - translation: I'll do it, no matter the risk!

- .o'o:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Patience: Expresses patience / tolerance / forbearance / leniency / benevolence / indulgence / magnanimity.
      - examples:
        - 1:
          - lojban: .o'o do fliba .i ko za'u re'u troci
          - gloss: [Patiently] you fail new-sentence you-imperative again try.
          - translation: Ok, you failed. Try again.
          - comment: The speaker feels patient with others' attempts.

- .o'o cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Mere tolerance: Expresses mere tolerance without patience or impatience.
      - examples:
        - 1:
          - lojban: .o'o cu'i ma pu mukti fi do
          - gloss: [Tolerantly] What past motivate of you.
          - translation: So, what drove you to do it?
        - 2:
          - lojban: .o'o cu'i mi na tugni gi'e na fapro
          - gloss: [Tolerantly] I not agree and not oppose.
          - translation: I neither agree nor disagree, I can tolerate it.

- .o'o nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Impatience: Expresses impatience or anger.
      - examples:
        - 1:
          - lojban: .o'o nai lo xanto cu fanta lo nu mi pagre
          - gloss: [Impatiently] The elephant - prevent the event-of I pass-through.
          - translation: Damn, the elephants are blocking my way!
        - 2:
          - lojban: .o'o nai do masno mutce
          - gloss: [Impatiently] You slow very.
          - translation: Hurry up! You're so slow!

- .o'u:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Relaxation: Expresses relaxation / leisure / repose / peacefulness / serenity / calmness / placidity / tranquility / quietude
      - examples:
        - 1:
          - lojban: .o'u mi co'a jinru le glare
          - gloss: [Relaxation!] I at-the-beginning bathe-in the hot.
          - translation: [Phew!] I'm sinking into a hot bath.
          - comment: The speaker feels relieved when taking a hot bath.

- .o'u cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Composure: Expresses composure or calmness.
      - examples:
        - 1:
          - lojban: .o'u cu'i mi pu tinbe lo selfla
          - gloss: [Composedly] I past obey the law.
          - translation: I followed the law.
        - 2:
          - lojban: .o'u cu'i mi na cinmo
          - gloss: [Composedly] I not emotion.
          - translation: I'm feeling neither relaxed nor stressed.

- .o'u nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Stress: Expresses stress or anxiety.
      - examples:
        - 1:
          - lojban: .o'u nai le mi bersa cu zvati ma
          - gloss: [Stressfully] The of-me son - present-at where?
          - translation: Where is my son?
        - 2:
          - lojban: .o'u nai mi na kakne lo nu gunka
          - gloss: [Stressfully] I not able the event-of work.
          - translation: I'm too stressed to work!

- .oi:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Complaint: Expresses pain / complaint / displeasure / discomfort / discontentment / frustration / protestation.
      - examples:
        - 1:
          - lojban: .oi la djan. klama
          - gloss: [Complaint!] That-named John comes.
          - translation: [Complaint!] John is coming.
          - comment: The speaker feels distressed about John's arrival.
        - 2:
          - lojban: .oi la'e do'i nandu
          - gloss: [Complainingly] referent-of some-utterance difficult.
          - translation: Ugh, this is hard.

- .oi nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Pleasure: Expresses pleasure or delight.
      - examples:
        - 1:
          - lojban: .oi nai glare cakla
          - gloss: [Pleasurably] Hot chocolate.
          - translation: Mmm, hot chocolate!
        - 2:
          - lojban: .oi nai mi mutce gleki
          - gloss: [Pleasurably] I very happy.
          - translation: I'm so pleased!

- .u'a:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Gain: Expresses the feeling of gaining or obtaining something, victory, acquiring or achieving something desirable.
      - examples:
        - 1:
          - lojban: .u'a mi facki fi le mi mapku
          - gloss: [Gain!] I found-out about the of-me hat.
          - translation: [Gain!] I found my hat!
          - comment: Emphasizes the feeling of gain associated with finding the hat.
        - 2:
          - lojban: .u'a la'e di'u se jetnu lo du'u mi pu drani
          - gloss: [Gain!] The-referent of-previous-sentence is-true-ified the statement-of I past correct.
          - translation: Hah, that proves I was right!
        - 3:
          - lojban: .u'a mi jinga le jinga
          - gloss: [Gain!] I win the prize.
          - translation: I won the prize!

- .u'a nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Loss: Expresses the feeling of losing something valuable, experiencing a setback, defeat, or missing out on something desirable.
      - examples:
        - 1:
          - lojban: .u'anai le mi mapku ba'o zvati
          - gloss: [Loss!] the of-me hat no-anymore is-present-at.
          - translation: [Loss!] My hat is no longer here.
          - comment: Shows the feeling of loss when the hat is not present.
        - 2:
          - lojban: .u'a nai la rover pu xamgu gerku
          - gloss: [Loss!] The Rover past good dog.
          - translation: Snif, Rover was a good dog.
        - 3:
          - lojban: .u'a nai mi pu cirko lo jdini
          - gloss: [Loss!] I past lose the money.
          - translation: Alas, I lost the money.

- .u'e:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Wonder/Awe: Expresses feelings of awe, wonder, amazement, fascination, or admiration.
      - examples:
        - 1:
          - lojban: .u'e le jemna cu melbi
          - gloss: [Awe!] The gem is-beautiful.
          - translation: [Wow!] The gem is beautiful!
          - comment: Expresses admiration for the beauty of the gem.
        - 2:
          - lojban: .u'e ze prenu cu zvati
          - gloss: [Wonderfully] Seven person - present-at.
          - translation: Wow, there are seven people here!
        - 3:
          - lojban: .u'e le va gerku cu mutce stati
          - gloss: [Wonderfully] The yonder dog - very talented.
          - translation: Wow, that dog is really talented!

- .u'e nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Commonplace: Expresses the feeling that something is commonplace, unremarkable, ordinary, or unimpressive.
      - examples:
        - 1:
          - lojban: .u'enai la djan klama
          - gloss: [Meh!] that-named John is-coming.
          - translation: [Meh!] John is coming.
          - comment: Expresses that John's arrival is seen as ordinary or unimpressive.
        - 2:
          - lojban: .u'e nai xu ta xagrai lo se kakne be do
          - gloss: [Mundanely] Is-it-true that superlative the is-able-to by you?
          - translation: Pshaw, is that the best you can do?
        - 3:
          - lojban: .u'e nai mi pu zi viska lo simsa
          - gloss: [Mundanely] I past recently see the similar.
          - translation: Meh, I just saw something like that.

- .u'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Amusement/Playfulness: Expresses feelings of amusement, mirth, fun, playfulness, being entertained or finding something funny.
      - examples:
        - 1:
          - lojban: .u'i tu cusku zo ganxo
          - gloss: [Fun!] That-over-there express word "anus".
          - translation: Heh, heh, he said "arsehole".
        - 2:
          - lojban: .u'i le skina cu mutce xajmi
          - gloss: [Fun!] The movie - very funny.
          - translation: Haha, the movie is so funny!
        - 3:
          - lojban: .u'i mi citka
          - gloss: [Fun!] I eat.
          - translation: [Fun!] I'm eating!
          - comment: Expresses a playful attitude while doing something simple like eating.
- .u'i nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Weariness: Expresses weariness or boredom, lack of amusement.
      - examples:
        - 1:
          - lojban: .u'inai do tavla mi
          - gloss: [Boring!] you talk to me.
          - translation: [Boring!] You are talking to me.
          - comment: Expresses weariness or boredom with the conversation.
        - 2:
          - lojban: .u'i nai banzu ca le cabdei
          - gloss: [Wearily] Enough in the now-day.
          - translation: Yawn, that's enough for today.
        - 3:
          - lojban: .u'i nai ti na cinri
          - gloss: [Wearily] This not interesting.
          - translation: This is so boring.

- .u'o:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Courage: Expresses the feeling of courage, boldness, bravery, valor, or daring.
      - examples:
        - 1:
          - lojban: .u'o mi do pu'o nurgau
          - gloss: [Courageously] I you about-to rescue.
          - translation: I'm coming to your rescue!
        - 2:
          - lojban: .u'o mi vofli
          - gloss: [Courage!] I fly
          - translation: [Courage!] I'm flying!
          - comment: Shows courage when flying.
- .u'o cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Timidity: Expresses timidity or shyness.
      - examples:
        - 1:
          - lojban: .u'o cu'i xu mi zifre lo nu stali
          - gloss: [Timidly] Is-it-true I free the event-of stay?
          - translation: Erm, may I stay here?
        - 2:
          - lojban: .u'o cu'i mi na djica lo nu tavla
          - gloss: [Timidly] I not want the event-of talk.
          - translation: I'm too shy to speak up.

- .u'o nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Cowardice: Expresses the feeling of cowardice, shyness, or lack of confidence.
      - examples:
        - 1:
          - lojban: .u'o nai mi na klama tu
          - gloss: [Cowardly!] I not go-to there.
          - translation: [Oh no!] I'm not going there!
          - comment: Shows cowardice when attempting/planning/considering to go to that place.
        - 2:
          - lojban: .u'o nai mi djica lo nu mi cliva
          - gloss: [Cowardly!] I want the event-of leave.
          - translation: I'm too scared, I want to leave!

- .u'u:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Repentance: Expresses feelings of remorse, guilt, regret, or repentance.
      - examples:
        - 1:
          - lojban: .u'u mi pu na jundi
          - gloss: [Repentantly] I past not attentive.
          - translation: Sorry, I wasn't paying attention.
        - 2:
          - lojban: .u'u mi pu zukte lo srera
          - gloss: [Repentantly] I past do the mistake.
          - translation: I regret that I made a mistake.
        - 3:
          - lojban: .u'u do cortu
          - gloss: [Repentance!] you feel-pain.
          - translation: [Repentance!] you feel pain.
          - comment: The speaker feels guilt about the other person’s pain.
- .u'u cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Lack of regret: Expresses neither regret nor lack of regret.
      - examples:
        - 1:
          - lojban: .u'u cu'i mi zukte no da
          - gloss: [Non-repentantly] I do no thing.
          - translation: I didn't do anything!
        - 2:
          - lojban: .u'u cu'i mi na djuno
          - gloss: [Non-repentantly] I not know.
          - translation: I don't know, and I don't feel particularly bad about it.

- .u'u nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Lack of regret: Expresses a lack of regret, remorselessness, defiance,  spite, provocation, unrepentance.
      -- examples:
        - 1:
          - lojban: .u'u nai mi pu zi stapa le do jamfu i do ba zukte ma
          - gloss: [Unrepentantly] I past recently step-on the your foot . You future do what?
          - translation: Yeah, I just stepped on your foot. What are you going to do about it?
        - 2:
          - lojban: .u'u nai mi na cikre
          - gloss: [Unrepentantly] I not repair.
          - translation: I won't fix it and I don't feel bad about it.
        - 3:
          - lojban: .u'unai do cortu
          - gloss: [Unrepentantly] you feel-pain.
          - translation: You feel pain, I'm not to blame.
          - comment: The speaker emphasizes no regret or guilt about the other person’s pain.
- ua:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Discovery: Expresses discovery or comprehension, the feeling of suddenly finding or understanding something previously unknown or unclear.
      - examples:
        - 1:
          - lojban: .ua le mi mapku cu zvati le drata kumfa
          - gloss: [Eureka!] the of-me hat - is-present-at the another room.
          - translation: [Eureka!] My hat is in the other room!
          - comment: Emphasizes the discovery of the hat.
        - 2:
          - lojban: ua ba'e ta do mensi
          - gloss: [Ah!] [emphasize] that your sister.
          - translation: Ah, so *that's* your sister.
        - 3:
          - lojban: ua .i mi jimpe
          - gloss: [Ah!] I understand.
          - translation: Oh, I get it now!

- ua nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Confusion: Expresses confusion or incomprehension.
      - examples:
        - 1:
          - lojban: .uanai le mi mapku na nenri le dinju
          - gloss: [Confusion!] The of-me hat not is-inside-of the building.
          - translation: [Confusion!] My hat is not inside the building.
          - comment: Emphasizes the feeling of confusion when not finding the hat.
        - 2:
          - lojban: ua nai la'e di'u vajni fi ma
          - gloss: [Confusion!] The-referent of-previous-sentence important to what?
          - translation: Huh? How is that relevant?

- ue:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Surprise: Expresses surprise or astonishment.
      - examples:
        - 1:
          - lojban: ue ta lenku
          - gloss: [Surprisingly] That cold.
          - translation: Oo, that's cold!
        - 2:
          - lojban: ue do klama ti
          - gloss: [Surprisingly] You come here.
          - translation: Wow, you came here!
        - 3:
          - lojban: .ue la .djan. cu klama
          - gloss: [Wow!] that-named John is-coming.
          - translation: [Wow!] John is coming!
          - comment: Expresses surprise at John's arrival.
- ue cu'i:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Not really surprised: Expresses a lack of real surprise.
      - examples:
        - 1:
          - lojban: ue cu'i ma cnino
          - gloss: [Not-really-surprisingly] What new?
          - translation: So what's new?
        - 2:
          - lojban: ue cu'i mi pu djuno
          - gloss: [Not-really-surprisingly] I past know.
          - translation: I'm not really surprised, I knew about it.

- ue nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Expectation: Expresses expectation or lack of surprise.
      - examples:
        - 1:
          - lojban: .uenai la .djan. klama
          - gloss: [As-expected!] that-named John is-coming.
          - translation: [As expected!] John is coming.
          - comment: Expresses a lack of surprise at John's arrival.
        - 2:
          - lojban: ue nai ro da pu prane
          - gloss: [Expectedly] All everything past perfect.
          - translation: Everything was perfect, just as I expected.
        - 3:
          - lojban: ue nai do za'o zukte
          - gloss: [Expectedly] You still do.
          - translation: I'm not surprised you're still doing that.

- ui:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Happiness: Expresses happiness or joy.
      - examples:
        - 1:
          - lojban: .ui mi facki fi le mi mapku
          - gloss: [Yay!] I found-out about the of-me hat.
          - translation: [Yay!] I found my hat!
          - comment: Emphasizes the feeling of happiness about finding the hat.
        - 2:
          - lojban: ui mi pu klama le zarci
          - gloss: [Happily] I past go-to the store.
          - translation: Yay, I went to the store!
        - 3:
          - lojban: ui mi co'a se slabu do
          - gloss: [Happily] I start-to be-familiar-with you.
          - translation: I'm so happy to get to know you!

- ui nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Unhappiness: Expresses unhappiness or sadness.
      - examples:
        - 1:
          - lojban: .uinai mi na facki fi le mi mapku
          - gloss: [Ugh!] I not found-out about the of-me hat.
          - translation: [Ugh!] I didn't find my hat.
          - comment: Emphasizes unhappiness due to not finding the hat.
        - 2:
          - lojban: ui nai ti pu melbi jarbu
          - gloss: [Unhappily] This past beautiful neighborhood.
          - translation: Sigh, this used to be a nice neighbourhood.
        - 3:
          - lojban: ui nai mi na co'a se slabu do
          - gloss: [Unhappily] I not start-to be-familiar-with you.
          - translation: I'm sad that I don't know you better.

- uo:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Completion: Expresses completion or achievement, a sense of completion or finality, having finished something, reaching a goal, or achieving closure.
      - examples:
        - 1:
          - lojban: .uo mi facki fi le mi mapku
          - gloss: [At-last!] I found-out about the of-me hat.
          - translation: [At last!] I found my hat!
          - comment: Emphasizes the sense of finality upon finding the hat.
        - 2:
          - lojban: uo di'u clani jufra
          - gloss: [Completely] This long sentence.
          - translation: Phew, that was a long sentence!
        - 3:
          - lojban: uo mi mo'u gunka
          - gloss: [Completely] I complete work.
          - translation: I've finished the work, finally!

- uo nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Incompleteness: Incompleteness: Expresses the sense of something being unfinished or incomplete, lacking closure, or having something more to do, to be, or to have (but not necessarily with an obligation or restriction to do it).
      - examples:
        - 1:
          - lojban: .uonai mi na facki fi le mi mapku
          - gloss: [Not-finished!] I not found-out about the of-me hat.
          - translation: [Not finished!] I didn’t find my hat.
          - comment: Emphasizes the feeling of incompleteness from not finding the hat.
        - 2:
          - lojban: uo nai do tu na ru'e darxi
          - gloss: [Incompletely] You yonder not at-most hit.
          - translation: Oh, you almost hit it.
        - 3:
          - lojban: uo nai mi na mo'u gunka
          - gloss: [Incompletely] I not complete work.
          - translation: I haven't finished the work yet, unfortunately.

- uu:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Pity: Expresses pity or compassion.
      - examples:
        - 1:
          - lojban: .uu do cortu
          - gloss: [Pity!] you feel-pain.
          - translation: I'm so sorry you're in pain.
          - comment: Expresses sympathy for someone feeling pain.
        - 2:
          - lojban: uu mi ba plicru do le boxfo
          - gloss: [Pity!] I future use-allow you the blanket.
          - translation: Oh you poor thing! I'll get you a blanket.

- uu nai:
  - definitions:
    - 1:
      - type: pure emotion indicator
      - definition: Cruelty: Expresses cruelty, callousness, a lack of sympathy, cold-heartedness, ruthlessness, or heartlessness.
      - examples:
        - 1:
          - lojban: uu nai mi ba ponse le do pruxi
          - gloss: [Cruelly] I future possess the your spirit.
          - translation: Mwa, ha, ha, ha, ha! Your soul will be mine!
        - 2:
          - lojban: .uunai do cortu
          - gloss: [No-pity!] you feel-pain.
          - translation: [No pity!] You feel pain.
          - comment: Expresses a lack of sympathy for someone feeling pain.
----

- ki'a:
  - definitions:
    - 1:
      - type: indicator
      - definition: Metalinguistic confusion
      - examples:
        - 1:
          - lojban: mi nelci le ctuca. .i le ki'a ctuca
          - translation: I like the teacher. Which teacher?
- na'i:
  - definitions:
    - 1:
      - type: indicator
      - definition: Metalinguistic negation (indicates error or inappropriateness)
      - examples:
        - 1:
          - lojban: la .djan. nanmu .ina'i ninmu
          - translation: John, who is a man, [is not] a woman.
- jo'a:
  - definitions:
    - 1:
      - type: indicator
      - definition: Metalinguistic affirmation
      - examples:
        - 1:
          - lojban: la .djan. nanmu .ijo'a ninmu.
          - translation: John, who is a man, is [indeed] not a woman.
- xu:
  - definitions:
    - 1:
      - type: indicator
      - definition: Truth question marker
      - examples:
        - 1:
          - lojban: xu do klama le zarci?
          - translation: Is it true that you go to the store?
- pau:
  - definitions:
    - 1:
      - type: indicator
      - definition: Question pre-marker
      - examples:
        - 1:
          - lojban: pau ma cmene do?
          - translation: What is your name?
- paunai:
  - definitions:
    - 1:
      - type: indicator
      - definition: Indicates rhetorical question
- pe'a:
  - definitions:
    - 1:
      - type: indicator
      - definition: Figurative language marker
      - examples:
        - 1:
          - lojban: mi viska le blanu pe'a zdani.
          - translation: I see the "blue" house.
          - comment: The house is not literally blue but figuratively so, perhaps meaning it's sad.
- pe'anai:
  - definitions:
    - 1:
      - type: indicator
      - definition: Literal language marker
- .o'a:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Pride/Shame: Expresses the feeling of satisfaction, self-respect, or accomplishment, or conversely, the feeling of humiliation, guilt, or embarrassment.
- .o'e:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Closeness/Distance: Expresses the feeling of intimacy, connection, or warmth toward someone or something, or conversely, the feeling of detachment, separation, or coldness.
- .oi:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Complaint/Pleasure: Expresses the feeling of pain, discomfort, or displeasure, or conversely, the feeling of enjoyment, satisfaction, or pleasure.
      - examples:
        - 1:
          - lojban: .oi la .djan. klama
          - gloss: [Complaint!] that-named John is-coming.
- .oinai:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Pleasure: Expresses the feeling of enjoyment, satisfaction, or pleasure.
      - examples:
        - 1:
          - lojban: .o'onai la .djan. klama
          - gloss: [Anger!] that-named John is-coming!
- .o'i:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Caution/Rashness: Expresses the feeling of being careful, hesitant, or wary, or conversely, the feeling of being reckless, impulsive, or daring.
      - examples:
        - 1:
          - lojban: .o'i la .djan. klama
          - gloss: [Beware!] that-named John is-coming.
- .o'o:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Patience/Anger: Expresses the feeling of being able to wait calmly or endure delays, or conversely, the feeling of irritation, frustration, or rage.
- .o'u:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Relaxation/Stress: Expresses the feeling of being calm, peaceful, or at ease, or conversely, the feeling of being tense, anxious, or under pressure.
      - examples:
        - 1:
          - lojban: .o'u la .djan. klama
          - gloss: [Phew!] that-named John is-coming.
- .ii:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Fear/Security: Expresses the feeling of fright, anxiety, or apprehension, or conversely, the feeling of safety, confidence, or peace of mind.
      - examples:
        - 1:
          - lojban: .ii smacu
          - gloss: [Fear!] [Observative:]-a-mouse!
          - translation: Eek! A mouse!
- .i'i:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Togetherness/Privacy: Expresses the feeling of wanting to be with others or be part of a group, or conversely, the feeling of wanting to be alone or have privacy.
- .io:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Respect/Disrespect: Expresses the feeling of admiration, esteem, or deference, or conversely, the feeling of contempt, disdain, or disregard.
      - examples:
        - 1:
          - lojban: .ionai la .djan. klama
          - gloss: [disrespect!] that-named John is-coming.
- .i'o:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Appreciation/Envy: Expresses the feeling of gratitude, thankfulness, or recognition of value, or conversely, the feeling of resentment or covetousness toward someone else's possessions or qualities.
- .iu:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Love/Hate: Expresses the feeling of affection, fondness, or deep care for someone or something, or conversely, the feeling of dislike, aversion, or animosity.
      - examples:
        - 1:
          - lojban: .iu la .djan. klama
          - gloss: [love!] that-named John is-coming.
- .i'u:
  - definitions:
    - 1:
      - type: simple emotion indicator
      - definition: Familiarity/Mystery: Expresses the feeling of knowing something well or being comfortable with it, or conversely, the feeling of something being unknown, strange, or enigmatic.
- .a'a:
  - definitions:
    - 1:
      - definition: Attention: Expresses the speaker's focus and concentration on a particular matter, or conversely, their lack of focus or deliberate avoidance of paying attention to something.
      - examples:
        - 1:
          - lojban: .a'a do zgana le veltivni
          - gloss: [attentive] you observe the television-receiver.
          - translation: I'm noticing that you are watching the TV.
- .a'anai:
  - definitions:
    - 1:
      - definition: Inattention: Expresses the speaker's lack of focus, inattentiveness, or deliberate avoidance of paying attention to something.
- .a'e:
  - definitions:
    - 1:
      - definition: Alertness/Exhaustion: Expresses the speaker's state of being awake, aware, and mentally active, or conversely, their state of being tired, sleepy, or mentally drained.
      - examples:
        - 1:
          - lojban: .a'enai do ranji bacru
          - gloss: [exhaustion] you continuously utter.
          - translation: I'm worn out by your continuous talking.
- .ai:
  - definitions:
    - 1:
      - definition: Intent: Expresses the speaker's firm resolution or determination to do something, or conversely, their uncertainty or lack of resolve.
      - examples:
        - 1:
          - lojban: .ai mi muvgau do le ckana
          - gloss: [intent] I transfer you to-the bed.
          - translation: I'm putting you to bed.
- .ainai:
  - definitions:
    - 1:
      - definition: Indecision: Expresses the speaker's uncertainty, hesitation, or lack of resolve regarding a particular action.
- .a'i:
  - definitions:
    - 1:
      - definition: Effort/Repose: Expresses the speaker's exertion of energy or willpower to accomplish something, or conversely, their state of rest or relaxation.
      - examples:
        - 1:
          - lojban: .a'i mi ba gasnu le nu do cikna binxo
          - gloss: [effort] I [future] am-the-actor-in the event-of you awake-ly become.
          - translation: It'll be hard for me to wake you up.
- .a'o:
  - definitions:
    - 1:
      - definition: Hope/Despair: Expresses the speaker's optimistic expectation or desire for something to happen, or conversely, their pessimism or lack of hope.
      - examples:
        - 1:
          - lojban: .a'o mi kanryze'a ca le bavlamdei
          - gloss: [hope] I am-health-increased at-time the future-adjacent-day.
          - translation: I hope I feel better tomorrow!
- .au:
  - definitions:
    - 1:
      - definition: Desire: Expresses the speaker's wish or longing for something, or conversely, their unwillingness or aversion to something.
      - examples:
        - 1:
          - lojban: .au mi sipna
          - gloss: [desire] I sleep.
          - translation: I want to sleep.
- .aucu'i:
  - definitions:
    - 1:
      - definition: Neutral desire: Expresses a neutral or indifferent feeling towards a particular desire, neither wanting nor not wanting something.
- .aunai:
  - definitions:
    - 1:
      - definition: Reluctance: Expresses the speaker's unwillingness, hesitation, or aversion to something.
- .a'u:
  - definitions:
    - 1:
      - definition: Interest: Expresses the speaker's curiosity, engagement, or attraction to something, or conversely, their disinterest, boredom, or aversion.
      - examples:
        - 1:
          - lojban: .a'ucu'i do pante
          - gloss: [no-interest] you complain.
          - translation: I have no interest in your complaints.
- .e'a:
  - definitions:
    - 1:
      - definition: Permission: Expresses the speaker's granting of allowance or authorization for something to happen, or conversely, their forbidding or disallowing of something.
      - examples:
        - 1:
          - lojban: .e'a do sazri le karce
          - gloss: [permission] you drive the car.
          - translation: Sure, you can drive the car.
- .e'anai:
  - definitions:
    - 1:
      - definition: Prohibition: Expresses the speaker's forbidding or disallowing of something.
- .e'e:
  - definitions:
    - 1:
      - definition: Competence: Expresses the speaker's feeling of being capable, skilled, or qualified to do something, or conversely, their feeling of being unable or unqualified.
      - examples:
        - 1:
          - lojban: .e'e mi lifri tu'a do
          - gloss: [competence] I experience something-related-to you.
          - translation: I feel up to dealing with you.
- .e'enai:
  - definitions:
    - 1:
      - definition: Incompetence: Expresses the speaker's feeling of being incapable, unskilled, or unqualified to do something.
- .ei:
  - definitions:
    - 1:
      - definition: Obligation: Expresses the speaker's sense of duty, responsibility, or requirement to do something, or conversely, their feeling of being free from obligation or constraint.
      - examples:
        - 1:
          - lojban: .ei mi tisygau le karce ctilyvau
          - gloss: [obligation] I fill the car-type-of petroleum-container.
          - translation: I should fill the car's gas tank.
- .einai:
  - definitions:
    - 1:
      - definition: Freedom: Expresses the speaker's feeling of being free from obligation, constraint, or requirement.
- .e'i:
  - definitions:
    - 1:
      - definition: Constraint: Expresses the feeling of being restricted, limited, or controlled by external factors, or conversely, the feeling of being free, autonomous, or independent.
- .e'o:
  - definitions:
    - 1:
      - definition: Request: Expresses the speaker's asking or pleading for something to be done, or conversely, their expressing a desire for something not to be done.
      - examples:
        - 1:
          - lojban: .e'o ko ko kurji
          - gloss: [request] you-imperative of-you-imperative take-care.
          - translation: Please take care of yourself!
- .e'onai:
  - definitions:
    - 1:
      - definition: Negative request: Expresses the speaker's desire for something not to be done.
- .e'u:
  - definitions:
    - 1:
      - definition: Suggestion/Warning: Expresses the speaker's offering of a possible course of action or idea, or conversely, their cautioning or advising against something.
      - examples:
        - 1:
          - lojban: .e'u do klama le panka
          - gloss: [suggestion] you go to-the park.
          - translation: I suggest going to the park.
- .ia:
  - definitions:
    - 1:
      - definition: Belief/Disbelief: Expresses the speaker's acceptance of something as true or likely, or conversely, their skepticism or rejection of something as false or unlikely.
      - examples:
        - 1:
          - lojban: .ianai do pu pensi le nu tcica mi
          - gloss: [disbelief] you [past] think the event-of deceiving me.
          - translation: I can't believe you thought you could fool me.
- .ianai:
  - definitions:
    - 1:
      - definition: Disbelief: Expresses the speaker's skepticism or rejection of something as false or unlikely.
- .i'a:
  - definitions:
    - 1:
      - definition: Acceptance/Blame: Expresses the speaker's willingness to receive or tolerate something, or conversely, their assigning of responsibility or fault for something negative.
      - examples:
        - 1:
          - lojban: do .i'anai na xruti do le zdani
          - gloss: You [blame] did-not return you to-the house.
          - translation: I blame you for not coming home.
- .ie:
  - definitions:
    - 1:
      - definition: Agreement/Disagreement: Expresses the speaker's concurrence or harmony with a statement or opinion, or conversely, their dissent or opposition.
      - examples:
        - 1:
          - lojban: .ie mi na cusku lu'e
          - gloss: [agreement] I did-not express a-symbol-for ...
          - translation: It's true I didn't tell you when to come back.
- .ienai:
  - definitions:
    - 1:
      - definition: Disagreement: Expresses the speaker's dissent, opposition, or difference of opinion.
- .i'e:
  - definitions:
    - 1:
      - definition: Approval/Disapproval: Expresses the speaker's positive evaluation or acceptance of something, or conversely, their negative evaluation or rejection.
      - examples:
        - 1:
          - lojban: .i'enai do .i'e zukte
          - gloss: [disapproval] you [approval] act.
          - translation: I don't approve of what you did, but I approve of you.
- ja'o:
  - definitions:
    - 1:
      - definition: Conclusion: Indicates that the speaker has arrived at the statement through a process of deduction, inference, or reasoning based on other information or evidence. It's similar to saying "therefore" or "thus" in English.
      - examples:
        - 1:
          - lojban: .iseki'ubo la berti brife co'a bilga tugni fi lonu la solri cu traji leka vlipa vau fo la berti brife ce la solri
          - translation: And so the North Wind was obliged to confess that the Sun was the stronger of the two.
- ca'e:
  - definitions:
    - 1:
      - definition: Definition/Performative: Used to introduce definitions or performative statements. In definitions, it signifies that the speaker is assigning a specific meaning to a word or concept. In performatives, the act of uttering the statement itself makes it true, like saying "I promise" or "I declare."
      - examples:
        - 1:
          - lojban: ca'e le re do cu simxu speni
          - gloss: [I-define!] the two of-you are-mutual spouses.
          - translation: I now pronounce you husband and wife.
- ba'a:
  - definitions:
    - 1:
      - notes: The scale "Expectation/Experience/Memory" expresses the speaker's relationship to the timeline of an event.
      - definition: Expectation: Indicates the speaker's anticipation or expectation of a future event.
- ba'acu'i:
  - definitions:
    - 1:
      - definition: Experience: Indicates that the speaker is currently experiencing or perceiving the event.
      - examples:
        - 1:
          - lojban: ba'acu'i le tuple be mi cu se cortu
          - gloss: [I-experience!] the leg of me is-the-locus-of-pain.
          - translation: My leg hurts.
- ba'anai:
  - definitions:
    - 1:
      - definition: Memory: Indicates that the speaker is recalling or remembering a past event.
- su'a:
  - definitions:
    - 1:
      - notes: Generalization/Particularization: Expresses the speaker's approach to formulating the statement. su'a can also be used as a discursive with slightly different meanings: "abstractly" for su'a and "concretely" or "in particular" for su'anai.
      - definition: Generalization: Indicates that the speaker is making a general statement or drawing a conclusion based on a pattern or a set of examples. It's similar to saying "generally" or "as a rule" in English.
- su'anai:
  - definitions:
    - 1:
      - definition: Particularization: Indicates that the speaker is focusing on a specific instance or making a particular observation, rather than a general statement. It could be paraphrased as "specifically" or "in this case".
- ti'e:
  - definitions:
    - 1:
      - definition: Hearsay: Indicates that the information is being relayed or reported from another source, not from the speaker's direct knowledge or experience. It's similar to saying "I heard that..." or "It is said that..." in English.
      - examples:
        - 1:
          - lojban: ti'e la .uengas cu zergau
          - gloss: [I-hear!] Wenga is-a-criminal-doer.
          - translation: I hear that Wenga is a crook.
- ka'u:
  - definitions:
    - 1:
      - definition: Cultural Knowledge: Indicates that the information is based on the speaker's cultural background, including myths, traditions, customs, or common knowledge within their culture.
      - examples:
        - 1:
          - lojban: .ia mi pu'o jibni le midju be le terdi .i ka'u kilto leka minli li vo vau leka sraji
          - translation: [belief] I must be getting somewhere near the centre of the earth. Let me see: that would be four thousand miles down, I think—
- se'o:
  - definitions:
    - 1:
      - definition: Internal Experience: Indicates that the information is based on the speaker's internal experience, such as a dream, vision, intuition, or personal revelation, which is not directly accessible to others.
- za'a:
  - definitions:
    - 1:
      - definition: Observation: Indicates that the information is based on the speaker's direct observation or perception using their senses.
      - examples:
        - 1:
          - lojban: za'a do tatpi
          - gloss: [I-observe!] you are-tired.
          - translation: I see you are tired.
- pe'i:
  - definitions:
    - 1:
      - definition: Opinion: Indicates that the statement reflects the speaker's personal opinion or belief.
      - examples:
        - 1:
          - lojban: pe'i la .kartagos. .ei se daspo
          - gloss: [I-opine!] that-named Carthage [obligation] is-destroyed.
          - translation: In my opinion, Carthage should be destroyed.
- ru'a:
  - definitions:
    - 1:
      - definition: Postulation: Indicates that the speaker is making an assumption or postulating something as a basis for further discussion or reasoning. It's similar to saying "Let's assume that..." or "Suppose that..." in English.
      - examples:
        - 1:
          - lojban: ru'a doi .livinston.
          - gloss: [I-presume] o Livingstone.
          - translation: Dr. Livingstone, I presume?
- ju'a:
  - definitions:
    - 1:
      - definition: Statement: A general evidential indicating that the speaker is making a statement without specifying the basis or source of their knowledge. It can also be used when the basis for the statement doesn't fall into any of the other evidential categories.
- ku'i:
  - definitions:
    - 1:
      - type: Commentary on Discourse
      - definition: However/But/In contrast - Signals a contrast or exception to the previous statement or argument. It indicates a shift in direction or a change of perspective.
      - examples:
        - 1:
          - lojban: mi lojbo le ka se cinri la .lojban. vau .i je mi na se bangu la .lojban.
          - translation: I'm a Lojbanic person in that I'm interested in Lojban; I don't speak it.
          - comment: Here, **ku'i** highlights the contrast between being interested in Lojban and not speaking it.
- ji'a:
  - definitions:
    - 1:
      - type: Commentary on Discourse
      - definition: Additionally/Furthermore - Adds weight or provides further support to the previous statement or argument. It indicates a continuation or strengthening of the current line of thought.
      - examples:
        - 1:
          - lojban: lo'e xagji cribe cu citka lo'e cinki ku ji'a sai
          - translation: A hungry bear will eat even insects.
          - comment: ji'a emphasizes that the bear's hunger is so intense that it will eat anything, even insects.
- si'a:
  - definitions:
    - 1:
      - type: Commentary on Discourse
      - definition: Similarly/Likewise - Indicates that the following statement is similar or analogous to the previous one. It suggests a parallel or comparison between two ideas.
- mi'u:
  - definitions:
    - 1:
      - type: Commentary on Discourse
      - definition: Ditto - Repeats the previous statement or idea, often used in lists or tables to avoid redundancy.
- po'o:
  - definitions:
    - 1:
      - type: Commentary on Discourse
      - definition: Uniquely/Only - Indicates that the associated statement is the only relevant or true case. It excludes other possibilities and emphasizes exclusivity.
      - examples:
        - 1:
          - lojban: mi po'o darxi le mi tamne fo le nazbi
          - translation: Only I (nobody else) hit my cousin on his nose.
- va'i:
  - definitions:
    - 1:
      - type: Commentary on Words
      - definition: In other words/Rephrasing - Signals a rephrasing or clarification of the previous statement using different words but retaining the same meaning.
      - examples:
        - 1:
          - lojban: mi se slabu le ctuca .i va'i le ctuca cu slabu mi
          - translation: I am familiar with the teacher. In other words, the teacher is familiar to me.
- va'inai:
  - definitions:
    - 1:
      - type: Commentary on Words
      - definition: Repeating: Indicates that the same idea is being repeated using the same words.
- ta'u:
  - definitions:
    - 1:
      - type: Commentary on Words
      - definition: Expanding a tanru/Making a tanru - Indicates a shift between a concise but potentially ambiguous tanru and its more elaborate and explicit explanation.
- ta'unai:
  - definitions:
    - 1:
      - type: Commentary on Words
      - definition: Making a tanru: Signals the opposite process, where a detailed explanation is being condensed into a shorter tanru.
- ju'o:
  - definitions:
    - 1:
      - type: Commentary on Knowledge
      - definition: Certainly/Uncertain - Expresses the speaker's degree of certainty or uncertainty about the truth of the associated statement.
- ju'onai:
  - definitions:
    - 1:
      - type: Commentary on Knowledge
      - definition: Uncertainty: Indicates a lack of certainty or doubt about the truth of the statement.
- la'a:
  - definitions:
    - 1:
      - type: Commentary on Knowledge
      - definition: Probably/Improbably - Expresses the speaker's assessment of the likelihood or probability of the associated statement being true.
- la'anai:
  - definitions:
    - 1:
      - type: Commentary on Knowledge
      - definition: Improbably: Indicates that the statement is unlikely or improbable.
- ta'o:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: By the way/Returning to point - Signals a digression or aside, often followed by a return to the main topic of discussion.
      - examples:
        - 1:
          - lojban: ca'o se menli jdice fu'e ta'o se rai leka kakne poi se curmi le glare donri noi rinka lonu la .alis. cu lifri leka djica lonu ri sipna kei gi'e bebna fu'o fi le jei lonu pluka fa lonu zbasu lo xrula linsi cu naku naku jalge lo raktu poi nu co'a sanli gi'e crepu lo xrula .icabo suksa fa lonu le pa blabi ractu ku noi se kanla lo xunblabi cu bajra ne'a la .alis.
          - translation: So she was considering in her own mind (as well as she could, for the hot day made her feel very sleepy and stupid), whether the pleasure of making a daisy-chain would be worth the trouble of getting up and picking the daisies, when suddenly a White Rabbit with pink eyes ran close by her.
- ta'onai:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: Returning to point: Indicates a return to the main topic after a digression.
- ra'u:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: Chiefly/Equally/Incidentally - Indicates the relative importance of the associated statement within the discourse.
- ra'ucu'i:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: Equally: Suggests that the statement is of equal importance to other points in the discourse.
- ra'unai:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: Incidentally: Indicates that the statement is of lesser importance or is a side point.
- mu'a:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: For example/Omitting examples/End examples - Introduces examples, signals that examples are being omitted, or marks the end of a series of examples.
- zu'u:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: On the one hand/On the other hand - Presents contrasting viewpoints or alternatives within the discourse.
- ke'u:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: Repeating/Continuing - Indicates that the same idea will be expressed using different words or that the discourse will continue along the same line of thought.
- ke'unai:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: Furthermore: Signals that the content is new and the discourse is moving on to a different idea.
- da'i:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: Supposing/In fact - Marks a hypothetical scenario or supposition, contrasted with a statement of fact.
      - examples:
        - 1:
          - lojban: ganai da'i do viska le mi citno mensi gi ju'o do djuno le du'u ri pazvau
          - translation: If you were to see my younger sister, you would certainly know she is pregnant.
- da'inai:
  - definitions:
    - 1:
      - type: Discourse Management
      - definition: In fact: Emphasizes that the statement is based on reality or actual facts.
      - examples:
        - 1:
          - lojban: ganai da'inai do viska le mi citno mensi gi ju'o do djuno le du'u ri pazvau
          - translation: If you saw my younger sister, you would certainly know she is pregnant.

## COI

### Constructs

- coi:
- co'o:
  - definitions:
    - 1:
      - definition: Partings: Expresses farewell or departure from the listener. It is often translated as "goodbye" or "farewell" and indicates the end of an interaction or the speaker's departure.
      - examples:
        - 1:
          - lojban: co'o .djan.
          - gloss: [partings] John.
          - translation: Goodbye, John.
- coico'o:
  - definitions:
    - 1:
      - definition: Used for greetings in passing, akin to "hello and goodbye" when encountering someone briefly.
- ju'i:
  - definitions:
    - 1:
      - definition: Attention: Calls for the listener's attention and indicates that an important communication follows. Translations include "attention," "listen," "hark," or "behold."
      - examples:
        - 1:
          - lojban: ju'i .djordj. .e'unai le kabri ba zi farlu
          - gloss: [Attention] George, [Warning] the cup [future] [short] falls.
          - translation: George, watch out! The cup's falling!
- nu'e:
  - definitions:
    - 1:
      - definition: Promise: Expresses a promise or commitment made to the listener. It can be used to introduce oaths or formal declarations and is often translated as "I promise."
      - examples:
        - 1:
          - lojban: nu'e .pam. .o'e ro'i do ba zvati
          - gloss: [Promise-to] Pam, [closeness] [emotional] you [future] are-at.
          - translation: I promise you'll be there, Pam honey.
- ta'a:
  - definitions:
    - 1:
      - definition: Interruption: Indicates the speaker's desire to interrupt the current conversation and claim the floor to speak. It can be used for both polite and impolite interruptions and may be translated as "excuse me", "pardon me", or "I interrupt."
      - examples:
        - 1:
          - lojban: ta'a ro zvati be ti
          - gloss: [Interrupt] all at this-place,
          - translation: Sorry to break in, everybody.
- pe'u:
  - definitions:
    - 1:
      - definition: Request: Expresses a polite request or solicitation directed at the listener. It can be translated as "please" and often precedes a request or command.
      - examples:
        - 1:
          - lojban: pe'u .alis.
          - gloss: [Please] Alice,
          - translation: Please, Alice,
- ki'e:
  - definitions:
    - 1:
      - definition: Appreciation/Gratitude: Expresses thanks or appreciation towards the listener. It is commonly translated as "thank you."
      - examples:
        - 1:
          - lojban: ki'e .pam.
          - gloss: [Thanks] Pam.
          - translation: Thanks, Pam.
- fi'i:
  - definitions:
    - 1:
      - definition: Welcome/Offering: Offers hospitality or welcome to the listener. It can be used to invite someone in or make them feel comfortable and translates to phrases like "welcome," "make yourself at home," or "at your service."
      - examples:
        - 1:
          - lojban: fi'i ro zvati
          - gloss: [Welcome-to] all at-place,
          - translation: A cup of coffee for the house, on me.
- be'e:
  - definitions:
    - 1:
      - definition: Request to Send: Indicates the speaker's desire to communicate with someone specific and requests to be connected with them. Often used in telephone conversations and translates to "Can I speak to X?" or "Hello? X, please."
      - examples:
        - 1:
          - lojban: be'e selfu
          - gloss: [Request-to-speak-to] server.
          - translation: Waiter!
- re'i:
  - definitions:
    - 1:
      - definition: Ready to Receive: Signals the speaker's readiness and willingness to receive communication from the listener. It can be used to indicate attentiveness or to acknowledge a call and translates to phrases like "ready to receive," "go ahead," or "I'm listening."
      - examples:
        - 1:
          - lojban: (...) the server says, [end-comment] [Ready-to-receive].
          - translation: The waiter replied, "May I help you?"
- mu'o:
  - definitions:
    - 1:
      - definition: Completion of Utterance: Indicates the completion of the speaker's current utterance and their readiness for a response from the listener. It can be translated as "over" or "go ahead."
- je'e:
  - definitions:
    - 1:
      - definition: Acknowledgement: Acknowledges the successful receipt and understanding of a communication from the listener. It can be used to express agreement, understanding, or acceptance and translates to "roger," "uh-huh," "okay," or "I understand."
      - examples:
        - 1:
          - lojban: je'e
          - gloss: [Acknowledge].
          - translation: Sure
- je'enai:
  - definitions:
    - 1:
      - definition: Negative acknowledgement: Indicates that the message was not received or understood correctly. It can be translated as "what?" or "excuse me?"
- vi'o:
  - definitions:
    - 1:
      - definition: Compliance: Indicates the speaker's understanding of a request and their willingness to comply. It can be translated as "wilco," "okay," or "I understand and will comply."
      - examples:
        - 1:
          - lojban: (...) the server says, [end-comment] [Will-comply]
          - translation: "Gotcha" , said the waiter.
- ke'o:
  - definitions:
    - 1:
      - definition: Repeat Request: Requests the listener to repeat or clarify their previous utterance due to unsuccessful receipt or understanding. It can be translated as "what did you say?" or "come again?"
- mi'e:
  - definitions:
    - 1:
      - definition: serves for self-identification rather than addressing the listener.
### DOI

- doi:
  - definitions:
    - 1:
      - definition: Attention/Address: This is the most general vocative marker, indicating that the speaker is directly addressing the individual(s) mentioned following the **doi**. It serves to attract the attention of the listener and signal that the subsequent utterance is directed towards them.
      - examples:
        - 1:
          - lojban: doi .djan. mi tavla do
          - gloss: O Frank, I speak-to you
          - translation: Frank, I'm talking to you.
        - 2:
          - lojban: doi ma
          - gloss: O [what sumti?]
          - translation: Hey, you!
          - comment: asking for the name or identity of someone

## FAhA

### Description

FAhA cmavo specify the direction of the imaginary journey taken from the speaker to the location of the event described by the bridi. They can be used alone or in combination with VA (distance) and ZAhO (event contour) cmavo to create complex spatial tenses.

### Constructs

- bu'u:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: coincident with: Indicates that the event happens at the same location as the speaker. This is the spatial equivalent of the temporal tense **ca** (present).
      - examples:
        - 1:
          - lojban: le nanmu ca'u vi ni'a va ri'u vu ne'i batci le gerku
          - gloss: The man [front] [short] [down] [medium] [right] [long] [within] bites the dog.
          - comment: Here, **ca'u** indicates that the first leg of the imaginary journey is forward, in front of the speaker.
- ti'a:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: behind: Indicates that the event happens behind the speaker, opposite the direction the speaker is facing.
- zu'a:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: on the left of: Indicates that the event happens to the left of the speaker.
      - examples:
        - 1:
          - lojban: le nanmu zu'a batci le gerku
          - gloss: The man [left] bites the dog.
          - comment: Here, **zu'a** indicates that the event happens to the left of the speaker.
        - 2:
          - lojban: le nanmu zu'avi batci le gerku
          - gloss: The man [left-short-distance] bites the dog.
          - comment: Here, **zu'avi** indicates that the event happens a short distance to the left of the speaker.
- ri'u:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: on the right of: Indicates that the event happens to the right of the speaker.
      - examples:
        - 1:
          - lojban: le verba mo'i ri'u cadzu le bisli
          - gloss: The child [movement] [right] walks-on the ice.
          - comment: Here, **ri'u** combined with **mo'i** indicates that the child is walking towards the speaker's right side.
- ga'u:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: above: Indicates that the event happens above the speaker.
      - examples:
        - 1:
          - lojban: le nanmu ga'u zu'a batci le gerku
          - gloss: The man [up] [left] bites the dog.
          - comment: Here, **ga'u** indicates that the first leg of the imaginary journey is upwards, above the speaker.
- ni'a:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: below: Indicates that the event happens below the speaker.
      - examples:
        - 1:
          - lojban: le nanmu ca'u vi ni'a va ri'u vu ne'i batci le gerku
          - gloss: The man [front] [short] [down] [medium] [right] [long] [within] bites the dog.
          - comment: Here, **ni'a** indicates that the second leg of the imaginary journey is downwards, below a point that is a short distance in front of the speaker.
- ne'i:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: within: Indicates that the event happens inside of something.
      - examples:
        - 1:
          - lojban: le nanmu ca'u vi ni'a va ri'u vu ne'i batci le gerku
          - gloss: The man [front] [short] [down] [medium] [right] [long] [within] bites the dog.
          - comment: Here, **ne'i** indicates that the event happens within something that is far to the right of a point below and in front of the speaker.
- ru'u:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: surrounding: Indicates that the event happens all around the speaker.
- pa'o:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: transfixing: Indicates that the event happens while passing through something.
- ne'a:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: next to: Indicates that the event happens beside something else.
- te'e:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: bordering: Indicates that the event happens at the edge or boundary of something.
- re'o:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: adjacent to: Indicates that the event happens right next to something else, touching it.
- fa'a:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: towards: Indicates movement towards a specific destination.
      - examples:
        - 1:
          - lojban: i la .alis. cu djica lonu ri co'a bartu le manku kumfa gi'e cadzu jbini le va zdani be le carmi xrula be'o jo'u le va lenku ke jetce jinto .i ku'i je la .alis. na ka'e jai zu'e pagre fai le ji'a stedu le kevna .i lu da'i lonu le .ianai mu'anai stedu be mi ka'e pagre to'isa'a se pensi la .uu .alis. toi cu so'u va'e leka prali vau fau lonu na co'e le janco be mi .i .au mi ne tai le'e darvistci ka'e se polje .i pe'i mi da'i ka'e go'i fau lonu mi djuno ledu'u mi ta'i ma kau co'a go'i li'u
          - translation: ...and wander about among those beds of bright flowers and those cool fountains, but she could not even get her head through the doorway...
          - comment: Here, the speaker desires to leave the dark hall and go towards the garden, which is the destination.
- to'o:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: away from: Indicates movement away from a specific origin point.
- zo'i:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: approaching from: Indicates movement towards the speaker or the origin point of the imaginary journey.
- ze'o:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: receding from: Indicates movement away from the speaker or the origin point of the imaginary journey.
- zo'a:
  - definitions:
    - 1:
      - type: direction of the imaginary journey taken from the speaker to the location of the event described by the bridi
      - definition: tangential to: Indicates movement that passes by something without directly approaching or leaving it.
- be'a:
  - definitions:
    - 1:
      - type: absolute or relative directions based on a compass or similar frame of reference
      - definition: north of: Indicates that the event happens to the north of the speaker or the origin point.
      - examples:
        - 1:
          - lojban: tu ve'abe'a fe'e co'a rokci
          - gloss: That-yonder [medium-space-interval-north] [space] [initiative] is-a-rock.
          - comment: Here, **be'a** indicates that the rock extends northward from a point near the speaker.
- ne'u:
  - definitions:
    - 1:
      - type: absolute or relative directions based on a compass or similar frame of reference
      - definition: south of: Indicates that the event happens to the south of the speaker or the origin point.
- du'a:
  - definitions:
    - 1:
      - type: absolute or relative directions based on a compass or similar frame of reference
      - definition: east of: Indicates that the event happens to the east of the speaker or the origin point.
- vu'a:
  - definitions:
    - 1:
      - type: absolute or relative directions based on a compass or similar frame of reference
      - definition: west of: Indicates that the event happens to the west of the speaker or the origin point.

## A

### Constructs

- .enai:
  - definitions:
    - 1:
      - definition: signifies "not both ... and ...". It indicates that at least one of the connected sumti is false, possibly both.
- .o:
  - definitions:
    - 1:
      - definition: Logical Equivalence (if and only if). Signifies a logical equivalence or "if and only if" (biconditional). It indicates that both connected sumti have the same truth value; either both are true or both are false.
      - examples:
        - 1:
          - lojban: la .djan. .o la .alis. klama le zarci
          - gloss: That-named John if-and-only-if that-named Alice goes-to the market.
          - translation: John goes to the market if, and only if, Alice does.
- se .o:
  - definitions:
    - 1:
      - definition: essentially means the same as ".o" because logical equivalence is commutative.
- .onai:
  - definitions:
    - 1:
      - definition: signifies "exclusive or" (XOR). It indicates that the connected sumti have different truth values; one is true, and the other is false.
- .u:
  - definitions:
    - 1:
      - definition: Whether or not. Signifies "whether or not" (implication). It indicates that the truth of the first sumti does not depend on the truth value of the second sumti.
      - examples:
        - 1:
          - lojban: la .djan. nanmu .iju la .djeimyz. ninmu
          - gloss: That-named John is-a-man whether-or-not that-named James is-a-woman.
          - translation: It is true that John is a man, whether or not James is a woman.
- se .u:
  - definitions:
    - 1:
      - definition: essentially reverses the implication, making the truth of the second sumti independent of the truth value of the first.
- .unai:
  - definitions:
    - 1:
      - definition: signifies "neither ... nor ..." but with a focus on the first sumti. It is rarely used due to the availability of ".anai" which is shorter and expresses the same logical meaning.

## BO

### Description

Despite having several meanings particles of class BO never lead to ambiguity since those meanings arise from applying separate parts of the grammar.

### Constructs

- bo:
  - definitions:
    - 1:
      - definition: Joins statements, ensuring a high-precedence grouping.
      - examples:
        - 1:
          lojban: mi klama le zarci .i ca bo do klama le zdani .i ra sipna
          translation: I go to the market when you go home. She sleeps. 
    - 2:
      - definition: Joins tanru units, ensuring a high-precedence grouping
      - examples:
        - 1:
          lojban: ta cmalu bo ractu zdani
          translation: That is a small-rabbit home.
          comment: The first two tanru units are grouped first.
    - 3:
      - definition: Used for bridi tails, ensuring a high-precedence grouping.
      - examples:
        - 1:
          lojban: mi klama le zarci gi'e ca bo citka gi'e pensi
          translation: I go to the market when eating, and I think. 
    - 4:
      - definition: Used for sumti, ensuring a high-precedence grouping.
      - examples:
        - 1:
          lojban: do .e ca bo mi .e ra klama le zarci
          translation: You-and-at-the-same-time-me, and also she go to the market. 
    - 5:
      - definition: Used to attach particles of class NAhE to sumti 
      - examples:
        - 1:
          lojban: na'e bo le prenu cu zvati tu
          translation: Something other than the people are present there. 
    - 6:
      - definition: Used to attach particles of class NAhE to operands in math (mekso) expressions 
      - examples:
        - 1:
          lojban: li na'e bo tau ny. du li pa su'i my.
          translation: other than N is equal to 1 + m. 

## ZAhO

### Description

The cmavo in selma'o ZAhO express the nuances of how an event unfolds over time, capturing aspects like its beginning, continuation, and end. These are often referred to as "event contours."

### Constructs

- pu'o:
  - definitions:
    - 1:
      - definition: Prospective: Indicates the phase of an event before it begins, highlighting anticipation, preparation, or the verge of something happening.
      - examples:
        - 1:
          - lojban: mi pu'o damba
          - gloss: I [prospective] fight
          - translation: I'm on the verge of fighting
- pu'onai:
  - definitions:
    - 1:
      - definition: the event is not about to begin, is already in progress, or has already happened.
- ca'o:
  - definitions:
    - 1:
      - definition: Continuitive: Indicates the phase of an event while it is in progress, emphasizing its ongoing nature, duration, or continuation.
      - examples:
        - 1:
          - lojban: la .stiv. ca'o bacru
          - gloss: That-named Steve [continuitive] utters
          - translation: Steve continues to talk
- ca'onai:
  - definitions:
    - 1:
      - definition: the event is not ongoing; it might be about to begin, has just ended, or happened at a specific point in time.
- ba'o:
  - definitions:
    - 1:
      - definition: Retrospective: Indicates the phase of an event after it has ended, emphasizing its aftermath, or the fact that it no longer occurs.
      - examples:
        - 1:
          - lojban: le verba ba'o cadzu le bisli
          - gloss: The child [retrospective] walks-on the ice
          - translation: The child is no longer walking on the ice
- ba'onai:
  - definitions:
    - 1:
      - definition: the event is not over; it might be ongoing, about to begin, or happening at a specific point in time.
- co'a:
  - definitions:
    - 1:
      - definition: Initiative: Indicates the starting point of an event, the precise moment when it begins or transitions from not happening to happening.
      - examples:
        - 1:
          - lojban: mi ba co'a citka le mi sanmi
          - gloss: I [future] [initiative] eat the associated-with-me meal.
          - translation: I will begin to eat my meal.
- co'u:
  - definitions:
    - 1:
      - definition: Cessitive: Indicates the ending point of an event, the precise moment when it stops or transitions from happening to not happening.
      - examples:
        - 1:
          - lojban: mi pu co'u citka le mi sanmi
          - gloss: I [past] [cessitive] eat the associated-with-me meal.
          - translation: I ceased eating my meal.
- co'unai:
  - definitions:
    - 1:
      - definition: the event did not stop at the specified point; it might be ongoing, about to begin, or happening at a specific point in time.
- mo'u:
  - definitions:
    - 1:
      - definition: Completitive: Indicates the natural ending point of an event, the point at which it is considered finished or complete, regardless of whether it actually stops.
      - examples:
        - 1:
          - lojban: mi pu mo'u citka le mi sanmi
          - gloss: I [past] [completitive] eat the associated-with-me meal.
          - translation: I finished eating my meal.
- za'o:
  - definitions:
    - 1:
      - definition: Superfective: Indicates that an event continues beyond its natural ending point, emphasizing excessiveness, going too far, or doing something for longer than necessary.
      - examples:
        - 1:
          - lojban: le ctuca pu za'o ciksi le cmaci seldanfu le tadgri
          - gloss: The teacher [past] [superfective] explained the mathematics problem to-the student-group.
          - translation: The teacher kept on explaining the mathematics problem to the class too long.
- co'i:
  - definitions:
    - 1:
      - definition: Achievative: Treats an entire event as a single, indivisible point in time, often used to emphasize the moment of completion or achievement.
      - examples:
        - 1:
          - lojban: la .djan. pu co'i catra la djim
          - gloss: That-named John [past] [achievative] kills that-named Jim.
          - translation: John was at the point in time where he killed Jim.
- de'a:
  - definitions:
    - 1:
      - definition: Pausative: Indicates the point in time just before an interruption in a process, highlighting a temporary pause or suspension with the intention of resuming.
      - examples:
        - 1:
          - lojban: mi pu de'a citka le mi sanmi
          - gloss: I [past] [pausative] eat the associated-with-me meal.
          - translation: I stopped eating my meal (with the intention of resuming).
- di'a:
  - definitions:
    - 1:
      - definition: Resumptive: Indicates the point in time just after an interruption in a process, highlighting the resumption or continuation of a paused activity.
      - examples:
        - 1:
          - lojban: mi ba di'a citka le mi sanmi
          - gloss: I [future] [resumptive] eat the associated-with-me meal.
          - translation: I will resume eating my meal.
- ca'o co'a:
  - definitions:
    - 1:
      - definition: the ongoing beginning of an event
- pu'o co'a:
  - definitions:
    - 1:
      - definition: highlights the point just before an event is about to start.
