## Lektion 9. Logische Konjunktionen

Logische Konjunktionen im Lojban basieren auf 4 primitiven: **.a**, **.e**, **.o**, **.u**. In dieser Lektion werden wir sie im Detail behandeln.

### Logische Konjunktionen für Argumente

Hier sind die Konjunktionen, die zwei Wörter kombinieren: _dies_ und _das_.

- **ti .a ta** = _dies und/oder das_

 > **mi ba vitke le mamta .a le tamne**
 >_Ich werde die Mutter oder den Cousin besuchen._
 
 Beachten Sie, dass **.a** auch als _mindestens einer der beiden Werte_ übersetzt werden kann und somit die Möglichkeit offen lässt, dass ich irgendwann beide besuchen werde.

- **ti .e ta** = _dies und das_

 > **mi ralte le pa gerku .e le re mlatu**
 >_Ich habe einen Hund und zwei Katzen._
 >`Ich halte einen Hund und zwei Katzen.`

- **ti .o ta** = _entweder dies und das, oder keines_

 > **mi ba vitke le mamta .o le tamne**
 >_Ich werde entweder sowohl die Mutter als auch den Cousin besuchen, oder keinen von beiden._

 Beachten Sie, dass **.o** auch als _nicht einer der beiden Werte_ übersetzt werden kann und somit bedeutet, dass ich entweder beide besuchen werde oder keinen.

- **ti .u ta** = _dies, und vielleicht das_, _dies, ob das oder nicht_

 > **mi ba vitke le mamta .u le tamne**
 >_Ich werde die Mutter besuchen, ob ich den Cousin besuche oder nicht._

 **.u** betont nur, dass der zweite Wert die Wahrheit des Satzes nicht beeinflusst.

Das Platzieren von **nai** nach einer Konjunktion negiert, was rechts davon steht. Das Platzieren von **na** vor einer Konjunktion negiert, was links davon steht:

- **ti .e nai ta** = _dies und nicht das_

 > **mi nelci la .bob. e nai la .alis.**
 >_Ich mag Bob, aber nicht Alice._
 >`Ich mag Bob und nicht Alice`

 Wir können auch **ti .e nai ku'i ta** (_dies aber nicht das_) sagen, um dem zweiten Argument einen Kontrast zu verleihen.

- **ti na .e ta** = _nicht dies, aber das_

 > **mi nelci la .alis. na .e la .bob.**
 >_Ich mag Alice nicht, aber ich mag Bob._
 >`Ich mag Alice nicht und Bob`

 Das mag für englische Sprecher etwas seltsam klingen (`I like Alice not…`), daher bevorzugen Sie vielleicht, die Argumente zu tauschen und stattdessen **.e nai** zu verwenden: **mi nelci la .bob. e nai la .alis.** oder sogar **mi nelci la .bob. i mi na ku nelci la .alis.** wird dasselbe bedeuten.

- **ti na .e nai ta** = _weder dies noch das (keines)_

 > **mi nelci la .alis. na .e nai la .bob.**
 > _Ich mag weder Alice noch Bob_

Das Verneinen mit anderen primitiven Konjunktionen mag nicht intuitiv benutzbar erscheinen, man kann sie einfach aus Beispielen lernen:
- **ti .a nai ta** = _dies wenn das_, _für dies ist die ausschließliche Bedingung, dass das passiert_

 > **mi ba vitke le mamta .a nai le tamne**
 > _Ich werde die Mutter besuchen, aber dafür muss ich den Cousin besuchen._

 Somit bedeutet **ti .a nai ta**, dass **ta** notwendig ist (aber nicht die einzige Bedingung sein kann), damit **ti** angewendet wird.

- **ti .o nai ta** = _entweder dies oder das_

 > **mi ba vitke le mamta .o nai le tamne**
 > _Ich werde entweder die Mutter oder den Cousin besuchen._

 **.o nai** kann auch als _genau eines von beiden Werten_ übersetzt werden.

 Wenn ich sagen möchte, dass ich entweder die Mutter oder den Cousin besuchen werde, aber nicht beide, brauche ich **.o nai** (_entweder/oder_). Es ist anders als **.a** (_und/oder_), wo ich beide besuchen kann.

- **ti na .u ta** = beeinflusst nicht _(nicht dies, aber vielleicht das)_
- **ti na .u nai ta** = beeinflusst nicht _(nicht dies, aber vielleicht das)_

- **ti se .u ta** = _vielleicht dies, und das_
- **ti se .u nai ta** = _vielleicht dies, aber nicht das_

<!-- **se** wird nur für **.u** verwendet, da es in anderen Fällen keine Auswirkung auf die Bedeutung hat. -->

Diese werden zum Verbinden von Argumenten verwendet. Zum Verbinden von Teilen zusammengesetzter Relationen verwenden wir ähnliche Konjunktionen: **ja**, **je**, **jo**, **ju**. Anstelle des Punktes (Pause) verwenden wir hier **j**.

<!-- Es ist üblich, **ja**, **je**, **jo**, **ju** auch zum Verbinden von Argumenten zu verwenden. -->

### Logische Konjunktionen für Sätze

Dies ist eine prägnantere Art zu sagen:

> **mi ralte le pa gerku .i je mi ralte le re mlatu**
> _Ich habe einen Hund, und ich habe zwei Katzen._

**.i je** verbindet zwei Sätze mit einem logischen _und_, was zeigt, dass beide Sätze Teil eines Gedankens sind und wahr sind.

Hier sind Beispiele für andere Konjunktionen für Sätze:

> **la .rome'os. cu prami la .djuliet. i je la .djuliet. cu prami la .rome'os.**
> _Romeo liebt Julia, <u>und</u> Julia liebt Romeo._

Dies bedeutet, dass beide Aussagen wahr sind, d.h., Romeo und Julia lieben sich.

Dasselbe gilt für andere Konjunktionen:

> **la .rome'os. cu prami la .djuliet. i ja la .djuliet. cu prami la .rome'os.**
> _Romeo liebt Julia, und/oder Julia liebt Romeo._

Dies bedeutet, dass einer von ihnen den anderen liebt, und vielleicht tun es beide.

> **la .rome'os. cu prami la .djuliet. i jo nai la .djuliet. cu prami la .rome'os.**
> _Entweder Romeo liebt Julia oder Julia liebt Romeo._

Hier liebt entweder Romeo Julia (aber Julia liebt ihn nicht), oder Julia liebt Romeo (aber er liebt sie nicht).

> **la .rome'os. cu prami la .djuliet. i ja nai la .djuliet. cu prami la .rome'os.**
> _Damit Romeo Julia liebt, ist es notwendig, dass Julia Romeo liebt._

Dies bedeutet, dass wenn Julia Romeo liebt, er sie definitiv liebt, aber er könnte sie trotzdem lieben (das einzige unmögliche Ergebnis ist, dass Julia Romeo liebt, aber er sie nicht liebt).

> **la .rome'os. cu prami la .djuliet. i jo la .djuliet. cu prami la .rome'os.**
> _Entweder Romeo liebt Julia und Julia liebt Romeo, oder keines der beiden Ereignisse tritt ein._

Dies bedeutet, dass wenn Julia Romeo liebt, er sie liebt, und wenn sie ihn nicht liebt, liebt er sie nicht.

> **la .rome'os. cu prami la .djuliet. i ju la .djuliet. cu prami la .rome'os.**
> _Romeo liebt Julia, egal ob Julia Romeo liebt oder nicht._

Beachten Sie, wie wir den Namen "Romeo" lojbanisieren: die Kombination "eo" ist im Lojban unmöglich, also haben wir "e'o" verwendet und einen Konsonanten am Ende seines Namens hinzugefügt.

Beachten Sie, dass **da** sich auf dieselbe Entität bezieht, wenn mehrere Sätze verbunden sind.

### Logische Konjunktionen innerhalb zusammengesetzter Relationen

> **le melbi xunre fonxa**
> _schön rot Telefone_

<!-- -->

> **le melbi je xunre fonxa**
> _schöne und rote Telefone_

Andere Konjunktionen machen ebenfalls Sinn:

> **mi nelci ro tu voi xajmi ja melbi prenu**
> _Ich mag alle Personen, die lustig oder gutaussehend sind (oder beides)._

<!-- -->

> **mi nelci ro tu voi xajmi jo nai melbi prenu**
> _Ich mag alle Personen, die entweder lustig oder schön sind._

Dies könnte erklärt werden, wenn ich zum Beispiel die Eigenschaften Humor und gutes Aussehen für unvereinbar halte, d.h., eine Mischung aus beidem wäre einfach zu viel.

> **mi nelci ro tu voi xajmi ju melbi nanmu**
> _Ich mag alle Personen, die lustig sind (ob schön oder nicht)._

Und noch einmal, wir sollten den Unterschied zwischen dem Verbinden von Argumenten und dem Verbinden von Teilen zusammengesetzter Relationenkonstrukte nicht vergessen:

> **mi ba vitke le pa pendo .e le pa speni**
> _Ich werde einen Freund und einen Ehepartner besuchen._

<!-- -->

> **mi ba vitke le pa pendo je speni**
> _Ich werde einen Freund-und-Ehepartner besuchen._

Der letzte Lojban-Satz bedeutet, dass der Freund auch ein Ehepartner ist.

### Logische Konjunktionen für Relationenschwänze

> **pu ku mi uantida la .soker. gi'e klama le zdani gi'e citka le badna**
> _Ich habe Fußball gespielt, bin nach Hause gegangen, habe die Banane gegessen._

uantida
: nicht-offizielle Relation: $x_1$ spielt das Spiel $x_2$, nimmt am Spiel $x_2$ teil

**gi'e** verbindet mehrere Relationen zu einer mit einigen gemeinsamen Begriffen. Schauen Sie sich das an: Es erweitert sich zu **pu ku mi kelci la .soker. i je pu ku mi klama le zdani** … was länger wäre.

Mit **gi'e** halten wir den Kopf der Relation konstant und spezifizieren Begriffe nach jedem Relationenkonstrukt (**kelci la .soker.**, **klama le zdani** …).

Wenn wir also **gi'e** verwenden, haben wir mehrere Relationen im Schwanz, die zusammengefügt sind, aber einen gemeinsamen Kopf haben.

**gi'e** hat denselben Endvokal wie **je** und bedeutet daher _und_.

Andere Konjunktionen zum Verbinden von Relationenschwänzen:

- **gi'a** für _und/oder_
- **gi'o nai** für _entweder … oder_
- **gi'u** für _ob oder nicht_ usw.

Diese Konjunktionen haben dasselbe Ende wie diejenigen in der **.a**, **.o**, **.u** Serie.

### Begriffe in Sätzen mit mehreren Schwänzen

Beachten Sie, dass Zeitformen als Begriffe und Zeitformen, die an die Hauptrelation der Relation angehängt sind, einen Unterschied machen, wenn sie auf Sätze angewendet werden, die mehrere angehängte Relationen enthalten:

- Ein Begriff im Kopf des Satzes wird auf alle seine Schwänze angewendet:

 >**mi ba'o cu citka le badna gi'e pinxe**
 >_Ich esse die Banane nicht mehr und trinke nicht mehr._

 Hier wird **ba'o** auf **citka le badna gi'e pinxe** angewendet.

- Ein Zeitwort, das Teil der Relation ist, wird nur auf diese Relation angewendet:

 >**mi ba'o citka le badna gi'e pinxe**
 >_Ich esse die Banane nicht mehr, aber ich trinke._

Hier wird **ba'o** nur auf die implizierte **mi citka le badna**-Beziehung angewendet, aber nicht auf die implizierte **mi pinxe**-Beziehung.

### Auswahlfragen

Eine andere Art von englischem "or" findet sich in Fragen:

> **— xu do pinxe le tcati .o nai le ckafi?**
> **— pinxe**
> _— Wirst du Tee oder Kaffee trinken?_
> _— Ja._

Das ist eine eigenartige, aber vollkommen vernünftige Antwort: _Ja, ich werde Tee oder Kaffee trinken._

Das passiert, weil "or" im Englischen mehrere Bedeutungen hat:

1. _A or B_ kann bedeuten _entweder A oder B, aber nicht beides_. Wir verwenden hier **.o nai**.
2. _A or B_ kann bedeuten _A oder B oder beides_. Wir verwenden hier **.a**.
3. _A or B?_ kann eine Frage sein, die bedeutet _wähle zwischen A und B, welches wählst du?_ Wir verwenden hier **ji**.

Daher verwenden wir im letzten Fall eine separate Fragekonjunktion **ji**:

> **— do pinxe le tcati ji le ckafi?**
> _— Wirst du Tee oder Kaffee trinken?_

Mögliche Antworten:

> **le tcati .e le ckafi**
> _Tee und Kaffee._

<!-- -->

> **le tcati**
> _Tee._

<!-- -->

> **le ckafi**
> _Kaffee._

Es ist auch möglich, Konjunktionen bei der Antwort zu verwenden:

> **.e** — <span>_Beides_ (das erste und das zweite Element wird gewählt)</span>

<!-- -->

> **.e nai** — <span>_Das erste (Tee)_ (das erste, aber nicht das zweite wird gewählt)</span>

<!-- -->

> **na .e** — <span>_Das zweite (Kaffee)_ (nicht das erste, aber das zweite wird gewählt)</span>

<!-- -->

> **na .e nai** — <span>_Keines_ (weder das erste noch das zweite wird gewählt)</span>

Man kann auf die gleiche Weise Fragen zu den anderen Arten von Konjunktionen stellen, die wir betrachtet haben. Die Fragekonjunktion für Relation-Enden ist **gi'i**, für zusammengesetzte Relationen — **je'i**, für Sätze — **.i je'i**.

Indirekte Fragen werden durch die Verwendung von **ji kau** erreicht:

Angenommen, der Kellner fragt einen Besucher

> **- le'e dembi ji le'e rismi**
> _- Die Bohnen oder den Reis?_

Sobald der Besucher antwortet, weiß der Kellner, ob der Besucher Lamm oder Rindfleisch essen möchte:

> **ba le nu le vitke cu spusku kei le bevri cu djuno le du'u le vitke cu djica le nu ri citka le'e dembi ji kau le'e rismi**
> _Nachdem der Besucher antwortet, weiß der Kellner, ob der Besucher die Bohnen oder den Reis essen möchte._

### Vorangestellte Konjunktionen

> **ge do gi mi**
> _sowohl du als auch ich_

<!-- -->

> **ge nai do gi mi**
> _Nicht du, sondern ich_

<!-- -->

> **ge do gi nai mi**
> _Du, aber nicht ich_

<!-- -->

> **go nai do gi mi**
> _Entweder du oder ich_

Die vorangestellte Konjunktion **ge** bedeutet _und_, wird aber vor dem ersten Argument platziert, wobei **gi** die beiden Argumente trennt. Diese Serie ist parallel zu anderen Konjunktionen: **ga**, **ge**, **go**, **gu**, sowie **ga nai**, **ge nai**, **go nai**, usw. Der Separator **gi** ist für alle gleich.

Die Verwendung dieser Konjunktionen ist eine Frage der Bequemlichkeit:

> **mi citka ge nai le badna gi le plise**
> _Ich esse nicht die Banane, sondern den Apfel._

Hier wird, wie im Englischen, _nicht_ vor dem ersten Argument angegeben.

**ge** und Wörter dieser Serie können auch zur Verbindung von Relationen verwendet werden:

> **ge mi dansu gi mi zgipli le pipno**
> _Ich tanze und spiele Klavier._

zgipli
: $x_1$ spielt Musikinstrument $x_2$

le pipno
: Klavier

> **.i ga nai pu zi carvi gi ca cilmo**
> _Wenn es kürzlich geregnet hat, ist es jetzt nass._
