## Lektion 8. Begriffe und Mathematik

### ‘_Möglicherweise kann_’, ‘_haben gewesen_’ und ‘_noch nicht gewesen_’

<pixra url="/assets/pixra/cilre/kahe_vofli.webp" caption="le cipni ka'e vofli" definition="Der Vogel kann möglicherweise fliegen."></pixra>

> **le'e cipni ka'e vofli**
> _Vögel können fliegen._

<!-- -->

> **le pendo be mi ca'a xendo prenu**
> _Mein Freund zeigt sich als freundliche Person._

<!-- -->

> **le pendo be mi ka'e litru bu'u ro da**
> _Ein Freund von mir kann an jedem Ort reisen._

<!-- -->

> **mi ca'a zvati la .madrid.**
> _Ich bin in Madrid._

<!-- -->

> **mi pu'i zvati la .madrid.**
> _Ich war in Madrid._

<!-- -->

> **mi nu'o zvati la .madrid.**
> _Ich war noch nie in Madrid._

ka'e
: Begriff der Möglichkeit: möglicherweise kann

ca'a
: Begriff der Möglichkeit: tatsächlich ist

pu'i
: Begriff der Möglichkeit: ist bereits passiert

nu'o
: Begriff der Möglichkeit: ist noch nie passiert

Diese Reihe von sogenannten Begriffen der Möglichkeit beschreibt mögliche Situationen.

Beachte, dass **ka'e** bedeutet, dass ein Ereignis passieren kann, während zum Beispiel,

> **le'e cipni cu kakne le ka vofli**
> _Vögel sind fähig zu fliegen._

Fähigkeiten beschreibt, die von den Handlungen der Teilnehmer abhängen.

### ‘_Plus_’ und ‘_minus_’

<!-- -->

> **li mu du li re su'i ci**
> _Fünf ist gleich zwei plus drei._

**li**, das wir früher gesehen haben, ist ähnlich wie **le**, aber es beginnt einen mathematischen Ausdruck (oder nur eine Zahl oder einen Zeitstempel).

Beachte, dass **li re su'i ci** (_2+3_) als ein einziger Ausdruck betrachtet wird und als ein Argument behandelt wird.

**du** ist ein Relationswort und bedeutet _… ist gleich …_.

- **su'i** bedeutet _plus_.
- **vu'u** bedeutet _minus_.
- **pi'i** bedeutet _mal_ und wird für die Multiplikation verwendet.
- **fe'i** bedeutet _geteilt durch_ und wird für die Division verwendet.

**pi** ist ein Dezimaltrennzeichen, also bedeutet **no pi mu** _0,5_, und **ci ze pi pa so** bedeutet _37,19_.

In einigen Notationen kann 0,35 als .35 geschrieben werden, und in Lojban können wir die Null auch weglassen, indem wir **pi mu** sagen.

Hier sind einige andere Beispiele:

> **li pare fe'i ci du li vo**
> _12 : 3 = 4._

<!-- -->

> **li re pi'i re du li vo**
> _zwei mal zwei ist vier_

<!-- -->

> **li pano vu'u mu pi'i re du li no**
> _10 — 5 ⋅ 2 = 0._

Beachten Sie, dass Sie **li** nur einmal vor der Gleichung und einmal danach setzen. Somit wird _12 : 3_ als eine Zahl betrachtet. Tatsächlich ist _4_ dasselbe wie _12 : 3_. Beide sind Zahlen.

Um nach einer Zahl zu fragen, verwenden wir **ma**:

> **li ci su'i vo du ma**
> _3 + 4 = ?_

<!-- -->

> **li ze**
> _7_

### ‘_erste_ — «**pa moi**», ‘_zweite_’ — «**re moi**», ‘_letzte_’ — «**ro moi**»

Ordnungszahlen wie _erste_, _zweite_ und _dritte_ werden verwendet, um Elemente in eine Reihenfolge zu bringen. Im Lojban werden sie gebildet, indem eine Zahl gefolgt von **moi** hinzugefügt wird:

pa moi
: $x_1$ ist der Erste unter $x_2$ (Menge)

re moi
: $x_1$ ist der Zweite unter $x_2$ (Menge)

ci moi
: $x_1$ ist der Dritte unter $x_2$ (Menge)

…

ro moi
: $x_1$ ist der Letzte unter $x_2$ (Menge)

Beziehungen können auch anstelle von Zahlen verwendet werden:

me mi moi
: $x_1$ ist meiner

me do moi
: $x_1$ ist deiner

In diesem Fall mussten wir Pronomen in Beziehungen umwandeln, indem wir **me** verwenden.

> **le prenu cu pa moi le'i se prami be mi**
> _Er ist meine erste Liebe._

<!-- -->

> **tu ro moi le'i ratcu pe mi**
> _Das ist meine letzte Ratte._

<!-- -->

> **le cerni tarci cu ro moi le'i tarci poi cumki fa le nu viska ke'a pu le nu co'a donri**
> _Der Morgenstern ist der letzte Stern, der vor dem Anbruch des Tages sichtbar ist._

<!-- -->

> **tu me mi moi**
> _Das ist meiner._

<!-- -->

> **tu me mi moi le'i stizu**
> **tu me mi moi stizu** (unter Verwendung einer zusammengesetzten Beziehung zur Kürze)

> _Das ist mein Platz._

<!-- -->

> **.i ti voi stizu cu me mi moi le'i pa ci stizu poi jibni le jubme**
> _Dieser Platz ist meiner unter den 13 Plätzen in der Nähe des Tisches._

Kardinalzahlen werden vor Ordnungszahlen in einer Zeichenkette platziert und durch **boi** getrennt:

> **le ci boi pa moi be le'i kabri pe le ckafi**
> _die ersten drei Tassen Kaffee_

Ohne **boi** würde es zu **ci pa moi** — _einunddreißigste_.

### «**gau**» — lass sie es tun

Der Begriff **gau** kennzeichnet den Agenten eines Ereignisses:

> **le canko cu kalri**
> _Das Fenster ist offen._

<!-- -->

> **le canko gau do kalri**
> _Du öffnest das Fenster._
> `Das Fenster getrieben von dir ist offen`

gau
: modaler Begriff: verursacht durch … (Agent), getrieben von … (jemand, ein Objekt)

kalri
: $x_1$ ist offen

So können Verben wie _etwas öffnen_ und _etwas bewegen_ umformuliert werden zu _etwas offen machen_ und _etwas bewegen machen_. Daher müssen wir keine zusätzlichen Verben für jede solche Bedeutung lernen. Stattdessen fügen wir immer den Begriff **gau** hinzu.

Es gibt auch eine andere Methode, die die gleiche Wortreihenfolge wie im Englischen beibehält:

> **le canko gau ko kalri**
> **ko jai gau kalri fai le canko**
> _Öffne das Fenster!_

Hier verwandeln wir die Beziehung **kalri** — _offen sein_ in eine neue Beziehung:

jai gau kalri
: etwas öffnen

Der erste Platz von **kalri** kann durch die Verwendung eines Platz-Tags **fai** angezeigt werden.

Einige weitere Variationen:

> **le pa karce cu muvdu**
> _Das Auto bewegt sich._

<!-- -->

> **ko jai gau muvdu fai le karce**
> **le karce gau ko muvdu**
> _Bewege das Auto! Mach das Auto bewegen!_

<!-- -->

> **le karce cu muvdu ti**
> **fa le karce cu muvdu fe ti**
> _Das Auto bewegt sich hierher._

<!-- -->

> **ko jai gau muvdu fai le karce fe ti**
> _Bewege das Auto hierher!_

**muvdu** — _bewegt sich zu einem Ort_ wird in eine neue Beziehung **jai gau muvdu** — _etwas oder jemanden zu einem Ort bewegen_ umgewandelt.

muvdu
: $x_1$ bewegt sich zu $x_2$ von $x_3$ über $x_4$

jai gau muvdu fai le karce
: $x_1$ bewegt das Auto zu $x_2$ von $x_3$ über $x_4$

> **la .alis. cu klama**
> _Alice kommt._

<!-- -->

> **la .alis. gau ko klama**
> _Mach, dass Alice kommt!_

### ‘_Warum_?’ — «**ri'a**», «**ni'i**», «**mu'i**», «**ki'u**»

> **- ri'a ma carvi**
> _- Warum regnet es?_

> **- le nu le dilnu ca klaku**
> _- Weil die Wolken weinen._

ri'a
: modaler Begriff: wegen … (eines Ereignisses)

ri'a ma
: warum?

klaku
: $x_1$ weint

Im Gegensatz zu **gau** erwartet der Begriff **ri'a** keinen Agenten, sondern ein Ereignis, wie _die Wolken weinen_:

> **le dilnu cu klaku ri'a le nu le dargu cu cilmo**
> _Der Himmel weint, was zur nassen Straße führt._

_Daher_ ist das umgekehrte Wort zu _weil_:

> **le dilnu cu klaku .i se ri'a bo le dargu cu cilmo**
> _Der Himmel weint. Daher ist die Straße nass._

**cilmo**
: … ist nass

Eine andere Art von _warum_ ist **ni'i**:

> **- ni'i ma nicte**
> **- le nu le solri na ku te gusni**
> _- Warum ist es Nacht?_
> _- Weil die Sonne nicht scheint._

<!-- -->

> **le solri na ku te gusni .i se ni'i bo nicte**
> _Die Sonne scheint nicht. Daher ist es Nacht._

**ni'i**
: modaler Begriff: logisch wegen …

**se ni'i**
: modaler Begriff: mit der logischen Konsequenz, dass …, logisch daher

Hier können wir **ri'a** nicht verwenden, da wir nicht über ein Ergebnis, sondern über eine logische Implikation sprechen. Die Tatsache, dass es Nacht ist, folgt logisch daraus, dass die Sonne nicht scheint.

> **mi darxi la .kevin. mu'i le nu ky. lacpu le kerfa be mi**
> _Ich habe Kevin geschlagen, weil er an meinen Haaren gezogen hat._

**mu'i**
: Begriff: weil (aus Motiv …)

In diesem Beispiel haben wir nicht zwei physisch verbundene Ereignisse, wie Wolken und Regen, sondern drei Ereignisse:

1. Kevin zieht an meinen Haaren.
2. Ich entscheide mich infolgedessen, Kevin zu schlagen.
3. Ich schlage Kevin.

Im Englischen wird das zweite Ereignis weggelassen und es heißt _Sally hit Joey because he pulled her hair._ Dies ist jedoch nicht nur vage, sondern, wie manche sagen würden, psychologisch gefährlich. Menschen reagieren im Allgemeinen nicht automatisch auf Reize, sondern aufgrund von Motivation, und die Verwechslung komplexer Reaktionen mit einfacher physischer Verursachung kann uns glauben lassen, dass wir keine Kontrolle über unsere Emotionen oder sogar unsere Handlungen haben. Daher ist es oft nützlich, nicht nur physische Reaktionen (**ri'a**) zu sagen, sondern Reaktionen zu betonen, die ein kognitives/emotionales Element haben (**mu'i**).

> **le ctuca pu plicru la .ben. le jemna ki'u le nu by. pu zabna gunka**
> _Der Lehrer gab Ben das Juwel als Geschenk, weil er gut gearbeitet hat._

**le ctuca**
: der Lehrer

**le jemna**
: das Juwel

zabna
: $x_1$ ist cool, nett

gunka
: $x_1$ arbeitet

ki'u
: modaler Begriff: weil (aufgrund der Erklärung …)

Der Unterschied zwischen Motivation und Rechtfertigung ist nicht immer klar, aber wir können sagen, dass Rechtfertigung eine Regel oder einen Standard beinhaltet, während Motivation dies nicht erfordert. Vergleichen:

> **le ctuca pu plicru la .ben. le jemna ki'u le nu by. pu zabna gunka**
> _Der Lehrer gab Ben das Juwel als Geschenk, motiviert durch seine gute Arbeit._

This says only that Ben's hard work motivated the teacher to give him the gem, whereas with **ki'u**, we might imply that it is the custom for teachers to give gems as a reward for good work.

Note: Don't get **ki'u** mixed up with **ku'i**, which means _but, however_.

**ki'u** appeals to more general considerations than **mu'i**, but it still deals with human standards, not logical laws. Only a very naive student would believe that if a student is given a gem, it must logically imply that the student has worked nicely.

Im Falle von **ni'i ma nicte**, jedoch, die Tatsache, dass die Sonne nachts nicht scheint, impliziert logisch, dass die Sonne nicht scheint. Hier können wir sicher **ni'i** verwenden.

### ‘_So … that_’

Der Ausdruck _so … that_ wird im Lojban ausgedrückt, indem der Satz in zwei Teile geteilt wird:

> **mi tai galtu plipe .i ja'e bo mi farlu**
> _I jumped so high that I fell down._

ja'e
: Modalterm: mit dem Ergebnis von …

tai
: Modalterm: in der Art von …

Weitere Beispiele:

> **mi tai zukte**
> _I act this way_

<!-- -->

> **mi tai fengu**
> _I am so angry._

fengu
: $x_1$ ist wütend auf $x_2$ (Klausel) für Handlung $x_3$ (Eigenschaft von $x_2$)

### ‘_If … then_’

> **ba ku fau le nu do cizra kei mi prami do**
> _If you are strange then I'll love you._

fau
: Modalterm: mit dem Ereignis von …, unter Umständen …, gleichzeitig mit …

**fau** ist sehr ähnlich wie **ca** (_wenn_) oder **bu'u** (_an (einem Ort)_).

In vielen Fällen können wir **fau** durch **ca** ersetzen, um fast die gleiche Bedeutung zu erhalten (manchmal präziser):

> **mi ba prami do ca le nu do cizra**
> _I'll love you when you are strange._

Wir können **le** durch **ro lo** in solchen Ausdrücken ersetzen und erhalten eine neue Bedeutung:

> **mi ba prami do ca ro lo nu do cizra**
> _I'll love you whenever you are strange._

### «**fau**» und «**da'i**». ‘_What if …_’

> **da'i mi turni**
> _I could be a governor._

<!-- -->

> **da'i nai mi turni**
> _I am a governor._

- Die Interjektion **da'i** markiert die Beziehung, in der sie steht, als Beschreibung eines imaginären Ereignisses.
- Die gegenteilige Interjektion **da'i nai** markiert die Beziehung als Beschreibung eines tatsächlichen, realen Ereignisses.

Konstruktionen mit **da'i** werden im Englischen normalerweise mit Hilfsverben wie _can/could, will/would, may/might, should_ und _must_ übersetzt. Beziehungen, die im Englischen mit **da'i** markiert sind, werden als _subjunctive mood_ bezeichnet.

Das Weglassen von **da'i** oder **da'i nai** macht den Satz nur aus dem Kontext klar, was normalerweise ziemlich transparent ist. Deshalb ist **da'i** oder **da'i nai** nicht obligatorisch. Wir verwenden es zur Klarstellung, wenn nötig.

Beziehungen mit **da'i** können den Begriff mit **fau** enthalten:

> **da'i mi gleki fau le nu mi ponse le rupnusudu be li pa ki'o ki'o**
> _I would/could be happy if I had one million dollars._

fau
: mit dem Ereignis von …

rupnusudu
: $x_1$ kostet $x_2$ (Zahl) US-Dollar

pa ki'o ki'o
: 1 Million

> **mo da'i fau le nu mi cusku lu ie nai li'u**
> _What if I say "no"?_

Hier wird das Ereignis innerhalb von **fau** zusammen mit **mi gleki** gleichermaßen vorgestellt. Und hier ist das umgekehrte Beispiel:

> **da'i nai mi gleki fau le nu mi ponse le rupnusudu be li pa ki'o ki'o**
> _Having one million dollars, I am happy._

In vielen Fällen kann das Wort **fau** sicher durch **ca** (_zur gleichen Zeit wie …_) ersetzt werden:

> **da'i nai mi gleki ca le nu do klama**
> _I'm happy when you come._

Andere Präpositionen können bei Bedarf verwendet werden:

> **da'i mi denpa ze'a le nu do limna**
> _I would wait while you took a swim._

denpa
: $x_1$ wartet auf $x_2$ (Ereignis)…

ze'a
: durch eine gewisse Zeit, für eine Weile, während …

limna
: $x_1$ schwimmt

### Wahrscheinlichkeiten

Angenommen, du kommst nach Hause und hörst jemanden kratzen. Du kannst einen der folgenden Sätze sagen:

> **fau su'o da tu mlatu**
> **fau da tu mlatu**
> _This might be/possibly is a cat. It is possible that this is a cat._
> (Du hast mehrere Tiere zu Hause. Es könnte also deine Katze sein, die kratzt, aber du bist dir nicht sicher.)

<!-- -->

> **fau ro da tu mlatu**
> _This must be/certainly is the cat._
> (Du hast eine Katze, und solche Geräusche können nur von einem Objekt, dieser Katze, erzeugt werden.)

<!-- -->

> **fau so'e da tu mlatu**
> _This should be/probably is the cat._
> (Wenn du einen Hund hast, dann kann er auch solche Geräusche machen, aber dein Hund macht das normalerweise nicht, also ist die Katze wahrscheinlicher.)

<!-- -->

> **fau so'u da tu mlatu**
> _Es ist nicht wahrscheinlich, dass dies die Katze ist._

<!-- -->

> **fau no da tu mlatu**
> _Das kann nicht die Katze sein. Das darf nicht die Katze sein. Es ist unmöglich, dass dies die Katze ist._

Beachten Sie, dass wir **da'i** der Kürze halber weggelassen haben. Aber wenn wir ausdrücklich klarstellen wollen, dass die Ereignisse imaginär sind, muss **da'i** in diesen Beispielen innerhalb der **fau**-Beziehung platziert werden:

1. **fau da'i da** bedeutet, dass das Ereignis in dieser Beziehung _möglich ist, möglicherweise passieren kann._
2. **fau da'i ro da** — das Ereignis _würde notwendigerweise passieren._
3. **fau da'i so'e da** — das Ereignis _ist wahrscheinlich, wird wahrscheinlich passieren, wird wahrscheinlich passieren._
4. **fau da'i so'o da** — das Ereignis _ist entfernt wahrscheinlich, könnte passieren._
5. **fau da'i so'u da** — das Ereignis _ist nicht wahrscheinlich, passiert wahrscheinlich nicht._
6. **fau da'i no da** — das Ereignis _ist nicht möglich._

Der Unterschied zwischen diesen liegt in der Anzahl der imaginären Situationen, die wir berücksichtigen. Wir beschreiben diese Situationen nicht; wir markieren sie einfach als **da** (_etwas_), und lassen den Kontext (oder unsere Zuhörer) entscheiden, was diese Situationen sind.

### Möglichkeit, die in den Stellen der Beziehungen impliziert ist

Einige Beziehungen haben **da'i** in einigen ihrer Slots impliziert, wenn Sie **da'i** nicht explizit verwenden:

> **mi pacna le nu do ba pluka sipna**
> _Ich hoffe, du wirst einen angenehmen Schlaf haben._

pacna
: $x_1$ hofft auf $x_2$ (mögliches Ereignis) mit Wahrscheinlichkeit $x_3$ (Zahl, standardmäßig **li so'a**, d.h. nahe 1)

> **mi kanpe le nu do klama**
> _Ich erwarte, dass du kommst._

<!-- -->

> **mi kanpe le nu do ba jinga kei li so'e**
> _Du wirst wahrscheinlich gewinnen._
> `Ich erwarte mit hoher Wahrscheinlichkeit, dass du gewinnen wirst.`

<!-- -->

> **mi kanpe le nu mi cortu fau ro lo nu su'o lo rokci cu farlu le tuple be mi**
> _Ich weiß mit Sicherheit, dass wenn ein Stein auf meinen Fuß fällt, es weh tun wird._

kanpe
: $x_1$ erwartet $x_2$ (mögliches Ereignis) mit erwarteter Wahrscheinlichkeit $x_3$ (eine Zahl von 0 bis 1, der Standardwert ist **li so'a**, d.h. nahe 1)

Im Gegensatz zu **pacna** impliziert die Beziehung **kanpe** nicht unbedingt Hoffnung oder Wunsch. Sie kann eine unparteiische Erwartung, eine subjektive Bewertung der Wahrscheinlichkeit einer Situation beschreiben.

> **cumki fa le nu do jinga**
> _Es ist möglich, dass du gewinnst._

<!-- -->

> **- xu ba carvi**
> **- cumki**
> _- Wird es regnen?_
> _- Vielleicht._

cumki
: $x_1$ (mögliches Ereignis) ist möglich, $x_1$ könnte passieren, $x_1$ ist ein Vielleicht.

> **- xu ba carvi**
> **- lakne**
> _- Wird es regnen?_
> _- Wahrscheinlich._

lakne
: $x_1$ (mögliches Ereignis) ist wahrscheinlich, wahrscheinlich

> **mi djica le nu do jinga**
> _Ich möchte, dass du gewinnst._

<!-- -->

> **mi djica le nu mi klama la .paris.**
> _Ich würde lieber Paris besuchen. Ich möchte Paris besuchen._

djica
: $x_1$ möchte $x_2$ (mögliches Ereignis)

> **mi te mukti le ka klama la .paris.**
> _Ich werde Paris besuchen. Ich bin motiviert, Paris zu besuchen._

<!-- -->

> **mi te mukti klama la .paris.**
> _Ich besuche Paris absichtlich._

te mukti
: $x_1$ ist motiviert, das Ziel $x_2$ (mögliches Ereignis) durch den Antrieb $x_3$ (Ereignis) zu erreichen

> **mi kakne le ka limna**
> _Ich kann schwimmen._

<!-- -->

> **mi pu kakne le ka gunka**
> _Ich konnte arbeiten. Ich war in der Lage zu arbeiten._

kakne
: $x_1$ kann, ist in der Lage, $x_2$ (Eigenschaft von $x_1$) zu tun

$x_2$ beschreibt ein mögliches Ereignis.

> **mi nitcu le nu mi sipna**
> _Ich muss schlafen._

nitcu
: $x_1$ braucht $x_2$ (mögliches Ereignis)

> **mi bilga le ka gunka**
> _Ich muss arbeiten. Ich bin verpflichtet zu arbeiten._

bilga
: $x_1$ muss, ist verpflichtet, $x_2$ (Eigenschaft von $x_1$) zu tun

> **mi curmi le nu do citka ti**
> _Ich erlaube dir, dies zu essen._

curmi
: $x_1$ erlaubt/gestattet $x_2$ (mögliches Ereignis)

> **mi tolcru le nu do nerkla**
> _Ich verbiete dir, einzutreten._

tolcru
: $x_1$ verbietet/untersagt $x_2$ (mögliches Ereignis)

> **xu do stidi le ka sipna kei mi**
> _Schlägst du vor, dass ich schlafe?_

stidi
: $x_1$ inspiriert $x_2$ (mögliche Handlung) bei Akteur $x_3$

<!-- >**mi na ku birti le du'u ra klama**
>_Ich bin mir nicht sicher, ob er kommt._

birti
: $x_1$ ist sicher, dass $x_2$ (Aussage) wahr ist -->

> **mi senpi le du'u ra kakne le ka limna**
> _Ich bezweifle, dass er schwimmen kann._

senpi
: $x_1$ bezweifelt, dass $x_2$ (Aussage) wahr ist

<!-- **senpi** ist dasselbe wie **na'e birti** -->

> **mi se xanri le nu mi pavyseljirna**
> _Ich stelle mir vor, ein Einhorn zu sein. Ich könnte ein Einhorn sein._

<!-- -->

> **se xanri**
> _$x_1$ stellt sich $x_2$ (mögliches Ereignis) vor_

<!-- -->

> **xanri**
> _$x_1$ (mögliches Ereignis) wird von $x_2$ vorgestellt_
