## Lektion 7. Buchstaben, die sich auf Beziehungen und Daten beziehen

### Namen der Buchstaben in Lojban

Jeder Buchstabe hat einen Namen in Lojban.

Die folgende Tabelle stellt das grundlegende Lojban-Alphabet dar und wie man die Buchstaben ausspricht (unter jedem Buchstaben):

<table>
<tbody><tr>
<td>'
</td>
<td><b><font  class="guibutton" color="#FF1493">a</font></b>
</td>
<td>b
</td>
<td>c
</td>
<td>d
</td>
<td><b><font  class="guibutton" color="#FF1493">e</font></b>
</td></tr>
<tr>
<td><b>.y'y.</b>
</td>
<td><b>.a bu</b>
</td>
<td><b>by.</b>
</td>
<td><b>cy.</b>
</td>
<td><b>dy.</b>
</td>
<td><b>.ebu</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>f
</td>
<td>g
</td>
<td><b><font  class="guibutton" color="#FF1493">i</font></b>
</td>
<td>j
</td>
<td>k
</td>
<td>l
</td></tr>
<tr>
<td><b>fy.</b>
</td>
<td><b>gy.</b>
</td>
<td><b>.i bu</b>
</td>
<td><b>jy.</b>
</td>
<td><b>ky.</b>
</td>
<td><b>ly.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>m
</td>
<td>n
</td>
<td><b><font class="guibutton" color="#FF1493">o</font></b>
</td>
<td>p
</td>
<td>r
</td>
<td>s
</td></tr>
<tr>
<td><b>my.</b>
</td>
<td><b>ny.</b>
</td>
<td><b>.o bu</b>
</td>
<td><b>py.</b>
</td>
<td><b>ry.</b>
</td>
<td><b>sy.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>t
</td>
<td><b><font  class="guibutton" color="#FF1493">u</font></b>
</td>
<td>v
</td>
<td>x
</td>
<td><b><font  class="guibutton" color="#FF1493">y</font></b>
</td>
<td>z
</td></tr>
<tr>
<td><b>ty.</b>
</td>
<td><b>.u bu</b>
</td>
<td><b>vy.</b>
</td>
<td><b>xy.</b>
</td>
<td><b>.y bu</b>
</td>
<td><b>zy.</b>
</td></tr></tbody></table>

Wie Sie sehen können:

- um den Namen für einen Vokal zu erhalten, fügen wir das Wort **bu** hinzu.
- um den Namen für einen Konsonanten zu erhalten, fügen wir **y.** zum Konsonanten hinzu.
- das Wort für **'** (Apostroph) ist **.y'y**.

Wir können Wörter mit diesen Namen buchstabieren. Zum Beispiel wird CNN **cy. ny. ny.** sein.

<!-- Ein einzelner Großbuchstabe hat eine besondere Bedeutung. Er bezeichnet den Namen dieses Buchstabens:

**A** ist dasselbe wie **.abu**, **B** ist dasselbe wie **by.** und so weiter. Sie bedeuten dasselbe und werden sogar genauso gelesen wie das normale **.abu**, **by.** usw. Also kann _CNN_ auch als **CNN** in Lojban geschrieben werden und es wird immer noch genauso ausgesprochen und bedeutet dasselbe wie **cy. ny. ny.** -->

### Buchstaben statt ‘_er_’ und ‘_sie_’

Eine Folge von einem oder mehreren Buchstabennamen kann als Pronomen fungieren und bietet eine alternative Methode, um in der Rede auf zuvor erwähnte Argumente zu verweisen.

> **la .alis. pu klama le nurma .i le nurma cu melbi la .alis.**
> **la .alis. pu klama le nurma .i ri melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi .a bu**
> _Alice ging aufs Land. Das ländliche Gebiet ist schön für Alice._
> _Alice ging aufs Land. Es ist schön für sie._

Alle oben genannten Lojban-Varianten haben die gleiche Bedeutung.

Da der erste Buchstabe in **.alis.** **a** ist (den Punkt ignorierend) und der erste Buchstabe in **nurma** **n** ist, können wir Buchstabenwörter verwenden, um auf diese Argumente entsprechend zu verweisen:

- **.a bu** bezieht sich auf **la .alis.**
- **ny.** bezieht sich auf **le nurma**

Diese Methode könnte bequemer sein als das englische _he_ oder _she_, oder sogar das Lojban **ri** oder **ra**. Sie ermöglicht es uns, die Rede prägnanter und dennoch präzise zu gestalten, ohne potenziell lange Namen oder andere Argumentbegriffe wiederholt zu verwenden.

Es ist jedoch wichtig zu beachten, dass es Situationen geben kann, in denen wir beispielsweise auf **le nurma** zurückverweisen möchten, aber ein anderes Argument, das mit **n** beginnt, inzwischen aufgetaucht ist, wodurch **ny.** nicht mehr auf das ländliche Gebiet verweisen kann. In solchen Fällen ist die schnellste Lösung, das gesamte Argument zu wiederholen, d.h. **le nurma** zu sagen:

> **bu'u le nurma la .alis. pu penmi la .nik. i ri se zdani bu'u le nurma**
> _Im Land traf Alice Nick. Er hat sein Zuhause im Land._

zdani
: … ist ein Zuhause für …

se zdani
: … hat ein Zuhause …, … lebt in …

Wenn ein Name aus mehreren cmevla besteht, können Sie die Anfangsbuchstaben davon verwenden, um auf diesen Namen zu verweisen. Dasselbe gilt für zusammengesetzte Beziehungen:

> **la .djan.smit. cu citka le glare stasu .i dy.sy. nelci fy.sy.**
> _John Smith isst die heiße Suppe. Er mag sie._

glare
: … ist heiß

**dy.sy.** ist ein einzelnes Pronomen. Dasselbe gilt für **fy.sy.**.

Wenn Sie mehrere Pronomen hintereinander setzen müssen, trennen Sie sie mit dem Wort **boi**:

> **mi klama la .paris. la .moskov.**
> _Ich gehe nach Paris von Moskau._

<!-- -->

> **mi klama py. boi my.**
> _Ich gehe nach P von M._

Der Satz **mi klama py. my.** würde _Ich gehe nach PM_ bedeuten, was etwas anderes bedeuten würde.

> **la .tom.silver. pu zvati .i je'u ty. sy. boi .ui pu sidju mi**
> _Tom Silver war anwesend. Und tatsächlich, TS (yay!) hat mir geholfen._

Wenn du eine Interjektion nach solchen Buchstaben setzt, trenne sie mit **boi**. Ohne **boi** beziehen sich Interjektionen auf den letzten Buchstaben.

### Verschiedene Arten, ‘_wir_’ auf Lojban zu sagen

Im Lojban gibt es mehrere Pronomen, die _wir_ bedeuten:

mi'o
: du und ich

mi'a
: wir ohne dich

ma'a
: du, ich und andere

Also musst du beim Sprechen vorsichtiger sein, welche Bedeutung von _wir_ du benötigst.

Und schließlich:

mi
: ich oder die Sprecher

**mi** kann auch _wir_ bedeuten! Lojban unterscheidet standardmäßig nicht zwischen Singular und Plural. Wenn also mehrere Personen zusammen sprechen, ist **mi** (das sich auf einen oder mehrere Sprecher bezieht) für _wir_ vollkommen korrekt. In der Praxis wirst du **mi** normalerweise so verwenden, wenn eine Person im Namen anderer spricht (oder häufiger schreibt).

Einige Beispiele:

> **mi prami do**
> _Ich liebe dich._

<!-- -->

> **mi'a ba penmi do**
> _Wir werden dich treffen._

<!-- -->

> **ma'a remna**
> _Wir sind alle Menschen._

<!-- -->

> **mi djica le nu do cliva**
> _Wir wollen, dass du gehst._

cliva
: $x_1$ verlässt

### «**ri**» statt ‘_er_’ und ‘_sie_’

Früher haben wir das Pronomen **ri** gelernt:

ri
: Pronomen: bezieht sich auf das vorherige Argument, das gerade beendet wurde (überspringt stabile Pronomen wie **mi**, **do**, Wörter für _wir_)

> **mi catlu le nanmu .i ri melbi**
> _Ich schaue den Mann an. Er ist gutaussehend._

melbi
: $x_1$ ist schön / hübsch / gutaussehend für jemanden $x_2$

**ri** bezieht sich auf das vorherige abgeschlossene Argument, das im Text oder in der Rede einer Person verwendet wird:

> **la .alis. cu sipna bu'u le sledi'u pe la .alis.**
> _Alice schläft im Zimmer von Alice._
> `Alice schläft im von-Alice Zimmer.`

> **la .alis. cu sipna bu'u le sledi'u pe ri**
> _Alice schläft in ihrem Zimmer._
> `Alice schläft im Zimmer des [vorherigen Argumentterms].`

sledi'u
: $x_1$ ist ein Raum für den Zweck $x_2$ (Proposition)

Das **ri** ist gleichbedeutend mit der Wiederholung des letzten Arguments, das hier **la .alis.** ist.

Ein Aspekt, den man beachten sollte, ist, dass **ri** nicht **le sledi'u pe ri** (was auch ein Argument ist) wiederholt, weil **ri** ein Teil dieses Arguments ist und daher dieses Argument nicht "vorherig" ist, noch nicht abgeschlossen ist, wenn **ri** erscheint. Dies verhindert, dass **ri** sich rekursiv auf sich selbst bezieht.

Ein weiteres Beispiel:

> **le du'u le prenu cu melbi cu se djuno ri**
> _Dass die Person hübsch ist, ist ihr bekannt._

Das **ri** bezieht sich auf **le prenu** (und nicht auf **le du'u le prenu cu melbi**, obwohl beide Argumente vollständig sind: **le prenu** beginnt zuletzt, nach dem Beginn von **le du'u le prenu cu melbi**).

Die Beziehung innerhalb von **sei** bildet einen parallelen Text. **ri** überspringt Argumente innerhalb von **sei**-Beziehungen:

> **mi viska la .lukas. sei la .doris. pu cusku .i ri jibni la .micel.**
> _Ich sehe Lucas, — sagte Doris. Er ist in der Nähe von Michelle._

In diesem Beispiel kann sich **ri** nicht auf **la .doris.** beziehen. Wir überspringen einfach die gesamte **sei la .doris. pu cusku**-Beziehung, wenn wir entscheiden, worauf sich **ri** beziehen soll.

Pronomen, die im Dialog oder in der Geschichte stabil sind, werden von **ri** ignoriert. Wir wiederholen sie einfach direkt:

> **mi lumci mi**
> _Ich wasche mich._
> `Ich wasche mich`

lumci
: $x_1$ wäscht $x_2$

> **mi prami mi**
> _Ich liebe mich._
> `Ich liebe mich.`

Jedoch:

- die Pronomen **ti**, **ta**, **tu** werden von **ri** aufgenommen, weil du möglicherweise geändert hast, worauf du zeigst, sodass das Wiederholen von **tu** möglicherweise nicht effektiv ist.
- ähnlich kann **ri** selbst (oder vielmehr sein Antezedens) von einem späteren **ri** wiederholt werden. Tatsächlich wird eine Reihe von **ri**-Wörtern ohne andere dazwischenliegende Argumente immer dasselbe Argument wiederholen:

 > **la .alis. cu catlu le nanmu .i ri melbi .i ri co'a zgana .a bu**
 > _Alice bemerkt einen Mann. Er ist gutaussehend. Er bemerkt Alice._

zgana
: beobachten

co'a zgana
: zu beobachten beginnen, bemerken

In diesem Beispiel hat das zweite **ri** das erste **ri** als Antezedens, das wiederum **le nanmu** als Antezedens hat. Alle drei beziehen sich auf dasselbe: den Mann.

Letztendlich entscheidest du, was, wo und wann du in der Rede verwendest: die Methode mit **le** + Beziehung, die Methode mit Buchstabennamen oder mit **ri**.

<!-- ### "_Myself, themselves_"

In slawischen Sprachen sagen die Leute wörtlich _Ich wasche mich_. Um einem slawischen Stil näher zu kommen, können wir **lo nei** verwenden.

>**mi nelci mi**
>_Ich mag mich._

>`I like me.`

Es hat die gleiche Bedeutung wie:

>**mi nelci lo nei**
>_Ich mag mich._

>**mi lumci mi**
>**mi lumci lo nei**
>_Ich wasche mich._

>**la ian ca lumci lo nei**
>**la ian ca lumci ri**
>_Yan wäscht sich._

**lo nei** bezieht sich auf das erste Substantiv der aktuellen Beziehung.

Denke daran, dass **ri** nicht auf Pronomen wie **mi** zurückverweisen kann, daher könnte **lo nei** im letzten Beispiel bevorzugt werden. Wenn man das erste Substantiv ändert, ändert sich **lo nei** nicht, was ziemlich praktisch ist:

>**mi lumci lo nei i do lumci lo nei i la ian cu lumci lo nei**
>_Ich wasche mich. Du wäschst dich. Yan wäscht sich._

>**la .doris. cu pensi lo nei**
>_Doris denkt an sich._

>**pa gerku cu batci lo nei**
>_Ein Hund beißt sich._

---

**nei** funktioniert gut, wenn ein Satz nur eine Beziehung enthält. Aber wenn er mehrere eingebettete Beziehungen hat, könnten wir etwas anderes benötigen. In

>**la .doris. cu djuno lo du'u la .alis. cu prami lo nei**
>_Doris weiß, dass Alice sich liebt._

bezieht sich **lo nei** auf **la .alis.**

Was, wenn wir uns auf Doris beziehen wollen? Hier ist eine Lösung:

>**la .doris. cu djuno lo du'u la .alis. cu prami vo'a**
>_Doris weiß, dass Alice sie liebt._

Während sich **lo nei** auf das erste Substantiv der aktuellen Beziehung bezieht, bezieht sich **vo'a** auf das erste Substantiv des aktuellen Satzes.

Wenn es keine eingebetteten Beziehungen gibt, bedeuten diese beiden Wörter dasselbe:

>**la .alis. cu prami vo'a** ist dasselbe wie **la .alis. cu prami lo nei**
>_Alice liebt sich._

- **vo'a** bezieht sich auf das erste Substantiv des aktuellen Satzes.
- **vo'e** bezieht sich auf das zweite Substantiv des aktuellen Satzes.
- **vo'i** bezieht sich auf das dritte Substantiv des aktuellen Satzes.
- **vo'o** bezieht sich auf das vierte Substantiv des aktuellen Satzes.
- **vo'u** bezieht sich auf das fünfte Substantiv des aktuellen Satzes.

---

**lo nei** kann lustige Ergebnisse liefern, wenn es auf gegenseitige Handlungen angewendet wird:

>**la .alis. e la .kevin. cu cinba lo nei**
>_Alice küsst sich selbst, und Kevin küsst sich selbst._

Hier ist die Lösung:

>**la .alis. jo'u la .kevin. cu cinba zu'ai**
>_Alice und Kevin küssen sich gegenseitig_

Es bedeutet dasselbe wie:

>**la alis cu cinba la kevin i je la kevin cu cinba la alis**
>_Alice küsst Kevin, und Kevin küsst Alice._

**zu'ai** wird an die zweite Stelle des Verbs gesetzt. Es zeigt die gegenseitige Handlung zwischen dem ersten und dem zweiten Platz. Mitglieder dieser gegenseitigen Handlung werden an die erste Stelle gesetzt und mit der Konjunktion **jo'u** verbunden.

### «**go'i**» für die vorherige Beziehung

> **la .alis. cu klama le barja .i la .alis. cu viska le nanmu**
> **la .alis. cu klama le barja .i le go'i cu viska le nanmu**
> _Alice kommt zur Bar. Sie sieht einen Mann._

- **le go'i** bezieht sich auf den ersten Platz der vorherigen Beziehung.
  - **go'i** stellt eine weitere Möglichkeit dar, auf ein Argument zurückzugreifen, das wir benötigen.
- **le se go'i** bezieht sich auf den zweiten Platz der vorherigen Beziehung.
- **le te go'i** bezieht sich auf den dritten Platz und so weiter.

Beispiele:

> **.i la .alis. cu zgana le nanmu .i ri melbi**
> **.i la .alis. cu zgana le nanmu .i le se go'i cu melbi**
> _Alice beobachtet einen Mann. Er ist gutaussehend._

Hier bezieht sich **le se go'i** auf den zweiten Platz ($x_2$) der vorhergehenden Beziehung, nämlich **le nanmu**.

Ein weiteres Beispiel:

> _Bill sah Nick. Er schlug ihn._

Englisch kümmert sich hier nicht um Präzision — _er_ bedeutet einfach _eine männliche Person, die irgendwo im Text erwähnt wurde oder aus dem Kontext abgeleitet wird._ Hat Bill Bob geschlagen, oder hat Bob Bill geschlagen? Wir wissen es nicht. Auf Lojban können wir sagen:

> **la .bil. pu viska la .nik. .i le se go'i cu darxi le go'i**
> _Bill sah Nick. Nick schlug Bill._

In den meisten Fällen können jedoch **ri** oder Buchstabenwörter verwendet werden:

> **la .bil. cu viska la .nik. i ri darxi la .bil.**
> **la .bil. cu viska la .nik. i ny. darxi by.**
> _Bill sah Nick. Nick schlug Bill._

**go'i** selbst ist ein Beziehungswort und hat daher eine Platzstruktur:

> **mi tatpi .i do ji'a go'i**
> _Ich bin müde. Und du auch._

Wenn wir **do go'i** sagen, wiederholen wir die vorherige Beziehung, ersetzen aber den ersten Platz durch **do**. Mit anderen Worten, **do ji'a go'i** hier ist dasselbe wie **do ji'a tatpi** zu sagen.

### Tageszeit

> **— ma tcika ti**
> _Wie spät ist es?_

> **— li cacra bu pa pa**
> _Elf Stunden_

tcika
: $x_1$ (Stunden, Minuten, Sekunden) ist die Zeit des Ereignisses $x_2$

Im Lojban sind Zeiten immer die Zeiten von etwas. Also fragen wir, wie spät es **ti** ist, was _dieses Ereignis/Ding_ bedeutet, oder, mit anderen Worten, _jetzt_.

**li**, ein Präfix für Zahlen, wird auch für Zeitstempel verwendet.

- **cacra bu** ist ein Präfix, das signalisiert, dass die Anzahl der Stunden folgt. Im Lojban wird fast immer die 24-Stunden-Zeit verwendet.
- **mentu bu** ist ein Präfix, das signalisiert, dass die Anzahl der Minuten folgt.
- **snidu bu** ist ein Präfix, das signalisiert, dass die Anzahl der Sekunden folgt.

> **li cacra bu pa pa mentu bu pa no**
> _11:10 (Zehn Minuten nach elf)_

> **li cacra bu pa pa mentu bu pa no snidu bu pa ci**
> _11 Stunden, 10 Minuten und 13 Sekunden._

> **li cacra bu pa no mentu bu mu no**
> _10:50, zehn vor elf_

Wenn wir die Zeit eines Ereignisses angeben möchten, anstatt nur die Uhrzeit zu nennen, wird der zweite Platz ausgefüllt:

> **li cacra bu pa no tcika le nu mi klama**
> _Zehn Uhr ist die Zeit, zu der ich komme._

Durch die Verwendung des Begriffs **de'i** können wir einen natürlicher klingenden Satz erhalten:

> **mi klama de'i li cacra bu pa no**
> _Ich komme um 10 Uhr._

de'i
: um … (Zeit), am … (Datum)

Und ein nützliches Beispiel:

> **ca tcika le nu .ei sipna**
> _Es ist Zeit zu schlafen._

### Daten

> **— ma detri ti**
> _Welches Datum ist heute?_

> **— li mastu bu ze djedi bu pa**
> _Es ist der 1. Juli._

detri
: $x_1$ (Jahr, Monat, Tag) ist das Datum/Zeitpunkt des Ereignisses $x_2$

Eine andere Option:

> **— ma ca detri**
> _— Welches Datum ist jetzt?_

- **nanca bu** ist ein Präfix, das signalisiert, dass das Jahr folgt.
- **masti bu** ist ein Präfix, das signalisiert, dass der Monat folgt.
- **jefydei bu** ist ein Präfix, das signalisiert, dass der Wochentag folgt.
- **djedi bu** ist ein Präfix, das signalisiert, dass der Tag folgt.

Präfixe mit Zahlen danach können in beliebiger Reihenfolge verwendet werden (wir verwenden Ziffern, um Zahlen darzustellen):

> **li djedi bu 2 ca detri**
> _Es ist jetzt der zweite Tag des Monats._

<!-- -->

> **li masti bu 4 djedi bu 1 ca detri**
> _Es ist jetzt der erste April._

<!-- -->

> **li djedi bu 5 masti bu 7 nanca bu 2005 detri le nu mi jbena**
> _Der fünfte Juli (siebter Monat), Jahr 2005 ist, als ich geboren wurde._

jbena
: $x_1$ ist geboren

Wir können auch **de'i** verwenden:

> **mi ba klama de'i li masti bu pano**
> _Ich werde im Oktober kommen._

Partikel im Lojban können ohne Leerzeichen dazwischen geschrieben werden, wie in diesem **pano**, das dasselbe ist wie **pa no**.

Für Wochentage ist normalerweise Montag der erste Tag:

> **mi gunka de'i li jefydei bu pa**
> _Ich arbeite am Montag._

<!-- -->

> **mi gunka ca ro se detri be li jefydei bu re**
> _Ich arbeite jeden Dienstag._

<!-- -->

> **xu do pu zvati la .paris. de'i li jefydei bu ci**
> _Warst du am Mittwoch in Paris?_

### Zeitintervalle angeben

> **mi nanca li re re**
> _Ich bin 22 Jahre alt._

nanca
: $x_1$ hat eine Dauer von $x_2$ (Anzahl) Jahren

**nanca** gibt die Dauer an, und um _zwei Jahre lang_ zu sagen, füllen Sie den zweiten Platz mit einer Zahl, die mit **li** vorangestellt ist.

> **le verba cu masti li re**
> _Das Kind ist zwei Monate alt._

masti
: $x_1$ ist $x_2$ Monate lang

> **le nu carvi cu djedi li ci**
> _Es regnet seit drei Tagen._

djedi
: $x_1$ (Ereignis) ist $x_2$ (Anzahl) volle Tage lang

### Neue Verben von einer Skala: ‘_anders als_’ — «**na'e**», ‘_anti-_’ — «**to'e**»

> **mi na'e nelci do**
> _Ich mag dich anders als._

"Linke Skalar" Partikel (zu denen **na'e** gehört) werden links von den Konstrukten platziert, die sie beeinflussen, und bilden eine Skala:

Die Skala selbst kann mit dem Modal-Tag **ci'u** spezifiziert werden.

- **je'a** = _in der Tat (die bejahende Position auf der Skala)_. Das Wort **je'a** bestätigt die Bedeutung eines Satzteils. Normalerweise wird es einfach weggelassen.

 > **mi je'a nelci do**
 > _Ich mag dich in der Tat._

- **na'e** = _nicht- (anders als die bejahende Position auf der Skala)_

 > **mi na'e nelci do**
 > _Ich mag dich anders als._

 > **le stizu cu na'e xunre be ci'u le ka skari**
 > _Der Stuhl ist von einer nicht-roten Farbe._
 > `Der Stuhl ist anders als rot auf der Skala des Farbhabens`

- **no'e** = _nicht wirklich (Mittelpunkt auf der Skala)_. Das Wort **no'e** gibt einem Satzteil eine mittlere Bedeutung.

 > **mi no'e nelci do**
 > _Ob ich dich liebe oder hasse, ich bin dir gegenüber gleichgültig. Ich mag dich weder noch hasse ich dich._

- **to'e** = _anti-, dis-, miss- usw. (Gegenteil auf der Skala)_. Das Wort **to'e** gibt einem Satzteil eine gegenteilige Bedeutung. Es ist dem englischen Präfix _anti-_ ähnlich.

 > **mi to'e nelci do**
 > _Ich hasse dich._
 > `Ich anti-mag dich`

**na'e** ist vager als **no'e** und **to'e**; es kann jede von ihnen bedeuten, wenn man sich nicht um die genaue Bedeutung kümmert.

### Komplexe Modalbegriffe: ‘_weil_’ — «**ki'u**», ‘_trotz_’ — «**to'e ki'u nai**»

Modalbegriffe können auf zwei Arten verneint werden, um verwandte Bedeutungen zu erhalten.

ki'u
: Modalbegriff: weil, aufgrund der Erklärung …, was durch die Tatsache erklärt werden kann, dass …

> **ki'u ma do cusku zo co'o**
> _Warum sagst du auf Wiedersehen?_

Das Hinzufügen des Suffixes **nai** ändert die Bedeutung:

ki'u nai
: Modalbegriff: nicht weil, was nicht durch die Tatsache erklärt werden kann, dass …?!

> **mi se nabmi ki'u nai le nu mi laldo ce'e ki'u le nu mi na certu**
> _Ich habe Probleme nicht weil ich alt bin, sondern weil ich kein Experte bin._

nabmi
: $x_1$ ist ein Problem für $x_2$

se nabmi
: $x_1$ hat ein Problem $x_2$

laldo
: $x_1$ ist alt …

certu
: $x_1$ ist ein Experte, Profi in Eigenschaft $x_2$

Adding **to'e** sets the negation of the meaning:

to'e ki'u
: weil nicht, was durch die Tatsache erklärt werden kann, dass es nicht passiert …

> **mi jinga to'e ki'u le nu mi pu surla**
> _Ich habe gewonnen, weil ich mich nicht ausgeruht hatte._

Combining both **to'e** and **nai** we get:

to'e ki'u nai
: trotz des Grundes …, nicht weil nicht, was nicht durch die Tatsache erklärt werden kann, dass es nicht passiert …,

> **.i to'e ki'u nai le nu le mamta cu sanga su'o melbi kei le verba na snada lo ka sipna**
> _Trotz des schönen Singens der Mutter gelingt es dem Kind nicht, einzuschlafen._

Using **se** changes the order of arguments. Otherwise, the meaning is preserved.

se ki'u
: daher, was die Tatsache erklärt, dass …

> **ra bilma se ki'u le nu ra na pu cusku zo coi do**
> _Er ist krank, was erklärt, warum er dich nicht gegrüßt hat._

se ki'u nai
: aber es folgt nicht, dass …, was die Tatsache nicht erklärt, dass …

> **ra bilma se ki'u nai le nu ra klama le drata tcadu**
> _Er ist krank, was nicht erklärt, warum er in eine andere Stadt geht._

se to'e ki'u
: …, dessen Abwesenheit die Tatsache erklärt, dass …

> **ra bilma se to'e ki'u le nu ra klama le drata tcadu**
> _Er ist nicht krank, und das erklärt, warum er in eine andere Stadt geht._

se to'e ki'u nai
: …, dessen Abwesenheit die Tatsache nicht erklärt, dass …

> **ra bilma se to'e ki'u nai le nu ra penmi le mikce**
> _Er ist nicht krank, und das erklärt nicht, warum er den Arzt trifft._

mikce
: $x_1$ ist ein Arzt
