## Lektion 5. Modalbegriffe, «**da**», ihre relative Position

### Wie beziehen sich Modalbegriffe auf die Relation?

Einige Modalbegriffe, wie diejenigen, die die Zeit (Tempus) beschreiben, verbinden die aktuelle Relation mit der im Argument nach ihnen:

> **mi cadzu ca le nu le cipni cu vofli**
> _Ich gehe, wenn die Vögel fliegen._

cadzu
: … geht

le cipni
: der Vogel/die Vögel

vofli
: … fliegt zu …

> **mi pu cadzu fa'a le rirxe**
> _Ich ging zum Fluss._

<!-- -->

> **mi pu cadzu se ka'a le rirxe**
> _Ich ging zum Fluss._

se ka'a
: kommend zu …

fa'a
: direkt zu …

Modalbegriffe entfernen keine geordneten Plätze (**fa**, **fe**, **fi**, **fo**, **fu**) aus der Relation:

> **mi klama se ka'a le rirxe le dinju**
> **mi klama fe le rirxe .e le dinju**
> _Ich gehe zu einem Fluss, zu einem Haus._

Im ersten Beispiel verbindet **se ka'a** **le rirxe** und dann folgt der zweite Platz von **klama**, der mit **le dinju** gefüllt wird. Es ist dasselbe wie einfach den zweiten Platz von **klama** zweimal zu füllen und sie mit **.e** — _und_ — zu verbinden.

Jedoch ist **se ka'a** nützlich, wenn es auf andere Relationen wie **cadzu** im vorherigen Beispiel angewendet wird.

> **le prenu pu cadzu tai le nu ri bevri su'o da poi tilju**
> _Die Person ging, als ob sie etwas Schweres trug._

bevri
: $x_1$ trägt $x_2$

tai
: Modalbegriff: wie …, ähnlich …

<!--
- Einige Begriffe beschreiben Relationen des ersten Platzes der Relation mit dem Substantiv nach dem Begriff:

>**mi jinga se rai le ka clani**
>_Ich gewinne als der Größte._

se rai
: Begriff von **se traji**: am meisten in …

Hier entspricht $x_1$ der Relation dem Größten im Vergleich, der nach **se rai** angegeben wird.

- Schließlich beschreiben einige Begriffe Relationen des ersten Platzes der Relation und die Relation selbst mit dem Substantiv nach dem Begriff:

>**le fragari cu se nelci mi te rai le'i jbari**
>_Von den Beeren mag ich Erdbeeren am meisten._

te rai
: Begriff von **te traji**: bevorzugt aus …

lo fragari
: Erdbeeren

lo jbari
: Beeren

$x_1$ der Relation beschreibt das Meiste in diesem Vergleich, die Relation selbst beschreibt den Vergleich.

Das Wörterbuch erklärt solche kniffligen Fälle, in denen die durch den Begriff definierte Beziehung Schwierigkeiten bereiten könnte. In der Praxis ist die Beziehung oft aus den gegebenen Beispielen klar ersichtlich. -->

### Verwendung von «**ne**» + Begriff. «**se mau**» — ‘_mehr als …_’

> **mi ne se mau do cu melbi**
> _Ich bin hübscher als du._

se mau
: Begriff von **se zmadu**: mehr als; die Beziehung selbst beschreibt den Vergleich

Dieses Beispiel ist ähnlich wie

> **mi zmadu do le ka melbi**
> _Ich übertreffe dich in Hübschheit._

Mit anderen Worten, die Hauptbeziehung **melbi** ist ähnlich wie der dritte Platz von **zmadu**, der die Vergleichskriterien spezifiziert. Zwei weitere Beispiele:

> **mi prami do ne se mau la .doris.**
> _Ich liebe dich mehr als Doris._

<!-- -->

> **mi ne se mau la .doris. cu prami do**
> _Ich liebe dich mehr als Doris._
> _Ich liebe dich mehr als Doris dich liebt._
> `Ich (mehr als Doris) liebe dich.`

Weitere Beispiele:

> **mi nelci le'e pesxu ne se mau le'e jisra**
> _Ich mag Marmelade mehr als Saft._

pesxu
: … ist Marmelade

> **le'e pesxu cu zmadu le'e jisra le ka mi nelci**
> _Ich mag Marmelade mehr als Saft._
> `Marmelade übertrifft Saft darin, wie sehr ich es mag.`

Und nun ein interessanter Satz:

> _Bob mag Betty mehr als Mary._

Das kann im Englischen zwei verschiedene Dinge bedeuten!

1. Bob mag Betty und er mag Mary weniger.
2. Bob mag Betty, aber Mary mag Betty auch, nur nicht so sehr wie Bob!

Vergleichen wir Betty mit Mary darin, wie Bob sie mag?

Oder vergleichen wir stattdessen Bob mit Mary darin, wie sie Betty mögen?

Englisch ist in dieser Hinsicht mehrdeutig.

Im Lojban können wir die beiden Bedeutungen unterscheiden, indem wir **se mau** an geeignete Argumente anhängen:

> **la .bob. ne se mau la .maris. cu nelci la .betis.**
> _Bob (im Vergleich zu Mary) mag Betty mehr. Mary mag Betty weniger._
> _Bob mag Betty mehr als Mary._

<!-- -->

> **la .bob. cu nelci la .betis. ne se mau la .maris.**
> _Bob mag Betty, und er mag Mary weniger._
> _Bob mag Betty mehr als Mary._

### Vergleiche: ‘_gleich_’, ‘_dasselbe_’

> **mi dunli le mensi be mi le ka mitre .i ku'i mi na ku du le mensi**
> _Ich bin so groß wie meine Schwester. Aber ich bin nicht sie._
> Ich gleiche der Schwester von mir in Metern. Aber ich bin nicht identisch mit der Schwester._

dunli
: $x_1$ (jeder Typ) ist gleich $x_2$ (jeder Typ) in $x_3$ (Eigenschaft von $x_1$ und $x_2$ mit **kau**)

mitre
: $x_1$ ist $x_2$ Meter lang

du
: $x_1$ (jeder Typ) ist identisch mit $x_2$ (jeder Typ)

**dunli** vergleicht zwei Orte für eine einzelne Eigenschaft, während **du** für Identität vergleicht. Meine Schwester und ich sind gleich groß, aber wir sind nicht dieselbe Person. Clark Kent und Superman haben unterschiedliche Bewunderer, aber sie sind dieselbe Person.

Dasselbe gilt für diese beiden Verben:

> **mi frica do le ka nelci ma kau**
> *Wir unterscheiden uns darin, was wir mögen.*
> _Ich unterscheide mich von dir darin, was ich mag._

<!-- -->

> **le drata be mi cu kakne le ka sidju**
> *Jemand anderes als ich kann helfen.*

frica
: $x_1$ (jeder Typ) unterscheidet sich von $x_2$ (jeder Typ) in $x_3$ (Eigenschaft von $x_1$ und $x_2$ mit **kau**)

drata
: $x_1$ (jeder Typ) ist nicht dasselbe wie $x_2$ (jeder Typ)

### Das Konzept von ‘_nur_’

> **mi .e no le pendo be mi cu nelci le'e badna**
> _Ich und keiner meiner Freunde mögen Bananen._
> _Unter meinen Freunden bin ich der Einzige, der Bananen mag._

Das Konzept von _nicht nur_ wird ähnlich ausgedrückt:

> **mi .e le su'o pendo be mi cu nelci le'e badna**
> _Nicht nur ich mag Bananen unter meinen Freunden._
> _Ich und einige meiner Freunde mögen Bananen._

<!-- Ein präziseres Beispiel:

> **mi se steci le ka nelci le'e badna kei le'i pendo be mi**
> _Ich bin der Einzige, der Bananen unter meinen Freunden mag._ (übrigens, impliziert, dass du ein Freund von dir selbst bist)

se steci
: $x_1$ ist der Einzige in $x_2$ (Eigenschaft von $x_1$) unter $x_3$ (Menge) -->

<!-- Beachte, dass dieses Beispiel impliziert, dass du ein Freund von dir selbst bist :) Andernfalls, bitte, benutze eine noch präzisere Aussage:

> **mi se steci le ka nelci le'e badna kei le'i me mi .e le pendo be mi**
> _Ich bin der Einzige, der Bananen mag unter der Menge von mir und meinen Freunden._ -->

<!-- Wenn wir dies verneinen, erhalten wir:

> **na ku mi se steci le ka nelci le'e badna**
> _Es ist nicht wahr, dass nur ich Bananen mag._

— vielleicht mag niemand Bananen, vielleicht mögen ich + andere sie. -->

<!-- Noch ein interessantes Beispiel:

> **le'e troci cu se steci le ka snada**
> _Nur derjenige, der es versucht, hat Erfolg._
> `Wer es versucht, ist der Einzige, der Erfolg hat.`

> **le'e po'o zukte be le ka troci cu fliba**
> _Der Einzige, der nur versucht, scheitert._
> `Derjenige, der versucht und nichts anderes tut, scheitert.`

troci
: $x_1$ versucht, $x_2$ zu tun (Eigenschaft von $x_1$)

snada
: $x_1$ gelingt es, $x_2$ zu tun (Eigenschaft von $x_1$)

fliba
: $x_1$ scheitert daran, $x_2$ zu tun (Eigenschaft von $x_1$)

Und noch eine Lösung:

> **ro snada pu troci**
> _Jeder, der Erfolg hat, hat es versucht._

ro
: Zahl: jeder, alle

Wie Sie sehen können, bietet Lojban verschiedene Methoden, dasselbe auszudrücken, von denen einige erheblich von den englischen Formen abweichen können. -->

### ‘_Die meisten_’, ‘_viele_’ und ‘_zu viel_’

Wörter wie _die meisten_ und _viele_ sind auch Zahlen in Lojban:

<table>
<tbody><tr>
<td><b>ro</b>
</td>
<td><i>jeder</i>
</td></tr>
<tr>
<td><b>so'a</b>
</td>
<td><i>fast alle</i>
</td></tr>
<tr>
<td><b>so'e</b>
</td>
<td><i>die meisten</i>
</td></tr>
<tr>
<td><b>so'i</b>
</td>
<td><i>viele</i>, <i>eine Menge</i>
</td></tr>
<tr>
<td><b>so'o</b>
</td>
<td><i>mehrere</i>
</td></tr>
<tr>
<td><b>so'u</b>
</td>
<td><i>wenige</i>
</td></tr>
<tr>
<td><b>no</b>
</td>
<td><i>null</i>, <i>keine</i>
</td></tr>
<tr>
<td><b>su'e</b>
</td>
<td><i>höchstens</i>
</td></tr>
<tr>
<td><b>su'o</b>
</td>
<td><i>mindestens</i>
</td></tr>
<tr>
<td><b>za'u</b>
</td>
<td><i>mehr als …</i>
</td></tr>
<tr>
<td><b>du'e</b>
</td>
<td><i>zu viele</i>
</td></tr></tbody></table>

Einige Beispiele:

> **su'e re no le prenu ba klama**
> _Nicht mehr als 20 der Leute werden kommen._

<!-- -->

> **su'o pa le prenu cu prami do**
> _Mindestens eine Person liebt dich._

### ‘_niemals_’ — «**no roi**», ‘_immer_’ — «**ro roi**»

Begriffe, die die Anzahl der Male angeben:

- **no roi** = _niemals_
- **pa roi** = _einmal_
- **re roi** = _zweimal_
- **ci roi** = _dreimal_

…

- **so'i roi** = _viele Male_
- **so'u roi** = _ein paar Mal_
- **du'e roi** = _zu viele Male_
- **ro roi** = _immer_

> **mi du'e roi klama le zarci**
> _Ich gehe zu oft zum Markt._

zarci
: $x_1$ ist ein Markt

> **mi pu re roi klama le zarci**
> _Ich bin zweimal zum Markt gegangen._

Ohne **pu** kann die Konstruktion **re roi** bedeuten, dass ich einmal zum Markt gegangen bin, aber das zweite Mal wird erst in der Zukunft passieren. Diese zeitbezogenen Partikel können mit einem Argument nach ihnen verwendet werden:

> **mi klama ti pa roi le jeftu**
> _Ich komme einmal pro Woche hierher._

### ‘_zum ersten Mal_’ — «**pa re'u**», ‘_zum letzten Mal_’ — «**ro re'u**»

- **pa re'u** = _zum ersten Mal_
- **re re'u** = _zum zweiten Mal_

…

- **za'u re'u** = _wieder_
- **ro re'u** = _zum letzten Mal_

Die zeitbezogene Partikel **re'u** funktioniert wie **roi**, gibt aber die Anzahl der Wiederholungen an, für die das Ereignis eintritt.

Vergleiche:

> **mi pa roi klama le muzga**
> _Ich habe das Museum einmal besucht._

<!-- -->

> **mi pa re'u klama le muzga**
> _Ich habe das Museum zum ersten Mal besucht._

<!-- -->

> **mi za'u roi klama le muzga**
> _Ich habe das Museum mehrmals besucht._

<!-- -->

> **mi za'u re'u klama le muzga**
> _Ich habe das Museum wieder besucht._

<!-- -->

> **mi za'u pa roi klama le muzga**
> _Ich habe das Museum mehr als einmal besucht._

<!-- -->

> **mi za'u pa re'u klama le muzga**
> _Ich habe das Museum nicht zum ersten Mal besucht (vielleicht zum zweiten/dritten usw.)_

vitke
: besuchen (jemanden oder etwas)

Beachte den Unterschied zwischen:

za'u re'u
: wieder, nicht zum ersten Mal

re re'u
: zum zweiten Mal (auch hier ist kein Kontext nötig, und die genaue Anzahl der Male wird angegeben)

### Modalpartikeln: ihre Position innerhalb einer Relation

> **le nu tcidu kei ca cu nandu**
> _Lesen ist jetzt schwierig._

<!-- -->

> **ca ku le nu tcidu cu nandu**
> _Jetzt ist Lesen schwierig._

Unbestimmte Begriffe ohne Argumente danach können im Satz verschoben werden, indem man **ku** nach ihnen hinzufügt.

**ku** verhindert, dass die folgenden Argumentbegriffe an solche Begriffe angehängt werden. Vergleiche:

> **ca le nu tcidu cu nandu**
> _Beim Lesen ist es schwierig._

Hier sind mehrere Stellen, an denen Modalpartikeln stehen können.

- Der Modalbegriff modifiziert die Relation rechts von ihm:

 >**ca ku mi citka**
 >_Jetzt esse ich._

  — hier wird der Begriff mit einem Wort **ku** als abgeschlossen gekennzeichnet.

 >**ca le cabdei mi citka**
 >_Heute esse ich._

  — hier hat der Begriff ein Argument danach.

 >**mi ca citka**
 >_Ich esse jetzt._

  — hier ist die Modalpartikel Teil des Hauptrelationskonstrukts und ohne Argument.

- Der Modalausdruck wird auf die gesamte Relation angewendet:

 >**mi citka ca**
 >_Ich esse jetzt._

  — hier der Modalausdruck am Ende der Relation.

### Aussagen mit Modalausdrücken verbinden

> **mi pinxe le jisra ca le nu do co'i klama le zdani**
> _Ich trinke den Saft, wenn du nach Hause kommst._

<!-- -->

> **mi pinxe le jisra .i ca bo do co'i klama le zdani**
> _Ich trinke den Saft, und gleichzeitig kommst du nach Hause._

Die beiden Beispiele vermitteln die gleiche Bedeutung. Die zweite Option wird hauptsächlich verwendet, wenn eine der ursprünglichen Relationen sperrig klingt.

Eine weitere Verwendung besteht darin, Modalausdrücke aus dem Geltungsbereich anderer Modalausdrücke zu entfernen:

> **mi na ku te vecnu ki'u le nu kargu**
> _Es ist nicht wahr, dass ich kaufe, weil es teuer ist._

In diesem Beispiel könnte man annehmen, dass ich nur Dinge kaufe, wenn sie teuer sind. Das ist jedoch nicht der Fall.

Hier negiert **na ku**, dass _ich Dinge kaufe, weil sie teuer sind_. **na ku** wird auf die gesamte Relation angewendet und "deckt" somit **ki'u** ab.

> **mi na ku te vecnu .i ki'u bo kargu**
> _Ich kaufe nicht. Es ist, weil es teuer ist._

In diesem Fall kaufe ich keine Dinge. Warum? Weil sie teuer sind. Vielleicht bevorzuge ich nur billige Dinge.

Hier wird **ki'u** in einem anderen Satz platziert. Daher erstreckt sich **na ku** nicht darauf.

Beide Beispiele könnten als _Ich kaufe nicht, weil es teuer ist._ übersetzt werden. Sie bedeuten jedoch unterschiedliche Dinge.

Eine spezielle Regel gilt für die Verwendung von **.i ba bo** und **.i pu bo**. Vergleiche:

> **mi cadzu pu le nu mi citka**
> _Ich gehe, bevor ich esse._

<!-- -->

> **mi cadzu .i ba bo mi citka**
> _Ich gehe, und dann esse ich._

**.i ba bo** bedeutet _danach, dann_. Der Satz nach **.i ba bo** bezieht sich auf etwas, das später stattfand als das, was in der vorherigen Relation stattfand.

**pu** wird in **ba** geändert und umgekehrt. Diese spezielle Regel für Lojban wurde nach dem Vorbild natürlicher Sprachen erstellt. Man muss sich also nur dieses spezielle Verhalten dieser beiden Wörter merken.

### Existierende Dinge, ‘_es gibt …_’

Es gibt tatsächlich drei Wörter in der **da**-Serie: **da**, **de** und **di**. Wir verwenden sie, wenn wir uns in einem Diskurs auf verschiedene Objekte beziehen:

> **ci le mlatu cu citka re le finpe**
> _Es gibt drei Katzen, es gibt zwei Fische für jede Katze, und jede Katze frisst zwei Fische._

Wenn du mehr solcher Wörter in einem Diskurs benötigst, füge ein Suffix **xi** und dann eine beliebige Zahl (die wir als Index bezeichnen können) hinzu. Also,

- **da xi pa** ist dasselbe wie einfach **da**,
- **da xi re** ist dasselbe wie **de**,
- **da xi ci** ist dasselbe wie **di**
- **da xi vo** ist das vierte "etwas" und so weiter …

### Thema und Kommentar. «**zo'u**»

Manchmal ist es nützlich, das Thema einer Beziehung zu zeigen und dann einen Kommentar dazu abzugeben:

> **le'e finpe zo'u mi nelci le'e salmone**
> _Was Fische betrifft, mag ich Lachs._

salmone
: … ist ein Lachs

zo'u
: beendet das Thema und beginnt den Kommentar der Beziehung

**zo'u** ist nützlicher, wenn ein Pronomen wie **da** im Thema definiert und dann im Kommentar verwendet wird:

> **su'o da zo'u mi viska da**
> _Es gibt ein Ding, das ich sehe._

<!-- -->

> **ro da poi gerku zo'u mi nelci da**
> _Für jedes Ding, das ein Hund ist: Ich mag es._
> _Ich mag alle Hunde._

<!-- -->

> **da de zo'u da viska de**
> _Es gibt **da** und **de**, sodass **da** **de** sieht._

Die beiden Pronomen **da** und **de** zeigen an, dass es zwei Dinge gibt, die in der Beziehung stehen, dass eines das andere sieht. Es könnte der Fall sein, dass die vermeintlichen zwei Dinge wirklich nur ein einziges Ding sind, das sich selbst liebt: Nichts im Satz schließt diese Interpretation aus, weshalb die umgangssprachliche Übersetzung nicht sagt _Jemand sieht jemand anderen._ Die Dinge, auf die sich verschiedene Pronomen der **da**-Serie beziehen, können unterschiedlich oder gleich sein.

Es ist völlig in Ordnung, dass diese Pronomen mehr als einmal im selben Satz erscheinen:

> **da zo'u da prami da**
> _Es gibt **da**, sodass **da** **da** liebt. Es gibt jemanden, der sich selbst liebt._

Es ist nicht notwendig, dass ein Pronomen das direkte Argument der Beziehung ist:

> **da zo'u le gerku pe da cu viska mi**
> _Es gibt **da**, sodass der Hund von ihnen mich sieht. Jemandes Hund sieht mich._

### ‘_any_’ und ‘_some_’ in Beispielen

Die Wörter _any_ und _some_ sowie ihre Derivate haben viele Bedeutungen im Englischen. Wir sollten vorsichtig sein, wenn wir die beabsichtigte Bedeutung übersetzen:

Übersetzen als **da**:

- _some_: etwas Unbestimmtes:

 >**da pu klama .i je ko smadi le du'u da me ma kau**
 >_Jemand kam. Rate, wer es war._

  <!-- -->

 >**mi pu tirna da .i je mi fliba le ka jimpe le du'u da mo kau**
 >_Ich hörte etwas, aber ich verstehe nicht, was es war._

- _some_ in Fragen wird zu _anything_, _anybody_; im Lojban ist es immer noch **da**:

 >**xu su'o da pu klama**
 >_Kam jemand?_

- _some_ bei Befehlen, Anfragen oder Vorschlägen:

 >**.e'u mi'o pilno su'o da poi drata**
 >_Lass uns etwas anderes ausprobieren. Lass uns andere Dinge ausprobieren._

  <!-- -->

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Lass uns woanders versuchen._

- _any_ kann in inneren Beziehungen verwendet werden:

 >**mi rivbi le ka jdice da**
 >_Ich vermied es, irgendeine Entscheidung zu treffen._

 Wie in Beziehungen innerhalb modaler Begriffe:

 >**ba le nu do zgana da kei ko klama**
 >_Nachdem du etwas bemerkst, komm!_

- Umfang: _any_ wird im Englischen bei Verneinungen verwendet, während Lojban **na ku** verwendet, aber dann immer noch **da**:

 >**mi na ku viska su'o da poi prenu**
 >_Ich sehe niemanden._

- _any_ wird verwendet, wenn keine Unterscheidung zwischen den Mitgliedern gemacht wird, über die wir sprechen:

 >**.au nai mi tavla su'o da poi na ku slabu mi**
 >_Ich möchte nicht mit irgendjemandem sprechen._

- Umfang: Die Verneinung sollte in einer geeigneten Beziehung verwendet werden, wie unten gezeigt:

 >**mi jinvi le du'u na ku da jimpe**
 >_Ich denke nicht, dass jemand versteht._

 Dies kann umformuliert werden als:

 >**mi jinvi le du'u no da jimpe**
 >_Ich denke, dass niemand versteht._

- In Vergleichen wird _every_ zu _any_ und als **ro da** übersetzt:

 >**do zmadu ro da le ka se canlu**
 >_Du bist größer als jeder._
 >`Du übertriffst alle in der Größe.`

- Bei der Auswahl wird _any_ verwendet und als **ro da** übersetzt:

 >**ro da poi do nelci zo'u .e'a do citka da**
 >_Du darfst alles essen, was du magst._
 >`Für alles, was du magst, erlaube ich dir, es zu essen.`

- Für Begriffe wie _anyone_ und _somewhere_:

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Lass uns woanders versuchen._

 Hier bedeutet **su'o da poi drata** _irgendeine andere Sache oder Dinge, Ort oder Orte_. Die Anzahl solcher Orte ist nicht spezifiziert, obwohl jeder solcher Ort passen könnte.

Um _irgendeinen Ort, aber nur einen Ort_ zu sagen, benutze:

>**.e'u mi'o troci bu'u pa da poi drata**
>_Lass uns an einem anderen Ort versuchen._

- Übersetzen von _any_ als **le'e** in generischen Aussagen:

>**le'e gerku cu se tuple le vo da**
>_Jeder Hund hat vier Beine. Hunde werden erwartet, vier Beine zu haben._

- Verwendung von **le** beim Beschreiben spezifischer Objekte, Orte oder Ereignisse:

>**le drata zo'u .e'u mi'o pilno ri**
>_Das andere Ding, lass es uns benutzen._

>**le drata stuzi zo'u .e'u mi'o troci bu'u ri**
>_Der andere Ort, lass es uns dort versuchen._

### Zusammenfassung: Welche Konstrukte beeinflusst der Geltungsbereich?

Der Geltungsbereich wird nur durch folgende Elemente erzeugt:

- Grenzen von Relationen,
- Modalbegriffe und Modalpartikel des Hauptrelationskonstrukts,
- Argumentbegriffe, die mit Zahlen beginnen (wie **pa le prenu** — _eine der Personen_).
<!-- - diskursive Interjektionen **po'o**, **ji'a**. -->

**da**, **de**, **di**, wenn sie ohne Prenex und ohne explizite Zahl davor verwendet werden, sollen **su'o da**, **su'o de**, **su'o di** bedeuten und erzeugen somit auch einen Geltungsbereich.

Daher ändert die relative Reihenfolge solcher Konstrukte die Bedeutung:

> **pa le prenu ca ku zvati**
> _Es gibt eine Person, die jetzt anwesend ist._

> **ca ku pa le prenu ca zvati**
> _Jetzt gibt es eine Person._

Der Geltungsbereich ist nicht relevant für Relationenkonstrukte und für Argumente, die mit **le** beginnen (wie **le prenu** oder **le re prenu**). Beide Sätze bedeuten dasselbe:

> **le prenu ca ku zvati le zdani**
> **ca ku le prenu cu zvati le zdani**
> **ca ku fe le zdani fa le prenu cu zvati**
> _Menschen sind jetzt anwesend._

Der Geltungsbereich des Modalbegriffs erstreckt sich von seiner Verwendung bis zum rechten Ende der Relation und all ihrer inneren Relationen (falls vorhanden).

Hier steht **ki'u le nu kargu** unter dem Geltungsbereich von **na ku**:

> **na ku mi te vecnu ki'u le nu kargu**
> _Es ist nicht wahr, dass: Ich kaufe, weil es teuer ist._

Aber hier steht **ki'u le ne kargu** nicht unter dem Geltungsbereich von **na ku**. **ki'u** wird auf den gesamten vorherigen Satz angewendet, einschließlich **na ku**:

> **mi na ku te vecnu .i ki'u bo kargu**
> _Ich kaufe nicht. Es ist, weil es teuer ist._
