## Lektion 4. Übung

Jetzt kennen wir die wichtigsten Teile der Grammatik und können anfangen, neue Wörter durch Situationen zu sammeln.

### Umgangssprachliche Ausdrücke

Hier sind einige gängige Strukturen, die von fließenden Sprechern von Lojban verwendet werden, zusammen mit Beispielen, die ihre Verwendung veranschaulichen.

Sie können Ihnen helfen, sich schneller an das umgangssprachliche Lojban zu gewöhnen.

- <dl><dt>.i ku'i</dt><dd>Aber…</dd></dl>
 > **mi djuno .i ku'i mi na ku djica**
 > _Ich weiß. Aber ich will nicht._
- <dl><dt>mi djica le nu</dt><dd>Ich will, dass …</dd></dl>

 > **mi djica le nu mi sipna**
 > _Ich will schlafen._
 > `Ich will, dass ich schlafe.`
- <dl><dt>mi djuno le du'u ma kau</dt><dd>Ich weiß, was/wer …</dd></dl>

 > **mi djuno le du'u ma kau smuni zo coi**
 > _Ich weiß, was **coi** bedeutet._

 <!-- -->

 > **mi na ku djuno**
 > _Ich weiß nicht._
- <dl><dt>jinvi le du'u</dt><dd>… hat die Meinung, dass …</dd></dl>

 > **mi jinvi le du'u la .lojban. cu zabna**
 > _Ich denke, dass Lojban cool ist._

 <!-- -->

 > **coi ro do**
 > _Hallo, alle zusammen!_

 <!-- -->

 > **co'o ro do**
 > _Tschüss, alle zusammen!_
- <dl><dt>jinvi le du'u</dt><dd>… hat die Meinung, dass …</dd></dl>

 > **ai mi cliva .i co'o**
 > _Ich werde gehen. Tschüss!_
- <dl><dt>.ei mi</dt><dd>Ich sollte …</dd></dl>

 > **.ei mi citka .i co'o**
 > _Ich sollte essen. Tschüss!_
- <dl><dt>ca le nu</dt><dd>wenn …</dd></dl>

 > **mi pu bebna ca le nu mi citno**
 > _Ich war dumm, als ich jung war._
- <dl><dt>va'o le nu</dt><dd>vorausgesetzt, dass …</dd></dl>

 > **va'o le nu do djica kei mi ka'e ciksi**
 > _Wenn du willst, kann ich es erklären._
- <dl><dt>simlu le ka</dt><dd>… scheint … zu sein</dd></dl>

 > **simlu le ka zabna**
 > _Es scheint cool zu sein._
- <dl><dt>ca le cabdei</dt><dd>heute</dd></dl>

 > **pu ce'e ca le cabdei mi surla**
 > _Heute habe ich mich ausgeruht._
- <dl><dt>mi nelci</dt><dd>Ich mag</dd></dl>

 > **mi nelci le mlatu**
 > _Ich mag die Katze._
- <dl><dt>le nu pilno</dt><dd>unter Verwendung von …</dd></dl>

 > **na ku le nu pilno le vlaste cu nandu**
 > _Die Verwendung von Wörterbüchern ist nicht schwer._
- <dl><dt>kakne le ka</dt><dd>fähig zu …</dd></dl>

 > **xu do kakne le ka sutra tavla**
 > _Bist du in der Lage, schnell zu sprechen?_
- <dl><dt>tavla fi</dt><dd>über … sprechen</dd></dl>

 > **.e'ei tavla fi le skami**
 > _Lass uns über Computer reden!_
- <dl><dt>mutce le ka</dt><dd>sehr …</dd></dl>

 > **mi mutce le ka se cinri**
 > _Ich bin sehr interessiert._
- <dl><dt>troci le ka</dt><dd>… versucht zu …</dd></dl>

 > **mi troci le ka tavla fo la .lojban.**
 > _Ich versuche, in Lojban zu sprechen._
- <dl><dt>rinka le nu</dt><dd>(Ereignis) führt zu …</dd></dl>

 > **le nu mi tadni la .lojban. cu rinka le nu mi jimpe fi do**
 > _Dass ich Lojban lerne, lässt mich dich verstehen._
- <dl><dt>gasnu le nu</dt><dd>(Agent) verursacht …</dd></dl>

 > **mi pu gasnu le nu le skami pe mi co'a spofu**
 > _Ich habe es so gemacht, dass mein Computer kaputt ging._
- <dl><dt>xusra le du'u</dt><dd>behaupten, dass …</dd></dl>

 > **xu do xusra le du'u mi na ku drani**
 > _Behauptest du, dass ich nicht recht habe?_
- <dl><dt>kanpe le du'u</dt><dd>erwarten (im Sinne von Einschätzung, Vorhersage), dass …</dd></dl>

 <!-- -->

 > **mi na ku kanpe le du'u mi jinga**
 > _Ich erwarte nicht, dass ich gewinne._

### Ein einfacher Dialog

> **coi la .alis.**
> _Hallo, Alice!_
<!-- -->
> **coi la .doris.**
> _Hallo, Doris!_
<!-- -->
> **do mo**
> _Wie geht's?_
<!-- -->
> **mi kanro .i mi ca tadni la .lojban. .i mi troci le ka tavla do**
> _Ich bin gesund. Ich lerne jetzt Lojban. Ich versuche, mit dir zu sprechen._

kanro
: gesund sein

tadni
: … (etwas) lernen

troci
: … versuchen (etwas zu tun)

tavla
: mit [jemandem] sprechen

> **zabna .i ma tcima ca le bavlamdei**
> _Gut. Wie wird das Wetter morgen?_

zabna
: … ist schön, cool

tcima
: … ist das Wetter

ca
: zu (einer Zeit)

le bavlamdei
: morgen (Tag als Ereignis)

> **mi na ku djuno .i le solri sei mi pacna**
> _Ich weiß es nicht. Es wird sonnig sein, hoffe ich._

djuno
: wissen (Fakt)

le solri
: die Sonne

Beachte, dass **le solri cu tcima** (wörtlich _die Sonne ist das Wetter_) die Art und Weise ist, **tcima** im Lojban zu verwenden.

sei
: Kommentar beginnt

pacna
: hoffen (auf ein Ereignis)

> **mi jimpe**
> _Ich verstehe._

> **co'o**
> _Auf Wiedersehen._

### Menschliche Sinne

> **ju'i la .alis.**
> _Hey, Alice!_

ju'i
: Vokativ, der Aufmerksamkeit erregt: _Hey! Psst! Ahem! Aufmerksamkeit!_

> **re'i**
> _Hören._

re'i
: Vokativ: _Ich bin bereit, Informationen zu erhalten._

> **xu do viska ta**
> _Siehst du das Ding in deiner Nähe?_

Auf Englisch sagen wir _Can you see_, auf Lojban sagen wir einfach **xu do viska** — _Du siehst?_

----

Beziehungen, die Wahrnehmung beschreiben, werden nach dem Dialog erklärt.

> **viska .i plise**
> **.i le plise cu xunre .i skari le ka xunre**
> _Ja. Es ist ein Apfel._
> _Der Apfel ist rot. Er ist rot gefärbt._

> **xu do viska le tarmi be le plise**
> _Kannst du die Form des Apfels sehen?_

<!-- -->

> **viska .i le plise cu barda**
> _Ja. Der Apfel ist groß._

<!-- -->

> **xu do jinvi le du'u le plise ca makcu**
> _Denkst du, dass der Apfel reif ist?_

makcu
: … ist reif

> **.au mi zgana le sefta be le plise**
> _Ich möchte ihn ertasten._

> **.i ua xutla**
> _Oh, er ist glatt._

> **.i mi pacna le nu makcu ie**
> _Ich hoffe, dass er reif ist, ja._

<!-- -->

> **panci pei**
> _Wie steht es mit dem Geruch?_

> **.i .e'o do sumne le plise**
> _Bitte, riech daran._

<!-- -->

> **le xrula cu panci**
> _Er riecht nach Blumen._

> **.i .au mi zgana le vrusi be le plise**
> _Ich möchte den Apfel probieren._

> **.i .oi nai le kukte cu vrusi**
> _Lecker, er schmeckt süß._

> **.i .oi**
> _Oh nein._

le xrula
: die Blume(n)

<pixra url="/assets/pixra/cilre/xrula.webp" caption="xrula" definition="flower"></pixra>

> **ma pu fasnu**
> _Was ist passiert?_

<!-- -->

> **mi pu farlu**
> _Ich bin gefallen._

farlu
: ... fällt herunter auf ...

<!-- -->

> **xu do cortu**
> _Hast du Schmerzen?_

<!-- -->

> **cortu .i mi cortu le cidni**
> _Ja, ich habe Schmerzen im Knie._

> **.i na ku ckape**
> _Es ist nicht gefährlich._

> **.i ca ti mi ganse le nu da vi zvati**
> _Und jetzt kann ich die Anwesenheit von jemandem hier spüren._

<!-- -->

> **doi la .alis. do cliva .e'o sai**
> _Alice, bitte, komm sofort zurück!_

<!-- -->

> **ko denpa .i mi ca tirna le sance**
> _Warte, ich höre ein Geräusch._

<!-- -->

> **le sance be ma**
> _Ein Geräusch von was?_

<!-- -->

> **mi pu tirna le nu le prenu cu tavla**
> _Ich habe eine Person sprechen gehört._

> **.i ca ti mi zgana le lenku**
> _Jetzt ist mir kalt._

<!-- -->

> **ju'i la .alis.**
> _Hey, Alice!.._

In diesem Dialog wurden die wichtigsten Konzepte für menschliche Sinne berührt. In den folgenden Abschnitten werden wir ihre Platzstrukturen erklären, zusammen mit zusätzlichen Beziehungen und Beispielen.

#### Sehen

viska
: $x_1$ sieht $x_2$ (Objekt, Form, Farbe)

skari
: $x_1$ ist ein Objekt mit der Farbe $x_2$ (Eigenschaft)

tarmi
: $x_1$ ist die Form von $x_2$

cukla
: $x_1$ ist rund (in Form)

<pixra url="/assets/pixra/cilre/coha_viska.webp" caption="le prenu co'a viska le cipni" definition="Die Person bemerkt, beginnt den Vogel zu sehen."></pixra>

> **mi viska le plise**
> _Ich sehe den Apfel._

> **mi viska le tarmi be le plise**
> _Ich sehe die Form des Apfels._

> **.i le plise cu se tarmi le cukla**
> _Der Apfel ist rund._


<!-- -->
<!-- > **mi viska le se skari be le plise**
> _Ich sehe die Farbe des Apfels._ -->

> **.i le plise cu skari le ka xunre**
> _Der Apfel ist rot gefärbt._

Hinweis: Wir können sowohl _die Form des Apfels sehen_ als auch _den Apfel sehen_ sagen.

#### Hören

tirna
: $x_1$ hört $x_2$ (Objekt oder Klang)

<pixra url="/assets/pixra/cilre/le_prenu_cu_tirna_lei_djacu.webp" caption="le prenu cu tirna lei djacu" definition="Die Person hört das Wasser."></pixra>

> **mi tirna le palta**
> _Ich höre den Teller_

<!-- -->

> **mi tirna le sance be le palta poi ca'o porpi**
> _Ich höre das Geräusch eines fallenden Tellers._

> **.i le palta cu se sance le cladu**
> _Es klingt laut._


le palta
: der Teller

cladu
: $x_1$ ist laut

tolycladu
: $x_1$ ist leise im Klang

tonga
: $x_1$ ist ein Ton von $x_2$

Wir können **cladu** und ähnliche Wörter direkt verwenden:

> **mi tirna le cladu**
> _Ich höre etwas Lautes._

<!-- -->

> **mi tirna le tolycladu**
> _Ich höre etwas Leises._

<!-- -->

> **mi tirna le tonga be le palta poi farlu**
> _Ich höre den Ton des fallenden Tellers._

Ähnlich wie beim Sehen können wir sagen _ein Geräusch hören_ und _etwas hören, das das Geräusch erzeugt_:

> **— ma sance gi'e se tirna do**
> _— Welches Geräusch hörst du?_

> **— le zgike**
> _— Die Musik._

<!-- -->

> **— do tirna le sance be ma**
> _— Du hörst ein Geräusch von was?_

> **— le plise poi co'i farlu**
> _— Der Apfel, der heruntergefallen ist._

#### Wahrnehmung im Allgemeinen

Wir können auch das vage **ganse** verwenden — _einen Reiz wahrnehmen_.

ganse
: $x_1$ nimmt den Reiz $x_2$ (Objekt, Ereignis) durch Mittel $x_3$ wahr

ganse le glare
: die Hitze fühlen

ganse le lenku
: die Kälte fühlen

> **mi ganse le plise**
> _Ich nehme den Apfel wahr._

<!-- -->

Für die Beobachtung unserer Wahrnehmungen können wir **zgana** verwenden:

<pixra url="/assets/pixra/cilre/zgana_le_sefta.webp" caption="le prenu cu zgana le sefta be le xrula" definition="Die Person tastet die Oberfläche der Blume ab."></pixra>

> **mi zgana le tarmi be le plise**
> _Ich beobachte die Form eines Apfels._

> **.i le plise cu se tarmi le'e cukla**
> _Der Apfel ist rund._

zgana
: $x_1$ bemerkt, beobachtet, schaut $x_2$. Nicht auf das Sehen beschränkt

Einige Argumente können mit verschiedenen sensorischen Beziehungen verwendet werden. Zum Beispiel können wir

viska le sefta
: die Oberfläche sehen

zgana le sefta
: die Oberfläche abtasten


#### Geruchssinn

sumne
: $x_1$ riecht $x_2$ (Geruch)

panci
: $x_1$ ist ein Geruch von $x_2$ (Objekt)

<pixra url="/assets/pixra/cilre/sumne.webp" caption="le mlatu cu sumne le xrula" definition="Die Katze riecht die Blume."></pixra>

> **mi sumne le xrula**
> _Ich rieche die Blume._


<!-- -->

> **mi sumne le panci be le za'u xrula**
> _Ich rieche den Geruch von Blumen._

<!-- -->

> **mi sumne le panci be le plise**
> _Ich rieche den Geruch des Apfels._

> **.i le plise cu se panci le xrula**
> _Der Apfel riecht nach Blumen._

Beachten Sie, dass Englisch verwirrend sein kann, wenn es darum geht, zwischen dem Riechen eines Geruchs und dem Riechen eines Objekts, das diesen Geruch erzeugt, zu unterscheiden. Wir sagen _den Apfel riechen_, _der Apfel riecht nach Blumen (hat den Duft von Blumen)_. Diese zweifache Unterscheidung ist wichtig, weil ein Apfel aromatische Partikel produziert, die sich vom Apfel selbst unterscheiden. Dasselbe gilt für einen fallenden Teller und sein Geräusch — wir möchten sie möglicherweise nicht vermischen.

Im Lojban können wir diese Fälle leicht trennen, wie in den obigen Beispielen gezeigt.


#### Geschmackssinn

vrusi
: $x_1$ ist ein Geschmack von $x_2$

<pixra url="/assets/pixra/cilre/se_vrusi_lo_ka_kukte.webp" caption="le prenu cu zgana le vrusi be le grute" definition="Die Person schmeckt, beobachtet den Geschmack der Frucht."></pixra>

> **mi zgana le vrusi be le grute**
> _Ich schmecke den Apfel._
> `Ich beobachte den Geschmack der Frucht`

le grute
: die Frucht, die Früchte
<!-- -->

> **.i le plise cu se vrusi le titla**
> _Der Apfel schmeckt süß._

titla
: … ist süß, … ist ein Süßer

#### Tastsinn

sefta
: $x_1$ ist eine Oberfläche von $x_2$

> **mi zgana le sefta be le plise**
> _Ich taste, fühle die Oberfläche des Apfels._

<!-- -->

> **.i le plise cu se sefta le xutla**
> _Der Apfel hat eine glatte Oberfläche._

#### Schmerz

> **mi cortu le birka be mi**
> _Ich fühle Schmerz in meinem Arm._
> _Mein Arm tut weh._

<!-- -->

<pixra url="/assets/pixra/cilre/cortu.webp" caption="mi cortu le cidni be mi" definition="Mein Knie tut weh."></pixra>

> **mi cortu le cidni**
> _Ich fühle Schmerz in meinem Knie, mein Knie tut weh._

cortu
: $x_1$ hat Schmerzen im Organ $x_2$, welches ein Teil des Körpers von $x_1$ ist

cidni
: $x_1$ ist ein Knie von $x_2$

#### Farben

Verschiedene Sprachen verwenden unterschiedliche Wortsets, um Farben zu benennen. Einige Sprachen beziehen sich einfach auf Farben, indem sie andere "Prototyp"-Objekte mit ähnlichen Farben, Schattierungen oder Formen referenzieren. Im Lojban verwenden wir alle Optionen:

> **ti xunre**
> _Das ist rot._

xunre
: $x_1$ ist rot

> **ti skari le ka xunre**
> _Das ist rot. Das hat die Farbe von roten Dingen._

<!-- -->

> **ti skari le ka ciblu**
> _Das hat die Farbe von Blut._

le ciblu
: das Blut

Hier sind einige Farbbeispiele, die mit der englischen Sprache übereinstimmen. Sie können auch andere Farbwörter verwenden, die widerspiegeln, wie Sprecher verschiedener Sprachen Dinge typischerweise kategorisieren.

> **le tsani cu xunre ca le cerni**
> _Der Himmel ist rot am Morgen._

le tsani
: der Himmel

> **.i le solri cu simlu le ka narju**
> _Die Sonne scheint orange zu sein._

le solri
: die Sonne

<pixra url="/assets/pixra/cilre/tsani.webp" caption="tsani .i solri" definition="Der Himmel. Die Sonne."></pixra>

simlu
: $x_1$ sieht aus wie $x_2$ (Eigenschaft von $x_1$)

> **.i le pelxu xrula cu se farna le solri**
> _Gelbe Blumen sind zur Sonne hin ausgerichtet._

se farna
: $x_1$ ist in Richtung $x_2$ orientiert

farna
: $x_1$ ist die Richtung von $x_2$

> **.i le pezli be le tricu cu crino**
> _Blätter von Bäumen sind grün._

pezli
: $x_1$ ist ein Blatt von $x_2$

le tricu
: Baum

> **.i mi zvati le korbi be le blanu xamsi**
> _Ich bin am Rand eines blauen Meeres._

zvati
: … ist anwesend bei …

korbi
: $x_1$ ist der Rand von $x_2$

le xamsi
: Meer

> **.i mi catlu le prenu noi dasni le zirpu taxfu**
> _Ich schaue eine Person an, die das violette Kleid trägt._

dasni
: $x_1$ trägt $x_2$ (etwas)

xunre
: $x_1$ ist rot

narju
: $x_1$ ist orange

pelxu
: $x_1$ ist gelb

crino
: $x_1$ ist grün

blanu
: $x_1$ ist blau

zirpu
: $x_1$ ist violett

Andere nützliche Beziehungen:

> **le gusni be le manku pagbu pu na ku carmi**
> _Das Licht, das dunkle Bereiche beleuchtet, war nicht intensiv._

<!-- -->

> **le gusni be fi le solri pu carmi**
> _Das Licht von der Sonne war intensiv._

gusni
: $x_1$ ist ein Licht, das $x_2$ von der Lichtquelle $x_3$ beleuchtet

carmi
: $x_1$ ist intensiv, hell

manku
: $x_1$ ist dunkel

### «**sipna**» — ‘_schlafen_’, «**sanji**» — ‘_bewusst sein_’

Die folgenden Beispiele veranschaulichen einige grundlegende Aspekte des Geistes:

> **pu ku mi cikna gi'e ku'i na ganse le nu do klama**
> _Ich war wach, aber habe deine Ankunft nicht bemerkt._

<!-- -->

> **pu ku ca le nu mi sipna kei mi ganse ku'i le nu do klama**
> _Während ich schlief, habe ich dennoch deine Ankunft gespürt._

<!-- -->

<pixra url="/assets/pixra/cilre/le_prenu_cu_senva_tuha_le_nei.webp" caption="mi ca'o sipna gi'e sanji le nu mi sipna" definition="Ich schlafe und bin mir bewusst, dass ich schlafe."></pixra>

> **pu ku mi ca'o sipna gi'e sanji le nu mi sipna**
> _Ich schlief und war mir bewusst, dass ich schlief._
> _Ich hatte einen luziden Traum._

<!-- -->

> **mi sanji le nu mi sanji**
> _Ich bin mir bewusst, dass ich mir bewusst bin._
> _Ich bin selbstbewusst._

sipna
: $x_1$ schläft

cikna
: $x_1$ ist wach

ganse
: Beobachter $x_1$ bemerkt, erkennt einen Reiz (Ereignis) durch Mittel $x_3$

sanji
: $x_1$ ist sich bewusst, bewusst von $x_2$ (Ereignis)

**ganse** impliziert keine mentale Verarbeitung; es beschreibt nur die Wahrnehmung, Erkennung, Detektion eines Reizes über sensorische Kanäle (spezifiziert in $x_3$).

Auf der anderen Seite beschreibt **sanji** passives Wahrnehmen, das mentale Verarbeitung beinhaltet, aber nicht unbedingt über sensorische Eingaben (einige mentale Beziehungen werden nicht von den Sinnen erkannt).

### Emotionen: «**cmila**» — ‘_lachen_’, «**cisma**» — ‘_lächeln_’

> **coi**
> **.i ma nuzba**
> **.i do simlu le ka badri**
> _Hallo._
> _Was gibt's Neues?_
> _Du scheinst traurig zu sein._

badri
: $x_1$ ist traurig über $x_2$

<pixra url="/assets/pixra/cilre/badri.webp" caption="le prenu cu simlu lo ka badri" definition="Die Person scheint traurig zu sein."></pixra>

> **mi steba le nu le bruna be mi co'a speni le ninmu**
> _Ich bin frustriert, dass mein Bruder die Frau heiratet._

steba
: $x_1$ fühlt Frustration über $x_2$

> **mi se cfipu**
> **.i xu do na ku gleki le nu le bruna co'a speni**
> _Ich bin verwirrt._
> _Du bist nicht glücklich, dass der Bruder heiratet?_

se cfipu
: $x_1$ ist verwirrt über $x_2$

gleki
: $x_1$ ist glücklich über $x_2$

> **ie**
> **.i le ninmu cu pindi**
> **.i le ninmu na ku ponse le jdini**
> **.i mi na ku kakne le ka ciksi**
> _Ja._
> _Die Frau ist arm._
> _Sie hat kein Geld._
> _Ich bin nicht in der Lage zu erklären._

le jdini
: das Geld

kakne
: $x_1$ ist fähig zu $x_2$ (Eigenschaft von $x_1$)

> **ua**
> **.i la'a do kanpe le nu le ninmu na ku prami le bruna**
> _Ah!_
> _Wahrscheinlich erwartest du, dass die Frau den Bruder nicht mag._

la'a
: Interjektion: wahrscheinlich, es ist wahrscheinlich

kanpe
: $x_1$ erwartet $x_2$ (ein Ereignis)

> **mi terpa le nu le ninmu ba tarti lo xlali**
> **.i ku'i le bruna cu cisma ca ro nu ri tavla le ninmu**
> **.i ri ta'e cmila**
> _Ich habe Angst, dass sie sich schlecht benehmen wird._
> _Aber der Bruder lächelt jedes Mal, wenn er mit ihr spricht._
> _Und sie lacht normalerweise._

terpa
: $x_1$ fürchtet $x_2$

cisma
: $x_1$ lächelt

cmila
: $x_1$ lacht

<pixra url="/assets/pixra/cilre/cisma.webp" caption="le prenu cu cisma" definition="Die Person lächelt."></pixra>
<pixra url="/assets/pixra/cilre/cmila.webp" caption="ra cmila" definition="Er/sie lacht."></pixra>

> **mi kucli le nu le ninmu cu prami le bruna**
> _Ich frage mich, ob das Mädchen den Bruder mag._

kucli
: $x_1$ ist neugierig auf $x_2$

> **mi na ku kanpe**
> _Ich erwarte das nicht._

kanpe
: $x_1$ erwartet, dass $x_2$ (Ereignis) passiert

> **ko surla**
> _Entspann dich!_

surla
: $x_1$ entspannt sich durch $x_2$ (Eigenschaft von $x_1$)

cinmo
: $x_1$ fühlt Emotion $x_2$ (Eigenschaft von $x_1$)

nelci
: $x_1$ mag $x_2$

manci
: $x_1$ fühlt Ehrfurcht oder Staunen über $x_2$

fengu
: $x_1$ ist wütend über $x_2$

xajmi
: $x_1$ findet $x_2$ lustig

se zdile
: $x_1$ ist amüsiert von $x_2$

zdile
: $x_1$ ist amüsant

djica
: $x_1$ wünscht $x_2$

pacna
: $x_1$ hofft, dass $x_2$ wahr ist

### Gesundheit

> **ca glare**
> _Es ist jetzt heiß._

<!-- -->

> **.i ku'i mi ganse le lenku**
> _Aber ich fühle mich kalt._

ku'i
: Interjektion: aber, jedoch

> **xu do bilma**
> _Bist du krank?_

<!-- -->

> **bilma**
> _Ja._

<!-- -->

> **xu do bilma fi le vidru**
> **.i .e'u do klama le mikce**
> _Hast du ein Virus? Ich schlage vor, du gehst zum Arzt._

le vidru
: das Virus

le mikce
: Arzt

> **mi bilma le ka cortu le galxe**
> **.i mi sruma le du'u mi bilma fi la .zukam.**
> _Meine Symptome sind, dass mein Hals schmerzt._
> _Ich nehme an, dass ich eine Erkältung habe._

cortu
: $x_1$ hat Schmerzen im Organ $x_2$, welches ein Teil des Körpers von $x_1$ ist

la .zukam.
: Erkältung (Krankheit)

> **ko kanro**
> _Gute Besserung!_

kanro
: $x_1$ ist gesund

> **ki'e**
> _Danke._

bilma
: $x_1$ ist krank mit Symptomen $x_2$ von Krankheit $x_3$

Beachte, dass der zweite Platz von **bilma** Symptome beschreibt, wie **le ka cortu le galxe** = _Schmerzen im Hals haben_. Der dritte Platz gibt den Namen der Krankheit an, die diese Symptome verursacht. Offensichtlich möchtest du diese Plätze von **bilma** möglicherweise nicht ausfüllen.

### Menschlicher Körper

> **le nanmu cu se xadni le clani**
> _Der Mann hat einen langen Körper. Der Mann ist groß._

se xadni
: $x_1$ hat den Körper $x_2$

xadni
: $x_1$ ist der Körper von $x_2$

> **mi pu darxi fi le stedu .e le zunle xance**
> **.i ca ti le degji be le xance cu cortu**
> **.i ku'i le pritu xance na ku cortu**
> _Ich habe etwas mit dem Kopf und der linken Hand geschlagen. Jetzt schmerzt der Finger der Hand. Aber die rechte Hand schmerzt nicht._

darxi
: $x_1$ schlägt $x_2$ mit $x_3$

Die meisten Wörter für Körperteile haben die gleiche Platzstruktur wie **xadni**:

stedu
: $x_1$ ist der Kopf von $x_2$

Jedoch beschreiben einige kleinere Teile:

degji
: $x_1$ ist ein Finger/Zehe an Teil $x_2$ (Hand, Fuß)

> **le degji be le xance be le ninmu cu clani**
> _Die Finger der Frau sind lang._
> `Finger der Hand der Frau sind lang`

> **mi viska le jamfu .i ku'i mi na ku viska le degji be le jamfu**
> _Ich kann die Füße sehen. Aber ich sehe nicht deren Zehen._

janco
: $x_1$ ist ein Gelenk, das Gliedmaßen $x_2$ verbindet

ctebi
: $x_1$ ist eine Lippe des Mundes, Öffnung $x_2$

cidni
: $x_1$ ist ein Knie oder Ellbogen der Gliedmaße $x_2$

![](/assets/pixra/cilre/xadni1.svg)

![](/assets/pixra/cilre/xadni2.svg)

### Verwandtschaft

> **coi do mi se cmene zo .adam.**
> **.i ti du la .alis.**
> **.i ri speni mi**
> _Hallo an dich. Ich heiße "Adam"._
> _Das ist Alice._
> _Sie ist meine Frau._

<!-- -->

> **pluka fa le nu penmi do**
> **.i .e'o do klama le nenri be le dinju**
> _Freut mich, dich kennenzulernen._
> _Bitte, komm ins Haus._

<!-- -->

> **ki'e**
> _Danke._

<!-- -->

> **.i .au gau mi do co'a slabu le lanzu be mi**
> **.i le re verba cu panzi mi**
> **.i le tixnu cu se cmene zo .flor.**
> **.i la .karl. cu du le bersa**
> _Ich möchte, dass du meine Familie kennenlernst._
> _Die zwei Kinder sind meine Nachkommen._
> _Die Tochter heißt "Flor"._
> _Karl ist der Sohn._

<!-- -->

> **la .karl. cu mutce citno**
> _Karl ist sehr jung._

<!-- -->

> **ie**
> _Ja._

<!-- -->

> **.i ji'a mi se tunba re da noi ca na ku zvati le dinju**
> **.i sa'e mi se tunba le pa bruna .e le pa mensi**
> _Außerdem habe ich zwei Geschwister, die jetzt nicht im Haus sind._
> _Genauer gesagt, habe ich einen Bruder und eine Schwester._

<!-- -->

> **ue**
> **.i le lanzu be do cu barda**
> _Wow!_
> _Deine Familie ist groß._

<!-- -->

> **je'u pei**
> _Wirklich?_

je'u
: Interjektion: wirklich

Die Wörter für die Namen der Familienmitglieder haben eine ähnliche Platzstruktur:

speni
: $x_1$ ist der Ehemann/die Ehefrau von $x_2$

**co'a speni** bedeutet _heiraten_:

> **mi co'a speni la .suzan.**
> _Ich habe Susan geheiratet._

lanzu
: $x_1$ ist eine Familie einschließlich $x_2$

panzi
: $x_1$ ist ein Kind von $x_2$

tixnu
: $x_1$ ist eine Tochter von $x_2$

bersa
: $x_1$ ist ein Sohn von $x_2$

tunba
: $x_1$ ist ein Geschwister (Bruder/Schwester) von $x_2$

bruna
: $x_1$ ist ein Bruder von $x_2$

mensi
: $x_1$ ist eine Schwester von $x_2$

Beachten Sie, dass **panzi** auf erwachsene Kinder angewendet werden kann:

verba
: $x_1$ ist ein Kind, unreife Person im Alter von $x_2$ (Ereignis)

panzi
: $x_1$ ist ein Kind, Nachkomme von $x_2$

**verba** spricht nicht unbedingt von dem Kind als Familienmitglied:

> **le bersa be le pendo be mi cu verba le nanca be li ci**
> _Der Sohn meines Freundes ist ein drei Jahre altes Kind._

citno
: $x_1$ ist jung

laldo
: $x_1$ ist alt, gealtert

Paare traditioneller Wörter (nur für Menschen):

le ninmu
: Frau / Frauen

le nanmu
: männlicher Mann / männliche Männer

le nixli
: die Mädchen

le nanla
: die Jungen

le remna
: die Menschen

Beachten Sie, dass **le prenu** _die Leute_ oder _die Personen_ bedeutet. In Märchen und fantastischen Geschichten können nicht nur Menschen (**lo'e remna**), sondern auch Tiere oder außerirdische Wesen von anderen Planeten als Personen betrachtet werden.

Diese Wörter können verwendet werden, um genetisch bestimmtes Geschlecht (sowohl bei Tieren als auch bei Menschen) im Gegensatz zu Geschlecht zu beschreiben:

le fetsi
: das Weibchen

le nakni
: Männchen

Diese Wörter beschreiben elterliche (nicht unbedingt genetische) Beziehungen:

mamta
: $x_1$ ist eine Mutter von $x_2$, $x_1$ handelt mütterlich

patfu
: $x_1$ ist ein Vater von $x_2$

rirni
: $x_1$ ist ein Elternteil von $x_2$, $x_1$ zieht $x_2$ groß

### Im Laden

> **ue**
> **do pu te vecnu le laldo karce**
> _Wow!_
> _Du hast ein altes Auto gekauft._

<!-- -->

> **ie**
> **.i ku'i mi na ku pu pleji le so'i jdini**
> _Ja._
> _Aber ich habe nicht viel Geld bezahlt._

<!-- -->

> **ma pu jdima le karce**
> _Was war der Preis des Autos?_

<!-- -->

> **mi pu pleji le rupnusudu be li pa ki'o le kagni le karce**
> _Ich habe tausend Dollar an die Firma für das Auto bezahlt._

<!-- -->

> **mi pu vecnu le laldo karce pe mi le pendo be mi**
> **.i le pendo pu pleji le rupne'uru be li re ki'o mi le karce**
> _Ich habe ein altes Auto von mir an meinen Freund verkauft._
> _Der Freund hat 2 000 Euro für das Auto bezahlt._

ki'o
: Komma zwischen Ziffern, sodass **pa ki'o** _1, 000_ (_eintausend_) ist

vecnu
: $x_1$ verkauft $x_2$ an $x_3$

te vecnu
: $x_1$ kauft $x_2$ von $x_3$

pleji
: $x_1$ zahlt $x_2$ an $x_3$ für $x_4$

jdima
: $x_1$ ist der Preis von $x_2$

jdini
: $x_1$ ist Geld

rupnusudu
: $x_1$ kostet $x_2$ (Zahl) US-Dollar

rupne'uru
: $x_1$ kostet $x_2$ (Zahl) Euro

### Shop, Gebäude

> **ma stuzi le zdani be do**
> _Was ist der Standort deines Hauses?_

<!-- -->

> **le korbi be le cmana**
> **.i mi se zdani le nurma**
> **.i le zdani be mi cu barda dinju gi'e se sledi'u ci da .e le vimstu .e le lumstu**
> _Der Rand des Berges._
> _Ich lebe auf dem Land._
> _Mein Zuhause ist ein großes Haus und hat drei Zimmer plus eine Toilette plus ein Badezimmer._

<!-- -->

> **je'e**
> **.i ku'i mi pu jbena le tcadu .i je ca ti mi se zdani le jarbu be la .paris.**
> **.i mi xabju ne'a le zarci**
> _Ich verstehe._
> _Aber ich wurde in der Stadt geboren und lebe jetzt in den Vororten von Paris._
> _Ich wohne in der Nähe eines Ladens._

stuzi
: $x_1$ ist ein Ort

dinju
: $x_1$ ist ein Gebäude, Haus

sledi'u
: $x_1$ ist ein Raum, ein Teil eines Gebäudes $x_2$

vimstu
: $x_1$ ist eine Toilette, ein Ort zum Ausscheiden

lumstu
: $x_1$ ist ein Badezimmer, ein Ort zum Waschen

zdani
: $x_1$ ist ein Zuhause von $x_2$

se zdani
: $x_1$ lebt in $x_2$, $x_1$ bewohnt $x_2$

tcadu
: $x_1$ ist eine Stadt oder ein Dorf

jarbu
: $x_1$ ist ein Vorort von Stadt/Dorf $x_2$

nurma
: $x_1$ ist ein ländliches Gebiet, $x_1$ ist auf dem Land

zarci
: $x_1$ ist ein Laden
