## Lektion 3. Zitieren. Fragen. Interjektionen

### «**sei**»: Kommentare zum Text

Die Partikel **sei** ermöglicht es, einen Kommentar zu unserer Einstellung zu dem, was gesagt wird, in eine Relation einzufügen:

> **do jinga sei mi gleki**
> _Du hast gewonnen! (Ich freue mich darüber!)_

Jedoch:

> **do jinga sei la .ian. cu gleki**
> _Du hast gewonnen! (Und Yan freut sich darüber!)_

Wie bei Argumenten, die mit **le** gebildet werden, muss die mit **sei** gebildete Relation in einer Relationskonstruktion enden.

> **la .alis. cu prami sei la .bob. cu gleki la .kevin.**

Lassen Sie uns Klammern hinzufügen, um es leichter lesbar zu machen.

> **la .alis. cu prami (sei la .bob. cu gleki) la .kevin.**
> _Alice liebt (Bob freut sich) Kevin._
> _Alice liebt Kevin (Bob freut sich)._

Wir können natürlich weitere Argumente zur Relation mit **be** und **bei** hinzufügen, wie wir es innerhalb von Argumentbegriffen tun:

> **do jinga sei mi zausku be fo la fircku**
> _Du hast gewonnen! (Ich werde Glückwünsche auf Facebook posten)_

la fircku
: Facebook

zausku
: $x_1$ lobt $x_2$ für Publikum $x_3$ über Mittel $x_4$

### Anführungszeichen

Zum Zitieren von Text platzieren wir die Zitatpartikel **lu** vor dem Zitat und **li'u** danach. Das Ergebnis ist ein Argument, das den zitierten Text darstellt:

> **mi cusku lu mi prami do li'u**
> _Ich sage "Ich liebe dich."_

cusku
: $x_1$ drückt aus/sagt $x_2$ (Zitat) zu Publikum $x_3$

Ein schönes Merkmal von Lojban ist, dass **lu** — «Zitat» und **li'u** — «Zitatende» aussprechbar sind. Das ist sehr praktisch, da man im gesprochenen Lojban die Intonation nicht ändern muss, um zu zeigen, wo ein zitierter Text beginnt und endet.

In geschriebenen Texten, die ein Gespräch zitieren, lenkt der Autor jedoch oft die Aufmerksamkeit des Lesers auf den Inhalt der Zitate. In solchen Fällen wird **sei** bevorzugt.

Wir können auch Zitate verschachteln, zum Beispiel:

> **la .ian. pu cusku lu la .djein. pu cusku lu coi li'u mi li'u**
> _Yan sagte, "Jane sagte, ‘Hallo’ zu mir."_

was ähnlich ist wie

> **la .ian. pu cusku lu la .djein. pu rinsa mi li'u**
> _Yan sagte, "Jane begrüßte mich."_

rinsa
: $x_1$ begrüßt jemanden $x_2$

<pixra url="/assets/pixra/cilre/rinsa2.webp" caption="le prenu cu rinsa mi" definition="Die Person begrüßt mich."></pixra>

Beachten Sie, dass wir im Lojban Dinge und ihre Namen unterscheiden:

> **lu le munje li'u cu cmalu**
> _"Das Universum" ist klein._

<!-- -->

> **le munje na ku cmalu**
> _Das Universum ist nicht klein._

le munje
: das Universum, Welt

Hier ist der Text _"das Universum"_ klein, während das Universum es nicht ist.

---

Interjektionen und Vokative funktionieren wie **sei**-Konstrukte:

> **je'u mi jinga sei ra cusku**
> _Wahrlich, "Ich habe gewonnen", sagte er._

je'u
: Interjektion: wahrlich

Wie Sie sehen können, ist **je'u** nicht Teil seiner Worte. Es repräsentiert Ihre Haltung gegenüber der Aussage. Wenn Sie "**je'u mi jinga**" zitieren möchten, verwenden Sie Anführungszeichen wie folgt:

> **lu je'u mi jinga li'u se cusku ra**
> _"Wahrlich, ich habe gewonnen", sagte er._

Bemerkten Sie den Unterschied zwischen den beiden Beispielen?

Hier sind einige gebräuchliche Beziehungswörter im Zusammenhang mit dem Sprechen:

> **ra pu retsku lu do klama ma li'u**
> _Sie fragte, "Wohin gehst du?"_

<!-- -->

> **mi pu spusku lu mi klama le zdani li'u**
> _Ich antwortete, "Ich gehe nach Hause."_

<!-- -->

> **mi pu spuda le se retsku be ra le ka spusku lu mi klama le zdani li'u**
> _Ich antwortete auf ihre Frage, indem ich sagte, "Ich gehe nach Hause."_

spuda
: $x_1$ antwortet $x_2$ durch das Tun von $x_3$ (Eigenschaft von $x_1$)

Die verbleibenden drei Beziehungswörter haben eine identische Platzstruktur:

cusku
: $x_1$ drückt/sagt $x_2$ (Zitat) zu Publikum $x_3$

retsku
: $x_1$ fragt $x_2$ (Zitat) zu Publikum $x_3$

spusku
: $x_1$ antwortet/sagt Antwort $x_2$ (Zitat) zu Publikum $x_3$

### «**zo**» — ein Wort zitieren

**zo** ist ein Zitatmarker, ähnlich wie **lu**. Allerdings zitiert **zo** nur ein Wort, das unmittelbar darauf folgt. Das bedeutet, dass es kein Endzitatwort wie **li'u** benötigt; wir wissen bereits, wo das Zitat endet. Dadurch sparen wir zwei Silben und machen unsere Rede prägnanter.

> **zo .robin. cmene mi**
> _"Robin" ist mein Name._
> _Mein Name ist Robin._

cmene
: $x_1$ (Zitat) ist ein Name von $x_2$ …

Um sich im Lojban mit Ihrem lojbanisierten Namen vorzustellen, folgen Sie dem obigen Beispiel. Wenn Ihr Name aus mehr als einem Wort besteht, verwenden Sie **lu … li'u**:

> **lu .robin.djonsyn. li'u cmene mi**
> _Robin Johnson ist mein Name._

Ein anderer Ansatz ist die Verwendung von **me**:

> **mi me la .robin.djonsyn.**
> _Ich bin Robin Johnson._

Beachte den Unterschied: _"Robin"_ in Anführungszeichen ist ein zitierter Name, während Robin eine Person ist.

Um dies besser zu zeigen, hier eine alberne Variation:
> **zo .robin. cmene la .robin.**
> _"Robin" ist Robins Name._
> _"Robin" ist ein Name von Robin._

Der erste Platz von **cmene** ist ein Zitat, ein Text. Daher verwenden wir **lu … li'u** oder **zo**, um ein Zitat zu erstellen und den ersten Platz von **cmene** damit zu füllen, anstatt **la** (Präfix für Namen).

### Verben der Rede

Hier sind einige Beziehungen, die die Rede beschreiben:

> **mi pu skicu le purdi le pendo be mi lo ka bredi**
> _Ich erzählte meinem Freund von meinem Garten, der bereit ist._

skicu
: $x_1$ erzählt über $x_1$ (Objekt/Ereignis/Zustand) zu $x_3$ mit Beschreibung $x_4$ (Eigenschaft)

bredi
: … ist bereit zu …

> **mi pu cusku lu le purdi cu bredi li'u le pendo be mi lo ka cladu bacru**
> _Ich sagte zu meinem Freund: "Der Garten ist bereit," indem ich es laut aussprach._

cusku
: $x_1$ sagt $x_2$ (Text) für Publikum $x_3$ über Medium $x_4$

cladu
: … ist laut

> **mi pu tavla le pendo be mi le nu le purdi cu bredi kei le lojbo**
> _Ich sprach mit meinem Freund auf Lojban über den Garten, der bereit ist._

tavla
: $x_1$ spricht mit $x_2$ über Thema $x_3$ in Sprache $x_4$

Kurz gesagt:

* **skicu** bedeutet _erzählen_, _beschreiben mit einer Beschreibung_,
* **cusku** bedeutet _einen Text sagen_,
* **tavla** bedeutet _in einer Sprache sprechen_.

### Inhaltsfragen

Englisch hat mehrere _wh-_ Fragewörter — _who_, _what_ usw. In Lojban verwenden wir für beide ein Wort: **ma**. Dieses Wort ist ein Argument (wie **mi**, **le prenu** usw.) und es ist wie ein Vorschlag, den fehlenden Platz auszufüllen. Zum Beispiel:

> **— do klama ma**
> **— la .london.**
> _— Wohin gehst du?_
> _— London._

<!-- -->

> **— ma klama la .london.**
> **— la .kevin.**
> _— Wer geht nach London?_
> _— Kevin._

<!-- -->

> **— mi plicru do ma**
> **— le plise**
> <span>_— Ich gebe dir was?_ (wahrscheinlich im Sinne von _Was sollte ich dir nochmal geben?_)</span>
> _— Den Apfel._

Um _welcher/welches_, zu übersetzen, verwenden wir auch **ma**:

> **— ma gugde gi'e se xabju do**
> **— le gugde'usu**
> _— In welchem Land lebst du?_
> _— USA_
> `— Was ist ein Land und wird von dir bewohnt`
> `— USA`

xabju
: … (jemand) bewohnt … (einen Ort)

se xabju
: … (ein Ort) wird bewohnt von … (jemand)

**mo** ist ähnlich wie **ma**, aber es ist ein Relationswort.

**mo** schlägt vor, eine Beziehung anstelle eines Arguments zu füllen. Es ist wie die Frage _Was macht X?_ oder _Was ist X?_ auf Englisch (Lojban zwingt dich nicht, zwischen Sein und Tun zu unterscheiden).

Wir können **mo** als Aufforderung sehen, jemandem zu beschreiben, wie die Beziehung zwischen den Argumenten in der Frage ist.

> **— do mo**
> _— Wie geht es dir? Was ist los?_
> `— Du bist was, du machst was?`

Dies ist die gebräuchlichste Art, _Wie geht es dir?_ oder _Howdy?_ auf Lojban zu fragen. Einige mögliche Antworten:

> **— mi gleki**
> _— Ich bin glücklich._

gleki
: $x_1$ ist glücklich

> **— mi kanro**
> _— Ich bin gesund._

<!-- -->

> **mi tatpi**
> _Ich bin müde._

<!-- -->

> **mi gunka**
> _Ich arbeite._

Eine andere Art zu fragen _Wie geht es dir?_:

> **— do cinmo le ka mo**
> _— Wie fühlst du dich (emotional)?_

cinmo
: $x_1$ fühlt $x_2$ (Eigenschaft von $x_1$)

Weitere Beispiele:

> **ti mo**
> _Was ist das?_

<!-- -->

> **la .meilis. cu mo**
> _Wer ist Mei Li? / Was ist Mei Li? / Was macht Mei Li?_

Mögliche Antworten je nach Kontext:

- **ninmu**: _Sie ist eine Frau._
- **jungo**: _Sie ist Chinesin._
- **pulji**: _Sie ist Polizistin._
- **sanga**: _Sie ist Sängerin_ oder _Sie singt._

> **do mo la .kevin.**
> _Was bist du für Kevin?_
> `Du bist was (du machst was) für Kevin.`

Die Antwort hängt vom Kontext ab. Mögliche Antworten auf diese Frage sind:

- **nelci**: _Ich mag ihn._
- **pendo**: _Ich bin sein Freund._
- **prami**: _Ich liebe ihn._
- **xebni**: _Ich hasse ihn._
- **fengu**: _Ich bin wütend auf ihn._
- **cinba**: _Ich habe ihn geküsst._

Beachte erneut, dass die Zeit hier nicht wichtig ist: genauso wie **cinba** _küsst_, _küsste_, _wird küssen_ und so weiter bedeuten kann, fragt **mo** keine Frage über eine bestimmte Zeit.

Wenn wir zwischen _etwas tun_ und _jemand oder etwas sein_ unterscheiden wollen, verwenden wir zusätzliche Beziehungen:

> **la meilis cu zukte ma**
> `Mei Li macht was?`
> _Was macht Mei Li?_

> **le ka lumci**
> _Reinigen._

<!-- -->

> **la meilis cu zukte le ka lumci**
> _Mei Li macht Reinigung._

zukte
: $x_1$ macht $x_2$ (Eigenschaft von $x_1$)

lumci
: ... reinigt oder wäscht ... (etwas)

<pixra url="/assets/pixra/cilre/lumci.webp" caption="ra lumci le zdani" definition="Sie reinigt das Zuhause."></pixra>

> **do du ma**
> `Du bist wer?`

> **mi du le ctuca**
> _Ich bin der Lehrer._

Die Verwendung von Modalbegriffen mit **ma** kann uns andere nützliche Fragen geben:

<table>
<tbody><tr>
<th>Wort
</th>
<th>Bedeutung
</th>
<th><code>[wörtlich]</code>
</th></tr>
<tr>
<td><b>ca ma</b>
</td>
<td>Wann?
</td>
<td>während was
</td></tr>
<tr>
<td><b>bu'u ma</b>
</td>
<td>Wo?
</td>
<td>bei was
</td></tr>
<tr>
<td><b>ma prenu gi'e …</b>
</td>
<td>Wer?
</td>
<td>wer ist eine Person und …
</td></tr>
<tr>
<td><b>ma dacti gi'e</b>
</td>
<td>Was? (über Objekte)
</td>
<td>was ist ein Objekt und …
</td></tr>
<tr>
<td><b>ri'a ma</b>
</td>
<td>Warum?
</td>
<td>wegen was
</td></tr>
<tr>
<td><b>pe ma</b>
</td>
<td>Wessen? Welche? Über was?
</td>
<td>bezüglich was oder wem
</td></tr>
<tr>
<td><b>le mlatu poi mo</b>
</td>
<td>Welche Katze? Welche Art von Katze?
</td>
<td>
</td></tr></tbody></table>

**pe ma** wird nur an Argumente angehängt:

> **le penbi pe ma cu zvati le jubme**
> _Wessen Stift ist auf dem Tisch?_

### Zahlenfragen

> **le xo prenu cu klama ti**
> _Wie viele Leute kommen hierher?_

<!-- -->

> **mu**
> _Fünf._

Das Wort **xo** bedeutet _Wie viele?_ und fragt somit nach einer Zahl. Die vollständige Antwort lautet:

> **le mu prenu cu klama ti**
> _Die 5 Leute kommen hierher._

Die befragte Person soll einen passenden Wert anstelle von **xo** einsetzen.

Hier sind noch ein paar Beispiele:

> **le xo botpi cu kunti**
> _Wie viele Flaschen sind leer?_

<!-- -->

> **do ralte le xo gerku**
> _Wie viele Hunde hältst du?_

### Verben der Tatsachen

Betrachten Sie das Beispiel:

> **mi djuno le du'u do stati**
> _Ich weiß, dass du klug bist._

djuno
: $x_1$ weiß $x_2$ (Aussage) über $x_3$

> **mi jimpe le du'u do pu citka**
> _Ich verstehe, dass du gegessen hast._

jimpe
: $x_1$ versteht $x_2$ (Aussage) über $x_3$

<pixra url="/assets/pixra/cilre/na_jimpe.webp" caption="mi na jimpe" definition="Ich verstehe nicht."></pixra>

An Stellen, die Fakten beschreiben, wird das Partikel **du'u** verwendet (anstelle von **nu**).

**djuno** (_wissen_) und **jimpe** (_verstehen_) beschreiben Fakten. Es wäre unlogisch zu sagen, _Ich verstehe, dass du gegessen hast, aber in Wirklichkeit hast du nicht._

Beachte, dass die mit **du'u** begonnene Beziehung nicht wahr sein muss:

> **le du'u do mlatu cu jitfa**
> _Dass du eine Katze bist, ist falsch._

jitfa
: $x_1$ (Aussage) ist falsch

Wann sollte man **du'u** und wann **nu** verwenden? Du kannst das Wörterbuch konsultieren:

- Das Label _(du'u)_ oder _(Aussage)_ kennzeichnet Stellen, an denen **du'u** empfohlen wird.
- Das Label _(nu)_ oder _(Ereignis)_ kennzeichnet Stellen, an denen **nu** empfohlen wird.

Wenn du versehentlich **nu** anstelle von **du'u** verwendest, wirst du trotzdem verstanden. Allerdings unterscheiden fließende Lojban-Sprecher typischerweise zwischen diesen Partikeln.

### Indirekte Fragen

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Ich weiß, wer Lojban lernt._

Dies wird als indirekte Frage bezeichnet. Das Wort _wer_ hier ist keine Informationsanfrage, und es gibt kein Fragezeichen. Die Antwort wird vorausgesetzt, und tatsächlich kennst du selbst die Antwort auf die Frage _Wer lernt Lojban?_

**kau** ist eine Interjektion, die wir nach einem Fragewort setzen, um anzuzeigen, dass es sich um eine indirekte Frage handelt.

Wenn ich dir die Frage **ma tadni la .lojban.** stelle, weißt du, welchen Wert du in den **ma**-Slot einfüllen musst: **la .kevin.** Also könntest du einfach sagen

> **ma tadni la .lojban.**
> _Wer lernt Lojban?_

<!-- -->

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Ich weiß, wer Lojban lernt. Ich kenne die Identität der Person, die Lojban lernt._

<!-- -->

> **mi djica le nu ma tadni la .lojban.**
> _Wen möchte ich, dass Lojban lernt?_
> `Ich möchte, dass wer Lojban lernt?`

Dies kann niemals eine indirekte Frage sein: Es wird nach einer Antwort gefragt (selbst wenn du es rhetorisch machst).

You can put it after other question words:

> **mi djuno le du'u le xo kau prenu cu tadni la .lojban.**
> _Ich weiß, wie viele Leute Lojban lernen._

### Indirekte Zitate (indirekte Rede): ‘_Ich sagte, dass ich kommen würde._’

Eine Beziehung wie _Alice sagte: "Michelle sagte zu mir 'Hallo'"_ kann auch subtiler ausgedrückt werden:

> **la .alis. pu cusku zo'e pe le nu la .micel. pu rinsa la .alis.**
> _Alice sagte etwas darüber, dass Michelle sie zuvor begrüßt hatte._
> `Alice sagte etwas über das Ereignis, dass Michelle sie begrüßt hatte.`

Alternativ kann man es kürzer machen:

> **la .alis. pu cusku le se du'u la .micel. pu rinsa la .alis.**
> _Alice sagte, dass Michelle sie begrüßt hatte._

Die Kombination **se du'u** ermöglicht die Ausdrucksweise der indirekten Rede.

Hier sind einige Beispiele für Beziehungen, die für die indirekte Rede nützlich sind:

> **le ninmu pu retsku le se du'u mi klama ma kau**
> _Sie fragte, wohin ich gehe._

<!-- -->

> **mi pu spusku le se du'u mi klama le zdani**
> _Ich antwortete, dass ich nach Hause gehe._

<!-- -->

> **mi pu spuda le se retsku be le ninmu le ka spusku le se du'u mi klama le zdani**
> _Ich antwortete auf ihre Frage, indem ich sagte, dass ich nach Hause gehe._

Fragen in der indirekten Rede:

> **mi pu cusku le se du'u ma tadni la .lojban.**
> _Wen habe ich gesagt, dass er Lojban lernt?_
> `Ich sagte, wer Lojban lernt?`

So hat Lojban mehrere Wörter für _dass …_, je nachdem, was gemeint ist.

- Wenn _dass_ beschreibt, was gesehen, gehört oder was passiert, benutze **nu**.
- Wenn _dass_ beschreibt, was du denkst, ein Fakt oder Information, benutze **du'u**.
- Wenn _dass_ beschreibt, was du sagst, benutze **se du'u**.
  - Aber wenn du ein wörtliches Zitat brauchst, benutze **lu … li'u**.

### Emotionale Interjektionen: ‘_Yay!_’ = «**ui**», ‘_Aye!_’ = «**ie**», ‘_Phew!_’ = «**.o'u**»

Wir kennen solche Interjektionen wie **ui** (_Yay!_), **.a'o** (_Ich hoffe_).

> **do jinga ui**
> _Du hast gewonnen! (Ich freue mich darüber!)_

ui
: Interjektion: _Yay!_, Interjektion der Freude

<pixra url="/assets/pixra/cilre/ui_jinga.webp" caption="ui mi jinga" definition="Yay! Ich habe gewonnen!"></pixra>

Interjektionen funktionieren wie **sei** mit ihren Beziehungen. **ui** bedeutet dasselbe wie **sei mi gleki**, also könnten wir genauso gut sagen **do jinga sei mi gleki**, was dasselbe bedeutet (obwohl es etwas länger ist).

Es gibt Interjektionen, die andere emotionale Zustände ausdrücken. Sie sind ähnlich wie Smileys wie ;-) oder :-(, aber in Lojban können wir spezifischer über unsere Emotionen sein und dennoch prägnant in unserer Sprache bleiben.

> **ie tu mlatu**
> _Einverstanden, das ist eine Katze._

<!-- -->

> **ie nai .i tu na ku mlatu**
> _Nein, ich stimme nicht zu. Das ist keine Katze._

ie
: Interjektion: _Ja! Aye!_ (Zustimmung)

ie nai
: Interjektion: Ablehnung

> **.ai mi vitke do**
> _Ich werde dich besuchen._

.ai
: Interjektion: _Ich werde …_ (Absicht)

> **.au do kanro**
> _Ich wünschte, du wärst gesund._

.au
: Interjektion des Wunsches

<pixra url="/assets/pixra/cilre/clira.webp" caption="mi clira klama" definition="Ich kam früh."></pixra>

> **.a'o do clira klama**
> _Ich hoffe, du kommst früh._

.a'o
: Interjektion: Ich hoffe

clira
: $x_1$ passiert früh

<pixra url="/assets/pixra/cilre/ciska.webp" caption=".ei mi ciska le xatra ti voi pelji ku'o le penbi" definition="Ich sollte den Brief auf diesem Papier mit dem Stift schreiben."></pixra>

> **.ei mi ciska le xatra le pelji le penbi**
> _Ich sollte den Brief auf dem Papier mit dem Stift schreiben._

.ei
: Ich sollte … (Verpflichtung)

ciska
: $x_1$ schreibt $x_2$ auf Medium $x_4$

> **.i'e do pu gunka le vajni**
> _Sehr gut! Du hast wichtige Arbeit geleistet._

.i'e
: Interjektion: _Gut!_ (Zustimmung)

> **.o'u tu mlatu**
> _Oh, das ist nur eine Katze._

.o'u
: Interjektion: _Puh!_ (Entspannung)

In diesem Fall hast du wahrscheinlich gedacht, dass es etwas Gefährliches war, aber es ist nur eine Katze, also sagst du **.o'u**.

> **.u'i ti zmitci**
> _Ha-ha, das ist ein Roboter._

.u'i
: Interjektion: _Ha-ha!_ (Belustigung)

zmitci
: … ist ein automatisches Werkzeug

Du kannst Interjektionen zu einem Satz hinzufügen oder daraus entfernen, ohne das Risiko, ihn zu zerstören.

Jedes Wort, das mit einem reinen Vokal beginnt (außer **u** und **i** vor Vokalen), wird in Lojban im Schreiben mit einem Punkt und im Sprechen mit einer Pause versehen. Also ist die korrekte Schreibweise **.a'o** und so weiter. Es ist üblich, Punkte im Schreiben wegzulassen. Beim Sprechen solltest du jedoch immer diese Punkte durch eine kurze Pause vor dem Wort anzeigen, um zu verhindern, dass zwei benachbarte Wörter zu einem verschmelzen.

Wie bei **xu**- oder **sei**-Relationen können wir nach jedem Argument oder Relationskonstrukt Interjektionen hinzufügen und so unsere Haltung zu diesem Teil des Satzes ausdrücken.

### Drängende Interjektionen

Eine spezielle Gruppe von "imperativen/hortativen" Interjektionen wird für Aufforderungen, Befehle und Bitten verwendet. Wir haben bereits **.e'o** kennengelernt:

> **.e'o mi ciksi da poi mi cusku djica**
> _Bitte, lass mich erklären, was ich sagen möchte._

.e'o
: Interjektion: _Bitte …_ (Bitte)

> **— au mi klama le nenri**
> **— .e'a**
> _— Ich möchte eintreten._
> _— Bitte._

.e'a
: Interjektion: _Ich erlaube, du darfst …_ (Erlaubnis)

le nenri
: das Innere, was drinnen ist

> **.e'ei do zukte**
> _Komm schon, mach es!_

.e'ei
: Interjektion: _Komm schon!_ (Ermutigung, Anstiftung, Provokation). Inoffizielles Wort

> **.e'i do zutse doi le verba**
> _Setz dich, Kind!_

.e'i
: Interjektion: _Mach das!_ (Befehl)

> **.e'u do pinxe le jisra**
> _Ich schlage vor, dass du den Saft trinkst. Du solltest besser den Saft trinken._

.e'u
: Interjektion: _Lass uns …_ (Vorschlag)

### «**ko**» für schnellere Aufforderungen

> **do bajra**
> _Du läufst._

<!-- -->

> **bajra**
> _Jemand läuft._

Im Englischen ist das Verb selbst ein Befehl:

> _Lauf!_

Im Lojban bedeutet **bajra** als Satz _Jemand läuft_ (oder _läuft gerade_ / _lief_, je nach Kontext). **bajra** kann auch ein Befehl sein, _Lauf!_, aber manchmal reicht der Kontext nicht aus, um zu bestimmen, ob es eine Aufforderung zum Laufen ist oder einfach eine Aussage, dass jemand läuft oder läuft.

Das Pronomen **ko** wird anstelle von **do** verwendet, um Bitten, Vorschläge oder Befehle zu machen:

> **ko bajra**
> _Lauf! Lauf wirklich! Mach es so, dass du läufst!_

**ko** ist eine vage Alternative zu **do .e'o**, **do .e'u**, **do .e'i**.

Es ist völlig in Ordnung, etwas Präziseres zu sagen, wie:

> **do .e'o bajra**
> _Du, bitte lauf!_

wobei wir die Betonung auf unsere Höflichkeit gegenüber **do** (_du_) legen.

Indem man **ko** in eine Relation verschiebt, wird der Befehl/die Bitte auf diesen Teil verschoben. Zum Beispiel:

> **nelci ko**
> _Mach es so, dass du von jemandem gemocht wirst!_

nelci
: … mag … (etwas oder jemanden)

Wie Sie sehen können, müssen wir diese Relation im Englischen umstrukturieren, was immer noch seltsam klingt. Im Lojban könnte man es jedoch im Sinne von _Versuche, einen guten Eindruck zu machen_ verwenden.

Note that **prami** corresponds to English _to love_, while **nelci** corresponds to English _to like_.

We can even have several **ko** in one sentence:

> **ko kurji ko**
> _Take care of yourself._

kurji
: … kümmert sich um … (jemanden oder etwas)

### Diskursive Interjektionen

> **au mi citka le salta .e ji'a le grute**
> _I'd like to eat the salad and the fruits too._

ji'a
: _zusätzlich, auch_, bedeutet, dass es andere gibt, die ebenfalls gleich sind (_du_ in diesem Fall) oder dasselbe tun

salta
: … ist etwas Salat

grute
: … ist eine Frucht

> **mi si'a nelci do**
> `I too like you`

<!-- -->
> **— mi nelci le'e mlatu**
> **— mi si'a nelci le'e mlatu**
> _— I like cats._
> _— I like cats too (Me too)._

si'a
: _ähnlich, auch_, bezeichnet, dass etwas ähnlich ist, während es in anderen nicht erwähnten Aspekten unterschiedlich ist

### Struktur der Interjektionen: «**nai**», «**sai**», «**pei**», «**dai**»

Interjektionen können bestehen aus

1. der Wurzel, wie **ui** (_Yay!_)
2. danach Suffixe wie **pei**, **dai**, **zo'o**:

    > **ui zo'o**
    > _Yay! (scherzhaft, ich bin eigentlich nicht glücklich)_

3. sowohl die Wurzel als auch jedes der Suffixe können mit Skalarpartikeln wie **nai** modifiziert werden:

    > **ui nai**
    > _Ach!_

    <!-- -->
    > **ui nai zo'o**
    > _Ach! (scherzhaft, ich meine es nicht ernst mit diesem Gefühl)_

    <!-- -->
    > **ui nai zo'o nai**
    > _Ach, ich scherze nicht, ich fühle mich unglücklich_

Einige Beispiele, wie Skalarpartikeln funktionieren.

- **ju'o** = _Interjektion: Ich bin sicher (Gewissheit)_
- **ju'o cu'i** = _Interjektion: vielleicht, möglicherweise (Unsicherheit)_
- **ju'o nai** = _Interjektion: Ich habe keine Ahnung!_

Häufige Beispiele für Interjektionen:

- eine Interjektion, die nur aus einer Wurzel besteht:

 > **ju'o le bruna co'i klama**
 > _Ich bin sicher, der Bruder ist gekommen._

- die Skalarpartikel **cu'i** verwandelt eine reine Wurzelinterjektion in ihre mittlere Haltung:

 > **ju'o cu'i le bruna co'i klama**
 > _Vielleicht ist der Bruder gekommen, ich bin mir nicht sicher._

- die Skalarpartikel **nai** verwandelt die Interjektion in die entgegengesetzte Haltung:

 > **ju'o nai le bruna co'i klama**
 > _Vielleicht ist der Bruder gekommen, vielleicht auch nicht, ich habe keine Ahnung_

Ähnlich bedeutet **ui** _Whee! Yay!_, während **ui nai** _Alas!_ bedeutet.

Genaue Bedeutungen von Interjektionen, die mit ihren Skalarpartikeln **cu'i** und **nai** sinnvoll sind, werden im Wörterbuch angegeben.

- Die Skalarpartikel **sai** bezeichnet starke Intensität der Interjektion:

 > **.u'i sai**
 > _Ha-ha-ha!_

Vokative können auch mit Skalarpartikeln modifiziert werden:

> **ki'e sai do**
> _Vielen Dank!_

Suffixe werden nach der Wurzel der Interjektion hinzugefügt (zusammen mit ihren Skalarpartikeln, wenn wir sie verwendet haben):

- Das Interjektionssuffix **pei** verwandelt die Interjektion in eine Frage.

 > **— .au pei do .e mi klama le zarci**
 > **— .au cu'i**
 > _— Willst du, dass du und ich zum Laden gehen?_
 > _— Meh, ich habe keine Präferenzen._

 <!-- -->

 > **— ie pei tu melbi**
 > **— ie**
 > _— Der da ist hübsch, oder?_
 > _— Ja._

- Das Interjektionssuffix **dai** zeigt die Gefühle anderer, nicht die Gefühle des Sprechers:

 > **ui nai dai do na ku co'i jinga**
 > _Du musst traurig sein, du hast nicht gewonnen._

 <!-- -->

 > **.a'u**
 > _Das ist interessant!_

 <!-- -->

 > **.a'u dai**
 > _Das muss für dich interessant gewesen sein!_

- Bloße Interjektionen drücken die Haltung des Sprechers aus. **ei do cliva** bedeutet nicht _Du solltest gehen_, sondern _Ich fühle die Verpflichtung, dass du gehst_. **dai** zeigt, dass der Sprecher die Gefühle anderer nachempfindet.

 > **.ei dai do cliva**
 > _Du fühlst die Verpflichtung, selbst zu gehen._

Beachte, dass Interjektionen nicht unbedingt die Haltung gegenüber den Sprechern selbst zeigen. Stattdessen drücken sie die Haltung der Sprecher gegenüber anderen Dingen aus.

- Das Interjektionssuffix **zo'o** kennzeichnet die Haltung als nicht ernst gemeint:

 > **.e'u zo'o do pinxe ti**
 > _Ich schlage vor, dass du es trinkst (scherzhaft)._

- Suffixe können auch mit Skalarpartikeln modifiziert werden:

 > **ie zo'o nai**
 > _Ich stimme zu (nicht scherzhaft)._

- **zo'o nai** wird verwendet, um zu zeigen, dass die Information kein Scherz ist:

 >**zo'o nai ra pu klama la .paris.**
 >_— Ich meine es ernst, er ist nach Paris gegangen._

- Suffixe können auch allein verwendet werden:

  - **pei** wird allein verwendet, um nach einer beliebigen Interjektion zu fragen, die der Zuhörer für angemessen hält:

 >**— pei le lunra cu crino**
 >**— .ie nai**
 >_— Der Mond ist grün (was fühlst du dabei?)_
 >_— Ich stimme nicht zu._

- Bei anderen Suffixen bedeutet es, dass die Wurzelinterjektion **ju'a** (_Ich stelle fest_) weggelassen wurde:

 > **zo'o do kusru**
 > **ju'a zo'o do kusru**
 > _Du bist grausam (Scherz)._

 ju'a
 : Interjektion: Ich stelle fest (nicht zu verwechseln mit **ju'o** (Ich bin sicher))

### Nur zur Referenz: Interjektionen in Tabellen

Hier ist eine umfassendere Ansicht: emotionale, drängende und verschiedene andere Interjektionen nach Serien.

<table>
<tbody><tr>
<td><b>.au</b><br/><i>Wunsch …</i>
</td>
<td><b>.ai</b><br/><i>Ich werde…</i>
</td>
<td><b>.ei</b><br/><i>Es sollte…</i>
</td>
<td><b>.oi</b><br/><i>Autsch!</i>
</td></tr>
<tr>
<td><b>.au cu'i</b><br/><i>meh</i><br/>Gleichgültigkeit
</td>
<td><b>.ai cu'i</b><br/>Unentschlossenheit
</td>
<td><b>.ei cu'i</b>
</td>
<td><b>.oi cu'i</b>
</td></tr>
<tr>
<td><b>.au nai</b><br/><i>Nuh-uh!</i><br/>Abneigung, Widerwillen
</td>
<td><b>.ai nai</b><br/>unabsichtlich, versehentlich
</td>
<td><b>.ei nai</b><br/>Freiheit, wie Dinge nicht sein müssen
</td>
<td><b>.oi nai</b><br/>Vergnügen
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
<td><b>ua</b><br/><small>"wah" wie in "<u>wo</u>n", "<u>o</u>nce"</small><br/><i>Aha! Eureka!</i>
</td>
<td><b>ue</b><br/><small>"weh" wie in "<u>we</u>t"</small><br/><i>Was für eine Überraschung!</i>
</td>
<td><b>ui</b><br/><small>"weeh" wie "wir"</small><br/><i>hurra!</i>
</td>
<td><b>uo</b><br/><small>"woh" wie in "<u>wo</u>mbat", "<u>wha</u>t"</small><br/><i>voila!</i>
</td>
<td><b>uu</b><br/><small>"wooh" wie "woo"</small><br/><i>oh du armes Ding</i>
</td></tr>
<tr>
<td><b>ua cu'i</b><br/>&nbsp;
</td>
<td><b>ue cu'i</b><br/><i>Ich bin nicht wirklich überrascht</i>
</td>
<td><b>ui cu'i</b><br/>&nbsp;
</td>
<td><b>uo cu'i</b><br/>&nbsp;
</td>
<td><b>uu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ua nai</b><br/><i>Duh! Ich verstehe es nicht!</i><br/>Verwirrung
</td>
<td><b>ue nai</b><br/>Erwartung, Mangel an Überraschung
</td>
<td><b>ui nai</b><br/><i>Ach!</i><br/>unglücklich fühlen
</td>
<td><b>uo nai</b><br/>sich unvollständig fühlen
</td>
<td><b>uu nai</b><br/><i>Mwa ha ha!</i><br/>Grausamkeit
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
<td><b>ia</b><br/><small>"yah" wie in "<u>ya</u>rd"</small><br/><i>Ich glaube</i>
</td>
<td><b>ie</b><br/><small>"yeh" wie in "<u>ye</u>s"</small><br/><i>aye! einverstanden!</i>
</td>
<td><b>ii</b><br/><small>"yeeh" wie in "hear <u>ye</u>"</small><br/><i>yikes!</i>
</td>
<td><b>io</b><br/><small>"yoh" wie in "<u>yo</u>gurt"</small><br/><i>Respekt</i>
</td>
<td><b>iu</b><br/><small>"yooh" wie in "c<u>u</u>te, d<u>ew</u>"</small><br/><i>Ich liebe es</i>
</td></tr>
<tr>
<td><b>ia cu'i</b><br/>&nbsp;
</td>
<td><b>ie cu'i</b><br/>&nbsp;
</td>
<td><b>ii cu'i</b><br/>&nbsp;
</td>
<td><b>io cu'i</b><br/>&nbsp;
</td>
<td><b>iu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ia nai</b><br/><i>Pah!</i><br/>Unglaube
</td>
<td><b>ie nai</b><br/>Uneinigkeit
</td>
<td><b>ii nai</b><br/><i>Ich fühle mich sicher</i>
</td>
<td><b>io nai</b><br/>Respektlosigkeit
</td>
<td><b>iu nai</b><br/>Hass
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
<td><b>.u'a</b><br/><small>"oohah" wie in "t<u>wo ha</u>lves"</small><br/><i>Gewinn</i>
</td>
<td><b>.u'e</b><br/><small>"ooheh" wie in "t<u>wo hea</u>ds"</small><br/><i>was für ein Wunder!</i>
</td>
<td><b>.u'i</b><br/><small>"ooheeh" wie in "t<u>wo hee</u>ls"</small><br/><i>hahaha!</i>
</td>
<td><b>.u'o</b><br/><small>"oohoh" wie in "t<u>wo haw</u>ks"</small><br/><i>Mut</i>
</td>
<td><b>.u'u</b><br/><small>"oohooh" wie in "t<u>wo hoo</u>ds"</small><br/><i>Entschuldigung!</i>
</td></tr>
<tr>
<td><b>.u'a cu'i</b><br/>&nbsp;
</td>
<td><b>.u'e cu'i</b><br/>&nbsp;
</td>
<td><b>.u'i cu'i</b><br/>&nbsp;
</td>
<td><b>.u'o cu'i</b><br/>Schüchternheit
</td>
<td><b>.u'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.u'a nai</b><br/>Verlust
</td>
<td><b>.u'e nai</b><br/><i>Pff!</i><br/>alltäglich
</td>
<td><b>.u'i nai</b><br/><i>Blah</i><br/>Müdigkeit
</td>
<td><b>.u'o nai</b><br/>Feigheit
</td>
<td><b>.u'u nai</b><br/>&nbsp;
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Attitude</th></tr></thead>
<tbody>
<tr>
<td><b>.i'a</b><br/><small>"eehah" wie in "t<u>eaho</u>use"</small><br/><i>ok, ich akzeptiere es</i>
</td>
<td><b>.i'e</b><br/><small>"eeheh" wie in "t<u>eahea</u>d"</small><br/><i>Ich stimme zu!</i>
</small></td>
<td><b>.i'i</b><br/><small>"eeheeh" wie in "w<u>e hea</u>t"</small><br/><i>Ich bin bei dir</i>
</td>
<td><b>.i'o</b><br/><small>"eehoh" wie in "w<u>e haw</u>"</small><br/><i>dank ihm/ihr</i>
</td>
<td><b>.i'u</b><br/><small>"eehooh" wie in "w<u>e hoo</u>k"</small><br/><i>Vertrautheit</i>
</td></tr>
<tr>
<td><b>.i'a cu'i</b><br/>&nbsp;
</td>
<td><b>.i'e cu'i</b><br/>Nicht-Zustimmung
</td>
<td><b>.i'i cu'i</b><br/>&nbsp;
</td>
<td><b>.i'o cu'i</b><br/>&nbsp;
</td>
<td><b>.i'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.i'a nai</b><br/>Widerstand
</td>
<td><b>.i'e nai</b><br/><i>Buh!</i><br/>Missbilligung
</td>
<td><b>.i'i nai</b><br/>Gefühl der Feindseligkeit
</td>
<td><b>.i'o nai</b><br/>Neid
</td>
<td><b>.i'u nai</b><br/>Unvertrautheit
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Anhang zur Situation</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.a'a</b><br/><small>"ahah" wie "aha"</small><br/><i>Ich höre zu</i>
</td>
<td><b>.a'e</b><br/><small>"aheh"</small><br/><i>Wachsamkeit</i>
</td>
<td><b>.a'i</b><br/><small>"aheeh" wie in "Sw<u>ahi</u>li"</small><br/><i>Elan!</i><br/>Anstrengung
</td>
<td><b>.a'o</b><br/><small></small><br/><i>Ich hoffe</i>
</td>
<td><b>.a'u</b><br/><small></small><br/><i>Hm, ich frage mich…</i>
</td></tr>
<tr>
<td><b>.a'a cu'i</b><br/>unaufmerksam
</td>
<td><b>.a'e cu'i</b><br/>&nbsp;
</td>
<td><b>.a'i cu'i</b><br/>keine besondere Anstrengung
</td>
<td><b>.a'o cu'i</b><br/>&nbsp;
</td>
<td><b>.a'u cu'i</b><br/><i>Gähn</i><br/>Desinteresse
</td></tr>
<tr>
<td><b>.a'a nai</b><br/>vermeidend
</td>
<td><b>.a'e nai</b><br/><i>Ich bin müde</i>
</td>
<td><b>.a'i nai</b><br/>Ruhe
</td>
<td><b>.a'o nai</b><br/><i>Gah!</i><br/>Verzweiflung
</td>
<td><b>.a'u nai</b><br/><i>Igitt! Pfui!</i><br/>Abscheu
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Drängen</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.e'a</b><br/><small>"ehah"</small><br/><i>du darfst</i>
</td>
<td><b>.e'ei</b><br/><small>"ehey"</small><br/><i>komm schon, mach es!</i>
</td>
<td><b>.e'i</b><br/><small>"eheeh"</small><br/><i>mach es!</i>
</td>
<td><b>.e'o</b><br/><small>"ehoh"</small><br/><i>bitte, mach es</i>
</td>
<td><b>.e'u</b><br/><small>"ehooh"</small><br/><i>Ich schlage vor</i>
</td></tr>
<tr>
<td><b>.e'a cu'i</b><br/>&nbsp;
</td>
<td><b>.e'ei cu'i</b><br/>&nbsp;
</td>
<td><b>.e'i cu'i</b><br/>&nbsp;
</td>
<td><b>.e'o cu'i</b><br/>&nbsp;
</td>
<td><b>.e'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.e'a nai</b><br/>verboten
</td>
<td><b>.e'ei nai</b><br/>Entmutigung ausdrücken, demoralisieren
</td>
<td><b>.e'i nai</b><br/>&nbsp;
</td>
<td><b>.e'o nai</b><br/>anbieten, gewähren
</td>
<td><b>.e'u nai</b><br/>warnen, abraten
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emotion</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.o'a</b><br/><small>"ohah"</small><br/><i>Stolz</i>
</td>
<td><b>.o'e</b><br/><small>"oheh"</small><br/><i>Ich fühle es in der Nähe</i>
</td>
<td><b>.o'i</b><br/><small>"oheeh"</small><br/><i>Gefahr!</i>
</td>
<td><b>.o'o</b><br/><small>"ohoh" wie in "s<u>awho</u>rse"</small><br/><i>Geduld</i>
</td>
<td><b>.o'u</b><br/><small>"ohooh"</small><br/><i>Entspannung</i>
</td></tr>
<tr>
<td><b>.o'a cu'i</b><br/>Bescheidenheit, Demut
</td>
<td><b>.o'e cu'i</b><br/>&nbsp;
</td>
<td><b>.o'i cu'i</b><br/>&nbsp;
</td>
<td><b>.o'o cu'i</b><br/>bloße Toleranz
</td>
<td><b>.o'u cu'i</b><br/>Gelassenheit, Ausgeglichenheit
</td></tr>
<tr>
<td><b>.o'a nai</b><br/><i>Wie peinlich.<br/>Es macht mich beschämt.</i>
</td>
<td><b>.o'e nai</b><br/>Distanz
</td>
<td><b>.o'i nai</b><br/>Unbesonnenheit, Rücksichtslosigkeit
</td>
<td><b>.o'o nai</b><br/>Ungeduld, Intoleranz
</td>
<td><b>.o'u nai</b><br/>Stress, Angst
</td></tr></tbody></table>

Notice how an emotion changes to its opposite when using **nai**, and to the middle emotion when using **cu'i**.

Warum sind einige Zellen der Interjektionen mit **cu'i** und **nai** leer? Weil es im Englischen keine prägnanten Möglichkeiten gibt, solche Emotionen auszudrücken.

Außerdem werden viele dieser Interjektionen selten verwendet.

### Kombination von Interjektionen

> **iu ui nai**
> _Unglücklich verliebt._

<!-- -->

> **ue ui do jinga**
> _Oh, du hast gewonnen! Ich bin so glücklich!_

jinga
: … gewinnt

In diesem Fall war der Sieg unwahrscheinlich, also bin ich gleichzeitig überrascht und glücklich.

Interjektionen (im Gegensatz zu Skalarpartikeln und Interjektionssuffixen) modifizieren sich nicht gegenseitig:

> **ue ui do jinga**
> **ui ue do jinga**
> _Oh, du hast gewonnen! Ich bin so glücklich!_

Hier modifizieren zwei Interjektionen denselben Satz (den ganzen Satz), aber sie modifizieren sich nicht gegenseitig, daher ist ihre Reihenfolge nicht wichtig.

> **pei .u'i le gerku cu sutra plipe**
> _(Was fühlst du?) Heh, der Hund springt schnell._

Hier wird **pei** allein verwendet und modifiziert nicht **.u'i**, das danach gesetzt wird.

### Vergessen, eine Interjektion am Anfang zu setzen?

> **do pu sidju mi ui**
> _Du hilfst mir (yay!)_

**ui** modifiziert nur das Pronomen **mi** und bezieht die Haltung nur auf _mich_.

> **ui do pu sidju mi**
> _Yay, du hast mir geholfen._

Was, wenn wir vergessen haben, **ui** am Anfang dieses Satzes hinzuzufügen?

Wir können die Beziehung explizit als abgeschlossen kennzeichnen mit **vau** und dann die Interjektion setzen:

> **do pu sidju mi vau ui**
> _Du hast mir geholfen, yay!_
