## Lektion 11. Schwierigere Themen

### Kenne auch deine Erstsprache

Wenn du versuchst, dich in Lojban auszudrücken, ist es wichtig, es nicht nur zu einer Kopie des Englischen zu machen.

Betrachte den Satz:

> _Terry, der Tiger, besucht die große Stadt._

Es könnte verlockend sein, die Beziehung

vitke
: $x_1$ (Gast) besucht $x_2$ (jemanden) bei $x_3$

zu verwenden. Allerdings impliziert der Satz _besucht die große Stadt_ das Besuchen eines Ortes und nicht jemanden an diesem Ort, was zeigt, dass das englische Verb _to visit_ mehrere Bedeutungen haben kann.

Tatsächlich sehen wir zum Beispiel im Französischen separate Lösungen:

> I would like to visit my friends.<br/>
> J'aimerais rendre visite à mes amis.

<!-- -->

> I would like to visit this city.<br/>
> J'aimerais visiter cette ville.

Französisch verwendet _rendre visite_, wenn man jemanden besucht, und _visiter_, wenn man einen Ort besucht.

In Lojban übersetzen wir die Bedeutung, nicht nur die Wörter.

Das Verständnis der Besonderheiten deiner eigenen Sprache ist auch wichtig, wenn du versuchst, etwas in Lojban auszudrücken.

Die Lösungen für das obige Beispiel könnten sein:

> **la .teris. poi tirxu cu klama le barda tcadu**
> _Terry, der Tiger, kommt in die große Stadt._

tirxu
: $x_1$ ist ein Tiger

> **la .teris. poi tirxu cu pa roi klama le barda tcadu**
> _Terry, der Tiger, kommt einmal in die große Stadt._

<!-- -->

> **la .teris. poi tirxu cu pa re'u mo'u klama le barda tcadu**
> _Terry, der Tiger, kommt zum ersten Mal in die große Stadt._

<!-- -->

> **la .teris. poi tirxu cu co'a klama le barda tcadu**
> _Terry, der Tiger, reist in die große Stadt ab._

### Vier Bedeutungen von ‘_you_’ im Englischen

Wir haben bereits zwei Personalpronomen gesehen, **mi** (_ich_ oder _mich_) und **do** (_du_). Allerdings kann _you_ im Englischen mehrere Bedeutungen haben, die im Lojban auf spezifische Weise übersetzt werden:

- _you_ als _die eine Person, mit der ich spreche_:

 >**le pa do**<br/>
 >_du eine_

 Wir wissen, dass **le re prenu** _die zwei Personen_ bedeutet. Es ist auch möglich, Zahlen nach **le** und vor Pronomen zu setzen.

- _you_ als _alle Personen, mit denen ich spreche_:

 >**ro do**<br/>
 >_jeder von euch_, _alle von euch_ (oder im südlichen US-Englisch _y'all_)

Man kann auch Zahlen mit **ko** verwenden:

>**ro ko klama ti**<br/>
>_Alle von euch, kommt hierher._

- _du_ als _eine bestimmte Anzahl von Personen, mit denen ich spreche_:

>**le re do**<br/>
>_ihr zwei_

Zum Beispiel kann man E-Mails an seine Eltern mit **coi le re do** beginnen.

Beachte, dass **re do** _zwei von euch_ bedeutet und **re le ci do** _zwei von euch dreien_ bedeutet.

- _du_ als _die Person oder Personen, mit denen ich spreche, plus eine andere Person oder Personen_:

>**do'o**<br/>
>_du und jemand anderes_

- _du_ als _irgendjemand_ (z.B. _Geld kann dir keine Liebe kaufen._):

Es wird typischerweise ausgedrückt durch:

>**ro da**<br/>
>_alle **da**_

oder

>**ro lo prenu**<br/>
>_alle Personen_

Man kann es jedoch oft ganz weglassen oder **zo'e** an dieser Stelle platzieren.
<!-- Die empfohlene Methode ist, Pronomen zuerst in Verben zu verwandeln:

>**lo re me do ko klama ti**
>_Ihr zwei, kommt hierher._

Es ist möglich, **me** an dieser Stelle wegzulassen und **lo re do ko klama ti** zu sagen, aber das kann bei Anfängern zu Verwirrung führen. -->

### Mehr über kurze Relativsätze

Kurze Relativsätze mit einem folgenden Pronomen können direkt nach **le** platziert werden:

> **le gerku pe mi**
> _Mein Hund_

In solchen Fällen kann **pe** sogar weggelassen werden:

> **le gerku pe mi**
> **le mi gerku**
> _Mein Hund_

**le mi gerku** bedeutet genau dasselbe wie **le gerku pe mi**.

Daher ist "**le** + Argument + Relationskonstrukt" gleichbedeutend mit "**le** + Relationskonstrukt + **pe** + Argument".

Einige Regeln:

- Wenn du ein Argument verwenden möchtest, das aus einer Relation konvertiert wurde (zum Beispiel mit **le**) oder wenn es ein Name ist, ist es ratsam, **pe** zu verwenden und es nach dem Argument zu platzieren: **le gerku pe la .alis.** (_Alices Hund_).
- Das Weglassen von **pe** ist nur akzeptabel, wenn Pronomen ohne Zahlen davor verwendet werden: **le do gerku** (_dein Hund_), aber nicht **le pa do gerku** (= **le pa do cu gerku** = _einer von euch ist ein Hund_).

Es ist viel sicherer, **pe** explizit zu verwenden und es nach dem Argument zu platzieren, an das es angehängt ist: **le gerku pe la .alis.** und **le gerku pe mi** sind die intuitivsten Konstrukte.

### Zitate in verschiedenen Sprachen

**zoi** ist ein Anführungszeichen für das Zitieren von nicht-Lojban-Text. Seine Syntax ist **zoi X. text .X**, wobei X ein Lojban-Wort (das Begrenzungswort) ist, das durch Pausen vom zitierten Text getrennt ist und das nicht im geschriebenen Text oder im gesprochenen Phonemstrom innerhalb dieses Zitats vorkommt. Es ist üblich, aber nicht erforderlich, den Namen eines Buchstabens zu verwenden, der dem Lojban-Namen der zitierten Sprache entspricht:

> **zoi gy. John is a man .gy. cu glico jufra**
> _„John is a man“ ist ein englischer Satz._

glico
: $x_1$ ist Englisch

wobei **gy.** für **glico** steht. Andere beliebte Begrenzungswörter sind das Wort _zoi_ selbst und ein Lojban-Wort, das das Thema des Zitats andeutet.

Lojban vermeidet strikt jede Verwechslung zwischen Dingen und den Namen der Dinge:

> **zo .bob. cmene la .bob.**
> `Das-Wort „Bob“ ist-der-Name-desjenigen-der Bob genannt wird.`

**zo .bob.** ist das Wort, während **la .bob.** das Ding ist, das durch das Wort benannt wird. Die kurzen Qualifikationswörter **la'e** und **lu'e** vor Begriffen wandeln hin und her zwischen Referenzen und ihren Referenten:

> **zo .bob. cmene la'e zo .bob.**
> _Das-Wort „Bob“ ist-der-Name-des-Referenten-des-Wortes „Bob“._

<!-- -->

> **lu'e la .bob. cmene la .bob.**
> _Ein-Symbol-für Bob ist-der-Name-von Bob._

Die letzten beiden Beispiele bedeuten dasselbe. Aber das ist anders:

> **la .bob. cu cmene la .bob.**
> _Bob ist der Name von Bob._

und sagt, dass Bob sowohl der Name als auch das benannte Ding ist, eine unwahrscheinliche Situation. Menschen sind keine Namen.

**la'o** dient dazu, nicht-Lojban-Namen zu kennzeichnen, zum Beispiel die Linnäischen binomialen Namen (wie "Homo sapiens"), die die international standardisierten Namen für Tier- und Pflanzenarten sind.

International bekannte Namen, die leichter durch Rechtschreibung als durch Aussprache erkannt werden können, wie _Goethe_, können auch im Lojban-Text mit **la'o** erscheinen:

> **la'o dy. Goethe .dy. cu me la'o ly. Homo sapiens .ly.**
> _Goethe ist ein Homo sapiens._

Die Verwendung von **la'o** für alle Namen anstatt sie an Lojban anzupassen, kann jedoch zu einem umständlichen Text führen.

Alles, was im Text ausgedrückt wird, sollte auch in der Sprache ausgedrückt werden und umgekehrt. Daher kann es keine Interpunktion geben, die nicht ausgesprochen wird. Das bedeutet, dass Lojban eine breite Palette von Wörtern hat, um andere Wörter zu zitieren. Alle Lojban-Wörter wandeln einen Text in einen Argumentbegriff um.

**lu** … **li'u** zitiere nur grammatisch korrekten Text. Um beliebigen Lojban-Text zu zitieren, verwenden wir stattdessen **lo'u** … **le'u** Zitate.

> **— xu lo'u je le'u lojbo sumsmi**
> **— na ku sumsmi**
> _— Ist "je" ein Begriff?_
> _— Nein._

<!-- -->

> **ma xe fanva zoi gy.What's up?.gy. la .lojban.**
> _Wie übersetzt man "What's up?" ins Lojban?_

### Interne Begriffe

Mit **be** kannst du nicht nur die Slots von Relationen füllen, sondern auch modale Begriffe hinzufügen:

> **le xatra be de'i li vo cu se mrilu de'i li ze**
> _Dieser Brief, datiert auf den 4., wird am 7. verschickt_

xatra
: $x_1$ ist ein Brief

Ein mit **de'i** markiertes Datum bezieht sich nur auf den **xatra**. Vergleiche:

> **le xatra de'i li vo cu se mrilu de'i li ze**
> _Der Brief am 4. wird am 7. verschickt_ (was auch immer das bedeuten kann)

Ohne **be** würde sich der Begriff **de'i li vo** auf die gesamte Relation beziehen, nicht auf **xatra**. Was wir sagen wollen, ist, dass sich das erste Datum nur auf den Brief bezieht und das zweite Datum auf das Verschicken des Briefes. Das bedeutet, dass in **le xatra be de'i li vo** der Teil **de'i li vo** (_der 4., als Datum_), sich nur auf das Argument **le xatra** bezieht und nicht auf den gesamten Satz.

### Zusammengesetzte Relationen im Detail

Die Gruppierung von Begriffen in der Lojban-Grammatik ist besonders wichtig, wenn es um tanru (zusammengesetzte Relationen) geht. Die Art und Weise, wie Relationen in einem tanru zusammengefasst werden, bestimmt, was dieses tanru bedeutet. Zum Beispiel,

> _das schlechte Musikmagazin_

hat im Englischen zwei Interpretationen: ein schlechtes Magazin über Musik oder ein Magazin über schlechte Musik. Im Lojban hat das Äquivalent

> **le xlali zgike karni**

nur die Interpretation _ein schlechtes-Musik-Magazin_, weil die ersten beiden Relationen (_xlali zgike_ — _schlechte Musik_) zuerst zusammengefasst werden. Es ist wichtig, die Gruppierung der Relationen zu ändern, um sicherzustellen, dass das tanru die beabsichtigte Bedeutung vermittelt. Aus diesem Grund hat Lojban einige Mechanismen, um tanru richtig zusammenzufassen.

Im Englischen verwenden wir Klammern, um den Text zu strukturieren. Ähnlich verwenden wir für tanru **ke** für die linke Klammer und **ke'e** für die rechte Klammer.

**le xlali ke zgike karni** bedeutet _das schlechte (Musikmagazin)_.

Wie Sie sehen können, haben wir **xlali** vom Rest des tanru getrennt und es auf das gesamte tanru angewendet. Es ist kein **ke'e** am Ende des tanru erforderlich, da wir bereits wissen, dass es hier endet.

> **.i mi pu zi te vecnu le xlali ke zgike karni .i to'e zanru la'o gy.Eurythmics.gy.**
> _Ich habe gerade ein schlechtes (Musikmagazin) gekauft. Es hat die Eurythmics schlecht gemacht._

Das ist eine Möglichkeit, Komponenten in tanru zusammenzufassen. Die andere Möglichkeit besteht darin, **bo** in einer neuen Rolle zu verwenden. Wenn **bo** zwischen zwei Komponenten erscheint, bedeutet dies, dass diese Komponenten enger zusammengehören als alles andere. Eine alternative Möglichkeit, _schlechtes (Musikmagazin)_ zu sagen, ist

le xlali zgike bo karni
: das schlechte Musik-Magazin

**bo** hier ist ähnlich wie der Bindestrich in der englischen Übersetzung. Das bedeutet, dass **zgike bo karni** als Einheit zählen sollte, auf die **xlali** (_schlecht_) angewendet wird.

Also macht **bo** die Verbindungen enger:

> **la .doris. e la .alis. o nai bo la .bob.**
> _Doris und (entweder Alice oder Bob)_

**ke** kann auch mit Konnektoren verwendet werden (obwohl nicht mit Sätzen; sie haben ihre eigene Art von Klammern, **tu'e … tu'u**). Also könnten wir auch sagen

> **la .doris. e ke la .alis. o nai la .bob.**

Denken Sie daran, dass die rechte Klammer **ke'e** oft weggelassen werden kann, ohne die Bedeutung zu ändern (wie in diesem Fall).

Vorausschauende Konjunktionen werden auch häufig verwendet, da sie die Notwendigkeit für rechte Klammern beseitigen können:

> **ge la .doris. gi go nai la .alis. gi la .bob.**
> _Doris und entweder Alice oder Bob_

und

> **go nai ge la .doris. gi la .alis. gi la .bob.**
> _Entweder Doris und Alice, oder Bob_

Es besteht keine Notwendigkeit für **bo** oder **ke** bei vorausschauenden Konjunktionen.

### «**co**» zum Ändern der Reihenfolge in zusammengesetzten Beziehungen

Es gibt eine andere Möglichkeit, zusammengesetzte Beziehungen umzugestalten.

> **mi fanva se jibri**
> _Ich bin ein professioneller Übersetzer_

jibri
: $x_1$ ist ein Job von $x_2$

Wenn ich sagen wollte, dass ich ein professioneller Übersetzer von Englisch nach Deutsch bin, könnte ich **be** und **bei** verwenden:

> **mi fanva be le dotco bei le glico be'o se jibri**
> _Ich bin ein professioneller Übersetzer ins Deutsche aus dem Englischen._

dotco
: $x_1$ ist Deutsch

Die Tatsache, dass es sich um eine zusammengesetzte Beziehung handelte, konnte in der Sprache aufgrund der komplizierten Satzstruktur schnell verloren gehen. Hier können wir das Wort **co** verwenden:

**co** — kehrt die zusammengesetzte Beziehung um, sodass die rechteste Komponente die linkeste modifiziert, anstatt umgekehrt. Jeder vorherige Argumentterm füllt das Modifizierte, jeder nachfolgende Argumentterm füllt den Modifikator.

> **mi se jibri co fanva le dotco le glico**

Es ist die gleiche Beziehung wie die vorherige Lojban-Beziehung, aber viel einfacher zu verstehen. Beachten Sie, dass jedes Argument vor der zusammengesetzten Beziehung **se jibri** füllt, während jedes danach nur die modifizierende Komponente füllt: **fanva**.

Die Stärke, mit der zwei Komponenten mit **co** verbunden sind, ist sehr schwach — sogar schwächer als die normale Gruppierung von zusammengesetzten Beziehungen ohne Gruppierungswörter. Dies stellt sicher, dass in einer co-Konstruktion die linkeste Komponente immer die modifizierte Komponente ist und die rechteste Komponente immer modifiziert, selbst wenn einer dieser Teile zusammengesetzte Beziehungen sind. Dies macht eine **co**-Konstruktion leicht verständlich:

> **ti pelxu plise co kukte**

wird gelesen als **ti (pelxu plise) co kukte**, was dasselbe ist wie **ti kukte pelxu bo plise**. Dies bedeutet auch, dass ein **ke … ke'e** kein **co** umfassen kann.

Ein weiteres Beispiel:

> **mi merko limna co mutce certu**
> _Ich bin ein sehr erfahrener amerikanischer Schwimmer._

merko
: $x_1$ ist Amerikaner (im Sinne der USA)

Hier ist die Liste der verschiedenen Arten von Gruppierungen in zusammengesetzten Beziehungen, geordnet von der engsten bis zur lockersten:

1. **bo** und **ke … ke'e**
2. logische Konnektive innerhalb von zusammengesetzten Beziehungen wie **je**
3. keine Gruppierungswörter verwenden
4. **co**

### Explizite Beendigung von Argumenten

Das kleine Wort **ku** kann am Ende eines Arguments verwendet werden, um explizit dessen rechte Grenze zu zeigen. **ku** ist analog zur rechten Klammer in der Mathematik.

> **tu du le badna ku ui**
> **tu du le ui badna**
> _Das ist die Banane (yay!)_

Im Gegensatz zu:

> **tu du le badna ui**
> _Das ist die Banane (yay, dass es eine Banane ist und nichts anderes in der Natur!)_

### Vermeidung expliziter Beendigung
Ein anderer Sprachstil besteht darin, die Beendigung zu vermeiden. Hier sind einige häufige Fälle:

Eliminierung von **li'u**, dem rechten Anführungszeichen:

> **lu mi prami do li'u cu se cusku la .alis.**
> **lu mi prami do li'u se cusku la .alis.**
> **lu mi prami do cu se cusku la .alis.**
> _"I love you," sagte Alice._

**li'u** kann hier weggelassen werden, da es in einem Satz nicht zwei Hauptbeziehungskonstrukte geben kann. Daher lesen wir zuerst den Teil **lu mi prami do**, und wenn wir dann das **cu** sehen, erkennen wir, dass wir diesen zitierten Satz nicht weiter fortsetzen können. Wir nehmen an, dass das Zitat beendet ist und der äußere Satz weitergeht. Somit entsteht keine Mehrdeutigkeit.

Eliminierung von **ku'o**, der rechten Grenze von Relativsätzen:

> **le prenu noi mi zgana ke'a ku'o ca tavla le pendo be mi**
> **le prenu noi mi zgana ke'a ca tavla le pendo be mi**
> _Die Person, die ich beobachte, spricht jetzt mit meinem Freund._

**ku'o** kann hier weggelassen werden, wenn der benötigte Relativsatz (**mi zgana ke'a**) in einem Term endet, in diesem Fall **ke'a**. Nach dem Relativsatz beginnt etwas anderes als ein Term, sodass der Relativsatz nicht fortgesetzt werden kann, und wir wissen daher, dass er erfolgreich endet, ohne dass explizite rechte Klammerwörter erforderlich sind.

Ein ähnlicher Trick wäre, **ke'a** immer am Ende des Relativsatzes zu platzieren:

> **le prenu noi ke'a melbi ku'o ca tavla le pendo be mi**
> **le prenu noi melbi fa ke'a ca tavla le pendo be mi**
> _Die Person, die hübsch ist, spricht jetzt mit meinem Freund._

In folgendem Fall ist jedoch eine Beendigung notwendig:

> **le prenu noi mi zgana ke'a ku'o le pendo be mi ca tavla**
> _Die Person, die ich beobachte, spricht jetzt mit meinem Freund._

weil wir nach dem Relativsatz **mi zgana ke'a** einen weiteren Term (**le pendo be mi**) platziert haben, der nicht zum aktuellen Relativsatz gehört.

Ein halb-trick hier wäre die Verwendung von **ce'e**:

> **le prenu noi mi ke'a zgana ce'e le pendo be mi ca tavla**
> _Die Person, die ich beobachte, spricht jetzt mit meinem Freund._

Hier beenden wir den Relativsatz mit dem Hauptbeziehungskonstrukt **zgana**. Dann haben wir die Konjunktion **ce'e** und danach einen Term (**le pendo be mi**). Da **ce'e** nur Terme verbinden kann, wissen wir, dass links von **ce'e** ein Term steht, der nur **le prenu noi mi ke'a** sein kann. Daher bleibt die Bedeutung erhalten, und es entsteht keine Mehrdeutigkeit. Beachten Sie, dass wir in solchen Fällen immer noch ein separates Wort, **ce'e**, benötigen, sodass wir zwar das helle Klammerwort eliminiert haben, aber dennoch etwas anderes einführen mussten.

Eliminierung von **kei**, der rechten Grenze innerer Sätze:

> **mi cinmo le ka badri kei le tcini**
> **le ka badri cu se cinmo mi le tcini**
> **mi cinmo fi le tcini fe le ka badri**
> **mi cinmo le ka badri ce'e le tcini**
> _Ich fühle mich traurig bezüglich der Situation._

> **mi stidi lo ka citka su'o da kei do**
> **mi stidi lo ka ce'u su'o da citka ce'e do**
> _Ich schlage vor, dass du etwas isst._

Wie du sehen kannst, macht kein Trick das Ergebnis kürzer als das Original mit **kei**, daher möchtest du vielleicht **kei** für die Kürze verwenden.

### Umwandlung von Mengen in Massen

> **le prenu cu pa moi le'i pendo be mi ku noi lu'o ke'a ca smaji**
> _Er ist der Erste unter meinen Freunden, die zusammen schweigen._
> _Die Person ist der Erste unter der Menge meiner Freunde, die jetzt als Menge schweigen._

Das Qualifikationswort **lu'o**, das vor einem Argument platziert wird, wandelt es in eine Masse aus Mitgliedern dieses Arguments um. In diesem Fall bezieht sich **ke'a** auf die Menge meiner Freunde **le'i pendo be mi** und dann wandelt **lu'o** die Mitglieder der Menge in eine Masse um, die Menge meiner Freunde.

### Mengen und Teilmengen

Einige Infinitive können mehr als ein **ce'u** implizieren:

> **le'i prenu cu simxu le ka prami**
> **le'i prenu cu simxu le ka ce'u prami ce'u**
> _Die Leute lieben einander._

simxu
: Mitglieder der Menge $x_1$ tun wechselseitig $x_2$

Die Relation **simxu** nimmt jedes mögliche Paar aus der in $x_1$ angegebenen Menge und behauptet die in $x_2$ angegebene Relation.

Wenn wir drei Personen haben, würde das bedeuten, dass alle sich gegenseitig lieben.

> **do ce la .alis. ce mi simxu le ka prami**
> **do ce la .alis. ce mi simxu le ka ce'u prami ce'u**
> _Du, Alice und ich lieben uns alle gegenseitig._

ce
: Konjunktion: verbindet mehrere Argumente zu einer Menge

Die Konjunktion **ce** verbindet Argumente zu einer Menge. Daher könnte **do ce la .alis. ce mi** eine ausführlichere Art von **le'i prenu** aus dem vorherigen Beispiel sein, wenn wir die Mitglieder der Menge benennen wollen.

<pixra url="/assets/pixra/cilre/simxu_tunba.webp" caption="le'i ci prenu cu simxa le ka tunba" definition="Die drei Personen sind alle Geschwister zueinander."></pixra>

Insgesamt behaupten wir 6 Beziehungen:

1. Du liebst Alice.
2. Du liebst mich.
3. Alice liebt mich.
4. Alice liebt dich.
5. Ich liebe Alice.
6. Ich liebe dich.

Daher ist **simxu** eine schöne Abkürzung, um gegenseitige Beziehungen auszudrücken.

Betrachten wir nun das Beispiel:

> **le'i su'o cmima be le'i prenu cu simxu le ka prami**
> _Einige der Leute lieben sich gegenseitig._

cmima
: $x_1$ ist ein Mitglied der Menge $x_2$

In diesem Beispiel zeigen wir, dass eine Teilmenge der betreffenden Personen (eine Teilmenge von **le'i prenu**) gegenseitige Liebe hat.

Dies ermöglicht es uns, noch kniffligere Ideen zu vermitteln:

> **le'i su'o citno cmima be le'i stati prenu cu simxu le ka prami**
> _Einige Jugendliche aus diesen klugen Leuten lieben sich gegenseitig._
> `Einige junge Mitglieder der Menge der klugen Leute lieben sich gegenseitig.`

<!-- https://www.whitman.edu/mathematics/higher_math_online/section02.04.html -->
<!-- ### Matheprobleme

Im Folgenden ist eine Liste einiger Konzepte und Probleme in der Mathematik, die veranschaulichen, wie Lojban damit umgehen kann.

* Einzigartigkeit
	> $\exists ! x\,(x^2=0)$<br/>
	> Es gibt einen eindeutigen Wert für die Variable $x$, so dass für diesen Wert der Ausdruck $x^2+1=2x$ wahr ist.<br/>
	> **pa da zo'u li no du lo tenfa be nu'i da li re**<br/>
	> Es gibt nur ein $x$, so dass $0$ gleich dem exponentiellen Ergebnis von $x$ hoch 2 ist.<br/>
	> **su'o da ro de zo'u du go da de gi li no lo tenfa be nu'i ge da li re gi de li re**<br/>
	> Für jedes $x$ (das einen Wert hat) und für jedes $y$, was auch immer sie sein mögen: entweder 1. $x$ ist gleich $y$ und 2. $0$ ist gleich dem exponentiellen Ergebnis sowohl von $x$ hoch 2 als auch von $y$ hoch 2; oder 1. ist falsch und 2. ist falsch.

	Dieses Matheproblem postuliert, dass es nur einen eindeutigen Wert von $x$ gibt, so dass der Ausdruck $(x^2=0)$ wahr ist. "Einzigartigkeit" kann entweder als **pa** (_eins_) oder auf eine ausführlichere Weise ausgedrückt werden:

	1. wir postulieren, dass $x$ einen Wert hat, der unsere mathematische Aussage wahr macht, daher verwenden wir **su'o da**, und
	2. wir definieren eine zweite Variable, z.B. $y$ und zeigen, dass wann immer $(x^2=0)$ und $(y^2=0)$ dann $x=y$.
* Fibonacci-Zahlen

	Fibonacci-Zahlen sind eine Zahlenfolge, bei der jede Zahl die Summe der beiden vorhergehenden ist, normalerweise beginnend mit 0 und 1. Die Folge lautet: 0, 1, 1, 2, 3, 5, 8, 13, 21, 34 und so weiter.

Es gibt mehrere Möglichkeiten, Fibonacci-Zahlen zu berechnen. Ein einfacher Ansatz ist die Verwendung von Rekursion, bei der die $n$-te Fibonacci-Zahl als Summe der $(n-1)$ten und $(n-2)$ten Fibonacci-Zahlen berechnet wird.

Die Fibonacci-Funktion hat $n$ als Eingabe und die $n$-te Fibonacci-Zahl als Ausgabe.

> **ro da poi kacna'u zo'u**
> **ge da du li no gi lo ka fibno da du cu ka du li no**
> **.i jonaibo**
> **ge da du li pa gi lo ka fibno da du cu ka du li pa**
> **.i jonaibo**
> **lo ka fibno da du cu ka sumji lo fibno be lo se sumji be da bei li pa be'o lo fibno be lo se sumji be da bei li re**

> _Für jedes $n$, das eine natürliche Zahl ist, wenn $n=0$, dann ist die $n$-te Fibonacci-Zahl gleich $0$._
> _Oder wenn $n=1$, dann ist die $n$-te Fibonacci-Zahl gleich $1$._
> _Andernfalls ist die $n$-te Fibonacci-Zahl gleich der Summe der $(n-1)$ten Fibonacci-Zahl und der $(n-2)$ten Fibonacci-Zahl._

In dieser Lösung wird ein ad hoc brivla **fibno** verwendet, das der Fibonacci-Funktion entspricht.

Die Summe von zwei Zahlen wird mit **sumji lo fibno ... lo fibno** ausgedrückt.
Die Differenz von zwei Zahlen wird mit **se sumji lo fibno ... lo fibno** ausgedrückt.

<!-- i ja
ge da du li za'u pa gi lo ka fibno da du cu ka du li mo'e lo fibno be li mo'e da ni'u pa te'u su'i mo'e lo fibno be li mo'e da ni'u re
i ja
ge da du li za'u pa gi lo ka fibno da du cu ka sumji lo fibno be li mo'e da ni'u pa lo fibno be li mo'e da ni'u re -->

<!-- ## Zweite Ordnung Logik

Wir haben **da** (und **de**, **di**) als "Variable" in Substantivform mit erklärten Bedeutungen je nach gegebenen Aussagen gesehen.
Es wird normalerweise als _es gibt X, es gibt X, so dass …_ übersetzt.

Aus Neugier muss ich jedoch die Reihe von Verben erwähnen, die auch als "Variablen" dienen, aber in Verb-, d.h. Beziehungsform:

>**su'o bu'a zo'u mi bu'a do**
>_Es gibt eine Beziehung oder Eigenschaft: Ich habe diese Beziehung zu dir._
> _Du und ich sind in mindestens einer Weise verbunden._

>**ro bu'a zo'u ga nai le'e mlatu cu bu'a gi la .dinas. bu'a**
>>_Für jede mögliche Beziehung oder Eigenschaft: Wenn Katzen sie haben, dann hat Dinah sie auch._ (Daher nehmen wir an, dass Dinah eine Katze ist.)

Die Begründung hinter diesen variablen Verben ist in der formalen Logik verborgen. Es versteht sich von selbst, dass sie selten in der Sprache verwendet werden, aber hier ist ein mögliches Beispiel:

su'o bu'a zo'u ge ge da na bu'a gi su'o da su'o de zo'u ge da .e de bu'a gi da manci de gi ro da ro de zo'u da bu'a .ije da manci de .inaja de bu'a
- den Satz korrigieren

<!-- ## Dinge, die noch nicht in Lojban formalisiert sind

Obwohl Lojban vielleicht die sprechbare Sprache Nr. 1 in der Welt ist, wie detailliert ihre Grammatik auch sein mag. Es gibt immer noch einige
Es ist unbekannt, was **ta'e na** bedeutet im Gegensatz zu **na ta'e**.

Es ist unbekannt, wie man mit **na go'i** umgeht.

Es ist unbekannt, wie xorlo funktioniert, wenn wir eine explizite Umwandlung zwischen Mengen und Massen benötigen, wie man Mengen im Allgemeinen operiert, wie man xorlo zusammen mit zweiter Ordnung Logik wie bu'a verwendet.

postoxorlo arbeitet mit Anaphern und äußeren Quantoren. -->

<!-- ## Nicht-standardisiertes Konnektivsystem

Einige Leute verwenden zum Verbinden von Substantiven anstelle von

- **a**, **e**, **o**, **u**

verwenden

- **ja**, **je**, **jo**, **ju**

Das heißt, anstelle von

>**mi e do nelci le plise**
>_Ich mag Äpfel, und du magst Äpfel._

sagen sie

>**mi je do nelci le plise**
>_Ich mag Äpfel, und du magst Äpfel._

Dies ist ein nicht-standardisierter Ansatz. Leute verwenden diesen Stil, weil es darin weniger Konjunktionen zu merken gibt.

Aber du solltest darauf achten, **le** oder Zahlen nicht zu vergessen, um Substantive zu bilden: **mi nelci le plise je jisra** würde bedeuten _Ich mag etwas, das ein Apfel (oder Äpfel) ist und Saft ist_ (?!)

Der korrekte Satz verwendet **le**, um jedes Substantiv zu bilden:

>**mi nelci le plise je le jisra**
>_Ich mag Äpfel und Saft._

Im standardisierten Ansatz verwendet der Sprecher eine separate Konjunktion **e** beim Verbinden von Substantiven, und es ist einfacher, den Unterschied und die korrekte Bedeutung zu sehen:

>**mi nelci le plise .e le jisra**
>_Ich mag Äpfel und Saft._ -->
