## Lektion 10. Strukturierung von Text

### «**ju'a**» und Behauptungen

Die Hauptbeziehung eines Satzes behauptet einige Informationen, es sei denn, sie wird durch eine Interjektion modifiziert:

> **mi viska do**
> _Ich sehe dich._
> `Ich behaupte, dass ich dich sehe`
<!-- -->
> **.au mi viska do**
> _Ich wünschte, ich sähe dich._

Im letzten Beispiel habe ich nur einen Wunsch, aber ich behaupte nicht, dass ich dich sehe.

Ein weiteres Paar von Beispielen:

> **le prenu cu cizra .i ji'a je la .alis. cu jinvi le du'u go'i**
> _Die Person ist seltsam. Und Alice denkt das auch._

<!-- -->

> **la .alis. cu jinvi le du'u le prenu cu cizra**
> _Alice hat die Meinung, dass die Person seltsam ist._

Beziehungen, die sich innerhalb von Plätzen befinden, müssen nicht behauptet werden. Im letzten Beispiel wird das Seltsamsein des Mannes (**le prenu cu cizra**) nicht vom Sprecher behauptet; es ist nur Alices Meinung.

Die Interjektion **ju'a** macht die Beziehung vom Sprecher behauptet. Der erste Satz kann umformuliert werden als:

> **la .alis. cu jinvi le du'u ju'a le prenu cu cizra**
> _Alice hat die Meinung, dass die Person seltsam ist, und es ist so._

<!-- -->

> **ju'a .au mi viska do**
> _Ich wünschte, ich sähe dich. Aber ich sehe dich gleichzeitig._

Englisch versagt oft dabei, dieses mächtige **ju'a** prägnant zu übersetzen, daher folgt die englische Übersetzung nicht der Wortreihenfolge des Lojban-Originals.

Hier ist ein weiteres Beispiel:

> **mi nelci le nu do dansu**
> _Ich mag es, wenn du tanzt._

<!-- -->

> **mi nelci le nu ju'a do dansu**
> _Ich mag es, dass du tanzt._

Im zweiten Fall behauptet der Sprecher _Du tanzt_.

### «**pe'a**» für Metaphern, «**za'e**» für einmalige Wörter, «**ba'e**» für Betonung

> **le ninmu cu tarci pe'a .i va'i ri misno**
> *Die Frau ist ein Stern, metaphorisch gesprochen. Mit anderen Worten, sie ist berühmt.*

pe'a
: Interjektion: kennzeichnet eine Konstruktion als metaphorisch verwendet.

tarci
: $x_1$ ist ein Stern

**tarci** bezeichnet echte Sterne, Objekte am Himmel. Die Interjektion **pe'a** verwandelt es in eine metaphorische Bedeutung.

> **.i ba ku mi pu viska le cizra stuzi poi le fagri cu nenri .i mi pu klama za'e le fagrystu**
> *Dann sah ich einen seltsamen Ort mit einem Feuer darin. Ich näherte mich dem, sagen wir, "Feuer-Ort."*

za'e
: linke Interjektion: kennzeichnet das folgende Konstrukt als nicht in seiner üblichen Bedeutung verwendet

Linke Interjektionen, wie der Name schon sagt, werden vor einem modifizierten Konstrukt platziert (während andere Interjektionen danach platziert werden).

Die linke Interjektion **za'e** zeigt, dass das folgende Konstrukt, in diesem Fall **le fagrystu**, erfunden oder nicht in seiner Standardbedeutung verwendet wird. Daher ist es nicht notwendig, es im Wörterbuch nachzuschlagen oder den Sprecher speziell nach der Bedeutung dieses Wortes zu fragen, da das Wort verwendet wird, um die Geschichte weiter zu beschreiben.

> **ba'e la .alis. e nai la .kevin. pu darxi mi**
> *Alice, nicht Kevin, hat mich geschlagen!*

<!-- -->

> **mi djuno le du'u ma kau pu darxi ba'e mi .i ku'i mi na ku djuno le du'u ma kau pu darxi do**
> *Ich weiß, wer mich geschlagen hat. Allerdings weiß ich nicht, wer dich geschlagen hat.*

ba'e
: linke Interjektion: betont das folgende Konstrukt

Um ein Wort zu betonen, würden wir im gesprochenen Englisch Stress verwenden und im geschriebenen Englisch Unterstreichungen, Kursivschrift oder Großbuchstaben. Im Lojban verwenden wir die linke Interjektion **ba'e**.

### Absätze und Satztrennung

**ni'o** funktioniert genau wie **.i**, beginnt aber einen neuen Absatz. Absätze sind normalerweise mit neuen Themen verbunden.

Es ist normal, **.i** in der Rede zu verwenden, um Sätze zu trennen, aber man könnte **ni'o** besonders in geschriebenen Texten verwenden, um sie zu strukturieren.

<table>
 <tr>
  <td>ni'o</td>
  <td></td>
 </tr>
 <tr>
  <td>.i le pa nintadni cu klama le ctuca bu'u le galtu bu'u le darno cmana</td>
  <td>Ein Neuling besuchte den Meister weit oben in den Bergen.</td>
 </tr>
 <tr>
  <td>.i sei le nintadni cu cusku doi le ctuca noi certu tavla fo la .lojban. ku'o do skicu .e'o fi mi fe le nu fi ma kau fa la .lojban. cu frica le'e drata bangu</td>
  <td>Der Neuling sagte: "Meister, du sprichst fließend Lojban. Bitte, erzähle mir, was der Unterschied zwischen Lojban und anderen Sprachen ist."</td>
 </tr>
 <tr>
  <td>.i le ctuca cu friti tu'a le kabri be lei jinto djacu le nintadni gi'e ba bo cusku</td>
  <td>Der Meister bot ihm eine Tasse Quellwasser an und sagte dann:</td>
 </tr>
 <tr>
  <td>lu .i ca ti ko catlu le djacu gi'e skicu ri li'u</td>
  <td>Jetzt schau dir das Wasser an und beschreibe es.</td>
 </tr>
 <tr>
  <td>.i ku'i sei le nintadni cu cusku mi mo'u pinxe ri i je mi na ku kakne le ka catlu</td>
  <td>Der Neuling sagte: "Aber ich habe es ausgetrunken. Ich kann es nicht ansehen."</td>
 </tr>
 <tr>
  <td>.i ki'u ma do na ku kakne sei le ctuca cu cusku</td>
  <td>Warum kannst du nicht?, sagte der Meister.</td>
 </tr>
 <tr>
  <td>.i sei le nintadni cu cusku le djacu ca pagbu le xadni be mi</td>
  <td>Der Neuling sagte: "Jetzt ist es ein Teil meines Körpers."</td>
 </tr>
 <tr>
  <td>ni'o</td>
  <td></td>
 </tr>
 <tr>
  <td>.i su'o da poi prenu zo'u le mudri co'a pagbu le zdani be da</td>
  <td>Ein Stück Holz wird Teil des Hauses von jemandem.</td>
 </tr>
 <tr>
  <td>.i su'o de poi prenu zo'u su'o lo bangu poi se tadni cu co'a pagbu le menli be de</td>
  <td>Eine erlernte Sprache wird Teil des Geistes von jemandem.</td>
 </tr>
 <tr>
  <td>.i su'o di zo'u le dirgo be le djacu co'a pagbu da poi zmadu fi le ka banli</td>
  <td>Ein Tropfen Wasser wird Teil von etwas Größerem.</td>
 </tr>
</table>

dirgo
: $x_1$ ist ein Tropfen Material $x_2$ …

### «**to**» … «**toi**» für erläuternde Bemerkungen

Kommentare, die in englischen Texten in Klammern gesetzt werden, werden mit dem Wort **to** anstelle der linken Klammer und **toi** anstelle der rechten Klammer gebildet:

> **ti poi to vi'o nai do mi na ku djica tu'a su'o lo drata toi plise cu fusra**
> _Dieser (nein, ich will keinen anderen!) Apfel ist verfault._

djica
: wünschen

drata
: … ist anders als …

plise
: $x_1$ ist ein Apfel

fusra
: $x_1$ verrottet oder zerfällt durch Agent $x_2$

Erläuternde Bemerkungen können überall dort eingefügt werden, wo auch Zwischenrufe möglich sind, was bedeutet, dass sie praktisch überall in einem Lojban-Satz platziert werden können. Bei Klammern, genau wie bei Anführungszeichen, muss man wissen, wo die Klammer beginnt und wo sie endet.

### Fehler in der Rede korrigieren

Wenn man sich selbst korrigiert, ist es wichtig zu wissen, wie man seine Fehler behebt. Man kann zwei Wörter verwenden, um die vorherigen Wörter zu löschen:

si
: Löschung: löscht nur das letzte Wort

sa
: Löschung: löscht bis zum nächsten gesprochenen cmavo zurück

Sie löschen Wörter, als ob diese Wörter nie gesprochen worden wären. Sie funktionieren jedoch nicht innerhalb bestimmter Zitate (alle Zitate außer **lu…li'u**), da es sonst unmöglich wäre, diese Wörter zu zitieren. Mehrere **si** hintereinander löschen mehrere Wörter.

Im Englischen, wenn man beim Sprechen einen Fehler macht (faktisch oder grammatikalisch), bemüht man sich normalerweise nicht, ihn zu korrigieren, selbst wenn man merkt, dass man einen Fehler gemacht hat. Das liegt daran, dass Englisch ziemlich redundant ist (aus genau diesem Grund!). Wenn wir uns dabei ertappen, einen Fehler im Englischen zu machen, liefern wir schnell eine Korrektur, ohne ins Detail zu gehen, wie viele Wörter gestrichen werden sollten: Der Kontext hilft uns normalerweise. Zum Beispiel:

> _Ich lerne das englische Wort, … äh, Lojban-Wort._

Der Kontext und der gesunde Menschenverstand diktieren, dass _Lojban-Wort_ _englisches Wort_ ersetzen soll. Aber was, wenn es _Ich lerne das englische Wort_ ersetzen sollte? Normalerweise würden wir uns in natürlichen Sprachen nicht darum kümmern.

Lojban erlaubt es jedoch, genauer zu sein, welche Wörter man korrigiert.

**si** löscht das unmittelbar vorhergehende Wort. Wenn man zwei Wörter hintereinander löschen möchte, sagt man **si si** danach. Im Lojban würde die obige Korrektur lauten:

> **.i mi tadni le glico valsi si si lojbo valsi**
> _Ich lerne das englische Wort, … äh, Lojban-Wort._

valsi
: $x_1$ ist ein Wort mit der Bedeutung $x_2$ in der Sprache $x_3$

Das Problem mit **si** ist, dass man Wörter zählen muss. Das kann mühsam werden, und man sollte kein Transkript seiner Wörter führen müssen, wenn man sich korrigieren möchte.

Das andere Korrekturwort **sa** ist hilfreicher: **sa** nimmt als Argument das Wort, das darauf folgt. Dann löscht dieses **sa** Wörter zurück, bis es dasselbe Wort oder ein Wort derselben Klasse findet. Zum Beispiel:

> **.i mi tadni le sa .i mi tadni le lojbo valsi**
> _Ich lerne das … äh, ich lerne das Lojban-Wort._
> **.i mi tadni le lojbo valsi**

Das Argument von **sa** ist das Wort **.i**. Also ersetzt der Satz nach **sa** den aktuellen Satz bis einschließlich **sa**. Oder betrachten wir:

> **.i mi mrilu fi do de'i li jefydei bu pa sa de'i li jefydei bu re**
> _Ich habe es dir am Montag geschickt, … äh, am Dienstag._
> _Am Montag habe ich es dir geschickt, … äh, eigentlich war es Dienstag._
> **.i mi mrilu fi do de'i li jefydei bu re**

Die Korrektur ist **de'i li jefydei bu re** — _am Dienstag_. Also ersetzt es alles ab der letzten Relation, die mit **de'i** beginnt: **de'i li jefydei bu pa** — _am Montag_.

### Umgang mit Missverständnissen

> **— .i mi pu zi te vecnu le flokati**
> **— .i le flokati ki'a**
> _— Ich habe gerade einen Flokati gekauft._
> _— Flokati, was?_

ki'a
: Interjektion Anfrage: Verwirrung über etwas Gesagtes. _Was? Wie bitte?? (Verwirrung), pardon?_

Wenn man nicht versteht, was jemand gerade gesagt hat — sei es, weil man nicht versteht, worauf er sich bezog, das Wort nicht kennt oder die Grammatik einen verwirrt hat — kann man das Wort oder die Relation, die man nicht verstanden hat, wiederholen und **ki'a** als flehentliche Bitte um Klärung hinzufügen. Das ist sogar besser als _Was?_, weil man genau darauf hinweisen kann, was einen dazu gebracht hat, _Was?_ zu sagen.

Hier ist ein Dialog:

> **— mi nelci le kalci**
> **— ki'a ?**
> _— Ich mag Scheiße._
> _— Wie bitte???_

**Hinweis:** Da **zo** jedes folgende Wort zitiert — jedes Wort — bedeutet **zo ki'a** überhaupt nicht _zo? Was?_, sondern _Das Wort **ki'a**._ Um _zo? Was?_ zu fragen, muss man auf **zo zo ki'a** zurückgreifen.

### Reverse «**mi**» and «**do**» using «**ra'o**»

> **- mi prami do**
> **- go'i ra'o**
> _- Ich liebe dich._
> _- Ich liebe dich auch._

ra'o
: Interjektion: aktualisiert die Bedeutung aus der Sicht des aktuellen Sprechers

Wenn jemand **mi prami do** sagt und du mit **go'i ra'o** antwortest, vertauscht das die Pronomen **mi** und **do**, sodass sie aus deiner Sicht gelten. Somit wird jedes Pronomen neu bewertet.

Vergleiche:

> **- mi prami do**
> **- go'i**
> _- Ich liebe dich._
> _- Du tust es._

Ein einfaches **go'i** lässt **mi** immer noch die Person bezeichnen, die es verwendet hat, und **do** den Zuhörer der Person, die es gesagt hat.
