---
title: krulermorna alphabet
---

**la krulermorna** ist eine alternative Orthographie, die die audio-visuelle Isomorphie der Lojban-Schreibung strenger umsetzt.

1.  Die meisten Buchstaben stammen aus der ursprünglichen lateinbasierten Orthographie.
2.  Gleitlaute **i** und **u** vor Vokalen werden als Konsonanten betrachtet und daher durch unterschiedliche Buchstaben ausgedrückt:
    *   **i** => **ɩ**
    *   **u** => **w**
3.  Diphthonge, die wie andere "reine" Vokale wirken, werden durch unterschiedliche Buchstaben ausgedrückt:
    *   **au** => **ǎ**
    *   **ai** => **ą**
    *   **ei** => **ę**
    *   **oi** => **ǫ**
4.  In anderen Positionen bleiben **i** und **u** wie in der ursprünglichen lateinischen Orthographie erhalten.

## Verwendung

la krulermorna wird von einem Algorithmus in der [la sutysisku](https://la-lojban.github.io/sutysisku/en/ "la sutysisku") App verwendet, um nach Reimen für Lojban-Wörter zu suchen.

Es kann auch helfen, die Lojban-Morphologie zu verstehen.

Abgesehen davon ist es hauptsächlich ein Kunstprojekt.

Die Gesamtzahl der Buchstaben im Lojban-Alphabet wird von 26 in der offiziellen Schreibweise auf 32 in la krulermorna erhöht, was für Personen, die kleine Bildschirmtastaturen wie die auf tragbaren Geräten verwenden, möglicherweise nicht wünschenswert ist.

## la vlipa krulermorna

<figure class="wide">
	<img src="https://github.com/La-Lojban/suho-pixra-pe-la-jbotcan/blob/master/320px-la_vlipa_krulermorna.png?raw=true" alt="la vlipa krulermorna">
	<figcaption>
	.i coi do<br/>.i mi ca jai gau djuno fai do<br/>lo du'u wi mi ca pilno<br/>la krulermorna<br/>lo ka ciska dei<br/>.i ɩa ky. jai cinri
	</figcaption>
</figure>

_la vlipa krulermorna_ ist eine Modifikation von la krulermorna, bei der der Buchstabe **ǎ** durch das Unicode-Zeichen 'LATIN SMALL LETTER AU' ersetzt wird. Letzteres wird in den meisten verwendeten Schriftarten nicht unterstützt und daher wird diese Variante der la krulermorna Orthographie weniger verwendet.

## Interjektionen gemäß krulerske

|            |           |                |            |
| ---------- | --------- | -------------- | ---------- |
| .ǎ         | .ą        | .ę             | .ǫ         |
| Wunsch ... | Ich werde | es sollte sein | Autsch\!   |

<div class="first_col">

|     | a                     | e                         | i                     | o              | u                     |
| --- | --------------------- | ------------------------- | --------------------- | -------------- | --------------------- |
| .   |                       |                           |                       |                |                       |
| ɩ   | Ich glaube            | aye\! einverstanden\!     | oh je\!               | Respekt        | Ich liebe es          |
| w   | Entdeckung            | Was für eine Überraschung | hurra\!               | voila\!        | oh du Arme/r          |
| .a' | Ich höre zu           | Wachsamkeit               | oomph\! (Anstrengung) | Ich hoffe      | hm, ich frage mich... |
| .e' | du darfst             | komm schon, mach es\!     | mach es\!             | bitte, mach es | Ich schlage vor       |
| .i' | ok, ich akzeptiere es | Ich stimme zu\!           | Ich kenne das Gefühl  | dank ihm/ihr   | Vertrautheit          |
| .o' | Stolz                 | Nähe                      | Gefahr\!              | Geduld         | Entspannung           |
| .u' | Gewinn                | was für ein Wunder\!      | hahaha\!              | Mut            | Entschuldigung\!      |

</div>

## Alternative Darstellung

<div class="first_col">

| -    | a           | e            | i                   | o             | u            | ǎ           | ą           | ę             | ǫ                    |
|------|-------------|--------------|---------------------|---------------|--------------|-------------|-------------|---------------|----------------------|
| .    |             |              |                     |               |              | Wunsch      | Absicht     | Verpflichtung | Beschwerde/Schmerz   |
| ɩ    | Glaube      | Zustimmung   | Angst               | Respekt       | Liebe        |             |             |               |                      |
| w    | Entdeckung  | Überraschung | Glück               | Vollendung    | Mitleid      |             |             |               |                      |
| .a'  | aufmerksam  | Wachsamkeit  | Anstrengung         | Hoffnung      | Interesse    |             |             |               |                      |
| .e'  | Erlaubnis   | Kompetenz    | Einschränkung       | Bitte         | Vorschlag    |             |             |               |                      |
| .i'  | Akzeptanz   | Zustimmung   | Zusammengehörigkeit | Wertschätzung | Vertrautheit |             |             |               |                      |
| .o'  | Stolz       | Nähe         | Vorsicht            | Geduld        | Entspannung  |             |             |               |                      |
| .u'  | Gewinn      | Wunder       | Belustigung         | Mut           | Reue         |             |             |               |                      |

</div>
