---
icon: 📕 
title: Complete language
---

<pixra url="/assets/pixra/ralju/cll2.webp" caption="The Complete Lojban Language, die gedruckte Ausgabe von 2016"></pixra>

**CLL inoffiziell** (umgangssprachlich, *UnCLL*, *InCLL*) ist ein von Gleki organisiertes Projekt für regelmäßige experimentelle inoffizielle (nicht unbedingt von der Logical Language Group genehmigte) Versionen des Complete Lojban Language Buches.

*   Senden Sie Ihr Feedback (bemerkte Fehler, Vorschläge, Anregungen) an eine der folgenden Stellen:
    *   [Lojban Reddit Gruppe](https://www.reddit.com/r/lojban/)
    *   [Lojban Facebook Gruppe](https://www.facebook.com/groups/lojban)
    *   Live-Chat: [Telegram Chat](https://t.me/lojban) oder [Discord Chat](https://discord.gg/BVm4EYR)
    *   an <gleki.is.my.name@gmail.com> (Gleki&nbsp;Arxokuna), den Betreuer des UnCLL.


## Veröffentlichungen

### geklojban-1.2.15 Oktober 2022

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.15" kennzeichnet und der Name der Organisation, die es veröffentlicht hat, sich von der LLG unterscheidet; dies dient dazu, zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschieds"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference_prefixed.pdf), das geklojban-1.2.15 mit der UnCLL-Version 1.2.14 (veröffentlicht im Juli 2021) vergleicht. Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell scrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.14 Juli 2021'

* Korrektur von Tippfehlern und stilistischen Problemen in der Chrestomathie (dank an koyshi, gleki)
* [issue #475](https://github.com/lojban/cll/issues/475) **nunkilbra** geändert zu **nunkilca'a** (dank an up4kid)
* [issue #466](https://github.com/lojban/cll/issues/466) verbessertes Tosmabru-Testalgorithmus (dank an vpbroman)
* [issue #473](https://github.com/lojban/cll/issues/473) "Matrix-Transposition" cmavo verwendet jetzt hochgestelltes T für den Transpositionsoperator
* Erwähnungen der Helvetica-Schriftart wurden durch Erwähnungen der Comic-Schriftart ersetzt ("Comic" ist der Name einer mindestens einer Open-Source-Schriftart)
* Weitere kleinere Tippfehler korrigiert (dank an Matt Nazarian, mattfbacon, la-kanba)
* CSS-Änderungen, um HTML-Versionen auf Geräten im Dunkelmodus besser funktionieren zu lassen (dank an NathanHawks)
* Das UnCLL hat jetzt visuelle Unterschiedsdateien von der vorherigen Veröffentlichung und separat für die offizielle Veröffentlichung.

[git source of the UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Verglichen mit Version 'geklojban-1.2.12 November 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Vergleich zwischen der offiziellen CLL v.1.1 Ausgabe (2016) und der UnCLL November 2020 Ausgabe': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* das ["difference" PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference_prefixed.pdf), das geklojban-1.2.15 mit der offiziellen CLL v.1.1 Ausgabe (2016) vergleicht. Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe wurden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell durchscrollen, um die Unterschiede zu finden).

### geklojban-1.2.14 Juli 2021

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.14" markiert und der Name der Organisation, die es veröffentlicht hat, sich von der LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Differenz"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.14 mit der UnCLL, Version 1.2.12 (veröffentlicht im November 2020), vergleicht. Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Differenzversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell durchscrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Differenzdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.11.1 Oktober 2020'

* es ist eine der wichtigsten Verbesserungen. [Lojban Words Glossary](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) hat etwa 200 neue Beispielsätze in Lojban mit ihrer Übersetzung ins Englische erhalten. Da die Anzahl der Kernwörter in Lojban etwa 2000 beträgt, bedeutet dies, dass ~10% dieser Aufgabe erledigt sind
* Fehler in **bo**, **ke'e** in Kapitel 5. 'Skalare Negation von selbri' behoben
* einen falschen Namen einer Audiodatei korrigiert
* weitere Verbesserungen am Index: ZEhA und mehr BAI hinzugefügt
* cmevla besser gemäß der dotside erklären
* fehlende Punkte in cmavo dort hinzufügen, wo nötig
* Interpunktion in der Übersetzung des Gedichts 'Kubla Khan' korrigiert

[git source of the UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Verglichen mit Version 'geklojban-1.2.12 November 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Vergleich zwischen der offiziellen CLL v.1.1 Ausgabe (2016) und der UnCLL November 2020 Ausgabe': git Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.13 Mai 2021

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.13" kennzeichnet und der Name der Organisation, die es veröffentlicht hat, sich von der LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschieds"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.13 mit der UnCLL, Version 1.2.12 (veröffentlicht im November 2020) vergleicht. Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell durchscrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.11.1 Oktober 2020'

* neue schöne Kapitelbilder von [la-ninpre](https://github.com/la-ninpre) hinzugefügt
* eine Übersetzung des Gedichts 'In Xanadu' zur Chrestomathie hinzugefügt
* seltsamen datierten Versuch zur Mengenlehre von [simpson](https://github.com/MostAwesomeDude) behoben
* Definition von **toldi** (_Schmetterling_) korrigiert
* falsche Aussage, die implizierte, dass fuhivla keine rafsi haben, korrigiert
* die Erklärung von **le vi tavla ba klama** weniger irreführend gemacht (Korrektur von [mezohe](https://github.com/mezohe) implementiert)
* Matrizen mit mehr als zwei Dimensionen können entweder mit **pi'a** oder **sa'i** und einer entsprechenden Unterschrift zur Kennzeichnung der Dimension aufgebaut werden... Beschriftungen können alles sein, was **xi** unterstützt, z.B. **pa** oder **mlatu bu**.
* Kapitel 5: Erwähnung der **bo**-Gruppierung im Abschnitt über NAhE wiederhergestellt und **bo** zu einem Beispiel hinzugefügt (Korrektur von [mezohe](https://github.com/mezohe) implementiert)
* Kapitel 7: Aussage über **ra'o** im Beispiel 7.39 korrigiert (Korrektur von [mezohe](https://github.com/mezohe) implementiert)
* Kapitel 2: Diagramm korrigiert (Prädikat -> Prädikation) (Korrektur von [mezohe](https://github.com/mezohe) implementiert)
* fehlende Punkte in cmavo hinzugefügt
* weitere kleinere Tippfehler, Elemente der Indizes, Kompilierungsskripte usw. behoben

[Git-Quelle des UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Verglichen mit Version 'geklojban-1.2.12 November 2020': Git-Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Vergleich zwischen der offiziellen CLL v.1.1 Ausgabe (2016) und der UnCLL November 2020 Ausgabe': Git-Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.12 November 2020

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.12" markiert und der Name der Organisation, die es veröffentlicht hat, sich von der LLG unterscheidet; dies dient dazu, zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschieds"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.12 mit dem 2016 veröffentlichten CLL vergleicht (Veröffentlichung vom 27.08.2016). Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell durchscrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.11.1 Oktober 2020'

* Standardaussprache von {u} im IPA-Kapitel hinzugefügt (von [Vexatos](https://github.com/Vexatos))
* Tiefgestellte Symbole in Glossen werden angemessen behandelt (Fehler bemerkt von [gr-g](https://github.com/gr-g))
* Ein grammatikalischer Fehler in Beispiel 17.36 behoben (Fehler bemerkt von [kotwys](https://github.com/kotwys))
* Das Partikel **ri'u** fehlte in Abschnitt 10.28 (wie von [gr-g](https://github.com/gr-g) bemerkt). Hinzugefügt
* In Beispiel 7.12 wird der erste Platz von **lafti** auf eine Person angewendet. Das Prädikat wird zu **lafmuvgau** geändert (was in den Anmerkungen zur Definition von **lafti** steht)
* Im englischen Text .) zu ). geändert, wo nötig
* Quadratwurzel, Unendlichkeit und goldener Schnitt phi mit tatsächlichen Symbolen anzeigen
* Falsche Übersetzung von **levi rozgu cu sofi'upanova'e xunre** korrigiert
* weitere kleinere Korrekturen

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.12)

#### Quellcodevergleich mit früheren Versionen
* [Verglichen mit Version 'geklojban-1.2.11.1 Oktober 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Verglichen mit Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.12)
* [Verglichen mit der offiziellen CLL v.1.1 Ausgabe (2016)': git Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.12)


### geklojban-1.2.11.1 Oktober 2020

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.11" markiert und der Name der Organisation, die es veröffentlicht hat, sich von der LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschied"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.11 mit dem 2016 veröffentlichten CLL vergleicht (Veröffentlichung vom 27.08.2016). Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell scrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.10 August 2020'

* Audiolinks (Audio von la tcakoi, la .lindar., la .aionys.) wurden zu den HTML-Versionen des Buches "splits by sections" und "split by chapters" hinzugefügt
* mehrere Tippfehler behoben
* Hanzi-Zeichen zu einem chinesischen Beispiel hinzugefügt
* 1.2.11.1 Hotfix-Release: Audiobuttons in HTML-Seiten tatsächlich funktionsfähig gemacht

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.11)

#### Quellcodevergleich mit vorherigen Versionen
* [Verglichen mit Version 'geklojban-1.2.10 August 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [Verglichen mit Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.11)
* [Verglichen mit der offiziellen CLL v.1.1 Ausgabe (2016)': git Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)

### geklojban-1.2.10 August 2020

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.10" markiert und der Name der Organisation, die es veröffentlicht hat, sich von der LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    *   [HTML-Format - das gesamte Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["difference" PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.10 mit dem 2016 veröffentlichten CLL vergleicht (Veröffentlichung vom 27.08.2016). Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell durchscrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.9 Juli 2020'

* Chrestomathie (ausgewählte Texte) Band nach dem letzten Kapitel hinzugefügt
* Punkte werden in Wörtern niemals weggelassen, auch nicht im Lojban-Wörterindex

#### [git Quelle](https://github.com/lojban/cll/compare/geklojban-1.2.10)

#### Quellcode-Vergleich mit früheren Versionen
* [Verglichen mit Version 'geklojban-1.2.9 Juli 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Verglichen mit Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.10)
* [Verglichen mit der offiziellen CLL v.1.1 Ausgabe (2016)': git Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)


### geklojban-1.2.9 Juli 2020

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.9" markiert und der Name der Organisation, die es veröffentlicht hat, sich von der LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    *   [EPUB-Format](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschied"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.9 mit dem 2016 veröffentlichten CLL (Veröffentlichung vom 27.08.2016) vergleicht. Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell durchscrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.8.1 Juni 2020'

* Die HTML-Version hat jetzt Tabellen und Beispiele, die auf schmalen (z.B. mobilen) Bildschirmen horizontal scrollbar sind. Dies macht die HTML-Version mobilerfreundlicher
* EPUB wird wieder generiert (fehlte in Version 1.2.8.1)
* Koreanische und chinesische Symbole werden jetzt mit der Noto CJK-Schriftart angezeigt
* Stellen wie "$x_1$" werden jetzt mit tiefgestellten Zahlen angezeigt
* Ein Beispiel in Abschnitt 16.9 {naku zo'u la djan. klama} entsprach nicht den anderen Beispielen in der Umgebung, daher wurde es durch {naku zo'u mi klama le zarci} ersetzt (ein Fehler, bemerkt von [Corbin Simpson](https://github.com/MostAwesomeDude))
* Eine Definition des Wortes {bu'u} wurde der Liste der anderen grammatikalischen Partikel der Klasse FAhA hinzugefügt

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.9)

#### Quellcodevergleich mit früheren Versionen
* [Verglichen mit Version 'geklojban-1.2.8.1 Juni 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Verglichen mit Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Verglichen mit der offiziellen CLL v.1.1 Ausgabe (2016)': git Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.9)

### geklojban-1.2.8.1 Juni 2020

#### Kompilierte Version
* Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.8.1" markiert und der Name der Organisation, die es veröffentlicht hat, sich von LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    * [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    * [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    * [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschied"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.8.1 mit dem 2016 veröffentlichten CLL vergleicht (Veröffentlichung vom 27.08.2016). Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins`" markiert sind, und Löschungen, die mit rot und dem Präfix "del`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell scrollen, um die Unterschiede zu finden).
* oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    * [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.7 Mai 2020'

* Eine neue "diakritische" Orthographie namens "zbalermorna" hinzugefügt. Es wird klar als inoffiziell erwähnt. Ihre Symbole ("Buchstaben") werden mit einer geeigneten Schriftart angezeigt. Kudos an [Jack Humbert](https://jackhumbert.github.io/zbalermorna/) und ihr Team (la saski'o, la xaspeljba und andere) für die Schriftart und die Überarbeitung der Erklärung der Orthographie.
* Die Indizes wurden überarbeitet (fast alle ihre 4000 Einträge). Zahlreiche Einträge wurden zur Erleichterung der Nutzung geändert oder vom Lojban-Wörterindex in den allgemeinen Index oder umgekehrt verschoben.
* die Regel für die Verwendung des Kommas wurde [zurückgesetzt](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) auf die Version aus dem CLL 1.1
* ein besserer Diff-Algorithmus zur Anzeige von Unterschieden zwischen Versionen (ohne zusätzlichen Ballast)
* Version 1.2.8.1 Hotfix-Release: Probleme mit der Anzeige von zbalermorna-Symbolen im PDF-Dokument behoben

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)

#### Quellcodevergleich mit früheren Versionen
* [Verglichen mit Version 'geklojban-1.2.7 Mai 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Verglichen mit Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Verglichen mit der offiziellen CLL v.1.1 Ausgabe (2016)': git Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)

### geklojban-1.2.7 Mai 2020

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.7" markiert und der Name der Organisation, die es veröffentlicht hat, sich von LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    *   [EPUB-Format](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschieds"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.7 mit dem 2016 veröffentlichten CLL vergleicht (Veröffentlichung vom 27.08.2016). Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell scrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.6 April 2020'

* "The cmavo tu'a is used in forming abstractions, and is explained more fully in Section 11.11." aber es wird in diesem Abschnitt überhaupt nicht erwähnt. Referenz auf Abschnitt 11.10 geändert. Der Fehler wurde von [Robert Baruch](https://github.com/RobertBaruch) bemerkt.
* Alle Verweise auf selma'o wurden vom lojban Wörterindex zum allgemeinen Index im Anhang verschoben.
* Abschnitt 10.18. Der Satz "Unlike -nai contradictory negation, scalar negation of tenses is not limited to PU and FAhA:" widersprach dem folgenden Text des Abschnitts. Ersetzt durch "Ein Beispiel für skalare Negation von FAhA:"

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.7)
#### Quellcodevergleich mit früheren Versionen
* [Verglichen mit Version 'geklojban-1.2.6 April 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Verglichen mit Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Verglichen mit der offiziellen CLL v.1.1 Ausgabe (2016)': git Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)

### geklojban-1.2.6 April 2020

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.6" markiert und der Name der Organisation, die es veröffentlicht hat, sich von LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [EPUB-Format](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["difference" PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.6 mit dem 2016 veröffentlichten CLL vergleicht (Veröffentlichung vom 27.08.2016). Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell scrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur vorherigen Version 'geklojban-1.2.5 März 2020'

* neue hochauflösende Bilder für mehrere Kapitel erstellt von [la ninpre](https://github.com/la-ninpre) (möglicher Urheberrechtsverstoß abgelehnt)
* die Regel 'Kommas sind niemals erforderlich' ist jetzt vorübergehend auf Kommas beschränkt, die Silbentrenner sind
* mehr Links zu verschiedenen selma'o zum Lojban-Wortindex hinzugefügt

#### [git Quelle](https://github.com/lojban/cll/compare/geklojban-1.2.6)
#### Quellcodevergleich mit früheren Versionen
* [Verglichen mit Version 'geklojban-1.2.5 März 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.5...geklojban-1.2.6)
* [Verglichen mit Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.6)

### geklojban-1.2.5 März 2020

#### Kompilierte Version
*   Lesen Sie das endgültige Dokument, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.5" markiert und der Name der Organisation, die es veröffentlicht hat, sich von LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    *   [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    *   [EPUB-Format](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    *   [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    *   [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschied"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.5 mit dem 2016 veröffentlichten CLL (Veröffentlichung vom 27.08.2016) vergleicht. Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell durchscrollen, um die Unterschiede zu finden).
*   oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    *   [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur Version 'geklojban-1.2.3 Januar 2020'
* vorübergehende Entfernung der umstrittenen Verwendung von ni+ce'u
* ein besseres Beispiel für NU JA NU verwenden, Erweiterung von NU JA NU entfernen (was im Falle mehrerer NU JA NU in einem bridi nicht eindeutig sein könnte)
* Hanzi und schöneres Pinyin zu chinesischen Beispielen hinzufügen
* Dotside: Hinzufügen eines initialen Glottalverschlusses zur IPA-Transkription in einem Beispiel
* "FA selma'o" zum lojban-Wortindex hinzufügen
* die Regel 'Kommas sind niemals erforderlich' ist vorübergehend nur auf cmevla beschränkt
* einige Tippfehler wurden behoben
* UTF-Symbole werden so hinzugefügt, wie sie sind (anstatt ihrer Beschreibungen)
* Dotside implementiert
* Konzepte "cmene" und "cmevla" sind jetzt getrennt
* **sumti tcita** wird in **sumtcita** umbenannt
* **mi kucli le jei broda** ist jetzt **mi kucli tu'a le jei broda**
* Wörterbuch mit Beispielen ist jetzt technisch möglich: das Glossar kann jetzt Beispiele unter den Definitionen der Wörter haben (und tut dies für das Wort **coi** als Schaufenster)
* rafsi für **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** wurden gemäß cmavo.txt aus dem Jahr 2002 geändert.
* immense Menge an Tippfehlern und kleineren Fehlern behoben

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.5)
#### Quellcodevergleich mit früheren Versionen
* [Verglichen mit Version 'geklojban-1.2.4 Februar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Verglichen mit Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)


### geklojban-1.2.4 Februar 2020

#### Kompilierte Version
* das endgültige Dokument lesen, das für den Druck und die Veröffentlichung verwendet werden soll. Beachten Sie, dass die Titelseite das Dokument ausdrücklich als "geklojban-1.2.4" markiert und der Name der Organisation, die es veröffentlicht hat, sich von LLG unterscheidet; dies wird getan, um zu betonen, dass es sich nicht um eine LLG-Veröffentlichung handelt:
    * [PDF-Format](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    * [EPUB-Format](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    * [HTML-Format, eine Seite ist ein Abschnitt des Buches](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    * [HTML-Format - das ganze Buch auf einer sehr langen Seite](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* oder lesen Sie das sogenannte ["Unterschied"-PDF-Dokument](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference_prefixed.pdf), das geklojban-1.2.4 mit CLL vergleicht, das 2016 veröffentlicht wurde (Veröffentlichung vom 27.08.2016). Das Dokument hat Einfügungen, die mit grün und dem Präfix "ins\`" markiert sind, und Löschungen, die mit rot und dem Präfix "del\`" markiert sind. Präfixe werden hinzugefügt, damit Sie mit Cmd+F oder Ctrl+F schnell die Unterschiede im PDF-Dokument finden können. Es gibt [eine alternative Unterschiedsversion ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (aber dann müssen Sie das Dokument manuell durchscrollen, um die Unterschiede zu finden).
* oder lesen Sie das Unterschiedsdokument stattdessen im HTML-Format:
    * [mit Präfixen](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [ohne Präfixe](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Kurze Liste der Änderungen im Vergleich zur Version 'geklojban-1.2.3 Januar 2020'
* einige Tippfehler wurden behoben
* UTF-Symbole wurden hinzugefügt, wie sie sind (anstatt ihrer Beschreibungen)

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.4)

#### Quellcode-Vergleich mit früheren Versionen
* [Verglichen mit der Version 'geklojban-1.2.3 Januar 2020': git Unterschied](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Verglichen mit der offiziellen CLL v.1.1 Ausgabe (2016)': git Unterschied](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)

### geklojban-1.2.3 Januar 2020

#### Kurze Liste der Änderungen

*   Dotside implementiert
*   "cmene" und "cmevla" Konzepte sind jetzt getrennt
*   **sumti tcita** wurde umbenannt in **sumtcita**
*   **mi kucli le jei broda** ist jetzt **mi kucli tu'a le jei broda**
*   Wörterbuch mit Beispielen ist jetzt technisch möglich: das Glossar kann jetzt Beispiele unter den Definitionen von Wörtern haben (und tut dies für das Wort **coi** als Schaufenster)
*   rafsi für **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** wurden gemäß cmavo.txt aus dem Jahr 2002 geändert.
*   immense Menge an Tippfehlern und kleineren Fehlern behoben

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.3)
