---
title: Sind Verben in Lojban kaputt?
---

<div class="lojbo simple_blockquotes"></div>

## Frage

Es scheint, dass das Lernen der Definitionen von Verben in Lojban, wie zum Beispiel

> *$x_1$ läuft auf der Oberfläche $x_1$ mit Gliedmaßen $x_1$ mit Gangart $x_1$*

herausfordernd sein könnte, weil fast jedes Verb seine eigene spezifische Platzstruktur hat. Gibt es eine Möglichkeit, dies weniger geistigen Aufwand zu erfordern? Warum ist Lojban so gestaltet?

## Antwort

Englisch funktioniert in einem pragmatischen Sinne ähnlich. Es hat Verben mit ihrer impliziten Platzstruktur. Der Hauptunterschied ist, dass Lojban-Wörterbücher die Platzstruktur explizit angeben, während die meisten englischen Wörterbücher dies nicht tun. Der Grund für dieses System ist, dass es noch belastender und manchmal sogar undurchführbar wäre, für jeden Platz eine eigene Präposition zu haben.

Eine begrenzte Anzahl von Präpositionen würde die Sprache sehr subjektiv und nicht universell machen. Zum Beispiel sagen wir im Englischen

> I depend on you.

aber auf Russisch übersetzt es sich wörtlich zu

> I depend from you.

während es auf Portugiesisch und Spanisch wörtlich übersetzt wird zu

> I depend of you.

Bestimmte Präpositionen, die mit spezifischen Verben kombiniert werden, könnten ungewöhnliche Bedeutungen erzeugen, was zu noch mehr Zufälligkeit führen würde als das aktuelle System mit $x_1$, $x_2$, usw.

Es ist wichtig zu beachten, dass die meisten Lojban-Verben nur bis zu drei Plätze haben. Nur etwa 30 Kernverben (lo gismu) haben fünf Plätze. Außerdem muss man nicht die Platzstruktur jedes Kernverbs kennen, um fließend Lojban zu sprechen. Zum Beispiel, ist es entscheidend, die Platzstruktur der 'trigonometrischen Sinusfunktion' zu kennen, wenn man über Essenszubereitung spricht?

Es stimmt, dass _I give you a present_ keine Präpositionen erfordert, während die Platzstrukturen anderer Verben dies tun. Es ist jedoch nicht mehr Auswendiglernen erforderlich. Englisch erfordert das Lernen von Metaphern. Warum ist es _I give TO you_ und _I talk TO you_, wenn die Prozesse völlig unterschiedlich sind?

Betrachten Sie auch die folgenden Übersetzungen:

> [English] *I think of you*

> [Russian] *Ya dumayu o tebe* (Ich denke über dich)

> [Spanish] *Yo pienso en ti* (Ich denke in/zu dir)

Einige Lojban-Ortsstrukturen sind weniger eindeutig als andere, genau wie im Englischen. Zum Beispiel, warum heißt es "Dieser Film gefällt mir" statt "Ich mag diesen Film"?

Lojban-Verben, wie englische Verben, können in Rahmen mit identischen Ortsstrukturen gruppiert werden, z.B.

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=mlatu&bangu=en&versio=masno">mlatu</a> - $x_1$ ist eine Katze der Spezies $x_1$

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=gerku&bangu=en&versio=masno">gerku</a> - $x_1$ ist ein Hund der Spezies $x_1$

## Ortsstruktur ist leicht zu lernen, aber...

Oft ist die Ortsstruktur leicht zu lernen. Allerdings stellt das Konzept der Bewegung eine zufällige Reihe von Ortsstrukturen dar. Betrachten Sie die folgenden Beispiele:

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a> - $x_1$ (Objekt) bewegt sich zum Ziel/Empfänger $x_1$ [weg] vom Ursprung $x_1$ über den Pfad/Route $x_1$.

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> - $x_1$ läuft auf der Oberfläche $x_1$ mit Gliedmaßen $x_1$ mit Gangart $x_1$.

Warum nicht eine Ortsstruktur für alle?

## Antwort

<a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a>, <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> und <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=cadzu&bangu=en&versio=masno">cadzu</a> beschreiben einen ähnlichen Prozess aus sehr unterschiedlichen Perspektiven. In <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> sind der Ursprung und das Ziel nicht wichtig; der Schwerpunkt liegt auf der Form. Es ist nicht "laufen zu von" wie im Englischen. Bitte verwechseln Sie nicht englische Glossen mit dem tatsächlichen Prozess, den Lojban-Verben beschreiben. In einem <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a>-Zustand zu sein bedeutet, eine bestimmte Gangart zu haben, während man eine Oberfläche mit seinen Gliedmaßen berührt und dies schnell tut.

Eine Person, die ein Laufband benutzt, hat keine "zu" oder "von" Punkte, sondern läuft einfach, während sie am selben Ort bleibt. Dies ist ein gutes Beispiel für einen bajra-Zustand, ohne in einem klama-Zustand zu sein.

Zusammenfassend lässt sich sagen, dass Lojban kein relexiertes Englisch ist, obwohl der allgemeine Gebrauch und das Lojban-Englisch-Wörterbuch dies nahelegen könnten.

Das Problem liegt mehr in der Mehrdeutigkeit des Englischen als in der Lojban-Sprache selbst.

Schließlich kann man lo tanru, wie bajra klama (laufen-kommen), verwenden, um sowohl das Laufen als auch das Kommen an einen bestimmten Ort auszudrücken.
