<a id="section-vocative-syntax"></a>6.11. <a id="c6s11"></a>The syntax of vocative phrases
------------------------------------------------------------------------------------------

<a id="id-1.7.13.2.1" class="indexterm"></a>Vocative phrases are not sumti, but are explained in this chapter because their syntax is very similar to that of sumti. Grammatically, a vocative phrase is one of the so-called “free modifiers” of Lojban, along with subscripts, parentheses, and various other constructs explained in [Chapter 19](../chapter-structure). They can be placed after many, but not all, constructions of the grammar: in general, after any elidable terminator (which, however, must not then be elided!), at the beginnings and ends of sentences, and in many other places.

<a id="id-1.7.13.3.1" class="indexterm"></a>The purpose of a vocative phrase is to indicate who is being addressed, or to indicate to that person that he or she ought to be listening. A vocative phrase begins with a cmavo of selma'o COI or DOI, all of which are explained in more detail in [Section 13.14](../section-vocative-scales). Sometimes that is all there is to the phrase:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qLE3"></a>

**Example 6.62. <a id="c6e11d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>coi</td></tr><tr class="gloss"><td>[greetings]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Hello.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qLeB"></a>

**Example 6.63. <a id="c6e11d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>je'e</td></tr><tr class="gloss"><td>[acknowledgement]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Uh-huh.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Roger!</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.13.6.1" class="indexterm"></a>In these cases, the person being addressed is obvious from the context. However, a vocative word (more precisely, one or more cmavo of COI, possibly followed by _<a id="id-1.7.13.6.2.1" class="indexterm"></a>[_doi_](../go01#valsi-doi)_ , or else just _<a id="id-1.7.13.6.3.1" class="indexterm"></a>[_doi_](../go01#valsi-doi)_ by itself) can be followed by one of several kinds of phrases, all of which are intended to indicate the addressee. The most common case is a cmevla (name-word):

<div class="interlinear-gloss-example example">
<a id="example-random-id-Bega"></a>

**Example 6.64. <a id="c6e11d3"></a><a id="id-1.7.13.7.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>coi</td><td>.djan.</td></tr><tr class="gloss"><td>[greetings]</td><td>John.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Hello, John.</p></td></tr></tbody></table>

</div>  

Using _<a id="id-1.7.13.8.1.1" class="indexterm"></a>[_doi_](../go01#valsi-doi)_ instead is like just saying someone's name to attract his or her attention:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ULHn"></a>

**Example 6.65. <a id="c6e11d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>.djan.</td></tr><tr class="gloss"><td>O</td><td>John.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John!</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.13.10.1" class="indexterm"></a><a id="id-1.7.13.10.2" class="indexterm"></a><a id="id-1.7.13.10.3" class="indexterm"></a>In place of a cmevla, a description may appear, lacking its descriptor, which is understood to be _<a id="id-1.7.13.10.4.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-V530"></a>

**Example 6.66. <a id="c6e11d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>coi</td><td>xunre</td><td>pastu</td><td>nixli</td></tr><tr class="gloss"><td>Hello,</td><td>(red-type-of</td><td>dress)-type-of</td><td>girl.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Hello, girl with the red dress!</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.13.12.1" class="indexterm"></a><a id="id-1.7.13.12.2" class="indexterm"></a>The listener need not really be a _<a id="id-1.7.13.12.3.1" class="indexterm"></a>xunre pastu nixli_ , as long as she understands herself correctly from the description. (Actually, only a bare selbri can appear; explicit quantifiers are forbidden in this form of vocative, so the implicit quantifiers _<a id="id-1.7.13.12.4.1" class="indexterm"></a>su'o le ro_ are in effect.)

Finally, a complete sumti may be used, the most general case.

<div class="interlinear-gloss-example example">
<a id="example-random-id-tBTa"></a>

**Example 6.67. <a id="c6e11d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>co'o</td><td>la</td><td>.bab.</td><td>.e</td><td>la</td><td>.noras.</td></tr><tr class="gloss"><td>[partings]</td><td>that-named</td><td>Bob</td><td>and</td><td>that-named</td><td>Nora.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Goodbye, Bob and Nora.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.13.15.1" class="indexterm"></a>[Example 6.66](../section-vocative-syntax#example-random-id-V530) is thus the same as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3Qac"></a>

**Example 6.68. <a id="c6e11d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>coi</td><td>le</td><td>xunre</td><td>pastu</td><td>nixli</td></tr><tr class="gloss"><td>Hello,</td><td>the-one-described-as</td><td>(red-type-of</td><td>dress)-type-of</td><td>girl!</td></tr></tbody></table>

</div>  

and [Example 6.65](../section-vocative-syntax#example-random-id-ULHn) is the same as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-bx2C"></a>

**Example 6.69. <a id="c6e11d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>la</td><td>.djan.</td></tr><tr class="gloss"><td>O</td><td>that-named</td><td>John!</td></tr></tbody></table>

</div>  

<a id="id-1.7.13.19.1" class="indexterm"></a><a id="id-1.7.13.19.2" class="indexterm"></a>Finally, the elidable terminator for vocative phrases is _<a id="id-1.7.13.19.3.1" class="indexterm"></a>[_do'u_](../go01#valsi-dohu)_ (of selma'o DOhU), which is rarely needed except when a simple vocative word is being placed somewhere within a bridi. It may also be required when a vocative is placed between a sumti and its relative clause, or when there are a sequence of so-called “free modifiers” (vocatives, subscripts, utterance ordinals – see [Chapter 18](../chapter-mekso) – metalinguistic comments – see [Section 19.12](../section-parentheses) – or reciprocals – see [Chapter 19](../chapter-structure)) which must be properly separated.

<a id="id-1.7.13.20.1" class="indexterm"></a>The meaning of a vocative phrase that is within a sentence is not affected by its position in the sentence: thus [Example 6.70](../section-vocative-syntax#example-random-id-qLFi) and [Example 6.71](../section-vocative-syntax#example-random-id-qLGC) mean the same thing:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qLFi"></a>

**Example 6.70. <a id="c6e11d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>.djan.</td><td>ko</td><td>klama</td><td>mi</td></tr><tr class="gloss"><td>O</td><td>John</td><td>you&nbsp;[imperative]</td><td>go-to</td><td>me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John, come to me!</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qLGC"></a>

**Example 6.71. <a id="c6e11d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ko</td><td>klama</td><td>mi</td><td>doi</td><td>.djan.</td></tr><tr class="gloss"><td>You&nbsp;[imperative]</td><td>go-to</td><td>me</td><td>O</td><td>John.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Come to me, John!</p></td></tr></tbody></table>

</div>  

As usual for this chapter, the full syntax of vocative phrases has not been explained: relative clauses, discussed in [Chapter 8](../chapter-relative-clauses) , make for more possibilities.