<a id="section-vocative-scales"></a>13.14. <a id="c13s14"></a>Vocative scales
-----------------------------------------------------------------------------

<a id="id-1.14.16.2.1" class="indexterm"></a><a id="id-1.14.16.2.2" class="indexterm"></a><a id="id-1.14.16.2.3" class="indexterm"></a><a id="id-1.14.16.2.4" class="indexterm"></a><a id="id-1.14.16.2.5" class="indexterm"></a>“Vocatives” are words used to address someone directly; they precede and mark a name used in direct address, just as _<a id="id-1.14.16.2.7.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ (and the other members of selma'o LA) mark a name used to refer to someone. The vocatives actually are indicators – in fact, discursives – but the need to tie them to names and other descriptions of listeners requires them to be separated from selma'o UI. But like the cmavo of UI, the members of selma'o COI can be “negated” with _<a id="id-1.14.16.2.9.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ to get the opposite part of the scale.

<a id="id-1.14.16.3.1" class="indexterm"></a><a id="id-1.14.16.3.2" class="indexterm"></a>Because of the need for redundancy in noisy environments, the Lojban design does not compress the vocatives into a minimum number of scales. Doing so would make a non-redundant _<a id="id-1.14.16.3.3.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ too often vital to interpretation of a protocol signal, as explained later in this section.

<a id="id-1.14.16.4.1" class="indexterm"></a>The grammar of vocatives is explained in [Section 6.11](../section-vocative-syntax) ; but in brief, a vocative may be followed by a cmevla (without _<a id="id-1.14.16.4.3.1" class="indexterm"></a>[_la_](../go01#valsi-la)_), a description (without _<a id="id-1.14.16.4.4.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ or its relatives), a complete sumti, or nothing at all (if the addressee is obvious from the context). There is an elidable terminator, _<a id="id-1.14.16.4.5.1" class="indexterm"></a>[_do'u_](../go01#valsi-dohu)_ (of selma'o DOhU) which is almost never required unless no cmevla (or other indication of the addressee) follows the vocative.

<a id="id-1.14.16.5.1" class="indexterm"></a><a id="id-1.14.16.5.2" class="indexterm"></a>Using any vocative except _<a id="id-1.14.16.5.3.1" class="indexterm"></a>[_mi'e_](../go01#valsi-mihe)_ (explained below) implicitly defines the meaning of the pro-sumti _<a id="id-1.14.16.5.4.1" class="indexterm"></a>[_do_](../go01#valsi-do)_ , as the whole point of vocatives is to specify the listener, or at any rate the desired listener – even if the desired listener isn't listening! We will use the terms “speaker” and “listener” for clarity, although in written Lojban the appropriate terms would be “writer” and “reader”.

<a id="id-1.14.16.6.1" class="indexterm"></a>In the following list of vocatives, the translations include the symbol X. This represents the name (or identifying description, or whatever) of the listener.

The cmavo _<a id="id-1.14.16.7.1.1" class="indexterm"></a>[_doi_](../go01#valsi-doi)_ is the general-purpose vocative. It is not considered a scale, and _<a id="id-1.14.16.7.2.1" class="indexterm"></a>doinai_ is not grammatical. In general, _<a id="id-1.14.16.7.3.1" class="indexterm"></a>[_doi_](../go01#valsi-doi)_ needs no translation in English (we just use names by themselves without any preceding word, although in poetic styles we sometimes say “Oh X” , which is equivalent to _<a id="id-1.14.16.7.5.1" class="indexterm"></a>[_doi_](../go01#valsi-doi)_). One may attach an attitudinal to _<a id="id-1.14.16.7.6.1" class="indexterm"></a>[_doi_](../go01#valsi-doi)_ to express various English vocatives. For example, _<a id="id-1.14.16.7.7.1" class="indexterm"></a>doi .io_ means “Sir/Madam!” , whereas _<a id="id-1.14.16.7.9.1" class="indexterm"></a>doi .ionai_ means “You there!”.

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">coi</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">greetings</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><span class="quote">“<span class="quote">Hello, X</span>”</span> ; <span class="quote">“<span class="quote">Greetings, X</span>”</span> ; indicates a greeting to the listener.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">co'o</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">partings</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><span class="quote">“<span class="quote">Good-bye, X</span>”</span> ; indicates parting from immediate company by either the speaker or the listener. <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.11.2.1.1.2.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-coicoho"><em class="glossterm">coico'o</em></a></em></span> means <span class="quote">“<span class="quote">greeting in passing</span>”</span>.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ju'i</p></td><td class="gismu"><p class="gismu">[jundi]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">attention</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">at ease</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">ignore me/us</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><span class="quote">“<span class="quote">Attention/Lo/Hark/Behold/Hey!/Listen, X</span>”</span> ; indicates an important communication that the listener should listen to.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">nu'e</p></td><td class="gismu"><p class="gismu">[nupre]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">promise</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">release promise</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">non-promise</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><span class="quote">“<span class="quote">I promise, X</span>”</span> ; indicates a promise to the listener. In some contexts, <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.15.2.1.1.2.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nuhe"><em class="glossterm">nu'e</em></a></em></span> may be prefixed to an oath or other formal declaration.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ta'a</p></td><td class="gismu"><p class="gismu">[tavla]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">interruption</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><span class="quote">“<span class="quote">I interrupt, X</span>”</span> , <span class="quote">“<span class="quote">I desire the floor, X</span>”</span> ; a vocative expression to (possibly) interrupt and claim the floor to make a statement or expression. This can be used for both rude and polite interruptions, although rude interruptions will probably tend not to use a vocative at all. An appropriate response to an interruption might be <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.17.2.1.1.3.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-rehi"><em class="glossterm">re'i</em></a></em></span> (or <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.17.2.1.1.4.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-rehinai"><em class="glossterm">re'inai</em></a></em></span> to ignore the interruption).</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pe'u</p></td><td class="gismu"><p class="gismu">[cpedu]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">request</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><a id="id-1.14.16.19.2.1.1.1" class="indexterm"></a><a id="id-1.14.16.19.2.1.1.2" class="indexterm"></a><span class="quote">“<span class="quote">Please, X</span>”</span> ; indicates a request to the listener. It is a formal, non-attitudinal, equivalent of <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.19.2.1.1.4.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-eho"><em class="glossterm">.e'o</em></a></em></span> with a specific recipient being addressed. On the other hand, <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.19.2.1.1.5.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-eho"><em class="glossterm">.e'o</em></a></em></span> may be used when there is no specific listener, but merely a <span class="quote">“<span class="quote">sense of petition floating in the air</span>”</span> , as it were.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ki'e</p></td><td class="gismu"><p class="gismu">[ckire]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">appreciation; gratitude</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">disappreciation; ingratitude</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><a id="id-1.14.16.21.2.1.1.1" class="indexterm"></a><a id="id-1.14.16.21.2.1.1.2" class="indexterm"></a><a id="id-1.14.16.21.2.1.1.3" class="indexterm"></a><span class="quote">“<span class="quote">Thank you, X</span>”</span> ; indicates appreciation or gratitude toward the listener. The usual response is <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.21.2.1.1.5.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jehe"><em class="glossterm">je'e</em></a></em></span> , but <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.21.2.1.1.6.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-fihi"><em class="glossterm">fi'i</em></a></em></span> is appropriate on rare occasions: see the explanation of <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.21.2.1.1.7.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-fihi"><em class="glossterm">fi'i</em></a></em></span>.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">fi'i</p></td><td class="gismu"><p class="gismu">[friti]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">welcome; offering</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">unwelcome; inhospitality</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><a id="id-1.14.16.23.2.1.1.1" class="indexterm"></a><a id="id-1.14.16.23.2.1.1.2" class="indexterm"></a><a id="id-1.14.16.23.2.1.1.3" class="indexterm"></a><span class="quote">“<span class="quote">At your service, X</span>”</span> ; <span class="quote">“<span class="quote">Make yourself at home, X</span>”</span> ; offers hospitality (possibly in response to thanks, but not necessarily) to the listener. Note that <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.23.2.1.1.6.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-fihi"><em class="glossterm">fi'i</em></a></em></span> is <span class="emphasis"><em>not</em></span> the equivalent of American English <span class="quote">“<span class="quote">You're welcome</span>”</span> as a mechanical response to <span class="quote">“<span class="quote">Thank you</span>”</span> ; that is <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.23.2.1.1.10.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jehe"><em class="glossterm">je'e</em></a></em></span> , as noted below.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">be'e</p></td><td class="gismu"><p class="gismu">[benji]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">request to send</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><a id="id-1.14.16.25.2.1.1.1" class="indexterm"></a><span class="quote">“<span class="quote">Request to send to X</span>”</span> ; indicates that the speaker wishes to express something, and wishes to ensure that the listener is listening. In a telephone conversation, can be used to request the desired conversant(s). A more colloquial equivalent is <span class="quote">“<span class="quote">Hello? Can I speak to X?</span>”</span>.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">re'i</p></td><td class="gismu"><p class="gismu">[bredi]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">ready to receive</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">not ready</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><span class="quote">“<span class="quote">Ready to receive, X</span>”</span> ; indicates that the speaker is attentive and awaiting communication from the listener. It can be used instead of <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.27.2.1.1.2.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mihe"><em class="glossterm">mi'e</em></a></em></span> to respond when called to the telephone. The negative form can be used to prevent the listener from continuing to talk when the speaker is unable to pay attention: it can be translated <span class="quote">“<span class="quote">Hold on!</span>”</span> or <span class="quote">“<span class="quote">Just a minute</span>”</span>.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">mu'o</p></td><td class="gismu"><p class="gismu">[mulno]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">completion of utterance</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">more to follow</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><span class="quote">“<span class="quote">Over, X</span>”</span> ; indicates that the speaker has completed the current utterance and is ready to hear a response from the listener. The negative form signals that the pause or non-linguistic sound which follows does not represent the end of the current utterance: more colloquially, <span class="quote">“<span class="quote">I'm not done talking!</span>”</span></p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">je'e</p></td><td class="gismu"><p class="gismu">[jimpe]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">successful receipt</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">unsuccessful receipt</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><a id="id-1.14.16.31.2.1.1.1" class="indexterm"></a><a id="id-1.14.16.31.2.1.1.2" class="indexterm"></a><span class="quote">“<span class="quote">Roger, X!</span>”</span> , <span class="quote">“<span class="quote">I understand</span>”</span> ; acknowledges the successful receipt of a communication from the listener. The negative form indicates failure to receive correctly, and is usually followed by <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.31.2.1.1.5.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-keho"><em class="glossterm">ke'o</em></a></em></span>. The colloquial English equivalents of <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.31.2.1.1.6.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jehe"><em class="glossterm">je'e</em></a></em></span> and <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.31.2.1.1.7.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jehenai"><em class="glossterm">je'enai</em></a></em></span> are the grunt typically written <span class="quote">“<span class="quote">uh-huh</span>”</span> and <span class="quote">“<span class="quote">What?/Excuse me?</span>”</span>. <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.31.2.1.1.10.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jehe"><em class="glossterm">je'e</em></a></em></span> is also used to mean <span class="quote">“<span class="quote">You're welcome</span>”</span> when that is a response to <span class="quote">“<span class="quote">Thank you</span>”</span>.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">vi'o</p></td><td class="gismu"><p class="gismu"></p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">will comply</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">will not comply</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><a id="id-1.14.16.33.2.1.1.1" class="indexterm"></a><a id="id-1.14.16.33.2.1.1.2" class="indexterm"></a><span class="quote">“<span class="quote">Wilco, X</span>”</span> , <span class="quote">“<span class="quote">I understand and will comply</span>”</span>. Similar to <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.33.2.1.1.5.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jehe"><em class="glossterm">je'e</em></a></em></span> but signals an intention (similar to <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.33.2.1.1.6.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ai"><em class="glossterm">.ai</em></a></em></span>) to comply with the other speaker's request. This cmavo is the main way of saying <span class="quote">“<span class="quote">OK</span>”</span> in Lojban, in the usual sense of <span class="quote">“<span class="quote">Agreed!</span>”</span> , although <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.33.2.1.1.9.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ie"><em class="glossterm">.ie</em></a></em></span> carries some of the same meaning. The negative form indicates that the message was received but that you will not comply: a very colloquial version is <span class="quote">“<span class="quote">No way!</span>”</span>.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ke'o</p></td><td class="gismu"><p class="gismu">[krefu]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">please repeat</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">no repeat needed</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><a id="id-1.14.16.35.2.1.1.1" class="indexterm"></a><a id="id-1.14.16.35.2.1.1.2" class="indexterm"></a><span class="quote">“<span class="quote">What did you say, X?</span>”</span> ; a request for repetition or clarification due to unsuccessful receipt or understanding. This is the vocative equivalent of <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.35.2.1.1.4.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kiha"><em class="glossterm">ki'a</em></a></em></span> , and is related to <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.35.2.1.1.5.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jehenai"><em class="glossterm">je'enai</em></a></em></span>. The negative form may be rendered <span class="quote">“<span class="quote">Okay, already; I get the point!</span>”</span></p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">fe'o</p></td><td class="gismu"><p class="gismu">[fanmo]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">end of communication</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">not done</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><span class="quote">“<span class="quote">Over and out, X</span>”</span> ; indicates completion of statement(s) and communication directed at the identified person(s). Used to terminate a letter if a signature is not required because the sender has already been identified (as in memos). The negative form means <span class="quote">“<span class="quote">Wait, hold it, we're not done!</span>”</span> and differs from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.37.2.1.1.3.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-muhonai"><em class="glossterm">mu'onai</em></a></em></span> in that it means more exchanges are to follow, rather than that the current exchange is incomplete. <a id="id-1.14.16.37.2.1.1.4" class="indexterm"></a><a id="id-1.14.16.37.2.1.1.5" class="indexterm"></a>Do not confuse <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.37.2.1.1.6.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-feho"><em class="glossterm">fe'o</em></a></em></span> with <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.37.2.1.1.7.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-faho"><em class="glossterm">fa'o</em></a></em></span> (selma'o FAhO) which is a mechanical, extra-grammatical signal that a text is complete. One may say <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.37.2.1.1.8.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-feho"><em class="glossterm">fe'o</em></a></em></span> to one participant of a multi-way conversation and then go on speaking to the others.</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">mi'e</p></td><td class="gismu"><p class="gismu">[cmavo: mi]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">self-identification</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">non-identification</p></td></tr></tbody></table>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="long"><p class="long"><a id="id-1.14.16.39.2.1.1.1" class="indexterm"></a><a id="id-1.14.16.39.2.1.1.2" class="indexterm"></a><a id="id-1.14.16.39.2.1.1.3" class="indexterm"></a><span class="quote">“<span class="quote">And I am X</span>”</span> ; a generalized self-vocative. Although grammatically just like the other members of selma'o COI, <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.39.2.1.1.5.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mihe"><em class="glossterm">mi'e</em></a></em></span> is quite different semantically. In particular, rather than specifying the listener, the person whose name (or description) follows <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.39.2.1.1.6.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mihe"><em class="glossterm">mi'e</em></a></em></span> is taken to be the speaker. Therefore, using <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.39.2.1.1.7.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mihe"><em class="glossterm">mi'e</em></a></em></span> specifies the meaning of the pro-sumti <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.16.39.2.1.1.8.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mi"><em class="glossterm">mi</em></a></em></span>. It can be used to introduce oneself, to close letters, or to identify oneself on the telephone.</p></td></tr></tbody></table>

<a id="id-1.14.16.40.1" class="indexterm"></a><a id="id-1.14.16.40.2" class="indexterm"></a><a id="id-1.14.16.40.3" class="indexterm"></a>This cmavo is often combined with other members of COI: _<a id="id-1.14.16.40.4.1" class="indexterm"></a>fe'omi'e_ would be an appropriate closing at the end of a letter; _<a id="id-1.14.16.40.5.1" class="indexterm"></a>re'imi'e_ would be a self-vocative used in delayed responses, as when called to the phone, or possibly in a roll-call. As long as the _<a id="id-1.14.16.40.6.1" class="indexterm"></a>[_mi'e_](../go01#valsi-mihe)_ comes last, the following name is that of the speaker; if another COI cmavo is last, the following name is that of the listener. It is not possible to name both speaker and listener in a single vocative expression, but this fact is of no importance, because wherever one vocative expression is grammatical, any number of consecutive ones may appear.

<a id="id-1.14.16.41.1" class="indexterm"></a>The negative form denies an identity which someone else has attributed to you; _<a id="id-1.14.16.41.2.1" class="indexterm"></a>mi'enai .djan._ means that you are saying you are not John.

<a id="id-1.14.16.42.1" class="indexterm"></a><a id="id-1.14.16.42.2" class="indexterm"></a><a id="id-1.14.16.42.3" class="indexterm"></a>Many of the vocatives have been listed with translations which are drawn from radio use: “roger” , “wilco” , “over and out”. This form of translation does not mean that Lojban is a language of CB enthusiasts, but rather that in most natural languages these forms are so well handled by the context that only in specific domains (like speaking on the radio) do they need special words. In Lojban, dependence on the context can be dangerous, as speaker and listener may not share the right context, and so the vocatives provide a formal protocol for use when it is appropriate. Other appropriate contexts include computer communications and parliamentary procedure: in the latter context, the protocol question _<a id="id-1.14.16.42.7.1" class="indexterm"></a>ta'apei_ would mean “Will the speaker yield?”