<a id="section-upper-case"></a>17.3. <a id="c17s3"></a>Upper and lower cases
----------------------------------------------------------------------------

<a id="id-1.18.5.2.1" class="indexterm"></a><a id="id-1.18.5.2.2" class="indexterm"></a><a id="id-1.18.5.2.3" class="indexterm"></a><a id="id-1.18.5.2.4" class="indexterm"></a><a id="id-1.18.5.2.5" class="indexterm"></a><a id="id-1.18.5.2.6" class="indexterm"></a><a id="id-1.18.5.2.7" class="indexterm"></a>Lojban doesn't use lower-case (small) letters and upper-case (capital) letters in the same way that English does; sentences do not begin with an upper-case letter, nor do names. However, upper-case letters are used in Lojban to mark irregular stress within cmevla, thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Fam2"></a>

**Example 17.6. <a id="c17e3d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.iVAN.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the name <span class="quote">“<span class="quote">Ivan</span>”</span> in Russian/Slavic pronunciation.</p></td></tr></tbody></table>

</div>  

<a id="id-1.18.5.4.1" class="indexterm"></a><a id="id-1.18.5.4.2" class="indexterm"></a><a id="id-1.18.5.4.3" class="indexterm"></a>It would require far too many cmavo to assign one for each upper-case and one for each lower-case lerfu, so instead we have two special cmavo _<a id="id-1.18.5.4.4.1" class="indexterm"></a>[_ga'e_](../go01#valsi-gahe)_ and _<a id="id-1.18.5.4.5.1" class="indexterm"></a>[_to'a_](../go01#valsi-toha)_ representing upper case and lower case respectively. They belong to the same selma'o as the basic lerfu words, namely BY, and they may be freely interspersed with them.

<a id="id-1.18.5.5.1" class="indexterm"></a>The effect of _<a id="id-1.18.5.5.2.1" class="indexterm"></a>[_ga'e_](../go01#valsi-gahe)_ is to change the interpretation of all lerfu words following it to be the upper-case version of the lerfu. An occurrence of _<a id="id-1.18.5.5.3.1" class="indexterm"></a>[_to'a_](../go01#valsi-toha)_ causes the interpretation to revert to lower case. Thus, _<a id="id-1.18.5.5.4.1" class="indexterm"></a>ga'e .abu_ means not “a” but “A” , and Ivan's name may be spelled out thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-q6pw"></a>

**Example 17.7. <a id="c17e3d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ibu</td><td>ga'e</td><td>vy.</td><td>.abu</td><td>ny.</td><td>to'a</td></tr><tr class="gloss"><td>i</td><td>[upper]</td><td>V</td><td>A</td><td>N</td><td>[lower]</td></tr></tbody></table>

</div>  

The cmavo and compound cmavo of this type will be called “shift words”.

<a id="id-1.18.5.8.1" class="indexterm"></a>How long does a shift word last? Theoretically, until the next shift word that contradicts it or until the end of text. In practice, it is common to presume that a shift word is only in effect until the next word other than a lerfu word is found.

<a id="id-1.18.5.9.1" class="indexterm"></a><a id="id-1.18.5.9.2" class="indexterm"></a>It is often convenient to shift just a single letter to upper case. The cmavo _<a id="id-1.18.5.9.3.1" class="indexterm"></a>[_tau_](../go01#valsi-tau)_ , of selma'o LAU, is useful for the purpose. A LAU cmavo must always be immediately followed by a BY cmavo or its equivalent: the combination is grammatically equivalent to a single BY. (See [Section 17.14](../section-lerfu-cmavo-summary) for details.)

<a id="id-1.18.5.10.1" class="indexterm"></a>A likely use of _<a id="id-1.18.5.10.2.1" class="indexterm"></a>[_tau_](../go01#valsi-tau)_ is in the internationally standardized symbols for the chemical elements. Each element is represented using either a single upper-case lerfu or one upper-case lerfu followed by one lower-case lerfu:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qhS7"></a>

**Example 17.8. <a id="c17e3d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tau</td><td>sy.</td></tr><tr class="gloss"><td>[single-shift]</td><td>S</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">S (chemical symbol for sulfur)</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhsD"></a>

**Example 17.9. <a id="c17e3d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tau</td><td>sy.</td><td>.ibu</td></tr><tr class="gloss"><td>[single-shift]</td><td>S</td><td>i</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Si (chemical symbol for silicon)</p></td></tr></tbody></table>

</div>  

<a id="id-1.18.5.13.1" class="indexterm"></a>If a shift to upper-case is in effect when _<a id="id-1.18.5.13.2.1" class="indexterm"></a>[_tau_](../go01#valsi-tau)_ appears, it shifts the next lerfu word only to lower case, reversing its usual effect.