<a id="section-universal-claims"></a>16.3. <a id="c16s3"></a>Universal claims
-----------------------------------------------------------------------------

What happens if we substitute “everything” for “something” in [Example 16.7](../section-da-and-zohu#example-random-id-Mxj3) ? We get:

<div class="example">
<a id="example-random-id-UwYG"></a>

**Example 16.15. <a id="c16e3d1"></a><a id="id-1.17.5.3.1.2" class="indexterm"></a>** 

Everything sees me.

</div>  

<a id="id-1.17.5.4.1" class="indexterm"></a>Of course, this example is false, because there are many things which do not see the speaker. It is not easy to find simple truthful examples of so-called universal claims (those which are about everything), so bear with us for a while. (Indeed, some Lojbanists tend to avoid universal claims even in other languages, since they are so rarely true in Lojban.)

The Lojban translation of [Example 16.15](../section-universal-claims#example-random-id-UwYG) is

<div class="interlinear-gloss-example example">
<a id="example-random-id-nraD"></a>

**Example 16.16. <a id="c16e3d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>da</td><td>zo'u</td><td>da</td><td>viska</td><td>mi</td></tr><tr class="gloss"><td>For-every</td><td>X</td><td>:</td><td>X</td><td>sees</td><td>me.</td></tr></tbody></table>

</div>  

<a id="id-1.17.5.7.1" class="indexterm"></a>When the variable cmavo _<a id="id-1.17.5.7.2.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ is preceded by _<a id="id-1.17.5.7.3.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ , the combination means “For every X” rather than “There is an X”. Superficially, these English formulations look totally unrelated: [Section 16.6](../section-quantified-variables) will bring them within a common viewpoint. For the moment, accept the use of _<a id="id-1.17.5.7.7.1" class="indexterm"></a>ro da_ for “everything” on faith.

Here is a universal claim with two variables:

<div class="interlinear-gloss-example example">
<a id="example-random-id-jSrU"></a>

**Example 16.17. <a id="c16e3d3"></a><a id="id-1.17.5.9.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>da</td><td>ro</td><td>de</td><td>zo'u</td><td>da</td><td>prami</td><td>de</td></tr><tr class="gloss"><td>For-every</td><td>X,</td><td>for-every</td><td>Y</td><td>:</td><td>X</td><td>loves</td><td>Y.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Everything loves everything.</p></td></tr></tbody></table>

</div>  

Again, X and Y can represent the same thing, so [Example 16.17](../section-universal-claims#example-random-id-jSrU) does not mean “Everything loves everything else.” Furthermore, because the claim is universal, it is about every thing, not merely every person, so we cannot use “everyone” or “everybody” in the translation.

<a id="id-1.17.5.11.1" class="indexterm"></a><a id="id-1.17.5.11.2" class="indexterm"></a><a id="id-1.17.5.11.3" class="indexterm"></a>Note that _<a id="id-1.17.5.11.4.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ appears before both _<a id="id-1.17.5.11.5.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ and _<a id="id-1.17.5.11.6.1" class="indexterm"></a>[_de_](../go01#valsi-de)_. If _<a id="id-1.17.5.11.7.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ is omitted before either variable, we get a mixed claim, partly existential like those of [Section 16.2](../section-da-and-zohu) , partly universal.

<div class="interlinear-gloss-example example">
<a id="example-random-id-qHKm"></a>

**Example 16.18. <a id="c16e3d4"></a><a id="id-1.17.5.12.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>da</td><td>de</td><td>zo'u</td><td>da</td><td>viska</td><td>de</td></tr><tr class="gloss"><td>For-every</td><td>X,</td><td>there-is-a-Y</td><td>:</td><td>X</td><td>sees</td><td>Y.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Everything sees something.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qHKo"></a>

**Example 16.19. <a id="c16e3d5"></a><a id="id-1.17.5.13.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>ro</td><td>de</td><td>zo'u</td><td>da</td><td>viska</td><td>de</td></tr><tr class="gloss"><td>There-is-an-X</td><td>such-that-for-every</td><td>Y</td><td>:</td><td>X</td><td>sees</td><td>Y.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Something sees everything.</p></td></tr></tbody></table>

</div>  

<a id="id-1.17.5.14.1" class="indexterm"></a>[Example 16.18](../section-universal-claims#example-random-id-qHKm) and [Example 16.19](../section-universal-claims#example-random-id-qHKo) mean completely different things. [Example 16.18](../section-universal-claims#example-random-id-qHKm) says that for everything, there is something which it sees, not necessarily the same thing seen for every seer. [Example 16.19](../section-universal-claims#example-random-id-qHKo) , on the other hand, says that there is a particular thing which can see everything that there is (including itself). Both of these are fairly silly, but they are different kinds of silliness.

There are various possible translations of universal claims in English: sometimes we use “anybody/anything” rather than “everybody/everything”. Often it makes no difference which of these is used: when it does make a difference, it is a rather subtle one which is explained in [Section 16.8](../section-any).